/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.cobol.CobolLineReader;
import org.openrewrite.cobol.CobolParsingException;
import org.openrewrite.cobol.PreprocessCopyVisitor;
import org.openrewrite.cobol.PreprocessReplaceVisitor;
import org.openrewrite.cobol.internal.CobolDialect;
import org.openrewrite.cobol.internal.CobolPreprocessorParserVisitor;
import org.openrewrite.cobol.internal.grammar.CobolPreprocessorLexer;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class CobolPreprocessorParser
implements Parser {
    private static final List<String> COBOL_FILE_EXTENSIONS = Collections.singletonList(".cbl");
    private final CobolDialect cobolDialect;
    private List<SourceFile> copybooks;

    public CobolPreprocessorParser(CobolDialect cobolDialect, List<SourceFile> copybooks) {
        this.cobolDialect = cobolDialect;
        this.copybooks = copybooks;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(sourceFiles).map(sourceFile -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a COBOL file").tag("file.type", "COBOL");
            Timer.Sample sample = Timer.start();
            try {
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                String sourceStr = is.readFully();
                String prepareSource = new CobolLineReader().readLines(sourceStr, this.cobolDialect);
                org.openrewrite.cobol.internal.grammar.CobolPreprocessorParser parser = new org.openrewrite.cobol.internal.grammar.CobolPreprocessorParser((TokenStream)new CommonTokenStream((TokenSource)new CobolPreprocessorLexer((CharStream)CharStreams.fromString((String)prepareSource))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                CobolPreprocessorParserVisitor parserVisitor = new CobolPreprocessorParserVisitor(sourceFile.getRelativePath(relativeTo), sourceFile.getFileAttributes(), sourceStr, is.getCharset(), is.isCharsetBomMarked(), this.cobolDialect);
                CobolPreprocessor.CompilationUnit preprocessedCU = parserVisitor.visitCompilationUnit(parser.compilationUnit());
                PreprocessCopyVisitor copyPhase = new PreprocessCopyVisitor(preprocessedCU.getPreprocessorStatements(), this.copybooks);
                preprocessedCU = (CobolPreprocessor.CompilationUnit)copyPhase.visit(preprocessedCU, new InMemoryExecutionContext());
                assert (preprocessedCU != null);
                PreprocessReplaceVisitor replacePhase = new PreprocessReplaceVisitor(preprocessedCU.getReplacements());
                preprocessedCU = (CobolPreprocessor.CompilationUnit)replacePhase.visit(preprocessedCU, new InMemoryExecutionContext());
                assert (preprocessedCU != null);
                sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                parsingListener.parsed(sourceFile, (SourceFile)preprocessedCU);
                return preprocessedCU;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)sourceFile, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
    }

    public void setCopybooks(List<SourceFile> copybooks) {
        this.copybooks = copybooks;
    }

    public boolean accept(Path path) {
        String s = path.toString().toLowerCase();
        for (String COBOL_FILE_EXTENSION : COBOL_FILE_EXTENSIONS) {
            if (!s.endsWith(COBOL_FILE_EXTENSION)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.CBL");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        private CobolDialect cobolDialect = CobolDialect.ibmAnsi85();
        private List<SourceFile> copybooks = Collections.emptyList();

        public Builder() {
            super(Cobol.CompilationUnit.class);
        }

        public CobolPreprocessorParser build() {
            return new CobolPreprocessorParser(this.cobolDialect, this.copybooks);
        }

        public Builder cobolDialect(CobolDialect cobolDialect) {
            this.cobolDialect = cobolDialect;
            return this;
        }

        public Builder copybooks(List<SourceFile> copybooks) {
            this.copybooks = copybooks;
            return this;
        }

        public String getDslName() {
            return "preprocessCobol";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new CobolParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), (Throwable)e));
        }
    }
}

