/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolVisitor;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.ListUtils;

public class CobolPreprocessorVisitor<P>
extends TreeVisitor<CobolPreprocessor, P> {
    protected CobolVisitor<P> cobolVisitor;

    public CobolPreprocessorVisitor() {
        this.cobolVisitor = new CobolVisitor();
    }

    public CobolPreprocessorVisitor(CobolVisitor<P> cobolVisitor) {
        this.cobolVisitor = cobolVisitor;
    }

    public CobolPreprocessor visitCharData(CobolPreprocessor.CharData charData, P p) {
        CobolPreprocessor.CharData c = charData;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CHAR_DATA_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withCobols(ListUtils.map(c.getCobols(), it -> (CobolPreprocessor.CharDataLine)this.visit((Tree)it, p)));
        return c;
    }

    public CobolPreprocessor visitCharDataLine(CobolPreprocessor.CharDataLine charDataLine, P p) {
        CobolPreprocessor.CharDataLine c = charDataLine;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CHAR_DATA_LINE_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withWords(ListUtils.map(c.getWords(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        return c;
    }

    public CobolPreprocessor visitCharDataSql(CobolPreprocessor.CharDataSql charDataSql, P p) {
        CobolPreprocessor.CharDataSql c = charDataSql;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.CHAR_DATA_SQL_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withCobols(ListUtils.map(c.getCobols(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        return c;
    }

    public CobolPreprocessor visitCommentEntry(CobolPreprocessor.CommentEntry commentEntry, P p) {
        CobolPreprocessor.CommentEntry c = commentEntry;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMMENT_ENTRY_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withComments(ListUtils.map(c.getComments(), it -> (CobolPreprocessor.Word)this.visit((Tree)it, p)));
        return c;
    }

    public CobolPreprocessor visitCompilationUnit(CobolPreprocessor.CompilationUnit compilationUnit, P p) {
        CobolPreprocessor.CompilationUnit c = compilationUnit;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.PREPROCESSOR_COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withCobols(ListUtils.map(c.getCobols(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        c = c.withEof((CobolPreprocessor.Word)this.visit(c.getEof(), p));
        return c;
    }

    public CobolPreprocessor visitCompilerOption(CobolPreprocessor.CompilerOption compilerOption, P p) {
        CobolPreprocessor.CompilerOption c = compilerOption;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILER_OPTION_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withCobols(ListUtils.map(c.getCobols(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        return c;
    }

    public CobolPreprocessor visitCompilerOptions(CobolPreprocessor.CompilerOptions compilerOptions, P p) {
        CobolPreprocessor.CompilerOptions c = compilerOptions;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILER_OPTIONS_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withCobols(ListUtils.map(c.getCobols(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        return c;
    }

    public CobolPreprocessor visitCompilerXOpts(CobolPreprocessor.CompilerXOpts compilerXOpts, P p) {
        CobolPreprocessor.CompilerXOpts c = compilerXOpts;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILER_XOPTS_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withWord((CobolPreprocessor.Word)this.visit(c.getWord(), p));
        c = c.withLeftParen((CobolPreprocessor.Word)this.visit(c.getLeftParen(), p));
        c = c.withCompilerOptions(ListUtils.map(c.getCompilerOptions(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        c = c.withRightParen((CobolPreprocessor.Word)this.visit(c.getRightParen(), p));
        return c;
    }

    public CobolPreprocessor visitCopybook(CobolPreprocessor.Copybook copybook, P p) {
        CobolPreprocessor.Copybook c = copybook;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COPY_BOOK_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withLst(ListUtils.map(c.getLst(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        c = c.withEof((CobolPreprocessor.Word)this.visit(c.getEof(), p));
        return c;
    }

    public CobolPreprocessor visitCopySource(CobolPreprocessor.CopySource copySource, P p) {
        CobolPreprocessor.CopySource c = copySource;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COPY_SOURCE_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withName((CobolPreprocessor.Word)this.visit(c.getName(), p));
        c = c.withWord((CobolPreprocessor.Word)this.visit(c.getWord(), p));
        c = c.withCopyLibrary((CobolPreprocessor.Word)this.visit(c.getCopyLibrary(), p));
        return c;
    }

    public CobolPreprocessor visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, P p) {
        CobolPreprocessor.CopyStatement c = copyStatement;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COPY_STATEMENT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withWord((CobolPreprocessor.Word)this.visit(c.getWord(), p));
        c = c.withCopySource((CobolPreprocessor.CopySource)this.visit(c.getCopySource(), p));
        c = c.withCobols(ListUtils.map(c.getCobols(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        c = c.withDot((CobolPreprocessor.Word)this.visit(c.getDot(), p));
        c = c.withCopybook((CobolPreprocessor.Copybook)this.visit(c.getCopybook(), p));
        return c;
    }

    public CobolPreprocessor visitDirectoryPhrase(CobolPreprocessor.DirectoryPhrase directoryPhrase, P p) {
        CobolPreprocessor.DirectoryPhrase d = directoryPhrase;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DIRECTORY_PHRASE_PREFIX, p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withWord((CobolPreprocessor.Word)this.visit(d.getWord(), p));
        d = d.withName((CobolPreprocessor.Word)this.visit(d.getName(), p));
        return d;
    }

    public CobolPreprocessor visitEjectStatement(CobolPreprocessor.EjectStatement ejectStatement, P p) {
        CobolPreprocessor.EjectStatement e = ejectStatement;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EJECT_STATEMENT_PREFIX, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withWord((CobolPreprocessor.Word)this.visit(e.getWord(), p));
        e = e.withDot((CobolPreprocessor.Word)this.visit(e.getDot(), p));
        return e;
    }

    public CobolPreprocessor visitExecStatement(CobolPreprocessor.ExecStatement execStatement, P p) {
        CobolPreprocessor.ExecStatement e = execStatement;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EXEC_STATEMENT_PREFIX, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withWords(ListUtils.map(e.getWords(), it -> (CobolPreprocessor.Word)this.visit((Tree)it, p)));
        e = e.withCobol((CobolPreprocessor)this.visit(e.getCobol(), p));
        e = e.withEndExec((CobolPreprocessor.Word)this.visit(e.getEndExec(), p));
        e = e.withDot((CobolPreprocessor.Word)this.visit(e.getDot(), p));
        return e;
    }

    public CobolPreprocessor visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, P p) {
        CobolPreprocessor.ExecSqlIncludeStatement e = execSqlIncludeStatement;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EXEC_SQL_INCLUDE_STATEMENT_PREFIX, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withWords(ListUtils.map(e.getWords(), it -> (CobolPreprocessor.Word)this.visit((Tree)it, p)));
        e = e.withCopySource((CobolPreprocessor.Word)this.visit(e.getCopySource(), p));
        e = e.withEndExec((CobolPreprocessor.Word)this.visit(e.getEndExec(), p));
        e = e.withDot((CobolPreprocessor.Word)this.visit(e.getDot(), p));
        e = e.withCopybook((CobolPreprocessor.Copybook)this.visit(e.getCopybook(), p));
        return e;
    }

    public CobolPreprocessor visitFamilyPhrase(CobolPreprocessor.FamilyPhrase familyPhrase, P p) {
        CobolPreprocessor.FamilyPhrase f = familyPhrase;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), Space.Location.FAMILY_PHRASE_PREFIX, p));
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), p));
        f = f.withWord((CobolPreprocessor.Word)this.visit(f.getWord(), p));
        f = f.withName((CobolPreprocessor.Word)this.visit(f.getName(), p));
        return f;
    }

    public CobolPreprocessor visitPseudoText(CobolPreprocessor.PseudoText pseudoText, P p) {
        CobolPreprocessor.PseudoText pp = pseudoText;
        pp = pp.withPrefix(this.visitSpace(pp.getPrefix(), Space.Location.PSEUDO_TEXT_PREFIX, p));
        pp = pp.withMarkers(this.visitMarkers(pp.getMarkers(), p));
        pp = pp.withDoubleEqualOpen((CobolPreprocessor.Word)this.visit(pp.getDoubleEqualOpen(), p));
        pp = pp.withCharData((CobolPreprocessor.CharData)this.visit(pp.getCharData(), p));
        pp = pp.withDoubleEqualClose((CobolPreprocessor.Word)this.visit(pp.getDoubleEqualClose(), p));
        return pp;
    }

    public CobolPreprocessor visitReplaceArea(CobolPreprocessor.ReplaceArea replaceArea, P p) {
        CobolPreprocessor.ReplaceArea r = replaceArea;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.REPLACE_AREA_PREFIX, p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withReplaceByStatement((CobolPreprocessor.ReplaceByStatement)this.visit(r.getReplaceByStatement(), p));
        r = r.withCobols(ListUtils.map(r.getCobols(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        r = r.withReplaceOffStatement((CobolPreprocessor.ReplaceOffStatement)this.visit(r.getReplaceOffStatement(), p));
        return r;
    }

    public CobolPreprocessor visitReplaceByStatement(CobolPreprocessor.ReplaceByStatement replaceByStatement, P p) {
        CobolPreprocessor.ReplaceByStatement r = replaceByStatement;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.REPLACE_BY_STATEMENT_PREFIX, p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withWord((CobolPreprocessor.Word)this.visit(r.getWord(), p));
        r = r.withClauses(ListUtils.map(r.getClauses(), it -> (CobolPreprocessor.ReplaceClause)this.visit((Tree)it, p)));
        r = r.withDot((CobolPreprocessor.Word)this.visit(r.getDot(), p));
        return r;
    }

    public CobolPreprocessor visitReplaceClause(CobolPreprocessor.ReplaceClause replaceClause, P p) {
        CobolPreprocessor.ReplaceClause r = replaceClause;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.REPLACE_CLAUSE_PREFIX, p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withReplaceable((CobolPreprocessor)this.visit(r.getReplaceable(), p));
        r = r.withBy((CobolPreprocessor.Word)this.visit(r.getBy(), p));
        r = r.withReplacement((CobolPreprocessor)this.visit(r.getReplacement(), p));
        r = r.withSubscript(ListUtils.map(r.getSubscript(), it -> (CobolPreprocessor)this.visit((Tree)it, p)));
        r = r.withDirectoryPhrases(ListUtils.map(r.getDirectoryPhrases(), it -> (CobolPreprocessor.DirectoryPhrase)this.visit((Tree)it, p)));
        r = r.withFamilyPhrase((CobolPreprocessor.FamilyPhrase)this.visit(r.getFamilyPhrase(), p));
        return r;
    }

    public CobolPreprocessor visitReplaceOffStatement(CobolPreprocessor.ReplaceOffStatement replaceOffStatement, P p) {
        CobolPreprocessor.ReplaceOffStatement r = replaceOffStatement;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.REPLACE_OFF_STATEMENT_PREFIX, p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withWords(ListUtils.map(r.getWords(), it -> (CobolPreprocessor.Word)this.visit((Tree)it, p)));
        r = r.withDot((CobolPreprocessor.Word)this.visit(r.getDot(), p));
        return r;
    }

    public CobolPreprocessor visitReplacingPhrase(CobolPreprocessor.ReplacingPhrase replacingPhrase, P p) {
        CobolPreprocessor.ReplacingPhrase r = replacingPhrase;
        r = r.withPrefix(this.visitSpace(r.getPrefix(), Space.Location.REPLACING_PHRASE_PREFIX, p));
        r = r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withWord((CobolPreprocessor.Word)this.visit(r.getWord(), p));
        r = r.withClauses(ListUtils.map(r.getClauses(), it -> (CobolPreprocessor.ReplaceClause)this.visit((Tree)it, p)));
        return r;
    }

    public CobolPreprocessor visitSkipStatement(CobolPreprocessor.SkipStatement skipStatement, P p) {
        CobolPreprocessor.SkipStatement s = skipStatement;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SKIP_STATEMENT_PREFIX, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withWord((CobolPreprocessor.Word)this.visit(s.getWord(), p));
        s = s.withDot((CobolPreprocessor.Word)this.visit(s.getDot(), p));
        return s;
    }

    public CobolPreprocessor visitTitleStatement(CobolPreprocessor.TitleStatement titleStatement, P p) {
        CobolPreprocessor.TitleStatement t = titleStatement;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.TITLE_STATEMENT_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.withFirst((CobolPreprocessor.Word)this.visit(t.getFirst(), p));
        t = t.withSecond((CobolPreprocessor.Word)this.visit(t.getSecond(), p));
        t = t.withDot((CobolPreprocessor.Word)this.visit(t.getDot(), p));
        return t;
    }

    public CobolPreprocessor visitWord(CobolPreprocessor.Word word, P p) {
        CobolPreprocessor.Word w = word;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), Space.Location.WORD_PREFIX, p));
        w = w.withMarkers(this.visitMarkers(w.getMarkers(), p));
        w = w.withCobolWord((Cobol.Word)this.cobolVisitor.visitWord(w.getCobolWord(), p));
        return w;
    }

    public Space visitSpace(Space space, Space.Location location, P p) {
        return space;
    }
}

