/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolLineReader;
import org.openrewrite.cobol.internal.CobolDialect;
import org.openrewrite.cobol.internal.CobolPreprocessorParserVisitor;
import org.openrewrite.cobol.internal.grammar.CobolPreprocessorLexer;
import org.openrewrite.cobol.internal.grammar.CobolPreprocessorParser;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingExecutionContextView;

public class CopybookParser
implements Parser {
    public static final List<String> COPYBOOK_FILE_EXTENSIONS = Collections.singletonList(".cpy");
    private final CobolDialect cobolDialect;

    public CopybookParser(CobolDialect cobolDialect) {
        this.cobolDialect = cobolDialect;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).map(input -> this.parseInput((Parser.Input)input, relativeTo, ctx));
    }

    private SourceFile parseInput(Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx) {
        try {
            EncodingDetectingInputStream is = input.getSource(ctx);
            String sourceStr = is.readFully();
            PlainText plainText = new PlainText(Tree.randomId(), input.getPath(), Markers.EMPTY, is.getCharset().name(), is.isCharsetBomMarked(), null, null, sourceStr, Collections.emptyList());
            String prepareSource = new CobolLineReader().readLines(sourceStr, this.cobolDialect);
            CobolPreprocessorParser parser = new CobolPreprocessorParser((TokenStream)new CommonTokenStream((TokenSource)new CobolPreprocessorLexer((CharStream)CharStreams.fromString((String)prepareSource))));
            CobolPreprocessorParserVisitor parserVisitor = new CobolPreprocessorParserVisitor(input.getRelativePath(relativeTo), input.getFileAttributes(), sourceStr, is.getCharset(), is.isCharsetBomMarked(), this.cobolDialect);
            CobolPreprocessor.CompilationUnit preprocessedCU = parserVisitor.visitCompilationUnit(parser.compilationUnit());
            List<CobolPreprocessor> parsedCopySource = preprocessedCU.getCobols();
            CobolPreprocessor.Copybook copybook = new CobolPreprocessor.Copybook(Tree.randomId(), Space.EMPTY, Markers.EMPTY, plainText.getSourcePath(), null, plainText.getCharsetName(), plainText.isCharsetBomMarked(), null, parsedCopySource, preprocessedCU.getEof());
            ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener().parsed(input, (SourceFile)preprocessedCU);
            return copybook;
        }
        catch (Throwable t) {
            ctx.getOnError().accept(t);
            return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
        }
    }

    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        String s = path.toString().toLowerCase();
        for (String COBOL_FILE_EXTENSION : COPYBOOK_FILE_EXTENSIONS) {
            if (!s.endsWith(COBOL_FILE_EXTENSION)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.CPY");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        private CobolDialect cobolDialect = CobolDialect.ibmAnsi85();

        public Builder() {
            super(Cobol.CompilationUnit.class);
        }

        public CopybookParser build() {
            return new CopybookParser(this.cobolDialect);
        }

        public Builder setCobolDialect(CobolDialect cobolDialect) {
            this.cobolDialect = cobolDialect;
            return this;
        }

        public String getDslName() {
            return "copybook";
        }
    }
}

