/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolPreprocessorIsoVisitor;
import org.openrewrite.cobol.marker.CopiedStatement;
import org.openrewrite.cobol.marker.MissingCopybook;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.tree.ParseError;

public final class PreprocessCopyVisitor<P>
extends CobolPreprocessorIsoVisitor<P> {
    private final Map<String, SourceFile> copybooks = new HashMap<String, SourceFile>();
    private final Map<String, CobolPreprocessor> preprocessorMap;
    private final Stack<String> copyStack = new Stack();

    public PreprocessCopyVisitor(Map<String, CobolPreprocessor> preprocessorMap, List<SourceFile> copybooks) {
        this.preprocessorMap = preprocessorMap;
        copybooks.forEach(it -> {
            String fileName = it.getSourcePath().getFileName().toString();
            this.copybooks.putIfAbsent(fileName.substring(0, fileName.indexOf(".")), (SourceFile)it);
        });
    }

    @Override
    public CobolPreprocessor.CopyStatement visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, P p) {
        this.copyStack.push(copyStatement.getCopySource().getName().getCobolWord().getWord());
        CobolPreprocessor.CopyStatement c = (CobolPreprocessor.CopyStatement)this.resolve(copyStatement, copyStatement.getCopySource().getName().getCobolWord().getWord(), p);
        c = (CobolPreprocessor.CopyStatement)this.inCopiedStatement(c);
        this.preprocessorMap.put(c.getId().toString(), c);
        return c;
    }

    @Override
    public CobolPreprocessor.ExecSqlIncludeStatement visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, P p) {
        this.copyStack.push(execSqlIncludeStatement.getCopySource().getCobolWord().getWord());
        CobolPreprocessor.ExecSqlIncludeStatement e = (CobolPreprocessor.ExecSqlIncludeStatement)this.resolve(execSqlIncludeStatement, execSqlIncludeStatement.getCopySource().getCobolWord().getWord(), p);
        e = (CobolPreprocessor.ExecSqlIncludeStatement)this.inCopiedStatement(e);
        this.preprocessorMap.put(e.getId().toString(), e);
        return e;
    }

    private CobolPreprocessor inCopiedStatement(CobolPreprocessor c) {
        if (this.copyStack.size() > 1) {
            this.copyStack.pop();
            c = (CobolPreprocessor)c.withMarkers(c.getMarkers().addIfAbsent((Marker)new CopiedStatement(Tree.randomId(), this.copyStack.peek())));
        } else {
            this.copyStack.pop();
        }
        return c;
    }

    private CobolPreprocessor resolve(CobolPreprocessor c, String copybookName, P p) {
        if (this.copybooks.containsKey(copybookName)) {
            SourceFile sf = this.copybooks.get(copybookName);
            if (sf instanceof ParseError) {
                c = (CobolPreprocessor)c.withMarkers(c.getMarkers().addIfAbsent((Marker)new MissingCopybook(Tree.randomId(), MissingCopybook.Status.PARSE_ERROR)));
                return c;
            }
            CobolPreprocessor.Copybook cb = (CobolPreprocessor.Copybook)sf;
            cb = cb.withLst(ListUtils.map(cb.getLst(), l -> (CobolPreprocessor)this.visit((Tree)l, p)));
            c = c instanceof CobolPreprocessor.CopyStatement ? ((CobolPreprocessor.CopyStatement)c).withCopybook(cb) : ((CobolPreprocessor.ExecSqlIncludeStatement)c).withCopybook(cb);
        } else {
            c = (CobolPreprocessor)c.withMarkers(c.getMarkers().addIfAbsent((Marker)new MissingCopybook(Tree.randomId(), MissingCopybook.Status.MISSING)));
        }
        return c;
    }

    @Override
    public CobolPreprocessor.CompilerOption visitCompilerOption(CobolPreprocessor.CompilerOption compilerOption, P p) {
        this.preprocessorMap.put(compilerOption.getId().toString(), compilerOption);
        return compilerOption;
    }

    @Override
    public CobolPreprocessor.CompilerOptions visitCompilerOptions(CobolPreprocessor.CompilerOptions compilerOptions, P p) {
        this.preprocessorMap.put(compilerOptions.getId().toString(), compilerOptions);
        return compilerOptions;
    }

    @Override
    public CobolPreprocessor.EjectStatement visitEjectStatement(CobolPreprocessor.EjectStatement ejectStatement, P p) {
        this.preprocessorMap.put(ejectStatement.getId().toString(), ejectStatement);
        return ejectStatement;
    }

    @Override
    public CobolPreprocessor.ExecStatement visitExecStatement(CobolPreprocessor.ExecStatement execStatement, P p) {
        this.preprocessorMap.put(execStatement.getId().toString(), execStatement);
        return execStatement;
    }

    @Override
    public CobolPreprocessor.ReplaceByStatement visitReplaceByStatement(CobolPreprocessor.ReplaceByStatement replaceByStatement, P p) {
        this.preprocessorMap.put(replaceByStatement.getId().toString(), replaceByStatement);
        return replaceByStatement;
    }

    @Override
    public CobolPreprocessor.ReplaceOffStatement visitReplaceOffStatement(CobolPreprocessor.ReplaceOffStatement replaceOffStatement, P p) {
        this.preprocessorMap.put(replaceOffStatement.getId().toString(), replaceOffStatement);
        return replaceOffStatement;
    }

    @Override
    public CobolPreprocessor.SkipStatement visitSkipStatement(CobolPreprocessor.SkipStatement skipStatement, P p) {
        this.preprocessorMap.put(skipStatement.getId().toString(), skipStatement);
        return skipStatement;
    }

    @Override
    public CobolPreprocessor.TitleStatement visitTitleStatement(CobolPreprocessor.TitleStatement titleStatement, P p) {
        this.preprocessorMap.put(titleStatement.getId().toString(), titleStatement);
        return titleStatement;
    }

    public Map<String, SourceFile> getCopybooks() {
        return this.copybooks;
    }

    public Map<String, CobolPreprocessor> getPreprocessorMap() {
        return this.preprocessorMap;
    }

    public Stack<String> getCopyStack() {
        return this.copyStack;
    }

    public String toString() {
        return "PreprocessCopyVisitor(copybooks=" + this.getCopybooks() + ", preprocessorMap=" + this.getPreprocessorMap() + ", copyStack=" + this.getCopyStack() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreprocessCopyVisitor)) {
            return false;
        }
        PreprocessCopyVisitor other = (PreprocessCopyVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, SourceFile> this$copybooks = this.getCopybooks();
        Map<String, SourceFile> other$copybooks = other.getCopybooks();
        if (this$copybooks == null ? other$copybooks != null : !((Object)this$copybooks).equals(other$copybooks)) {
            return false;
        }
        Map<String, CobolPreprocessor> this$preprocessorMap = this.getPreprocessorMap();
        Map<String, CobolPreprocessor> other$preprocessorMap = other.getPreprocessorMap();
        if (this$preprocessorMap == null ? other$preprocessorMap != null : !((Object)this$preprocessorMap).equals(other$preprocessorMap)) {
            return false;
        }
        Stack<String> this$copyStack = this.getCopyStack();
        Stack<String> other$copyStack = other.getCopyStack();
        return !(this$copyStack == null ? other$copyStack != null : !((Object)this$copyStack).equals(other$copyStack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreprocessCopyVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, SourceFile> $copybooks = this.getCopybooks();
        result = result * 59 + ($copybooks == null ? 43 : ((Object)$copybooks).hashCode());
        Map<String, CobolPreprocessor> $preprocessorMap = this.getPreprocessorMap();
        result = result * 59 + ($preprocessorMap == null ? 43 : ((Object)$preprocessorMap).hashCode());
        Stack<String> $copyStack = this.getCopyStack();
        result = result * 59 + ($copyStack == null ? 43 : ((Object)$copyStack).hashCode());
        return result;
    }
}

