/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolPreprocessorIsoVisitor;
import org.openrewrite.cobol.CobolPrinterUtils;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.Markers;

public final class PreprocessReplaceVisitor<P>
extends CobolPreprocessorIsoVisitor<P> {
    private final Map<String, Replacement> replaceMap;

    public PreprocessReplaceVisitor(Map<String, Replacement> replaceMap) {
        this.replaceMap = replaceMap;
    }

    @Override
    public CobolPreprocessor.CopyStatement visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, P p) {
        CobolPreprocessor c = super.visitCopyStatement(copyStatement, (Object)p);
        if (((CobolPreprocessor.CopyStatement)c).getCopybook() != null) {
            ArrayList<CobolPreprocessor.ReplacingPhrase> phrases = new ArrayList<CobolPreprocessor.ReplacingPhrase>();
            for (CobolPreprocessor is : ((CobolPreprocessor.CopyStatement)c).getCobols()) {
                if (!(is instanceof CobolPreprocessor.ReplacingPhrase)) continue;
                CobolPreprocessor.ReplacingPhrase replacingPhrase = (CobolPreprocessor.ReplacingPhrase)is;
                phrases.add(replacingPhrase);
            }
            if (!phrases.isEmpty()) {
                LinkedHashMap replacements = new LinkedHashMap();
                phrases.forEach(it -> replacements.putAll(this.getReplacings((CobolPreprocessor.ReplacingPhrase)it)));
                for (Map.Entry entry : replacements.entrySet()) {
                    ArrayList replaceWords = new ArrayList();
                    FindReplaceableAreasVisitor findReplaceableAreasVisitor = new FindReplaceableAreasVisitor((List)entry.getKey());
                    c = ((CobolPreprocessor.CopyStatement)c).withCopybook(((CobolPreprocessor.CopyStatement)c).getCopybook().withLst(ListUtils.map(((CobolPreprocessor.CopyStatement)c).getCopybook().getLst(), preprocessor -> {
                        findReplaceableAreasVisitor.visit((Tree)preprocessor, replaceWords);
                        if (!replaceWords.isEmpty()) {
                            ReplaceVisitor replaceVisitor = new ReplaceVisitor(replaceWords, (List)entry.getValue(), this.replaceMap);
                            replaceWords.clear();
                            return (CobolPreprocessor)replaceVisitor.visit((Tree)preprocessor, new InMemoryExecutionContext(), this.getCursor());
                        }
                        return preprocessor;
                    })));
                }
            }
        }
        return c;
    }

    @Override
    public CobolPreprocessor.ReplaceArea visitReplaceArea(CobolPreprocessor.ReplaceArea replaceArea, P p) {
        CobolPreprocessor r = super.visitReplaceArea(replaceArea, (Object)p);
        Map<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>> replacements = this.getReplacements(replaceArea.getReplaceByStatement());
        for (Map.Entry<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>> entry : replacements.entrySet()) {
            ArrayList<List<CobolPreprocessor.Word>> replaceWords = new ArrayList<List<CobolPreprocessor.Word>>();
            FindReplaceableAreasVisitor findReplaceableAreasVisitor = new FindReplaceableAreasVisitor(entry.getKey());
            ListUtils.map(((CobolPreprocessor.ReplaceArea)r).getCobols(), it -> (CobolPreprocessor)findReplaceableAreasVisitor.visit((Tree)it, replaceWords, this.getCursor()));
            if (replaceWords.isEmpty()) continue;
            ReplaceVisitor replaceVisitor = new ReplaceVisitor(replaceWords, entry.getValue(), this.replaceMap);
            r = ((CobolPreprocessor.ReplaceArea)r).withCobols(ListUtils.map(((CobolPreprocessor.ReplaceArea)r).getCobols(), it -> (CobolPreprocessor)replaceVisitor.visit((Tree)it, new InMemoryExecutionContext(), this.getCursor())));
        }
        return r;
    }

    private Map<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>> getReplacings(CobolPreprocessor.ReplacingPhrase replacingPhrase) {
        LinkedHashMap<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>> replacements = new LinkedHashMap<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>>();
        for (CobolPreprocessor.ReplaceClause clause : replacingPhrase.getClauses()) {
            List<CobolPreprocessor.Word> replaceable = this.resolveReplacementRule(clause.getReplaceable());
            List<CobolPreprocessor.Word> replacement = this.resolveReplacement(clause);
            if (replaceable.isEmpty()) continue;
            replacements.put(replaceable, replacement);
        }
        return replacements;
    }

    private Map<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>> getReplacements(CobolPreprocessor.ReplaceByStatement replaceByStatement) {
        LinkedHashMap<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>> replacements = new LinkedHashMap<List<CobolPreprocessor.Word>, List<CobolPreprocessor.Word>>();
        for (CobolPreprocessor.ReplaceClause clause : replaceByStatement.getClauses()) {
            List<CobolPreprocessor.Word> replaceable = this.resolveReplacementRule(clause.getReplaceable());
            List<CobolPreprocessor.Word> replacement = this.resolveReplacement(clause);
            if (replaceable.isEmpty()) continue;
            replacements.put(replaceable, replacement);
        }
        return replacements;
    }

    private List<CobolPreprocessor.Word> resolveReplacement(CobolPreprocessor.ReplaceClause replaceClause) {
        ArrayList<CobolPreprocessor.Word> words = new ArrayList<CobolPreprocessor.Word>(this.resolveReplacementRule(replaceClause.getReplacement()));
        if (replaceClause.getSubscript() != null) {
            replaceClause.getSubscript().forEach(s -> words.addAll(this.resolveReplacementRule((CobolPreprocessor)s)));
        }
        if (replaceClause.getDirectoryPhrases() != null) {
            replaceClause.getDirectoryPhrases().forEach(s -> words.addAll(this.resolveReplacementRule((CobolPreprocessor)s)));
        }
        if (replaceClause.getFamilyPhrase() != null) {
            words.addAll(this.resolveReplacementRule(replaceClause.getFamilyPhrase()));
        }
        return words;
    }

    private List<CobolPreprocessor.Word> resolveReplacementRule(CobolPreprocessor cobolPreprocessor) {
        ArrayList<CobolPreprocessor.Word> words = new ArrayList<CobolPreprocessor.Word>();
        CobolPreprocessorWordVisitor wordVisitor = new CobolPreprocessorWordVisitor();
        if (cobolPreprocessor instanceof CobolPreprocessor.PseudoText) {
            CobolPreprocessor.PseudoText pseudoText = (CobolPreprocessor.PseudoText)cobolPreprocessor;
            if (pseudoText.getCharData() != null) {
                wordVisitor.visit(pseudoText.getCharData(), words);
            } else {
                words.add(new CobolPreprocessor.Word(Space.EMPTY, Markers.EMPTY, new Cobol.Word(Space.EMPTY, Markers.EMPTY, null, null, null, null, "", null, null, Collections.emptyList())));
            }
        } else if (cobolPreprocessor instanceof CobolPreprocessor.CharDataLine) {
            CobolPreprocessor.CharDataLine charDataLine = (CobolPreprocessor.CharDataLine)cobolPreprocessor;
            wordVisitor.visit(charDataLine, words);
        } else if (cobolPreprocessor instanceof CobolPreprocessor.Word) {
            CobolPreprocessor.Word word = (CobolPreprocessor.Word)cobolPreprocessor;
            wordVisitor.visit(word, words);
        } else if (cobolPreprocessor instanceof CobolPreprocessor.DirectoryPhrase) {
            CobolPreprocessor.DirectoryPhrase directoryPhrase = (CobolPreprocessor.DirectoryPhrase)cobolPreprocessor;
            wordVisitor.visit(directoryPhrase, words);
        } else if (cobolPreprocessor instanceof CobolPreprocessor.FamilyPhrase) {
            CobolPreprocessor.FamilyPhrase familyPhrase = (CobolPreprocessor.FamilyPhrase)cobolPreprocessor;
            wordVisitor.visit(familyPhrase, words);
        } else {
            throw new UnsupportedOperationException("Implement me.");
        }
        return words;
    }

    public Map<String, Replacement> getReplaceMap() {
        return this.replaceMap;
    }

    public String toString() {
        return "PreprocessReplaceVisitor(replaceMap=" + this.getReplaceMap() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreprocessReplaceVisitor)) {
            return false;
        }
        PreprocessReplaceVisitor other = (PreprocessReplaceVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Replacement> this$replaceMap = this.getReplaceMap();
        Map<String, Replacement> other$replaceMap = other.getReplaceMap();
        return !(this$replaceMap == null ? other$replaceMap != null : !((Object)this$replaceMap).equals(other$replaceMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PreprocessReplaceVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Replacement> $replaceMap = this.getReplaceMap();
        result = result * 59 + ($replaceMap == null ? 43 : ((Object)$replaceMap).hashCode());
        return result;
    }

    private static class FindReplaceableAreasVisitor
    extends CobolPreprocessorIsoVisitor<List<List<CobolPreprocessor.Word>>> {
        private final List<CobolPreprocessor.Word> from;
        private final List<CobolPreprocessor.Word> replacements;
        boolean inMatch = false;
        private int fromPos = 0;

        public FindReplaceableAreasVisitor(List<CobolPreprocessor.Word> from) {
            this.from = from;
            this.replacements = new ArrayList<CobolPreprocessor.Word>();
        }

        @Override
        public CobolPreprocessor.Word visitWord(CobolPreprocessor.Word word, List<List<CobolPreprocessor.Word>> words) {
            if (!this.inMatch && word.getCobolWord().getWord().equals(this.from.get(0).getCobolWord().getWord())) {
                this.fromPos = 0;
                this.replacements.add(word);
                if (this.from.size() == 1) {
                    words.add(new ArrayList<CobolPreprocessor.Word>(this.replacements));
                    this.replacements.clear();
                } else {
                    this.inMatch = true;
                    ++this.fromPos;
                }
            } else if (this.inMatch) {
                if (word.getCobolWord().getWord().equals(this.from.get(this.fromPos).getCobolWord().getWord())) {
                    this.replacements.add(word);
                    if (this.from.size() - 1 == this.fromPos) {
                        words.add(new ArrayList<CobolPreprocessor.Word>(this.replacements));
                        this.inMatch = false;
                        this.fromPos = 0;
                        this.replacements.clear();
                    } else {
                        ++this.fromPos;
                    }
                } else {
                    this.inMatch = false;
                    this.replacements.clear();
                    this.fromPos = 0;
                }
            }
            return super.visitWord(word, words);
        }
    }

    private static class ReplaceVisitor
    extends CobolPreprocessorIsoVisitor<ExecutionContext> {
        private final Map<String, Replacement> replaceMap;
        private final Map<CobolPreprocessor.Word, List<CobolPreprocessor.Word>> from;
        private final List<CobolPreprocessor.Word> to;
        private final ReplacementType replacementType;
        private List<CobolPreprocessor.Word> current;
        private Replacement replaceReductiveType = null;
        private int fromPos = 0;
        private int toPos = 0;
        boolean inMatch = false;

        public ReplaceVisitor(List<List<CobolPreprocessor.Word>> from, List<CobolPreprocessor.Word> to, Map<String, Replacement> replaceMap) {
            this.from = new IdentityHashMap<CobolPreprocessor.Word, List<CobolPreprocessor.Word>>(from.size());
            from.forEach(it -> this.from.put((CobolPreprocessor.Word)it.get(0), (List<CobolPreprocessor.Word>)it));
            this.to = to;
            this.replacementType = this.init();
            this.replaceMap = replaceMap;
        }

        @Override
        public CobolPreprocessor.Copybook visitCopybook(CobolPreprocessor.Copybook copybook, ExecutionContext executionContext) {
            copybook = copybook.withLst(ListUtils.map(copybook.getLst(), it -> (CobolPreprocessor)this.visit((Tree)it, executionContext)));
            return copybook;
        }

        @Override
        public CobolPreprocessor.CopyStatement visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, ExecutionContext executionContext) {
            if (copyStatement.getCopybook() != null) {
                copyStatement = copyStatement.withCopybook(this.visitCopybook(copyStatement.getCopybook(), executionContext));
            }
            return copyStatement;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public CobolPreprocessor.Word visitWord(CobolPreprocessor.Word word, ExecutionContext executionContext) {
            if (ReplacementType.SINGLE_WORD == this.replacementType) {
                if (!this.from.containsKey(word)) return super.visitWord(word, executionContext);
                boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(new Replacement.OriginalWord(word.getCobolWord(), isEmpty)), Replacement.Type.EQUAL, isCopiedSource);
                this.replaceMap.put(replacement.getId().toString(), replacement);
                word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                return super.visitWord(word, executionContext);
            } else if (ReplacementType.EQUAL == this.replacementType) {
                if (!this.inMatch) {
                    if (!this.from.containsKey(word)) return super.visitWord(word, executionContext);
                    this.inMatch = true;
                    this.current = this.from.get(word);
                    this.fromPos = 0;
                    this.toPos = 0;
                    if (!this.current.get(this.fromPos).getCobolWord().getWord().equals(this.to.get(this.toPos).getCobolWord().getWord())) {
                        boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                        CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                        boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                        Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(new Replacement.OriginalWord(word.getCobolWord(), isEmpty)), Replacement.Type.EQUAL, isCopiedSource);
                        this.replaceMap.put(replacement.getId().toString(), replacement);
                        word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                        word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                    }
                    ++this.fromPos;
                    ++this.toPos;
                    return super.visitWord(word, executionContext);
                } else {
                    boolean isSame = this.current.get(this.fromPos).getCobolWord().equals(word.getCobolWord());
                    if (!isSame) throw new IllegalStateException("Fix me, this should not have happened.");
                    if (!this.current.get(this.fromPos).getCobolWord().getWord().equals(this.to.get(this.toPos).getCobolWord().getWord())) {
                        boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                        CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                        boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                        Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(new Replacement.OriginalWord(word.getCobolWord(), isEmpty)), Replacement.Type.EQUAL, isCopiedSource);
                        this.replaceMap.put(replacement.getId().toString(), replacement);
                        word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                        word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                    }
                    if (this.current.size() - 1 == this.fromPos) {
                        this.inMatch = false;
                        this.current = null;
                        this.fromPos = 0;
                        this.toPos = 0;
                        return super.visitWord(word, executionContext);
                    } else {
                        ++this.fromPos;
                        ++this.toPos;
                    }
                }
                return super.visitWord(word, executionContext);
            } else if (ReplacementType.REDUCTIVE == this.replacementType) {
                if (!this.inMatch) {
                    boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                    this.replaceReductiveType = new Replacement(Tree.randomId(), Markers.EMPTY, new ArrayList<Replacement.OriginalWord>(), Replacement.Type.REDUCTIVE, isCopiedSource);
                    this.replaceMap.put(this.replaceReductiveType.getId().toString(), this.replaceReductiveType);
                    if (!this.from.containsKey(word)) return super.visitWord(word, executionContext);
                    this.inMatch = true;
                    this.current = this.from.get(word);
                    this.fromPos = 0;
                    this.toPos = 0;
                    if (!this.current.get(this.fromPos).getCobolWord().getWord().equals(this.to.get(this.toPos).getCobolWord().getWord())) {
                        CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                        boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                        Replacement.OriginalWord originalWord = new Replacement.OriginalWord(word.getCobolWord(), isEmpty);
                        if (isEmpty) {
                            this.replaceReductiveType.getOriginalWords().add(originalWord);
                            word = word.withCobolWord(word.getCobolWord().withReplacement(this.replaceReductiveType));
                            word = word.withCobolWord(word.getCobolWord().withWord(CobolPrinterUtils.fillArea(Character.valueOf(' '), word.getCobolWord().getWord().length())));
                        } else {
                            Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(originalWord), Replacement.Type.EQUAL, isCopiedSource);
                            this.replaceMap.put(replacement.getId().toString(), replacement);
                            word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                            word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                        }
                    }
                    ++this.fromPos;
                    ++this.toPos;
                    return super.visitWord(word, executionContext);
                } else {
                    boolean isSame = this.current.get(this.fromPos).getCobolWord().getWord().equals(word.getCobolWord().getWord());
                    if (!isSame) throw new IllegalStateException("Fix me, this should not have happened.");
                    if (this.toPos >= this.to.size()) {
                        Replacement.OriginalWord originalWord = new Replacement.OriginalWord(word.getCobolWord(), true);
                        this.replaceReductiveType.getOriginalWords().add(originalWord);
                        word = word.withCobolWord(word.getCobolWord().withReplacement(this.replaceReductiveType));
                        word = word.withCobolWord(word.getCobolWord().withWord(CobolPrinterUtils.fillArea(Character.valueOf(' '), word.getCobolWord().getWord().length())));
                    } else if (!this.current.get(this.fromPos).getCobolWord().getWord().equals(this.to.get(this.toPos).getCobolWord().getWord())) {
                        CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                        boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                        Replacement.OriginalWord originalWord = new Replacement.OriginalWord(word.getCobolWord(), isEmpty);
                        if (isEmpty) {
                            this.replaceReductiveType.getOriginalWords().add(originalWord);
                            word = word.withCobolWord(word.getCobolWord().withReplacement(this.replaceReductiveType));
                            word = word.withCobolWord(word.getCobolWord().withWord(CobolPrinterUtils.fillArea(Character.valueOf(' '), word.getCobolWord().getWord().length())));
                        } else {
                            boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                            Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(originalWord), Replacement.Type.EQUAL, isCopiedSource);
                            word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                            word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                        }
                    }
                    if (this.current.size() - 1 == this.fromPos) {
                        this.inMatch = false;
                        this.current = null;
                        this.fromPos = 0;
                        this.toPos = 0;
                        this.replaceReductiveType = null;
                        return super.visitWord(word, executionContext);
                    } else {
                        ++this.fromPos;
                        ++this.toPos;
                    }
                }
                return super.visitWord(word, executionContext);
            } else {
                if (ReplacementType.ADDITIVE != this.replacementType) return super.visitWord(word, executionContext);
                if (!this.inMatch) {
                    if (!this.from.containsKey(word)) return super.visitWord(word, executionContext);
                    this.inMatch = true;
                    this.current = this.from.get(word);
                    this.fromPos = 0;
                    this.toPos = 0;
                    if (!this.current.get(this.fromPos).getCobolWord().getWord().equals(this.to.get(this.toPos).getCobolWord().getWord())) {
                        CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                        boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                        boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                        Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(new Replacement.OriginalWord(word.getCobolWord(), isEmpty)), Replacement.Type.EQUAL, isCopiedSource);
                        this.replaceMap.put(replacement.getId().toString(), replacement);
                        word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                        word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                    }
                    ++this.fromPos;
                    ++this.toPos;
                    return super.visitWord(word, executionContext);
                } else if (this.fromPos < this.current.size()) {
                    boolean isSame = this.current.get(this.fromPos).getCobolWord().getWord().equals(word.getCobolWord().getWord());
                    if (!isSame) throw new IllegalStateException("Fix me, this should not have happened.");
                    if (!this.current.get(this.fromPos).getCobolWord().getWord().equals(this.to.get(this.toPos).getCobolWord().getWord())) {
                        boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                        CobolPreprocessor.Word toWord = this.to.get(this.toPos);
                        boolean isEmpty = toWord.getCobolWord().getWord().isEmpty();
                        Replacement replacement = new Replacement(Tree.randomId(), Markers.EMPTY, Collections.singletonList(new Replacement.OriginalWord(word.getCobolWord(), isEmpty)), Replacement.Type.EQUAL, isCopiedSource);
                        this.replaceMap.put(replacement.getId().toString(), replacement);
                        if (word.getPrefix().isEmpty() && !toWord.getPrefix().isEmpty()) {
                            word = word.withPrefix(toWord.getPrefix());
                        }
                        word = word.withCobolWord(word.getCobolWord().withReplacement(replacement));
                        word = word.withCobolWord(word.getCobolWord().withWord(toWord.getCobolWord().getWord()));
                    }
                    ++this.fromPos;
                    ++this.toPos;
                    return super.visitWord(word, executionContext);
                } else {
                    int difference = this.to.size() - this.current.size();
                    boolean isCopiedSource = this.getCursor().dropParentUntil(is -> is instanceof CobolPreprocessor.CopyStatement || is instanceof CobolPreprocessor.ReplaceArea).getValue() instanceof CobolPreprocessor.CopyStatement;
                    ArrayList<Replacement.OriginalWord> additiveReplaces = new ArrayList<Replacement.OriginalWord>(difference);
                    for (int i = 0; i < difference; ++i) {
                        int cur = this.toPos + i;
                        CobolPreprocessor.Word toWord = this.to.get(cur);
                        Cobol.Word addedWord = new Cobol.Word(toWord.getPrefix(), Markers.EMPTY, null, null, null, null, toWord.getCobolWord().getWord(), null, null, Collections.emptyList());
                        Replacement.OriginalWord originalWord = new Replacement.OriginalWord(addedWord, false);
                        additiveReplaces.add(originalWord);
                    }
                    Replacement replaceAdditiveType = new Replacement(Tree.randomId(), Markers.EMPTY, additiveReplaces, Replacement.Type.ADDITIVE, isCopiedSource);
                    this.replaceMap.put(replaceAdditiveType.getId().toString(), replaceAdditiveType);
                    word = word.withCobolWord(word.getCobolWord().withReplacement(replaceAdditiveType));
                    this.inMatch = false;
                    this.current = null;
                    this.fromPos = 0;
                    this.toPos = 0;
                }
            }
            return super.visitWord(word, executionContext);
        }

        private ReplacementType init() {
            for (List<CobolPreprocessor.Word> words : this.from.values()) {
                if (words.size() == 1 && this.to.size() == 1) {
                    return ReplacementType.SINGLE_WORD;
                }
                if (!words.isEmpty() && words.size() == this.to.size()) {
                    return ReplacementType.EQUAL;
                }
                if (words.size() < this.to.size()) {
                    return ReplacementType.ADDITIVE;
                }
                if (words.size() <= this.from.size()) continue;
                return ReplacementType.REDUCTIVE;
            }
            return ReplacementType.UNKNOWN;
        }

        public static enum ReplacementType {
            SINGLE_WORD,
            EQUAL,
            REDUCTIVE,
            ADDITIVE,
            UNKNOWN;

        }
    }

    private static class CobolPreprocessorWordVisitor
    extends CobolPreprocessorIsoVisitor<List<CobolPreprocessor.Word>> {
        private CobolPreprocessorWordVisitor() {
        }

        @Override
        public CobolPreprocessor.Word visitWord(CobolPreprocessor.Word word, List<CobolPreprocessor.Word> words) {
            words.add(word);
            return super.visitWord(word, words);
        }
    }
}

