/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.format.RemoveWords;
import org.openrewrite.cobol.format.ShiftSequenceAreas;
import org.openrewrite.cobol.marker.CopiedWord;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CommentArea;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.lang.Nullable;

public final class RemoveWithDebuggingMode
extends Recipe {
    @Option(displayName="Update sequence areas", description="When set to `true` the existing sequence are updated to preserve ordering. This is default to false, and is used to prevent large diffs since COBOL has a line limit of 999k.", example="true", required=false)
    @Nullable
    private final Boolean updateSequenceAreas;

    public String getDisplayName() {
        return "Remove with debugging mode";
    }

    public String getDescription() {
        return "Remove debugging mode from SOURCE-COMPUTER paragraphs.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4057");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1000000L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CobolIsoVisitor<ExecutionContext>(){
            @Nullable
            private Cobol.Word endWord = null;

            @Override
            public Cobol.Word visitWord(Cobol.Word word, ExecutionContext executionContext) {
                Cobol w = super.visitWord(word, executionContext);
                if (this.endWord != null) {
                    Cursor parent = this.getCursor().getParent();
                    if (parent != null && parent.getValue() instanceof Cobol.CompilationUnit && ((Cobol.CompilationUnit)parent.getValue()).getEof() == word) {
                        w = ((Cobol.Word)w).withPrefix(Space.EMPTY);
                    }
                    this.endWord = null;
                }
                return w;
            }

            @Override
            public Cobol.SourceComputerDefinition visitSourceComputerDefinition(Cobol.SourceComputerDefinition sourceComputerDefinition, ExecutionContext executionContext) {
                Cobol s = super.visitSourceComputerDefinition(sourceComputerDefinition, executionContext);
                if (((Cobol.SourceComputerDefinition)s).getDebuggingMode() != null) {
                    boolean isSupported = true;
                    for (Cobol.Word word : ((Cobol.SourceComputerDefinition)s).getDebuggingMode()) {
                        if (word.getReplacement() == null && !word.getMarkers().findFirst(CopiedWord.class).isPresent()) continue;
                        isSupported = false;
                        break;
                    }
                    if (isSupported) {
                        if (((Cobol.SourceComputerDefinition)s).getComputerName().getCommentArea() != null && !((Cobol.SourceComputerDefinition)s).getComputerName().getCommentArea().getPrefix().getWhitespace().isEmpty()) {
                            List<Cobol.Word> originalWords = ((Cobol.SourceComputerDefinition)s).getDebuggingMode();
                            CommentArea commentArea = ((Cobol.SourceComputerDefinition)s).getComputerName().getCommentArea();
                            commentArea = commentArea.withPrefix(commentArea.getPrefix().withWhitespace(commentArea.getPrefix().getWhitespace().substring(1)));
                            s = ((Cobol.SourceComputerDefinition)s).withDot(((Cobol.SourceComputerDefinition)s).getDot().withCommentArea(commentArea));
                            s = ((Cobol.SourceComputerDefinition)s).withComputerName(((Cobol.SourceComputerDefinition)s).getComputerName().withCommentArea(null));
                            Cobol.Word startWord = ((Cobol.SourceComputerDefinition)s).getComputerName();
                            if (Boolean.TRUE.equals(RemoveWithDebuggingMode.this.updateSequenceAreas)) {
                                this.doAfterVisit(new ShiftSequenceAreas(originalWords, startWord));
                            }
                            this.endWord = ((Cobol.SourceComputerDefinition)s).getDot();
                            s = ((Cobol.SourceComputerDefinition)s).withDebuggingMode(null);
                        } else {
                            s = new RemoveWords(((Cobol.SourceComputerDefinition)s).getDebuggingMode()).visitSourceComputerDefinition((Cobol.SourceComputerDefinition)s, executionContext);
                        }
                    }
                }
                return s;
            }
        };
    }

    public RemoveWithDebuggingMode(Boolean updateSequenceAreas) {
        this.updateSequenceAreas = updateSequenceAreas;
    }

    public Boolean getUpdateSequenceAreas() {
        return this.updateSequenceAreas;
    }

    public String toString() {
        return "RemoveWithDebuggingMode(updateSequenceAreas=" + this.getUpdateSequenceAreas() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveWithDebuggingMode)) {
            return false;
        }
        RemoveWithDebuggingMode other = (RemoveWithDebuggingMode)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$updateSequenceAreas = this.getUpdateSequenceAreas();
        Boolean other$updateSequenceAreas = other.getUpdateSequenceAreas();
        return !(this$updateSequenceAreas == null ? other$updateSequenceAreas != null : !((Object)this$updateSequenceAreas).equals(other$updateSequenceAreas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveWithDebuggingMode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $updateSequenceAreas = this.getUpdateSequenceAreas();
        result = result * 59 + ($updateSequenceAreas == null ? 43 : ((Object)$updateSequenceAreas).hashCode());
        return result;
    }
}

