/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.format;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.SequenceArea;

@Incubating(since="0.0")
public final class ShiftSequenceAreas
extends CobolIsoVisitor<ExecutionContext> {
    private final LinkedList<SequenceArea> originalSequenceAreas;
    private final Cobol.Word startAfter;
    private Cobol.Word previousWord = null;
    private boolean startShift = false;

    public ShiftSequenceAreas(List<Cobol.Word> originalWords, Cobol.Word startAfter) {
        this.originalSequenceAreas = originalWords.stream().map(Cobol.Word::getSequenceArea).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
        this.startAfter = startAfter;
    }

    @Override
    public Cobol.Word visitWord(Cobol.Word word, ExecutionContext executionContext) {
        Cobol w = super.visitWord(word, executionContext);
        if (this.startShift && word.getSequenceArea() != null) {
            this.originalSequenceAreas.add(((Cobol.Word)w).getSequenceArea());
            w = ((Cobol.Word)w).withSequenceArea(this.originalSequenceAreas.removeFirst());
        }
        if (this.previousWord == this.startAfter) {
            this.startShift = true;
        }
        this.previousWord = w;
        return w;
    }

    public LinkedList<SequenceArea> getOriginalSequenceAreas() {
        return this.originalSequenceAreas;
    }

    public Cobol.Word getStartAfter() {
        return this.startAfter;
    }

    public Cobol.Word getPreviousWord() {
        return this.previousWord;
    }

    public boolean isStartShift() {
        return this.startShift;
    }

    public String toString() {
        return "ShiftSequenceAreas(originalSequenceAreas=" + this.getOriginalSequenceAreas() + ", startAfter=" + this.getStartAfter() + ", previousWord=" + this.getPreviousWord() + ", startShift=" + this.isStartShift() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShiftSequenceAreas)) {
            return false;
        }
        ShiftSequenceAreas other = (ShiftSequenceAreas)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isStartShift() != other.isStartShift()) {
            return false;
        }
        LinkedList<SequenceArea> this$originalSequenceAreas = this.getOriginalSequenceAreas();
        LinkedList<SequenceArea> other$originalSequenceAreas = other.getOriginalSequenceAreas();
        if (this$originalSequenceAreas == null ? other$originalSequenceAreas != null : !((Object)this$originalSequenceAreas).equals(other$originalSequenceAreas)) {
            return false;
        }
        Cobol.Word this$startAfter = this.getStartAfter();
        Cobol.Word other$startAfter = other.getStartAfter();
        if (this$startAfter == null ? other$startAfter != null : !((Object)this$startAfter).equals(other$startAfter)) {
            return false;
        }
        Cobol.Word this$previousWord = this.getPreviousWord();
        Cobol.Word other$previousWord = other.getPreviousWord();
        return !(this$previousWord == null ? other$previousWord != null : !((Object)this$previousWord).equals(other$previousWord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShiftSequenceAreas;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isStartShift() ? 79 : 97);
        LinkedList<SequenceArea> $originalSequenceAreas = this.getOriginalSequenceAreas();
        result = result * 59 + ($originalSequenceAreas == null ? 43 : ((Object)$originalSequenceAreas).hashCode());
        Cobol.Word $startAfter = this.getStartAfter();
        result = result * 59 + ($startAfter == null ? 43 : ((Object)$startAfter).hashCode());
        Cobol.Word $previousWord = this.getPreviousWord();
        result = result * 59 + ($previousWord == null ? 43 : ((Object)$previousWord).hashCode());
        return result;
    }
}

