/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import java.util.Collection;
import org.openrewrite.cobol.internal.HpTandem;
import org.openrewrite.cobol.internal.IbmAnsi85;

public interface CobolDialect {
    public Collection<String> getSeparators();

    public Collection<Character> getCommentIndicators();

    public Columns getColumns();

    public static IbmAnsi85 ibmAnsi85() {
        return IbmAnsi85.getInstance();
    }

    public static HpTandem hpTandem() {
        return HpTandem.getInstance();
    }

    public static enum Columns {
        IBM_ANSI_85(0, 6, 7, 72),
        HP_TANDEM(Integer.MIN_VALUE, 0, 1, 5);

        private final int sequenceArea;
        private final int indicatorArea;
        private final int contentArea;
        private final int otherArea;

        private Columns(int sequenceArea, int indicatorArea, int contentArea, int otherArea) {
            this.sequenceArea = sequenceArea;
            this.indicatorArea = indicatorArea;
            this.contentArea = contentArea;
            this.otherArea = otherArea;
        }

        public int getSequenceArea() {
            return this.sequenceArea;
        }

        public int getIndicatorArea() {
            return this.indicatorArea;
        }

        public int getContentArea() {
            return this.contentArea;
        }

        public int getOtherArea() {
            return this.otherArea;
        }
    }
}

