/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolParsingTimeoutException;
import org.openrewrite.cobol.internal.CobolDialect;
import org.openrewrite.cobol.internal.CobolPreprocessorOutputSourcePrinter;
import org.openrewrite.cobol.internal.grammar.CobolBaseVisitor;
import org.openrewrite.cobol.internal.grammar.CobolParser;
import org.openrewrite.cobol.marker.CopiedWord;
import org.openrewrite.cobol.marker.MissingCopybook;
import org.openrewrite.cobol.tree.BlankLine;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.cobol.tree.CommentArea;
import org.openrewrite.cobol.tree.CommentLine;
import org.openrewrite.cobol.tree.Continuation;
import org.openrewrite.cobol.tree.CopybookSource;
import org.openrewrite.cobol.tree.Identifier;
import org.openrewrite.cobol.tree.IndicatorArea;
import org.openrewrite.cobol.tree.Literal;
import org.openrewrite.cobol.tree.Name;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.SequenceArea;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class CobolParserVisitor
extends CobolBaseVisitor<Object> {
    private final Path path;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final CobolDialect cobolDialect;
    private final Map<String, CobolPreprocessor> preprocessorMap;
    private final Map<String, Replacement> replaceMap;
    private final Duration timeout;
    private final long start = System.nanoTime();
    private final Set<String> templateKeys = new HashSet<String>();
    private final Map<Integer, String> sequenceAreas = new HashMap<Integer, String>();
    private final NavigableMap<Integer, String> indicatorAreas = new TreeMap<Integer, String>();
    private final NavigableMap<Integer, String> commentAreas = new TreeMap<Integer, String>();
    private static final Set<Character> commentIndicators = new HashSet<Character>();
    private int cursor = 0;
    private boolean removeTemplateCommentArea;
    private boolean removeColumnMarkers;
    private boolean isAdditiveCommentArea;
    private String copyStartComment = null;
    private String copyStopComment = null;
    private String copyUuidComment = null;
    private String copybookNotFoundComment = null;
    private final Stack<CopiedWord> copiedWordStack = new Stack();
    private String replaceStartComment = null;
    private String replaceStopComment = null;
    private String replaceAdditiveWhitespaceComment = null;
    private String replaceUuidComment = null;
    private String replaceAdditiveTypeStartComment = null;
    private String replaceAdditiveTypeStopComment = null;
    @Nullable
    private Replacement replaceAdditiveType = null;
    private String replaceAddWordStartComment = null;
    private String replaceAddWordStopComment = null;
    private String replaceReductiveTypeStartComment = null;
    private String replaceReductiveTypeStopComment = null;
    private String compileOptionStartComment = null;
    private String compileOptionStopComment = null;
    private String preprocessorStartComment = null;
    private String preprocessorStopComment = null;
    private String uuidComment = null;
    private Integer nextIndex = null;

    public <T> T visit(ParseTree ... trees) {
        if (Duration.ofNanos(System.nanoTime() - this.start).compareTo(this.timeout) > 0) {
            throw new CobolParsingTimeoutException(this.path);
        }
        for (ParseTree tree : trees) {
            if (tree == null) continue;
            return (T)this.visit(tree);
        }
        throw new IllegalStateException("Expected one of the supplied trees to be non-null");
    }

    public <T> T visitNullable(@Nullable ParseTree tree) {
        if (tree == null) {
            return null;
        }
        return (T)super.visit(tree);
    }

    private void init() {
        String[] parts = this.source.split("\n");
        if (this.cobolDialect.getColumns() == CobolDialect.Columns.IBM_ANSI_85) {
            CobolDialect.Columns columns = this.cobolDialect.getColumns();
            int pos = 0;
            for (String part : parts) {
                String otherArea;
                String cleanedPart;
                boolean isCRLF = part.endsWith("\r");
                String string = cleanedPart = isCRLF ? part.substring(0, part.length() - 1) : part;
                if (cleanedPart.isEmpty()) {
                    pos += isCRLF ? 2 : 1;
                    continue;
                }
                String sequenceArea = cleanedPart.substring(columns.getSequenceArea(), Math.min(cleanedPart.length(), columns.getIndicatorArea()));
                this.sequenceAreas.put(pos, sequenceArea);
                pos += sequenceArea.length();
                if (cleanedPart.length() - 1 >= columns.getIndicatorArea()) {
                    String indicatorArea = cleanedPart.substring(columns.getIndicatorArea(), columns.getContentArea());
                    this.indicatorAreas.put(pos, indicatorArea);
                    pos += indicatorArea.length();
                }
                if (cleanedPart.length() - 1 >= columns.getContentArea()) {
                    String contentArea = cleanedPart.substring(columns.getContentArea(), Math.min(cleanedPart.length(), columns.getOtherArea()));
                    pos += contentArea.length();
                }
                String string2 = otherArea = cleanedPart.length() > columns.getOtherArea() ? cleanedPart.substring(columns.getOtherArea()) : "";
                if (!otherArea.isEmpty()) {
                    this.commentAreas.put(pos, otherArea);
                    pos += otherArea.length();
                }
                pos += isCRLF ? 2 : 1;
            }
        } else {
            if (this.cobolDialect.getColumns() == CobolDialect.Columns.HP_TANDEM) {
                throw new UnsupportedOperationException("Implement me.");
            }
            throw new UnsupportedOperationException("CobolDialect is not supported: " + this.cobolDialect.getColumns().name());
        }
        commentIndicators.addAll(this.cobolDialect.getCommentIndicators());
        CobolPreprocessorOutputSourcePrinter templatePrinter = new CobolPreprocessorOutputSourcePrinter(this.cobolDialect, true);
        this.copyStartComment = this.getCommentFromKey(templatePrinter.getCopyStartComment());
        this.templateKeys.add(this.copyStartComment);
        this.copyStopComment = this.getCommentFromKey(templatePrinter.getCopyStopComment());
        this.templateKeys.add(this.copyStopComment);
        this.copyUuidComment = this.getCommentFromKey(templatePrinter.getCopyUuidKey());
        this.templateKeys.add(this.copyUuidComment);
        this.copybookNotFoundComment = this.getCommentFromKey(templatePrinter.getCopybookNotFound());
        this.templateKeys.add(this.copybookNotFoundComment);
        this.replaceStartComment = this.getCommentFromKey(templatePrinter.getReplaceStartComment());
        this.templateKeys.add(this.replaceStartComment);
        this.replaceStopComment = this.getCommentFromKey(templatePrinter.getReplaceStopComment());
        this.templateKeys.add(this.replaceStopComment);
        this.replaceUuidComment = this.getCommentFromKey(templatePrinter.getReplaceUuidComment());
        this.templateKeys.add(this.replaceUuidComment);
        this.replaceAdditiveWhitespaceComment = this.getCommentFromKey(templatePrinter.getReplaceAddedWhitespaceComment());
        this.templateKeys.add(this.replaceAdditiveWhitespaceComment);
        this.replaceAddWordStartComment = this.getCommentFromKey(templatePrinter.getReplaceAddWordStartComment());
        this.templateKeys.add(this.replaceAddWordStartComment);
        this.replaceAddWordStopComment = this.getCommentFromKey(templatePrinter.getReplaceAddWordStopComment());
        this.templateKeys.add(this.replaceAddWordStopComment);
        this.replaceAdditiveTypeStartComment = this.getCommentFromKey(templatePrinter.getReplaceTypeAdditiveStartComment());
        this.templateKeys.add(this.replaceAdditiveTypeStartComment);
        this.replaceAdditiveTypeStopComment = this.getCommentFromKey(templatePrinter.getReplaceTypeAdditiveStopComment());
        this.templateKeys.add(this.replaceAdditiveTypeStopComment);
        this.replaceReductiveTypeStartComment = this.getCommentFromKey(templatePrinter.getReplaceTypeReductiveStartComment());
        this.templateKeys.add(this.replaceReductiveTypeStartComment);
        this.replaceReductiveTypeStopComment = this.getCommentFromKey(templatePrinter.getReplaceTypeReductiveStopComment());
        this.templateKeys.add(this.replaceReductiveTypeStopComment);
        this.compileOptionStartComment = this.getCommentFromKey(templatePrinter.getCompilerOptionsStartComment());
        this.templateKeys.add(this.compileOptionStartComment);
        this.compileOptionStopComment = this.getCommentFromKey(templatePrinter.getCompilerOptionsStopComment());
        this.templateKeys.add(this.compileOptionStopComment);
        this.preprocessorStartComment = this.getCommentFromKey(templatePrinter.getPreprocessorStartComment());
        this.templateKeys.add(this.preprocessorStartComment);
        this.preprocessorStopComment = this.getCommentFromKey(templatePrinter.getPreprocessorStopComment());
        this.templateKeys.add(this.preprocessorStopComment);
        this.uuidComment = this.getCommentFromKey(templatePrinter.getUuidComment());
        this.templateKeys.add(this.uuidComment);
    }

    @Override
    public Cobol.CompilationUnit visitCompilationUnit(CobolParser.CompilationUnitContext ctx) {
        this.init();
        Space prefix = this.whitespace();
        ArrayList<Cobol.ProgramUnit> programUnits = new ArrayList<Cobol.ProgramUnit>(ctx.programUnit().size());
        for (CobolParser.ProgramUnitContext pu : ctx.programUnit()) {
            programUnits.add(this.visitProgramUnit(pu));
        }
        return new Cobol.CompilationUnit(this.path, this.fileAttributes, prefix, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, programUnits, (Cobol.Word)this.visit((ParseTree)ctx.EOF()));
    }

    @Override
    public Object visitAbbreviation(CobolParser.AbbreviationContext ctx) {
        return new Cobol.Abbreviation(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.NOT()), (Cobol.RelationalOperator)this.visitNullable((ParseTree)ctx.relationalOperator()), (Cobol.Word)this.visitNullable((ParseTree)ctx.LPARENCHAR()), (Cobol)this.visit((ParseTree)ctx.arithmeticExpression()), (Cobol)this.visitNullable((ParseTree)ctx.abbreviation()), (Cobol.Word)this.visitNullable((ParseTree)ctx.RPARENCHAR()));
    }

    @Override
    public Object visitAcceptFromDateStatement(CobolParser.AcceptFromDateStatementContext ctx) {
        return new Cobol.AcceptFromDateStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FROM(), ctx.DATE(), ctx.YYYYMMDD(), ctx.DAY(), ctx.YYYYDDD(), ctx.DAY_OF_WEEK(), ctx.TIME(), ctx.TIMER(), ctx.TODAYS_DATE(), ctx.MMDDYYYY(), ctx.TODAYS_NAME(), ctx.YEAR()));
    }

    @Override
    public Object visitAcceptFromEscapeKeyStatement(CobolParser.AcceptFromEscapeKeyStatementContext ctx) {
        return new Cobol.AcceptFromEscapeKeyStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FROM(), ctx.ESCAPE(), ctx.KEY()));
    }

    @Override
    public Object visitAcceptFromMnemonicStatement(CobolParser.AcceptFromMnemonicStatementContext ctx) {
        return new Cobol.AcceptFromMnemonicStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Identifier)this.visit((ParseTree)ctx.mnemonicName()));
    }

    @Override
    public Object visitAcceptMessageCountStatement(CobolParser.AcceptMessageCountStatementContext ctx) {
        return new Cobol.AcceptMessageCountStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.MESSAGE(), ctx.COUNT()));
    }

    @Override
    public Object visitAcceptStatement(CobolParser.AcceptStatementContext ctx) {
        return new Cobol.Accept(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ACCEPT()), (Identifier)this.visit((ParseTree)ctx.identifier()), ctx.acceptFromDateStatement() != null ? (Cobol)this.visit((ParseTree)ctx.acceptFromDateStatement()) : (ctx.acceptFromEscapeKeyStatement() != null ? (Cobol)this.visit((ParseTree)ctx.acceptFromEscapeKeyStatement()) : (ctx.acceptFromMnemonicStatement() != null ? (Cobol)this.visit((ParseTree)ctx.acceptFromMnemonicStatement()) : (ctx.acceptMessageCountStatement() != null ? (Cobol)this.visit((ParseTree)ctx.acceptMessageCountStatement()) : null))), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onExceptionClause()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnExceptionClause()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_ACCEPT()));
    }

    @Override
    public Object visitAccessModeClause(CobolParser.AccessModeClauseContext ctx) {
        return new Cobol.AccessModeClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ACCESS(), ctx.MODE(), ctx.IS()), (Cobol.Word)this.visit(new ParseTree[]{ctx.SEQUENTIAL(), ctx.RANDOM(), ctx.DYNAMIC(), ctx.EXCLUSIVE()}));
    }

    @Override
    public Object visitAddCorrespondingStatement(CobolParser.AddCorrespondingStatementContext ctx) {
        return new Cobol.AddCorresponding(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.CORRESPONDING(), ctx.CORR()}), (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol.Word)this.visit((ParseTree)ctx.TO()), (Cobol.Roundable)this.visit((ParseTree)ctx.addTo()));
    }

    @Override
    public Cobol.Add visitAddStatement(CobolParser.AddStatementContext ctx) {
        return new Cobol.Add(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ADD()), (Cobol)this.visit(new ParseTree[]{ctx.addToStatement(), ctx.addToGivingStatement(), ctx.addCorrespondingStatement()}), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onSizeErrorPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnSizeErrorPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_ADD()));
    }

    @Override
    public Cobol.AddToGiving visitAddToGivingStatement(CobolParser.AddToGivingStatementContext ctx) {
        return new Cobol.AddToGiving(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.addFrom()), (Cobol.Word)this.visitNullable((ParseTree)ctx.TO()), this.convertAll((List)ctx.addToGiving()), (Cobol.Word)this.visit((ParseTree)ctx.GIVING()), this.convertAll((List)ctx.addGiving()));
    }

    @Override
    public Cobol.AddTo visitAddToStatement(CobolParser.AddToStatementContext ctx) {
        return new Cobol.AddTo(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.addFrom()), (Cobol.Word)this.visitNullable((ParseTree)ctx.TO()), this.convertAll((List)ctx.addTo()));
    }

    @Override
    public Cobol.AlphabetAlso visitAlphabetAlso(CobolParser.AlphabetAlsoContext ctx) {
        return new Cobol.AlphabetAlso(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALSO()), this.convertAll((List)ctx.literal()));
    }

    @Override
    public Cobol.AlphabetClause visitAlphabetClauseFormat1(CobolParser.AlphabetClauseFormat1Context ctx) {
        return new Cobol.AlphabetClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALPHABET()), (Name)this.visit((ParseTree)ctx.alphabetName()), this.convertAllList(Collections.singletonList(ctx.FOR()), Collections.singletonList(ctx.ALPHANUMERIC()), Collections.singletonList(ctx.IS()), Collections.singletonList(ctx.EBCDIC()), Collections.singletonList(ctx.ASCII()), Collections.singletonList(ctx.STANDARD_1()), Collections.singletonList(ctx.STANDARD_2()), Collections.singletonList(ctx.NATIVE()), Collections.singletonList(ctx.cobolWord()), ctx.alphabetLiterals()));
    }

    @Override
    public Cobol.AlphabetClause visitAlphabetClauseFormat2(CobolParser.AlphabetClauseFormat2Context ctx) {
        return new Cobol.AlphabetClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALPHABET()), (Name)this.visit((ParseTree)ctx.alphabetName()), this.convertAllList(Collections.singletonList(ctx.FOR()), Collections.singletonList(ctx.NATIONAL()), Collections.singletonList(ctx.IS()), Collections.singletonList(ctx.NATIVE()), Collections.singletonList(ctx.CCSVERSION()), Collections.singletonList(ctx.literal())));
    }

    @Override
    public Cobol.AlphabetLiteral visitAlphabetLiterals(CobolParser.AlphabetLiteralsContext ctx) {
        return new Cobol.AlphabetLiteral(Space.EMPTY, Markers.EMPTY, (Literal)this.visit((ParseTree)ctx.literal()), (Cobol.AlphabetThrough)this.visitNullable((ParseTree)ctx.alphabetThrough()), ctx.alphabetAlso() == null ? null : this.convertAll((List)ctx.alphabetAlso()));
    }

    @Override
    public Cobol.AlphabetThrough visitAlphabetThrough(CobolParser.AlphabetThroughContext ctx) {
        return new Cobol.AlphabetThrough(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.THROUGH(), ctx.THRU()}), (Literal)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Cobol.AlterProceedTo visitAlterProceedTo(CobolParser.AlterProceedToContext ctx) {
        return new Cobol.AlterProceedTo(Space.EMPTY, Markers.EMPTY, (Cobol.ProcedureName)this.visit((ParseTree)ctx.procedureName(0)), this.wordsList(ctx.TO(0), ctx.PROCEED(), ctx.PROCEED() != null ? ctx.TO(1) : null), (Cobol.ProcedureName)this.visit((ParseTree)ctx.procedureName(1)));
    }

    @Override
    public Cobol.AlterStatement visitAlterStatement(CobolParser.AlterStatementContext ctx) {
        return new Cobol.AlterStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALTER()), this.convertAll((List)ctx.alterProceedTo()));
    }

    @Override
    public Object visitAlteredGoTo(CobolParser.AlteredGoToContext ctx) {
        return new Cobol.AlteredGoTo(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.GO(), ctx.TO()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitAlternateRecordKeyClause(CobolParser.AlternateRecordKeyClauseContext ctx) {
        return new Cobol.AlternateRecordKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ALTERNATE(), ctx.RECORD(), ctx.KEY(), ctx.IS()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()), (Cobol.PasswordClause)this.visitNullable((ParseTree)ctx.passwordClause()), this.wordsList(ctx.WITH(), ctx.DUPLICATES()));
    }

    @Override
    public Object visitAndOrCondition(CobolParser.AndOrConditionContext ctx) {
        return new Cobol.AndOrCondition(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.AND(), ctx.OR()}), (Cobol.CombinableCondition)this.visitNullable((ParseTree)ctx.combinableCondition()), this.convertAll((List)ctx.abbreviation()));
    }

    @Override
    public Object visitArgument(CobolParser.ArgumentContext ctx) {
        return new Cobol.Argument(Space.EMPTY, Markers.EMPTY, (Cobol)this.visit(new ParseTree[]{ctx.literal(), ctx.identifier(), ctx.qualifiedDataName(), ctx.indexName(), ctx.arithmeticExpression()}), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitArithmeticExpression(CobolParser.ArithmeticExpressionContext ctx) {
        return new Cobol.ArithmeticExpression(Space.EMPTY, Markers.EMPTY, (Cobol.MultDivs)this.visit((ParseTree)ctx.multDivs()), this.convertAll((List)ctx.plusMinus()));
    }

    @Override
    public Object visitAssignClause(CobolParser.AssignClauseContext ctx) {
        return new Cobol.AssignClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ASSIGN(), ctx.TO(), ctx.DISK(), ctx.DISPLAY(), ctx.KEYBOARD(), ctx.PORT(), ctx.PRINTER(), ctx.READER(), ctx.REMOTE(), ctx.TAPE(), ctx.VIRTUAL(), ctx.DYNAMIC(), ctx.EXTERNAL()), ctx.assignmentName() != null ? (Name)this.visitNullable((ParseTree)ctx.assignmentName()) : (ctx.literal() != null ? (Name)this.visitNullable((ParseTree)ctx.literal()) : null));
    }

    @Override
    public Cobol.StatementPhrase visitAtEndPhrase(CobolParser.AtEndPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.AT(), ctx.END()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitAuthorParagraph(CobolParser.AuthorParagraphContext ctx) {
        return new Cobol.IdentificationDivisionParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.AUTHOR()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()), null, null);
    }

    @Override
    public Object visitBasis(CobolParser.BasisContext ctx) {
        if (ctx.arithmeticExpression() != null) {
            return new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), Collections.singletonList((Cobol)this.visit((ParseTree)ctx.arithmeticExpression())), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
        }
        return this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()});
    }

    @Override
    public Object visitBlockContainsClause(CobolParser.BlockContainsClauseContext ctx) {
        return new Cobol.BlockContainsClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BLOCK(), ctx.CONTAINS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()), (Cobol.BlockContainsTo)this.visitNullable((ParseTree)ctx.blockContainsTo()), ctx.RECORDS() != null ? (Cobol.Word)this.visit((ParseTree)ctx.RECORDS()) : (ctx.CHARACTERS() != null ? (Cobol.Word)this.visit((ParseTree)ctx.CHARACTERS()) : null));
    }

    @Override
    public Object visitBlockContainsTo(CobolParser.BlockContainsToContext ctx) {
        return new Cobol.BlockContainsTo(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TO()), (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitCallByContent(CobolParser.CallByContentContext ctx) {
        return new Cobol.CallBy(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ADDRESS(), ctx.LENGTH(), ctx.OF(), ctx.OMITTED()), ctx.identifier() != null ? (Name)this.visit((ParseTree)ctx.identifier()) : (ctx.literal() != null ? (Name)this.visit((ParseTree)ctx.literal()) : null));
    }

    @Override
    public Object visitCallByContentPhrase(CobolParser.CallByContentPhraseContext ctx) {
        return new Cobol.CallPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BY(), ctx.CONTENT()), this.convertAll((List)ctx.callByContent()));
    }

    @Override
    public Object visitCallByReference(CobolParser.CallByReferenceContext ctx) {
        return new Cobol.CallBy(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ADDRESS(), ctx.OF(), ctx.INTEGER(), ctx.STRING(), ctx.OMITTED()), ctx.identifier() != null ? (Name)this.visit((ParseTree)ctx.identifier()) : (ctx.literal() != null ? (Name)this.visit((ParseTree)ctx.literal()) : (ctx.fileName() != null ? (Name)this.visit((ParseTree)ctx.fileName()) : null)));
    }

    @Override
    public Object visitCallByReferencePhrase(CobolParser.CallByReferencePhraseContext ctx) {
        return new Cobol.CallPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BY(), ctx.REFERENCE()), this.convertAll((List)ctx.callByReference()));
    }

    @Override
    public Object visitCallByValue(CobolParser.CallByValueContext ctx) {
        return new Cobol.CallBy(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ADDRESS(), ctx.LENGTH(), ctx.OF()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitCallByValuePhrase(CobolParser.CallByValuePhraseContext ctx) {
        return new Cobol.CallPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BY(), ctx.VALUE()), this.convertAll((List)ctx.callByValue()));
    }

    @Override
    public Object visitCallGivingPhrase(CobolParser.CallGivingPhraseContext ctx) {
        return new Cobol.CallGivingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.GIVING(), ctx.RETURNING()}), (Name)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitCallStatement(CobolParser.CallStatementContext ctx) {
        return new Cobol.Call(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.CALL()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.CallPhrase)this.visitNullable((ParseTree)ctx.callUsingPhrase()), (Cobol.CallGivingPhrase)this.visitNullable((ParseTree)ctx.callGivingPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onOverflowPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onExceptionClause()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnExceptionClause()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_CALL()));
    }

    @Override
    public Object visitCallUsingPhrase(CobolParser.CallUsingPhraseContext ctx) {
        return new Cobol.CallPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.USING()), this.convertAllList(ctx.callUsingParameter()));
    }

    @Override
    public Object visitCancelCall(CobolParser.CancelCallContext ctx) {
        return new Cobol.CancelCall(Space.EMPTY, Markers.EMPTY, (Name)this.visitNullable((ParseTree)ctx.libraryName()), this.wordsList(ctx.BYTITLE(), ctx.BYFUNCTION()), (Identifier)this.visitNullable((ParseTree)ctx.identifier()), (Literal)this.visitNullable((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitCancelStatement(CobolParser.CancelStatementContext ctx) {
        return new Cobol.Cancel(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CANCEL()), this.convertAll((List)ctx.cancelCall()));
    }

    @Override
    public Cobol.ChannelClause visitChannelClause(CobolParser.ChannelClauseContext ctx) {
        return new Cobol.ChannelClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CHANNEL()), (Literal)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visitNullable((ParseTree)ctx.IS()), (Identifier)this.visit((ParseTree)ctx.mnemonicName()));
    }

    @Override
    public Cobol.ValuedObjectComputerClause visitCharacterSetClause(CobolParser.CharacterSetClauseContext ctx) {
        return new Cobol.ValuedObjectComputerClause(Space.EMPTY, Markers.EMPTY, Cobol.ValuedObjectComputerClause.Type.CharacterSet, this.wordsList(ctx.CHARACTER(), ctx.SET(), ctx.DOT_FS()), null, null);
    }

    @Override
    public Object visitClassClause(CobolParser.ClassClauseContext ctx) {
        return new Cobol.ClassClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CLASS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.className()), this.wordsList(ctx.FOR(), ctx.ALPHANUMERIC(), ctx.NATIONAL(), ctx.IS()), this.convertAll((List)ctx.classClauseThrough()));
    }

    @Override
    public Object visitClassClauseThrough(CobolParser.ClassClauseThroughContext ctx) {
        return new Cobol.ClassClauseThrough(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.classClauseFrom()), ctx.THROUGH() != null ? (Cobol.Word)this.visit((ParseTree)ctx.THROUGH()) : (ctx.THRU() != null ? (Cobol.Word)this.visit((ParseTree)ctx.THRU()) : null), (Name)this.visitNullable((ParseTree)ctx.classClauseTo()));
    }

    @Override
    public Object visitClassCondition(CobolParser.ClassConditionContext ctx) {
        return new Cobol.ClassCondition(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.identifier()), this.wordsList(ctx.IS(), ctx.NOT()), (Cobol)this.visit(new ParseTree[]{ctx.NUMERIC(), ctx.ALPHABETIC(), ctx.ALPHABETIC_LOWER(), ctx.ALPHABETIC_UPPER(), ctx.DBCS(), ctx.KANJI(), ctx.className()}));
    }

    @Override
    public Object visitCloseFile(CobolParser.CloseFileContext ctx) {
        return new Cobol.CloseFile(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.fileName()), ctx.closeReelUnitStatement() != null || ctx.closeRelativeStatement() != null || ctx.closePortFileIOStatement() != null ? (Cobol)this.visit(new ParseTree[]{ctx.closeReelUnitStatement(), ctx.closeRelativeStatement(), ctx.closePortFileIOStatement()}) : null);
    }

    @Override
    public Object visitClosePortFileIOStatement(CobolParser.ClosePortFileIOStatementContext ctx) {
        return new Cobol.ClosePortFileIOStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.NO(), ctx.WAIT(), ctx.USING()), this.convertAll((List)ctx.closePortFileIOUsing()));
    }

    @Override
    public Object visitClosePortFileIOUsingAssociatedData(CobolParser.ClosePortFileIOUsingAssociatedDataContext ctx) {
        return new Cobol.ClosePortFileIOUsingAssociatedData(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ASSOCIATED_DATA()), (Identifier)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitClosePortFileIOUsingAssociatedDataLength(CobolParser.ClosePortFileIOUsingAssociatedDataLengthContext ctx) {
        return new Cobol.ClosePortFileIOUsingAssociatedDataLength(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ASSOCIATED_DATA_LENGTH(), ctx.OF()), (Identifier)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitClosePortFileIOUsingCloseDisposition(CobolParser.ClosePortFileIOUsingCloseDispositionContext ctx) {
        return new Cobol.ClosePortFileIOUsingCloseDisposition(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CLOSE_DISPOSITION(), ctx.OF(), ctx.ABORT(), ctx.ORDERLY()));
    }

    @Override
    public Object visitCloseReelUnitStatement(CobolParser.CloseReelUnitStatementContext ctx) {
        return new Cobol.CloseReelUnitStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REEL(), ctx.UNIT(), ctx.FOR(), ctx.REMOVAL(), ctx.WITH(), ctx.NO(), ctx.REWIND(), ctx.LOCK()));
    }

    @Override
    public Object visitCloseRelativeStatement(CobolParser.CloseRelativeStatementContext ctx) {
        return new Cobol.CloseRelativeStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.NO(), ctx.REWIND(), ctx.LOCK()));
    }

    @Override
    public Object visitCloseStatement(CobolParser.CloseStatementContext ctx) {
        return new Cobol.Close(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CLOSE()), this.convertAllList(ctx.closeFile()));
    }

    @Override
    public Object visitCodeSetClause(CobolParser.CodeSetClauseContext ctx) {
        return new Cobol.CodeSetClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CODE_SET(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.alphabetName()));
    }

    @Override
    public Cobol.CollatingSequenceClause visitCollatingSequenceClause(CobolParser.CollatingSequenceClauseContext ctx) {
        return new Cobol.CollatingSequenceClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PROGRAM(), ctx.COLLATING(), ctx.SEQUENCE()), (Cobol.Word)this.visit((ParseTree)ctx.IS()), this.convertAll((List)ctx.alphabetName()), (Cobol.CollatingSequenceAlphabet)this.visitNullable((ParseTree)ctx.collatingSequenceClauseAlphanumeric()), (Cobol.CollatingSequenceAlphabet)this.visitNullable((ParseTree)ctx.collatingSequenceClauseNational()));
    }

    @Override
    public Cobol.CollatingSequenceAlphabet visitCollatingSequenceClauseAlphanumeric(CobolParser.CollatingSequenceClauseAlphanumericContext ctx) {
        return new Cobol.CollatingSequenceAlphabet(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.ALPHANUMERIC(), ctx.IS()), (Identifier)this.visit((ParseTree)ctx.alphabetName()));
    }

    @Override
    public Object visitCollatingSequenceClauseNational(CobolParser.CollatingSequenceClauseNationalContext ctx) {
        return new Cobol.CollatingSequenceAlphabet(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.NATIONAL(), ctx.IS()), (Identifier)this.visit((ParseTree)ctx.alphabetName()));
    }

    @Override
    public Object visitCombinableCondition(CobolParser.CombinableConditionContext ctx) {
        return new Cobol.CombinableCondition(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.NOT()), (Cobol)this.visit((ParseTree)ctx.simpleCondition()));
    }

    @Override
    public Object visitCommentEntry(CobolParser.CommentEntryContext ctx) {
        return new Cobol.CommentEntry(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.COMMENTENTRYLINE()));
    }

    @Override
    public Object visitCommitmentControlClause(CobolParser.CommitmentControlClauseContext ctx) {
        return new Cobol.CommitmentControlClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COMMITMENT(), ctx.CONTROL(), ctx.FOR()), (Cobol.Word)this.visit((ParseTree)ctx.fileName()));
    }

    @Override
    public Object visitCommunicationDescriptionEntryFormat1(CobolParser.CommunicationDescriptionEntryFormat1Context ctx) {
        return new Cobol.CommunicationDescriptionEntryFormat1(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CD()), (Cobol.Word)this.visitNullable((ParseTree)ctx.cdName()), this.wordsList(ctx.FOR(), ctx.INITIAL(), ctx.INPUT()), this.convertAll(ctx.symbolicQueueClause(), ctx.symbolicSubQueueClause(), ctx.messageDateClause(), ctx.messageTimeClause(), ctx.symbolicSourceClause(), ctx.textLengthClause(), ctx.endKeyClause(), ctx.statusKeyClause(), ctx.messageCountClause(), ctx.dataDescName()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitCommunicationDescriptionEntryFormat2(CobolParser.CommunicationDescriptionEntryFormat2Context ctx) {
        return new Cobol.CommunicationDescriptionEntryFormat2(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CD()), (Cobol.Word)this.visitNullable((ParseTree)ctx.cdName()), this.wordsList(ctx.FOR(), ctx.OUTPUT()), this.convertAll(ctx.destinationCountClause(), ctx.textLengthClause(), ctx.statusKeyClause(), ctx.destinationTableClause(), ctx.errorKeyClause(), ctx.symbolicDestinationClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitCommunicationDescriptionEntryFormat3(CobolParser.CommunicationDescriptionEntryFormat3Context ctx) {
        return new Cobol.CommunicationDescriptionEntryFormat3(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CD()), (Cobol.Word)this.visitNullable((ParseTree)ctx.cdName()), this.wordsList(ctx.FOR(), ctx.INITIAL(), ctx.I_O()), this.convertAll(ctx.messageDateClause(), ctx.messageTimeClause(), ctx.symbolicTerminalClause(), ctx.textLengthClause(), ctx.endKeyClause(), ctx.statusKeyClause(), ctx.dataDescName()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitCommunicationSection(CobolParser.CommunicationSectionContext ctx) {
        return new Cobol.CommunicationSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COMMUNICATION(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll(ctx.communicationDescriptionEntry(), ctx.dataDescriptionEntry()));
    }

    @Override
    public Object visitComputeStatement(CobolParser.ComputeStatementContext ctx) {
        return new Cobol.Compute(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.COMPUTE()), this.convertAll((List)ctx.computeStore()), (Cobol.Word)this.visit(new ParseTree[]{ctx.EQUALCHAR(), ctx.EQUAL()}), (Cobol.ArithmeticExpression)this.visit((ParseTree)ctx.arithmeticExpression()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onSizeErrorPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnSizeErrorPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_COMPUTE()));
    }

    @Override
    public Object visitCondition(CobolParser.ConditionContext ctx) {
        return new Cobol.Condition(Space.EMPTY, Markers.EMPTY, (Cobol.CombinableCondition)this.visit((ParseTree)ctx.combinableCondition()), this.convertAll((List)ctx.andOrCondition()));
    }

    @Override
    public Cobol.ConditionNameReference visitConditionNameReference(CobolParser.ConditionNameReferenceContext ctx) {
        return new Cobol.ConditionNameReference(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.conditionName()), this.convertAll((List)ctx.inData()), (Cobol.InFile)this.visitNullable((ParseTree)ctx.inFile()), this.convertAll((List)ctx.conditionNameSubscriptReference()), this.convertAll((List)ctx.inMnemonic()));
    }

    @Override
    public Cobol visitConditionNameSubscriptReference(CobolParser.ConditionNameSubscriptReferenceContext ctx) {
        return new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), this.convertAllList(ctx.subscript(), ctx.COMMACHAR()), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
    }

    @Override
    public Cobol.ConfigurationSection visitConfigurationSection(CobolParser.ConfigurationSectionContext ctx) {
        return new Cobol.ConfigurationSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CONFIGURATION(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.configurationSectionParagraph()));
    }

    @Override
    public Object visitContinueStatement(CobolParser.ContinueStatementContext ctx) {
        return new Cobol.Continue(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CONTINUE()));
    }

    @Override
    public Cobol.CurrencyClause visitCurrencySignClause(CobolParser.CurrencySignClauseContext ctx) {
        return new Cobol.CurrencyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CURRENCY(), ctx.SIGN(), ctx.IS()), (Literal)this.visit((ParseTree)ctx.literal(0)), this.wordsList(ctx.WITH(), ctx.PICTURE(), ctx.SYMBOL()), ctx.literal().size() > 1 ? (Literal)this.visit((ParseTree)ctx.literal(1)) : null);
    }

    @Override
    public Object visitDataAlignedClause(CobolParser.DataAlignedClauseContext ctx) {
        return new Cobol.DataAlignedClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALIGNED()));
    }

    @Override
    public Object visitDataBaseSection(CobolParser.DataBaseSectionContext ctx) {
        return new Cobol.DataBaseSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DATA_BASE(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.dataBaseSectionEntry()));
    }

    @Override
    public Object visitDataBaseSectionEntry(CobolParser.DataBaseSectionEntryContext ctx) {
        return new Cobol.DataBaseSectionEntry(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Literal)this.visit((ParseTree)ctx.literal(0)), (Cobol.Word)this.visit((ParseTree)ctx.INVOKE()), (Literal)this.visit((ParseTree)ctx.literal(1)));
    }

    @Override
    public Object visitDataBlankWhenZeroClause(CobolParser.DataBlankWhenZeroClauseContext ctx) {
        return new Cobol.DataBlankWhenZeroClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BLANK(), ctx.WHEN(), ctx.ZERO(), ctx.ZEROS(), ctx.ZEROES()));
    }

    @Override
    public Object visitDataCommonOwnLocalClause(CobolParser.DataCommonOwnLocalClauseContext ctx) {
        return new Cobol.DataCommonOwnLocalClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.COMMON(), ctx.OWN(), ctx.LOCAL()}));
    }

    @Override
    public Object visitDataDescriptionEntryExecSql(CobolParser.DataDescriptionEntryExecSqlContext ctx) {
        return new Cobol.DataDescriptionEntry(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.EXECSQLLINE()), null, null, (Cobol.Word)this.visitNullable((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Cobol.DataDescriptionEntry visitDataDescriptionEntryFormat1(CobolParser.DataDescriptionEntryFormat1Context ctx) {
        return new Cobol.DataDescriptionEntry(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LEVEL_NUMBER_77(), ctx.INTEGERLITERAL()), ctx.dataName() != null ? (Cobol.Word)this.visit((ParseTree)ctx.dataName()) : (ctx.FILLER() != null ? (Cobol.Word)this.visit((ParseTree)ctx.FILLER()) : null), this.convertAll((List)ctx.dataDescriptionEntryFormat1Clause()), (Cobol.Word)this.visitNullable((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitDataDescriptionEntryFormat2(CobolParser.DataDescriptionEntryFormat2Context ctx) {
        return new Cobol.DataDescriptionEntry(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LEVEL_NUMBER_66()), (Cobol.Word)this.visit((ParseTree)ctx.dataName()), this.convertAll((List)Collections.singletonList(ctx.dataRenamesClause())), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitDataDescriptionEntryFormat3(CobolParser.DataDescriptionEntryFormat3Context ctx) {
        return new Cobol.DataDescriptionEntry(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LEVEL_NUMBER_88()), (Cobol.Word)this.visit((ParseTree)ctx.conditionName()), this.convertAll((List)Collections.singletonList(ctx.dataValueClause())), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Cobol.DataDivision visitDataDivision(CobolParser.DataDivisionContext ctx) {
        return new Cobol.DataDivision(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DATA(), ctx.DIVISION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.dataDivisionSection()));
    }

    @Override
    public Object visitDataExternalClause(CobolParser.DataExternalClauseContext ctx) {
        return new Cobol.DataExternalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.EXTERNAL(), ctx.BY()), (Literal)this.visitNullable((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitDataGlobalClause(CobolParser.DataGlobalClauseContext ctx) {
        return new Cobol.DataGlobalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.GLOBAL()));
    }

    @Override
    public Object visitDataIntegerStringClause(CobolParser.DataIntegerStringClauseContext ctx) {
        return new Cobol.DataIntegerStringClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.INTEGER(), ctx.STRING()}));
    }

    @Override
    public Object visitDataJustifiedClause(CobolParser.DataJustifiedClauseContext ctx) {
        return new Cobol.DataJustifiedClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.JUSTIFIED(), ctx.JUST(), ctx.RIGHT()));
    }

    @Override
    public Object visitDataOccursClause(CobolParser.DataOccursClauseContext ctx) {
        return new Cobol.DataOccursClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.OCCURS()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}), (Cobol.DataOccursTo)this.visitNullable((ParseTree)ctx.dataOccursTo()), (Cobol.Word)this.visitNullable((ParseTree)ctx.TIMES()), (Cobol.DataOccursDepending)this.visitNullable((ParseTree)ctx.dataOccursDepending()), this.convertAll(ctx.dataOccursSort(), ctx.dataOccursIndexed()));
    }

    @Override
    public Object visitDataOccursDepending(CobolParser.DataOccursDependingContext ctx) {
        return new Cobol.DataOccursDepending(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DEPENDING(), ctx.ON()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Object visitDataOccursIndexed(CobolParser.DataOccursIndexedContext ctx) {
        return new Cobol.DataOccursIndexed(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.INDEXED(), ctx.BY(), ctx.LOCAL()), this.convertAll((List)ctx.indexName()));
    }

    @Override
    public Object visitDataOccursSort(CobolParser.DataOccursSortContext ctx) {
        return new Cobol.DataOccursSort(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ASCENDING(), ctx.DESCENDING(), ctx.KEY(), ctx.IS()), this.convertAll((List)ctx.qualifiedDataName()));
    }

    @Override
    public Object visitDataOccursTo(CobolParser.DataOccursToContext ctx) {
        return new Cobol.DataOccursTo(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TO()), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Cobol.DataPictureClause visitDataPictureClause(CobolParser.DataPictureClauseContext ctx) {
        return new Cobol.DataPictureClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PICTURE(), ctx.PIC(), ctx.IS()), this.convertAll((List)Collections.singletonList(ctx.pictureString())));
    }

    @Override
    public Object visitDataReceivedByClause(CobolParser.DataReceivedByClauseContext ctx) {
        return new Cobol.DataReceivedByClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RECEIVED(), ctx.BY(), ctx.CONTENT(), ctx.REFERENCE(), ctx.REF()));
    }

    @Override
    public Object visitDataRecordAreaClause(CobolParser.DataRecordAreaClauseContext ctx) {
        return new Cobol.DataRecordAreaClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RECORD(), ctx.AREA()));
    }

    @Override
    public Object visitDataRecordsClause(CobolParser.DataRecordsClauseContext ctx) {
        return new Cobol.DataRecordsClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DATA(), ctx.RECORD(), ctx.RECORDS(), ctx.IS(), ctx.ARE()), this.convertAll((List)ctx.dataName()));
    }

    @Override
    public Object visitDataRedefinesClause(CobolParser.DataRedefinesClauseContext ctx) {
        return new Cobol.DataRedefinesClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REDEFINES()), (Cobol.Word)this.visit((ParseTree)ctx.dataName()));
    }

    @Override
    public Object visitDataRenamesClause(CobolParser.DataRenamesClauseContext ctx) {
        return new Cobol.DataRenamesClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RENAMES()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName(0)), ctx.THROUGH() != null ? (Cobol.Word)this.visit((ParseTree)ctx.THROUGH()) : (ctx.THRU() != null ? (Cobol.Word)this.visit((ParseTree)ctx.THRU()) : null), ctx.qualifiedDataName().size() == 1 ? null : (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName(1)));
    }

    @Override
    public Object visitDataSignClause(CobolParser.DataSignClauseContext ctx) {
        return new Cobol.DataSignClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SIGN(), ctx.IS(), ctx.LEADING(), ctx.TRAILING(), ctx.SEPARATE(), ctx.CHARACTER()));
    }

    @Override
    public Object visitDataSynchronizedClause(CobolParser.DataSynchronizedClauseContext ctx) {
        return new Cobol.DataSynchronizedClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYNCHRONIZED(), ctx.SYNC(), ctx.LEFT(), ctx.RIGHT()));
    }

    @Override
    public Object visitDataThreadLocalClause(CobolParser.DataThreadLocalClauseContext ctx) {
        return new Cobol.DataThreadLocalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.THREAD_LOCAL()));
    }

    @Override
    public Object visitDataTypeClause(CobolParser.DataTypeClauseContext ctx) {
        return new Cobol.DataTypeClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.TYPE(), ctx.IS(), ctx.SHORT_DATE(), ctx.LONG_DATE(), ctx.NUMERIC_DATE(), ctx.NUMERIC_TIME(), ctx.LONG_TIME(), ctx.CLOB(), ctx.BLOB(), ctx.DBCLOB()), ctx.integerLiteral() == null ? null : new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), Collections.singletonList((Cobol)this.visit((ParseTree)ctx.integerLiteral())), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR())));
    }

    @Override
    public Object visitDataTypeDefClause(CobolParser.DataTypeDefClauseContext ctx) {
        return new Cobol.DataTypeDefClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.TYPEDEF()));
    }

    @Override
    public Object visitDataUsageClause(CobolParser.DataUsageClauseContext ctx) {
        return new Cobol.DataUsageClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.USAGE(), ctx.IS(), ctx.BINARY(), ctx.TRUNCATED(), ctx.EXTENDED(), ctx.BIT(), ctx.COMP(), ctx.COMP_1(), ctx.COMP_2(), ctx.COMP_3(), ctx.COMP_4(), ctx.COMP_5(), ctx.COMPUTATIONAL(), ctx.COMPUTATIONAL_1(), ctx.COMPUTATIONAL_2(), ctx.COMPUTATIONAL_3(), ctx.COMPUTATIONAL_4(), ctx.COMPUTATIONAL_5(), ctx.CONTROL_POINT(), ctx.DATE(), ctx.DISPLAY(), ctx.DISPLAY_1(), ctx.DOUBLE(), ctx.EVENT(), ctx.FUNCTION_POINTER(), ctx.INDEX(), ctx.KANJI(), ctx.LOCK(), ctx.NATIONAL(), ctx.PACKED_DECIMAL(), ctx.POINTER(), ctx.PROCEDURE_POINTER(), ctx.REAL(), ctx.SQL(), ctx.TASK()));
    }

    @Override
    public Object visitDataUsingClause(CobolParser.DataUsingClauseContext ctx) {
        return new Cobol.DataUsingClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.USING(), ctx.LANGUAGE(), ctx.CONVENTION(), ctx.OF()), (Name)this.visit(new ParseTree[]{ctx.cobolWord(), ctx.dataName()}));
    }

    @Override
    public Object visitDataValueClause(CobolParser.DataValueClauseContext ctx) {
        return new Cobol.DataValueClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.VALUE(), ctx.VALUES(), ctx.IS(), ctx.ARE()), this.convertAllList(ctx.dataValueInterval(), ctx.COMMACHAR()));
    }

    @Override
    public Object visitDataValueInterval(CobolParser.DataValueIntervalContext ctx) {
        return new Cobol.DataValueInterval(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.dataValueIntervalFrom()), (Cobol.DataValueIntervalTo)this.visitNullable((ParseTree)ctx.dataValueIntervalTo()));
    }

    @Override
    public Object visitDataValueIntervalTo(CobolParser.DataValueIntervalToContext ctx) {
        return new Cobol.DataValueIntervalTo(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.THROUGH(), ctx.THRU()}), (Literal)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitDataWithLowerBoundsClause(CobolParser.DataWithLowerBoundsClauseContext ctx) {
        return new Cobol.DataWithLowerBoundsClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.LOWER(), ctx.BOUNDS()));
    }

    @Override
    public Object visitDateCompiledParagraph(CobolParser.DateCompiledParagraphContext ctx) {
        return new Cobol.IdentificationDivisionParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DATE_COMPILED()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()), null, null);
    }

    @Override
    public Object visitDateWrittenParagraph(CobolParser.DateWrittenParagraphContext ctx) {
        return new Cobol.IdentificationDivisionParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DATE_WRITTEN()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()), null, null);
    }

    @Override
    public Cobol.DecimalPointClause visitDecimalPointClause(CobolParser.DecimalPointClauseContext ctx) {
        return new Cobol.DecimalPointClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DECIMAL_POINT(), ctx.IS(), ctx.COMMA()));
    }

    @Override
    public Cobol.DefaultComputationalSignClause visitDefaultComputationalSignClause(CobolParser.DefaultComputationalSignClauseContext ctx) {
        return new Cobol.DefaultComputationalSignClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DEFAULT(), ctx.COMPUTATIONAL(), ctx.COMP(), ctx.SIGN(), ctx.IS(), ctx.LEADING(), ctx.TRAILING(), ctx.SEPARATE(), ctx.CHARACTER()));
    }

    @Override
    public Cobol.DefaultDisplaySignClause visitDefaultDisplaySignClause(CobolParser.DefaultDisplaySignClauseContext ctx) {
        return new Cobol.DefaultDisplaySignClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DEFAULT_DISPLAY(), ctx.SIGN(), ctx.IS(), ctx.LEADING(), ctx.TRAILING(), ctx.SEPARATE(), ctx.CHARACTER()));
    }

    @Override
    public Object visitDeleteStatement(CobolParser.DeleteStatementContext ctx) {
        return new Cobol.Delete(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DELETE()), (Name)this.visit((ParseTree)ctx.fileName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.RECORD()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.invalidKeyPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notInvalidKeyPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_DELETE()));
    }

    @Override
    public Object visitDestinationCountClause(CobolParser.DestinationCountClauseContext ctx) {
        return new Cobol.DestinationCountClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DESTINATION(), ctx.COUNT(), ctx.IS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitDestinationTableClause(CobolParser.DestinationTableClauseContext ctx) {
        return new Cobol.DestinationTableClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DESTINATION(), ctx.TABLE(), ctx.OCCURS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()), this.wordsList(ctx.TIMES(), ctx.INDEXED(), ctx.BY()), this.convertAll((List)ctx.indexName()));
    }

    @Override
    public Object visitDisableStatement(CobolParser.DisableStatementContext ctx) {
        return new Cobol.Disable(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DISABLE()), this.wordsList(ctx.INPUT(), ctx.I_O(), ctx.TERMINAL(), ctx.OUTPUT()), (Name)this.visit((ParseTree)ctx.cdName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.WITH()), (Cobol.Word)this.visit((ParseTree)ctx.KEY()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Cobol.ValuedObjectComputerClause visitDiskSizeClause(CobolParser.DiskSizeClauseContext ctx) {
        return new Cobol.ValuedObjectComputerClause(Space.EMPTY, Markers.EMPTY, Cobol.ValuedObjectComputerClause.Type.Disk, this.wordsList(ctx.DISK(), ctx.SIZE()), ctx.integerLiteral() != null ? (Cobol)this.visit((ParseTree)ctx.integerLiteral()) : (ctx.cobolWord() != null ? (Cobol)this.visit((ParseTree)ctx.cobolWord()) : null), ctx.WORDS() != null ? (Cobol.Word)this.visit((ParseTree)ctx.WORDS()) : (ctx.MODULES() != null ? (Cobol.Word)this.visit((ParseTree)ctx.MODULES()) : null));
    }

    @Override
    public Object visitDisplayAt(CobolParser.DisplayAtContext ctx) {
        return new Cobol.DisplayAt(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.AT()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Cobol.Display visitDisplayStatement(CobolParser.DisplayStatementContext ctx) {
        return new Cobol.Display(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DISPLAY()), this.convertAllList(ctx.displayOperand(), ctx.COMMACHAR()), (Cobol.DisplayAt)this.visitNullable((ParseTree)ctx.displayAt()), (Cobol.DisplayUpon)this.visitNullable((ParseTree)ctx.displayUpon()), (List)this.visitNullable((ParseTree)ctx.displayWith()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onExceptionClause()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnExceptionClause()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_DISPLAY()));
    }

    @Override
    public Object visitDisplayUpon(CobolParser.DisplayUponContext ctx) {
        return new Cobol.DisplayUpon(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.UPON()), (Cobol.Word)this.visit(new ParseTree[]{ctx.mnemonicName(), ctx.environmentName()}));
    }

    @Override
    public Object visitDisplayWith(CobolParser.DisplayWithContext ctx) {
        return Objects.requireNonNull(this.wordsList(ctx.WITH(), ctx.NO(), ctx.ADVANCING()));
    }

    @Override
    public Object visitDivideByGivingStatement(CobolParser.DivideByGivingStatementContext ctx) {
        return new Cobol.DivideGiving(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.BY()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.DivideGivingPhrase)this.visitNullable((ParseTree)ctx.divideGivingPhrase()));
    }

    @Override
    public Object visitDivideGivingPhrase(CobolParser.DivideGivingPhraseContext ctx) {
        return new Cobol.DivideGivingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.GIVING()), this.convertAll((List)ctx.divideGiving()));
    }

    @Override
    public Object visitDivideIntoGivingStatement(CobolParser.DivideIntoGivingStatementContext ctx) {
        return new Cobol.DivideGiving(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTO()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.DivideGivingPhrase)this.visitNullable((ParseTree)ctx.divideGivingPhrase()));
    }

    @Override
    public Object visitDivideIntoStatement(CobolParser.DivideIntoStatementContext ctx) {
        return new Cobol.DivideInto(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTO()), this.convertAll((List)ctx.divideInto()));
    }

    @Override
    public Object visitDivideRemainder(CobolParser.DivideRemainderContext ctx) {
        return new Cobol.DivideRemainder(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REMAINDER()), (Name)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitDivideStatement(CobolParser.DivideStatementContext ctx) {
        return new Cobol.Divide(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DIVIDE()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol)this.visit(new ParseTree[]{ctx.divideIntoStatement(), ctx.divideIntoGivingStatement(), ctx.divideByGivingStatement()}), (Cobol.DivideRemainder)this.visitNullable((ParseTree)ctx.divideRemainder()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onSizeErrorPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnSizeErrorPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_DIVIDE()));
    }

    @Override
    public Object visitEnableStatement(CobolParser.EnableStatementContext ctx) {
        return new Cobol.Enable(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ENABLE()), this.wordsList(ctx.INPUT(), ctx.I_O(), ctx.TERMINAL(), ctx.OUTPUT()), (Name)this.visit((ParseTree)ctx.cdName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.WITH()), (Cobol.Word)this.visit((ParseTree)ctx.KEY()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitEndKeyClause(CobolParser.EndKeyClauseContext ctx) {
        return new Cobol.EndKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.END(), ctx.KEY(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Cobol.EndProgram visitEndProgramStatement(CobolParser.EndProgramStatementContext ctx) {
        return new Cobol.EndProgram(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.END(), ctx.PROGRAM()), (Name)this.visit((ParseTree)ctx.programName()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitEntryStatement(CobolParser.EntryStatementContext ctx) {
        return new Cobol.Entry(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ENTRY()), (Literal)this.visit((ParseTree)ctx.literal()), (Cobol.Word)this.visitNullable((ParseTree)ctx.USING()), this.convertAll((List)ctx.identifier()));
    }

    @Override
    public Cobol.EnvironmentDivision visitEnvironmentDivision(CobolParser.EnvironmentDivisionContext ctx) {
        return new Cobol.EnvironmentDivision(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ENVIRONMENT(), ctx.DIVISION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.environmentDivisionBody()));
    }

    @Override
    public Object visitEnvironmentSwitchNameClause(CobolParser.EnvironmentSwitchNameClauseContext ctx) {
        return new Cobol.EnvironmentSwitchNameClause(Space.EMPTY, Markers.EMPTY, (Name)this.visitNullable((ParseTree)ctx.environmentName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.IS()), (Name)this.visitNullable((ParseTree)ctx.mnemonicName()), (Cobol.EnvironmentSwitchNameSpecialNamesStatusPhrase)this.visitNullable((ParseTree)ctx.environmentSwitchNameSpecialNamesStatusPhrase()));
    }

    @Override
    public Object visitEnvironmentSwitchNameSpecialNamesStatusPhrase(CobolParser.EnvironmentSwitchNameSpecialNamesStatusPhraseContext ctx) {
        return new Cobol.EnvironmentSwitchNameSpecialNamesStatusPhrase(Space.EMPTY, Markers.EMPTY, this.convertAllList(Collections.singletonList(ctx.ON()), Collections.singletonList(ctx.OFF()), ctx.STATUS(), ctx.IS(), ctx.condition()));
    }

    @Override
    public Object visitErrorKeyClause(CobolParser.ErrorKeyClauseContext ctx) {
        return new Cobol.ErrorKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ERROR(), ctx.KEY(), ctx.IS()), (Name)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitEvaluateAlsoCondition(CobolParser.EvaluateAlsoConditionContext ctx) {
        return new Cobol.EvaluateAlsoCondition(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALSO()), (Cobol.EvaluateCondition)this.visit((ParseTree)ctx.evaluateCondition()));
    }

    @Override
    public Object visitEvaluateAlsoSelect(CobolParser.EvaluateAlsoSelectContext ctx) {
        return new Cobol.EvaluateAlso(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ALSO()), (Cobol)this.visit((ParseTree)ctx.evaluateSelect()));
    }

    @Override
    public Object visitEvaluateCondition(CobolParser.EvaluateConditionContext ctx) {
        return new Cobol.EvaluateCondition(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ANY(), ctx.NOT()), ctx.ANY() != null ? null : (Cobol)this.visit(new ParseTree[]{ctx.evaluateValue(), ctx.condition(), ctx.booleanLiteral()}), (Cobol.EvaluateThrough)this.visitNullable((ParseTree)ctx.evaluateThrough()));
    }

    @Override
    public Object visitEvaluateStatement(CobolParser.EvaluateStatementContext ctx) {
        return new Cobol.Evaluate(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.EVALUATE()), (Cobol)this.visit((ParseTree)ctx.evaluateSelect()), this.convertAll((List)ctx.evaluateAlsoSelect()), this.convertAll((List)ctx.evaluateWhenPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.evaluateWhenOther()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_EVALUATE()));
    }

    @Override
    public Object visitEvaluateThrough(CobolParser.EvaluateThroughContext ctx) {
        return new Cobol.EvaluateThrough(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.THROUGH(), ctx.THRU()}), (Cobol)this.visit((ParseTree)ctx.evaluateValue()));
    }

    @Override
    public Object visitEvaluateWhen(CobolParser.EvaluateWhenContext ctx) {
        return new Cobol.EvaluateWhen(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.WHEN()), (Cobol.EvaluateCondition)this.visit((ParseTree)ctx.evaluateCondition()), this.convertAll((List)ctx.evaluateAlsoCondition()));
    }

    @Override
    public Object visitEvaluateWhenOther(CobolParser.EvaluateWhenOtherContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WHEN(), ctx.OTHER()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitEvaluateWhenPhrase(CobolParser.EvaluateWhenPhraseContext ctx) {
        return new Cobol.EvaluateWhenPhrase(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.evaluateWhen()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitExecCicsStatement(CobolParser.ExecCicsStatementContext ctx) {
        return new Cobol.ExecCicsStatement(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.EXECCICSLINE()));
    }

    @Override
    public Object visitExecSqlImsStatement(CobolParser.ExecSqlImsStatementContext ctx) {
        return new Cobol.ExecSqlImsStatement(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.EXECSQLIMSLINE()));
    }

    @Override
    public Object visitExecSqlStatement(CobolParser.ExecSqlStatementContext ctx) {
        return new Cobol.ExecSqlStatement(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.EXECSQLLINE()));
    }

    @Override
    public Cobol.Exhibit visitExhibitStatement(CobolParser.ExhibitStatementContext ctx) {
        return new Cobol.Exhibit(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.EXHIBIT(), ctx.NAMED(), ctx.CHANGED()), this.convertAll((List)ctx.exhibitOperand()));
    }

    @Override
    public Object visitExitStatement(CobolParser.ExitStatementContext ctx) {
        ArrayList<Cobol.Word> paragraphName = null;
        if (ctx.paragraphName() != null) {
            paragraphName = new ArrayList<Cobol.Word>(3);
            paragraphName.add((Cobol.Word)this.visit((ParseTree)ctx.paragraphName()));
            paragraphName.add((Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
            paragraphName.add((Cobol.Word)this.visit((ParseTree)ctx.EXIT()));
        }
        return new Cobol.Exit(Space.EMPTY, Markers.EMPTY, paragraphName != null ? paragraphName : this.wordsList(ctx.EXIT(), ctx.PROGRAM(), ctx.METHOD(), ctx.PERFORM(), ctx.CYCLE(), ctx.SECTION(), ctx.PARAGRAPH()));
    }

    @Override
    public Object visitExternalClause(CobolParser.ExternalClauseContext ctx) {
        return new Cobol.ExternalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.EXTERNAL()));
    }

    @Override
    public Object visitFigurativeConstant(CobolParser.FigurativeConstantContext ctx) {
        return new Cobol.FigurativeConstant(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.ALL(), ctx.HIGH_VALUE(), ctx.HIGH_VALUES(), ctx.LOW_VALUE(), ctx.LOW_VALUES(), ctx.NULL(), ctx.NULLS(), ctx.QUOTE(), ctx.QUOTES(), ctx.SPACE(), ctx.SPACES(), ctx.ZERO(), ctx.ZEROS(), ctx.ZEROES()}), (Literal)this.visitNullable((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitFileControlEntry(CobolParser.FileControlEntryContext ctx) {
        return new Cobol.FileControlEntry(Space.EMPTY, Markers.EMPTY, (Cobol)this.visit((ParseTree)ctx.selectClause()), this.convertAllList(ctx.fileControlClause()));
    }

    @Override
    public Object visitFileControlParagraph(CobolParser.FileControlParagraphContext ctx) {
        return new Cobol.FileControlParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.FILE_CONTROL()), this.convertAllList(ctx.DOT_FS(), ctx.fileControlEntry()));
    }

    @Override
    public Cobol.FileDescriptionEntry visitFileDescriptionEntry(CobolParser.FileDescriptionEntryContext ctx) {
        return new Cobol.FileDescriptionEntry(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.FD(), ctx.SD()}), (Cobol.Word)this.visit((ParseTree)ctx.fileName()), this.convertAllList(ctx.DOT_FS(), ctx.COMMACHAR(), ctx.fileDescriptionEntryClause()), this.convertAll((List)ctx.dataDescriptionEntry()));
    }

    @Override
    public Cobol.FileSection visitFileSection(CobolParser.FileSectionContext ctx) {
        return new Cobol.FileSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FILE(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.fileDescriptionEntry()));
    }

    @Override
    public Object visitFileStatusClause(CobolParser.FileStatusClauseContext ctx) {
        return new Cobol.FileStatusClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FILE(), ctx.STATUS(), ctx.IS()), this.convertAll((List)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.FunctionCall visitFunctionCall(CobolParser.FunctionCallContext ctx) {
        return new Cobol.FunctionCall(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FUNCTION()), (Cobol.Word)this.visit((ParseTree)ctx.functionName()), this.convertAll((List)ctx.functionCallArguments()), (Cobol.ReferenceModifier)this.visitNullable((ParseTree)ctx.referenceModifier()));
    }

    @Override
    public Object visitFunctionCallArguments(CobolParser.FunctionCallArgumentsContext ctx) {
        return new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), this.convertAllList(ctx.argument(), ctx.COMMACHAR()), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
    }

    @Override
    public Object visitGenerateStatement(CobolParser.GenerateStatementContext ctx) {
        return new Cobol.Generate(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.GENERATE()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.reportName()));
    }

    @Override
    public Object visitGlobalClause(CobolParser.GlobalClauseContext ctx) {
        return new Cobol.GlobalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.GLOBAL()));
    }

    @Override
    public Object visitGoToDependingOnStatement(CobolParser.GoToDependingOnStatementContext ctx) {
        return new Cobol.GoToDependingOnStatement(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.procedureName()), this.wordsList(ctx.MORE_LABELS(), ctx.DEPENDING(), ctx.ON()), (Identifier)this.visitNullable((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitGoToStatement(CobolParser.GoToStatementContext ctx) {
        return new Cobol.GoTo(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.GO(), ctx.TO()), (Cobol)this.visit(new ParseTree[]{ctx.goToStatementSimple(), ctx.goToDependingOnStatement()}));
    }

    @Override
    public Object visitGobackStatement(CobolParser.GobackStatementContext ctx) {
        return new Cobol.GoBack(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.GOBACK()));
    }

    @Override
    public Cobol visitIdentificationDivision(CobolParser.IdentificationDivisionContext ctx) {
        return new Cobol.IdentificationDivision(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IDENTIFICATION(), ctx.ID(), ctx.DIVISION(), ctx.DOT_FS()), (Cobol.ProgramIdParagraph)this.visit((ParseTree)ctx.programIdParagraph()), this.convertAll((List)ctx.identificationDivisionBody()));
    }

    @Override
    public Object visitIfElse(CobolParser.IfElseContext ctx) {
        return new Cobol.IfElse(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ELSE()), this.wordsList(ctx.NEXT(), ctx.SENTENCE()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitIfStatement(CobolParser.IfStatementContext ctx) {
        return new Cobol.If(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.IF()), (Cobol.Condition)this.visit((ParseTree)ctx.condition()), (Cobol.IfThen)this.visit((ParseTree)ctx.ifThen()), (Cobol.IfElse)this.visitNullable((ParseTree)ctx.ifElse()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_IF()));
    }

    @Override
    public Object visitIfThen(CobolParser.IfThenContext ctx) {
        return new Cobol.IfThen(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.THEN()), this.wordsList(ctx.NEXT(), ctx.SENTENCE()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitInData(CobolParser.InDataContext ctx) {
        return new Cobol.InData(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.IN(), ctx.OF()}), (Name)this.visit((ParseTree)ctx.dataName()));
    }

    @Override
    public Object visitInFile(CobolParser.InFileContext ctx) {
        return new Cobol.InFile(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.IN(), ctx.OF()}), (Name)this.visit((ParseTree)ctx.fileName()));
    }

    @Override
    public Object visitInLibrary(CobolParser.InLibraryContext ctx) {
        return new Cobol.InLibrary(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.IN(), ctx.OF()}), (Name)this.visit((ParseTree)ctx.libraryName()));
    }

    @Override
    public Object visitInMnemonic(CobolParser.InMnemonicContext ctx) {
        return new Cobol.InMnemonic(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.IN(), ctx.OF()}), (Name)this.visit((ParseTree)ctx.mnemonicName()));
    }

    @Override
    public Cobol.InSection visitInSection(CobolParser.InSectionContext ctx) {
        return new Cobol.InSection(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.IN(), ctx.OF()}), (Name)this.visit((ParseTree)ctx.sectionName()));
    }

    @Override
    public Object visitInTable(CobolParser.InTableContext ctx) {
        return new Cobol.InLibrary(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.IN(), ctx.OF()}), (Name)this.visit((ParseTree)ctx.tableCall()));
    }

    @Override
    public Object visitInstallationParagraph(CobolParser.InstallationParagraphContext ctx) {
        return new Cobol.IdentificationDivisionParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INSTALLATION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()), null, null);
    }

    @Override
    public Object visitInitializeReplacingBy(CobolParser.InitializeReplacingByContext ctx) {
        return new Cobol.InitializeReplacingBy(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ALPHABETIC(), ctx.ALPHANUMERIC(), ctx.ALPHANUMERIC_EDITED(), ctx.NATIONAL(), ctx.NATIONAL_EDITED(), ctx.NUMERIC(), ctx.NUMERIC_EDITED(), ctx.DBCS(), ctx.EGCS(), ctx.DATA(), ctx.BY()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitInitializeReplacingPhrase(CobolParser.InitializeReplacingPhraseContext ctx) {
        return new Cobol.InitializeReplacingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REPLACING()), this.convertAll((List)ctx.initializeReplacingBy()));
    }

    @Override
    public Object visitInitializeStatement(CobolParser.InitializeStatementContext ctx) {
        return new Cobol.Initialize(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INITIALIZE()), this.convertAllList(ctx.identifier()), (Cobol.InitializeReplacingPhrase)this.visitNullable((ParseTree)ctx.initializeReplacingPhrase()));
    }

    @Override
    public Object visitInitiateStatement(CobolParser.InitiateStatementContext ctx) {
        return new Cobol.Initiate(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INITIATE()), this.convertAll((List)ctx.reportName()));
    }

    @Override
    public Object visitInputOutputSection(CobolParser.InputOutputSectionContext ctx) {
        return new Cobol.InputOutputSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.INPUT_OUTPUT(), ctx.SECTION(), ctx.DOT_FS()), this.convertAll((List)ctx.inputOutputSectionParagraph()));
    }

    @Override
    public Object visitInspectAllLeading(CobolParser.InspectAllLeadingContext ctx) {
        return new Cobol.InspectAllLeading(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), this.convertAll((List)ctx.inspectBeforeAfter()));
    }

    @Override
    public Object visitInspectAllLeadings(CobolParser.InspectAllLeadingsContext ctx) {
        return new Cobol.InspectAllLeadings(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.ALL(), ctx.LEADING()}), this.convertAll((List)ctx.inspectAllLeading()));
    }

    @Override
    public Object visitInspectBeforeAfter(CobolParser.InspectBeforeAfterContext ctx) {
        return new Cobol.InspectBeforeAfter(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BEFORE(), ctx.AFTER(), ctx.INITIAL()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitInspectBy(CobolParser.InspectByContext ctx) {
        return new Cobol.InspectBy(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.BY()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitInspectCharacters(CobolParser.InspectCharactersContext ctx) {
        return new Cobol.InspectCharacters(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.CHARACTER(), ctx.CHARACTERS()}), this.convertAll((List)ctx.inspectBeforeAfter()));
    }

    @Override
    public Object visitInspectConvertingPhrase(CobolParser.InspectConvertingPhraseContext ctx) {
        return new Cobol.InspectConvertingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.CONVERTING()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.InspectTo)this.visit((ParseTree)ctx.inspectTo()), this.convertAll((List)ctx.inspectBeforeAfter()));
    }

    @Override
    public Object visitInspectFor(CobolParser.InspectForContext ctx) {
        return new Cobol.InspectFor(Space.EMPTY, Markers.EMPTY, (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol.Word)this.visit((ParseTree)ctx.FOR()), this.convertAll(ctx.inspectCharacters(), ctx.inspectAllLeadings()));
    }

    @Override
    public Object visitInspectReplacingAllLeading(CobolParser.InspectReplacingAllLeadingContext ctx) {
        return new Cobol.InspectReplacingAllLeading(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.InspectBy)this.visit((ParseTree)ctx.inspectBy()), this.convertAll((List)ctx.inspectBeforeAfter()));
    }

    @Override
    public Object visitInspectReplacingAllLeadings(CobolParser.InspectReplacingAllLeadingsContext ctx) {
        return new Cobol.InspectReplacingAllLeadings(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.ALL(), ctx.LEADING(), ctx.FIRST()}), this.convertAll((List)ctx.inspectReplacingAllLeading()));
    }

    @Override
    public Object visitInspectReplacingCharacters(CobolParser.InspectReplacingCharactersContext ctx) {
        return new Cobol.InspectReplacingCharacters(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.CHARACTER(), ctx.CHARACTERS()}), (Cobol.InspectBy)this.visit((ParseTree)ctx.inspectBy()), this.convertAll((List)ctx.inspectBeforeAfter()));
    }

    @Override
    public Object visitInspectReplacingPhrase(CobolParser.InspectReplacingPhraseContext ctx) {
        return new Cobol.InspectReplacingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REPLACING()), this.convertAll(ctx.inspectReplacingCharacters(), ctx.inspectReplacingAllLeadings()));
    }

    @Override
    public Object visitInspectStatement(CobolParser.InspectStatementContext ctx) {
        return new Cobol.Inspect(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INSPECT()), (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol)this.visit(new ParseTree[]{ctx.inspectTallyingPhrase(), ctx.inspectReplacingPhrase(), ctx.inspectTallyingReplacingPhrase(), ctx.inspectConvertingPhrase()}));
    }

    @Override
    public Object visitInspectTallyingPhrase(CobolParser.InspectTallyingPhraseContext ctx) {
        return new Cobol.InspectTallyingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TALLYING()), this.convertAll((List)ctx.inspectFor()));
    }

    @Override
    public Object visitInspectTallyingReplacingPhrase(CobolParser.InspectTallyingReplacingPhraseContext ctx) {
        return new Cobol.InspectTallyingReplacingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TALLYING()), this.convertAll((List)ctx.inspectFor()), this.convertAll((List)ctx.inspectReplacingPhrase()));
    }

    @Override
    public Object visitInspectTo(CobolParser.InspectToContext ctx) {
        return new Cobol.InspectTo(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TO()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Cobol.StatementPhrase visitInvalidKeyPhrase(CobolParser.InvalidKeyPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.INVALID(), ctx.KEY()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitIoControlParagraph(CobolParser.IoControlParagraphContext ctx) {
        return new Cobol.IoControlParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.I_O_CONTROL()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(0)), (Cobol.Word)this.visitNullable((ParseTree)ctx.fileName()), ctx.fileName() == null ? null : (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1)), this.convertAll((List)ctx.ioControlClause()), ctx.ioControlClause().isEmpty() ? null : (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(ctx.DOT_FS().size() == 2 ? 1 : 2)));
    }

    @Override
    public Object visitLabelRecordsClause(CobolParser.LabelRecordsClauseContext ctx) {
        return new Cobol.LabelRecordsClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LABEL(), ctx.RECORD(), ctx.RECORDS(), ctx.IS(), ctx.ARE(), ctx.OMITTED(), ctx.STANDARD()), this.convertAll((List)ctx.dataName()));
    }

    @Override
    public Object visitLibraryAttributeClauseFormat1(CobolParser.LibraryAttributeClauseFormat1Context ctx) {
        return new Cobol.LibraryAttributeClauseFormat1(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ATTRIBUTE(), ctx.SHARING(), ctx.IS(), ctx.DONTCARE(), ctx.PRIVATE(), ctx.SHAREDBYRUNUNIT(), ctx.SHAREDBYALL()));
    }

    @Override
    public Object visitLibraryAttributeClauseFormat2(CobolParser.LibraryAttributeClauseFormat2Context ctx) {
        return new Cobol.LibraryAttributeClauseFormat2(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ATTRIBUTE()), (Cobol.LibraryAttributeFunction)this.visitNullable((ParseTree)ctx.libraryAttributeFunction()), this.wordsList(ctx.LIBACCESS(), ctx.IS(), ctx.BYFUNCTION(), ctx.BYTITLE()), (Cobol.LibraryAttributeParameter)this.visitNullable((ParseTree)ctx.libraryAttributeParameter()), (Cobol.LibraryAttributeTitle)this.visitNullable((ParseTree)ctx.libraryAttributeTitle()));
    }

    @Override
    public Object visitLibraryAttributeFunction(CobolParser.LibraryAttributeFunctionContext ctx) {
        return new Cobol.LibraryAttributeFunction(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FUNCTIONNAME(), ctx.IS()), (Name)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitLibraryAttributeParameter(CobolParser.LibraryAttributeParameterContext ctx) {
        return new Cobol.LibraryAttributeParameter(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LIBPARAMETER(), ctx.IS()), (Name)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitLibraryAttributeTitle(CobolParser.LibraryAttributeTitleContext ctx) {
        return new Cobol.LibraryAttributeTitle(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.TITLE(), ctx.IS()), (Name)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitLibraryDescriptionEntryFormat1(CobolParser.LibraryDescriptionEntryFormat1Context ctx) {
        return new Cobol.LibraryDescriptionEntryFormat1(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LD()), (Cobol.Word)this.visit((ParseTree)ctx.libraryName()), (Cobol.Word)this.visit((ParseTree)ctx.EXPORT()), (Cobol.LibraryAttributeClauseFormat1)this.visitNullable((ParseTree)ctx.libraryAttributeClauseFormat1()), (Cobol.LibraryEntryProcedureClauseFormat1)this.visitNullable((ParseTree)ctx.libraryEntryProcedureClauseFormat1()));
    }

    @Override
    public Object visitLibraryDescriptionEntryFormat2(CobolParser.LibraryDescriptionEntryFormat2Context ctx) {
        return new Cobol.LibraryDescriptionEntryFormat2(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LB()), (Cobol.Word)this.visit((ParseTree)ctx.libraryName()), (Cobol.Word)this.visit((ParseTree)ctx.IMPORT()), (Cobol.LibraryIsGlobalClause)this.visitNullable((ParseTree)ctx.libraryIsGlobalClause()), (Cobol.LibraryIsCommonClause)this.visitNullable((ParseTree)ctx.libraryIsCommonClause()), this.convertAll(ctx.libraryAttributeClauseFormat2(), ctx.libraryEntryProcedureClauseFormat2()));
    }

    @Override
    public Object visitLibraryEntryProcedureClauseFormat1(CobolParser.LibraryEntryProcedureClauseFormat1Context ctx) {
        return new Cobol.LibraryEntryProcedureClauseFormat1(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ENTRY_PROCEDURE()), (Cobol.Word)this.visit((ParseTree)ctx.programName()), (Cobol.LibraryEntryProcedureForClause)this.visitNullable((ParseTree)ctx.libraryEntryProcedureForClause()));
    }

    @Override
    public Object visitLibraryEntryProcedureClauseFormat2(CobolParser.LibraryEntryProcedureClauseFormat2Context ctx) {
        return new Cobol.LibraryEntryProcedureClauseFormat2(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ENTRY_PROCEDURE()), (Cobol.Word)this.visit((ParseTree)ctx.programName()), (Cobol.LibraryEntryProcedureForClause)this.visitNullable((ParseTree)ctx.libraryEntryProcedureForClause()), (Cobol.LibraryEntryProcedureWithClause)this.visitNullable((ParseTree)ctx.libraryEntryProcedureWithClause()), (Cobol.LibraryEntryProcedureUsingClause)this.visitNullable((ParseTree)ctx.libraryEntryProcedureUsingClause()), (Cobol.LibraryEntryProcedureGivingClause)this.visitNullable((ParseTree)ctx.libraryEntryProcedureGivingClause()));
    }

    @Override
    public Object visitLibraryEntryProcedureForClause(CobolParser.LibraryEntryProcedureForClauseContext ctx) {
        return new Cobol.LibraryEntryProcedureForClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FOR()), (Name)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitLibraryEntryProcedureGivingClause(CobolParser.LibraryEntryProcedureGivingClauseContext ctx) {
        return new Cobol.LibraryEntryProcedureGivingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.GIVING()), (Cobol.Word)this.visit((ParseTree)ctx.dataName()));
    }

    @Override
    public Object visitLibraryEntryProcedureUsingClause(CobolParser.LibraryEntryProcedureUsingClauseContext ctx) {
        return new Cobol.LibraryEntryProcedureUsingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.USING()), this.convertAll((List)ctx.libraryEntryProcedureUsingName()));
    }

    @Override
    public Object visitLibraryEntryProcedureWithClause(CobolParser.LibraryEntryProcedureWithClauseContext ctx) {
        return new Cobol.LibraryEntryProcedureWithClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.WITH()), this.convertAll((List)ctx.libraryEntryProcedureWithName()));
    }

    @Override
    public Object visitLibraryIsCommonClause(CobolParser.LibraryIsCommonClauseContext ctx) {
        return new Cobol.LibraryIsCommonClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.COMMON()));
    }

    @Override
    public Object visitLibraryIsGlobalClause(CobolParser.LibraryIsGlobalClauseContext ctx) {
        return new Cobol.LibraryIsGlobalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.GLOBAL()));
    }

    @Override
    public Object visitLinageClause(CobolParser.LinageClauseContext ctx) {
        return new Cobol.LinageClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LINAGE(), ctx.IS()), (Name)this.visit(new ParseTree[]{ctx.dataName(), ctx.integerLiteral()}), (Cobol.Word)this.visitNullable((ParseTree)ctx.LINES()), this.convertAll((List)ctx.linageAt()));
    }

    @Override
    public Object visitLinageFootingAt(CobolParser.LinageFootingAtContext ctx) {
        return new Cobol.LinageFootingAt(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.FOOTING(), ctx.AT()), (Name)this.visit(new ParseTree[]{ctx.dataName(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitLinageLinesAtBottom(CobolParser.LinageLinesAtBottomContext ctx) {
        return new Cobol.LinageLinesAtBottom(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LINES(), ctx.AT(), ctx.BOTTOM()), (Name)this.visit(new ParseTree[]{ctx.dataName(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitLinageLinesAtTop(CobolParser.LinageLinesAtTopContext ctx) {
        return new Cobol.LinageLinesAtTop(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LINES(), ctx.AT(), ctx.TOP()), (Name)this.visit(new ParseTree[]{ctx.dataName(), ctx.integerLiteral()}));
    }

    @Override
    public Cobol.LinkageSection visitLinkageSection(CobolParser.LinkageSectionContext ctx) {
        return new Cobol.LinkageSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LINKAGE(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.dataDescriptionEntry()));
    }

    @Override
    public Cobol.LocalStorageSection visitLocalStorageSection(CobolParser.LocalStorageSectionContext ctx) {
        return new Cobol.LocalStorageSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LOCAL_STORAGE(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS().get(0)), (Cobol.Word)this.visitNullable((ParseTree)ctx.LD()), (Name)this.visitNullable((ParseTree)ctx.localName()), ctx.DOT_FS().size() == 1 ? null : (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS().get(1)), this.convertAll((List)ctx.dataDescriptionEntry()));
    }

    @Override
    public Cobol.ValuedObjectComputerClause visitMemorySizeClause(CobolParser.MemorySizeClauseContext ctx) {
        return new Cobol.ValuedObjectComputerClause(Space.EMPTY, Markers.EMPTY, Cobol.ValuedObjectComputerClause.Type.Memory, this.wordsList(ctx.MEMORY(), ctx.SIZE()), (Cobol)this.visit((ParseTree)(ctx.integerLiteral() == null ? ctx.cobolWord() : ctx.integerLiteral())), ctx.WORDS() != null ? (Cobol.Word)this.visit((ParseTree)ctx.WORDS()) : (ctx.CHARACTERS() != null ? (Cobol.Word)this.visit((ParseTree)ctx.CHARACTERS()) : (ctx.MODULES() != null ? (Cobol.Word)this.visit((ParseTree)ctx.MODULES()) : null)));
    }

    @Override
    public Cobol.Mergeable visitMergeCollatingAlphanumeric(CobolParser.MergeCollatingAlphanumericContext ctx) {
        return new Cobol.Mergeable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.ALPHANUMERIC(), ctx.IS()), (Name)this.visit((ParseTree)ctx.alphabetName()));
    }

    @Override
    public Cobol.Mergeable visitMergeCollatingNational(CobolParser.MergeCollatingNationalContext ctx) {
        return new Cobol.Mergeable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.NATIONAL(), ctx.IS()), (Name)this.visit((ParseTree)ctx.alphabetName()));
    }

    @Override
    public Cobol.MergeCollatingSequencePhrase visitMergeCollatingSequencePhrase(CobolParser.MergeCollatingSequencePhraseContext ctx) {
        return new Cobol.MergeCollatingSequencePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COLLATING(), ctx.SEQUENCE(), ctx.IS()), this.convertAll((List)ctx.alphabetName()), (Cobol.Mergeable)this.visitNullable((ParseTree)ctx.mergeCollatingAlphanumeric()), (Cobol.Mergeable)this.visitNullable((ParseTree)ctx.mergeCollatingNational()));
    }

    @Override
    public Cobol.MergeGiving visitMergeGiving(CobolParser.MergeGivingContext ctx) {
        return new Cobol.MergeGiving(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.fileName()), this.wordsList(ctx.LOCK(), ctx.SAVE(), ctx.NO(), ctx.REWIND(), ctx.RELEASE(), ctx.WITH(), ctx.REMOVE(), ctx.CRUNCH()));
    }

    @Override
    public Cobol.MergeGivingPhrase visitMergeGivingPhrase(CobolParser.MergeGivingPhraseContext ctx) {
        return new Cobol.MergeGivingPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.GIVING()), this.convertAll((List)ctx.mergeGiving()));
    }

    @Override
    public Cobol.MergeOnKeyClause visitMergeOnKeyClause(CobolParser.MergeOnKeyClauseContext ctx) {
        return new Cobol.MergeOnKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ON(), ctx.ASCENDING(), ctx.DESCENDING(), ctx.KEY()), this.convertAll((List)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.MergeOutputProcedurePhrase visitMergeOutputProcedurePhrase(CobolParser.MergeOutputProcedurePhraseContext ctx) {
        return new Cobol.MergeOutputProcedurePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.OUTPUT(), ctx.PROCEDURE(), ctx.IS()), this.visitProcedureName(ctx.procedureName()), (Cobol.MergeOutputThrough)this.visitNullable((ParseTree)ctx.mergeOutputThrough()));
    }

    @Override
    public Cobol.MergeOutputThrough visitMergeOutputThrough(CobolParser.MergeOutputThroughContext ctx) {
        return new Cobol.MergeOutputThrough(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.THROUGH(), ctx.THRU()}), this.visitProcedureName(ctx.procedureName()));
    }

    @Override
    public Cobol.Merge visitMergeStatement(CobolParser.MergeStatementContext ctx) {
        return new Cobol.Merge(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.MERGE()), (Name)this.visit((ParseTree)ctx.fileName()), this.convertAll((List)ctx.mergeOnKeyClause()), (Cobol.MergeCollatingSequencePhrase)this.visitNullable((ParseTree)ctx.mergeCollatingSequencePhrase()), this.convertAll((List)ctx.mergeUsing()), (Cobol.MergeOutputProcedurePhrase)this.visitNullable((ParseTree)ctx.mergeOutputProcedurePhrase()), this.convertAll((List)ctx.mergeGivingPhrase()));
    }

    @Override
    public Cobol.MergeUsing visitMergeUsing(CobolParser.MergeUsingContext ctx) {
        return new Cobol.MergeUsing(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.USING()), this.convertAll((List)ctx.fileName()));
    }

    @Override
    public Object visitMessageCountClause(CobolParser.MessageCountClauseContext ctx) {
        return new Cobol.MessageCountClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.MESSAGE(), ctx.COUNT(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitMessageDateClause(CobolParser.MessageDateClauseContext ctx) {
        return new Cobol.MessageDateClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.MESSAGE(), ctx.DATE(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitMessageTimeClause(CobolParser.MessageTimeClauseContext ctx) {
        return new Cobol.MessageTimeClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.MESSAGE(), ctx.TIME(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Cobol.MoveCorrespondingToStatement visitMoveCorrespondingToStatement(CobolParser.MoveCorrespondingToStatementContext ctx) {
        return new Cobol.MoveCorrespondingToStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.CORRESPONDING(), ctx.CORR()}), (Identifier)this.visit((ParseTree)ctx.moveCorrespondingToSendingArea()), (Cobol.Word)this.visit((ParseTree)ctx.TO()), this.convertAll((List)ctx.identifier()));
    }

    @Override
    public Cobol.MoveStatement visitMoveStatement(CobolParser.MoveStatementContext ctx) {
        return new Cobol.MoveStatement(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.MOVE(), ctx.ALL()), (Cobol)this.visit(new ParseTree[]{ctx.moveCorrespondingToStatement(), ctx.moveToStatement()}));
    }

    @Override
    public Cobol.MoveToStatement visitMoveToStatement(CobolParser.MoveToStatementContext ctx) {
        return new Cobol.MoveToStatement(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.moveToSendingArea()), (Cobol.Word)this.visit((ParseTree)ctx.TO()), this.convertAllList(ctx.identifier()));
    }

    @Override
    public Object visitMultDiv(CobolParser.MultDivContext ctx) {
        return new Cobol.MultDiv(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.ASTERISKCHAR(), ctx.SLASHCHAR()}), (Cobol.Powers)this.visit((ParseTree)ctx.powers()));
    }

    @Override
    public Object visitMultDivs(CobolParser.MultDivsContext ctx) {
        return new Cobol.MultDivs(Space.EMPTY, Markers.EMPTY, (Cobol.Powers)this.visit((ParseTree)ctx.powers()), this.convertAll((List)ctx.multDiv()));
    }

    @Override
    public Object visitMultipleFileClause(CobolParser.MultipleFileClauseContext ctx) {
        return new Cobol.MultipleFileClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.MULTIPLE(), ctx.FILE(), ctx.TAPE(), ctx.CONTAINS()), this.convertAll((List)ctx.multipleFilePosition()));
    }

    @Override
    public Object visitMultipleFilePosition(CobolParser.MultipleFilePositionContext ctx) {
        return new Cobol.MultipleFilePosition(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.fileName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.POSITION()), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Cobol.MultiplyGiving visitMultiplyGiving(CobolParser.MultiplyGivingContext ctx) {
        return new Cobol.MultiplyGiving(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.multiplyGivingOperand()), (Cobol.Word)this.visit((ParseTree)ctx.GIVING()), this.convertAll((List)ctx.multiplyGivingResult()));
    }

    @Override
    public Cobol.MultiplyRegular visitMultiplyRegular(CobolParser.MultiplyRegularContext ctx) {
        return new Cobol.MultiplyRegular(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.multiplyRegularOperand()));
    }

    @Override
    public Cobol.Multiply visitMultiplyStatement(CobolParser.MultiplyStatementContext ctx) {
        return new Cobol.Multiply(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.MULTIPLY()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.Word)this.visit((ParseTree)ctx.BY()), (Cobol)this.visit(new ParseTree[]{ctx.multiplyRegular(), ctx.multiplyGiving()}), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onSizeErrorPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnSizeErrorPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_MULTIPLY()));
    }

    @Override
    public Cobol.NextSentence visitNextSentenceStatement(CobolParser.NextSentenceStatementContext ctx) {
        return new Cobol.NextSentence(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NEXT(), ctx.SENTENCE()));
    }

    @Override
    public Cobol.StatementPhrase visitNotAtEndPhrase(CobolParser.NotAtEndPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NOT(), ctx.AT(), ctx.END()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.StatementPhrase visitNotInvalidKeyPhrase(CobolParser.NotInvalidKeyPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NOT(), ctx.INVALID(), ctx.KEY()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitNotOnExceptionClause(CobolParser.NotOnExceptionClauseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NOT(), ctx.ON(), ctx.EXCEPTION()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.StatementPhrase visitNotOnOverflowPhrase(CobolParser.NotOnOverflowPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NOT(), ctx.ON(), ctx.OVERFLOW()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.StatementPhrase visitNotOnSizeErrorPhrase(CobolParser.NotOnSizeErrorPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NOT(), ctx.ON(), ctx.SIZE(), ctx.ERROR()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.ObjectComputer visitObjectComputerParagraph(CobolParser.ObjectComputerParagraphContext ctx) {
        return new Cobol.ObjectComputer(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.OBJECT_COMPUTER(), ctx.DOT_FS(0)), ctx.computerName() == null ? null : new Cobol.ObjectComputerDefinition(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.computerName()), this.convertAll((List)ctx.objectComputerClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1))));
    }

    @Override
    public Cobol.OdtClause visitOdtClause(CobolParser.OdtClauseContext ctx) {
        return new Cobol.OdtClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ODT(), ctx.IS()), (Identifier)this.visit((ParseTree)ctx.mnemonicName()));
    }

    @Override
    public Object visitOnExceptionClause(CobolParser.OnExceptionClauseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ON(), ctx.EXCEPTION()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.StatementPhrase visitOnOverflowPhrase(CobolParser.OnOverflowPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ON(), ctx.OVERFLOW()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitOnSizeErrorPhrase(CobolParser.OnSizeErrorPhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ON(), ctx.SIZE(), ctx.ERROR()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.OpenIOExtendStatement visitOpenExtendStatement(CobolParser.OpenExtendStatementContext ctx) {
        return new Cobol.OpenIOExtendStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.EXTEND()), this.convertAllList(ctx.fileName()));
    }

    @Override
    public Cobol.OpenIOExtendStatement visitOpenIOStatement(CobolParser.OpenIOStatementContext ctx) {
        return new Cobol.OpenIOExtendStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.I_O()), this.convertAllList(ctx.fileName()));
    }

    @Override
    public Cobol.Openable visitOpenInput(CobolParser.OpenInputContext ctx) {
        return new Cobol.Openable(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.fileName()), this.wordsList(ctx.REVERSED(), ctx.WITH(), ctx.NO(), ctx.REWIND()));
    }

    @Override
    public Cobol.OpenInputOutputStatement visitOpenInputStatement(CobolParser.OpenInputStatementContext ctx) {
        return new Cobol.OpenInputOutputStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INPUT()), this.convertAllList(ctx.openInput()));
    }

    @Override
    public Cobol.Openable visitOpenOutput(CobolParser.OpenOutputContext ctx) {
        return new Cobol.Openable(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.fileName()), this.wordsList(ctx.WITH(), ctx.NO(), ctx.REWIND()));
    }

    @Override
    public Cobol.OpenInputOutputStatement visitOpenOutputStatement(CobolParser.OpenOutputStatementContext ctx) {
        return new Cobol.OpenInputOutputStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.OUTPUT()), this.convertAllList(ctx.openOutput()));
    }

    @Override
    public Cobol.Open visitOpenStatement(CobolParser.OpenStatementContext ctx) {
        return new Cobol.Open(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.OPEN()), this.convertAllList(ctx.openInputStatement(), ctx.openOutputStatement(), ctx.openIOStatement(), ctx.openExtendStatement()));
    }

    @Override
    public Object visitOrganizationClause(CobolParser.OrganizationClauseContext ctx) {
        return new Cobol.OrganizationClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ORGANIZATION(), ctx.IS(), ctx.LINE(), ctx.RECORD(), ctx.BINARY(), ctx.SEQUENTIAL(), ctx.RELATIVE(), ctx.INDEXED()));
    }

    @Override
    public Object visitPaddingCharacterClause(CobolParser.PaddingCharacterClauseContext ctx) {
        return new Cobol.PaddingCharacterClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PADDING(), ctx.CHARACTER(), ctx.IS()), (Name)this.visit(new ParseTree[]{ctx.qualifiedDataName(), ctx.literal()}));
    }

    @Override
    public Object visitParagraph(CobolParser.ParagraphContext ctx) {
        return new Cobol.Paragraph(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.paragraphName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.DOT_FS()), (Cobol.AlteredGoTo)this.visitNullable((ParseTree)ctx.alteredGoTo()), this.convertAll((List)ctx.sentence()));
    }

    @Override
    public Cobol.Paragraphs visitParagraphs(CobolParser.ParagraphsContext ctx) {
        return new Cobol.Paragraphs(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.sentence()), this.convertAll((List)ctx.paragraph()));
    }

    @Override
    public Object visitPasswordClause(CobolParser.PasswordClauseContext ctx) {
        return new Cobol.PasswordClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PASSWORD(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataName()));
    }

    @Override
    public Cobol.Performable visitPerformAfter(CobolParser.PerformAfterContext ctx) {
        return new Cobol.Performable(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.AFTER()), (Cobol)this.visit((ParseTree)ctx.performVaryingPhrase()));
    }

    @Override
    public Cobol.Performable visitPerformBy(CobolParser.PerformByContext ctx) {
        return new Cobol.Performable(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.BY()), (Cobol)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal(), ctx.arithmeticExpression()}));
    }

    @Override
    public Cobol.Performable visitPerformFrom(CobolParser.PerformFromContext ctx) {
        return new Cobol.Performable(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Cobol)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal(), ctx.arithmeticExpression()}));
    }

    @Override
    public Cobol.PerformInlineStatement visitPerformInlineStatement(CobolParser.PerformInlineStatementContext ctx) {
        return new Cobol.PerformInlineStatement(Space.EMPTY, Markers.EMPTY, (Cobol)this.visitNullable((ParseTree)ctx.performType()), this.convertAll((List)ctx.statement()), (Cobol.Word)this.visit((ParseTree)ctx.END_PERFORM()));
    }

    @Override
    public Cobol.PerformProcedureStatement visitPerformProcedureStatement(CobolParser.PerformProcedureStatementContext ctx) {
        return new Cobol.PerformProcedureStatement(Space.EMPTY, Markers.EMPTY, (Cobol.ProcedureName)this.visit((ParseTree)ctx.procedureName(0)), ctx.THROUGH() != null ? (Cobol.Word)this.visit((ParseTree)ctx.THROUGH()) : (ctx.THRU() != null ? (Cobol.Word)this.visit((ParseTree)ctx.THRU()) : null), ctx.procedureName().size() > 1 ? (Cobol.ProcedureName)this.visit((ParseTree)ctx.procedureName(1)) : null, (Cobol)this.visitNullable((ParseTree)ctx.performType()));
    }

    @Override
    public Cobol.Perform visitPerformStatement(CobolParser.PerformStatementContext ctx) {
        return new Cobol.Perform(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.PERFORM()), (Cobol)this.visit(new ParseTree[]{ctx.performInlineStatement(), ctx.performProcedureStatement()}));
    }

    @Override
    public Cobol.PerformTestClause visitPerformTestClause(CobolParser.PerformTestClauseContext ctx) {
        return new Cobol.PerformTestClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.TEST(), ctx.BEFORE(), ctx.AFTER()));
    }

    @Override
    public Cobol.PerformTimes visitPerformTimes(CobolParser.PerformTimesContext ctx) {
        return new Cobol.PerformTimes(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}), (Cobol.Word)this.visit((ParseTree)ctx.TIMES()));
    }

    @Override
    public Cobol.PerformUntil visitPerformUntil(CobolParser.PerformUntilContext ctx) {
        return new Cobol.PerformUntil(Space.EMPTY, Markers.EMPTY, (Cobol.PerformTestClause)this.visitNullable((ParseTree)ctx.performTestClause()), (Cobol.Word)this.visit((ParseTree)ctx.UNTIL()), (Cobol.Condition)this.visit((ParseTree)ctx.condition()));
    }

    @Override
    public Cobol.PerformVarying visitPerformVarying(CobolParser.PerformVaryingContext ctx) {
        return new Cobol.PerformVarying(Space.EMPTY, Markers.EMPTY, this.convertAllList(Collections.singletonList(ctx.performVaryingClause()), Collections.singletonList(ctx.performTestClause())));
    }

    @Override
    public Cobol.PerformVaryingClause visitPerformVaryingClause(CobolParser.PerformVaryingClauseContext ctx) {
        return new Cobol.PerformVaryingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.VARYING()), (Cobol.PerformVaryingPhrase)this.visit((ParseTree)ctx.performVaryingPhrase()), this.convertAll((List)ctx.performAfter()));
    }

    @Override
    public Cobol.PerformVaryingPhrase visitPerformVaryingPhrase(CobolParser.PerformVaryingPhraseContext ctx) {
        return new Cobol.PerformVaryingPhrase(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.Performable)this.visit((ParseTree)ctx.performFrom()), (Cobol.Performable)this.visit((ParseTree)ctx.performBy()), (Cobol.PerformUntil)this.visit((ParseTree)ctx.performUntil()));
    }

    @Override
    public Cobol.Picture visitPicture(CobolParser.PictureContext ctx) {
        return new Cobol.Picture(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.pictureChars()), (Cobol.Parenthesized)this.visitNullable((ParseTree)ctx.pictureCardinality()));
    }

    @Override
    public Object visitPictureCardinality(CobolParser.PictureCardinalityContext ctx) {
        return new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), Collections.singletonList((Cobol)this.visit((ParseTree)ctx.integerLiteral())), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
    }

    @Override
    public Object visitPictureString(CobolParser.PictureStringContext ctx) {
        return new Cobol.PictureString(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.picture()));
    }

    @Override
    public Object visitPlusMinus(CobolParser.PlusMinusContext ctx) {
        return new Cobol.PlusMinus(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.PLUSCHAR(), ctx.MINUSCHAR()}), (Cobol.MultDivs)this.visit((ParseTree)ctx.multDivs()));
    }

    @Override
    public Object visitPower(CobolParser.PowerContext ctx) {
        return new Cobol.Power(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DOUBLEASTERISKCHAR()), (Cobol)this.visit((ParseTree)ctx.basis()));
    }

    @Override
    public Object visitPowers(CobolParser.PowersContext ctx) {
        return new Cobol.Powers(Space.EMPTY, Markers.EMPTY, ctx.PLUSCHAR() != null ? (Cobol.Word)this.visit((ParseTree)ctx.PLUSCHAR()) : (ctx.MINUSCHAR() != null ? (Cobol.Word)this.visit((ParseTree)ctx.MINUSCHAR()) : null), (Cobol)this.visit((ParseTree)ctx.basis()), this.convertAll((List)ctx.power()));
    }

    @Override
    public Object visitProcedureDeclarative(CobolParser.ProcedureDeclarativeContext ctx) {
        return new Cobol.ProcedureDeclarative(Space.EMPTY, Markers.EMPTY, (Cobol.ProcedureSectionHeader)this.visit((ParseTree)ctx.procedureSectionHeader()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(0)), (Cobol.UseStatement)this.visit((ParseTree)ctx.useStatement()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1)), (Cobol.Paragraphs)this.visit((ParseTree)ctx.paragraphs()));
    }

    @Override
    public Object visitProcedureDeclaratives(CobolParser.ProcedureDeclarativesContext ctx) {
        return new Cobol.ProcedureDeclaratives(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.DECLARATIVES(0)), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(0)), this.convertAll((List)ctx.procedureDeclarative()), this.wordsList(ctx.END(), ctx.DECLARATIVES(1)), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1)));
    }

    @Override
    public Cobol.ProcedureDivision visitProcedureDivision(CobolParser.ProcedureDivisionContext ctx) {
        return new Cobol.ProcedureDivision(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PROCEDURE(), ctx.DIVISION()), (Cobol.ProcedureDivisionUsingClause)this.visitNullable((ParseTree)ctx.procedureDivisionUsingClause()), (Cobol.ProcedureDivisionGivingClause)this.visitNullable((ParseTree)ctx.procedureDivisionGivingClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.ProcedureDeclaratives)this.visitNullable((ParseTree)ctx.procedureDeclaratives()), (Cobol.ProcedureDivisionBody)this.visit((ParseTree)ctx.procedureDivisionBody()));
    }

    @Override
    public Cobol.ProcedureDivisionBody visitProcedureDivisionBody(CobolParser.ProcedureDivisionBodyContext ctx) {
        return new Cobol.ProcedureDivisionBody(Space.EMPTY, Markers.EMPTY, (Cobol.Paragraphs)this.visit((ParseTree)ctx.paragraphs()), this.convertAll((List)ctx.procedureSection()));
    }

    @Override
    public Cobol.ProcedureDivisionByReference visitProcedureDivisionByReference(CobolParser.ProcedureDivisionByReferenceContext ctx) {
        if (ctx.ANY() == null) {
            return new Cobol.ProcedureDivisionByReference(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.OPTIONAL()), ctx.identifier() == null ? (Name)this.visit((ParseTree)ctx.fileName()) : (Name)this.visit((ParseTree)ctx.identifier()));
        }
        return new Cobol.ProcedureDivisionByReference(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ANY()), null);
    }

    @Override
    public Cobol.ProcedureDivisionByReferencePhrase visitProcedureDivisionByReferencePhrase(CobolParser.ProcedureDivisionByReferencePhraseContext ctx) {
        return new Cobol.ProcedureDivisionByReferencePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BY(), ctx.REFERENCE()), this.convertAll((List)ctx.procedureDivisionByReference()));
    }

    @Override
    public Cobol.ProcedureDivisionByValuePhrase visitProcedureDivisionByValuePhrase(CobolParser.ProcedureDivisionByValuePhraseContext ctx) {
        return new Cobol.ProcedureDivisionByValuePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BY(), ctx.VALUE()), this.convertAll((List)ctx.procedureDivisionByValue()));
    }

    @Override
    public Object visitProcedureDivisionGivingClause(CobolParser.ProcedureDivisionGivingClauseContext ctx) {
        return new Cobol.ProcedureDivisionGivingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.GIVING(), ctx.RETURNING()}), (Name)this.visit((ParseTree)ctx.dataName()));
    }

    @Override
    public Cobol.ProcedureDivisionUsingClause visitProcedureDivisionUsingClause(CobolParser.ProcedureDivisionUsingClauseContext ctx) {
        return new Cobol.ProcedureDivisionUsingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.USING(), ctx.CHAINING()}), this.convertAllList(ctx.procedureDivisionUsingParameter()));
    }

    @Override
    public Cobol.ProcedureName visitProcedureName(CobolParser.ProcedureNameContext ctx) {
        return new Cobol.ProcedureName(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.paragraphName()), (Cobol.InSection)this.visitNullable((ParseTree)ctx.inSection()), (Name)this.visitNullable((ParseTree)ctx.sectionName()));
    }

    @Override
    public Object visitProcedureSection(CobolParser.ProcedureSectionContext ctx) {
        return new Cobol.ProcedureSection(Space.EMPTY, Markers.EMPTY, (Cobol.ProcedureSectionHeader)this.visit((ParseTree)ctx.procedureSectionHeader()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.Paragraphs)this.visit((ParseTree)ctx.paragraphs()));
    }

    @Override
    public Object visitProcedureSectionHeader(CobolParser.ProcedureSectionHeaderContext ctx) {
        return new Cobol.ProcedureSectionHeader(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.sectionName()), (Cobol.Word)this.visit((ParseTree)ctx.SECTION()), (Name)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Cobol.ProgramIdParagraph visitProgramIdParagraph(CobolParser.ProgramIdParagraphContext ctx) {
        return new Cobol.ProgramIdParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.PROGRAM_ID()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(0)), (Name)this.visit((ParseTree)ctx.programName()), this.wordsList(ctx.IS(), ctx.COMMON(), ctx.INITIAL(), ctx.LIBRARY(), ctx.DEFINITION(), ctx.RECURSIVE(), ctx.PROGRAM()), ctx.DOT_FS().size() == 1 ? null : (Cobol.Word)this.visitNullable((ParseTree)ctx.DOT_FS(1)), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()));
    }

    @Override
    public Object visitProgramLibrarySection(CobolParser.ProgramLibrarySectionContext ctx) {
        return new Cobol.ProgramLibrarySection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PROGRAM_LIBRARY(), ctx.SECTION(), ctx.DOT_FS()), this.convertAll((List)ctx.libraryDescriptionEntry()));
    }

    @Override
    public Cobol.ProgramUnit visitProgramUnit(CobolParser.ProgramUnitContext ctx) {
        List<CobolPreprocessor.CompilerOptions> compilerOptions = this.getCompilerOptions();
        return new Cobol.ProgramUnit(Space.EMPTY, Markers.EMPTY, compilerOptions, (Cobol.IdentificationDivision)this.visit((ParseTree)ctx.identificationDivision()), (Cobol.EnvironmentDivision)this.visitNullable((ParseTree)ctx.environmentDivision()), (Cobol.DataDivision)this.visitNullable((ParseTree)ctx.dataDivision()), (Cobol.ProcedureDivision)this.visitNullable((ParseTree)ctx.procedureDivision()), this.convertAll((List)ctx.programUnit()), (Cobol.EndProgram)this.visitNullable((ParseTree)ctx.endProgramStatement()));
    }

    @Override
    public Cobol.Purge visitPurgeStatement(CobolParser.PurgeStatementContext ctx) {
        return new Cobol.Purge(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.PURGE()), this.convertAll((List)ctx.cdName()));
    }

    @Override
    public Object visitQualifiedDataName(CobolParser.QualifiedDataNameContext ctx) {
        return new Cobol.QualifiedDataName(Space.EMPTY, Markers.EMPTY, (Cobol)this.visit(new ParseTree[]{ctx.qualifiedDataNameFormat1(), ctx.qualifiedDataNameFormat1(), ctx.qualifiedDataNameFormat3(), ctx.qualifiedDataNameFormat4()}));
    }

    @Override
    public Object visitQualifiedDataNameFormat1(CobolParser.QualifiedDataNameFormat1Context ctx) {
        return new Cobol.QualifiedDataNameFormat1(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.dataName(), ctx.conditionName()}), this.convertAll((List)ctx.qualifiedInData()), (Cobol.InFile)this.visitNullable((ParseTree)ctx.inFile()));
    }

    @Override
    public Object visitQualifiedDataNameFormat2(CobolParser.QualifiedDataNameFormat2Context ctx) {
        return new Cobol.QualifiedDataNameFormat2(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.paragraphName()), (Cobol.InSection)this.visit((ParseTree)ctx.inSection()));
    }

    @Override
    public Object visitQualifiedDataNameFormat3(CobolParser.QualifiedDataNameFormat3Context ctx) {
        return new Cobol.QualifiedDataNameFormat3(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.textName()), (Cobol.InLibrary)this.visit((ParseTree)ctx.inLibrary()));
    }

    @Override
    public Object visitQualifiedDataNameFormat4(CobolParser.QualifiedDataNameFormat4Context ctx) {
        return new Cobol.QualifiedDataNameFormat4(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.LINAGE_COUNTER()), (Cobol.InFile)this.visit((ParseTree)ctx.inFile()));
    }

    @Override
    public Object visitQualifiedInData(CobolParser.QualifiedInDataContext ctx) {
        return new Cobol.QualifiedDataName(Space.EMPTY, Markers.EMPTY, (Cobol)this.visit(new ParseTree[]{ctx.inData(), ctx.inTable()}));
    }

    @Override
    public Cobol.ReadInto visitReadInto(CobolParser.ReadIntoContext ctx) {
        return new Cobol.ReadInto(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTO()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Cobol.ReadKey visitReadKey(CobolParser.ReadKeyContext ctx) {
        return new Cobol.ReadKey(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.KEY(), ctx.IS()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.Read visitReadStatement(CobolParser.ReadStatementContext ctx) {
        return new Cobol.Read(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.READ()), (Name)this.visit((ParseTree)ctx.fileName()), this.wordsList(ctx.NEXT(), ctx.RECORD()), (Cobol.ReadInto)this.visitNullable((ParseTree)ctx.readInto()), (Cobol.ReadWith)this.visitNullable((ParseTree)ctx.readWith()), (Cobol.ReadKey)this.visitNullable((ParseTree)ctx.readKey()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.invalidKeyPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notInvalidKeyPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.atEndPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notAtEndPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_READ()));
    }

    @Override
    public Cobol.ReadWith visitReadWith(CobolParser.ReadWithContext ctx) {
        return new Cobol.ReadWith(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.KEPT(), ctx.NO(), ctx.LOCK(), ctx.WAIT()));
    }

    @Override
    public Cobol.Receivable visitReceiveBefore(CobolParser.ReceiveBeforeContext ctx) {
        return new Cobol.Receivable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BEFORE(), ctx.TIME()), (Name)this.visit(new ParseTree[]{ctx.numericLiteral(), ctx.identifier()}));
    }

    @Override
    public Cobol.ReceiveFrom visitReceiveFrom(CobolParser.ReceiveFromContext ctx) {
        return new Cobol.ReceiveFrom(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LAST(), ctx.ANY(), ctx.THREAD()), (Cobol.Word)this.visitNullable((ParseTree)ctx.dataName()));
    }

    @Override
    public Cobol.ReceiveFromStatement visitReceiveFromStatement(CobolParser.ReceiveFromStatementContext ctx) {
        return new Cobol.ReceiveFromStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.dataName()), (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Cobol.ReceiveFrom)this.visit((ParseTree)ctx.receiveFrom()), this.convertAll(ctx.receiveBefore(), ctx.receiveWith(), ctx.receiveThread(), ctx.receiveSize(), ctx.receiveStatus()));
    }

    @Override
    public Cobol.ReceiveIntoStatement visitReceiveIntoStatement(CobolParser.ReceiveIntoStatementContext ctx) {
        return new Cobol.ReceiveIntoStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.cdName()), this.wordsList(ctx.MESSAGE(), ctx.SEGMENT(), ctx.INTO()), (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.receiveNoData()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.receiveWithData()));
    }

    @Override
    public Cobol.StatementPhrase visitReceiveNoData(CobolParser.ReceiveNoDataContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NO(), ctx.DATA()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.Receivable visitReceiveSize(CobolParser.ReceiveSizeContext ctx) {
        return new Cobol.Receivable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SIZE(), ctx.IN()), (Name)this.visit(new ParseTree[]{ctx.numericLiteral(), ctx.identifier()}));
    }

    @Override
    public Cobol.Receive visitReceiveStatement(CobolParser.ReceiveStatementContext ctx) {
        return new Cobol.Receive(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RECEIVE()), (Cobol)this.visit(new ParseTree[]{ctx.receiveFromStatement(), ctx.receiveIntoStatement()}), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onExceptionClause()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnExceptionClause()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_RECEIVE()));
    }

    @Override
    public Cobol.Receivable visitReceiveStatus(CobolParser.ReceiveStatusContext ctx) {
        return new Cobol.Receivable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.STATUS(), ctx.IN()), (Name)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Cobol.Receivable visitReceiveThread(CobolParser.ReceiveThreadContext ctx) {
        return new Cobol.Receivable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.THREAD(), ctx.IN()), (Name)this.visit((ParseTree)ctx.dataName()));
    }

    @Override
    public Cobol.ReceiveWith visitReceiveWith(CobolParser.ReceiveWithContext ctx) {
        return new Cobol.ReceiveWith(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.NO(), ctx.WAIT()));
    }

    @Override
    public Cobol.StatementPhrase visitReceiveWithData(CobolParser.ReceiveWithDataContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.DATA()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitRecordContainsClause(CobolParser.RecordContainsClauseContext ctx) {
        return new Cobol.RecordContainsClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RECORD()), (Cobol)this.visit(new ParseTree[]{ctx.recordContainsClauseFormat1(), ctx.recordContainsClauseFormat2(), ctx.recordContainsClauseFormat3()}));
    }

    @Override
    public Object visitRecordContainsClauseFormat1(CobolParser.RecordContainsClauseFormat1Context ctx) {
        return new Cobol.RecordContainsClauseFormat1(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.CONTAINS()), (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visitNullable((ParseTree)ctx.CHARACTERS()));
    }

    @Override
    public Object visitRecordContainsClauseFormat2(CobolParser.RecordContainsClauseFormat2Context ctx) {
        return new Cobol.RecordContainsClauseFormat2(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.VARYING(), ctx.IN(), ctx.SIZE()), this.convertAllList(Collections.singletonList(ctx.FROM()), Collections.singletonList(ctx.integerLiteral()), Collections.singletonList(ctx.recordContainsTo()), Collections.singletonList(ctx.CHARACTERS())), this.convertAllList(Collections.singletonList(ctx.DEPENDING()), Collections.singletonList(ctx.ON()), Collections.singletonList(ctx.qualifiedDataName())));
    }

    @Override
    public Object visitRecordContainsClauseFormat3(CobolParser.RecordContainsClauseFormat3Context ctx) {
        return new Cobol.RecordContainsClauseFormat3(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.CONTAINS()), (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.RecordContainsTo)this.visit((ParseTree)ctx.recordContainsTo()), (Cobol.Word)this.visitNullable((ParseTree)ctx.CHARACTERS()));
    }

    @Override
    public Object visitRecordContainsTo(CobolParser.RecordContainsToContext ctx) {
        return new Cobol.RecordContainsTo(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TO()), (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitRecordDelimiterClause(CobolParser.RecordDelimiterClauseContext ctx) {
        return new Cobol.RecordDelimiterClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RECORD(), ctx.DELIMITER(), ctx.IS(), ctx.STANDARD_1(), ctx.IMPLICIT()), (Name)this.visitNullable((ParseTree)ctx.assignmentName()));
    }

    @Override
    public Object visitRecordKeyClause(CobolParser.RecordKeyClauseContext ctx) {
        return new Cobol.RecordKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RECORD(), ctx.KEY(), ctx.IS()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()), (Cobol.PasswordClause)this.visitNullable((ParseTree)ctx.passwordClause()), this.wordsList(ctx.WITH(), ctx.DUPLICATES()));
    }

    @Override
    public Object visitRecordingModeClause(CobolParser.RecordingModeClauseContext ctx) {
        return new Cobol.RecordingModeClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RECORDING(), ctx.MODE(), ctx.IS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.modeStatement()));
    }

    @Override
    public Object visitReferenceModifier(CobolParser.ReferenceModifierContext ctx) {
        return new Cobol.ReferenceModifier(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), (Cobol.ArithmeticExpression)this.visit((ParseTree)ctx.characterPosition()), (Cobol.Word)this.visit((ParseTree)ctx.COLONCHAR()), (Cobol.ArithmeticExpression)this.visitNullable((ParseTree)ctx.length()), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
    }

    @Override
    public Object visitRelationArithmeticComparison(CobolParser.RelationArithmeticComparisonContext ctx) {
        return new Cobol.RelationArithmeticComparison(Space.EMPTY, Markers.EMPTY, (Cobol.ArithmeticExpression)this.visit((ParseTree)ctx.arithmeticExpression().get(0)), (Cobol.RelationalOperator)this.visit((ParseTree)ctx.relationalOperator()), (Cobol.ArithmeticExpression)this.visit((ParseTree)ctx.arithmeticExpression().get(1)));
    }

    @Override
    public Object visitRelationCombinedComparison(CobolParser.RelationCombinedComparisonContext ctx) {
        return new Cobol.RelationCombinedComparison(Space.EMPTY, Markers.EMPTY, (Cobol.ArithmeticExpression)this.visit((ParseTree)ctx.arithmeticExpression()), (Cobol.RelationalOperator)this.visit((ParseTree)ctx.relationalOperator()), new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), Collections.singletonList((Cobol)this.visit((ParseTree)ctx.relationCombinedCondition())), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR())));
    }

    @Override
    public Object visitRelationCombinedCondition(CobolParser.RelationCombinedConditionContext ctx) {
        return new Cobol.RelationCombinedCondition(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.AND(), ctx.OR(), ctx.arithmeticExpression()));
    }

    @Override
    public Object visitRelationSignCondition(CobolParser.RelationSignConditionContext ctx) {
        return new Cobol.RelationSignCondition(Space.EMPTY, Markers.EMPTY, (Cobol.ArithmeticExpression)this.visit((ParseTree)ctx.arithmeticExpression()), this.wordsList(ctx.IS(), ctx.NOT(), ctx.POSITIVE(), ctx.NEGATIVE(), ctx.ZERO()));
    }

    @Override
    public Object visitRelationalOperator(CobolParser.RelationalOperatorContext ctx) {
        return new Cobol.RelationalOperator(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.ARE(), ctx.NOT(), ctx.GREATER(), ctx.LESS(), ctx.THAN(), ctx.OR(), ctx.EQUAL(), ctx.TO(), ctx.MORETHANCHAR(), ctx.LESSTHANCHAR(), ctx.EQUALCHAR(), ctx.NOTEQUALCHAR(), ctx.MORETHANOREQUAL(), ctx.LESSTHANOREQUAL()));
    }

    @Override
    public Object visitRelativeKeyClause(CobolParser.RelativeKeyClauseContext ctx) {
        return new Cobol.RelativeKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RELATIVE(), ctx.KEY(), ctx.IS()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.Release visitReleaseStatement(CobolParser.ReleaseStatementContext ctx) {
        return new Cobol.Release(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RELEASE()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.recordName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.FROM()), (Cobol.QualifiedDataName)this.visitNullable((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Object visitReportClause(CobolParser.ReportClauseContext ctx) {
        return new Cobol.ReportClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REPORT(), ctx.REPORTS(), ctx.IS(), ctx.ARE()), this.convertAll((List)ctx.reportName()));
    }

    @Override
    public Object visitRemarksParagraph(CobolParser.RemarksParagraphContext ctx) {
        return new Cobol.IdentificationDivisionParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REMARKS()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(0)), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()), this.wordsList(ctx.END_REMARKS()), ctx.DOT_FS().size() == 1 ? null : (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1)));
    }

    @Override
    public Object visitReportDescription(CobolParser.ReportDescriptionContext ctx) {
        return new Cobol.ReportDescription(Space.EMPTY, Markers.EMPTY, (Cobol.ReportDescriptionEntry)this.visit((ParseTree)ctx.reportDescriptionEntry()), this.convertAll((List)ctx.reportGroupDescriptionEntry()));
    }

    @Override
    public Object visitReportDescriptionEntry(CobolParser.ReportDescriptionEntryContext ctx) {
        return new Cobol.ReportDescriptionEntry(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RD()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.reportName()), (Cobol.ReportDescriptionGlobalClause)this.visitNullable((ParseTree)ctx.reportDescriptionGlobalClause()), (Cobol.ReportDescriptionPageLimitClause)this.visitNullable((ParseTree)ctx.reportDescriptionPageLimitClause()), (Cobol.ReportDescriptionHeadingClause)this.visitNullable((ParseTree)ctx.reportDescriptionHeadingClause()), (Cobol.ReportDescriptionFirstDetailClause)this.visitNullable((ParseTree)ctx.reportDescriptionFirstDetailClause()), (Cobol.ReportDescriptionLastDetailClause)this.visitNullable((ParseTree)ctx.reportDescriptionLastDetailClause()), (Cobol.ReportDescriptionFootingClause)this.visitNullable((ParseTree)ctx.reportDescriptionFootingClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitReportDescriptionFirstDetailClause(CobolParser.ReportDescriptionFirstDetailClauseContext ctx) {
        return new Cobol.ReportDescriptionFirstDetailClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FIRST(), ctx.DETAIL()), (Name)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportDescriptionFootingClause(CobolParser.ReportDescriptionFootingClauseContext ctx) {
        return new Cobol.ReportDescriptionFootingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FOOTING()), (Name)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportDescriptionGlobalClause(CobolParser.ReportDescriptionGlobalClauseContext ctx) {
        return new Cobol.ReportDescriptionGlobalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.IS(), ctx.GLOBAL()));
    }

    @Override
    public Object visitReportDescriptionHeadingClause(CobolParser.ReportDescriptionHeadingClauseContext ctx) {
        return new Cobol.ReportDescriptionHeadingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.HEADING()), (Name)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportDescriptionLastDetailClause(CobolParser.ReportDescriptionLastDetailClauseContext ctx) {
        return new Cobol.ReportDescriptionLastDetailClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LAST(), ctx.DETAIL()), (Name)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportDescriptionPageLimitClause(CobolParser.ReportDescriptionPageLimitClauseContext ctx) {
        return new Cobol.ReportDescriptionPageLimitClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PAGE(), ctx.LIMIT(), ctx.IS(), ctx.LIMITS(), ctx.ARE()), (Name)this.visit((ParseTree)ctx.integerLiteral()), ctx.LINE() != null ? (Cobol.Word)this.visit((ParseTree)ctx.LINE()) : (ctx.LINES() != null ? (Cobol.Word)this.visit((ParseTree)ctx.LINES()) : null));
    }

    @Override
    public Object visitReportGroupBlankWhenZeroClause(CobolParser.ReportGroupBlankWhenZeroClauseContext ctx) {
        return new Cobol.ReportGroupBlankWhenZeroClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BLANK(), ctx.WHEN(), ctx.ZERO()));
    }

    @Override
    public Object visitReportGroupColumnNumberClause(CobolParser.ReportGroupColumnNumberClauseContext ctx) {
        return new Cobol.ReportGroupColumnNumberClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COLUMN(), ctx.NUMBER(), ctx.IS()), (Name)this.visit((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportGroupDescriptionEntryFormat1(CobolParser.ReportGroupDescriptionEntryFormat1Context ctx) {
        return new Cobol.ReportGroupDescriptionEntryFormat1(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visit((ParseTree)ctx.dataName()), (Cobol.ReportGroupLineNumberClause)this.visitNullable((ParseTree)ctx.reportGroupLineNumberClause()), (Cobol.ReportGroupNextGroupClause)this.visitNullable((ParseTree)ctx.reportGroupNextGroupClause()), (Cobol.ReportGroupTypeClause)this.visit((ParseTree)ctx.reportGroupTypeClause()), (Cobol.ReportGroupUsageClause)this.visitNullable((ParseTree)ctx.reportGroupUsageClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitReportGroupDescriptionEntryFormat2(CobolParser.ReportGroupDescriptionEntryFormat2Context ctx) {
        return new Cobol.ReportGroupDescriptionEntryFormat2(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visitNullable((ParseTree)ctx.dataName()), (Cobol.ReportGroupLineNumberClause)this.visitNullable((ParseTree)ctx.reportGroupLineNumberClause()), (Cobol.ReportGroupUsageClause)this.visit((ParseTree)ctx.reportGroupUsageClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitReportGroupDescriptionEntryFormat3(CobolParser.ReportGroupDescriptionEntryFormat3Context ctx) {
        return new Cobol.ReportGroupDescriptionEntryFormat3(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visitNullable((ParseTree)ctx.dataName()), this.convertAll(ctx.reportGroupPictureClause(), ctx.reportGroupUsageClause(), ctx.reportGroupSignClause(), ctx.reportGroupJustifiedClause(), ctx.reportGroupBlankWhenZeroClause(), ctx.reportGroupLineNumberClause(), ctx.reportGroupColumnNumberClause(), ctx.reportGroupSourceClause(), ctx.reportGroupValueClause(), ctx.reportGroupSumClause(), ctx.reportGroupResetClause(), ctx.reportGroupIndicateClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitReportGroupIndicateClause(CobolParser.ReportGroupIndicateClauseContext ctx) {
        return new Cobol.ReportGroupIndicateClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.GROUP(), ctx.INDICATE()));
    }

    @Override
    public Object visitReportGroupJustifiedClause(CobolParser.ReportGroupJustifiedClauseContext ctx) {
        return new Cobol.ReportGroupJustifiedClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.JUSTIFIED(), ctx.JUST(), ctx.RIGHT()));
    }

    @Override
    public Object visitReportGroupLineNumberClause(CobolParser.ReportGroupLineNumberClauseContext ctx) {
        return new Cobol.ReportGroupLineNumberClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LINE(), ctx.NUMBER(), ctx.IS()), (Cobol)this.visit(new ParseTree[]{ctx.reportGroupLineNumberNextPage(), ctx.reportGroupLineNumberPlus()}));
    }

    @Override
    public Object visitReportGroupLineNumberNextPage(CobolParser.ReportGroupLineNumberNextPageContext ctx) {
        return new Cobol.ReportGroupLineNumberNextPage(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), this.wordsList(ctx.ON(), ctx.NEXT(), ctx.PAGE()));
    }

    @Override
    public Object visitReportGroupLineNumberPlus(CobolParser.ReportGroupLineNumberPlusContext ctx) {
        return new Cobol.ReportGroupLineNumberPlus(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.PLUS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportGroupNextGroupClause(CobolParser.ReportGroupNextGroupClauseContext ctx) {
        return new Cobol.ReportGroupNextGroupClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NEXT(), ctx.GROUP(), ctx.IS()), (Cobol)this.visit(new ParseTree[]{ctx.integerLiteral(), ctx.reportGroupNextGroupNextPage(), ctx.reportGroupNextGroupPlus()}));
    }

    @Override
    public Object visitReportGroupNextGroupNextPage(CobolParser.ReportGroupNextGroupNextPageContext ctx) {
        return new Cobol.ReportGroupNextGroupNextPage(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NEXT(), ctx.PAGE()));
    }

    @Override
    public Object visitReportGroupNextGroupPlus(CobolParser.ReportGroupNextGroupPlusContext ctx) {
        return new Cobol.ReportGroupNextGroupPlus(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.PLUS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitReportGroupPictureClause(CobolParser.ReportGroupPictureClauseContext ctx) {
        return new Cobol.ReportGroupPictureClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PICTURE(), ctx.PIC(), ctx.IS()), (Cobol.PictureString)this.visit((ParseTree)ctx.pictureString()));
    }

    @Override
    public Object visitReportGroupResetClause(CobolParser.ReportGroupResetClauseContext ctx) {
        return new Cobol.ReportGroupResetClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RESET(), ctx.ON(), ctx.FINAL()), (Name)this.visitNullable((ParseTree)ctx.dataName()));
    }

    @Override
    public Object visitReportGroupSignClause(CobolParser.ReportGroupSignClauseContext ctx) {
        return new Cobol.ReportGroupSignClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SIGN(), ctx.IS(), ctx.LEADING(), ctx.TRAILING(), ctx.SEPARATE(), ctx.CHARACTER()));
    }

    @Override
    public Object visitReportGroupSourceClause(CobolParser.ReportGroupSourceClauseContext ctx) {
        return new Cobol.ReportGroupSourceClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SOURCE(), ctx.IS()), (Name)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitReportGroupSumClause(CobolParser.ReportGroupSumClauseContext ctx) {
        return new Cobol.ReportGroupSumClause(Space.EMPTY, Markers.EMPTY, this.convertAllList(Collections.singletonList(ctx.SUM()), ctx.identifier(), ctx.COMMACHAR(), Collections.singletonList(ctx.UPON()), ctx.dataName()));
    }

    @Override
    public Object visitReportGroupTypeClause(CobolParser.ReportGroupTypeClauseContext ctx) {
        return new Cobol.ReportGroupTypeClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.TYPE(), ctx.IS()), (Cobol)this.visit(new ParseTree[]{ctx.reportGroupTypeReportHeading(), ctx.reportGroupTypeReportFooting(), ctx.reportGroupTypePageHeading(), ctx.reportGroupTypePageFooting(), ctx.reportGroupTypeControlHeading(), ctx.reportGroupTypeControlFooting(), ctx.reportGroupTypeDetail()}));
    }

    @Override
    public Object visitReportGroupTypeControlFooting(CobolParser.ReportGroupTypeControlFootingContext ctx) {
        return new Cobol.ReportGroupTypeControlFooting(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CONTROL(), ctx.FOOTING(), ctx.CF(), ctx.FINAL()), (Name)this.visitNullable((ParseTree)ctx.dataName()));
    }

    @Override
    public Object visitReportGroupTypeControlHeading(CobolParser.ReportGroupTypeControlHeadingContext ctx) {
        return new Cobol.ReportGroupTypeControlHeading(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CONTROL(), ctx.HEADING(), ctx.CH(), ctx.FINAL()), (Name)this.visitNullable((ParseTree)ctx.dataName()));
    }

    @Override
    public Object visitReportGroupTypeDetail(CobolParser.ReportGroupTypeDetailContext ctx) {
        return new Cobol.ReportGroupTypeDetail(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DETAIL(), ctx.DE()));
    }

    @Override
    public Object visitReportGroupTypePageFooting(CobolParser.ReportGroupTypePageFootingContext ctx) {
        return new Cobol.ReportGroupTypePageFooting(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PAGE(), ctx.FOOTING(), ctx.PF()));
    }

    @Override
    public Object visitReportGroupTypePageHeading(CobolParser.ReportGroupTypePageHeadingContext ctx) {
        return new Cobol.ReportGroupTypePageHeading(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PAGE(), ctx.HEADING(), ctx.PH()));
    }

    @Override
    public Object visitReportGroupTypeReportFooting(CobolParser.ReportGroupTypeReportFootingContext ctx) {
        return new Cobol.ReportGroupTypeReportFooting(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REPORT(), ctx.FOOTING(), ctx.RF()));
    }

    @Override
    public Object visitReportGroupTypeReportHeading(CobolParser.ReportGroupTypeReportHeadingContext ctx) {
        return new Cobol.ReportGroupTypeReportHeading(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REPORT(), ctx.HEADING(), ctx.RH()));
    }

    @Override
    public Object visitReportGroupUsageClause(CobolParser.ReportGroupUsageClauseContext ctx) {
        return new Cobol.ReportGroupUsageClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.USAGE(), ctx.IS(), ctx.DISPLAY(), ctx.DISPLAY_1()));
    }

    @Override
    public Object visitReportGroupValueClause(CobolParser.ReportGroupValueClauseContext ctx) {
        return new Cobol.ReportGroupValueClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.VALUE(), ctx.IS()), (Name)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitReportSection(CobolParser.ReportSectionContext ctx) {
        return new Cobol.ReportSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REPORT(), ctx.SECTION(), ctx.DOT_FS()), this.convertAll((List)ctx.reportDescription()));
    }

    @Override
    public Object visitRerunClause(CobolParser.RerunClauseContext ctx) {
        return new Cobol.RerunClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RERUN()), (Cobol.Word)this.visitNullable((ParseTree)ctx.ON()), (Cobol.Word)this.visit(new ParseTree[]{ctx.assignmentName(), ctx.fileName()}), (Cobol.Word)this.visit((ParseTree)ctx.EVERY()), (Cobol)this.visit(new ParseTree[]{ctx.rerunEveryRecords(), ctx.rerunEveryOf(), ctx.rerunEveryClock()}));
    }

    @Override
    public Object visitRerunEveryClock(CobolParser.RerunEveryClockContext ctx) {
        return new Cobol.RerunEveryClock(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visitNullable((ParseTree)ctx.CLOCK_UNITS()));
    }

    @Override
    public Object visitRerunEveryOf(CobolParser.RerunEveryOfContext ctx) {
        return new Cobol.RerunEveryOf(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.END(), ctx.OF().size() == 1 ? null : ctx.OF(0), ctx.REEL(), ctx.UNIT(), ctx.OF(ctx.OF().size() == 1 ? 0 : 1)), (Cobol.Word)this.visit((ParseTree)ctx.fileName()));
    }

    @Override
    public Object visitRerunEveryRecords(CobolParser.RerunEveryRecordsContext ctx) {
        return new Cobol.RerunEveryRecords(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visit((ParseTree)ctx.RECORDS()));
    }

    @Override
    public Object visitReserveClause(CobolParser.ReserveClauseContext ctx) {
        return new Cobol.ReserveClause(Space.EMPTY, Markers.EMPTY, this.convertAllList(Collections.emptyList(), Collections.singletonList(ctx.RESERVE()), Collections.singletonList(ctx.NO()), Collections.singletonList(ctx.integerLiteral()), Collections.singletonList(ctx.ALTERNATE()), Collections.singletonList(ctx.AREA()), Collections.singletonList(ctx.AREAS())));
    }

    @Override
    public Cobol.ReserveNetworkClause visitReserveNetworkClause(CobolParser.ReserveNetworkClauseContext ctx) {
        return new Cobol.ReserveNetworkClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RESERVE(), ctx.WORDS(), ctx.LIST(), ctx.IS(), ctx.NETWORK(), ctx.CAPABLE()));
    }

    @Override
    public Cobol.ReturnInto visitReturnInto(CobolParser.ReturnIntoContext ctx) {
        return new Cobol.ReturnInto(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTO()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.Return visitReturnStatement(CobolParser.ReturnStatementContext ctx) {
        return new Cobol.Return(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.RETURN()), (Name)this.visit((ParseTree)ctx.fileName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.RECORD()), (Cobol.ReturnInto)this.visitNullable((ParseTree)ctx.returnInto()), (Cobol.StatementPhrase)this.visit((ParseTree)ctx.atEndPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notAtEndPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_RETURN()));
    }

    @Override
    public Object visitRewriteFrom(CobolParser.RewriteFromContext ctx) {
        return new Cobol.RewriteFrom(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Name)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitRewriteStatement(CobolParser.RewriteStatementContext ctx) {
        return new Cobol.Rewrite(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REWRITE()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.recordName()), (Cobol.RewriteFrom)this.visitNullable((ParseTree)ctx.rewriteFrom()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.invalidKeyPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notInvalidKeyPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_REWRITE()));
    }

    @Override
    public Cobol.Roundable visitRoundable(CobolParser.RoundableContext ctx) {
        return new Cobol.Roundable(Space.EMPTY, Markers.EMPTY, (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol.Word)this.visitNullable((ParseTree)ctx.ROUNDED()));
    }

    @Override
    public Object visitSameClause(CobolParser.SameClauseContext ctx) {
        return new Cobol.SameClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SAME(), ctx.RECORD(), ctx.SORT(), ctx.SORT_MERGE(), ctx.AREA(), ctx.FOR()), this.convertAll((List)ctx.fileName()));
    }

    @Override
    public Object visitSecurityParagraph(CobolParser.SecurityParagraphContext ctx) {
        return new Cobol.IdentificationDivisionParagraph(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.SECURITY()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), (Cobol.CommentEntry)this.visitNullable((ParseTree)ctx.commentEntry()), null, null);
    }

    @Override
    public Object visitScreenDescriptionAutoClause(CobolParser.ScreenDescriptionAutoClauseContext ctx) {
        return new Cobol.ScreenDescriptionAutoClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.AUTO(), ctx.AUTO_SKIP()}));
    }

    @Override
    public Object visitScreenDescriptionBackgroundColorClause(CobolParser.ScreenDescriptionBackgroundColorClauseContext ctx) {
        return new Cobol.ScreenDescriptionBackgroundColorClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.BACKGROUND_COLOR(), ctx.BACKGROUND_COLOUR()}), (Cobol.Word)this.visitNullable((ParseTree)ctx.IS()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.identifier()}));
    }

    @Override
    public Object visitScreenDescriptionBellClause(CobolParser.ScreenDescriptionBellClauseContext ctx) {
        return new Cobol.ScreenDescriptionBellClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.BELL(), ctx.BEEP()}));
    }

    @Override
    public Object visitScreenDescriptionBlankClause(CobolParser.ScreenDescriptionBlankClauseContext ctx) {
        return new Cobol.ScreenDescriptionBlankClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BLANK(), ctx.SCREEN(), ctx.LINE()));
    }

    @Override
    public Object visitScreenDescriptionBlankWhenZeroClause(CobolParser.ScreenDescriptionBlankWhenZeroClauseContext ctx) {
        return new Cobol.ScreenDescriptionBlankWhenZeroClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BLANK(), ctx.WHEN(), ctx.ZERO()));
    }

    @Override
    public Object visitScreenDescriptionBlinkClause(CobolParser.ScreenDescriptionBlinkClauseContext ctx) {
        return new Cobol.ScreenDescriptionBlinkClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.BLINK()));
    }

    @Override
    public Object visitScreenDescriptionColumnClause(CobolParser.ScreenDescriptionColumnClauseContext ctx) {
        return new Cobol.ScreenDescriptionColumnClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COLUMN(), ctx.COL(), ctx.NUMBER(), ctx.IS(), ctx.PLUS(), ctx.PLUSCHAR(), ctx.MINUSCHAR()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitScreenDescriptionControlClause(CobolParser.ScreenDescriptionControlClauseContext ctx) {
        return new Cobol.ScreenDescriptionControlClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.CONTROL(), ctx.IS()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitScreenDescriptionEntry(CobolParser.ScreenDescriptionEntryContext ctx) {
        return new Cobol.ScreenDescriptionEntry(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTEGERLITERAL()), ctx.FILLER() != null ? (Cobol.Word)this.visit((ParseTree)ctx.FILLER()) : (ctx.screenName() != null ? (Cobol.Word)this.visit((ParseTree)ctx.screenName()) : null), this.convertAll(ctx.screenDescriptionBlankClause(), ctx.screenDescriptionAutoClause(), ctx.screenDescriptionBellClause(), ctx.screenDescriptionBlinkClause(), ctx.screenDescriptionBlankWhenZeroClause(), ctx.screenDescriptionBackgroundColorClause(), ctx.screenDescriptionEraseClause(), ctx.screenDescriptionLightClause(), ctx.screenDescriptionGridClause(), ctx.screenDescriptionReverseVideoClause(), ctx.screenDescriptionUnderlineClause(), ctx.screenDescriptionSizeClause(), ctx.screenDescriptionLineClause(), ctx.screenDescriptionColumnClause(), ctx.screenDescriptionForegroundColorClause(), ctx.screenDescriptionControlClause(), ctx.screenDescriptionValueClause(), ctx.screenDescriptionPictureClause(), ctx.screenDescriptionFromClause(), ctx.screenDescriptionUsingClause(), ctx.screenDescriptionUsageClause(), ctx.screenDescriptionJustifiedClause(), ctx.screenDescriptionSignClause(), ctx.screenDescriptionSecureClause(), ctx.screenDescriptionRequiredClause(), ctx.screenDescriptionPromptClause(), ctx.screenDescriptionFullClause(), ctx.screenDescriptionZeroFillClause()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Object visitScreenDescriptionEraseClause(CobolParser.ScreenDescriptionEraseClauseContext ctx) {
        return new Cobol.ScreenDescriptionEraseClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ERASE(), ctx.EOL(), ctx.EOS()));
    }

    @Override
    public Object visitScreenDescriptionForegroundColorClause(CobolParser.ScreenDescriptionForegroundColorClauseContext ctx) {
        return new Cobol.ScreenDescriptionForegroundColorClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOREGROUND_COLOR(), ctx.FOREGROUND_COLOUR(), ctx.IS()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitScreenDescriptionFromClause(CobolParser.ScreenDescriptionFromClauseContext ctx) {
        return new Cobol.ScreenDescriptionFromClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.ScreenDescriptionToClause)this.visitNullable((ParseTree)ctx.screenDescriptionToClause()));
    }

    @Override
    public Object visitScreenDescriptionFullClause(CobolParser.ScreenDescriptionFullClauseContext ctx) {
        return new Cobol.ScreenDescriptionFullClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.FULL(), ctx.LENGTH_CHECK()}));
    }

    @Override
    public Object visitScreenDescriptionGridClause(CobolParser.ScreenDescriptionGridClauseContext ctx) {
        return new Cobol.ScreenDescriptionGridClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.GRID(), ctx.LEFTLINE(), ctx.OVERLINE()}));
    }

    @Override
    public Object visitScreenDescriptionJustifiedClause(CobolParser.ScreenDescriptionJustifiedClauseContext ctx) {
        return new Cobol.ScreenDescriptionJustifiedClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.JUSTIFIED(), ctx.JUST(), ctx.RIGHT()));
    }

    @Override
    public Object visitScreenDescriptionLightClause(CobolParser.ScreenDescriptionLightClauseContext ctx) {
        return new Cobol.ScreenDescriptionLightClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.HIGHLIGHT(), ctx.LOWLIGHT()}));
    }

    @Override
    public Object visitScreenDescriptionLineClause(CobolParser.ScreenDescriptionLineClauseContext ctx) {
        return new Cobol.ScreenDescriptionLineClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.LINE(), ctx.NUMBER(), ctx.IS(), ctx.PLUS(), ctx.PLUSCHAR(), ctx.MINUSCHAR()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitScreenDescriptionPictureClause(CobolParser.ScreenDescriptionPictureClauseContext ctx) {
        return new Cobol.ScreenDescriptionPictureClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PICTURE(), ctx.PIC(), ctx.IS()), (Cobol.PictureString)this.visit((ParseTree)ctx.pictureString()));
    }

    @Override
    public Object visitScreenDescriptionPromptClause(CobolParser.ScreenDescriptionPromptClauseContext ctx) {
        return new Cobol.ScreenDescriptionPromptClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.PROMPT(), ctx.CHARACTER(), ctx.IS()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.ScreenDescriptionPromptOccursClause)this.visitNullable((ParseTree)ctx.screenDescriptionPromptOccursClause()));
    }

    @Override
    public Object visitScreenDescriptionPromptOccursClause(CobolParser.ScreenDescriptionPromptOccursClauseContext ctx) {
        return new Cobol.ScreenDescriptionPromptOccursClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.OCCURS()), (Cobol.Word)this.visit((ParseTree)ctx.integerLiteral()), (Cobol.Word)this.visitNullable((ParseTree)ctx.TIMES()));
    }

    @Override
    public Object visitScreenDescriptionRequiredClause(CobolParser.ScreenDescriptionRequiredClauseContext ctx) {
        return new Cobol.ScreenDescriptionRequiredClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.REQUIRED(), ctx.EMPTY_CHECK()}));
    }

    @Override
    public Object visitScreenDescriptionReverseVideoClause(CobolParser.ScreenDescriptionReverseVideoClauseContext ctx) {
        return new Cobol.ScreenDescriptionReverseVideoClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.REVERSE_VIDEO()));
    }

    @Override
    public Object visitScreenDescriptionSecureClause(CobolParser.ScreenDescriptionSecureClauseContext ctx) {
        return new Cobol.ScreenDescriptionSecureClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.SECURE(), ctx.NO_ECHO()}));
    }

    @Override
    public Object visitScreenDescriptionSignClause(CobolParser.ScreenDescriptionSignClauseContext ctx) {
        return new Cobol.ScreenDescriptionSignClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SIGN(), ctx.IS(), ctx.LEADING(), ctx.TRAILING(), ctx.SEPARATE(), ctx.CHARACTER()));
    }

    @Override
    public Object visitScreenDescriptionSizeClause(CobolParser.ScreenDescriptionSizeClauseContext ctx) {
        return new Cobol.ScreenDescriptionSizeClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SIZE(), ctx.IS()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitScreenDescriptionToClause(CobolParser.ScreenDescriptionToClauseContext ctx) {
        return new Cobol.ScreenDescriptionToClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TO()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitScreenDescriptionUnderlineClause(CobolParser.ScreenDescriptionUnderlineClauseContext ctx) {
        return new Cobol.ScreenDescriptionUnderlineClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.UNDERLINE()));
    }

    @Override
    public Object visitScreenDescriptionUsageClause(CobolParser.ScreenDescriptionUsageClauseContext ctx) {
        return new Cobol.ScreenDescriptionUsageClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.USAGE(), ctx.IS(), ctx.DISPLAY(), ctx.DISPLAY_1()));
    }

    @Override
    public Object visitScreenDescriptionUsingClause(CobolParser.ScreenDescriptionUsingClauseContext ctx) {
        return new Cobol.ScreenDescriptionUsingClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.USING()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitScreenDescriptionValueClause(CobolParser.ScreenDescriptionValueClauseContext ctx) {
        return new Cobol.ScreenDescriptionValueClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.VALUE(), ctx.IS()), (Name)this.visit((ParseTree)ctx.literal()));
    }

    @Override
    public Object visitScreenDescriptionZeroFillClause(CobolParser.ScreenDescriptionZeroFillClauseContext ctx) {
        return new Cobol.ScreenDescriptionZeroFillClause(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.ZERO_FILL()));
    }

    @Override
    public Object visitScreenSection(CobolParser.ScreenSectionContext ctx) {
        return new Cobol.ScreenSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SCREEN(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.screenDescriptionEntry()));
    }

    @Override
    public Cobol.Search visitSearchStatement(CobolParser.SearchStatementContext ctx) {
        return new Cobol.Search(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SEARCH(), ctx.ALL()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()), (Cobol.SearchVarying)this.visitNullable((ParseTree)ctx.searchVarying()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.atEndPhrase()), this.convertAll((List)ctx.searchWhen()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_SEARCH()));
    }

    @Override
    public Cobol.SearchVarying visitSearchVarying(CobolParser.SearchVaryingContext ctx) {
        return new Cobol.SearchVarying(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.VARYING()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.SearchWhen visitSearchWhen(CobolParser.SearchWhenContext ctx) {
        return new Cobol.SearchWhen(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.WHEN()), (Cobol.Condition)this.visit((ParseTree)ctx.condition()), this.wordsList(ctx.NEXT(), ctx.SENTENCE()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Cobol.ValuedObjectComputerClause visitSegmentLimitClause(CobolParser.SegmentLimitClauseContext ctx) {
        return new Cobol.ValuedObjectComputerClause(Space.EMPTY, Markers.EMPTY, Cobol.ValuedObjectComputerClause.Type.SegmentLimit, this.wordsList(ctx.SEGMENT_LIMIT(), ctx.IS()), (Cobol)this.visit((ParseTree)ctx.integerLiteral()), null);
    }

    @Override
    public Object visitSelectClause(CobolParser.SelectClauseContext ctx) {
        return new Cobol.SelectClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SELECT(), ctx.OPTIONAL()), (Cobol.Word)this.visit((ParseTree)ctx.fileName()));
    }

    @Override
    public Cobol.SendAdvancingLines visitSendAdvancingLines(CobolParser.SendAdvancingLinesContext ctx) {
        return new Cobol.SendAdvancingLines(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), ctx.LINE() != null ? (Cobol.Word)this.visit((ParseTree)ctx.LINE()) : (ctx.LINES() != null ? (Cobol.Word)this.visit((ParseTree)ctx.LINES()) : null));
    }

    @Override
    public Cobol.SendPhrase visitSendAdvancingPhrase(CobolParser.SendAdvancingPhraseContext ctx) {
        return new Cobol.SendPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BEFORE(), ctx.AFTER(), ctx.ADVANCING()), (Cobol)this.visit(new ParseTree[]{ctx.sendAdvancingPage(), ctx.sendAdvancingLines(), ctx.sendAdvancingMnemonic()}));
    }

    @Override
    public Cobol.SendPhrase visitSendFromPhrase(CobolParser.SendFromPhraseContext ctx) {
        return new Cobol.SendPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FROM()), (Cobol)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Cobol.SendPhrase visitSendReplacingPhrase(CobolParser.SendReplacingPhraseContext ctx) {
        return new Cobol.SendPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REPLACING(), ctx.LINE()), null);
    }

    @Override
    public Cobol.Send visitSendStatement(CobolParser.SendStatementContext ctx) {
        return new Cobol.Send(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.SEND()), (Cobol)this.visit(new ParseTree[]{ctx.sendStatementSync(), ctx.sendStatementAsync()}), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onExceptionClause()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnExceptionClause()));
    }

    @Override
    public Cobol.SendPhrase visitSendStatementAsync(CobolParser.SendStatementAsyncContext ctx) {
        return new Cobol.SendPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.TO(), ctx.TOP(), ctx.BOTTOM()), (Cobol)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Cobol.SendStatementSync visitSendStatementSync(CobolParser.SendStatementSyncContext ctx) {
        return new Cobol.SendStatementSync(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), (Cobol.SendPhrase)this.visitNullable((ParseTree)ctx.sendFromPhrase()), (Cobol.SendPhrase)this.visitNullable((ParseTree)ctx.sendWithPhrase()), (Cobol.SendPhrase)this.visitNullable((ParseTree)ctx.sendReplacingPhrase()), (Cobol.SendPhrase)this.visitNullable((ParseTree)ctx.sendAdvancingPhrase()));
    }

    @Override
    public Cobol.SendPhrase visitSendWithPhrase(CobolParser.SendWithPhraseContext ctx) {
        return new Cobol.SendPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.EGI(), ctx.EMI(), ctx.ESI()), (Cobol)this.visitNullable((ParseTree)ctx.identifier()));
    }

    @Override
    public Cobol.Sentence visitSentence(CobolParser.SentenceContext ctx) {
        return new Cobol.Sentence(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.statement()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()));
    }

    @Override
    public Cobol.Set visitSetStatement(CobolParser.SetStatementContext ctx) {
        return new Cobol.Set(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.SET()), this.convertAll((List)ctx.setToStatement()), (Cobol.SetUpDown)this.visitNullable((ParseTree)ctx.setUpDownByStatement()));
    }

    @Override
    public Cobol.SetTo visitSetToStatement(CobolParser.SetToStatementContext ctx) {
        return new Cobol.SetTo(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.setTo()), (Cobol.Word)this.visit((ParseTree)ctx.TO()), this.convertAll((List)ctx.setToValue()));
    }

    @Override
    public Cobol.SetUpDown visitSetUpDownByStatement(CobolParser.SetUpDownByStatementContext ctx) {
        return new Cobol.SetUpDown(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.setTo()), this.wordsList(ctx.DOWN(), ctx.UP(), ctx.BY()), (Name)this.visit((ParseTree)ctx.setByValue()));
    }

    @Override
    public Object visitSimpleCondition(CobolParser.SimpleConditionContext ctx) {
        return ctx.condition() != null ? new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), Collections.singletonList((Cobol)this.visit((ParseTree)ctx.condition())), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR())) : this.visit(new ParseTree[]{ctx.relationCondition(), ctx.classCondition(), ctx.conditionNameReference()});
    }

    @Override
    public Cobol.SortProcedurePhrase visitSortCollatingAlphanumeric(CobolParser.SortCollatingAlphanumericContext ctx) {
        return new Cobol.SortProcedurePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.ALPHANUMERIC(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.alphabetName()), null);
    }

    @Override
    public Cobol.SortProcedurePhrase visitSortCollatingNational(CobolParser.SortCollatingNationalContext ctx) {
        return new Cobol.SortProcedurePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.NATIONAL(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.alphabetName()), null);
    }

    @Override
    public Cobol.SortCollatingSequencePhrase visitSortCollatingSequencePhrase(CobolParser.SortCollatingSequencePhraseContext ctx) {
        return new Cobol.SortCollatingSequencePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COLLATING(), ctx.SEQUENCE(), ctx.IS()), this.convertAll((List)ctx.alphabetName()), (Cobol.Sortable)this.visitNullable((ParseTree)ctx.sortCollatingAlphanumeric()), (Cobol.Sortable)this.visitNullable((ParseTree)ctx.sortCollatingNational()));
    }

    @Override
    public Cobol.Sortable visitSortDuplicatesPhrase(CobolParser.SortDuplicatesPhraseContext ctx) {
        return new Cobol.Sortable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.DUPLICATES(), ctx.IN(), ctx.ORDER()), Collections.emptyList());
    }

    @Override
    public Cobol.SortGiving visitSortGiving(CobolParser.SortGivingContext ctx) {
        return new Cobol.SortGiving(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.fileName()), this.wordsList(ctx.LOCK(), ctx.SAVE(), ctx.NO(), ctx.REWIND(), ctx.RELEASE(), ctx.WITH(), ctx.REMOVE(), ctx.CRUNCH()));
    }

    @Override
    public Cobol.Sortable visitSortGivingPhrase(CobolParser.SortGivingPhraseContext ctx) {
        return new Cobol.Sortable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.GIVING()), this.convertAll((List)ctx.sortGiving()));
    }

    @Override
    public Cobol.SortProcedurePhrase visitSortInputProcedurePhrase(CobolParser.SortInputProcedurePhraseContext ctx) {
        return new Cobol.SortProcedurePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.INPUT(), ctx.PROCEDURE(), ctx.IS()), (Name)this.visit((ParseTree)ctx.procedureName()), (Cobol.Sortable)this.visitNullable((ParseTree)ctx.sortInputThrough()));
    }

    @Override
    public Cobol.Sortable visitSortInputThrough(CobolParser.SortInputThroughContext ctx) {
        return new Cobol.Sortable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.THROUGH(), ctx.THRU()), this.convertAll((List)Collections.singletonList(ctx.procedureName())));
    }

    @Override
    public Cobol.Sortable visitSortOnKeyClause(CobolParser.SortOnKeyClauseContext ctx) {
        return new Cobol.Sortable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ON(), ctx.ASCENDING(), ctx.DESCENDING(), ctx.KEY()), this.convertAll((List)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.SortProcedurePhrase visitSortOutputProcedurePhrase(CobolParser.SortOutputProcedurePhraseContext ctx) {
        return new Cobol.SortProcedurePhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.OUTPUT(), ctx.PROCEDURE(), ctx.IS()), (Name)this.visitNullable((ParseTree)ctx.procedureName()), (Cobol.Sortable)this.visitNullable((ParseTree)ctx.sortOutputThrough()));
    }

    @Override
    public Cobol.Sortable visitSortOutputThrough(CobolParser.SortOutputThroughContext ctx) {
        return new Cobol.Sortable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.THROUGH(), ctx.THRU()), this.convertAll((List)Collections.singletonList(ctx.procedureName())));
    }

    @Override
    public Cobol.Sort visitSortStatement(CobolParser.SortStatementContext ctx) {
        return new Cobol.Sort(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.SORT()), (Cobol.Word)this.visitNullable((ParseTree)ctx.fileName()), this.convertAll((List)ctx.sortOnKeyClause()), (Cobol.Sortable)this.visitNullable((ParseTree)ctx.sortDuplicatesPhrase()), (Cobol.SortCollatingSequencePhrase)this.visitNullable((ParseTree)ctx.sortCollatingSequencePhrase()), (Cobol.SortProcedurePhrase)this.visitNullable((ParseTree)ctx.sortInputProcedurePhrase()), this.convertAll((List)ctx.sortUsing()), (Cobol.SortProcedurePhrase)this.visitNullable((ParseTree)ctx.sortOutputProcedurePhrase()), this.convertAll((List)ctx.sortGivingPhrase()));
    }

    @Override
    public Cobol.Sortable visitSortUsing(CobolParser.SortUsingContext ctx) {
        return new Cobol.Sortable(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.USING()), this.convertAll((List)ctx.fileName()));
    }

    @Override
    public Cobol.SourceComputer visitSourceComputerParagraph(CobolParser.SourceComputerParagraphContext ctx) {
        return new Cobol.SourceComputer(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SOURCE_COMPUTER(), ctx.DOT_FS(0)), ctx.computerName() == null ? null : new Cobol.SourceComputerDefinition(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.computerName()), this.wordsList(ctx.WITH(), ctx.DEBUGGING(), ctx.MODE()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1))));
    }

    @Override
    public Cobol.SpecialNames visitSpecialNamesParagraph(CobolParser.SpecialNamesParagraphContext ctx) {
        return new Cobol.SpecialNames(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.SPECIAL_NAMES()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(0)), this.convertAll((List)ctx.specialNameClause()), ctx.DOT_FS().size() == 1 ? null : (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS(1)));
    }

    @Override
    public Object visitSpecialRegister(CobolParser.SpecialRegisterContext ctx) {
        return new Cobol.SpecialRegister(Space.EMPTY, Markers.EMPTY, this.convertAllList(Collections.singletonList(ctx.ADDRESS()), Collections.singletonList(ctx.LENGTH()), Collections.singletonList(ctx.OF()), Collections.singletonList(ctx.DATE()), Collections.singletonList(ctx.DAY()), Collections.singletonList(ctx.DAY_OF_WEEK()), Collections.singletonList(ctx.DEBUG_CONTENTS()), Collections.singletonList(ctx.DEBUG_ITEM()), Collections.singletonList(ctx.DEBUG_LINE()), Collections.singletonList(ctx.DEBUG_NAME()), Collections.singletonList(ctx.DEBUG_SUB_1()), Collections.singletonList(ctx.DEBUG_SUB_2()), Collections.singletonList(ctx.DEBUG_SUB_3()), Collections.singletonList(ctx.LINAGE_COUNTER()), Collections.singletonList(ctx.LINE_COUNTER()), Collections.singletonList(ctx.PAGE_COUNTER()), Collections.singletonList(ctx.RETURN_CODE()), Collections.singletonList(ctx.SHIFT_IN()), Collections.singletonList(ctx.SHIFT_OUT()), Collections.singletonList(ctx.SORT_CONTROL()), Collections.singletonList(ctx.SORT_CORE_SIZE()), Collections.singletonList(ctx.SORT_FILE_SIZE()), Collections.singletonList(ctx.SORT_MESSAGE()), Collections.singletonList(ctx.SORT_MODE_SIZE()), Collections.singletonList(ctx.SORT_RETURN()), Collections.singletonList(ctx.TALLY()), Collections.singletonList(ctx.TIME()), Collections.singletonList(ctx.WHEN_COMPILED())), (Name)this.visitNullable((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitStartKey(CobolParser.StartKeyContext ctx) {
        return new Cobol.StartKey(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.KEY(), ctx.IS(), ctx.NOT(), ctx.GREATER(), ctx.LESS(), ctx.THAN(), ctx.OR(), ctx.EQUAL(), ctx.TO(), ctx.MORETHANCHAR(), ctx.LESSTHANCHAR(), ctx.MORETHANOREQUAL(), ctx.EQUALCHAR()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Object visitStartStatement(CobolParser.StartStatementContext ctx) {
        return new Cobol.Start(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.START()), (Cobol.Word)this.visit((ParseTree)ctx.fileName()), (Cobol.StartKey)this.visitNullable((ParseTree)ctx.startKey()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.invalidKeyPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notInvalidKeyPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_START()));
    }

    @Override
    public Object visitStatusKeyClause(CobolParser.StatusKeyClauseContext ctx) {
        return new Cobol.StatusKeyClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.STATUS(), ctx.KEY(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Cobol.Stop visitStopStatement(CobolParser.StopStatementContext ctx) {
        return new Cobol.Stop(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.STOP(), ctx.RUN()), ctx.literal() != null ? (Cobol)this.visit((ParseTree)ctx.literal()) : (ctx.stopStatementGiving() != null ? (Cobol)this.visit((ParseTree)ctx.stopStatementGiving()) : null));
    }

    @Override
    public Object visitStopStatementGiving(CobolParser.StopStatementGivingContext ctx) {
        return new Cobol.StopStatementGiving(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.RUN(), ctx.GIVING(), ctx.RETURNING()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.integerLiteral()}));
    }

    @Override
    public Object visitStringDelimitedByPhrase(CobolParser.StringDelimitedByPhraseContext ctx) {
        return new Cobol.StringDelimitedByPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DELIMITED(), ctx.BY()), (Name)this.visit(new ParseTree[]{ctx.SIZE(), ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitStringForPhrase(CobolParser.StringForPhraseContext ctx) {
        return new Cobol.StringForPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.FOR()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitStringIntoPhrase(CobolParser.StringIntoPhraseContext ctx) {
        return new Cobol.StringIntoPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTO()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitStringSendingPhrase(CobolParser.StringSendingPhraseContext ctx) {
        return new Cobol.StringSendingPhrase(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.stringSending(), ctx.COMMACHAR()), (Cobol)this.visit(new ParseTree[]{ctx.stringDelimitedByPhrase(), ctx.stringForPhrase()}));
    }

    @Override
    public Object visitStringStatement(CobolParser.StringStatementContext ctx) {
        return new Cobol.StringStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.STRING()), this.convertAll((List)ctx.stringSendingPhrase()), (Cobol.StringIntoPhrase)this.visit((ParseTree)ctx.stringIntoPhrase()), (Cobol.StringWithPointerPhrase)this.visitNullable((ParseTree)ctx.stringWithPointerPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onOverflowPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnOverflowPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_STRING()));
    }

    @Override
    public Object visitStringWithPointerPhrase(CobolParser.StringWithPointerPhraseContext ctx) {
        return new Cobol.StringWithPointerPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.POINTER()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Cobol.Subscript visitSubscript(CobolParser.SubscriptContext ctx) {
        return new Cobol.Subscript(Space.EMPTY, Markers.EMPTY, ctx.ALL() == null && ctx.qualifiedDataName() == null && ctx.indexName() == null && ctx.arithmeticExpression() == null ? null : (Cobol)this.visit(new ParseTree[]{ctx.ALL(), ctx.qualifiedDataName(), ctx.indexName(), ctx.arithmeticExpression()}), (Cobol.Word)this.visitNullable((ParseTree)ctx.integerLiteral()));
    }

    @Override
    public Object visitSubtractCorrespondingStatement(CobolParser.SubtractCorrespondingStatementContext ctx) {
        return new Cobol.SubtractCorrespondingStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit(new ParseTree[]{ctx.CORRESPONDING(), ctx.CORR()}), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()), (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Cobol.SubtractMinuendCorresponding)this.visit((ParseTree)ctx.subtractMinuendCorresponding()));
    }

    @Override
    public Object visitSubtractFromGivingStatement(CobolParser.SubtractFromGivingStatementContext ctx) {
        return new Cobol.SubtractFromGivingStatement(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.subtractSubtrahend()), (Cobol.Word)this.visit((ParseTree)ctx.FROM()), (Name)this.visit((ParseTree)ctx.subtractMinuendGiving()), (Cobol.Word)this.visit((ParseTree)ctx.GIVING()), this.convertAll((List)ctx.subtractGiving()));
    }

    @Override
    public Object visitSubtractFromStatement(CobolParser.SubtractFromStatementContext ctx) {
        return new Cobol.SubtractFromStatement(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.subtractSubtrahend()), (Cobol.Word)this.visit((ParseTree)ctx.FROM()), this.convertAll((List)ctx.subtractMinuend()));
    }

    @Override
    public Object visitSubtractMinuendCorresponding(CobolParser.SubtractMinuendCorrespondingContext ctx) {
        return new Cobol.SubtractMinuendCorresponding(Space.EMPTY, Markers.EMPTY, (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.ROUNDED()));
    }

    @Override
    public Object visitSubtractStatement(CobolParser.SubtractStatementContext ctx) {
        return new Cobol.Subtract(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.SUBTRACT()), (Cobol)this.visit(new ParseTree[]{ctx.subtractFromStatement(), ctx.subtractFromGivingStatement(), ctx.subtractCorrespondingStatement()}), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onSizeErrorPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnSizeErrorPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_SUBTRACT()));
    }

    @Override
    public Cobol.SymbolicCharacter visitSymbolicCharacters(CobolParser.SymbolicCharactersContext ctx) {
        return new Cobol.SymbolicCharacter(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.symbolicCharacter()), ctx.IS() != null ? (Cobol.Word)this.visit((ParseTree)ctx.IS()) : (ctx.ARE() != null ? (Cobol.Word)this.visit((ParseTree)ctx.ARE()) : null), this.convertAll((List)ctx.integerLiteral()));
    }

    @Override
    public Cobol.SymbolicCharactersClause visitSymbolicCharactersClause(CobolParser.SymbolicCharactersClauseContext ctx) {
        return new Cobol.SymbolicCharactersClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYMBOLIC(), ctx.CHARACTERS(), ctx.FOR(), ctx.ALPHANUMERIC(), ctx.NATIONAL()), this.convertAll((List)ctx.symbolicCharacters()), (Cobol.Word)this.visitNullable((ParseTree)ctx.IN()), (Identifier)this.visitNullable((ParseTree)ctx.alphabetName()));
    }

    @Override
    public Object visitSymbolicDestinationClause(CobolParser.SymbolicDestinationClauseContext ctx) {
        return new Cobol.SymbolicDestinationClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYMBOLIC(), ctx.DESTINATION(), ctx.IS()), (Cobol.Word)this.visitNullable((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitSymbolicQueueClause(CobolParser.SymbolicQueueClauseContext ctx) {
        return new Cobol.SymbolicQueueClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYMBOLIC(), ctx.QUEUE(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitSymbolicSourceClause(CobolParser.SymbolicSourceClauseContext ctx) {
        return new Cobol.SymbolicSourceClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYMBOLIC(), ctx.SOURCE(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitSymbolicSubQueueClause(CobolParser.SymbolicSubQueueClauseContext ctx) {
        return new Cobol.SymbolicSubQueueClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYMBOLIC(), ctx.SUB_QUEUE_1(), ctx.SUB_QUEUE_2(), ctx.SUB_QUEUE_3(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitSymbolicTerminalClause(CobolParser.SymbolicTerminalClauseContext ctx) {
        return new Cobol.SymbolicTerminalClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.SYMBOLIC(), ctx.TERMINAL(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Cobol.TableCall visitTableCall(CobolParser.TableCallContext ctx) {
        return new Cobol.TableCall(Space.EMPTY, Markers.EMPTY, (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()), this.convertAll((List)ctx.tableCallSubscripts()), (Cobol.ReferenceModifier)this.visitNullable((ParseTree)ctx.referenceModifier()));
    }

    @Override
    public Cobol.Parenthesized visitTableCallSubscripts(CobolParser.TableCallSubscriptsContext ctx) {
        return new Cobol.Parenthesized(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.LPARENCHAR()), this.convertAllList(ctx.subscript(), ctx.COMMACHAR()), (Cobol.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
    }

    public Cobol.Word visitTerminal(TerminalNode node) {
        ArrayList<Object> objects = new ArrayList<Object>();
        Space prefix = this.processTokenText(node.getText(), objects);
        Markers markers = Markers.EMPTY;
        String text = "<EOF>".equals(node.getText()) ? "" : (node.getText().startsWith("*>CE ") ? node.getText().substring("*>CE ".length()) : node.getText());
        List cobolLines = null;
        Continuation continuation = null;
        SequenceArea sequenceArea = null;
        IndicatorArea indicatorArea = null;
        CommentArea commentArea = null;
        Replacement replacement = null;
        ArrayList preprocessorStatements = new ArrayList();
        for (Object e : objects) {
            if (e instanceof List) {
                cobolLines = (List)e;
                continue;
            }
            if (e instanceof Continuation) {
                continuation = (Continuation)e;
                continue;
            }
            if (e instanceof SequenceArea) {
                sequenceArea = (SequenceArea)e;
                continue;
            }
            if (e instanceof IndicatorArea) {
                indicatorArea = (IndicatorArea)e;
                continue;
            }
            if (e instanceof CommentArea) {
                commentArea = (CommentArea)e;
                continue;
            }
            if (e instanceof Replacement) {
                replacement = (Replacement)e;
                continue;
            }
            if (!(e instanceof CobolPreprocessor)) continue;
            if (e instanceof CopybookSource && !((CobolPreprocessor)e).getMarkers().findFirst(MissingCopybook.class).isPresent()) {
                this.copiedWordStack.add(new CopiedWord(Tree.randomId(), ((CobolPreprocessor)e).getId().toString()));
            }
            preprocessorStatements.add((CobolPreprocessor)e);
        }
        if (!this.copiedWordStack.isEmpty()) {
            markers = markers.addIfAbsent((Marker)this.copiedWordStack.peek());
        }
        return new Cobol.Word(prefix, markers, cobolLines, continuation, sequenceArea, indicatorArea, text, commentArea, replacement, preprocessorStatements.isEmpty() ? Collections.emptyList() : preprocessorStatements);
    }

    @Override
    public Object visitTerminateStatement(CobolParser.TerminateStatementContext ctx) {
        return new Cobol.Terminate(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.TERMINATE()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.reportName()));
    }

    @Override
    public Object visitTextLengthClause(CobolParser.TextLengthClauseContext ctx) {
        return new Cobol.TextLengthClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.TEXT(), ctx.LENGTH(), ctx.IS()), (Cobol.Word)this.visit((ParseTree)ctx.dataDescName()));
    }

    @Override
    public Object visitUnstringCountIn(CobolParser.UnstringCountInContext ctx) {
        return new Cobol.UnstringCountIn(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.COUNT(), ctx.IN()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitUnstringDelimitedByPhrase(CobolParser.UnstringDelimitedByPhraseContext ctx) {
        return new Cobol.UnstringDelimitedByPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DELIMITED(), ctx.BY(), ctx.ALL()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitUnstringDelimiterIn(CobolParser.UnstringDelimiterInContext ctx) {
        return new Cobol.UnstringDelimiterIn(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.DELIMITER(), ctx.IN()), (Identifier)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public Object visitUnstringInto(CobolParser.UnstringIntoContext ctx) {
        return new Cobol.UnstringInto(Space.EMPTY, Markers.EMPTY, (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol.UnstringDelimiterIn)this.visitNullable((ParseTree)ctx.unstringDelimiterIn()), (Cobol.UnstringCountIn)this.visitNullable((ParseTree)ctx.unstringCountIn()));
    }

    @Override
    public Object visitUnstringIntoPhrase(CobolParser.UnstringIntoPhraseContext ctx) {
        return new Cobol.UnstringIntoPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.INTO()), this.convertAll((List)ctx.unstringInto()));
    }

    @Override
    public Object visitUnstringOrAllPhrase(CobolParser.UnstringOrAllPhraseContext ctx) {
        return new Cobol.UnstringOrAllPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.OR(), ctx.ALL()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitUnstringSendingPhrase(CobolParser.UnstringSendingPhraseContext ctx) {
        return new Cobol.UnstringSendingPhrase(Space.EMPTY, Markers.EMPTY, (Identifier)this.visit((ParseTree)ctx.identifier()), (Cobol.UnstringDelimitedByPhrase)this.visitNullable((ParseTree)ctx.unstringDelimitedByPhrase()), this.convertAll((List)ctx.unstringOrAllPhrase()));
    }

    @Override
    public Object visitUnstringStatement(CobolParser.UnstringStatementContext ctx) {
        return new Cobol.UnString(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.UNSTRING()), (Cobol.UnstringSendingPhrase)this.visit((ParseTree)ctx.unstringSendingPhrase()), (Cobol.UnstringIntoPhrase)this.visit((ParseTree)ctx.unstringIntoPhrase()), (Cobol.UnstringWithPointerPhrase)this.visitNullable((ParseTree)ctx.unstringWithPointerPhrase()), (Cobol.UnstringTallyingPhrase)this.visitNullable((ParseTree)ctx.unstringTallyingPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.onOverflowPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notOnOverflowPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_UNSTRING()));
    }

    @Override
    public Object visitUnstringTallyingPhrase(CobolParser.UnstringTallyingPhraseContext ctx) {
        return new Cobol.UnstringTallyingPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.TALLYING(), ctx.IN()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Object visitUnstringWithPointerPhrase(CobolParser.UnstringWithPointerPhraseContext ctx) {
        return new Cobol.UnstringWithPointerPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WITH(), ctx.POINTER()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.qualifiedDataName()));
    }

    @Override
    public Object visitUseAfterClause(CobolParser.UseAfterClauseContext ctx) {
        return new Cobol.UseAfterClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.GLOBAL(), ctx.AFTER(), ctx.STANDARD(), ctx.EXCEPTION(), ctx.ERROR(), ctx.PROCEDURE(), ctx.ON()), (Cobol.UseAfterOn)this.visit((ParseTree)ctx.useAfterOn()));
    }

    @Override
    public Object visitUseAfterOn(CobolParser.UseAfterOnContext ctx) {
        return new Cobol.UseAfterOn(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.INPUT(), ctx.OUTPUT(), ctx.I_O(), ctx.EXTEND()), this.convertAll((List)ctx.fileName()));
    }

    @Override
    public Object visitUseDebugClause(CobolParser.UseDebugClauseContext ctx) {
        return new Cobol.UseDebugClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.FOR(), ctx.DEBUGGING(), ctx.ON()), this.convertAll((List)ctx.useDebugOn()));
    }

    @Override
    public Object visitUseDebugOn(CobolParser.UseDebugOnContext ctx) {
        return new Cobol.UseDebugOn(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.ALL(), ctx.PROCEDURES(), ctx.REFERENCES(), ctx.OF()), ctx.PROCEDURES() != null ? null : (Cobol)this.visit(new ParseTree[]{ctx.identifier(), ctx.fileName(), ctx.procedureName()}));
    }

    @Override
    public Object visitUseStatement(CobolParser.UseStatementContext ctx) {
        return new Cobol.UseStatement(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.USE()), (Cobol)this.visit(new ParseTree[]{ctx.useAfterClause(), ctx.useDebugClause()}));
    }

    @Override
    public Object visitValueOfClause(CobolParser.ValueOfClauseContext ctx) {
        return new Cobol.ValueOfClause(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.VALUE(), ctx.OF()), this.convertAll((List)ctx.valuePair()));
    }

    @Override
    public Object visitValuePair(CobolParser.ValuePairContext ctx) {
        return new Cobol.ValuePair(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.systemName()), (Cobol.Word)this.visitNullable((ParseTree)ctx.IS()), (Name)this.visit(new ParseTree[]{ctx.qualifiedDataName(), ctx.literal()}));
    }

    @Override
    public Cobol.WorkingStorageSection visitWorkingStorageSection(CobolParser.WorkingStorageSectionContext ctx) {
        return new Cobol.WorkingStorageSection(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.WORKING_STORAGE(), ctx.SECTION()), (Cobol.Word)this.visit((ParseTree)ctx.DOT_FS()), this.convertAll((List)ctx.dataDescriptionEntry()));
    }

    @Override
    public Object visitWriteAdvancingLines(CobolParser.WriteAdvancingLinesContext ctx) {
        return new Cobol.WriteAdvancingLines(Space.EMPTY, Markers.EMPTY, (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}), ctx.LINE() != null ? (Cobol.Word)this.visit((ParseTree)ctx.LINE()) : (ctx.LINES() != null ? (Cobol.Word)this.visit((ParseTree)ctx.LINES()) : null));
    }

    @Override
    public Object visitWriteAdvancingMnemonic(CobolParser.WriteAdvancingMnemonicContext ctx) {
        return new Cobol.WriteAdvancingMnemonic(Space.EMPTY, Markers.EMPTY, (Name)this.visit((ParseTree)ctx.mnemonicName()));
    }

    @Override
    public Object visitWriteAdvancingPage(CobolParser.WriteAdvancingPageContext ctx) {
        return new Cobol.WriteAdvancingPage(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.PAGE()));
    }

    @Override
    public Object visitWriteAdvancingPhrase(CobolParser.WriteAdvancingPhraseContext ctx) {
        return new Cobol.WriteAdvancingPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.BEFORE(), ctx.AFTER(), ctx.ADVANCING()), (Cobol)this.visit(new ParseTree[]{ctx.writeAdvancingPage(), ctx.writeAdvancingLines(), ctx.writeAdvancingMnemonic()}));
    }

    @Override
    public Object visitWriteAtEndOfPagePhrase(CobolParser.WriteAtEndOfPagePhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.AT(), ctx.END_OF_PAGE(), ctx.EOP()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitWriteFromPhrase(CobolParser.WriteFromPhraseContext ctx) {
        return new Cobol.WriteFromPhrase(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visitNullable((ParseTree)ctx.FROM()), (Name)this.visit(new ParseTree[]{ctx.identifier(), ctx.literal()}));
    }

    @Override
    public Object visitWriteNotAtEndOfPagePhrase(CobolParser.WriteNotAtEndOfPagePhraseContext ctx) {
        return new Cobol.StatementPhrase(Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.NOT(), ctx.AT(), ctx.END_OF_PAGE(), ctx.EOP()), this.convertAll((List)ctx.statement()));
    }

    @Override
    public Object visitWriteStatement(CobolParser.WriteStatementContext ctx) {
        return new Cobol.Write(Space.EMPTY, Markers.EMPTY, (Cobol.Word)this.visit((ParseTree)ctx.WRITE()), (Cobol.QualifiedDataName)this.visit((ParseTree)ctx.recordName()), (Cobol.WriteFromPhrase)this.visitNullable((ParseTree)ctx.writeFromPhrase()), (Cobol.WriteAdvancingPhrase)this.visitNullable((ParseTree)ctx.writeAdvancingPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.writeAtEndOfPagePhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.writeNotAtEndOfPagePhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.invalidKeyPhrase()), (Cobol.StatementPhrase)this.visitNullable((ParseTree)ctx.notInvalidKeyPhrase()), (Cobol.Word)this.visitNullable((ParseTree)ctx.END_WRITE()));
    }

    private Space whitespace() {
        int endIndex = this.indexOfNextNonWhitespace(this.cursor, this.source);
        String prefix = this.source.substring(this.cursor, endIndex);
        this.cursor += prefix.length();
        return Space.build(prefix);
    }

    private int indexOfNextNonWhitespace(int cursor, String source) {
        int delimIndex;
        boolean isColumnArea = false;
        for (delimIndex = cursor; delimIndex < source.length(); ++delimIndex) {
            char next;
            char c = source.charAt(delimIndex);
            boolean bl = isColumnArea = this.sequenceAreas.containsKey(delimIndex) || this.indicatorAreas.containsKey(delimIndex) || this.commentAreas.containsKey(delimIndex);
            if ((!Character.isWhitespace(c) || isColumnArea) && (c != ',' && (c != ';' || delimIndex + 1 >= source.length() - 1) || (next = source.charAt(delimIndex + 1)) != ' ' && next != '\r' && next != '\n')) break;
        }
        if (!isColumnArea && this.nextIndex != null && this.nextIndex > 0) {
            int totalWhitespace = delimIndex - cursor;
            int prefixCount = this.nextIndex > totalWhitespace ? this.nextIndex - totalWhitespace : totalWhitespace - this.nextIndex;
            int templateWhitespace = totalWhitespace - prefixCount;
            this.cursor += templateWhitespace;
            delimIndex = this.cursor + prefixCount;
            this.nextIndex = null;
            this.removeColumnMarkers = true;
        }
        return delimIndex;
    }

    @Nullable
    private List<Cobol.Word> wordsList(TerminalNode ... wordNodes) {
        ArrayList<Cobol.Word> words = new ArrayList<Cobol.Word>(wordNodes.length);
        for (TerminalNode wordNode : wordNodes) {
            if (wordNode == null) continue;
            Cobol.Word cw = (Cobol.Word)this.visit((ParseTree)wordNode);
            words.add(cw);
        }
        if (words.isEmpty()) {
            return null;
        }
        return words;
    }

    private <C, T extends ParseTree> List<C> convertAll(List<T> trees, Function<T, C> convert) {
        ArrayList converted = new ArrayList(trees.size());
        for (ParseTree tree : trees) {
            converted.add(convert.apply(tree));
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    @SafeVarargs
    private final <C extends Cobol> List<C> convertAll(List<? extends ParserRuleContext> ... trees) {
        ArrayList<Object> rules = new ArrayList<Object>();
        for (List<? extends ParserRuleContext> tree : trees) {
            if (tree == null) continue;
            rules.addAll(tree);
        }
        rules.sort(Comparator.comparingInt(it -> it.start.getStartIndex()));
        return this.convertAll((List)rules);
    }

    private <C extends Cobol, T extends ParseTree> List<C> convertAll(List<T> trees) {
        return this.convertAll(trees, (T t) -> (Cobol)this.visit((ParseTree)t));
    }

    @SafeVarargs
    private final List<Cobol> convertAllList(List<? extends ParseTree> ... trees) {
        ArrayList<ParseTree> parseTrees = new ArrayList<ParseTree>();
        for (List<? extends ParseTree> tree : trees) {
            for (ParseTree parseTree : tree) {
                if (parseTree == null) continue;
                parseTrees.add(parseTree);
            }
        }
        parseTrees.sort(Comparator.comparingInt(it -> it instanceof TerminalNode ? ((TerminalNode)it).getSymbol().getStartIndex() : ((ParserRuleContext)it).getStart().getStartIndex()));
        ArrayList parsed = new ArrayList();
        for (ParseTree pt : parseTrees) {
            parsed.add((Cobol)this.visit(pt));
        }
        return parsed.isEmpty() ? Collections.emptyList() : parsed;
    }

    private Space processTokenText(String text, List<Object> objects) {
        this.parseCommentsAndEmptyLines(text, objects);
        int saveCursor = this.cursor;
        this.sequenceArea();
        this.indicatorArea();
        Map.Entry<Integer, String> nextIndicator = this.indicatorAreas.higherEntry(this.cursor);
        boolean isContinued = nextIndicator != null && nextIndicator.getValue().equals("-");
        this.cursor = saveCursor;
        Character delimiter = null;
        if (text.startsWith("'") || text.startsWith("\"")) {
            delimiter = Character.valueOf(text.charAt(0));
        }
        if (delimiter != null && isContinued) {
            return this.processLiteral(text, objects, delimiter);
        }
        if ("<EOF>".equals(text) && this.source.substring(this.cursor).isEmpty()) {
            return Space.EMPTY;
        }
        return this.processText(text, objects, isContinued);
    }

    private void parseCommentsAndEmptyLines(String text, List<Object> objects) {
        int saveCursor = this.cursor;
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        boolean isCommentEntry = text.startsWith("*>CE ");
        if (!isCommentEntry) {
            ArrayList<CobolLine> lines = new ArrayList<CobolLine>();
            int max = 10000;
            for (int iterations = 0; iterations < max && !this.source.substring(this.cursor).isEmpty(); ++iterations) {
                int newLinePos = this.cursor + (this.source.substring(this.cursor).contains("\n") ? this.source.substring(this.cursor).indexOf("\n") : this.source.substring(this.cursor).length());
                int endOfContentArea = this.cursor - this.cobolDialect.getColumns().getIndicatorArea() - 1 + this.cobolDialect.getColumns().getOtherArea();
                String contentArea = this.source.substring(this.cursor, Math.min(newLinePos, endOfContentArea));
                if (!CobolParserVisitor.isCommentIndicator(indicatorArea) && !contentArea.trim().isEmpty() && !this.templateKeys.contains(contentArea)) break;
                if (this.templateKeys.contains(contentArea)) {
                    if (this.replaceStartComment.equals(contentArea)) {
                        this.replaceStartComment();
                    } else if (this.replaceAdditiveWhitespaceComment.equals(contentArea)) {
                        this.replaceAdditiveWhitespace();
                    } else if (this.replaceUuidComment.equals(contentArea)) {
                        objects.add(this.getReplace());
                    } else if (this.replaceAdditiveTypeStartComment.equals(contentArea)) {
                        this.replaceAdditiveStartComment();
                    } else if (this.replaceAdditiveTypeStopComment.equals(contentArea)) {
                        this.replaceAdditiveStopComment();
                    } else if (this.replaceReductiveTypeStartComment.equals(contentArea)) {
                        objects.add(this.getReplaceReductiveType());
                    } else if (this.replaceAddWordStartComment.equals(contentArea)) {
                        this.parseComment(this.replaceAddWordStartComment);
                        iterations = max;
                    } else if (this.replaceAddWordStopComment.equals(contentArea)) {
                        this.parseComment(this.replaceAddWordStopComment);
                    } else if (this.copyStartComment.equals(contentArea)) {
                        this.copyStartComment();
                    } else if (this.copyUuidComment.equals(contentArea)) {
                        CobolPreprocessor copybookSource = this.copyUuidComment();
                        int savedCursor = this.cursor;
                        this.sequenceArea();
                        this.indicatorArea();
                        newLinePos = this.cursor + (this.source.substring(this.cursor).contains("\n") ? this.source.substring(this.cursor).indexOf("\n") : this.source.substring(this.cursor).length());
                        endOfContentArea = this.cursor - this.cobolDialect.getColumns().getIndicatorArea() - 1 + this.cobolDialect.getColumns().getOtherArea();
                        contentArea = this.source.substring(this.cursor, Math.min(newLinePos, endOfContentArea));
                        if (this.copybookNotFoundComment.equals(contentArea)) {
                            copybookSource = this.copybookNotFoundComment((CopybookSource)((Object)copybookSource), lines);
                            this.copiedWordStack.add(new CopiedWord(Tree.randomId(), copybookSource.getId().toString()));
                            lines.clear();
                        } else {
                            this.cursor = savedCursor;
                        }
                        objects.add(copybookSource);
                    } else if (this.copyStopComment.equals(contentArea)) {
                        this.copyStopComment();
                    } else if (this.preprocessorStartComment.equals(contentArea)) {
                        objects.add(this.getPreprocessorStatement());
                    }
                } else {
                    this.cursor += contentArea.length();
                    CommentArea commentArea = this.commentArea();
                    CobolLine line = indicatorArea != null && "*".equals(indicatorArea.getIndicator()) ? new CommentLine(Markers.EMPTY, sequenceArea, indicatorArea, contentArea, commentArea, !this.copiedWordStack.isEmpty()) : new BlankLine(Markers.EMPTY, sequenceArea, indicatorArea, contentArea, commentArea, !this.copiedWordStack.isEmpty());
                    lines.add(line);
                }
                saveCursor = this.cursor;
                sequenceArea = this.sequenceArea();
                indicatorArea = this.indicatorArea();
            }
            if (!lines.isEmpty()) {
                objects.add(lines);
            }
        }
        this.cursor = saveCursor;
    }

    private Space processLiteral(String text, List<Object> objects, Character delimiter) {
        HashMap<Integer, List<ColumnArea>> continuations = new HashMap<Integer, List<ColumnArea>>();
        ArrayList<ColumnArea> continuation = new ArrayList<ColumnArea>(2);
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        if (sequenceArea != null) {
            continuation.add(sequenceArea);
        }
        if (indicatorArea != null) {
            continuation.add(indicatorArea);
        }
        Space prefix = this.whitespace();
        if (!continuation.isEmpty()) {
            continuations.put(0, continuation);
        }
        int matchedCount = 0;
        for (int iterations = 0; matchedCount < text.length() && iterations < 250; ++iterations) {
            int end;
            continuation = new ArrayList(3);
            String current = this.source.substring(this.cursor);
            char[] charArray = text.substring(matchedCount).toCharArray();
            char[] sourceArray = current.toCharArray();
            for (end = 0; end < charArray.length && charArray[end] == sourceArray[end] && !this.commentAreas.containsKey(this.cursor); ++end) {
                ++this.cursor;
            }
            String matchedText = current.substring(0, end);
            matchedCount += matchedText.length();
            CommentArea commentArea = this.commentArea();
            if (commentArea != null) {
                continuation.add(commentArea);
            }
            if (matchedCount == text.length()) {
                if (continuation.isEmpty()) break;
                continuations.put(matchedCount + 1, continuation);
                break;
            }
            sequenceArea = this.sequenceArea();
            indicatorArea = this.indicatorArea(delimiter, true);
            if (sequenceArea != null) {
                continuation.add(sequenceArea);
            }
            if (indicatorArea != null) {
                continuation.add(indicatorArea);
            }
            if (continuation.isEmpty()) continue;
            continuations.put(matchedCount, continuation);
        }
        objects.add(new Continuation(Markers.EMPTY, continuations));
        return prefix;
    }

    private Space processText(String text, List<Object> objects, boolean checkContinuation) {
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        boolean isCommentEntry = text.startsWith("*>CE ");
        if (isCommentEntry) {
            text = text.substring("*>CE ".length());
        }
        Space prefix = isCommentEntry ? Space.EMPTY : this.whitespace();
        boolean isContinued = false;
        if (checkContinuation) {
            Integer nextCommentArea = null;
            for (Integer it : this.commentAreas.keySet()) {
                if (it <= this.cursor) continue;
                nextCommentArea = it;
                break;
            }
            String current = this.source.substring(this.cursor);
            int newLinePos = current.indexOf("\n");
            int endPos = nextCommentArea != null && nextCommentArea < newLinePos + this.cursor ? nextCommentArea : newLinePos + this.cursor;
            current = this.source.substring(this.cursor, endPos).trim();
            if (!current.startsWith(text)) {
                HashMap<Integer, List<ColumnArea>> continuations = new HashMap<Integer, List<ColumnArea>>();
                ArrayList<ColumnArea> continuation = new ArrayList<ColumnArea>(2);
                if (sequenceArea != null) {
                    continuation.add(sequenceArea);
                }
                if (indicatorArea != null) {
                    continuation.add(indicatorArea);
                }
                if (!continuation.isEmpty()) {
                    continuations.put(0, continuation);
                }
                int matchedCount = 0;
                for (int iterations = 0; iterations < 250; ++iterations) {
                    int end;
                    continuation = new ArrayList(3);
                    current = this.source.substring(this.cursor);
                    char[] charArray = text.substring(matchedCount).toCharArray();
                    char[] sourceArray = current.toCharArray();
                    for (end = 0; end < charArray.length && charArray[end] == sourceArray[end] && !this.commentAreas.containsKey(this.cursor); ++end) {
                        ++this.cursor;
                    }
                    String matchedText = current.substring(0, end);
                    matchedCount += matchedText.length();
                    CommentArea commentArea = this.commentArea();
                    if (commentArea != null) {
                        continuation.add(commentArea);
                    }
                    if (matchedCount == text.length()) {
                        if (continuation.isEmpty()) break;
                        continuations.put(matchedCount + 1, continuation);
                        break;
                    }
                    sequenceArea = this.sequenceArea();
                    if (sequenceArea != null) {
                        continuation.add(sequenceArea);
                    }
                    if ((indicatorArea = this.indicatorArea(Character.valueOf(text.charAt(matchedCount)), false)) != null) {
                        continuation.add(indicatorArea);
                    }
                    if (continuation.isEmpty()) continue;
                    continuations.put(matchedCount, continuation);
                }
                objects.add(new Continuation(Markers.EMPTY, continuations));
                isContinued = true;
            }
        }
        if (this.replaceAdditiveType != null) {
            objects.add(this.replaceAdditiveType);
            this.cursor += text.length();
            int end = this.source.substring(this.cursor).indexOf("\n") + 1;
            this.cursor += end;
        } else if (!isContinued) {
            if (this.removeColumnMarkers) {
                this.removeColumnMarkers = false;
            } else {
                if (sequenceArea != null) {
                    objects.add(sequenceArea);
                }
                if (indicatorArea != null) {
                    objects.add(indicatorArea);
                }
            }
            if (!"<EOF>".equals(text)) {
                this.cursor += text.length();
                CommentArea commentArea = this.commentArea();
                if (commentArea != null) {
                    objects.add(commentArea);
                }
            }
        }
        return prefix;
    }

    private String getCommentFromKey(String key) {
        int contentAreaStart = this.cobolDialect.getColumns().getContentArea();
        int contentAreaEnd = this.cobolDialect.getColumns().getOtherArea();
        return key.substring(contentAreaStart, contentAreaEnd);
    }

    private void copyStartComment() {
        this.parseComment(this.copyStartComment);
        this.removeTemplateCommentArea = true;
        this.removeColumnMarkers = false;
        this.nextIndex = null;
    }

    private void copyStopComment() {
        this.parseComment(this.copyStopComment);
        if (!this.copiedWordStack.isEmpty()) {
            this.copiedWordStack.pop();
        }
        this.sequenceArea();
        this.indicatorArea();
        String numberOfSpaces = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1);
        this.cursor += numberOfSpaces.length();
        this.nextIndex = Integer.valueOf(numberOfSpaces.trim());
    }

    private CobolPreprocessor copyUuidComment() {
        this.parseComment(this.copyUuidComment);
        this.removeTemplateCommentArea = false;
        String uuid = this.getUuid();
        return this.preprocessorMap.get(uuid.trim());
    }

    private CobolPreprocessor copybookNotFoundComment(CopybookSource copybookSource, List<CobolLine> lines) {
        this.parseComment(this.copybookNotFoundComment);
        return copybookSource.withCopybook(new CobolPreprocessor.Copybook(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Paths.get("", ""), null, null, false, null, Collections.singletonList(new CobolPreprocessor.Word(Space.EMPTY, Markers.EMPTY, new Cobol.Word(Space.EMPTY, Markers.EMPTY, lines, null, null, null, "", null, null, Collections.emptyList()))), new CobolPreprocessor.Word(Space.EMPTY, Markers.EMPTY, new Cobol.Word(Space.EMPTY, Markers.EMPTY, null, null, null, null, "", null, null, Collections.emptyList()))));
    }

    private void replaceAdditiveWhitespace() {
        this.parseComment(this.replaceAdditiveWhitespaceComment);
        this.removeTemplateCommentArea = false;
        this.isAdditiveCommentArea = true;
    }

    private void replaceStartComment() {
        this.parseComment(this.replaceStartComment);
        this.removeTemplateCommentArea = true;
        this.removeColumnMarkers = false;
        this.nextIndex = null;
    }

    private void replaceAdditiveStartComment() {
        this.parseComment(this.replaceAdditiveTypeStartComment);
        String current = this.source.substring(this.cursor);
        current = current.substring(0, current.indexOf("\n") + 1);
        this.cursor += current.length();
        this.parseComment(this.uuidComment);
        this.removeTemplateCommentArea = false;
        String uuid = this.getUuid();
        this.replaceAdditiveType = this.replaceMap.get(uuid.trim());
    }

    private void replaceAdditiveStopComment() {
        this.parseComment(this.replaceAdditiveTypeStopComment);
        this.sequenceArea();
        this.indicatorArea();
        String numberOfSpaces = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1);
        this.cursor += numberOfSpaces.length();
        this.nextIndex = Integer.valueOf(numberOfSpaces.trim());
        this.replaceAdditiveType = null;
    }

    private void parseFully(String comment) {
        this.parseComment(comment);
        String current = this.source.substring(this.cursor);
        current = current.substring(0, current.indexOf("\n") + 1);
        this.cursor += current.length();
    }

    private Replacement getReplace() {
        this.parseComment(this.replaceUuidComment);
        this.removeTemplateCommentArea = false;
        String uuid = this.getUuid();
        Replacement replacement = this.replaceMap.get(uuid.trim());
        this.parseComment(this.replaceStopComment);
        if (this.isAdditiveCommentArea) {
            this.isAdditiveCommentArea = false;
        } else {
            this.sequenceArea();
            this.indicatorArea();
            String numberOfSpaces = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1);
            this.cursor += numberOfSpaces.length();
            this.nextIndex = Integer.valueOf(numberOfSpaces.trim());
        }
        return replacement;
    }

    private Replacement getReplaceReductiveType() {
        this.parseComment(this.replaceReductiveTypeStartComment);
        this.parseComment(this.uuidComment);
        this.removeTemplateCommentArea = false;
        String uuid = this.getUuid();
        Replacement replacement = this.replaceMap.get(uuid.trim());
        this.parseComment(this.replaceReductiveTypeStopComment);
        this.sequenceArea();
        this.indicatorArea();
        String numberOfSpaces = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1);
        this.cursor += numberOfSpaces.length();
        this.nextIndex = Integer.valueOf(numberOfSpaces.trim());
        return replacement;
    }

    private List<CobolPreprocessor.CompilerOptions> getCompilerOptions() {
        ArrayList compilerOptions = new ArrayList();
        for (int max = 0; max < 200; ++max) {
            int start = this.cursor;
            this.sequenceArea();
            this.indicatorArea();
            if (!this.source.substring(this.cursor).startsWith(this.compileOptionStartComment)) {
                this.cursor = start;
                break;
            }
            this.cursor += this.compileOptionStartComment.length();
            ++this.cursor;
            this.sequenceArea();
            this.indicatorArea();
            this.cursor += this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1).length();
            this.parseComment(this.uuidComment);
            String uuid = this.getUuid().trim();
            this.parseComment(this.compileOptionStopComment);
            this.sequenceArea();
            this.indicatorArea();
            this.cursor += this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1).length();
            CobolPreprocessor.CompilerOptions co = (CobolPreprocessor.CompilerOptions)this.preprocessorMap.get(uuid);
            if (co == null) continue;
            compilerOptions.add(co);
        }
        return compilerOptions.isEmpty() ? Collections.emptyList() : compilerOptions;
    }

    private CobolPreprocessor getPreprocessorStatement() {
        this.parseFully(this.preprocessorStartComment);
        this.parseComment(this.uuidComment);
        String uuid = this.getUuid();
        this.parseComment(this.preprocessorStopComment);
        this.sequenceArea();
        this.indicatorArea();
        String numberOfSpaces = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1);
        this.cursor += numberOfSpaces.length();
        this.nextIndex = Integer.valueOf(numberOfSpaces.trim());
        return this.preprocessorMap.get(uuid.trim());
    }

    private void parseComment(String comment) {
        this.sequenceArea();
        this.indicatorArea();
        this.cursor += comment.length();
        ++this.cursor;
    }

    private String getUuid() {
        this.sequenceArea();
        this.indicatorArea();
        String uuid = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf("\n") + 1);
        this.cursor += uuid.length();
        return uuid;
    }

    private static boolean isCommentIndicator(@Nullable IndicatorArea area) {
        boolean isUnknownIndicator = area != null && ("G".equals(area.getIndicator()) || "J".equals(area.getIndicator()) || "P".equals(area.getIndicator()));
        return area != null && (isUnknownIndicator || commentIndicators.contains(Character.valueOf(area.getIndicator().charAt(0))));
    }

    @Nullable
    private SequenceArea sequenceArea() {
        if (this.sequenceAreas.containsKey(this.cursor)) {
            String sequence = this.sequenceAreas.get(this.cursor);
            this.cursor += sequence.length();
            return new SequenceArea(Markers.EMPTY, sequence);
        }
        return null;
    }

    @Nullable
    private IndicatorArea indicatorArea() {
        return this.indicatorArea(null, false);
    }

    @Nullable
    private IndicatorArea indicatorArea(@Nullable Character continuationDelimiter, boolean isStringLiteral) {
        if (this.indicatorAreas.containsKey(this.cursor)) {
            String current;
            int pos;
            String indicatorArea = (String)this.indicatorAreas.get(this.cursor);
            this.cursor += indicatorArea.length();
            String continuationText = null;
            if (continuationDelimiter != null && (pos = (current = this.source.substring(this.cursor)).indexOf(continuationDelimiter.charValue())) != -1) {
                int endPos = (isStringLiteral ? 1 : 0) + current.indexOf(continuationDelimiter.charValue());
                continuationText = current.substring(0, endPos);
                this.cursor += continuationText.length();
            }
            return new IndicatorArea(Markers.EMPTY, indicatorArea, continuationText);
        }
        return null;
    }

    @Nullable
    private CommentArea commentArea() {
        int saveCursor = this.cursor;
        Space before = this.whitespace();
        String comment = null;
        Space endLine = Space.EMPTY;
        if (this.commentAreas.containsKey(this.cursor)) {
            comment = (String)this.commentAreas.get(this.cursor);
            this.cursor += comment.length();
            endLine = this.whitespace();
        }
        if (!(this.removeTemplateCommentArea && comment == null && before.getWhitespace().endsWith("\n") || !before.getWhitespace().endsWith("\n") && comment == null)) {
            return new CommentArea(before, Markers.EMPTY, comment == null ? "" : comment, endLine, this.isAdditiveCommentArea);
        }
        if (!this.removeTemplateCommentArea || !before.getWhitespace().endsWith("\n")) {
            this.cursor = saveCursor;
        }
        return null;
    }

    public CobolParserVisitor(Path path, FileAttributes fileAttributes, String source, Charset charset, boolean charsetBomMarked, CobolDialect cobolDialect, Map<String, CobolPreprocessor> preprocessorMap, Map<String, Replacement> replaceMap, Duration timeout) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.cobolDialect = cobolDialect;
        this.preprocessorMap = preprocessorMap;
        this.replaceMap = replaceMap;
        this.timeout = timeout;
    }
}

