/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.CobolPrinterUtils;
import org.openrewrite.cobol.CobolStringUtils;
import org.openrewrite.cobol.internal.CobolDialect;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.CopybookSource;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

public class CobolPreprocessorOutputSourcePrinter<P>
extends CobolPreprocessorSourcePrinter<P> {
    public static final String COPY_START_KEY = "__COPY_START__";
    public static final String COPY_STOP_KEY = "__COPY_STOP__";
    public static final String COPY_UUID_KEY = "__COPY_UUID__";
    public static final String COPYBOOK_NOT_FOUND = "__COPYBOOK_NOT_FOUND__";
    public static final String REPLACE_START_KEY = "__REPLACE_START__";
    public static final String REPLACE_STOP_KEY = "__REPLACE_STOP__";
    public static final String REPLACE_UUID_KEY = "__REPLACE_UUID__";
    public static final String REPLACE_TYPE_ADDITIVE_START_KEY = "__REPLACE_TYPE_ADDITIVE_START__";
    public static final String REPLACE_TYPE_ADDITIVE_STOP_KEY = "__REPLACE_TYPE_ADDITIVE_STOP__";
    public static final String REPLACE_ADD_WORD_START_KEY = "__REPLACE_ADD_WORD_START__";
    public static final String REPLACE_ADD_WORD_STOP_KEY = "__REPLACE_ADD_WORD_STOP__";
    public static final String REPLACE_TYPE_REDUCTIVE_START_KEY = "__REPLACE_TYPE_REDUCTIVE_START__";
    public static final String REPLACE_TYPE_REDUCTIVE_STOP_KEY = "__REPLACE_TYPE_REDUCTIVE_STOP__";
    public static final String REPLACE_ADDED_WHITESPACE_KEY = "__REPLACE_ADDED_WHITESPACE__";
    public static final String COMPILER_OPTIONS_START_KEY = "__COMPILER_OPTIONS_START__";
    public static final String COMPILER_OPTIONS_STOP_KEY = "__COMPILER_OPTIONS_STOP__";
    public static final String PREPROCESSOR_START_KEY = "__PREPROCESSOR_START__";
    public static final String PREPROCESSOR_STOP_KEY = "__PREPROCESSOR_STOP__";
    public static final String UUID_KEY = "__UUID__";
    private final CobolSourcePrinter<P> cobolSourcePrinter;
    private final CobolDialect cobolDialect;
    private final boolean printColumns;
    private String dialectSequenceArea = null;
    private String uuidEndOfLine = null;
    private String copyStartComment = null;
    private String copyStopComment = null;
    private String copyUuidComment = null;
    private String copybookNotFoundComment = null;
    private String replaceStartComment = null;
    private String replaceStopComment = null;
    private String replaceUuidComment = null;
    private String uuidComment = null;
    private String replaceTypeAdditiveStartComment = null;
    private String replaceTypeAdditiveStopComment = null;
    private String replaceAddWordStartComment = null;
    private String replaceAddWordStopComment = null;
    private String replaceTypeReductiveStartComment = null;
    private String replaceTypeReductiveStopComment = null;
    private Replacement replaceReductiveType = null;
    private String replaceAddedWhitespaceComment = null;
    private String compilerOptionsStartComment = null;
    private String compilerOptionsStopComment = null;
    private String preprocessorStartComment = null;
    private String preprocessorStopComment = null;
    private final CobolPreprocessorSourcePrinter<ExecutionContext> statementPrinter = new CobolPreprocessorSourcePrinter(false);
    private final CobolSourcePrinter<ExecutionContext> cobolStatementPrinter = new CobolSourcePrinter(false);
    private boolean inUnknownIndicator = false;

    public CobolPreprocessorOutputSourcePrinter(CobolDialect cobolDialect, boolean printColumns) {
        super(true);
        this.cobolSourcePrinter = new CobolSourcePrinter(printColumns);
        this.cobolDialect = cobolDialect;
        this.printColumns = printColumns;
    }

    @Override
    public CobolPreprocessor visitCompilerOptions(CobolPreprocessor.CompilerOptions compilerOptions, PrintOutputCapture<P> p) {
        if (this.printColumns) {
            int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
            curIndex = curIndex == -1 ? 0 : curIndex;
            this.addStartKey(this.getCompilerOptionsStartComment(), curIndex, p);
            this.addUuidKey(this.getUuidComment(), compilerOptions.getId(), p);
            this.addStopComment(this.getCompilerOptionsStopComment(), null, curIndex, p);
        }
        return compilerOptions;
    }

    @Override
    public CobolPreprocessor visitCommentEntry(CobolPreprocessor.CommentEntry commentEntry, PrintOutputCapture<P> p) {
        if (this.printColumns) {
            super.visitCommentEntry(commentEntry, p);
        } else {
            this.visitSpace(commentEntry.getPrefix(), Space.Location.COMMENT_ENTRY_PREFIX, p);
            this.visitMarkers(commentEntry.getMarkers(), p);
            for (CobolPreprocessor.Word comment : commentEntry.getComments()) {
                p.append("*>CE ");
                this.visit(comment, p);
            }
        }
        return commentEntry;
    }

    @Override
    public CobolPreprocessor visitCopybook(CobolPreprocessor.Copybook copybook, PrintOutputCapture<P> p) {
        this.visitSpace(copybook.getPrefix(), Space.Location.COPY_BOOK_PREFIX, p);
        this.visitMarkers(copybook.getMarkers(), p);
        for (CobolPreprocessor cobolPreprocessor : copybook.getLst()) {
            if (cobolPreprocessor instanceof CobolPreprocessor.CompilerOptions || cobolPreprocessor instanceof CobolPreprocessor.EjectStatement || cobolPreprocessor instanceof CobolPreprocessor.ExecStatement || cobolPreprocessor instanceof CobolPreprocessor.SkipStatement || cobolPreprocessor instanceof CobolPreprocessor.TitleStatement) continue;
            this.visit(cobolPreprocessor, p);
        }
        this.visit(copybook.getEof(), p);
        return copybook;
    }

    @Override
    public CobolPreprocessor visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, PrintOutputCapture<P> p) {
        this.visitSpace(copyStatement.getPrefix(), Space.Location.COPY_STATEMENT_PREFIX, p);
        this.visitMarkers(copyStatement.getMarkers(), p);
        this.printCopybookSource(copyStatement, p);
        return copyStatement;
    }

    private void printCopybookSource(CopybookSource copybookSource, PrintOutputCapture<P> p) {
        if (!this.printColumns) {
            this.visit(copybookSource.getCopybook(), p);
            if (!p.getOut().endsWith("\n")) {
                p.append("\n");
            }
            return;
        }
        if (copybookSource instanceof CobolPreprocessor.CopyStatement) {
            CobolPreprocessor.CopyStatement cs = (CobolPreprocessor.CopyStatement)copybookSource;
            this.visit(cs.getWord(), p);
            p.out.delete(p.getOut().length() - cs.getWord().getCobolWord().getWord().length() - cs.getWord().getPrefix().getWhitespace().length(), p.getOut().length());
        } else {
            CobolPreprocessor.ExecSqlIncludeStatement es = (CobolPreprocessor.ExecSqlIncludeStatement)copybookSource;
            this.visit(es.getWords().get(0), p);
            p.out.delete(p.getOut().length() - es.getWords().get(0).getCobolWord().getWord().length() - es.getWords().get(0).getPrefix().getWhitespace().length(), p.getOut().length());
        }
        int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
        this.addStartKey(this.getCopyStartComment(), curIndex, p);
        this.addUuidKey(this.getCopyUuidKey(), ((CobolPreprocessor)((Object)copybookSource)).getId(), p);
        if (copybookSource.getCopybook() == null) {
            p.append(this.getCopybookNotFound());
        } else {
            this.visit(copybookSource.getCopybook(), p);
        }
        if (!p.getOut().endsWith("\n")) {
            p.append("\n");
        }
        this.addStopComment(this.getCopyStopComment(), (CobolPreprocessor)((Object)copybookSource), curIndex, p);
    }

    @Override
    public CobolPreprocessor visitEjectStatement(CobolPreprocessor.EjectStatement ejectStatement, PrintOutputCapture<P> p) {
        this.addPreprocessorStatementTemplate(ejectStatement, p);
        return ejectStatement;
    }

    @Override
    public CobolPreprocessor visitExecStatement(CobolPreprocessor.ExecStatement execStatement, PrintOutputCapture<P> p) {
        this.addPreprocessorStatementTemplate(execStatement, p);
        return execStatement;
    }

    @Override
    public CobolPreprocessor visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, PrintOutputCapture<P> p) {
        this.visitSpace(execSqlIncludeStatement.getPrefix(), Space.Location.EXEC_SQL_INCLUDE_STATEMENT_PREFIX, p);
        this.visitMarkers(execSqlIncludeStatement.getMarkers(), p);
        this.printCopybookSource(execSqlIncludeStatement, p);
        return execSqlIncludeStatement;
    }

    @Override
    public CobolPreprocessor visitReplaceArea(CobolPreprocessor.ReplaceArea replaceArea, PrintOutputCapture<P> p) {
        this.visit(replaceArea.getReplaceByStatement(), p);
        if (replaceArea.getCobols() != null) {
            for (CobolPreprocessor cobol : replaceArea.getCobols()) {
                this.visit(cobol, p);
            }
        }
        this.visit(replaceArea.getReplaceOffStatement(), p);
        return replaceArea;
    }

    @Override
    public CobolPreprocessor visitReplaceByStatement(CobolPreprocessor.ReplaceByStatement replaceByStatement, PrintOutputCapture<P> p) {
        this.addPreprocessorStatementTemplate(replaceByStatement, p);
        return replaceByStatement;
    }

    @Override
    public CobolPreprocessor visitReplaceOffStatement(CobolPreprocessor.ReplaceOffStatement replaceOffStatement, PrintOutputCapture<P> p) {
        this.addPreprocessorStatementTemplate(replaceOffStatement, p);
        return replaceOffStatement;
    }

    @Override
    public CobolPreprocessor visitSkipStatement(CobolPreprocessor.SkipStatement skipStatement, PrintOutputCapture<P> p) {
        this.addPreprocessorStatementTemplate(skipStatement, p);
        return skipStatement;
    }

    @Override
    public CobolPreprocessor visitTitleStatement(CobolPreprocessor.TitleStatement titleStatement, PrintOutputCapture<P> p) {
        this.addPreprocessorStatementTemplate(titleStatement, p);
        return titleStatement;
    }

    private void addPreprocessorStatementTemplate(CobolPreprocessor cobolPreprocessor, PrintOutputCapture<P> p) {
        if (this.printColumns) {
            int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
            curIndex = curIndex == -1 ? 0 : curIndex;
            this.addStartKey(this.getPreprocessorStartComment(), curIndex, p);
            this.addUuidKey(this.getUuidComment(), cobolPreprocessor.getId(), p);
            this.addStopComment(this.getPreprocessorStopComment(), null, curIndex, p);
        }
    }

    @Override
    public CobolPreprocessor visitWord(CobolPreprocessor.Word word, PrintOutputCapture<P> p) {
        if (!this.printColumns) {
            String indicator;
            if (word.getCobolWord().getIndicatorArea() != null && ("G".equals(indicator = word.getCobolWord().getIndicatorArea().getIndicator()) || "J".equals(indicator) || "P".equals(indicator))) {
                this.inUnknownIndicator = true;
            }
            if (!this.inUnknownIndicator) {
                if (word.getCobolWord().getReplacement() != null && word.getCobolWord().getReplacement().getType() == Replacement.Type.ADDITIVE) {
                    int contentEnd;
                    Replacement replaceAdditiveType = word.getCobolWord().getReplacement();
                    for (Replacement.OriginalWord additionalWord : replaceAdditiveType.getOriginalWords()) {
                        this.cobolSourcePrinter.visit(additionalWord.getOriginal(), p);
                    }
                    int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
                    int untilEndOfLine = curIndex >= (contentEnd = this.cobolDialect.getColumns().getOtherArea()) ? 0 : this.cobolDialect.getColumns().getOtherArea() - curIndex;
                    String whitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine) + "\n";
                    p.append(whitespace);
                }
                this.visitSpace(word.getPrefix(), Space.Location.WORD_PREFIX, p);
                this.visitMarkers(word.getMarkers(), p);
                p.append(word.getCobolWord().getWord());
                if (word.getCobolWord().getCommentArea() != null) {
                    this.visitSpace(word.getCobolWord().getCommentArea().getPrefix(), Space.Location.COMMENT_AREA_PREFIX, p);
                    this.visitSpace(word.getCobolWord().getCommentArea().getEndOfLine(), Space.Location.COMMENT_AREA_EOL, p);
                }
            }
            if (this.inUnknownIndicator && word.getCobolWord().getCommentArea() != null) {
                this.inUnknownIndicator = false;
            }
            return word;
        }
        Replacement replacement = word.getCobolWord().getReplacement();
        if (replacement != null && replacement.getType() == Replacement.Type.EQUAL) {
            List<CobolLine> lines = replacement.getOriginalWords().get(0).getOriginal().getLines();
            if (lines != null) {
                ListUtils.map(lines, l -> this.cobolSourcePrinter.visitLine((CobolLine)l, (PrintOutputCapture)p));
            }
            this.replaceTemplate(word, p, replacement);
        } else if (replacement != null && replacement.getType() == Replacement.Type.REDUCTIVE) {
            if (this.replaceReductiveType == null) {
                this.replaceReductiveType = replacement;
            }
        } else if (this.replaceReductiveType != null) {
            this.replaceReductiveTemplate(p);
            super.visitWord(word, p);
            this.replaceReductiveType = null;
        } else if (replacement != null && replacement.getType() == Replacement.Type.ADDITIVE) {
            this.replaceAdditiveTemplate(replacement, p);
            super.visitWord(word, p);
        } else if (!CobolStringUtils.isSubstituteCharacter(word.getCobolWord().getWord())) {
            super.visitWord(word, p);
        }
        return word;
    }

    private void replaceAdditiveTemplate(Replacement replaceAdditiveType, PrintOutputCapture<P> p) {
        int contentEnd;
        int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
        int untilEndOfLine = curIndex >= (contentEnd = this.cobolDialect.getColumns().getOtherArea()) ? 0 : this.cobolDialect.getColumns().getOtherArea() - curIndex;
        String whitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine) + "\n";
        p.append(whitespace);
        int startKeyIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
        this.addStartKey(this.getReplaceTypeAdditiveStartComment(), startKeyIndex, p);
        this.addUuidKey(this.getUuidComment(), replaceAdditiveType.getId(), p);
        for (Replacement.OriginalWord additionalWord : replaceAdditiveType.getOriginalWords()) {
            p.append(this.getReplaceAddWordStartComment());
            String addedWord = this.getDialectSequenceArea() + " " + additionalWord.getOriginal().getPrefix().getWhitespace() + additionalWord.getOriginal().getWord();
            p.append(addedWord);
            int addedIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
            untilEndOfLine = addedIndex >= contentEnd ? 0 : this.cobolDialect.getColumns().getOtherArea() - addedIndex;
            String addWhitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine) + "\n";
            p.append(addWhitespace);
            p.append(this.getReplaceAddWordStopComment());
        }
        this.addStopComment(this.getReplaceTypeAdditiveStopComment(), null, curIndex, p);
    }

    private void replaceReductiveTemplate(PrintOutputCapture<P> p) {
        for (Replacement.OriginalWord replace : this.replaceReductiveType.getOriginalWords()) {
            Cobol.Word originalWord = replace.getOriginal();
            if (originalWord.getContinuation() != null) {
                throw new UnsupportedOperationException("Implement continuation lines for a reductive replacement.");
            }
            if (originalWord.getSequenceArea() != null) {
                originalWord.getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            if (originalWord.getIndicatorArea() != null) {
                originalWord.getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            this.visitSpace(originalWord.getPrefix(), Space.Location.WORD_PREFIX, p);
            String replaceWithWhitespace = CobolPrinterUtils.generateWhitespace(originalWord.getWord().length());
            p.append(replaceWithWhitespace);
            if (originalWord.getCommentArea() == null) continue;
            originalWord.getCommentArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
        }
        int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
        if (curIndex == -1) {
            throw new UnsupportedOperationException("Unknown case: Detected a ReplaceTypeReductive at the start of the source code.");
        }
        int contentEnd = this.cobolDialect.getColumns().getOtherArea();
        int untilEndOfLine = curIndex >= contentEnd ? 0 : this.cobolDialect.getColumns().getOtherArea() - curIndex;
        String whitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine) + "\n";
        p.append(whitespace);
        p.append(this.getReplaceTypeReductiveStartComment());
        this.addUuidKey(this.getUuidComment(), this.replaceReductiveType.getId(), p);
        p.append(this.getReplaceTypeReductiveStopComment());
        String afterStop = this.getColumnAlignmentAfterStop(curIndex);
        p.append(afterStop);
        p.append(StringUtils.repeat((String)" ", (int)(curIndex >= contentEnd ? 0 : curIndex)));
    }

    private void replaceTemplate(CobolPreprocessor.Word word, PrintOutputCapture<P> p, Replacement replacement) {
        int curIndex = CobolPrinterUtils.getCurrentIndex(p.getOut());
        if (curIndex == -1) {
            throw new UnsupportedOperationException("Unknown case: Detected a Replace at the start of the source code.");
        }
        Cobol.Word originalWord = replacement.getOriginalWords().get(0).getOriginal();
        boolean isLongerWord = word.getCobolWord().getWord().length() > originalWord.getWord().length();
        String replacedWord = isLongerWord ? " " + word.getCobolWord().getWord() : word.getCobolWord().getWord();
        boolean isLiteral = word.getCobolWord().getWord().startsWith("\"") || word.getCobolWord().getWord().startsWith("'");
        int contentAreaLength = CobolPrinterUtils.getContentAreaLength(this.cobolDialect);
        boolean isContinuedLiteral = isLiteral && curIndex + replacedWord.length() > contentAreaLength;
        int insertIndex = CobolPrinterUtils.getInsertIndex(p.getOut());
        p.out.insert(insertIndex, this.getReplaceStartComment());
        if (isLongerWord && !isContinuedLiteral) {
            insertIndex = CobolPrinterUtils.getInsertIndex(p.getOut());
            p.out.insert(insertIndex, this.getReplaceAddedWhitespaceComment());
        }
        if (curIndex == 0) {
            if (originalWord.getSequenceArea() != null) {
                originalWord.getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            if (originalWord.getIndicatorArea() != null) {
                originalWord.getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
        }
        int untilEndOfLine = this.cobolDialect.getColumns().getOtherArea() - (curIndex == 0 ? this.cobolDialect.getColumns().getContentArea() : curIndex);
        String whitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine) + "\n";
        p.append(whitespace);
        this.addUuidKey(this.getReplaceUuidComment(), replacement.getId(), p);
        p.append(this.getReplaceStopComment());
        if (isLongerWord) {
            if (isContinuedLiteral) {
                String part;
                int i;
                int numberOfSpaces = curIndex == 0 ? this.cobolDialect.getColumns().getContentArea() : curIndex;
                String afterStop = this.getColumnAlignmentAfterStop(numberOfSpaces);
                p.append(afterStop);
                p.append(StringUtils.repeat((String)" ", (int)numberOfSpaces));
                String dialectSequenceArea = this.getDialectSequenceArea();
                int originalLength = originalWord.getPrefix().getWhitespace().length() + originalWord.getWord().length();
                int endPos = replacedWord.length() - curIndex + this.getDialectSequenceArea().length() + 1 - originalLength;
                String end = dialectSequenceArea + "-" + replacedWord.substring(endPos);
                replacedWord = replacedWord.substring(0, replacedWord.length() - end.length());
                int remainder = replacedWord.length() % contentAreaLength;
                int size = replacedWord.length() / contentAreaLength + (remainder == 0 ? 0 : 1);
                ArrayList<String> parts = new ArrayList<String>(size);
                int total = replacedWord.length();
                for (i = 0; i < size; ++i) {
                    if (total - contentAreaLength >= 0) {
                        part = replacedWord.substring(total - contentAreaLength, total);
                        parts.add(part);
                        total -= part.length();
                        continue;
                    }
                    if (total != remainder) {
                        throw new IllegalStateException("Unexpected remained calculating replacement end position.");
                    }
                    parts.add(replacedWord.substring(0, remainder));
                }
                for (i = parts.size() - 1; i >= 0; --i) {
                    part = (String)parts.get(i);
                    if (i != parts.size() - 1) {
                        p.append(this.getDialectSequenceArea());
                        p.append("-");
                    }
                    p.append(part);
                    if (i == parts.size() - 1 && part.length() < contentAreaLength) {
                        untilEndOfLine = this.getDialectSequenceArea().length() + 1 + contentAreaLength - (curIndex + part.length());
                        whitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine);
                        p.append(whitespace);
                    }
                    p.append("\n");
                }
                p.append(end);
            } else {
                int difference = word.getCobolWord().getWord().length() - originalWord.getWord().length();
                int alignColumn = curIndex == 0 ? this.cobolDialect.getColumns().getContentArea() : curIndex;
                int total = alignColumn + word.getPrefix().getWhitespace().length() - difference;
                if (total > this.cobolDialect.getColumns().getOtherArea()) {
                    throw new UnsupportedOperationException("The position of the replaced word exceeds the column area.");
                }
                String prefix = CobolPrinterUtils.generateWhitespace(total);
                p.append(prefix);
                p.append(word.getCobolWord().getWord());
            }
        } else {
            int numberOfSpaces;
            PrintOutputCapture outputCapture = new PrintOutputCapture((Object)new InMemoryExecutionContext());
            this.cobolStatementPrinter.visit(originalWord, outputCapture);
            String statement = outputCapture.getOut();
            boolean isEndOfLine = statement.endsWith("\n");
            boolean isCRLF = statement.endsWith("\r\n");
            int totalChars = statement.length() + curIndex - this.cobolDialect.getColumns().getContentArea() - (isEndOfLine ? (isCRLF ? 2 : 1) : 0);
            if (!isEndOfLine && totalChars > contentAreaLength) {
                String replaced = word.print(this.getCursor());
                numberOfSpaces = CobolPrinterUtils.getCurrentIndex(replaced);
            } else {
                numberOfSpaces = curIndex == 0 ? this.cobolDialect.getColumns().getContentArea() : curIndex;
            }
            String afterStop = this.getColumnAlignmentAfterStop(numberOfSpaces);
            p.append(afterStop);
            p.append(StringUtils.repeat((String)" ", (int)numberOfSpaces));
            int difference = originalWord.getWord().length() - word.getCobolWord().getWord().length();
            if (curIndex + difference > this.cobolDialect.getColumns().getOtherArea()) {
                String fullWord = word.print(this.getCursor());
                int lastIndex = fullWord.lastIndexOf("\n");
                if ((fullWord = fullWord.substring(lastIndex + 1)).length() - word.getCobolWord().getWord().length() < curIndex) {
                    p.out.delete(p.getOut().length() - (curIndex - (fullWord.length() - word.getCobolWord().getWord().length())), p.getOut().length());
                } else {
                    p.append(StringUtils.repeat((String)" ", (int)(fullWord.length() - word.getCobolWord().getWord().length() - curIndex)));
                }
                p.append(word.getCobolWord().getWord());
            } else {
                String additionalPrefix = StringUtils.repeat((String)" ", (int)difference);
                p.append(additionalPrefix);
                this.visitSpace(word.getPrefix(), Space.Location.WORD_PREFIX, p);
                p.append(word.getCobolWord().getWord());
            }
        }
        if (word.getCobolWord().getCommentArea() != null) {
            word.getCobolWord().getCommentArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
        }
    }

    private void addStartKey(String startComment, int curIndex, PrintOutputCapture<P> p) {
        if (curIndex == -1) {
            throw new UnsupportedOperationException("Negative index detected for: " + startComment);
        }
        int insertIndex = CobolPrinterUtils.getInsertIndex(p.getOut());
        p.out.insert(insertIndex, startComment);
        int untilEndOfLine = this.cobolDialect.getColumns().getOtherArea() - curIndex;
        String whitespace = CobolPrinterUtils.generateWhitespace(untilEndOfLine) + "\n";
        p.append(whitespace);
    }

    private void addUuidKey(String uuidComment, UUID uuid, PrintOutputCapture<P> p) {
        p.append(uuidComment);
        String replaceUuidLine = this.getDialectSequenceArea() + "*" + uuid + this.getUuidEndOfLine();
        p.append(replaceUuidLine);
    }

    private void addStopComment(String stopComment, @Nullable CobolPreprocessor statement, int curIndex, PrintOutputCapture<P> p) {
        p.append(stopComment);
        PrintOutputCapture outputCapture = new PrintOutputCapture((Object)new InMemoryExecutionContext());
        this.statementPrinter.visit(statement, outputCapture);
        String output = outputCapture.getOut();
        boolean isEndOfLine = output.endsWith("\n");
        boolean isCRLF = output.endsWith("\r\n");
        int totalChars = output.length() + curIndex - this.cobolDialect.getColumns().getContentArea() - (isEndOfLine ? (isCRLF ? 2 : 1) : 0);
        int contentAreaLength = CobolPrinterUtils.getContentAreaLength(this.cobolDialect);
        int numberOfSpaces = !isEndOfLine && totalChars > contentAreaLength ? 0 : (isEndOfLine ? 0 : output.length() + curIndex);
        String afterStop = this.getColumnAlignmentAfterStop(numberOfSpaces);
        p.append(afterStop);
        if (numberOfSpaces != this.cobolDialect.getColumns().getOtherArea()) {
            p.append(StringUtils.repeat((String)" ", (int)numberOfSpaces));
        }
    }

    private String getColumnAlignmentAfterStop(int lengthOfPrefix) {
        if (lengthOfPrefix > 0 && lengthOfPrefix - this.cobolDialect.getColumns().getContentArea() < 0) {
            throw new IllegalStateException("Negative index detected.");
        }
        int startOfContentArea = this.cobolDialect.getColumns().getContentArea();
        int endOfContentArea = this.cobolDialect.getColumns().getOtherArea();
        int prefixLength = lengthOfPrefix == 0 || lengthOfPrefix >= endOfContentArea ? 0 : lengthOfPrefix - startOfContentArea;
        prefixLength = prefixLength == endOfContentArea - startOfContentArea ? 0 : prefixLength;
        String alignmentKey = this.getDialectSequenceArea() + "*" + prefixLength;
        String whitespace = CobolPrinterUtils.generateWhitespace(endOfContentArea - alignmentKey.length());
        return alignmentKey + whitespace + "\n";
    }

    private String getTemplateComment(String key) {
        String start = this.getDialectSequenceArea() + "*" + key;
        return start + StringUtils.repeat((String)"_", (int)(this.cobolDialect.getColumns().getOtherArea() - start.length())) + "\n";
    }

    public String getCopyStartComment() {
        if (this.copyStartComment == null) {
            this.copyStartComment = this.getTemplateComment(COPY_START_KEY);
        }
        return this.copyStartComment;
    }

    public String getCopyStopComment() {
        if (this.copyStopComment == null) {
            this.copyStopComment = this.getTemplateComment(COPY_STOP_KEY);
        }
        return this.copyStopComment;
    }

    public String getCopyUuidKey() {
        if (this.copyUuidComment == null) {
            this.copyUuidComment = this.getTemplateComment(COPY_UUID_KEY);
        }
        return this.copyUuidComment;
    }

    public String getCopybookNotFound() {
        if (this.copybookNotFoundComment == null) {
            this.copybookNotFoundComment = this.getTemplateComment(COPYBOOK_NOT_FOUND);
        }
        return this.copybookNotFoundComment;
    }

    public String getReplaceStartComment() {
        if (this.replaceStartComment == null) {
            this.replaceStartComment = this.getTemplateComment(REPLACE_START_KEY);
        }
        return this.replaceStartComment;
    }

    public String getReplaceStopComment() {
        if (this.replaceStopComment == null) {
            this.replaceStopComment = this.getTemplateComment(REPLACE_STOP_KEY);
        }
        return this.replaceStopComment;
    }

    public String getReplaceUuidComment() {
        if (this.replaceUuidComment == null) {
            this.replaceUuidComment = this.getTemplateComment(REPLACE_UUID_KEY);
        }
        return this.replaceUuidComment;
    }

    public String getReplaceAddedWhitespaceComment() {
        if (this.replaceAddedWhitespaceComment == null) {
            this.replaceAddedWhitespaceComment = this.getTemplateComment(REPLACE_ADDED_WHITESPACE_KEY);
        }
        return this.replaceAddedWhitespaceComment;
    }

    public String getReplaceAddWordStartComment() {
        if (this.replaceAddWordStartComment == null) {
            this.replaceAddWordStartComment = this.getTemplateComment(REPLACE_ADD_WORD_START_KEY);
        }
        return this.replaceAddWordStartComment;
    }

    public String getReplaceAddWordStopComment() {
        if (this.replaceAddWordStopComment == null) {
            this.replaceAddWordStopComment = this.getTemplateComment(REPLACE_ADD_WORD_STOP_KEY);
        }
        return this.replaceAddWordStopComment;
    }

    public String getReplaceTypeAdditiveStartComment() {
        if (this.replaceTypeAdditiveStartComment == null) {
            this.replaceTypeAdditiveStartComment = this.getTemplateComment(REPLACE_TYPE_ADDITIVE_START_KEY);
        }
        return this.replaceTypeAdditiveStartComment;
    }

    public String getReplaceTypeAdditiveStopComment() {
        if (this.replaceTypeAdditiveStopComment == null) {
            this.replaceTypeAdditiveStopComment = this.getTemplateComment(REPLACE_TYPE_ADDITIVE_STOP_KEY);
        }
        return this.replaceTypeAdditiveStopComment;
    }

    public String getReplaceTypeReductiveStartComment() {
        if (this.replaceTypeReductiveStartComment == null) {
            this.replaceTypeReductiveStartComment = this.getTemplateComment(REPLACE_TYPE_REDUCTIVE_START_KEY);
        }
        return this.replaceTypeReductiveStartComment;
    }

    public String getReplaceTypeReductiveStopComment() {
        if (this.replaceTypeReductiveStopComment == null) {
            this.replaceTypeReductiveStopComment = this.getTemplateComment(REPLACE_TYPE_REDUCTIVE_STOP_KEY);
        }
        return this.replaceTypeReductiveStopComment;
    }

    public String getCompilerOptionsStartComment() {
        if (this.compilerOptionsStartComment == null) {
            this.compilerOptionsStartComment = this.getTemplateComment(COMPILER_OPTIONS_START_KEY);
        }
        return this.compilerOptionsStartComment;
    }

    public String getCompilerOptionsStopComment() {
        if (this.compilerOptionsStopComment == null) {
            this.compilerOptionsStopComment = this.getTemplateComment(COMPILER_OPTIONS_STOP_KEY);
        }
        return this.compilerOptionsStopComment;
    }

    public String getPreprocessorStartComment() {
        if (this.preprocessorStartComment == null) {
            this.preprocessorStartComment = this.getTemplateComment(PREPROCESSOR_START_KEY);
        }
        return this.preprocessorStartComment;
    }

    public String getPreprocessorStopComment() {
        if (this.preprocessorStopComment == null) {
            this.preprocessorStopComment = this.getTemplateComment(PREPROCESSOR_STOP_KEY);
        }
        return this.preprocessorStopComment;
    }

    public String getUuidComment() {
        if (this.uuidComment == null) {
            this.uuidComment = this.getTemplateComment(UUID_KEY);
        }
        return this.uuidComment;
    }

    private String getUuidEndOfLine() {
        if (this.uuidEndOfLine == null) {
            this.uuidEndOfLine = StringUtils.repeat((String)" ", (int)(this.cobolDialect.getColumns().getOtherArea() - this.cobolDialect.getColumns().getContentArea() - 36)) + "\n";
        }
        return this.uuidEndOfLine;
    }

    private String getDialectSequenceArea() {
        if (this.dialectSequenceArea == null) {
            this.dialectSequenceArea = StringUtils.repeat((String)" ", (int)(this.cobolDialect.getColumns().getContentArea() - 1));
        }
        return this.dialectSequenceArea;
    }
}

