/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolStringUtils;
import org.openrewrite.cobol.internal.CobolDialect;
import org.openrewrite.cobol.internal.grammar.CobolPreprocessorBaseVisitor;
import org.openrewrite.cobol.internal.grammar.CobolPreprocessorParser;
import org.openrewrite.cobol.tree.BlankLine;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.cobol.tree.CommentArea;
import org.openrewrite.cobol.tree.CommentLine;
import org.openrewrite.cobol.tree.Continuation;
import org.openrewrite.cobol.tree.IndicatorArea;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.SequenceArea;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public class CobolPreprocessorParserVisitor
extends CobolPreprocessorBaseVisitor<Object> {
    private final Path path;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final CobolDialect cobolDialect;
    private final Map<Integer, String> sequenceAreas = new HashMap<Integer, String>();
    private final Map<Integer, String> indicatorAreas = new LinkedHashMap<Integer, String>();
    private final Map<Integer, String> commentAreas = new LinkedHashMap<Integer, String>();
    private final Set<Character> commentIndicators = new HashSet<Character>();
    private int cursor = 0;

    public CobolPreprocessorParserVisitor(Path path, @Nullable FileAttributes fileAttributes, String source, Charset charset, boolean charsetBomMarked, CobolDialect cobolDialect) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.cobolDialect = cobolDialect;
    }

    public <T> T visit(ParseTree ... trees) {
        for (ParseTree tree : trees) {
            if (tree == null) continue;
            return (T)this.visit(tree);
        }
        throw new IllegalStateException("Expected one of the supplied trees to be non-null");
    }

    public <T> T visitNullable(@Nullable ParseTree tree) {
        if (tree == null) {
            return null;
        }
        return (T)super.visit(tree);
    }

    private void init() {
        String[] parts = this.source.split("\n");
        if (this.cobolDialect.getColumns() == CobolDialect.Columns.IBM_ANSI_85) {
            CobolDialect.Columns columns = this.cobolDialect.getColumns();
            int pos = 0;
            for (String part : parts) {
                String otherArea;
                String cleanedPart;
                boolean isCRLF = part.endsWith("\r");
                String string = cleanedPart = isCRLF ? part.substring(0, part.length() - 1) : part;
                if (cleanedPart.isEmpty()) {
                    pos += isCRLF ? 2 : 1;
                    continue;
                }
                if (CobolStringUtils.isSubstituteCharacter(part)) {
                    pos += part.length();
                    continue;
                }
                String sequenceArea = cleanedPart.substring(columns.getSequenceArea(), Math.min(cleanedPart.length(), columns.getIndicatorArea()));
                this.sequenceAreas.put(pos, sequenceArea);
                pos += sequenceArea.length();
                if (cleanedPart.length() - 1 >= columns.getIndicatorArea()) {
                    String indicatorArea = cleanedPart.substring(columns.getIndicatorArea(), columns.getContentArea());
                    this.indicatorAreas.put(pos, indicatorArea);
                    pos += indicatorArea.length();
                }
                if (cleanedPart.length() - 1 >= columns.getContentArea()) {
                    String contentArea = cleanedPart.substring(columns.getContentArea(), Math.min(cleanedPart.length(), columns.getOtherArea()));
                    pos += contentArea.length();
                }
                String string2 = otherArea = cleanedPart.length() > columns.getOtherArea() ? cleanedPart.substring(columns.getOtherArea()) : "";
                if (!otherArea.isEmpty()) {
                    this.commentAreas.put(pos, otherArea);
                    pos += otherArea.length();
                }
                pos += isCRLF ? 2 : 1;
            }
        } else {
            if (this.cobolDialect.getColumns() == CobolDialect.Columns.HP_TANDEM) {
                throw new UnsupportedOperationException("Implement me.");
            }
            throw new UnsupportedOperationException("CobolDialect is not supported: " + this.cobolDialect.getColumns().name());
        }
        this.commentIndicators.addAll(this.cobolDialect.getCommentIndicators());
    }

    @Override
    public Object visitCharData(CobolPreprocessorParser.CharDataContext ctx) {
        return new CobolPreprocessor.CharData(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.charDataLine()));
    }

    @Override
    public Object visitCharDataKeyword(CobolPreprocessorParser.CharDataKeywordContext ctx) {
        return super.visitCharDataKeyword(ctx);
    }

    @Override
    public Object visitCharDataLine(CobolPreprocessorParser.CharDataLineContext ctx) {
        return new CobolPreprocessor.CharDataLine(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.cobolWord(), ctx.literal(), ctx.filename(), ctx.commentEntry(), ctx.TEXT(), ctx.DOT(), ctx.LPARENCHAR(), ctx.RPARENCHAR()));
    }

    @Override
    public Object visitCharDataLineNoDot(CobolPreprocessorParser.CharDataLineNoDotContext ctx) {
        return new CobolPreprocessor.CharDataLine(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.cobolWord(), ctx.literal(), ctx.filename(), ctx.commentEntry(), ctx.TEXT(), ctx.LPARENCHAR(), ctx.RPARENCHAR()));
    }

    @Override
    public Object visitCharDataSql(CobolPreprocessorParser.CharDataSqlContext ctx) {
        return new CobolPreprocessor.CharDataSql(Space.EMPTY, Markers.EMPTY, this.convertAllList(ctx.charDataLine()));
    }

    @Override
    public Object visitCobolWord(CobolPreprocessorParser.CobolWordContext ctx) {
        return super.visitCobolWord(ctx);
    }

    @Override
    public Object visitCommentEntry(CobolPreprocessorParser.CommentEntryContext ctx) {
        return new CobolPreprocessor.CommentEntry(Space.EMPTY, Markers.EMPTY, this.convertAll((List)ctx.COMMENTENTRYLINE()));
    }

    @Override
    public Object visitCompilerOption(CobolPreprocessorParser.CompilerOptionContext ctx) {
        return new CobolPreprocessor.CompilerOption(Space.EMPTY, Markers.EMPTY, this.convertAllList(Collections.singletonList(ctx.ADATA()), Collections.singletonList(ctx.ADV()), Collections.singletonList(ctx.ALIAS()), Collections.singletonList(ctx.ANSI()), Collections.singletonList(ctx.ANY()), Collections.singletonList(ctx.APOST()), Collections.singletonList(ctx.AR()), Collections.singletonList(ctx.ARITH()), Collections.singletonList(ctx.AUTO()), Collections.singletonList(ctx.AWO()), Collections.singletonList(ctx.BIN()), Collections.singletonList(ctx.BLOCK0()), Collections.singletonList(ctx.BUF()), Collections.singletonList(ctx.BUFSIZE()), Collections.singletonList(ctx.C_CHAR()), Collections.singletonList(ctx.CBLCARD()), Collections.singletonList(ctx.CICS()), Collections.singletonList(ctx.CO()), Collections.singletonList(ctx.COBOL2()), Collections.singletonList(ctx.COBOL3()), Collections.singletonList(ctx.cobolWord()), Collections.singletonList(ctx.CODEPAGE()), ctx.COMMACHAR(), Collections.singletonList(ctx.COMPAT()), Collections.singletonList(ctx.COMPILE()), Collections.singletonList(ctx.CP()), Collections.singletonList(ctx.CPP()), Collections.singletonList(ctx.CPSM()), Collections.singletonList(ctx.CS()), Collections.singletonList(ctx.CURR()), Collections.singletonList(ctx.CURRENCY()), Collections.singletonList(ctx.D_CHAR()), Collections.singletonList(ctx.DATA()), Collections.singletonList(ctx.DATEPROC()), Collections.singletonList(ctx.DBCS()), Collections.singletonList(ctx.DD()), Collections.singletonList(ctx.DEBUG()), Collections.singletonList(ctx.DECK()), Collections.singletonList(ctx.DIAGTRUNC()), Collections.singletonList(ctx.DLL()), Collections.singletonList(ctx.DP()), Collections.singletonList(ctx.DTR()), Collections.singletonList(ctx.DU()), Collections.singletonList(ctx.DUMP()), Collections.singletonList(ctx.DYN()), Collections.singletonList(ctx.DYNAM()), ctx.E_CHAR(), Collections.singletonList(ctx.EDF()), Collections.singletonList(ctx.EJPD()), Collections.singletonList(ctx.EN()), Collections.singletonList(ctx.ENGLISH()), Collections.singletonList(ctx.EPILOG()), Collections.singletonList(ctx.EXIT()), Collections.singletonList(ctx.EXP()), Collections.singletonList(ctx.EXPORTALL()), Collections.singletonList(ctx.EXTEND()), Collections.singletonList(ctx.F_CHAR()), Collections.singletonList(ctx.FASTSRT()), Collections.singletonList(ctx.FEPI()), Collections.singletonList(ctx.FLAG()), Collections.singletonList(ctx.FLAGSTD()), Collections.singletonList(ctx.FSRT()), Collections.singletonList(ctx.FULL()), Collections.singletonList(ctx.GDS()), Collections.singletonList(ctx.GRAPHIC()), Collections.singletonList(ctx.H_CHAR()), Collections.singletonList(ctx.HOOK()), ctx.I_CHAR(), Collections.singletonList(ctx.INTDATE()), Collections.singletonList(ctx.JA()), Collections.singletonList(ctx.JP()), Collections.singletonList(ctx.KA()), Collections.singletonList(ctx.LANG()), Collections.singletonList(ctx.LANGUAGE()), Collections.singletonList(ctx.LC()), Collections.singletonList(ctx.LEASM()), Collections.singletonList(ctx.LENGTH()), Collections.singletonList(ctx.LIB()), Collections.singletonList(ctx.LINKAGE()), Collections.singletonList(ctx.LIN()), Collections.singletonList(ctx.LINECOUNT()), Collections.singletonList(ctx.LIST()), ctx.literal(), Collections.singletonList(ctx.LILIAN()), Collections.singletonList(ctx.LM()), Collections.singletonList(ctx.LONGMIXED()), Collections.singletonList(ctx.LONGUPPER()), Collections.singletonList(ctx.LPARENCHAR()), Collections.singletonList(ctx.LU()), Collections.singletonList(ctx.M_CHAR()), Collections.singletonList(ctx.MAP()), Collections.singletonList(ctx.MARGINS()), Collections.singletonList(ctx.MAX()), Collections.singletonList(ctx.MD()), Collections.singletonList(ctx.MDECK()), Collections.singletonList(ctx.MIG()), Collections.singletonList(ctx.MIXED()), Collections.singletonList(ctx.N_CHAR()), Collections.singletonList(ctx.NAME()), Collections.singletonList(ctx.NAT()), Collections.singletonList(ctx.NATIONAL()), Collections.singletonList(ctx.NATLANG()), Collections.singletonList(ctx.NN()), Collections.singletonList(ctx.NOADATA()), Collections.singletonList(ctx.NOADV()), Collections.singletonList(ctx.NOALIAS()), Collections.singletonList(ctx.NOAWO()), Collections.singletonList(ctx.NOBLOCK0()), Collections.singletonList(ctx.NOCBLCARD()), Collections.singletonList(ctx.NOCICS()), Collections.singletonList(ctx.NOCMPR2()), Collections.singletonList(ctx.NOC()), Collections.singletonList(ctx.NOCOMPILE()), Collections.singletonList(ctx.NOCPSM()), Collections.singletonList(ctx.NOCURR()), Collections.singletonList(ctx.NOCURRENCY()), Collections.singletonList(ctx.NOD()), Collections.singletonList(ctx.NODATEPROC()), Collections.singletonList(ctx.NODBCS()), Collections.singletonList(ctx.NODE()), Collections.singletonList(ctx.NODEBUG()), Collections.singletonList(ctx.NODECK()), Collections.singletonList(ctx.NODIAGTRUNC()), Collections.singletonList(ctx.NODLL()), Collections.singletonList(ctx.NODP()), Collections.singletonList(ctx.NODTR()), Collections.singletonList(ctx.NODYN()), Collections.singletonList(ctx.NODYNAM()), Collections.singletonList(ctx.NODU()), Collections.singletonList(ctx.NODUMP()), Collections.singletonList(ctx.NOEDF()), Collections.singletonList(ctx.NOEJPD()), Collections.singletonList(ctx.NOEPILOG()), Collections.singletonList(ctx.NOEXIT()), Collections.singletonList(ctx.NOEXP()), Collections.singletonList(ctx.NOEXPORTALL()), Collections.singletonList(ctx.NOF()), Collections.singletonList(ctx.NOFASTSRT()), Collections.singletonList(ctx.NOFEPI()), Collections.singletonList(ctx.NOFLAG()), Collections.singletonList(ctx.NOFLAGMIG()), Collections.singletonList(ctx.NOFLAGSTD()), Collections.singletonList(ctx.NOFSRT()), Collections.singletonList(ctx.NOGRAPHIC()), Collections.singletonList(ctx.NOHOOK()), Collections.singletonList(ctx.NOLENGTH()), Collections.singletonList(ctx.NOLIB()), Collections.singletonList(ctx.NOLINKAGE()), Collections.singletonList(ctx.NOLIST()), Collections.singletonList(ctx.NOMAP()), Collections.singletonList(ctx.NOMD()), Collections.singletonList(ctx.NOMDECK()), Collections.singletonList(ctx.NONAME()), Collections.singletonList(ctx.NONUM()), Collections.singletonList(ctx.NONUMBER()), Collections.singletonList(ctx.NOOBJ()), Collections.singletonList(ctx.NOOBJECT()), Collections.singletonList(ctx.NOOFF()), Collections.singletonList(ctx.NOOFFSET()), Collections.singletonList(ctx.NOOPSEQUENCE()), Collections.singletonList(ctx.NOOPT()), Collections.singletonList(ctx.NOOPTIMIZE()), Collections.singletonList(ctx.NOOPTIONS()), Collections.singletonList(ctx.NOP()), Collections.singletonList(ctx.NOPFD()), Collections.singletonList(ctx.NOPROLOG()), Collections.singletonList(ctx.NORENT()), Collections.singletonList(ctx.NOS()), Collections.singletonList(ctx.NOSEP()), Collections.singletonList(ctx.NOSEPARATE()), Collections.singletonList(ctx.NOSEQ()), Collections.singletonList(ctx.NOSEQUENCE()), Collections.singletonList(ctx.NOSOURCE()), Collections.singletonList(ctx.NOSPIE()), Collections.singletonList(ctx.NOSQL()), Collections.singletonList(ctx.NOSQLC()), Collections.singletonList(ctx.NOSQLCCSID()), Collections.singletonList(ctx.NOSSR()), Collections.singletonList(ctx.NOSSRANGE()), Collections.singletonList(ctx.NOSTDTRUNC()), Collections.singletonList(ctx.NOTERM()), Collections.singletonList(ctx.NOTERMINAL()), Collections.singletonList(ctx.NOTEST()), Collections.singletonList(ctx.NOTHREAD()), Collections.singletonList(ctx.NOTRIG()), Collections.singletonList(ctx.NOVBREF()), Collections.singletonList(ctx.NOWD()), Collections.singletonList(ctx.NOWORD()), Collections.singletonList(ctx.NOX()), Collections.singletonList(ctx.NOXREF()), Collections.singletonList(ctx.NOZWB()), Collections.singletonList(ctx.NS()), Collections.singletonList(ctx.NSEQ()), Collections.singletonList(ctx.NSYMBOL()), Collections.singletonList(ctx.NUM()), Collections.singletonList(ctx.NUMBER()), Collections.singletonList(ctx.NUMPROC()), Collections.singletonList(ctx.OBJ()), Collections.singletonList(ctx.OBJECT()), Collections.singletonList(ctx.OFF()), Collections.singletonList(ctx.OFFSET()), Collections.singletonList(ctx.OPMARGINS()), Collections.singletonList(ctx.OPSEQUENCE()), Collections.singletonList(ctx.OP()), Collections.singletonList(ctx.OPT()), Collections.singletonList(ctx.OPTFILE()), Collections.singletonList(ctx.OPTIMIZE()), Collections.singletonList(ctx.OPTIONS()), Collections.singletonList(ctx.OUT()), Collections.singletonList(ctx.OUTDD()), Collections.singletonList(ctx.PFD()), Collections.singletonList(ctx.PGMN()), Collections.singletonList(ctx.PGMNAME()), Collections.singletonList(ctx.PROLOG()), Collections.singletonList(ctx.Q_CHAR()), Collections.singletonList(ctx.QUOTE()), Collections.singletonList(ctx.RENT()), Collections.singletonList(ctx.RMODE()), Collections.singletonList(ctx.RPARENCHAR()), ctx.S_CHAR(), Collections.singletonList(ctx.SEP()), Collections.singletonList(ctx.SEPARATE()), Collections.singletonList(ctx.SEQ()), Collections.singletonList(ctx.SEQUENCE()), Collections.singletonList(ctx.SHORT()), Collections.singletonList(ctx.SIZE()), Collections.singletonList(ctx.SOURCE()), Collections.singletonList(ctx.SP()), Collections.singletonList(ctx.SPACE()), Collections.singletonList(ctx.SPIE()), Collections.singletonList(ctx.SS()), Collections.singletonList(ctx.SSR()), Collections.singletonList(ctx.SSRANGE()), Collections.singletonList(ctx.STD()), Collections.singletonList(ctx.SQL()), Collections.singletonList(ctx.SQLC()), Collections.singletonList(ctx.SQLCCSID()), Collections.singletonList(ctx.SYSEIB()), Collections.singletonList(ctx.SZ()), Collections.singletonList(ctx.TERM()), Collections.singletonList(ctx.TERMINAL()), Collections.singletonList(ctx.THREAD()), Collections.singletonList(ctx.TEST()), Collections.singletonList(ctx.TRIG()), Collections.singletonList(ctx.TRUNC()), ctx.U_CHAR(), Collections.singletonList(ctx.UE()), Collections.singletonList(ctx.UPPER()), Collections.singletonList(ctx.VBREF()), Collections.singletonList(ctx.WD()), Collections.singletonList(ctx.WORD()), Collections.singletonList(ctx.X_CHAR()), Collections.singletonList(ctx.XP()), Collections.singletonList(ctx.XMLPARSE()), Collections.singletonList(ctx.XMLSS()), Collections.singletonList(ctx.XREF()), Collections.singletonList(ctx.YEARWINDOW()), Collections.singletonList(ctx.YW()), Collections.singletonList(ctx.ZWB()), ctx.W_CHAR()));
    }

    @Override
    public Object visitCompilerOptions(CobolPreprocessorParser.CompilerOptionsContext ctx) {
        return new CobolPreprocessor.CompilerOptions(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.PROCESS(), ctx.CBL()}), this.convertAllList(ctx.COMMACHAR(), ctx.compilerOption(), ctx.compilerXOpts()));
    }

    @Override
    public Object visitCompilerXOpts(CobolPreprocessorParser.CompilerXOptsContext ctx) {
        return new CobolPreprocessor.CompilerXOpts(Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.XOPTS()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.LPARENCHAR()), this.convertAllList(ctx.COMMACHAR(), ctx.compilerOption()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.RPARENCHAR()));
    }

    @Override
    public CobolPreprocessor.CompilationUnit visitCompilationUnit(CobolPreprocessorParser.CompilationUnitContext ctx) {
        this.init();
        return new CobolPreprocessor.CompilationUnit(this.path, this.fileAttributes, Space.EMPTY, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, new HashMap<String, CobolPreprocessor>(), new HashMap<String, Replacement>(), this.convertAll(ctx.charDataLine(), ctx.compilerOptions(), ctx.copyStatement(), ctx.execCicsStatement(), ctx.execSqlStatement(), ctx.execSqlIncludeStatement(), ctx.execSqlImsStatement(), ctx.ejectStatement(), ctx.replaceArea(), ctx.replaceOffStatement(), ctx.skipStatement(), ctx.titleStatement()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.EOF()));
    }

    @Override
    public Object visitCopyLibrary(CobolPreprocessorParser.CopyLibraryContext ctx) {
        return super.visitCopyLibrary(ctx);
    }

    @Override
    public Object visitCopySource(CobolPreprocessorParser.CopySourceContext ctx) {
        return new CobolPreprocessor.CopySource(Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.literal(), ctx.cobolWord(), ctx.filename()}), ctx.OF() == null && ctx.IN() == null ? null : (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.OF(), ctx.IN()}), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.copyLibrary()));
    }

    @Override
    public Object visitCopyStatement(CobolPreprocessorParser.CopyStatementContext ctx) {
        return new CobolPreprocessor.CopyStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.COPY()), (CobolPreprocessor.CopySource)this.visit((ParseTree)ctx.copySource()), this.convertAllList(ctx.directoryPhrase(), ctx.familyPhrase(), ctx.replacingPhrase(), ctx.SUPPRESS()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.DOT()), null);
    }

    @Override
    public Object visitDirectoryPhrase(CobolPreprocessorParser.DirectoryPhraseContext ctx) {
        return new CobolPreprocessor.DirectoryPhrase(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.OF(), ctx.IN()}), (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.literal(), ctx.cobolWord()}));
    }

    @Override
    public Object visitEjectStatement(CobolPreprocessorParser.EjectStatementContext ctx) {
        return new CobolPreprocessor.EjectStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.EJECT()), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitExecCicsStatement(CobolPreprocessorParser.ExecCicsStatementContext ctx) {
        return new CobolPreprocessor.ExecStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.EXEC(), ctx.CICS()), (CobolPreprocessor)this.visit((ParseTree)ctx.charData()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.END_EXEC()), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitExecSqlStatement(CobolPreprocessorParser.ExecSqlStatementContext ctx) {
        return new CobolPreprocessor.ExecStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.EXEC(), ctx.SQL()), (CobolPreprocessor)this.visit((ParseTree)ctx.charDataSql()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.END_EXEC()), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitExecSqlIncludeStatement(CobolPreprocessorParser.ExecSqlIncludeStatementContext ctx) {
        return new CobolPreprocessor.ExecSqlIncludeStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.EXEC(), ctx.SQL(), ctx.INCLUDE()), (CobolPreprocessor.Word)(ctx.literal() != null ? this.visit((ParseTree)ctx.literal()) : (ctx.cobolWord() != null ? this.visit((ParseTree)ctx.cobolWord()) : this.visit((ParseTree)ctx.filename()))), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.END_EXEC()), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()), null);
    }

    @Override
    public Object visitExecSqlImsStatement(CobolPreprocessorParser.ExecSqlImsStatementContext ctx) {
        return new CobolPreprocessor.ExecStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.EXEC(), ctx.SQLIMS()), (CobolPreprocessor)this.visit((ParseTree)ctx.charData()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.END_EXEC()), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitFamilyPhrase(CobolPreprocessorParser.FamilyPhraseContext ctx) {
        return new CobolPreprocessor.FamilyPhrase(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.ON()), (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.literal(), ctx.cobolWord()}));
    }

    @Override
    public Object visitFilename(CobolPreprocessorParser.FilenameContext ctx) {
        return super.visitFilename(ctx);
    }

    @Override
    public Object visitLiteral(CobolPreprocessorParser.LiteralContext ctx) {
        return super.visitLiteral(ctx);
    }

    @Override
    public Object visitPseudoText(CobolPreprocessorParser.PseudoTextContext ctx) {
        return new CobolPreprocessor.PseudoText(Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.DOUBLEEQUALCHAR().get(0)), (CobolPreprocessor.CharData)this.visitNullable((ParseTree)ctx.charData()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.DOUBLEEQUALCHAR().get(1)));
    }

    @Override
    public Object visitReplaceable(CobolPreprocessorParser.ReplaceableContext ctx) {
        return super.visitReplaceable(ctx);
    }

    @Override
    public Object visitReplaceArea(CobolPreprocessorParser.ReplaceAreaContext ctx) {
        return new CobolPreprocessor.ReplaceArea(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.ReplaceByStatement)this.visit((ParseTree)ctx.replaceByStatement()), this.convertAllList(ctx.copyStatement(), ctx.charData()), (CobolPreprocessor.ReplaceOffStatement)this.visitNullable((ParseTree)ctx.replaceOffStatement()));
    }

    @Override
    public Object visitReplaceByStatement(CobolPreprocessorParser.ReplaceByStatementContext ctx) {
        return new CobolPreprocessor.ReplaceByStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.REPLACE()), this.convertAll((List)ctx.replaceClause()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitReplaceClause(CobolPreprocessorParser.ReplaceClauseContext ctx) {
        return new CobolPreprocessor.ReplaceClause(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor)this.visit((ParseTree)ctx.replaceable()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.BY()), (CobolPreprocessor)this.visit((ParseTree)ctx.replacement()), (List)this.visitNullable((ParseTree)ctx.subscript()), this.convertAll((List)ctx.directoryPhrase()), (CobolPreprocessor.FamilyPhrase)this.visitNullable((ParseTree)ctx.familyPhrase()));
    }

    @Override
    public Object visitReplacement(CobolPreprocessorParser.ReplacementContext ctx) {
        return super.visitReplacement(ctx);
    }

    @Override
    public Object visitReplaceOffStatement(CobolPreprocessorParser.ReplaceOffStatementContext ctx) {
        return new CobolPreprocessor.ReplaceOffStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.wordsList(ctx.REPLACE(), ctx.OFF()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitReplacingPhrase(CobolPreprocessorParser.ReplacingPhraseContext ctx) {
        return new CobolPreprocessor.ReplacingPhrase(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.REPLACING()), this.convertAll((List)ctx.replaceClause()));
    }

    @Override
    public Object visitSkipStatement(CobolPreprocessorParser.SkipStatementContext ctx) {
        return new CobolPreprocessor.SkipStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit(new ParseTree[]{ctx.SKIP1(), ctx.SKIP2(), ctx.SKIP3()}), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()));
    }

    @Override
    public Object visitSubscript(CobolPreprocessorParser.SubscriptContext ctx) {
        return this.convertAllList(Collections.singletonList(ctx.LPARENCHAR()), ctx.literal(), ctx.cobolWord(), ctx.COMMACHAR(), Collections.singletonList(ctx.RPARENCHAR()));
    }

    public Object visitTerminal(TerminalNode node) {
        ArrayList<Object> objects = new ArrayList<Object>();
        Space prefix = this.processTokenText(node.getText(), objects);
        String text = "<EOF>".equals(node.getText()) ? "" : (node.getText().startsWith("*>CE ") ? node.getText().substring("*>CE ".length()) : node.getText());
        List cobolLines = null;
        Continuation continuation = null;
        SequenceArea sequenceArea = null;
        IndicatorArea indicatorArea = null;
        CommentArea commentArea = null;
        Replacement replacement = null;
        for (Object e : objects) {
            if (e instanceof List) {
                cobolLines = (List)e;
                continue;
            }
            if (e instanceof Continuation) {
                continuation = (Continuation)e;
                continue;
            }
            if (e instanceof SequenceArea) {
                sequenceArea = (SequenceArea)e;
                continue;
            }
            if (e instanceof IndicatorArea) {
                indicatorArea = (IndicatorArea)e;
                continue;
            }
            if (e instanceof CommentArea) {
                commentArea = (CommentArea)e;
                continue;
            }
            if (!(e instanceof Replacement)) continue;
            replacement = (Replacement)e;
        }
        return new CobolPreprocessor.Word(Space.EMPTY, Markers.EMPTY, new Cobol.Word(prefix, Markers.EMPTY, cobolLines, continuation, sequenceArea, indicatorArea, text, commentArea, replacement, Collections.emptyList()));
    }

    @Override
    public Object visitTitleStatement(CobolPreprocessorParser.TitleStatementContext ctx) {
        return new CobolPreprocessor.TitleStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (CobolPreprocessor.Word)this.visit((ParseTree)ctx.TITLE()), (CobolPreprocessor.Word)this.visit((ParseTree)ctx.literal()), (CobolPreprocessor.Word)this.visitNullable((ParseTree)ctx.DOT()));
    }

    private Space whitespace() {
        String prefix = this.source.substring(this.cursor, this.indexOfNextNonWhitespace(this.cursor, this.source));
        this.cursor += prefix.length();
        return Space.build(prefix);
    }

    private int indexOfNextNonWhitespace(int cursor, String source) {
        int delimIndex;
        for (delimIndex = cursor; delimIndex < source.length(); ++delimIndex) {
            char next;
            boolean isColumnArea;
            char c = source.charAt(delimIndex);
            boolean bl = isColumnArea = this.sequenceAreas.containsKey(delimIndex) || this.indicatorAreas.containsKey(delimIndex) || this.commentAreas.containsKey(delimIndex);
            if ((!Character.isWhitespace(c) || isColumnArea) && (c != ',' && (c != ';' || delimIndex + 1 >= source.length() - 1) || (next = source.charAt(delimIndex + 1)) != ' ' && next != '\r' && next != '\n')) break;
        }
        return delimIndex;
    }

    @Nullable
    private List<CobolPreprocessor.Word> wordsList(TerminalNode ... wordNodes) {
        ArrayList<CobolPreprocessor.Word> words = new ArrayList<CobolPreprocessor.Word>(wordNodes.length);
        for (TerminalNode wordNode : wordNodes) {
            if (wordNode == null) continue;
            CobolPreprocessor.Word cw = (CobolPreprocessor.Word)this.visit((ParseTree)wordNode);
            words.add(cw);
        }
        if (words.isEmpty()) {
            return null;
        }
        return words;
    }

    private <C, T extends ParseTree> List<C> convertAll(List<T> trees, Function<T, C> convert) {
        ArrayList converted = new ArrayList(trees.size());
        for (ParseTree tree : trees) {
            converted.add(convert.apply(tree));
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    @SafeVarargs
    private final <C extends CobolPreprocessor> List<C> convertAll(List<? extends ParserRuleContext> ... trees) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (List<? extends ParserRuleContext> tree : trees) {
            if (tree == null) continue;
            list.addAll(tree);
        }
        list.sort(Comparator.comparingInt(it -> it.start.getStartIndex()));
        return this.convertAll((List)list);
    }

    private <C extends CobolPreprocessor, T extends ParseTree> List<C> convertAll(List<T> trees) {
        return this.convertAll(trees, (T t) -> (CobolPreprocessor)this.visit((ParseTree)t));
    }

    @SafeVarargs
    private final List<CobolPreprocessor> convertAllList(List<? extends ParseTree> ... trees) {
        ArrayList<ParseTree> toSort = new ArrayList<ParseTree>();
        for (List<? extends ParseTree> tree : trees) {
            for (ParseTree parseTree : tree) {
                if (parseTree == null) continue;
                toSort.add(parseTree);
            }
        }
        toSort.sort(Comparator.comparingInt(it -> it instanceof TerminalNode ? ((TerminalNode)it).getSymbol().getStartIndex() : ((ParserRuleContext)it).getStart().getStartIndex()));
        ArrayList parsed = new ArrayList();
        for (ParseTree it3 : toSort) {
            CobolPreprocessor visit = (CobolPreprocessor)this.visit(it3);
            parsed.add(visit);
        }
        return parsed.isEmpty() ? Collections.emptyList() : parsed;
    }

    private Space processTokenText(String text, List<Object> objects) {
        this.parseCommentsAndEmptyLines(text, objects);
        int saveCursor = this.cursor;
        this.sequenceArea();
        this.indicatorArea();
        Integer nextIndicator = null;
        for (Integer integer : this.indicatorAreas.keySet()) {
            if (integer <= this.cursor) continue;
            nextIndicator = integer;
            break;
        }
        boolean isContinued = nextIndicator != null && this.indicatorAreas.get(nextIndicator).equals("-");
        Character delimiter = null;
        if (text.startsWith("'") || text.startsWith("\"")) {
            delimiter = Character.valueOf(text.charAt(0));
        }
        if (isContinued && delimiter == null) {
            Integer nextCommentArea = null;
            for (Integer it : this.commentAreas.keySet()) {
                if (it <= this.cursor) continue;
                nextCommentArea = it;
                break;
            }
            String current = this.source.substring(this.cursor);
            int newLinePos = current.indexOf("\n");
            int endPos = nextCommentArea != null && nextCommentArea < newLinePos + this.cursor ? nextCommentArea : newLinePos + this.cursor;
            current = this.source.substring(this.cursor, endPos).trim();
            isContinued = !current.startsWith(text);
        }
        this.cursor = saveCursor;
        if (isContinued) {
            return delimiter == null ? this.processContinuedText(text, objects) : this.processLiteral(text, objects, delimiter);
        }
        if ("<EOF>".equals(text) && this.source.substring(this.cursor).isEmpty()) {
            return Space.EMPTY;
        }
        return this.processText(text, objects);
    }

    private void parseCommentsAndEmptyLines(String text, List<Object> objects) {
        int saveCursor = this.cursor;
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        boolean isCommentEntry = text.startsWith("*>CE ");
        if (!isCommentEntry) {
            ArrayList<BlankLine> lines = new ArrayList<BlankLine>();
            for (int iterations = 0; iterations < 10000 && !this.source.substring(this.cursor).isEmpty() && !CobolStringUtils.isSubstituteCharacter(String.valueOf(this.source.substring(this.cursor).charAt(0))); ++iterations) {
                int newLinePos = this.cursor + (this.source.substring(this.cursor).contains("\n") ? this.source.substring(this.cursor).indexOf("\n") : this.source.substring(this.cursor).length());
                int endOfContentArea = this.cursor - this.cobolDialect.getColumns().getIndicatorArea() - 1 + this.cobolDialect.getColumns().getOtherArea();
                String contentArea = this.source.substring(this.cursor, Math.min(newLinePos, endOfContentArea));
                if (!this.isCommentIndicator(indicatorArea) && !contentArea.trim().isEmpty()) break;
                this.cursor += contentArea.length();
                CommentArea commentArea = this.commentArea();
                CobolLine line = indicatorArea != null && "*".equals(indicatorArea.getIndicator()) ? new CommentLine(Markers.EMPTY, sequenceArea, indicatorArea, contentArea, commentArea, false) : new BlankLine(Markers.EMPTY, sequenceArea, indicatorArea, contentArea, commentArea, false);
                lines.add((BlankLine)line);
                saveCursor = this.cursor;
                sequenceArea = this.sequenceArea();
                indicatorArea = this.indicatorArea();
            }
            if (!lines.isEmpty()) {
                objects.add(lines);
            }
        }
        this.cursor = saveCursor;
    }

    private Space processLiteral(String text, List<Object> objects, Character delimiter) {
        HashMap<Integer, List<ColumnArea>> continuations = new HashMap<Integer, List<ColumnArea>>();
        ArrayList<ColumnArea> continuation = new ArrayList<ColumnArea>(2);
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        if (sequenceArea != null) {
            continuation.add(sequenceArea);
        }
        if (indicatorArea != null) {
            continuation.add(indicatorArea);
        }
        Space prefix = this.whitespace();
        if (!continuation.isEmpty()) {
            continuations.put(0, continuation);
        }
        int matchedCount = 0;
        for (int iterations = 0; iterations < 250; ++iterations) {
            int end;
            continuation = new ArrayList(3);
            String current = this.source.substring(this.cursor);
            char[] charArray = text.substring(matchedCount).toCharArray();
            char[] sourceArray = current.toCharArray();
            for (end = 0; end < charArray.length && charArray[end] == sourceArray[end] && !this.commentAreas.containsKey(this.cursor); ++end) {
                ++this.cursor;
            }
            String matchedText = current.substring(0, end);
            matchedCount += matchedText.length();
            CommentArea commentArea = this.commentArea();
            if (commentArea != null) {
                continuation.add(commentArea);
            }
            if (matchedCount == text.length()) {
                if (continuation.isEmpty()) break;
                continuations.put(matchedCount + 1, continuation);
                break;
            }
            sequenceArea = this.sequenceArea();
            indicatorArea = this.indicatorArea(delimiter, true);
            if (sequenceArea != null) {
                continuation.add(sequenceArea);
            }
            if (indicatorArea != null) {
                continuation.add(indicatorArea);
            }
            if (continuation.isEmpty()) continue;
            continuations.put(matchedCount, continuation);
        }
        objects.add(new Continuation(Markers.EMPTY, continuations));
        return prefix;
    }

    private Space processText(String text, List<Object> objects) {
        Space prefix;
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        boolean isCommentEntry = text.startsWith("*>CE ");
        if (isCommentEntry) {
            text = text.substring("*>CE ".length());
        }
        Space space = prefix = isCommentEntry ? Space.EMPTY : this.whitespace();
        if (sequenceArea != null) {
            objects.add(sequenceArea);
        }
        if (indicatorArea != null) {
            objects.add(indicatorArea);
        }
        if (!"<EOF>".equals(text)) {
            this.cursor += text.length();
            CommentArea commentArea = this.commentArea();
            if (commentArea != null) {
                objects.add(commentArea);
            }
        }
        return prefix;
    }

    private Space processContinuedText(String text, List<Object> objects) {
        SequenceArea sequenceArea = this.sequenceArea();
        IndicatorArea indicatorArea = this.indicatorArea();
        boolean isCommentEntry = text.startsWith("*>CE ");
        if (isCommentEntry) {
            text = text.substring("*>CE ".length());
        }
        Space prefix = isCommentEntry ? Space.EMPTY : this.whitespace();
        HashMap<Integer, List<ColumnArea>> continuations = new HashMap<Integer, List<ColumnArea>>();
        ArrayList<ColumnArea> continuation = new ArrayList<ColumnArea>(2);
        if (sequenceArea != null) {
            continuation.add(sequenceArea);
        }
        if (indicatorArea != null) {
            continuation.add(indicatorArea);
        }
        if (!continuation.isEmpty()) {
            continuations.put(0, continuation);
        }
        int matchedCount = 0;
        for (int iterations = 0; iterations < 250; ++iterations) {
            int end;
            continuation = new ArrayList(3);
            String current = this.source.substring(this.cursor);
            char[] charArray = text.substring(matchedCount).toCharArray();
            char[] sourceArray = current.toCharArray();
            for (end = 0; end < charArray.length && charArray[end] == sourceArray[end] && !this.commentAreas.containsKey(this.cursor); ++end) {
                ++this.cursor;
            }
            String matchedText = current.substring(0, end);
            matchedCount += matchedText.length();
            CommentArea commentArea = this.commentArea();
            if (commentArea != null) {
                continuation.add(commentArea);
            }
            if (matchedCount == text.length()) {
                if (continuation.isEmpty()) break;
                continuations.put(matchedCount + 1, continuation);
                break;
            }
            sequenceArea = this.sequenceArea();
            if (sequenceArea != null) {
                continuation.add(sequenceArea);
            }
            if ((indicatorArea = this.indicatorArea(Character.valueOf(text.charAt(matchedCount)), false)) != null) {
                continuation.add(indicatorArea);
            }
            if (continuation.isEmpty()) continue;
            continuations.put(matchedCount, continuation);
        }
        objects.add(new Continuation(Markers.EMPTY, continuations));
        return prefix;
    }

    private boolean isCommentIndicator(@Nullable IndicatorArea area) {
        return area != null && this.commentIndicators.contains(Character.valueOf(area.getIndicator().charAt(0)));
    }

    @Nullable
    private SequenceArea sequenceArea() {
        if (this.sequenceAreas.containsKey(this.cursor)) {
            String sequence = this.sequenceAreas.get(this.cursor);
            this.cursor += sequence.length();
            return new SequenceArea(Markers.EMPTY, sequence);
        }
        return null;
    }

    @Nullable
    private IndicatorArea indicatorArea() {
        return this.indicatorArea(null, false);
    }

    @Nullable
    private IndicatorArea indicatorArea(@Nullable Character continuationDelimiter, boolean isStringLiteral) {
        if (this.indicatorAreas.containsKey(this.cursor)) {
            String current;
            int pos;
            String indicatorArea = this.indicatorAreas.get(this.cursor);
            this.cursor += indicatorArea.length();
            String continuationText = null;
            if (continuationDelimiter != null && (pos = (current = this.source.substring(this.cursor)).indexOf(continuationDelimiter.charValue())) != -1) {
                int endPos = (isStringLiteral ? 1 : 0) + current.indexOf(continuationDelimiter.charValue());
                continuationText = current.substring(0, endPos);
                this.cursor += continuationText.length();
            }
            return new IndicatorArea(Markers.EMPTY, indicatorArea, continuationText);
        }
        return null;
    }

    @Nullable
    private CommentArea commentArea() {
        int saveCursor = this.cursor;
        Space before = this.whitespace();
        String comment = null;
        Space endLine = Space.EMPTY;
        if (this.commentAreas.containsKey(this.cursor)) {
            comment = this.commentAreas.get(this.cursor);
            this.cursor += comment.length();
            endLine = this.whitespace();
        }
        if (before.getWhitespace().endsWith("\n") || comment != null) {
            return new CommentArea(before, Markers.EMPTY, comment == null ? "" : comment, endLine, false);
        }
        this.cursor = saveCursor;
        return null;
    }
}

