/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.internal;

import java.util.Optional;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.CobolPreprocessorVisitor;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.marker.CopiedWord;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class CobolPreprocessorSourcePrinter<P>
extends CobolPreprocessorVisitor<PrintOutputCapture<P>> {
    private final CobolSourcePrinter<P> cobolSourcePrinter;
    private final boolean printColumns;
    private int originalReplaceLength;
    private static final UnaryOperator<String> COBOL_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    public CobolPreprocessorSourcePrinter(boolean printColumns) {
        this.cobolSourcePrinter = new CobolSourcePrinter(printColumns);
        this.printColumns = printColumns;
    }

    @Override
    public CobolPreprocessor visitCharData(CobolPreprocessor.CharData charData, PrintOutputCapture<P> p) {
        this.beforeSyntax(charData, Space.Location.CHAR_DATA_PREFIX, p);
        this.visit(charData.getCobols(), p);
        this.afterSyntax(charData, p);
        return charData;
    }

    @Override
    public CobolPreprocessor visitCharDataLine(CobolPreprocessor.CharDataLine charDataLine, PrintOutputCapture<P> p) {
        this.beforeSyntax(charDataLine, Space.Location.CHAR_DATA_LINE_PREFIX, p);
        this.visit(charDataLine.getWords(), p);
        this.afterSyntax(charDataLine, p);
        return charDataLine;
    }

    @Override
    public CobolPreprocessor visitCharDataSql(CobolPreprocessor.CharDataSql charDataSql, PrintOutputCapture<P> p) {
        this.beforeSyntax(charDataSql, Space.Location.CHAR_DATA_SQL_PREFIX, p);
        this.visit(charDataSql.getCobols(), p);
        this.afterSyntax(charDataSql, p);
        return charDataSql;
    }

    @Override
    public CobolPreprocessor visitCommentEntry(CobolPreprocessor.CommentEntry commentEntry, PrintOutputCapture<P> p) {
        this.beforeSyntax(commentEntry, Space.Location.COMMENT_ENTRY_PREFIX, p);
        this.visit(commentEntry.getComments(), p);
        this.afterSyntax(commentEntry, p);
        return commentEntry;
    }

    @Override
    public CobolPreprocessor visitCompilationUnit(CobolPreprocessor.CompilationUnit compilationUnit, PrintOutputCapture<P> p) {
        this.beforeSyntax(compilationUnit, Space.Location.PREPROCESSOR_COMPILATION_UNIT_PREFIX, p);
        this.visit(compilationUnit.getCobols(), p);
        this.visit(compilationUnit.getEof(), p);
        this.afterSyntax(compilationUnit, p);
        return compilationUnit;
    }

    @Override
    public CobolPreprocessor visitCompilerOption(CobolPreprocessor.CompilerOption compilerOption, PrintOutputCapture<P> p) {
        this.beforeSyntax(compilerOption, Space.Location.COMPILER_OPTION_PREFIX, p);
        this.visit(compilerOption.getCobols(), p);
        this.afterSyntax(compilerOption, p);
        return compilerOption;
    }

    @Override
    public CobolPreprocessor visitCompilerOptions(CobolPreprocessor.CompilerOptions compilerOptions, PrintOutputCapture<P> p) {
        this.beforeSyntax(compilerOptions, Space.Location.COMPILER_OPTIONS_PREFIX, p);
        this.visit(compilerOptions.getWord(), p);
        this.visit(compilerOptions.getCobols(), p);
        this.afterSyntax(compilerOptions, p);
        return compilerOptions;
    }

    @Override
    public CobolPreprocessor visitCompilerXOpts(CobolPreprocessor.CompilerXOpts compilerXOpts, PrintOutputCapture<P> p) {
        this.beforeSyntax(compilerXOpts, Space.Location.COMPILER_XOPTS_PREFIX, p);
        this.visit(compilerXOpts.getWord(), p);
        this.visit(compilerXOpts.getLeftParen(), p);
        this.visit(compilerXOpts.getCompilerOptions(), p);
        this.visit(compilerXOpts.getRightParen(), p);
        this.afterSyntax(compilerXOpts, p);
        return compilerXOpts;
    }

    @Override
    public CobolPreprocessor visitCopybook(CobolPreprocessor.Copybook copybook, PrintOutputCapture<P> p) {
        return copybook;
    }

    @Override
    public CobolPreprocessor visitCopySource(CobolPreprocessor.CopySource copySource, PrintOutputCapture<P> p) {
        this.beforeSyntax(copySource, Space.Location.COPY_SOURCE_PREFIX, p);
        this.visit(copySource.getName(), p);
        this.visit(copySource.getWord(), p);
        this.visit(copySource.getCopyLibrary(), p);
        this.afterSyntax(copySource, p);
        return copySource;
    }

    @Override
    public CobolPreprocessor visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(copyStatement, Space.Location.COPY_STATEMENT_PREFIX, p);
        this.visit(copyStatement.getWord(), p);
        this.visit(copyStatement.getCopySource(), p);
        this.visit(copyStatement.getCobols(), p);
        this.visit(copyStatement.getDot(), p);
        this.afterSyntax(copyStatement, p);
        return copyStatement;
    }

    @Override
    public CobolPreprocessor visitDirectoryPhrase(CobolPreprocessor.DirectoryPhrase directoryPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(directoryPhrase, Space.Location.DIRECTORY_PHRASE_PREFIX, p);
        this.visit(directoryPhrase.getWord(), p);
        this.visit(directoryPhrase.getName(), p);
        this.afterSyntax(directoryPhrase, p);
        return directoryPhrase;
    }

    @Override
    public CobolPreprocessor visitEjectStatement(CobolPreprocessor.EjectStatement ejectStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(ejectStatement, Space.Location.EJECT_STATEMENT_PREFIX, p);
        this.visit(ejectStatement.getWord(), p);
        this.visit(ejectStatement.getDot(), p);
        this.afterSyntax(ejectStatement, p);
        return ejectStatement;
    }

    @Override
    public CobolPreprocessor visitExecStatement(CobolPreprocessor.ExecStatement execStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(execStatement, Space.Location.EXEC_STATEMENT_PREFIX, p);
        this.visit(execStatement.getWords(), p);
        this.visit(execStatement.getCobol(), p);
        this.visit(execStatement.getEndExec(), p);
        this.visit(execStatement.getDot(), p);
        this.afterSyntax(execStatement, p);
        return execStatement;
    }

    @Override
    public CobolPreprocessor visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(execSqlIncludeStatement, Space.Location.EXEC_SQL_INCLUDE_STATEMENT_PREFIX, p);
        this.visit(execSqlIncludeStatement.getWords(), p);
        this.visit(execSqlIncludeStatement.getCopySource(), p);
        this.visit(execSqlIncludeStatement.getEndExec(), p);
        this.visit(execSqlIncludeStatement.getDot(), p);
        this.afterSyntax(execSqlIncludeStatement, p);
        return execSqlIncludeStatement;
    }

    @Override
    public CobolPreprocessor visitFamilyPhrase(CobolPreprocessor.FamilyPhrase familyPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(familyPhrase, Space.Location.FAMILY_PHRASE_PREFIX, p);
        this.visit(familyPhrase.getWord(), p);
        this.visit(familyPhrase.getName(), p);
        this.afterSyntax(familyPhrase, p);
        return familyPhrase;
    }

    @Override
    public CobolPreprocessor visitPseudoText(CobolPreprocessor.PseudoText pseudoText, PrintOutputCapture<P> p) {
        this.beforeSyntax(pseudoText, Space.Location.PSEUDO_TEXT_PREFIX, p);
        this.visit(pseudoText.getDoubleEqualOpen(), p);
        this.visit(pseudoText.getCharData(), p);
        this.visit(pseudoText.getDoubleEqualClose(), p);
        this.afterSyntax(pseudoText, p);
        return pseudoText;
    }

    @Override
    public CobolPreprocessor visitReplaceArea(CobolPreprocessor.ReplaceArea replaceArea, PrintOutputCapture<P> p) {
        this.beforeSyntax(replaceArea, Space.Location.REPLACE_AREA_PREFIX, p);
        this.visit(replaceArea.getReplaceByStatement(), p);
        this.visit(replaceArea.getCobols(), p);
        this.visit(replaceArea.getReplaceOffStatement(), p);
        this.afterSyntax(replaceArea, p);
        return replaceArea;
    }

    @Override
    public CobolPreprocessor visitReplaceByStatement(CobolPreprocessor.ReplaceByStatement replaceByStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(replaceByStatement, Space.Location.REPLACE_BY_STATEMENT_PREFIX, p);
        this.visit(replaceByStatement.getWord(), p);
        this.visit(replaceByStatement.getClauses(), p);
        this.visit(replaceByStatement.getDot(), p);
        this.afterSyntax(replaceByStatement, p);
        return replaceByStatement;
    }

    @Override
    public CobolPreprocessor visitReplaceClause(CobolPreprocessor.ReplaceClause replaceClause, PrintOutputCapture<P> p) {
        this.beforeSyntax(replaceClause, Space.Location.REPLACE_CLAUSE_PREFIX, p);
        this.visit(replaceClause.getReplaceable(), p);
        this.visit(replaceClause.getBy(), p);
        this.visit(replaceClause.getReplacement(), p);
        this.visit(replaceClause.getSubscript(), p);
        this.visit(replaceClause.getDirectoryPhrases(), p);
        this.visit(replaceClause.getFamilyPhrase(), p);
        this.afterSyntax(replaceClause, p);
        return replaceClause;
    }

    @Override
    public CobolPreprocessor visitReplaceOffStatement(CobolPreprocessor.ReplaceOffStatement replaceOffStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(replaceOffStatement, Space.Location.REPLACE_OFF_STATEMENT_PREFIX, p);
        this.visit(replaceOffStatement.getWords(), p);
        this.visit(replaceOffStatement.getDot(), p);
        this.afterSyntax(replaceOffStatement, p);
        return replaceOffStatement;
    }

    @Override
    public CobolPreprocessor visitReplacingPhrase(CobolPreprocessor.ReplacingPhrase replacingPhrase, PrintOutputCapture<P> p) {
        this.beforeSyntax(replacingPhrase, Space.Location.REPLACING_PHRASE_PREFIX, p);
        this.visit(replacingPhrase.getWord(), p);
        this.visit(replacingPhrase.getClauses(), p);
        this.afterSyntax(replacingPhrase, p);
        return replacingPhrase;
    }

    @Override
    public CobolPreprocessor visitSkipStatement(CobolPreprocessor.SkipStatement skipStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(skipStatement, Space.Location.SKIP_STATEMENT_PREFIX, p);
        this.visit(skipStatement.getWord(), p);
        this.visit(skipStatement.getDot(), p);
        this.afterSyntax(skipStatement, p);
        return skipStatement;
    }

    @Override
    public Space visitSpace(Space space, Space.Location location, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        return space;
    }

    @Override
    public CobolPreprocessor visitTitleStatement(CobolPreprocessor.TitleStatement titleStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(titleStatement, Space.Location.TITLE_STATEMENT_PREFIX, p);
        this.visit(titleStatement.getFirst(), p);
        this.visit(titleStatement.getSecond(), p);
        this.visit(titleStatement.getDot(), p);
        this.afterSyntax(titleStatement, p);
        return titleStatement;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CobolPreprocessor visitWord(CobolPreprocessor.Word word, PrintOutputCapture<P> p) {
        Optional copiedWord = word.getMarkers().findFirst(CopiedWord.class);
        CobolPreprocessor.CopyStatement copyStatement = null;
        for (CobolPreprocessor preprocessorStatement : word.getCobolWord().getPreprocessorStatements()) {
            if (preprocessorStatement instanceof CobolPreprocessor.CopyStatement) {
                copyStatement = (CobolPreprocessor.CopyStatement)preprocessorStatement;
                continue;
            }
            this.cobolSourcePrinter.visit(preprocessorStatement, p);
        }
        if (copyStatement == null && copiedWord.isPresent()) {
            return word;
        }
        if (word.getCobolWord().getReplacement() != null) {
            if (word.getCobolWord().getReplacement().getType() == Replacement.Type.EQUAL) {
                Replacement.OriginalWord originalWord = word.getCobolWord().getReplacement().getOriginalWords().get(0);
                this.cobolSourcePrinter.visitWord(originalWord.getOriginal(), p);
                if (!originalWord.isReplacedWithEmpty()) {
                    this.originalReplaceLength = 0;
                    return word;
                }
                this.originalReplaceLength = word.getPrefix().getWhitespace().length() - word.getCobolWord().getWord().length();
            } else if (word.getCobolWord().getReplacement().getType() == Replacement.Type.REDUCTIVE && !word.getCobolWord().getReplacement().isCopiedSource()) {
                for (Replacement.OriginalWord originalWord : word.getCobolWord().getReplacement().getOriginalWords()) {
                    this.cobolSourcePrinter.visitWord(originalWord.getOriginal(), p);
                }
                if (word.getCobolWord().getSequenceArea() != null) {
                    word.getCobolWord().getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
                }
                if (word.getCobolWord().getIndicatorArea() != null) {
                    word.getCobolWord().getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
                }
                this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
                p.append(word.getCobolWord().getWord());
                return word;
            }
        }
        if (copyStatement != null) {
            this.visit(copyStatement, p);
            return word;
        }
        if (this.printColumns && word.getCobolWord().getLines() != null) {
            for (CobolLine cobolLine : word.getCobolWord().getLines()) {
                this.visitMarkers(cobolLine.getMarkers(), p);
                cobolLine.printCobolLine(this, this.getCursor(), p);
            }
        }
        if (word.getCobolWord().getContinuation() != null) {
            word.getCobolWord().getContinuation().printContinuation(this, this.getCursor(), word, this.printColumns, p);
        } else {
            if (word.getCobolWord().getSequenceArea() != null) {
                word.getCobolWord().getSequenceArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            if (word.getCobolWord().getIndicatorArea() != null) {
                word.getCobolWord().getIndicatorArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
            if (word.getCobolWord().getReplacement() != null && word.getCobolWord().getReplacement().getType() == Replacement.Type.EQUAL && word.getCobolWord().getReplacement().getOriginalWords().get(0).isReplacedWithEmpty()) {
                p.append(StringUtils.repeat((String)" ", (int)(word.getPrefix().getWhitespace().length() - this.originalReplaceLength)));
                this.originalReplaceLength = 0;
            } else {
                this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
            }
            p.append(word.getCobolWord().getWord());
            if (word.getCobolWord().getCommentArea() != null && !word.getCobolWord().getCommentArea().isAdded()) {
                word.getCobolWord().getCommentArea().printColumnArea(this, this.getCursor(), this.printColumns, p);
            }
        }
        this.afterSyntax(word, p);
        return word;
    }

    protected void beforeSyntax(CobolPreprocessor c, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(c.getPrefix(), c.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), COBOL_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), COBOL_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(CobolPreprocessor c, PrintOutputCapture<P> p) {
        this.afterSyntax(c.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), COBOL_MARKER_WRAPPER));
        }
    }
}

