/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.CobolPreprocessorIsoVisitor;
import org.openrewrite.cobol.marker.MissingCopybook;
import org.openrewrite.cobol.search.UsesCopybook;
import org.openrewrite.cobol.table.CopybookSource;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

public final class FindCopybook
extends Recipe {
    private final transient CopybookSource copybookSource = new CopybookSource(this);
    @Option(displayName="Copybook name", description="The copybook name to search for. If not provided, all copy statements will be returned.", example="KP008", required=false)
    @Nullable
    private final String copybookName;
    @Option(displayName="Only missing copybooks", description="Only find copy statements and exec sql include statements that are missing copybooks.", example="True", required=false)
    @Nullable
    private final Boolean onlyMissingCopybooks;

    public String getDisplayName() {
        return "Find copybook usage";
    }

    public String getDescription() {
        return "Find all copy statements with the copybook name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final CobolPreprocessorIsoVisitor<ExecutionContext> preprocessorVisitor = new CobolPreprocessorIsoVisitor<ExecutionContext>(){

            @Override
            public CobolPreprocessor.CopyStatement visitCopyStatement(CobolPreprocessor.CopyStatement copyStatement, ExecutionContext ctx) {
                CobolPreprocessor cs = super.visitCopyStatement(copyStatement, ctx);
                if (((CobolPreprocessor.CopyStatement)cs).getMarkers().findFirst(MissingCopybook.class).isPresent()) {
                    FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), ((CobolPreprocessor.CopyStatement)cs).getCopySource().getName().getCobolWord().getWord(), "", CopybookSource.ResolutionStatus.MISSING_SOURCE, ""));
                    return ((CobolPreprocessor.CopyStatement)cs).withCopySource(((CobolPreprocessor.CopyStatement)cs).getCopySource().withName((CobolPreprocessor.Word)SearchResult.found((Tree)((CobolPreprocessor.CopyStatement)cs).getCopySource().getName())));
                }
                if (!Boolean.TRUE.equals(FindCopybook.this.onlyMissingCopybooks) && (FindCopybook.this.copybookName == null || FindCopybook.this.copybookName.isEmpty() || FindCopybook.this.copybookName.equals(((CobolPreprocessor.CopyStatement)cs).getCopySource().getName().getCobolWord().getWord()))) {
                    CobolPreprocessor.CopyStatement updated = ((CobolPreprocessor.CopyStatement)cs).withCopySource(((CobolPreprocessor.CopyStatement)cs).getCopySource().withName((CobolPreprocessor.Word)SearchResult.found((Tree)((CobolPreprocessor.CopyStatement)cs).getCopySource().getName(), null)));
                    boolean copySourceResolved = ((CobolPreprocessor.CopyStatement)cs).getCopybook() != null;
                    FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), ((CobolPreprocessor.CopyStatement)cs).getCopySource().getName().getCobolWord().getWord(), copySourceResolved ? ((CobolPreprocessor.CopyStatement)cs).getCopybook().getSourcePath().toString() : "", copySourceResolved ? CopybookSource.ResolutionStatus.RESOLVED : CopybookSource.ResolutionStatus.NO_SOURCE_PATH, ""));
                    return updated;
                }
                return cs;
            }

            @Override
            public CobolPreprocessor.ExecSqlIncludeStatement visitExecSqlIncludeStatement(CobolPreprocessor.ExecSqlIncludeStatement execSqlIncludeStatement, ExecutionContext ctx) {
                CobolPreprocessor is = super.visitExecSqlIncludeStatement(execSqlIncludeStatement, ctx);
                if (((CobolPreprocessor.ExecSqlIncludeStatement)is).getMarkers().findFirst(MissingCopybook.class).isPresent()) {
                    FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), ((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopySource().getCobolWord().getWord(), "", CopybookSource.ResolutionStatus.MISSING_SOURCE, ""));
                    return ((CobolPreprocessor.ExecSqlIncludeStatement)is).withCopySource((CobolPreprocessor.Word)SearchResult.found((Tree)((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopySource()));
                }
                if (!Boolean.TRUE.equals(FindCopybook.this.onlyMissingCopybooks) && (FindCopybook.this.copybookName == null || FindCopybook.this.copybookName.isEmpty() || FindCopybook.this.copybookName.equals(((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopySource().getCobolWord().getWord()))) {
                    CobolPreprocessor.ExecSqlIncludeStatement updated = ((CobolPreprocessor.ExecSqlIncludeStatement)is).withCopySource((CobolPreprocessor.Word)SearchResult.found((Tree)((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopySource(), null));
                    boolean copySourceResolved = ((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopybook() != null;
                    FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), ((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopySource().getCobolWord().getWord(), copySourceResolved ? ((CobolPreprocessor.ExecSqlIncludeStatement)is).getCopybook().getSourcePath().toString() : "", copySourceResolved ? CopybookSource.ResolutionStatus.RESOLVED : CopybookSource.ResolutionStatus.NO_SOURCE_PATH, ""));
                    return updated;
                }
                return is;
            }
        };
        return Preconditions.check((TreeVisitor)new UsesCopybook(this.copybookName), (TreeVisitor)new CobolIsoVisitor<ExecutionContext>(){

            @Override
            public Cobol.Word visitWord(Cobol.Word word, ExecutionContext ctx) {
                Cobol w = super.visitWord(word, ctx);
                w = ((Cobol.Word)w).withPreprocessorStatements(ListUtils.map(((Cobol.Word)w).getPreprocessorStatements(), ps -> {
                    if (ps instanceof CobolPreprocessor.CopyStatement) {
                        CobolPreprocessor.CopyStatement copyStatement = (CobolPreprocessor.CopyStatement)ps;
                        if (copyStatement.getMarkers().findFirst(MissingCopybook.class).isPresent()) {
                            FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), copyStatement.getCopySource().getName().getCobolWord().getWord(), "", CopybookSource.ResolutionStatus.MISSING_SOURCE, ""));
                            return copyStatement.withCopySource(copyStatement.getCopySource().withName((CobolPreprocessor.Word)SearchResult.found((Tree)copyStatement.getCopySource().getName())));
                        }
                        if (!Boolean.TRUE.equals(FindCopybook.this.onlyMissingCopybooks) && (FindCopybook.this.copybookName == null || FindCopybook.this.copybookName.isEmpty() || FindCopybook.this.copybookName.equals(copyStatement.getCopySource().getName().getCobolWord().getWord()))) {
                            CobolPreprocessor.CopyStatement updated = copyStatement.withCopySource(copyStatement.getCopySource().withName((CobolPreprocessor.Word)SearchResult.found((Tree)copyStatement.getCopySource().getName(), null)));
                            if (updated.getCopybook() != null) {
                                updated = updated.withCopybook(updated.getCopybook().withLst(ListUtils.map(updated.getCopybook().getLst(), l -> (CobolPreprocessor)preprocessorVisitor.visit((Tree)l, ctx, this.getCursor()))));
                            }
                            boolean copySourceResolved = updated.getCopybook() != null;
                            FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), updated.getCopySource().getName().getCobolWord().getWord(), copySourceResolved ? updated.getCopybook().getSourcePath().toString() : "", copySourceResolved ? CopybookSource.ResolutionStatus.RESOLVED : CopybookSource.ResolutionStatus.NO_SOURCE_PATH, word.getWord()));
                            return updated;
                        }
                    } else if (ps instanceof CobolPreprocessor.ExecSqlIncludeStatement) {
                        CobolPreprocessor.ExecSqlIncludeStatement includeStatement = (CobolPreprocessor.ExecSqlIncludeStatement)ps;
                        if (includeStatement.getMarkers().findFirst(MissingCopybook.class).isPresent()) {
                            FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), includeStatement.getCopySource().getCobolWord().getWord(), "", CopybookSource.ResolutionStatus.MISSING_SOURCE, ""));
                            return includeStatement.withCopySource((CobolPreprocessor.Word)SearchResult.found((Tree)includeStatement.getCopySource()));
                        }
                        if (!Boolean.TRUE.equals(FindCopybook.this.onlyMissingCopybooks) && (FindCopybook.this.copybookName == null || FindCopybook.this.copybookName.isEmpty() || FindCopybook.this.copybookName.equals(includeStatement.getCopySource().getCobolWord().getWord()))) {
                            CobolPreprocessor.ExecSqlIncludeStatement updated = includeStatement.withCopySource((CobolPreprocessor.Word)SearchResult.found((Tree)includeStatement.getCopySource(), null));
                            if (updated.getCopybook() != null) {
                                updated = updated.withCopybook(updated.getCopybook().withLst(ListUtils.map(updated.getCopybook().getLst(), l -> (CobolPreprocessor)preprocessorVisitor.visit((Tree)l, ctx, this.getCursor()))));
                            }
                            boolean copySourceResolved = updated.getCopybook() != null;
                            FindCopybook.this.copybookSource.insertRow(ctx, new CopybookSource.Row(((Cobol.CompilationUnit)this.getCursor().firstEnclosingOrThrow(Cobol.CompilationUnit.class)).getSourcePath().toString(), updated.getCopySource().getCobolWord().getWord(), copySourceResolved ? updated.getCopybook().getSourcePath().toString() : "", copySourceResolved ? CopybookSource.ResolutionStatus.RESOLVED : CopybookSource.ResolutionStatus.NO_SOURCE_PATH, word.getWord()));
                            return updated;
                        }
                    }
                    return ps;
                }));
                return w;
            }
        });
    }

    public FindCopybook(String copybookName, Boolean onlyMissingCopybooks) {
        this.copybookName = copybookName;
        this.onlyMissingCopybooks = onlyMissingCopybooks;
    }

    public CopybookSource getCopybookSource() {
        return this.copybookSource;
    }

    public String getCopybookName() {
        return this.copybookName;
    }

    public Boolean getOnlyMissingCopybooks() {
        return this.onlyMissingCopybooks;
    }

    public String toString() {
        return "FindCopybook(copybookSource=" + (Object)((Object)this.getCopybookSource()) + ", copybookName=" + this.getCopybookName() + ", onlyMissingCopybooks=" + this.getOnlyMissingCopybooks() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCopybook)) {
            return false;
        }
        FindCopybook other = (FindCopybook)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$onlyMissingCopybooks = this.getOnlyMissingCopybooks();
        Boolean other$onlyMissingCopybooks = other.getOnlyMissingCopybooks();
        if (this$onlyMissingCopybooks == null ? other$onlyMissingCopybooks != null : !((Object)this$onlyMissingCopybooks).equals(other$onlyMissingCopybooks)) {
            return false;
        }
        String this$copybookName = this.getCopybookName();
        String other$copybookName = other.getCopybookName();
        return !(this$copybookName == null ? other$copybookName != null : !this$copybookName.equals(other$copybookName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindCopybook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $onlyMissingCopybooks = this.getOnlyMissingCopybooks();
        result = result * 59 + ($onlyMissingCopybooks == null ? 43 : ((Object)$onlyMissingCopybooks).hashCode());
        String $copybookName = this.getCopybookName();
        result = result * 59 + ($copybookName == null ? 43 : $copybookName.hashCode());
        return result;
    }
}

