/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolIsoVisitor;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindIndicators
extends Recipe {
    @Option(displayName="Indicator character", description="Indicator to search for.", example="D")
    private final String indicator;

    public String getDisplayName() {
        return "Find indicators";
    }

    public String getDescription() {
        return "Find matching indicators. Currently, this recipe will not mark indicators on copybook code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddSearchResult(this.indicator);
    }

    public FindIndicators(String indicator) {
        this.indicator = indicator;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public String toString() {
        return "FindIndicators(indicator=" + this.getIndicator() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindIndicators)) {
            return false;
        }
        FindIndicators other = (FindIndicators)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$indicator = this.getIndicator();
        String other$indicator = other.getIndicator();
        return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindIndicators;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $indicator = this.getIndicator();
        result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
        return result;
    }

    private static class AddSearchResult
    extends CobolIsoVisitor<ExecutionContext> {
        private final String indicator;

        public AddSearchResult(String indicator) {
            this.indicator = indicator;
        }

        @Override
        public Cobol.Word visitWord(Cobol.Word word, ExecutionContext executionContext) {
            if (word.getIndicatorArea() != null && word.getIndicatorArea().getIndicator().equals(this.indicator)) {
                word = word.withIndicatorArea(word.getIndicatorArea().withMarkers(word.getIndicatorArea().getMarkers().addIfAbsent((Marker)new SearchResult(Tree.randomId(), null))));
            }
            return word;
        }
    }
}

