/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.search;

import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolPreprocessorVisitor;
import org.openrewrite.cobol.NameVisitor;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.JclIsoVisitor;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.marker.SearchResult;

public final class FindReference
extends Recipe {
    @Option(displayName="Term to search for", description="A word or regex pattern to find. By default the search term is case insensitive.", example="CM102M or cm1.*")
    private final String searchTerm;
    @Nullable
    @Option(displayName="Only match exact word", description="Search for a word based on an exact match of the search term.", example="true")
    private final Boolean exactMatch;

    public String getDisplayName() {
        return "Find matching identifiers in COBOL, copybooks, and JCL";
    }

    public String getDescription() {
        return "Finds an identifier by an exact match or regex pattern in COBOL, copybooks, and/or JCL.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            private final CobolReference cobolReference = new CobolReference();
            private final CopybookReference copybookReference = new CopybookReference();
            private final JclReference jclReference = new JclReference();
            @Nullable
            private final Pattern pattern = Boolean.TRUE.equals(FindReference.access$000(FindReference.this)) ? null : Pattern.compile(FindReference.access$100(FindReference.this).toLowerCase());

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext executionContext) {
                return this.cobolReference.isAcceptable(sourceFile, executionContext) || this.copybookReference.isAcceptable(sourceFile, executionContext) || this.jclReference.isAcceptable(sourceFile, executionContext);
            }

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (tree instanceof Cobol) {
                    return this.cobolReference.visit(tree, executionContext);
                }
                if (tree instanceof CobolPreprocessor.Copybook) {
                    return this.copybookReference.visit(tree, executionContext);
                }
                if (tree instanceof Jcl.CompilationUnit) {
                    return this.jclReference.visit(tree, executionContext);
                }
                return super.visit(tree, (Object)executionContext);
            }

            private boolean matches(String word) {
                return this.pattern != null && this.pattern.matcher(word.toLowerCase()).matches() || this.pattern == null && word.equals(FindReference.this.searchTerm);
            }

            class CobolReference
            extends NameVisitor<ExecutionContext> {
                CobolReference() {
                }

                @Override
                public Cobol.Word visitWord(Cobol.Word word, ExecutionContext executionContext) {
                    if (this.matches(word.getWord())) {
                        return (Cobol.Word)SearchResult.found((Tree)word);
                    }
                    return super.visitWord(word, executionContext);
                }
            }

            class CopybookReference
            extends CobolPreprocessorVisitor<ExecutionContext> {
                CopybookReference() {
                }

                @Override
                public CobolPreprocessor visitWord(CobolPreprocessor.Word word, ExecutionContext executionContext) {
                    if (this.matches(word.getCobolWord().getWord())) {
                        return (CobolPreprocessor)SearchResult.found((Tree)word);
                    }
                    return super.visitWord(word, executionContext);
                }
            }

            class JclReference
            extends JclIsoVisitor<ExecutionContext> {
                JclReference() {
                }
            }
        };
    }

    public FindReference(String searchTerm, Boolean exactMatch) {
        this.searchTerm = searchTerm;
        this.exactMatch = exactMatch;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public Boolean getExactMatch() {
        return this.exactMatch;
    }

    public String toString() {
        return "FindReference(searchTerm=" + this.getSearchTerm() + ", exactMatch=" + this.getExactMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindReference)) {
            return false;
        }
        FindReference other = (FindReference)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$exactMatch = this.getExactMatch();
        Boolean other$exactMatch = other.getExactMatch();
        if (this$exactMatch == null ? other$exactMatch != null : !((Object)this$exactMatch).equals(other$exactMatch)) {
            return false;
        }
        String this$searchTerm = this.getSearchTerm();
        String other$searchTerm = other.getSearchTerm();
        return !(this$searchTerm == null ? other$searchTerm != null : !this$searchTerm.equals(other$searchTerm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $exactMatch = this.getExactMatch();
        result = result * 59 + ($exactMatch == null ? 43 : ((Object)$exactMatch).hashCode());
        String $searchTerm = this.getSearchTerm();
        result = result * 59 + ($searchTerm == null ? 43 : $searchTerm.hashCode());
        return result;
    }

    static /* synthetic */ Boolean access$000(FindReference x0) {
        return x0.exactMatch;
    }
}

