/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class CobolRelationships
extends DataTable<Row> {
    public CobolRelationships(Recipe recipe) {
        super(recipe, "COBOL relationships", "Relationships between different COBOL resources.");
    }

    public static enum ResourceAction {
        ACCESS,
        COPY,
        CALL,
        INCLUDE,
        PLAN,
        MEMBER,
        TRIGGERS;

    }

    public static enum ResourceType {
        COBOL,
        COPYBOOK,
        LINKEDIT,
        BINDPLAN,
        BINDPACKAGE,
        SQL_CURSOR,
        SQL_TABLE,
        CONTROL_M_SCHEDULE,
        JCL;

    }

    public static final class Row {
        @Column(displayName="Dependent", description="The resource that defines the relationship.")
        private final String dependent;
        @Column(displayName="Dependent type", description="The resource type of the resource that defines the relationship.")
        private final ResourceType dependentType;
        @Column(displayName="Action", description="The action that links the dependent and dependency.")
        private final ResourceAction action;
        @Column(displayName="Dependency", description="The resource that is exercised or linked to.")
        private final String dependency;
        @Column(displayName="Dependency type", description="The resource type of the resource that is exercised or linked to.")
        private final ResourceType dependencyType;
        @Column(displayName="Dependency missing", description="Indicates whether the dependency is a known resource.")
        private final boolean dependencyMissing;
        @Column(displayName="Action metadata", description="Additional data about the action.")
        private final String actionMetadata;

        public Row(String dependent, ResourceType dependentType, ResourceAction action, String dependency, ResourceType dependencyType, boolean dependencyMissing, String actionMetadata) {
            this.dependent = dependent;
            this.dependentType = dependentType;
            this.action = action;
            this.dependency = dependency;
            this.dependencyType = dependencyType;
            this.dependencyMissing = dependencyMissing;
            this.actionMetadata = actionMetadata;
        }

        public String getDependent() {
            return this.dependent;
        }

        public ResourceType getDependentType() {
            return this.dependentType;
        }

        public ResourceAction getAction() {
            return this.action;
        }

        public String getDependency() {
            return this.dependency;
        }

        public ResourceType getDependencyType() {
            return this.dependencyType;
        }

        public boolean isDependencyMissing() {
            return this.dependencyMissing;
        }

        public String getActionMetadata() {
            return this.actionMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isDependencyMissing() != other.isDependencyMissing()) {
                return false;
            }
            String this$dependent = this.getDependent();
            String other$dependent = other.getDependent();
            if (this$dependent == null ? other$dependent != null : !this$dependent.equals(other$dependent)) {
                return false;
            }
            ResourceType this$dependentType = this.getDependentType();
            ResourceType other$dependentType = other.getDependentType();
            if (this$dependentType == null ? other$dependentType != null : !((Object)((Object)this$dependentType)).equals((Object)other$dependentType)) {
                return false;
            }
            ResourceAction this$action = this.getAction();
            ResourceAction other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            String this$dependency = this.getDependency();
            String other$dependency = other.getDependency();
            if (this$dependency == null ? other$dependency != null : !this$dependency.equals(other$dependency)) {
                return false;
            }
            ResourceType this$dependencyType = this.getDependencyType();
            ResourceType other$dependencyType = other.getDependencyType();
            if (this$dependencyType == null ? other$dependencyType != null : !((Object)((Object)this$dependencyType)).equals((Object)other$dependencyType)) {
                return false;
            }
            String this$actionMetadata = this.getActionMetadata();
            String other$actionMetadata = other.getActionMetadata();
            return !(this$actionMetadata == null ? other$actionMetadata != null : !this$actionMetadata.equals(other$actionMetadata));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDependencyMissing() ? 79 : 97);
            String $dependent = this.getDependent();
            result = result * 59 + ($dependent == null ? 43 : $dependent.hashCode());
            ResourceType $dependentType = this.getDependentType();
            result = result * 59 + ($dependentType == null ? 43 : ((Object)((Object)$dependentType)).hashCode());
            ResourceAction $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            String $dependency = this.getDependency();
            result = result * 59 + ($dependency == null ? 43 : $dependency.hashCode());
            ResourceType $dependencyType = this.getDependencyType();
            result = result * 59 + ($dependencyType == null ? 43 : ((Object)((Object)$dependencyType)).hashCode());
            String $actionMetadata = this.getActionMetadata();
            result = result * 59 + ($actionMetadata == null ? 43 : $actionMetadata.hashCode());
            return result;
        }

        public String toString() {
            return "CobolRelationships.Row(dependent=" + this.getDependent() + ", dependentType=" + (Object)((Object)this.getDependentType()) + ", action=" + (Object)((Object)this.getAction()) + ", dependency=" + this.getDependency() + ", dependencyType=" + (Object)((Object)this.getDependencyType()) + ", dependencyMissing=" + this.isDependencyMissing() + ", actionMetadata=" + this.getActionMetadata() + ")";
        }
    }
}

