/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class CopybookSource
extends DataTable<Row> {
    public CopybookSource(Recipe recipe) {
        super(recipe, "Copybook source information", "Information about copybook references in a COBOL source.");
    }

    public static enum ResolutionStatus {
        MISSING_SOURCE,
        NO_SOURCE_PATH,
        RESOLVED;

    }

    public static final class Row {
        @Column(displayName="Source path", description="The source path of the file that contains the copy statement.")
        private final String source;
        @Column(displayName="Copybook name", description="The copybook name from a copy statement in a COBOL source.")
        private final String copybookName;
        @Column(displayName="Copybook source path", description="The source path of the copybook that was resolved during resolution of copybooks.")
        private final String copybookSourcePath;
        @Column(displayName="Resolution status", description="The status of the resolved copybook in a copy statement.")
        private final ResolutionStatus resolutionStatus;
        @Column(displayName="Marked word", description="The current word being visited from the post-processed LST.")
        private final String markedWord;

        public Row(String source, String copybookName, String copybookSourcePath, ResolutionStatus resolutionStatus, String markedWord) {
            this.source = source;
            this.copybookName = copybookName;
            this.copybookSourcePath = copybookSourcePath;
            this.resolutionStatus = resolutionStatus;
            this.markedWord = markedWord;
        }

        public String getSource() {
            return this.source;
        }

        public String getCopybookName() {
            return this.copybookName;
        }

        public String getCopybookSourcePath() {
            return this.copybookSourcePath;
        }

        public ResolutionStatus getResolutionStatus() {
            return this.resolutionStatus;
        }

        public String getMarkedWord() {
            return this.markedWord;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$copybookName = this.getCopybookName();
            String other$copybookName = other.getCopybookName();
            if (this$copybookName == null ? other$copybookName != null : !this$copybookName.equals(other$copybookName)) {
                return false;
            }
            String this$copybookSourcePath = this.getCopybookSourcePath();
            String other$copybookSourcePath = other.getCopybookSourcePath();
            if (this$copybookSourcePath == null ? other$copybookSourcePath != null : !this$copybookSourcePath.equals(other$copybookSourcePath)) {
                return false;
            }
            ResolutionStatus this$resolutionStatus = this.getResolutionStatus();
            ResolutionStatus other$resolutionStatus = other.getResolutionStatus();
            if (this$resolutionStatus == null ? other$resolutionStatus != null : !((Object)((Object)this$resolutionStatus)).equals((Object)other$resolutionStatus)) {
                return false;
            }
            String this$markedWord = this.getMarkedWord();
            String other$markedWord = other.getMarkedWord();
            return !(this$markedWord == null ? other$markedWord != null : !this$markedWord.equals(other$markedWord));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $copybookName = this.getCopybookName();
            result = result * 59 + ($copybookName == null ? 43 : $copybookName.hashCode());
            String $copybookSourcePath = this.getCopybookSourcePath();
            result = result * 59 + ($copybookSourcePath == null ? 43 : $copybookSourcePath.hashCode());
            ResolutionStatus $resolutionStatus = this.getResolutionStatus();
            result = result * 59 + ($resolutionStatus == null ? 43 : ((Object)((Object)$resolutionStatus)).hashCode());
            String $markedWord = this.getMarkedWord();
            result = result * 59 + ($markedWord == null ? 43 : $markedWord.hashCode());
            return result;
        }

        public String toString() {
            return "CopybookSource.Row(source=" + this.getSource() + ", copybookName=" + this.getCopybookName() + ", copybookSourcePath=" + this.getCopybookSourcePath() + ", resolutionStatus=" + (Object)((Object)this.getResolutionStatus()) + ", markedWord=" + this.getMarkedWord() + ")";
        }
    }
}

