/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.cobol.CobolVisitor;
import org.openrewrite.cobol.internal.CobolPrinter;
import org.openrewrite.cobol.tree.CobolLine;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.CobolSourceFile;
import org.openrewrite.cobol.tree.Comment;
import org.openrewrite.cobol.tree.CommentArea;
import org.openrewrite.cobol.tree.Continuation;
import org.openrewrite.cobol.tree.DataDivisionSection;
import org.openrewrite.cobol.tree.Identifier;
import org.openrewrite.cobol.tree.IndicatorArea;
import org.openrewrite.cobol.tree.Literal;
import org.openrewrite.cobol.tree.Name;
import org.openrewrite.cobol.tree.Replacement;
import org.openrewrite.cobol.tree.SequenceArea;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.cobol.tree.Statement;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public interface Cobol
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptCobol((CobolVisitor)v.adapt(CobolVisitor.class), p);
    }

    @Nullable
    default public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
        return (Cobol)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(CobolVisitor.class);
    }

    public Space getPrefix();

    public <P extends Cobol> P withPrefix(Space var1);

    default public UUID getId() {
        return CompilationUnit.id;
    }

    default public <T extends Tree> T withId(UUID id) {
        return (T)this;
    }

    public static final class CompilationUnit
    implements Cobol,
    CobolSourceFile {
        public static final UUID id = Tree.randomId();
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<ProgramUnit> programUnits;
        private final Word eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new CobolPrinter(true, true);
        }

        public CompilationUnit(Path sourcePath, FileAttributes fileAttributes, Space prefix, Markers markers, String charsetName, boolean charsetBomMarked, Checksum checksum, List<ProgramUnit> programUnits, Word eof) {
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.programUnits = programUnits;
            this.eof = eof;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public List<ProgramUnit> getProgramUnits() {
            return this.programUnits;
        }

        public Word getEof() {
            return this.eof;
        }

        public String toString() {
            return "Cobol.CompilationUnit(sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", programUnits=" + this.getProgramUnits() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            FileAttributes this$fileAttributes = this.getFileAttributes();
            FileAttributes other$fileAttributes = other.getFileAttributes();
            if (this$fileAttributes == null ? other$fileAttributes != null : !this$fileAttributes.equals(other$fileAttributes)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            String this$charsetName = this.getCharsetName();
            String other$charsetName = other.getCharsetName();
            if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
                return false;
            }
            Checksum this$checksum = this.getChecksum();
            Checksum other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
                return false;
            }
            List<ProgramUnit> this$programUnits = this.getProgramUnits();
            List<ProgramUnit> other$programUnits = other.getProgramUnits();
            if (this$programUnits == null ? other$programUnits != null : !((Object)this$programUnits).equals(other$programUnits)) {
                return false;
            }
            Word this$eof = this.getEof();
            Word other$eof = other.getEof();
            return !(this$eof == null ? other$eof != null : !((Object)this$eof).equals(other$eof));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            FileAttributes $fileAttributes = this.getFileAttributes();
            result = result * 59 + ($fileAttributes == null ? 43 : $fileAttributes.hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            String $charsetName = this.getCharsetName();
            result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
            Checksum $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            List<ProgramUnit> $programUnits = this.getProgramUnits();
            result = result * 59 + ($programUnits == null ? 43 : ((Object)$programUnits).hashCode());
            Word $eof = this.getEof();
            result = result * 59 + ($eof == null ? 43 : ((Object)$eof).hashCode());
            return result;
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.programUnits, this.eof);
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.programUnits, this.eof);
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.programUnits, this.eof);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.programUnits, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.programUnits, this.eof);
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.programUnits, this.eof);
        }

        public CompilationUnit withProgramUnits(List<ProgramUnit> programUnits) {
            return this.programUnits == programUnits ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, programUnits, this.eof);
        }

        public CompilationUnit withEof(Word eof) {
            return this.eof == eof ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.programUnits, eof);
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.programUnits, this.eof);
        }
    }

    public static final class WriteFromPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word from;
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWriteFromPhrase(this, p);
        }

        public WriteFromPhrase(Space prefix, Markers markers, Word from, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getFrom() {
            return this.from;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.WriteFromPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", from=" + this.getFrom() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteFromPhrase)) {
                return false;
            }
            WriteFromPhrase other = (WriteFromPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public WriteFromPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WriteFromPhrase(prefix, this.markers, this.from, this.name);
        }

        public WriteFromPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new WriteFromPhrase(this.prefix, markers, this.from, this.name);
        }

        public WriteFromPhrase withFrom(Word from) {
            return this.from == from ? this : new WriteFromPhrase(this.prefix, this.markers, from, this.name);
        }

        public WriteFromPhrase withName(Name name) {
            return this.name == name ? this : new WriteFromPhrase(this.prefix, this.markers, this.from, name);
        }
    }

    public static final class WriteAdvancingPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Cobol writeBy;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWriteAdvancingPhrase(this, p);
        }

        public WriteAdvancingPhrase(Space prefix, Markers markers, List<Word> words, Cobol writeBy) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.writeBy = writeBy;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getWriteBy() {
            return this.writeBy;
        }

        public String toString() {
            return "Cobol.WriteAdvancingPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", writeBy=" + this.getWriteBy() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteAdvancingPhrase)) {
                return false;
            }
            WriteAdvancingPhrase other = (WriteAdvancingPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$writeBy = this.getWriteBy();
            Cobol other$writeBy = other.getWriteBy();
            return !(this$writeBy == null ? other$writeBy != null : !this$writeBy.equals(other$writeBy));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $writeBy = this.getWriteBy();
            result = result * 59 + ($writeBy == null ? 43 : $writeBy.hashCode());
            return result;
        }

        public WriteAdvancingPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WriteAdvancingPhrase(prefix, this.markers, this.words, this.writeBy);
        }

        public WriteAdvancingPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new WriteAdvancingPhrase(this.prefix, markers, this.words, this.writeBy);
        }

        public WriteAdvancingPhrase withWords(List<Word> words) {
            return this.words == words ? this : new WriteAdvancingPhrase(this.prefix, this.markers, words, this.writeBy);
        }

        public WriteAdvancingPhrase withWriteBy(Cobol writeBy) {
            return this.writeBy == writeBy ? this : new WriteAdvancingPhrase(this.prefix, this.markers, this.words, writeBy);
        }
    }

    public static final class WriteAdvancingPage
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word page;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWriteAdvancingPage(this, p);
        }

        public WriteAdvancingPage(Space prefix, Markers markers, Word page) {
            this.prefix = prefix;
            this.markers = markers;
            this.page = page;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getPage() {
            return this.page;
        }

        public String toString() {
            return "Cobol.WriteAdvancingPage(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", page=" + this.getPage() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteAdvancingPage)) {
                return false;
            }
            WriteAdvancingPage other = (WriteAdvancingPage)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$page = this.getPage();
            Word other$page = other.getPage();
            return !(this$page == null ? other$page != null : !((Object)this$page).equals(other$page));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $page = this.getPage();
            result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
            return result;
        }

        public WriteAdvancingPage withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WriteAdvancingPage(prefix, this.markers, this.page);
        }

        public WriteAdvancingPage withMarkers(Markers markers) {
            return this.markers == markers ? this : new WriteAdvancingPage(this.prefix, markers, this.page);
        }

        public WriteAdvancingPage withPage(Word page) {
            return this.page == page ? this : new WriteAdvancingPage(this.prefix, this.markers, page);
        }
    }

    public static final class WriteAdvancingMnemonic
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWriteAdvancingMnemonic(this, p);
        }

        public WriteAdvancingMnemonic(Space prefix, Markers markers, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.WriteAdvancingMnemonic(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteAdvancingMnemonic)) {
                return false;
            }
            WriteAdvancingMnemonic other = (WriteAdvancingMnemonic)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public WriteAdvancingMnemonic withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WriteAdvancingMnemonic(prefix, this.markers, this.name);
        }

        public WriteAdvancingMnemonic withMarkers(Markers markers) {
            return this.markers == markers ? this : new WriteAdvancingMnemonic(this.prefix, markers, this.name);
        }

        public WriteAdvancingMnemonic withName(Name name) {
            return this.name == name ? this : new WriteAdvancingMnemonic(this.prefix, this.markers, name);
        }
    }

    public static final class WriteAdvancingLines
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final Word word;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWriteAdvancingLines(this, p);
        }

        public WriteAdvancingLines(Space prefix, Markers markers, Name name, Word word) {
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.word = word;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Cobol.WriteAdvancingLines(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteAdvancingLines)) {
                return false;
            }
            WriteAdvancingLines other = (WriteAdvancingLines)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            return !(this$word == null ? other$word != null : !((Object)this$word).equals(other$word));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            return result;
        }

        public WriteAdvancingLines withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WriteAdvancingLines(prefix, this.markers, this.name, this.word);
        }

        public WriteAdvancingLines withMarkers(Markers markers) {
            return this.markers == markers ? this : new WriteAdvancingLines(this.prefix, markers, this.name, this.word);
        }

        public WriteAdvancingLines withName(Name name) {
            return this.name == name ? this : new WriteAdvancingLines(this.prefix, this.markers, name, this.word);
        }

        public WriteAdvancingLines withWord(Word word) {
            return this.word == word ? this : new WriteAdvancingLines(this.prefix, this.markers, this.name, word);
        }
    }

    public static final class Write
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word write;
        private final QualifiedDataName recordName;
        @Nullable
        private final WriteFromPhrase writeFromPhrase;
        @Nullable
        private final WriteAdvancingPhrase writeAdvancingPhrase;
        @Nullable
        private final StatementPhrase writeAtEndOfPagePhrase;
        @Nullable
        private final StatementPhrase writeNotAtEndOfPagePhrase;
        @Nullable
        private final StatementPhrase invalidKeyPhrase;
        @Nullable
        private final StatementPhrase notInvalidKeyPhrase;
        @Nullable
        private final Word endWrite;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWrite(this, p);
        }

        public Write(Space prefix, Markers markers, Word write, QualifiedDataName recordName, WriteFromPhrase writeFromPhrase, WriteAdvancingPhrase writeAdvancingPhrase, StatementPhrase writeAtEndOfPagePhrase, StatementPhrase writeNotAtEndOfPagePhrase, StatementPhrase invalidKeyPhrase, StatementPhrase notInvalidKeyPhrase, Word endWrite) {
            this.prefix = prefix;
            this.markers = markers;
            this.write = write;
            this.recordName = recordName;
            this.writeFromPhrase = writeFromPhrase;
            this.writeAdvancingPhrase = writeAdvancingPhrase;
            this.writeAtEndOfPagePhrase = writeAtEndOfPagePhrase;
            this.writeNotAtEndOfPagePhrase = writeNotAtEndOfPagePhrase;
            this.invalidKeyPhrase = invalidKeyPhrase;
            this.notInvalidKeyPhrase = notInvalidKeyPhrase;
            this.endWrite = endWrite;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWrite() {
            return this.write;
        }

        public QualifiedDataName getRecordName() {
            return this.recordName;
        }

        public WriteFromPhrase getWriteFromPhrase() {
            return this.writeFromPhrase;
        }

        public WriteAdvancingPhrase getWriteAdvancingPhrase() {
            return this.writeAdvancingPhrase;
        }

        public StatementPhrase getWriteAtEndOfPagePhrase() {
            return this.writeAtEndOfPagePhrase;
        }

        public StatementPhrase getWriteNotAtEndOfPagePhrase() {
            return this.writeNotAtEndOfPagePhrase;
        }

        public StatementPhrase getInvalidKeyPhrase() {
            return this.invalidKeyPhrase;
        }

        public StatementPhrase getNotInvalidKeyPhrase() {
            return this.notInvalidKeyPhrase;
        }

        public Word getEndWrite() {
            return this.endWrite;
        }

        public String toString() {
            return "Cobol.Write(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", write=" + this.getWrite() + ", recordName=" + this.getRecordName() + ", writeFromPhrase=" + this.getWriteFromPhrase() + ", writeAdvancingPhrase=" + this.getWriteAdvancingPhrase() + ", writeAtEndOfPagePhrase=" + this.getWriteAtEndOfPagePhrase() + ", writeNotAtEndOfPagePhrase=" + this.getWriteNotAtEndOfPagePhrase() + ", invalidKeyPhrase=" + this.getInvalidKeyPhrase() + ", notInvalidKeyPhrase=" + this.getNotInvalidKeyPhrase() + ", endWrite=" + this.getEndWrite() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Write)) {
                return false;
            }
            Write other = (Write)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$write = this.getWrite();
            Word other$write = other.getWrite();
            if (this$write == null ? other$write != null : !((Object)this$write).equals(other$write)) {
                return false;
            }
            QualifiedDataName this$recordName = this.getRecordName();
            QualifiedDataName other$recordName = other.getRecordName();
            if (this$recordName == null ? other$recordName != null : !((Object)this$recordName).equals(other$recordName)) {
                return false;
            }
            WriteFromPhrase this$writeFromPhrase = this.getWriteFromPhrase();
            WriteFromPhrase other$writeFromPhrase = other.getWriteFromPhrase();
            if (this$writeFromPhrase == null ? other$writeFromPhrase != null : !((Object)this$writeFromPhrase).equals(other$writeFromPhrase)) {
                return false;
            }
            WriteAdvancingPhrase this$writeAdvancingPhrase = this.getWriteAdvancingPhrase();
            WriteAdvancingPhrase other$writeAdvancingPhrase = other.getWriteAdvancingPhrase();
            if (this$writeAdvancingPhrase == null ? other$writeAdvancingPhrase != null : !((Object)this$writeAdvancingPhrase).equals(other$writeAdvancingPhrase)) {
                return false;
            }
            StatementPhrase this$writeAtEndOfPagePhrase = this.getWriteAtEndOfPagePhrase();
            StatementPhrase other$writeAtEndOfPagePhrase = other.getWriteAtEndOfPagePhrase();
            if (this$writeAtEndOfPagePhrase == null ? other$writeAtEndOfPagePhrase != null : !((Object)this$writeAtEndOfPagePhrase).equals(other$writeAtEndOfPagePhrase)) {
                return false;
            }
            StatementPhrase this$writeNotAtEndOfPagePhrase = this.getWriteNotAtEndOfPagePhrase();
            StatementPhrase other$writeNotAtEndOfPagePhrase = other.getWriteNotAtEndOfPagePhrase();
            if (this$writeNotAtEndOfPagePhrase == null ? other$writeNotAtEndOfPagePhrase != null : !((Object)this$writeNotAtEndOfPagePhrase).equals(other$writeNotAtEndOfPagePhrase)) {
                return false;
            }
            StatementPhrase this$invalidKeyPhrase = this.getInvalidKeyPhrase();
            StatementPhrase other$invalidKeyPhrase = other.getInvalidKeyPhrase();
            if (this$invalidKeyPhrase == null ? other$invalidKeyPhrase != null : !((Object)this$invalidKeyPhrase).equals(other$invalidKeyPhrase)) {
                return false;
            }
            StatementPhrase this$notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            StatementPhrase other$notInvalidKeyPhrase = other.getNotInvalidKeyPhrase();
            if (this$notInvalidKeyPhrase == null ? other$notInvalidKeyPhrase != null : !((Object)this$notInvalidKeyPhrase).equals(other$notInvalidKeyPhrase)) {
                return false;
            }
            Word this$endWrite = this.getEndWrite();
            Word other$endWrite = other.getEndWrite();
            return !(this$endWrite == null ? other$endWrite != null : !((Object)this$endWrite).equals(other$endWrite));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $write = this.getWrite();
            result = result * 59 + ($write == null ? 43 : ((Object)$write).hashCode());
            QualifiedDataName $recordName = this.getRecordName();
            result = result * 59 + ($recordName == null ? 43 : ((Object)$recordName).hashCode());
            WriteFromPhrase $writeFromPhrase = this.getWriteFromPhrase();
            result = result * 59 + ($writeFromPhrase == null ? 43 : ((Object)$writeFromPhrase).hashCode());
            WriteAdvancingPhrase $writeAdvancingPhrase = this.getWriteAdvancingPhrase();
            result = result * 59 + ($writeAdvancingPhrase == null ? 43 : ((Object)$writeAdvancingPhrase).hashCode());
            StatementPhrase $writeAtEndOfPagePhrase = this.getWriteAtEndOfPagePhrase();
            result = result * 59 + ($writeAtEndOfPagePhrase == null ? 43 : ((Object)$writeAtEndOfPagePhrase).hashCode());
            StatementPhrase $writeNotAtEndOfPagePhrase = this.getWriteNotAtEndOfPagePhrase();
            result = result * 59 + ($writeNotAtEndOfPagePhrase == null ? 43 : ((Object)$writeNotAtEndOfPagePhrase).hashCode());
            StatementPhrase $invalidKeyPhrase = this.getInvalidKeyPhrase();
            result = result * 59 + ($invalidKeyPhrase == null ? 43 : ((Object)$invalidKeyPhrase).hashCode());
            StatementPhrase $notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            result = result * 59 + ($notInvalidKeyPhrase == null ? 43 : ((Object)$notInvalidKeyPhrase).hashCode());
            Word $endWrite = this.getEndWrite();
            result = result * 59 + ($endWrite == null ? 43 : ((Object)$endWrite).hashCode());
            return result;
        }

        public Write withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Write(prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withMarkers(Markers markers) {
            return this.markers == markers ? this : new Write(this.prefix, markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withWrite(Word write) {
            return this.write == write ? this : new Write(this.prefix, this.markers, write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withRecordName(QualifiedDataName recordName) {
            return this.recordName == recordName ? this : new Write(this.prefix, this.markers, this.write, recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withWriteFromPhrase(WriteFromPhrase writeFromPhrase) {
            return this.writeFromPhrase == writeFromPhrase ? this : new Write(this.prefix, this.markers, this.write, this.recordName, writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withWriteAdvancingPhrase(WriteAdvancingPhrase writeAdvancingPhrase) {
            return this.writeAdvancingPhrase == writeAdvancingPhrase ? this : new Write(this.prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withWriteAtEndOfPagePhrase(StatementPhrase writeAtEndOfPagePhrase) {
            return this.writeAtEndOfPagePhrase == writeAtEndOfPagePhrase ? this : new Write(this.prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withWriteNotAtEndOfPagePhrase(StatementPhrase writeNotAtEndOfPagePhrase) {
            return this.writeNotAtEndOfPagePhrase == writeNotAtEndOfPagePhrase ? this : new Write(this.prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withInvalidKeyPhrase(StatementPhrase invalidKeyPhrase) {
            return this.invalidKeyPhrase == invalidKeyPhrase ? this : new Write(this.prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, invalidKeyPhrase, this.notInvalidKeyPhrase, this.endWrite);
        }

        public Write withNotInvalidKeyPhrase(StatementPhrase notInvalidKeyPhrase) {
            return this.notInvalidKeyPhrase == notInvalidKeyPhrase ? this : new Write(this.prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, notInvalidKeyPhrase, this.endWrite);
        }

        public Write withEndWrite(Word endWrite) {
            return this.endWrite == endWrite ? this : new Write(this.prefix, this.markers, this.write, this.recordName, this.writeFromPhrase, this.writeAdvancingPhrase, this.writeAtEndOfPagePhrase, this.writeNotAtEndOfPagePhrase, this.invalidKeyPhrase, this.notInvalidKeyPhrase, endWrite);
        }
    }

    public static final class WorkingStorageSection
    implements DataDivisionSection {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dot;
        private final List<DataDescriptionEntry> dataDescriptions;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitWorkingStorageSection(this, p);
        }

        public WorkingStorageSection(Space prefix, Markers markers, List<Word> words, Word dot, List<DataDescriptionEntry> dataDescriptions) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dot = dot;
            this.dataDescriptions = dataDescriptions;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDot() {
            return this.dot;
        }

        public List<DataDescriptionEntry> getDataDescriptions() {
            return this.dataDescriptions;
        }

        public String toString() {
            return "Cobol.WorkingStorageSection(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dot=" + this.getDot() + ", dataDescriptions=" + this.getDataDescriptions() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkingStorageSection)) {
                return false;
            }
            WorkingStorageSection other = (WorkingStorageSection)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            List<DataDescriptionEntry> this$dataDescriptions = this.getDataDescriptions();
            List<DataDescriptionEntry> other$dataDescriptions = other.getDataDescriptions();
            return !(this$dataDescriptions == null ? other$dataDescriptions != null : !((Object)this$dataDescriptions).equals(other$dataDescriptions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            List<DataDescriptionEntry> $dataDescriptions = this.getDataDescriptions();
            result = result * 59 + ($dataDescriptions == null ? 43 : ((Object)$dataDescriptions).hashCode());
            return result;
        }

        public WorkingStorageSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WorkingStorageSection(prefix, this.markers, this.words, this.dot, this.dataDescriptions);
        }

        public WorkingStorageSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new WorkingStorageSection(this.prefix, markers, this.words, this.dot, this.dataDescriptions);
        }

        public WorkingStorageSection withWords(List<Word> words) {
            return this.words == words ? this : new WorkingStorageSection(this.prefix, this.markers, words, this.dot, this.dataDescriptions);
        }

        public WorkingStorageSection withDot(Word dot) {
            return this.dot == dot ? this : new WorkingStorageSection(this.prefix, this.markers, this.words, dot, this.dataDescriptions);
        }

        public WorkingStorageSection withDataDescriptions(List<DataDescriptionEntry> dataDescriptions) {
            return this.dataDescriptions == dataDescriptions ? this : new WorkingStorageSection(this.prefix, this.markers, this.words, this.dot, dataDescriptions);
        }
    }

    public static final class ValuePair
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word systemName;
        @Nullable
        private final Word is;
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitValuePair(this, p);
        }

        public ValuePair(Space prefix, Markers markers, Word systemName, Word is, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.systemName = systemName;
            this.is = is;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getSystemName() {
            return this.systemName;
        }

        public Word getIs() {
            return this.is;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.ValuePair(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", systemName=" + this.getSystemName() + ", is=" + this.getIs() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValuePair)) {
                return false;
            }
            ValuePair other = (ValuePair)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$systemName = this.getSystemName();
            Word other$systemName = other.getSystemName();
            if (this$systemName == null ? other$systemName != null : !((Object)this$systemName).equals(other$systemName)) {
                return false;
            }
            Word this$is = this.getIs();
            Word other$is = other.getIs();
            if (this$is == null ? other$is != null : !((Object)this$is).equals(other$is)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $systemName = this.getSystemName();
            result = result * 59 + ($systemName == null ? 43 : ((Object)$systemName).hashCode());
            Word $is = this.getIs();
            result = result * 59 + ($is == null ? 43 : ((Object)$is).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public ValuePair withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ValuePair(prefix, this.markers, this.systemName, this.is, this.name);
        }

        public ValuePair withMarkers(Markers markers) {
            return this.markers == markers ? this : new ValuePair(this.prefix, markers, this.systemName, this.is, this.name);
        }

        public ValuePair withSystemName(Word systemName) {
            return this.systemName == systemName ? this : new ValuePair(this.prefix, this.markers, systemName, this.is, this.name);
        }

        public ValuePair withIs(Word is) {
            return this.is == is ? this : new ValuePair(this.prefix, this.markers, this.systemName, is, this.name);
        }

        public ValuePair withName(Name name) {
            return this.name == name ? this : new ValuePair(this.prefix, this.markers, this.systemName, this.is, name);
        }
    }

    public static final class ValueOfClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> valueOf;
        private final List<ValuePair> valuePairs;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitValueOfClause(this, p);
        }

        public ValueOfClause(Space prefix, Markers markers, List<Word> valueOf, List<ValuePair> valuePairs) {
            this.prefix = prefix;
            this.markers = markers;
            this.valueOf = valueOf;
            this.valuePairs = valuePairs;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getValueOf() {
            return this.valueOf;
        }

        public List<ValuePair> getValuePairs() {
            return this.valuePairs;
        }

        public String toString() {
            return "Cobol.ValueOfClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", valueOf=" + this.getValueOf() + ", valuePairs=" + this.getValuePairs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueOfClause)) {
                return false;
            }
            ValueOfClause other = (ValueOfClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$valueOf = this.getValueOf();
            List<Word> other$valueOf = other.getValueOf();
            if (this$valueOf == null ? other$valueOf != null : !((Object)this$valueOf).equals(other$valueOf)) {
                return false;
            }
            List<ValuePair> this$valuePairs = this.getValuePairs();
            List<ValuePair> other$valuePairs = other.getValuePairs();
            return !(this$valuePairs == null ? other$valuePairs != null : !((Object)this$valuePairs).equals(other$valuePairs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $valueOf = this.getValueOf();
            result = result * 59 + ($valueOf == null ? 43 : ((Object)$valueOf).hashCode());
            List<ValuePair> $valuePairs = this.getValuePairs();
            result = result * 59 + ($valuePairs == null ? 43 : ((Object)$valuePairs).hashCode());
            return result;
        }

        public ValueOfClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ValueOfClause(prefix, this.markers, this.valueOf, this.valuePairs);
        }

        public ValueOfClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ValueOfClause(this.prefix, markers, this.valueOf, this.valuePairs);
        }

        public ValueOfClause withValueOf(List<Word> valueOf) {
            return this.valueOf == valueOf ? this : new ValueOfClause(this.prefix, this.markers, valueOf, this.valuePairs);
        }

        public ValueOfClause withValuePairs(List<ValuePair> valuePairs) {
            return this.valuePairs == valuePairs ? this : new ValueOfClause(this.prefix, this.markers, this.valueOf, valuePairs);
        }
    }

    public static final class ValuedObjectComputerClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Type type;
        private final List<Word> words;
        @Nullable
        private final Cobol value;
        @Nullable
        private final Word units;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitValuedObjectComputerClause(this, p);
        }

        public ValuedObjectComputerClause(Space prefix, Markers markers, Type type, List<Word> words, Cobol value, Word units) {
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.words = words;
            this.value = value;
            this.units = units;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getType() {
            return this.type;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getValue() {
            return this.value;
        }

        public Word getUnits() {
            return this.units;
        }

        public String toString() {
            return "Cobol.ValuedObjectComputerClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", type=" + (Object)((Object)this.getType()) + ", words=" + this.getWords() + ", value=" + this.getValue() + ", units=" + this.getUnits() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValuedObjectComputerClause)) {
                return false;
            }
            ValuedObjectComputerClause other = (ValuedObjectComputerClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$value = this.getValue();
            Cobol other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Word this$units = this.getUnits();
            Word other$units = other.getUnits();
            return !(this$units == null ? other$units != null : !((Object)this$units).equals(other$units));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Word $units = this.getUnits();
            result = result * 59 + ($units == null ? 43 : ((Object)$units).hashCode());
            return result;
        }

        public ValuedObjectComputerClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ValuedObjectComputerClause(prefix, this.markers, this.type, this.words, this.value, this.units);
        }

        public ValuedObjectComputerClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ValuedObjectComputerClause(this.prefix, markers, this.type, this.words, this.value, this.units);
        }

        public ValuedObjectComputerClause withType(Type type) {
            return this.type == type ? this : new ValuedObjectComputerClause(this.prefix, this.markers, type, this.words, this.value, this.units);
        }

        public ValuedObjectComputerClause withWords(List<Word> words) {
            return this.words == words ? this : new ValuedObjectComputerClause(this.prefix, this.markers, this.type, words, this.value, this.units);
        }

        public ValuedObjectComputerClause withValue(Cobol value) {
            return this.value == value ? this : new ValuedObjectComputerClause(this.prefix, this.markers, this.type, this.words, value, this.units);
        }

        public ValuedObjectComputerClause withUnits(Word units) {
            return this.units == units ? this : new ValuedObjectComputerClause(this.prefix, this.markers, this.type, this.words, this.value, units);
        }

        public static enum Type {
            Memory,
            Disk,
            SegmentLimit,
            CharacterSet;

        }
    }

    public static final class UseStatement
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word use;
        private final Cobol clause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUseStatement(this, p);
        }

        public UseStatement(Space prefix, Markers markers, Word use, Cobol clause) {
            this.prefix = prefix;
            this.markers = markers;
            this.use = use;
            this.clause = clause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getUse() {
            return this.use;
        }

        public Cobol getClause() {
            return this.clause;
        }

        public String toString() {
            return "Cobol.UseStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", use=" + this.getUse() + ", clause=" + this.getClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UseStatement)) {
                return false;
            }
            UseStatement other = (UseStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$use = this.getUse();
            Word other$use = other.getUse();
            if (this$use == null ? other$use != null : !((Object)this$use).equals(other$use)) {
                return false;
            }
            Cobol this$clause = this.getClause();
            Cobol other$clause = other.getClause();
            return !(this$clause == null ? other$clause != null : !this$clause.equals(other$clause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $use = this.getUse();
            result = result * 59 + ($use == null ? 43 : ((Object)$use).hashCode());
            Cobol $clause = this.getClause();
            result = result * 59 + ($clause == null ? 43 : $clause.hashCode());
            return result;
        }

        public UseStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UseStatement(prefix, this.markers, this.use, this.clause);
        }

        public UseStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new UseStatement(this.prefix, markers, this.use, this.clause);
        }

        public UseStatement withUse(Word use) {
            return this.use == use ? this : new UseStatement(this.prefix, this.markers, use, this.clause);
        }

        public UseStatement withClause(Cobol clause) {
            return this.clause == clause ? this : new UseStatement(this.prefix, this.markers, this.use, clause);
        }
    }

    public static final class UseDebugOn
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final List<Word> words;
        @Nullable
        private final Cobol name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUseDebugOn(this, p);
        }

        public UseDebugOn(Space prefix, Markers markers, List<Word> words, Cobol name) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.UseDebugOn(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UseDebugOn)) {
                return false;
            }
            UseDebugOn other = (UseDebugOn)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$name = this.getName();
            Cobol other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public UseDebugOn withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UseDebugOn(prefix, this.markers, this.words, this.name);
        }

        public UseDebugOn withMarkers(Markers markers) {
            return this.markers == markers ? this : new UseDebugOn(this.prefix, markers, this.words, this.name);
        }

        public UseDebugOn withWords(List<Word> words) {
            return this.words == words ? this : new UseDebugOn(this.prefix, this.markers, words, this.name);
        }

        public UseDebugOn withName(Cobol name) {
            return this.name == name ? this : new UseDebugOn(this.prefix, this.markers, this.words, name);
        }
    }

    public static final class UseDebugClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<UseDebugOn> useDebugs;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUseDebugClause(this, p);
        }

        public UseDebugClause(Space prefix, Markers markers, List<Word> words, List<UseDebugOn> useDebugs) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.useDebugs = useDebugs;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<UseDebugOn> getUseDebugs() {
            return this.useDebugs;
        }

        public String toString() {
            return "Cobol.UseDebugClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", useDebugs=" + this.getUseDebugs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UseDebugClause)) {
                return false;
            }
            UseDebugClause other = (UseDebugClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<UseDebugOn> this$useDebugs = this.getUseDebugs();
            List<UseDebugOn> other$useDebugs = other.getUseDebugs();
            return !(this$useDebugs == null ? other$useDebugs != null : !((Object)this$useDebugs).equals(other$useDebugs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<UseDebugOn> $useDebugs = this.getUseDebugs();
            result = result * 59 + ($useDebugs == null ? 43 : ((Object)$useDebugs).hashCode());
            return result;
        }

        public UseDebugClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UseDebugClause(prefix, this.markers, this.words, this.useDebugs);
        }

        public UseDebugClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new UseDebugClause(this.prefix, markers, this.words, this.useDebugs);
        }

        public UseDebugClause withWords(List<Word> words) {
            return this.words == words ? this : new UseDebugClause(this.prefix, this.markers, words, this.useDebugs);
        }

        public UseDebugClause withUseDebugs(List<UseDebugOn> useDebugs) {
            return this.useDebugs == useDebugs ? this : new UseDebugClause(this.prefix, this.markers, this.words, useDebugs);
        }
    }

    public static final class UseAfterOn
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final List<Word> afterOn;
        @Nullable
        private final List<Name> fileNames;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUseAfterOn(this, p);
        }

        public UseAfterOn(Space prefix, Markers markers, List<Word> afterOn, List<Name> fileNames) {
            this.prefix = prefix;
            this.markers = markers;
            this.afterOn = afterOn;
            this.fileNames = fileNames;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getAfterOn() {
            return this.afterOn;
        }

        public List<Name> getFileNames() {
            return this.fileNames;
        }

        public String toString() {
            return "Cobol.UseAfterOn(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", afterOn=" + this.getAfterOn() + ", fileNames=" + this.getFileNames() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UseAfterOn)) {
                return false;
            }
            UseAfterOn other = (UseAfterOn)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$afterOn = this.getAfterOn();
            List<Word> other$afterOn = other.getAfterOn();
            if (this$afterOn == null ? other$afterOn != null : !((Object)this$afterOn).equals(other$afterOn)) {
                return false;
            }
            List<Name> this$fileNames = this.getFileNames();
            List<Name> other$fileNames = other.getFileNames();
            return !(this$fileNames == null ? other$fileNames != null : !((Object)this$fileNames).equals(other$fileNames));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $afterOn = this.getAfterOn();
            result = result * 59 + ($afterOn == null ? 43 : ((Object)$afterOn).hashCode());
            List<Name> $fileNames = this.getFileNames();
            result = result * 59 + ($fileNames == null ? 43 : ((Object)$fileNames).hashCode());
            return result;
        }

        public UseAfterOn withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UseAfterOn(prefix, this.markers, this.afterOn, this.fileNames);
        }

        public UseAfterOn withMarkers(Markers markers) {
            return this.markers == markers ? this : new UseAfterOn(this.prefix, markers, this.afterOn, this.fileNames);
        }

        public UseAfterOn withAfterOn(List<Word> afterOn) {
            return this.afterOn == afterOn ? this : new UseAfterOn(this.prefix, this.markers, afterOn, this.fileNames);
        }

        public UseAfterOn withFileNames(List<Name> fileNames) {
            return this.fileNames == fileNames ? this : new UseAfterOn(this.prefix, this.markers, this.afterOn, fileNames);
        }
    }

    public static final class UseAfterClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final UseAfterOn useAfterOn;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUseAfterClause(this, p);
        }

        public UseAfterClause(Space prefix, Markers markers, List<Word> words, UseAfterOn useAfterOn) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.useAfterOn = useAfterOn;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public UseAfterOn getUseAfterOn() {
            return this.useAfterOn;
        }

        public String toString() {
            return "Cobol.UseAfterClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", useAfterOn=" + this.getUseAfterOn() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UseAfterClause)) {
                return false;
            }
            UseAfterClause other = (UseAfterClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            UseAfterOn this$useAfterOn = this.getUseAfterOn();
            UseAfterOn other$useAfterOn = other.getUseAfterOn();
            return !(this$useAfterOn == null ? other$useAfterOn != null : !((Object)this$useAfterOn).equals(other$useAfterOn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            UseAfterOn $useAfterOn = this.getUseAfterOn();
            result = result * 59 + ($useAfterOn == null ? 43 : ((Object)$useAfterOn).hashCode());
            return result;
        }

        public UseAfterClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UseAfterClause(prefix, this.markers, this.words, this.useAfterOn);
        }

        public UseAfterClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new UseAfterClause(this.prefix, markers, this.words, this.useAfterOn);
        }

        public UseAfterClause withWords(List<Word> words) {
            return this.words == words ? this : new UseAfterClause(this.prefix, this.markers, words, this.useAfterOn);
        }

        public UseAfterClause withUseAfterOn(UseAfterOn useAfterOn) {
            return this.useAfterOn == useAfterOn ? this : new UseAfterClause(this.prefix, this.markers, this.words, useAfterOn);
        }
    }

    public static final class UnstringWithPointerPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringWithPointerPhrase(this, p);
        }

        public UnstringWithPointerPhrase(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.UnstringWithPointerPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringWithPointerPhrase)) {
                return false;
            }
            UnstringWithPointerPhrase other = (UnstringWithPointerPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public UnstringWithPointerPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringWithPointerPhrase(prefix, this.markers, this.words, this.qualifiedDataName);
        }

        public UnstringWithPointerPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringWithPointerPhrase(this.prefix, markers, this.words, this.qualifiedDataName);
        }

        public UnstringWithPointerPhrase withWords(List<Word> words) {
            return this.words == words ? this : new UnstringWithPointerPhrase(this.prefix, this.markers, words, this.qualifiedDataName);
        }

        public UnstringWithPointerPhrase withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new UnstringWithPointerPhrase(this.prefix, this.markers, this.words, qualifiedDataName);
        }
    }

    public static final class UnstringTallyingPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringTallyingPhrase(this, p);
        }

        public UnstringTallyingPhrase(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.UnstringTallyingPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringTallyingPhrase)) {
                return false;
            }
            UnstringTallyingPhrase other = (UnstringTallyingPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public UnstringTallyingPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringTallyingPhrase(prefix, this.markers, this.words, this.qualifiedDataName);
        }

        public UnstringTallyingPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringTallyingPhrase(this.prefix, markers, this.words, this.qualifiedDataName);
        }

        public UnstringTallyingPhrase withWords(List<Word> words) {
            return this.words == words ? this : new UnstringTallyingPhrase(this.prefix, this.markers, words, this.qualifiedDataName);
        }

        public UnstringTallyingPhrase withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new UnstringTallyingPhrase(this.prefix, this.markers, this.words, qualifiedDataName);
        }
    }

    public static final class UnstringSendingPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Identifier identifier;
        @Nullable
        private final UnstringDelimitedByPhrase unstringDelimitedByPhrase;
        @Nullable
        private final List<UnstringOrAllPhrase> unstringOrAllPhrases;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringSendingPhrase(this, p);
        }

        public UnstringSendingPhrase(Space prefix, Markers markers, Identifier identifier, UnstringDelimitedByPhrase unstringDelimitedByPhrase, List<UnstringOrAllPhrase> unstringOrAllPhrases) {
            this.prefix = prefix;
            this.markers = markers;
            this.identifier = identifier;
            this.unstringDelimitedByPhrase = unstringDelimitedByPhrase;
            this.unstringOrAllPhrases = unstringOrAllPhrases;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public UnstringDelimitedByPhrase getUnstringDelimitedByPhrase() {
            return this.unstringDelimitedByPhrase;
        }

        public List<UnstringOrAllPhrase> getUnstringOrAllPhrases() {
            return this.unstringOrAllPhrases;
        }

        public String toString() {
            return "Cobol.UnstringSendingPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", identifier=" + this.getIdentifier() + ", unstringDelimitedByPhrase=" + this.getUnstringDelimitedByPhrase() + ", unstringOrAllPhrases=" + this.getUnstringOrAllPhrases() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringSendingPhrase)) {
                return false;
            }
            UnstringSendingPhrase other = (UnstringSendingPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            UnstringDelimitedByPhrase this$unstringDelimitedByPhrase = this.getUnstringDelimitedByPhrase();
            UnstringDelimitedByPhrase other$unstringDelimitedByPhrase = other.getUnstringDelimitedByPhrase();
            if (this$unstringDelimitedByPhrase == null ? other$unstringDelimitedByPhrase != null : !((Object)this$unstringDelimitedByPhrase).equals(other$unstringDelimitedByPhrase)) {
                return false;
            }
            List<UnstringOrAllPhrase> this$unstringOrAllPhrases = this.getUnstringOrAllPhrases();
            List<UnstringOrAllPhrase> other$unstringOrAllPhrases = other.getUnstringOrAllPhrases();
            return !(this$unstringOrAllPhrases == null ? other$unstringOrAllPhrases != null : !((Object)this$unstringOrAllPhrases).equals(other$unstringOrAllPhrases));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            UnstringDelimitedByPhrase $unstringDelimitedByPhrase = this.getUnstringDelimitedByPhrase();
            result = result * 59 + ($unstringDelimitedByPhrase == null ? 43 : ((Object)$unstringDelimitedByPhrase).hashCode());
            List<UnstringOrAllPhrase> $unstringOrAllPhrases = this.getUnstringOrAllPhrases();
            result = result * 59 + ($unstringOrAllPhrases == null ? 43 : ((Object)$unstringOrAllPhrases).hashCode());
            return result;
        }

        public UnstringSendingPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringSendingPhrase(prefix, this.markers, this.identifier, this.unstringDelimitedByPhrase, this.unstringOrAllPhrases);
        }

        public UnstringSendingPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringSendingPhrase(this.prefix, markers, this.identifier, this.unstringDelimitedByPhrase, this.unstringOrAllPhrases);
        }

        public UnstringSendingPhrase withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new UnstringSendingPhrase(this.prefix, this.markers, identifier, this.unstringDelimitedByPhrase, this.unstringOrAllPhrases);
        }

        public UnstringSendingPhrase withUnstringDelimitedByPhrase(UnstringDelimitedByPhrase unstringDelimitedByPhrase) {
            return this.unstringDelimitedByPhrase == unstringDelimitedByPhrase ? this : new UnstringSendingPhrase(this.prefix, this.markers, this.identifier, unstringDelimitedByPhrase, this.unstringOrAllPhrases);
        }

        public UnstringSendingPhrase withUnstringOrAllPhrases(List<UnstringOrAllPhrase> unstringOrAllPhrases) {
            return this.unstringOrAllPhrases == unstringOrAllPhrases ? this : new UnstringSendingPhrase(this.prefix, this.markers, this.identifier, this.unstringDelimitedByPhrase, unstringOrAllPhrases);
        }
    }

    public static final class UnstringOrAllPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringOrAllPhrase(this, p);
        }

        public UnstringOrAllPhrase(Space prefix, Markers markers, List<Word> words, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.UnstringOrAllPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringOrAllPhrase)) {
                return false;
            }
            UnstringOrAllPhrase other = (UnstringOrAllPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public UnstringOrAllPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringOrAllPhrase(prefix, this.markers, this.words, this.name);
        }

        public UnstringOrAllPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringOrAllPhrase(this.prefix, markers, this.words, this.name);
        }

        public UnstringOrAllPhrase withWords(List<Word> words) {
            return this.words == words ? this : new UnstringOrAllPhrase(this.prefix, this.markers, words, this.name);
        }

        public UnstringOrAllPhrase withName(Name name) {
            return this.name == name ? this : new UnstringOrAllPhrase(this.prefix, this.markers, this.words, name);
        }
    }

    public static final class UnstringIntoPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word into;
        private final List<UnstringInto> unstringIntos;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringIntoPhrase(this, p);
        }

        public UnstringIntoPhrase(Space prefix, Markers markers, Word into, List<UnstringInto> unstringIntos) {
            this.prefix = prefix;
            this.markers = markers;
            this.into = into;
            this.unstringIntos = unstringIntos;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getInto() {
            return this.into;
        }

        public List<UnstringInto> getUnstringIntos() {
            return this.unstringIntos;
        }

        public String toString() {
            return "Cobol.UnstringIntoPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", into=" + this.getInto() + ", unstringIntos=" + this.getUnstringIntos() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringIntoPhrase)) {
                return false;
            }
            UnstringIntoPhrase other = (UnstringIntoPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$into = this.getInto();
            Word other$into = other.getInto();
            if (this$into == null ? other$into != null : !((Object)this$into).equals(other$into)) {
                return false;
            }
            List<UnstringInto> this$unstringIntos = this.getUnstringIntos();
            List<UnstringInto> other$unstringIntos = other.getUnstringIntos();
            return !(this$unstringIntos == null ? other$unstringIntos != null : !((Object)this$unstringIntos).equals(other$unstringIntos));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $into = this.getInto();
            result = result * 59 + ($into == null ? 43 : ((Object)$into).hashCode());
            List<UnstringInto> $unstringIntos = this.getUnstringIntos();
            result = result * 59 + ($unstringIntos == null ? 43 : ((Object)$unstringIntos).hashCode());
            return result;
        }

        public UnstringIntoPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringIntoPhrase(prefix, this.markers, this.into, this.unstringIntos);
        }

        public UnstringIntoPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringIntoPhrase(this.prefix, markers, this.into, this.unstringIntos);
        }

        public UnstringIntoPhrase withInto(Word into) {
            return this.into == into ? this : new UnstringIntoPhrase(this.prefix, this.markers, into, this.unstringIntos);
        }

        public UnstringIntoPhrase withUnstringIntos(List<UnstringInto> unstringIntos) {
            return this.unstringIntos == unstringIntos ? this : new UnstringIntoPhrase(this.prefix, this.markers, this.into, unstringIntos);
        }
    }

    public static final class UnstringInto
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Identifier identifier;
        @Nullable
        private final UnstringDelimiterIn unstringDelimiterIn;
        @Nullable
        private final UnstringCountIn unstringCountIn;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringInto(this, p);
        }

        public UnstringInto(Space prefix, Markers markers, Identifier identifier, UnstringDelimiterIn unstringDelimiterIn, UnstringCountIn unstringCountIn) {
            this.prefix = prefix;
            this.markers = markers;
            this.identifier = identifier;
            this.unstringDelimiterIn = unstringDelimiterIn;
            this.unstringCountIn = unstringCountIn;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public UnstringDelimiterIn getUnstringDelimiterIn() {
            return this.unstringDelimiterIn;
        }

        public UnstringCountIn getUnstringCountIn() {
            return this.unstringCountIn;
        }

        public String toString() {
            return "Cobol.UnstringInto(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", identifier=" + this.getIdentifier() + ", unstringDelimiterIn=" + this.getUnstringDelimiterIn() + ", unstringCountIn=" + this.getUnstringCountIn() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringInto)) {
                return false;
            }
            UnstringInto other = (UnstringInto)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            UnstringDelimiterIn this$unstringDelimiterIn = this.getUnstringDelimiterIn();
            UnstringDelimiterIn other$unstringDelimiterIn = other.getUnstringDelimiterIn();
            if (this$unstringDelimiterIn == null ? other$unstringDelimiterIn != null : !((Object)this$unstringDelimiterIn).equals(other$unstringDelimiterIn)) {
                return false;
            }
            UnstringCountIn this$unstringCountIn = this.getUnstringCountIn();
            UnstringCountIn other$unstringCountIn = other.getUnstringCountIn();
            return !(this$unstringCountIn == null ? other$unstringCountIn != null : !((Object)this$unstringCountIn).equals(other$unstringCountIn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            UnstringDelimiterIn $unstringDelimiterIn = this.getUnstringDelimiterIn();
            result = result * 59 + ($unstringDelimiterIn == null ? 43 : ((Object)$unstringDelimiterIn).hashCode());
            UnstringCountIn $unstringCountIn = this.getUnstringCountIn();
            result = result * 59 + ($unstringCountIn == null ? 43 : ((Object)$unstringCountIn).hashCode());
            return result;
        }

        public UnstringInto withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringInto(prefix, this.markers, this.identifier, this.unstringDelimiterIn, this.unstringCountIn);
        }

        public UnstringInto withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringInto(this.prefix, markers, this.identifier, this.unstringDelimiterIn, this.unstringCountIn);
        }

        public UnstringInto withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new UnstringInto(this.prefix, this.markers, identifier, this.unstringDelimiterIn, this.unstringCountIn);
        }

        public UnstringInto withUnstringDelimiterIn(UnstringDelimiterIn unstringDelimiterIn) {
            return this.unstringDelimiterIn == unstringDelimiterIn ? this : new UnstringInto(this.prefix, this.markers, this.identifier, unstringDelimiterIn, this.unstringCountIn);
        }

        public UnstringInto withUnstringCountIn(UnstringCountIn unstringCountIn) {
            return this.unstringCountIn == unstringCountIn ? this : new UnstringInto(this.prefix, this.markers, this.identifier, this.unstringDelimiterIn, unstringCountIn);
        }
    }

    public static final class UnstringDelimiterIn
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Identifier identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringDelimiterIn(this, p);
        }

        public UnstringDelimiterIn(Space prefix, Markers markers, List<Word> words, Identifier identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.UnstringDelimiterIn(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringDelimiterIn)) {
                return false;
            }
            UnstringDelimiterIn other = (UnstringDelimiterIn)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public UnstringDelimiterIn withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringDelimiterIn(prefix, this.markers, this.words, this.identifier);
        }

        public UnstringDelimiterIn withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringDelimiterIn(this.prefix, markers, this.words, this.identifier);
        }

        public UnstringDelimiterIn withWords(List<Word> words) {
            return this.words == words ? this : new UnstringDelimiterIn(this.prefix, this.markers, words, this.identifier);
        }

        public UnstringDelimiterIn withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new UnstringDelimiterIn(this.prefix, this.markers, this.words, identifier);
        }
    }

    public static final class UnstringDelimitedByPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringDelimitedByPhrase(this, p);
        }

        public UnstringDelimitedByPhrase(Space prefix, Markers markers, List<Word> words, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.UnstringDelimitedByPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringDelimitedByPhrase)) {
                return false;
            }
            UnstringDelimitedByPhrase other = (UnstringDelimitedByPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public UnstringDelimitedByPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringDelimitedByPhrase(prefix, this.markers, this.words, this.name);
        }

        public UnstringDelimitedByPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringDelimitedByPhrase(this.prefix, markers, this.words, this.name);
        }

        public UnstringDelimitedByPhrase withWords(List<Word> words) {
            return this.words == words ? this : new UnstringDelimitedByPhrase(this.prefix, this.markers, words, this.name);
        }

        public UnstringDelimitedByPhrase withName(Name name) {
            return this.name == name ? this : new UnstringDelimitedByPhrase(this.prefix, this.markers, this.words, name);
        }
    }

    public static final class UnstringCountIn
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Identifier identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnstringCountIn(this, p);
        }

        public UnstringCountIn(Space prefix, Markers markers, List<Word> words, Identifier identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.UnstringCountIn(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnstringCountIn)) {
                return false;
            }
            UnstringCountIn other = (UnstringCountIn)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public UnstringCountIn withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnstringCountIn(prefix, this.markers, this.words, this.identifier);
        }

        public UnstringCountIn withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnstringCountIn(this.prefix, markers, this.words, this.identifier);
        }

        public UnstringCountIn withWords(List<Word> words) {
            return this.words == words ? this : new UnstringCountIn(this.prefix, this.markers, words, this.identifier);
        }

        public UnstringCountIn withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new UnstringCountIn(this.prefix, this.markers, this.words, identifier);
        }
    }

    public static final class UnString
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word unstring;
        private final UnstringSendingPhrase unstringSendingPhrase;
        private final UnstringIntoPhrase unstringIntoPhrase;
        @Nullable
        private final UnstringWithPointerPhrase unstringWithPointerPhrase;
        @Nullable
        private final UnstringTallyingPhrase unstringTallyingPhrase;
        @Nullable
        private final StatementPhrase onOverflowPhrase;
        @Nullable
        private final StatementPhrase notOnOverflowPhrase;
        @Nullable
        private final Word endUnstring;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitUnString(this, p);
        }

        public UnString(Space prefix, Markers markers, Word unstring, UnstringSendingPhrase unstringSendingPhrase, UnstringIntoPhrase unstringIntoPhrase, UnstringWithPointerPhrase unstringWithPointerPhrase, UnstringTallyingPhrase unstringTallyingPhrase, StatementPhrase onOverflowPhrase, StatementPhrase notOnOverflowPhrase, Word endUnstring) {
            this.prefix = prefix;
            this.markers = markers;
            this.unstring = unstring;
            this.unstringSendingPhrase = unstringSendingPhrase;
            this.unstringIntoPhrase = unstringIntoPhrase;
            this.unstringWithPointerPhrase = unstringWithPointerPhrase;
            this.unstringTallyingPhrase = unstringTallyingPhrase;
            this.onOverflowPhrase = onOverflowPhrase;
            this.notOnOverflowPhrase = notOnOverflowPhrase;
            this.endUnstring = endUnstring;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getUnstring() {
            return this.unstring;
        }

        public UnstringSendingPhrase getUnstringSendingPhrase() {
            return this.unstringSendingPhrase;
        }

        public UnstringIntoPhrase getUnstringIntoPhrase() {
            return this.unstringIntoPhrase;
        }

        public UnstringWithPointerPhrase getUnstringWithPointerPhrase() {
            return this.unstringWithPointerPhrase;
        }

        public UnstringTallyingPhrase getUnstringTallyingPhrase() {
            return this.unstringTallyingPhrase;
        }

        public StatementPhrase getOnOverflowPhrase() {
            return this.onOverflowPhrase;
        }

        public StatementPhrase getNotOnOverflowPhrase() {
            return this.notOnOverflowPhrase;
        }

        public Word getEndUnstring() {
            return this.endUnstring;
        }

        public String toString() {
            return "Cobol.UnString(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", unstring=" + this.getUnstring() + ", unstringSendingPhrase=" + this.getUnstringSendingPhrase() + ", unstringIntoPhrase=" + this.getUnstringIntoPhrase() + ", unstringWithPointerPhrase=" + this.getUnstringWithPointerPhrase() + ", unstringTallyingPhrase=" + this.getUnstringTallyingPhrase() + ", onOverflowPhrase=" + this.getOnOverflowPhrase() + ", notOnOverflowPhrase=" + this.getNotOnOverflowPhrase() + ", endUnstring=" + this.getEndUnstring() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnString)) {
                return false;
            }
            UnString other = (UnString)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$unstring = this.getUnstring();
            Word other$unstring = other.getUnstring();
            if (this$unstring == null ? other$unstring != null : !((Object)this$unstring).equals(other$unstring)) {
                return false;
            }
            UnstringSendingPhrase this$unstringSendingPhrase = this.getUnstringSendingPhrase();
            UnstringSendingPhrase other$unstringSendingPhrase = other.getUnstringSendingPhrase();
            if (this$unstringSendingPhrase == null ? other$unstringSendingPhrase != null : !((Object)this$unstringSendingPhrase).equals(other$unstringSendingPhrase)) {
                return false;
            }
            UnstringIntoPhrase this$unstringIntoPhrase = this.getUnstringIntoPhrase();
            UnstringIntoPhrase other$unstringIntoPhrase = other.getUnstringIntoPhrase();
            if (this$unstringIntoPhrase == null ? other$unstringIntoPhrase != null : !((Object)this$unstringIntoPhrase).equals(other$unstringIntoPhrase)) {
                return false;
            }
            UnstringWithPointerPhrase this$unstringWithPointerPhrase = this.getUnstringWithPointerPhrase();
            UnstringWithPointerPhrase other$unstringWithPointerPhrase = other.getUnstringWithPointerPhrase();
            if (this$unstringWithPointerPhrase == null ? other$unstringWithPointerPhrase != null : !((Object)this$unstringWithPointerPhrase).equals(other$unstringWithPointerPhrase)) {
                return false;
            }
            UnstringTallyingPhrase this$unstringTallyingPhrase = this.getUnstringTallyingPhrase();
            UnstringTallyingPhrase other$unstringTallyingPhrase = other.getUnstringTallyingPhrase();
            if (this$unstringTallyingPhrase == null ? other$unstringTallyingPhrase != null : !((Object)this$unstringTallyingPhrase).equals(other$unstringTallyingPhrase)) {
                return false;
            }
            StatementPhrase this$onOverflowPhrase = this.getOnOverflowPhrase();
            StatementPhrase other$onOverflowPhrase = other.getOnOverflowPhrase();
            if (this$onOverflowPhrase == null ? other$onOverflowPhrase != null : !((Object)this$onOverflowPhrase).equals(other$onOverflowPhrase)) {
                return false;
            }
            StatementPhrase this$notOnOverflowPhrase = this.getNotOnOverflowPhrase();
            StatementPhrase other$notOnOverflowPhrase = other.getNotOnOverflowPhrase();
            if (this$notOnOverflowPhrase == null ? other$notOnOverflowPhrase != null : !((Object)this$notOnOverflowPhrase).equals(other$notOnOverflowPhrase)) {
                return false;
            }
            Word this$endUnstring = this.getEndUnstring();
            Word other$endUnstring = other.getEndUnstring();
            return !(this$endUnstring == null ? other$endUnstring != null : !((Object)this$endUnstring).equals(other$endUnstring));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $unstring = this.getUnstring();
            result = result * 59 + ($unstring == null ? 43 : ((Object)$unstring).hashCode());
            UnstringSendingPhrase $unstringSendingPhrase = this.getUnstringSendingPhrase();
            result = result * 59 + ($unstringSendingPhrase == null ? 43 : ((Object)$unstringSendingPhrase).hashCode());
            UnstringIntoPhrase $unstringIntoPhrase = this.getUnstringIntoPhrase();
            result = result * 59 + ($unstringIntoPhrase == null ? 43 : ((Object)$unstringIntoPhrase).hashCode());
            UnstringWithPointerPhrase $unstringWithPointerPhrase = this.getUnstringWithPointerPhrase();
            result = result * 59 + ($unstringWithPointerPhrase == null ? 43 : ((Object)$unstringWithPointerPhrase).hashCode());
            UnstringTallyingPhrase $unstringTallyingPhrase = this.getUnstringTallyingPhrase();
            result = result * 59 + ($unstringTallyingPhrase == null ? 43 : ((Object)$unstringTallyingPhrase).hashCode());
            StatementPhrase $onOverflowPhrase = this.getOnOverflowPhrase();
            result = result * 59 + ($onOverflowPhrase == null ? 43 : ((Object)$onOverflowPhrase).hashCode());
            StatementPhrase $notOnOverflowPhrase = this.getNotOnOverflowPhrase();
            result = result * 59 + ($notOnOverflowPhrase == null ? 43 : ((Object)$notOnOverflowPhrase).hashCode());
            Word $endUnstring = this.getEndUnstring();
            result = result * 59 + ($endUnstring == null ? 43 : ((Object)$endUnstring).hashCode());
            return result;
        }

        public UnString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnString(prefix, this.markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnString(this.prefix, markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withUnstring(Word unstring) {
            return this.unstring == unstring ? this : new UnString(this.prefix, this.markers, unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withUnstringSendingPhrase(UnstringSendingPhrase unstringSendingPhrase) {
            return this.unstringSendingPhrase == unstringSendingPhrase ? this : new UnString(this.prefix, this.markers, this.unstring, unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withUnstringIntoPhrase(UnstringIntoPhrase unstringIntoPhrase) {
            return this.unstringIntoPhrase == unstringIntoPhrase ? this : new UnString(this.prefix, this.markers, this.unstring, this.unstringSendingPhrase, unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withUnstringWithPointerPhrase(UnstringWithPointerPhrase unstringWithPointerPhrase) {
            return this.unstringWithPointerPhrase == unstringWithPointerPhrase ? this : new UnString(this.prefix, this.markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withUnstringTallyingPhrase(UnstringTallyingPhrase unstringTallyingPhrase) {
            return this.unstringTallyingPhrase == unstringTallyingPhrase ? this : new UnString(this.prefix, this.markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withOnOverflowPhrase(StatementPhrase onOverflowPhrase) {
            return this.onOverflowPhrase == onOverflowPhrase ? this : new UnString(this.prefix, this.markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, onOverflowPhrase, this.notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withNotOnOverflowPhrase(StatementPhrase notOnOverflowPhrase) {
            return this.notOnOverflowPhrase == notOnOverflowPhrase ? this : new UnString(this.prefix, this.markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, notOnOverflowPhrase, this.endUnstring);
        }

        public UnString withEndUnstring(Word endUnstring) {
            return this.endUnstring == endUnstring ? this : new UnString(this.prefix, this.markers, this.unstring, this.unstringSendingPhrase, this.unstringIntoPhrase, this.unstringWithPointerPhrase, this.unstringTallyingPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, endUnstring);
        }
    }

    public static final class TextLengthClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dataDescName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitTextLengthClause(this, p);
        }

        public TextLengthClause(Space prefix, Markers markers, List<Word> words, Word dataDescName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataDescName = dataDescName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataDescName() {
            return this.dataDescName;
        }

        public String toString() {
            return "Cobol.TextLengthClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataDescName=" + this.getDataDescName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextLengthClause)) {
                return false;
            }
            TextLengthClause other = (TextLengthClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataDescName = this.getDataDescName();
            Word other$dataDescName = other.getDataDescName();
            return !(this$dataDescName == null ? other$dataDescName != null : !((Object)this$dataDescName).equals(other$dataDescName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataDescName = this.getDataDescName();
            result = result * 59 + ($dataDescName == null ? 43 : ((Object)$dataDescName).hashCode());
            return result;
        }

        public TextLengthClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TextLengthClause(prefix, this.markers, this.words, this.dataDescName);
        }

        public TextLengthClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new TextLengthClause(this.prefix, markers, this.words, this.dataDescName);
        }

        public TextLengthClause withWords(List<Word> words) {
            return this.words == words ? this : new TextLengthClause(this.prefix, this.markers, words, this.dataDescName);
        }

        public TextLengthClause withDataDescName(Word dataDescName) {
            return this.dataDescName == dataDescName ? this : new TextLengthClause(this.prefix, this.markers, this.words, dataDescName);
        }
    }

    public static final class Terminate
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word terminate;
        private final QualifiedDataName reportName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitTerminate(this, p);
        }

        public Terminate(Space prefix, Markers markers, Word terminate, QualifiedDataName reportName) {
            this.prefix = prefix;
            this.markers = markers;
            this.terminate = terminate;
            this.reportName = reportName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getTerminate() {
            return this.terminate;
        }

        public QualifiedDataName getReportName() {
            return this.reportName;
        }

        public String toString() {
            return "Cobol.Terminate(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", terminate=" + this.getTerminate() + ", reportName=" + this.getReportName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Terminate)) {
                return false;
            }
            Terminate other = (Terminate)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$terminate = this.getTerminate();
            Word other$terminate = other.getTerminate();
            if (this$terminate == null ? other$terminate != null : !((Object)this$terminate).equals(other$terminate)) {
                return false;
            }
            QualifiedDataName this$reportName = this.getReportName();
            QualifiedDataName other$reportName = other.getReportName();
            return !(this$reportName == null ? other$reportName != null : !((Object)this$reportName).equals(other$reportName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $terminate = this.getTerminate();
            result = result * 59 + ($terminate == null ? 43 : ((Object)$terminate).hashCode());
            QualifiedDataName $reportName = this.getReportName();
            result = result * 59 + ($reportName == null ? 43 : ((Object)$reportName).hashCode());
            return result;
        }

        public Terminate withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Terminate(prefix, this.markers, this.terminate, this.reportName);
        }

        public Terminate withMarkers(Markers markers) {
            return this.markers == markers ? this : new Terminate(this.prefix, markers, this.terminate, this.reportName);
        }

        public Terminate withTerminate(Word terminate) {
            return this.terminate == terminate ? this : new Terminate(this.prefix, this.markers, terminate, this.reportName);
        }

        public Terminate withReportName(QualifiedDataName reportName) {
            return this.reportName == reportName ? this : new Terminate(this.prefix, this.markers, this.terminate, reportName);
        }
    }

    public static final class TableCall
    implements Identifier {
        private final Space prefix;
        private final Markers markers;
        private final QualifiedDataName qualifiedDataName;
        private final List<Parenthesized> subscripts;
        @Nullable
        private final ReferenceModifier referenceModifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitTableCall(this, p);
        }

        public TableCall(Space prefix, Markers markers, QualifiedDataName qualifiedDataName, List<Parenthesized> subscripts, ReferenceModifier referenceModifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.qualifiedDataName = qualifiedDataName;
            this.subscripts = subscripts;
            this.referenceModifier = referenceModifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public List<Parenthesized> getSubscripts() {
            return this.subscripts;
        }

        public ReferenceModifier getReferenceModifier() {
            return this.referenceModifier;
        }

        public String toString() {
            return "Cobol.TableCall(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", qualifiedDataName=" + this.getQualifiedDataName() + ", subscripts=" + this.getSubscripts() + ", referenceModifier=" + this.getReferenceModifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableCall)) {
                return false;
            }
            TableCall other = (TableCall)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            if (this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName)) {
                return false;
            }
            List<Parenthesized> this$subscripts = this.getSubscripts();
            List<Parenthesized> other$subscripts = other.getSubscripts();
            if (this$subscripts == null ? other$subscripts != null : !((Object)this$subscripts).equals(other$subscripts)) {
                return false;
            }
            ReferenceModifier this$referenceModifier = this.getReferenceModifier();
            ReferenceModifier other$referenceModifier = other.getReferenceModifier();
            return !(this$referenceModifier == null ? other$referenceModifier != null : !((Object)this$referenceModifier).equals(other$referenceModifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            List<Parenthesized> $subscripts = this.getSubscripts();
            result = result * 59 + ($subscripts == null ? 43 : ((Object)$subscripts).hashCode());
            ReferenceModifier $referenceModifier = this.getReferenceModifier();
            result = result * 59 + ($referenceModifier == null ? 43 : ((Object)$referenceModifier).hashCode());
            return result;
        }

        public TableCall withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TableCall(prefix, this.markers, this.qualifiedDataName, this.subscripts, this.referenceModifier);
        }

        public TableCall withMarkers(Markers markers) {
            return this.markers == markers ? this : new TableCall(this.prefix, markers, this.qualifiedDataName, this.subscripts, this.referenceModifier);
        }

        public TableCall withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new TableCall(this.prefix, this.markers, qualifiedDataName, this.subscripts, this.referenceModifier);
        }

        public TableCall withSubscripts(List<Parenthesized> subscripts) {
            return this.subscripts == subscripts ? this : new TableCall(this.prefix, this.markers, this.qualifiedDataName, subscripts, this.referenceModifier);
        }

        public TableCall withReferenceModifier(ReferenceModifier referenceModifier) {
            return this.referenceModifier == referenceModifier ? this : new TableCall(this.prefix, this.markers, this.qualifiedDataName, this.subscripts, referenceModifier);
        }
    }

    public static final class SymbolicTerminalClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dataDescName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicTerminalClause(this, p);
        }

        public SymbolicTerminalClause(Space prefix, Markers markers, List<Word> words, Word dataDescName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataDescName = dataDescName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataDescName() {
            return this.dataDescName;
        }

        public String toString() {
            return "Cobol.SymbolicTerminalClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataDescName=" + this.getDataDescName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicTerminalClause)) {
                return false;
            }
            SymbolicTerminalClause other = (SymbolicTerminalClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataDescName = this.getDataDescName();
            Word other$dataDescName = other.getDataDescName();
            return !(this$dataDescName == null ? other$dataDescName != null : !((Object)this$dataDescName).equals(other$dataDescName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataDescName = this.getDataDescName();
            result = result * 59 + ($dataDescName == null ? 43 : ((Object)$dataDescName).hashCode());
            return result;
        }

        public SymbolicTerminalClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicTerminalClause(prefix, this.markers, this.words, this.dataDescName);
        }

        public SymbolicTerminalClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicTerminalClause(this.prefix, markers, this.words, this.dataDescName);
        }

        public SymbolicTerminalClause withWords(List<Word> words) {
            return this.words == words ? this : new SymbolicTerminalClause(this.prefix, this.markers, words, this.dataDescName);
        }

        public SymbolicTerminalClause withDataDescName(Word dataDescName) {
            return this.dataDescName == dataDescName ? this : new SymbolicTerminalClause(this.prefix, this.markers, this.words, dataDescName);
        }
    }

    public static final class SymbolicSubQueueClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dataDescName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicSubQueueClause(this, p);
        }

        public SymbolicSubQueueClause(Space prefix, Markers markers, List<Word> words, Word dataDescName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataDescName = dataDescName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataDescName() {
            return this.dataDescName;
        }

        public String toString() {
            return "Cobol.SymbolicSubQueueClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataDescName=" + this.getDataDescName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicSubQueueClause)) {
                return false;
            }
            SymbolicSubQueueClause other = (SymbolicSubQueueClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataDescName = this.getDataDescName();
            Word other$dataDescName = other.getDataDescName();
            return !(this$dataDescName == null ? other$dataDescName != null : !((Object)this$dataDescName).equals(other$dataDescName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataDescName = this.getDataDescName();
            result = result * 59 + ($dataDescName == null ? 43 : ((Object)$dataDescName).hashCode());
            return result;
        }

        public SymbolicSubQueueClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicSubQueueClause(prefix, this.markers, this.words, this.dataDescName);
        }

        public SymbolicSubQueueClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicSubQueueClause(this.prefix, markers, this.words, this.dataDescName);
        }

        public SymbolicSubQueueClause withWords(List<Word> words) {
            return this.words == words ? this : new SymbolicSubQueueClause(this.prefix, this.markers, words, this.dataDescName);
        }

        public SymbolicSubQueueClause withDataDescName(Word dataDescName) {
            return this.dataDescName == dataDescName ? this : new SymbolicSubQueueClause(this.prefix, this.markers, this.words, dataDescName);
        }
    }

    public static final class SymbolicSourceClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dataDescName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicSourceClause(this, p);
        }

        public SymbolicSourceClause(Space prefix, Markers markers, List<Word> words, Word dataDescName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataDescName = dataDescName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataDescName() {
            return this.dataDescName;
        }

        public String toString() {
            return "Cobol.SymbolicSourceClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataDescName=" + this.getDataDescName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicSourceClause)) {
                return false;
            }
            SymbolicSourceClause other = (SymbolicSourceClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataDescName = this.getDataDescName();
            Word other$dataDescName = other.getDataDescName();
            return !(this$dataDescName == null ? other$dataDescName != null : !((Object)this$dataDescName).equals(other$dataDescName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataDescName = this.getDataDescName();
            result = result * 59 + ($dataDescName == null ? 43 : ((Object)$dataDescName).hashCode());
            return result;
        }

        public SymbolicSourceClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicSourceClause(prefix, this.markers, this.words, this.dataDescName);
        }

        public SymbolicSourceClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicSourceClause(this.prefix, markers, this.words, this.dataDescName);
        }

        public SymbolicSourceClause withWords(List<Word> words) {
            return this.words == words ? this : new SymbolicSourceClause(this.prefix, this.markers, words, this.dataDescName);
        }

        public SymbolicSourceClause withDataDescName(Word dataDescName) {
            return this.dataDescName == dataDescName ? this : new SymbolicSourceClause(this.prefix, this.markers, this.words, dataDescName);
        }
    }

    public static final class SymbolicQueueClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dataDescName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicQueueClause(this, p);
        }

        public SymbolicQueueClause(Space prefix, Markers markers, List<Word> words, Word dataDescName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataDescName = dataDescName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataDescName() {
            return this.dataDescName;
        }

        public String toString() {
            return "Cobol.SymbolicQueueClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataDescName=" + this.getDataDescName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicQueueClause)) {
                return false;
            }
            SymbolicQueueClause other = (SymbolicQueueClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataDescName = this.getDataDescName();
            Word other$dataDescName = other.getDataDescName();
            return !(this$dataDescName == null ? other$dataDescName != null : !((Object)this$dataDescName).equals(other$dataDescName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataDescName = this.getDataDescName();
            result = result * 59 + ($dataDescName == null ? 43 : ((Object)$dataDescName).hashCode());
            return result;
        }

        public SymbolicQueueClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicQueueClause(prefix, this.markers, this.words, this.dataDescName);
        }

        public SymbolicQueueClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicQueueClause(this.prefix, markers, this.words, this.dataDescName);
        }

        public SymbolicQueueClause withWords(List<Word> words) {
            return this.words == words ? this : new SymbolicQueueClause(this.prefix, this.markers, words, this.dataDescName);
        }

        public SymbolicQueueClause withDataDescName(Word dataDescName) {
            return this.dataDescName == dataDescName ? this : new SymbolicQueueClause(this.prefix, this.markers, this.words, dataDescName);
        }
    }

    public static final class SymbolicDestinationClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dataDescName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicDestinationClause(this, p);
        }

        public SymbolicDestinationClause(Space prefix, Markers markers, List<Word> words, Word dataDescName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataDescName = dataDescName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataDescName() {
            return this.dataDescName;
        }

        public String toString() {
            return "Cobol.SymbolicDestinationClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataDescName=" + this.getDataDescName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicDestinationClause)) {
                return false;
            }
            SymbolicDestinationClause other = (SymbolicDestinationClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataDescName = this.getDataDescName();
            Word other$dataDescName = other.getDataDescName();
            return !(this$dataDescName == null ? other$dataDescName != null : !((Object)this$dataDescName).equals(other$dataDescName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataDescName = this.getDataDescName();
            result = result * 59 + ($dataDescName == null ? 43 : ((Object)$dataDescName).hashCode());
            return result;
        }

        public SymbolicDestinationClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicDestinationClause(prefix, this.markers, this.words, this.dataDescName);
        }

        public SymbolicDestinationClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicDestinationClause(this.prefix, markers, this.words, this.dataDescName);
        }

        public SymbolicDestinationClause withWords(List<Word> words) {
            return this.words == words ? this : new SymbolicDestinationClause(this.prefix, this.markers, words, this.dataDescName);
        }

        public SymbolicDestinationClause withDataDescName(Word dataDescName) {
            return this.dataDescName == dataDescName ? this : new SymbolicDestinationClause(this.prefix, this.markers, this.words, dataDescName);
        }
    }

    public static final class SymbolicCharactersClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<SymbolicCharacter> symbols;
        @Nullable
        private final Word inAlphabet;
        @Nullable
        private final Identifier alphabetName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicCharactersClause(this, p);
        }

        public SymbolicCharactersClause(Space prefix, Markers markers, List<Word> words, List<SymbolicCharacter> symbols, Word inAlphabet, Identifier alphabetName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.symbols = symbols;
            this.inAlphabet = inAlphabet;
            this.alphabetName = alphabetName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<SymbolicCharacter> getSymbols() {
            return this.symbols;
        }

        public Word getInAlphabet() {
            return this.inAlphabet;
        }

        public Identifier getAlphabetName() {
            return this.alphabetName;
        }

        public String toString() {
            return "Cobol.SymbolicCharactersClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", symbols=" + this.getSymbols() + ", inAlphabet=" + this.getInAlphabet() + ", alphabetName=" + this.getAlphabetName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicCharactersClause)) {
                return false;
            }
            SymbolicCharactersClause other = (SymbolicCharactersClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<SymbolicCharacter> this$symbols = this.getSymbols();
            List<SymbolicCharacter> other$symbols = other.getSymbols();
            if (this$symbols == null ? other$symbols != null : !((Object)this$symbols).equals(other$symbols)) {
                return false;
            }
            Word this$inAlphabet = this.getInAlphabet();
            Word other$inAlphabet = other.getInAlphabet();
            if (this$inAlphabet == null ? other$inAlphabet != null : !((Object)this$inAlphabet).equals(other$inAlphabet)) {
                return false;
            }
            Identifier this$alphabetName = this.getAlphabetName();
            Identifier other$alphabetName = other.getAlphabetName();
            return !(this$alphabetName == null ? other$alphabetName != null : !this$alphabetName.equals(other$alphabetName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<SymbolicCharacter> $symbols = this.getSymbols();
            result = result * 59 + ($symbols == null ? 43 : ((Object)$symbols).hashCode());
            Word $inAlphabet = this.getInAlphabet();
            result = result * 59 + ($inAlphabet == null ? 43 : ((Object)$inAlphabet).hashCode());
            Identifier $alphabetName = this.getAlphabetName();
            result = result * 59 + ($alphabetName == null ? 43 : $alphabetName.hashCode());
            return result;
        }

        public SymbolicCharactersClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicCharactersClause(prefix, this.markers, this.words, this.symbols, this.inAlphabet, this.alphabetName);
        }

        public SymbolicCharactersClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicCharactersClause(this.prefix, markers, this.words, this.symbols, this.inAlphabet, this.alphabetName);
        }

        public SymbolicCharactersClause withWords(List<Word> words) {
            return this.words == words ? this : new SymbolicCharactersClause(this.prefix, this.markers, words, this.symbols, this.inAlphabet, this.alphabetName);
        }

        public SymbolicCharactersClause withSymbols(List<SymbolicCharacter> symbols) {
            return this.symbols == symbols ? this : new SymbolicCharactersClause(this.prefix, this.markers, this.words, symbols, this.inAlphabet, this.alphabetName);
        }

        public SymbolicCharactersClause withInAlphabet(Word inAlphabet) {
            return this.inAlphabet == inAlphabet ? this : new SymbolicCharactersClause(this.prefix, this.markers, this.words, this.symbols, inAlphabet, this.alphabetName);
        }

        public SymbolicCharactersClause withAlphabetName(Identifier alphabetName) {
            return this.alphabetName == alphabetName ? this : new SymbolicCharactersClause(this.prefix, this.markers, this.words, this.symbols, this.inAlphabet, alphabetName);
        }
    }

    public static final class SymbolicCharacter
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> symbols;
        @Nullable
        private final Word word;
        private final List<Word> literals;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSymbolicCharacter(this, p);
        }

        public SymbolicCharacter(Space prefix, Markers markers, List<Word> symbols, Word word, List<Word> literals) {
            this.prefix = prefix;
            this.markers = markers;
            this.symbols = symbols;
            this.word = word;
            this.literals = literals;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getSymbols() {
            return this.symbols;
        }

        public Word getWord() {
            return this.word;
        }

        public List<Word> getLiterals() {
            return this.literals;
        }

        public String toString() {
            return "Cobol.SymbolicCharacter(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", symbols=" + this.getSymbols() + ", word=" + this.getWord() + ", literals=" + this.getLiterals() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SymbolicCharacter)) {
                return false;
            }
            SymbolicCharacter other = (SymbolicCharacter)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$symbols = this.getSymbols();
            List<Word> other$symbols = other.getSymbols();
            if (this$symbols == null ? other$symbols != null : !((Object)this$symbols).equals(other$symbols)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            List<Word> this$literals = this.getLiterals();
            List<Word> other$literals = other.getLiterals();
            return !(this$literals == null ? other$literals != null : !((Object)this$literals).equals(other$literals));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $symbols = this.getSymbols();
            result = result * 59 + ($symbols == null ? 43 : ((Object)$symbols).hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            List<Word> $literals = this.getLiterals();
            result = result * 59 + ($literals == null ? 43 : ((Object)$literals).hashCode());
            return result;
        }

        public SymbolicCharacter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SymbolicCharacter(prefix, this.markers, this.symbols, this.word, this.literals);
        }

        public SymbolicCharacter withMarkers(Markers markers) {
            return this.markers == markers ? this : new SymbolicCharacter(this.prefix, markers, this.symbols, this.word, this.literals);
        }

        public SymbolicCharacter withSymbols(List<Word> symbols) {
            return this.symbols == symbols ? this : new SymbolicCharacter(this.prefix, this.markers, symbols, this.word, this.literals);
        }

        public SymbolicCharacter withWord(Word word) {
            return this.word == word ? this : new SymbolicCharacter(this.prefix, this.markers, this.symbols, word, this.literals);
        }

        public SymbolicCharacter withLiterals(List<Word> literals) {
            return this.literals == literals ? this : new SymbolicCharacter(this.prefix, this.markers, this.symbols, this.word, literals);
        }
    }

    public static final class SubtractMinuendCorresponding
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final QualifiedDataName qualifiedDataName;
        @Nullable
        private final Word rounded;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSubtractMinuendCorresponding(this, p);
        }

        public SubtractMinuendCorresponding(Space prefix, Markers markers, QualifiedDataName qualifiedDataName, Word rounded) {
            this.prefix = prefix;
            this.markers = markers;
            this.qualifiedDataName = qualifiedDataName;
            this.rounded = rounded;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public Word getRounded() {
            return this.rounded;
        }

        public String toString() {
            return "Cobol.SubtractMinuendCorresponding(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", qualifiedDataName=" + this.getQualifiedDataName() + ", rounded=" + this.getRounded() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubtractMinuendCorresponding)) {
                return false;
            }
            SubtractMinuendCorresponding other = (SubtractMinuendCorresponding)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            if (this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName)) {
                return false;
            }
            Word this$rounded = this.getRounded();
            Word other$rounded = other.getRounded();
            return !(this$rounded == null ? other$rounded != null : !((Object)this$rounded).equals(other$rounded));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            Word $rounded = this.getRounded();
            result = result * 59 + ($rounded == null ? 43 : ((Object)$rounded).hashCode());
            return result;
        }

        public SubtractMinuendCorresponding withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SubtractMinuendCorresponding(prefix, this.markers, this.qualifiedDataName, this.rounded);
        }

        public SubtractMinuendCorresponding withMarkers(Markers markers) {
            return this.markers == markers ? this : new SubtractMinuendCorresponding(this.prefix, markers, this.qualifiedDataName, this.rounded);
        }

        public SubtractMinuendCorresponding withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new SubtractMinuendCorresponding(this.prefix, this.markers, qualifiedDataName, this.rounded);
        }

        public SubtractMinuendCorresponding withRounded(Word rounded) {
            return this.rounded == rounded ? this : new SubtractMinuendCorresponding(this.prefix, this.markers, this.qualifiedDataName, rounded);
        }
    }

    public static final class SubtractFromStatement
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Name> subtractSubtrahend;
        private final Word from;
        private final List<Roundable> subtractMinuend;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSubtractFromStatement(this, p);
        }

        public SubtractFromStatement(Space prefix, Markers markers, List<Name> subtractSubtrahend, Word from, List<Roundable> subtractMinuend) {
            this.prefix = prefix;
            this.markers = markers;
            this.subtractSubtrahend = subtractSubtrahend;
            this.from = from;
            this.subtractMinuend = subtractMinuend;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Name> getSubtractSubtrahend() {
            return this.subtractSubtrahend;
        }

        public Word getFrom() {
            return this.from;
        }

        public List<Roundable> getSubtractMinuend() {
            return this.subtractMinuend;
        }

        public String toString() {
            return "Cobol.SubtractFromStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", subtractSubtrahend=" + this.getSubtractSubtrahend() + ", from=" + this.getFrom() + ", subtractMinuend=" + this.getSubtractMinuend() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubtractFromStatement)) {
                return false;
            }
            SubtractFromStatement other = (SubtractFromStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Name> this$subtractSubtrahend = this.getSubtractSubtrahend();
            List<Name> other$subtractSubtrahend = other.getSubtractSubtrahend();
            if (this$subtractSubtrahend == null ? other$subtractSubtrahend != null : !((Object)this$subtractSubtrahend).equals(other$subtractSubtrahend)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            List<Roundable> this$subtractMinuend = this.getSubtractMinuend();
            List<Roundable> other$subtractMinuend = other.getSubtractMinuend();
            return !(this$subtractMinuend == null ? other$subtractMinuend != null : !((Object)this$subtractMinuend).equals(other$subtractMinuend));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Name> $subtractSubtrahend = this.getSubtractSubtrahend();
            result = result * 59 + ($subtractSubtrahend == null ? 43 : ((Object)$subtractSubtrahend).hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            List<Roundable> $subtractMinuend = this.getSubtractMinuend();
            result = result * 59 + ($subtractMinuend == null ? 43 : ((Object)$subtractMinuend).hashCode());
            return result;
        }

        public SubtractFromStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SubtractFromStatement(prefix, this.markers, this.subtractSubtrahend, this.from, this.subtractMinuend);
        }

        public SubtractFromStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new SubtractFromStatement(this.prefix, markers, this.subtractSubtrahend, this.from, this.subtractMinuend);
        }

        public SubtractFromStatement withSubtractSubtrahend(List<Name> subtractSubtrahend) {
            return this.subtractSubtrahend == subtractSubtrahend ? this : new SubtractFromStatement(this.prefix, this.markers, subtractSubtrahend, this.from, this.subtractMinuend);
        }

        public SubtractFromStatement withFrom(Word from) {
            return this.from == from ? this : new SubtractFromStatement(this.prefix, this.markers, this.subtractSubtrahend, from, this.subtractMinuend);
        }

        public SubtractFromStatement withSubtractMinuend(List<Roundable> subtractMinuend) {
            return this.subtractMinuend == subtractMinuend ? this : new SubtractFromStatement(this.prefix, this.markers, this.subtractSubtrahend, this.from, subtractMinuend);
        }
    }

    public static final class SubtractFromGivingStatement
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Name> subtractSubtrahend;
        private final Word from;
        private final Name subtractMinuendGiving;
        private final Word giving;
        private final List<Roundable> subtractGiving;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSubtractFromGivingStatement(this, p);
        }

        public SubtractFromGivingStatement(Space prefix, Markers markers, List<Name> subtractSubtrahend, Word from, Name subtractMinuendGiving, Word giving, List<Roundable> subtractGiving) {
            this.prefix = prefix;
            this.markers = markers;
            this.subtractSubtrahend = subtractSubtrahend;
            this.from = from;
            this.subtractMinuendGiving = subtractMinuendGiving;
            this.giving = giving;
            this.subtractGiving = subtractGiving;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Name> getSubtractSubtrahend() {
            return this.subtractSubtrahend;
        }

        public Word getFrom() {
            return this.from;
        }

        public Name getSubtractMinuendGiving() {
            return this.subtractMinuendGiving;
        }

        public Word getGiving() {
            return this.giving;
        }

        public List<Roundable> getSubtractGiving() {
            return this.subtractGiving;
        }

        public String toString() {
            return "Cobol.SubtractFromGivingStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", subtractSubtrahend=" + this.getSubtractSubtrahend() + ", from=" + this.getFrom() + ", subtractMinuendGiving=" + this.getSubtractMinuendGiving() + ", giving=" + this.getGiving() + ", subtractGiving=" + this.getSubtractGiving() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubtractFromGivingStatement)) {
                return false;
            }
            SubtractFromGivingStatement other = (SubtractFromGivingStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Name> this$subtractSubtrahend = this.getSubtractSubtrahend();
            List<Name> other$subtractSubtrahend = other.getSubtractSubtrahend();
            if (this$subtractSubtrahend == null ? other$subtractSubtrahend != null : !((Object)this$subtractSubtrahend).equals(other$subtractSubtrahend)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            Name this$subtractMinuendGiving = this.getSubtractMinuendGiving();
            Name other$subtractMinuendGiving = other.getSubtractMinuendGiving();
            if (this$subtractMinuendGiving == null ? other$subtractMinuendGiving != null : !this$subtractMinuendGiving.equals(other$subtractMinuendGiving)) {
                return false;
            }
            Word this$giving = this.getGiving();
            Word other$giving = other.getGiving();
            if (this$giving == null ? other$giving != null : !((Object)this$giving).equals(other$giving)) {
                return false;
            }
            List<Roundable> this$subtractGiving = this.getSubtractGiving();
            List<Roundable> other$subtractGiving = other.getSubtractGiving();
            return !(this$subtractGiving == null ? other$subtractGiving != null : !((Object)this$subtractGiving).equals(other$subtractGiving));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Name> $subtractSubtrahend = this.getSubtractSubtrahend();
            result = result * 59 + ($subtractSubtrahend == null ? 43 : ((Object)$subtractSubtrahend).hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            Name $subtractMinuendGiving = this.getSubtractMinuendGiving();
            result = result * 59 + ($subtractMinuendGiving == null ? 43 : $subtractMinuendGiving.hashCode());
            Word $giving = this.getGiving();
            result = result * 59 + ($giving == null ? 43 : ((Object)$giving).hashCode());
            List<Roundable> $subtractGiving = this.getSubtractGiving();
            result = result * 59 + ($subtractGiving == null ? 43 : ((Object)$subtractGiving).hashCode());
            return result;
        }

        public SubtractFromGivingStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SubtractFromGivingStatement(prefix, this.markers, this.subtractSubtrahend, this.from, this.subtractMinuendGiving, this.giving, this.subtractGiving);
        }

        public SubtractFromGivingStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new SubtractFromGivingStatement(this.prefix, markers, this.subtractSubtrahend, this.from, this.subtractMinuendGiving, this.giving, this.subtractGiving);
        }

        public SubtractFromGivingStatement withSubtractSubtrahend(List<Name> subtractSubtrahend) {
            return this.subtractSubtrahend == subtractSubtrahend ? this : new SubtractFromGivingStatement(this.prefix, this.markers, subtractSubtrahend, this.from, this.subtractMinuendGiving, this.giving, this.subtractGiving);
        }

        public SubtractFromGivingStatement withFrom(Word from) {
            return this.from == from ? this : new SubtractFromGivingStatement(this.prefix, this.markers, this.subtractSubtrahend, from, this.subtractMinuendGiving, this.giving, this.subtractGiving);
        }

        public SubtractFromGivingStatement withSubtractMinuendGiving(Name subtractMinuendGiving) {
            return this.subtractMinuendGiving == subtractMinuendGiving ? this : new SubtractFromGivingStatement(this.prefix, this.markers, this.subtractSubtrahend, this.from, subtractMinuendGiving, this.giving, this.subtractGiving);
        }

        public SubtractFromGivingStatement withGiving(Word giving) {
            return this.giving == giving ? this : new SubtractFromGivingStatement(this.prefix, this.markers, this.subtractSubtrahend, this.from, this.subtractMinuendGiving, giving, this.subtractGiving);
        }

        public SubtractFromGivingStatement withSubtractGiving(List<Roundable> subtractGiving) {
            return this.subtractGiving == subtractGiving ? this : new SubtractFromGivingStatement(this.prefix, this.markers, this.subtractSubtrahend, this.from, this.subtractMinuendGiving, this.giving, subtractGiving);
        }
    }

    public static final class SubtractCorrespondingStatement
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word corresponding;
        private final QualifiedDataName qualifiedDataName;
        private final Word from;
        private final SubtractMinuendCorresponding subtractMinuendCorresponding;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSubtractCorrespondingStatement(this, p);
        }

        public SubtractCorrespondingStatement(Space prefix, Markers markers, Word corresponding, QualifiedDataName qualifiedDataName, Word from, SubtractMinuendCorresponding subtractMinuendCorresponding) {
            this.prefix = prefix;
            this.markers = markers;
            this.corresponding = corresponding;
            this.qualifiedDataName = qualifiedDataName;
            this.from = from;
            this.subtractMinuendCorresponding = subtractMinuendCorresponding;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getCorresponding() {
            return this.corresponding;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public Word getFrom() {
            return this.from;
        }

        public SubtractMinuendCorresponding getSubtractMinuendCorresponding() {
            return this.subtractMinuendCorresponding;
        }

        public String toString() {
            return "Cobol.SubtractCorrespondingStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", corresponding=" + this.getCorresponding() + ", qualifiedDataName=" + this.getQualifiedDataName() + ", from=" + this.getFrom() + ", subtractMinuendCorresponding=" + this.getSubtractMinuendCorresponding() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubtractCorrespondingStatement)) {
                return false;
            }
            SubtractCorrespondingStatement other = (SubtractCorrespondingStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$corresponding = this.getCorresponding();
            Word other$corresponding = other.getCorresponding();
            if (this$corresponding == null ? other$corresponding != null : !((Object)this$corresponding).equals(other$corresponding)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            if (this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            SubtractMinuendCorresponding this$subtractMinuendCorresponding = this.getSubtractMinuendCorresponding();
            SubtractMinuendCorresponding other$subtractMinuendCorresponding = other.getSubtractMinuendCorresponding();
            return !(this$subtractMinuendCorresponding == null ? other$subtractMinuendCorresponding != null : !((Object)this$subtractMinuendCorresponding).equals(other$subtractMinuendCorresponding));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $corresponding = this.getCorresponding();
            result = result * 59 + ($corresponding == null ? 43 : ((Object)$corresponding).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            SubtractMinuendCorresponding $subtractMinuendCorresponding = this.getSubtractMinuendCorresponding();
            result = result * 59 + ($subtractMinuendCorresponding == null ? 43 : ((Object)$subtractMinuendCorresponding).hashCode());
            return result;
        }

        public SubtractCorrespondingStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SubtractCorrespondingStatement(prefix, this.markers, this.corresponding, this.qualifiedDataName, this.from, this.subtractMinuendCorresponding);
        }

        public SubtractCorrespondingStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new SubtractCorrespondingStatement(this.prefix, markers, this.corresponding, this.qualifiedDataName, this.from, this.subtractMinuendCorresponding);
        }

        public SubtractCorrespondingStatement withCorresponding(Word corresponding) {
            return this.corresponding == corresponding ? this : new SubtractCorrespondingStatement(this.prefix, this.markers, corresponding, this.qualifiedDataName, this.from, this.subtractMinuendCorresponding);
        }

        public SubtractCorrespondingStatement withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new SubtractCorrespondingStatement(this.prefix, this.markers, this.corresponding, qualifiedDataName, this.from, this.subtractMinuendCorresponding);
        }

        public SubtractCorrespondingStatement withFrom(Word from) {
            return this.from == from ? this : new SubtractCorrespondingStatement(this.prefix, this.markers, this.corresponding, this.qualifiedDataName, from, this.subtractMinuendCorresponding);
        }

        public SubtractCorrespondingStatement withSubtractMinuendCorresponding(SubtractMinuendCorresponding subtractMinuendCorresponding) {
            return this.subtractMinuendCorresponding == subtractMinuendCorresponding ? this : new SubtractCorrespondingStatement(this.prefix, this.markers, this.corresponding, this.qualifiedDataName, this.from, subtractMinuendCorresponding);
        }
    }

    public static final class Subtract
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word substract;
        private final Cobol operation;
        @Nullable
        private final StatementPhrase onSizeErrorPhrase;
        @Nullable
        private final StatementPhrase notOnSizeErrorPhrase;
        @Nullable
        private final Word endSubtract;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSubtract(this, p);
        }

        public Subtract(Space prefix, Markers markers, Word substract, Cobol operation, StatementPhrase onSizeErrorPhrase, StatementPhrase notOnSizeErrorPhrase, Word endSubtract) {
            this.prefix = prefix;
            this.markers = markers;
            this.substract = substract;
            this.operation = operation;
            this.onSizeErrorPhrase = onSizeErrorPhrase;
            this.notOnSizeErrorPhrase = notOnSizeErrorPhrase;
            this.endSubtract = endSubtract;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getSubstract() {
            return this.substract;
        }

        public Cobol getOperation() {
            return this.operation;
        }

        public StatementPhrase getOnSizeErrorPhrase() {
            return this.onSizeErrorPhrase;
        }

        public StatementPhrase getNotOnSizeErrorPhrase() {
            return this.notOnSizeErrorPhrase;
        }

        public Word getEndSubtract() {
            return this.endSubtract;
        }

        public String toString() {
            return "Cobol.Subtract(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", substract=" + this.getSubstract() + ", operation=" + this.getOperation() + ", onSizeErrorPhrase=" + this.getOnSizeErrorPhrase() + ", notOnSizeErrorPhrase=" + this.getNotOnSizeErrorPhrase() + ", endSubtract=" + this.getEndSubtract() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subtract)) {
                return false;
            }
            Subtract other = (Subtract)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$substract = this.getSubstract();
            Word other$substract = other.getSubstract();
            if (this$substract == null ? other$substract != null : !((Object)this$substract).equals(other$substract)) {
                return false;
            }
            Cobol this$operation = this.getOperation();
            Cobol other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
                return false;
            }
            StatementPhrase this$onSizeErrorPhrase = this.getOnSizeErrorPhrase();
            StatementPhrase other$onSizeErrorPhrase = other.getOnSizeErrorPhrase();
            if (this$onSizeErrorPhrase == null ? other$onSizeErrorPhrase != null : !((Object)this$onSizeErrorPhrase).equals(other$onSizeErrorPhrase)) {
                return false;
            }
            StatementPhrase this$notOnSizeErrorPhrase = this.getNotOnSizeErrorPhrase();
            StatementPhrase other$notOnSizeErrorPhrase = other.getNotOnSizeErrorPhrase();
            if (this$notOnSizeErrorPhrase == null ? other$notOnSizeErrorPhrase != null : !((Object)this$notOnSizeErrorPhrase).equals(other$notOnSizeErrorPhrase)) {
                return false;
            }
            Word this$endSubtract = this.getEndSubtract();
            Word other$endSubtract = other.getEndSubtract();
            return !(this$endSubtract == null ? other$endSubtract != null : !((Object)this$endSubtract).equals(other$endSubtract));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $substract = this.getSubstract();
            result = result * 59 + ($substract == null ? 43 : ((Object)$substract).hashCode());
            Cobol $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
            StatementPhrase $onSizeErrorPhrase = this.getOnSizeErrorPhrase();
            result = result * 59 + ($onSizeErrorPhrase == null ? 43 : ((Object)$onSizeErrorPhrase).hashCode());
            StatementPhrase $notOnSizeErrorPhrase = this.getNotOnSizeErrorPhrase();
            result = result * 59 + ($notOnSizeErrorPhrase == null ? 43 : ((Object)$notOnSizeErrorPhrase).hashCode());
            Word $endSubtract = this.getEndSubtract();
            result = result * 59 + ($endSubtract == null ? 43 : ((Object)$endSubtract).hashCode());
            return result;
        }

        public Subtract withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Subtract(prefix, this.markers, this.substract, this.operation, this.onSizeErrorPhrase, this.notOnSizeErrorPhrase, this.endSubtract);
        }

        public Subtract withMarkers(Markers markers) {
            return this.markers == markers ? this : new Subtract(this.prefix, markers, this.substract, this.operation, this.onSizeErrorPhrase, this.notOnSizeErrorPhrase, this.endSubtract);
        }

        public Subtract withSubstract(Word substract) {
            return this.substract == substract ? this : new Subtract(this.prefix, this.markers, substract, this.operation, this.onSizeErrorPhrase, this.notOnSizeErrorPhrase, this.endSubtract);
        }

        public Subtract withOperation(Cobol operation) {
            return this.operation == operation ? this : new Subtract(this.prefix, this.markers, this.substract, operation, this.onSizeErrorPhrase, this.notOnSizeErrorPhrase, this.endSubtract);
        }

        public Subtract withOnSizeErrorPhrase(StatementPhrase onSizeErrorPhrase) {
            return this.onSizeErrorPhrase == onSizeErrorPhrase ? this : new Subtract(this.prefix, this.markers, this.substract, this.operation, onSizeErrorPhrase, this.notOnSizeErrorPhrase, this.endSubtract);
        }

        public Subtract withNotOnSizeErrorPhrase(StatementPhrase notOnSizeErrorPhrase) {
            return this.notOnSizeErrorPhrase == notOnSizeErrorPhrase ? this : new Subtract(this.prefix, this.markers, this.substract, this.operation, this.onSizeErrorPhrase, notOnSizeErrorPhrase, this.endSubtract);
        }

        public Subtract withEndSubtract(Word endSubtract) {
            return this.endSubtract == endSubtract ? this : new Subtract(this.prefix, this.markers, this.substract, this.operation, this.onSizeErrorPhrase, this.notOnSizeErrorPhrase, endSubtract);
        }
    }

    public static final class Subscript
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Cobol first;
        @Nullable
        private final Word second;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSubscript(this, p);
        }

        public Subscript(Space prefix, Markers markers, Cobol first, Word second) {
            this.prefix = prefix;
            this.markers = markers;
            this.first = first;
            this.second = second;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Cobol getFirst() {
            return this.first;
        }

        public Word getSecond() {
            return this.second;
        }

        public String toString() {
            return "Cobol.Subscript(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subscript)) {
                return false;
            }
            Subscript other = (Subscript)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Cobol this$first = this.getFirst();
            Cobol other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Word this$second = this.getSecond();
            Word other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !((Object)this$second).equals(other$second));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Cobol $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Word $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
            return result;
        }

        public Subscript withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Subscript(prefix, this.markers, this.first, this.second);
        }

        public Subscript withMarkers(Markers markers) {
            return this.markers == markers ? this : new Subscript(this.prefix, markers, this.first, this.second);
        }

        public Subscript withFirst(Cobol first) {
            return this.first == first ? this : new Subscript(this.prefix, this.markers, first, this.second);
        }

        public Subscript withSecond(Word second) {
            return this.second == second ? this : new Subscript(this.prefix, this.markers, this.first, second);
        }
    }

    public static final class StringWithPointerPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStringWithPointerPhrase(this, p);
        }

        public StringWithPointerPhrase(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.StringWithPointerPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringWithPointerPhrase)) {
                return false;
            }
            StringWithPointerPhrase other = (StringWithPointerPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public StringWithPointerPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringWithPointerPhrase(prefix, this.markers, this.words, this.qualifiedDataName);
        }

        public StringWithPointerPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringWithPointerPhrase(this.prefix, markers, this.words, this.qualifiedDataName);
        }

        public StringWithPointerPhrase withWords(List<Word> words) {
            return this.words == words ? this : new StringWithPointerPhrase(this.prefix, this.markers, words, this.qualifiedDataName);
        }

        public StringWithPointerPhrase withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new StringWithPointerPhrase(this.prefix, this.markers, this.words, qualifiedDataName);
        }
    }

    public static final class StringStatement
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word string;
        private final List<Cobol> stringSendingPhrases;
        private final StringIntoPhrase stringIntoPhrase;
        @Nullable
        private final StringWithPointerPhrase stringWithPointerPhrase;
        @Nullable
        private final StatementPhrase onOverflowPhrase;
        @Nullable
        private final StatementPhrase notOnOverflowPhrase;
        @Nullable
        private final Word endString;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStringStatement(this, p);
        }

        public StringStatement(Space prefix, Markers markers, Word string, List<Cobol> stringSendingPhrases, StringIntoPhrase stringIntoPhrase, StringWithPointerPhrase stringWithPointerPhrase, StatementPhrase onOverflowPhrase, StatementPhrase notOnOverflowPhrase, Word endString) {
            this.prefix = prefix;
            this.markers = markers;
            this.string = string;
            this.stringSendingPhrases = stringSendingPhrases;
            this.stringIntoPhrase = stringIntoPhrase;
            this.stringWithPointerPhrase = stringWithPointerPhrase;
            this.onOverflowPhrase = onOverflowPhrase;
            this.notOnOverflowPhrase = notOnOverflowPhrase;
            this.endString = endString;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getString() {
            return this.string;
        }

        public List<Cobol> getStringSendingPhrases() {
            return this.stringSendingPhrases;
        }

        public StringIntoPhrase getStringIntoPhrase() {
            return this.stringIntoPhrase;
        }

        public StringWithPointerPhrase getStringWithPointerPhrase() {
            return this.stringWithPointerPhrase;
        }

        public StatementPhrase getOnOverflowPhrase() {
            return this.onOverflowPhrase;
        }

        public StatementPhrase getNotOnOverflowPhrase() {
            return this.notOnOverflowPhrase;
        }

        public Word getEndString() {
            return this.endString;
        }

        public String toString() {
            return "Cobol.StringStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", string=" + this.getString() + ", stringSendingPhrases=" + this.getStringSendingPhrases() + ", stringIntoPhrase=" + this.getStringIntoPhrase() + ", stringWithPointerPhrase=" + this.getStringWithPointerPhrase() + ", onOverflowPhrase=" + this.getOnOverflowPhrase() + ", notOnOverflowPhrase=" + this.getNotOnOverflowPhrase() + ", endString=" + this.getEndString() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringStatement)) {
                return false;
            }
            StringStatement other = (StringStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$string = this.getString();
            Word other$string = other.getString();
            if (this$string == null ? other$string != null : !((Object)this$string).equals(other$string)) {
                return false;
            }
            List<Cobol> this$stringSendingPhrases = this.getStringSendingPhrases();
            List<Cobol> other$stringSendingPhrases = other.getStringSendingPhrases();
            if (this$stringSendingPhrases == null ? other$stringSendingPhrases != null : !((Object)this$stringSendingPhrases).equals(other$stringSendingPhrases)) {
                return false;
            }
            StringIntoPhrase this$stringIntoPhrase = this.getStringIntoPhrase();
            StringIntoPhrase other$stringIntoPhrase = other.getStringIntoPhrase();
            if (this$stringIntoPhrase == null ? other$stringIntoPhrase != null : !((Object)this$stringIntoPhrase).equals(other$stringIntoPhrase)) {
                return false;
            }
            StringWithPointerPhrase this$stringWithPointerPhrase = this.getStringWithPointerPhrase();
            StringWithPointerPhrase other$stringWithPointerPhrase = other.getStringWithPointerPhrase();
            if (this$stringWithPointerPhrase == null ? other$stringWithPointerPhrase != null : !((Object)this$stringWithPointerPhrase).equals(other$stringWithPointerPhrase)) {
                return false;
            }
            StatementPhrase this$onOverflowPhrase = this.getOnOverflowPhrase();
            StatementPhrase other$onOverflowPhrase = other.getOnOverflowPhrase();
            if (this$onOverflowPhrase == null ? other$onOverflowPhrase != null : !((Object)this$onOverflowPhrase).equals(other$onOverflowPhrase)) {
                return false;
            }
            StatementPhrase this$notOnOverflowPhrase = this.getNotOnOverflowPhrase();
            StatementPhrase other$notOnOverflowPhrase = other.getNotOnOverflowPhrase();
            if (this$notOnOverflowPhrase == null ? other$notOnOverflowPhrase != null : !((Object)this$notOnOverflowPhrase).equals(other$notOnOverflowPhrase)) {
                return false;
            }
            Word this$endString = this.getEndString();
            Word other$endString = other.getEndString();
            return !(this$endString == null ? other$endString != null : !((Object)this$endString).equals(other$endString));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $string = this.getString();
            result = result * 59 + ($string == null ? 43 : ((Object)$string).hashCode());
            List<Cobol> $stringSendingPhrases = this.getStringSendingPhrases();
            result = result * 59 + ($stringSendingPhrases == null ? 43 : ((Object)$stringSendingPhrases).hashCode());
            StringIntoPhrase $stringIntoPhrase = this.getStringIntoPhrase();
            result = result * 59 + ($stringIntoPhrase == null ? 43 : ((Object)$stringIntoPhrase).hashCode());
            StringWithPointerPhrase $stringWithPointerPhrase = this.getStringWithPointerPhrase();
            result = result * 59 + ($stringWithPointerPhrase == null ? 43 : ((Object)$stringWithPointerPhrase).hashCode());
            StatementPhrase $onOverflowPhrase = this.getOnOverflowPhrase();
            result = result * 59 + ($onOverflowPhrase == null ? 43 : ((Object)$onOverflowPhrase).hashCode());
            StatementPhrase $notOnOverflowPhrase = this.getNotOnOverflowPhrase();
            result = result * 59 + ($notOnOverflowPhrase == null ? 43 : ((Object)$notOnOverflowPhrase).hashCode());
            Word $endString = this.getEndString();
            result = result * 59 + ($endString == null ? 43 : ((Object)$endString).hashCode());
            return result;
        }

        public StringStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringStatement(prefix, this.markers, this.string, this.stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringStatement(this.prefix, markers, this.string, this.stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withString(Word string) {
            return this.string == string ? this : new StringStatement(this.prefix, this.markers, string, this.stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withStringSendingPhrases(List<Cobol> stringSendingPhrases) {
            return this.stringSendingPhrases == stringSendingPhrases ? this : new StringStatement(this.prefix, this.markers, this.string, stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withStringIntoPhrase(StringIntoPhrase stringIntoPhrase) {
            return this.stringIntoPhrase == stringIntoPhrase ? this : new StringStatement(this.prefix, this.markers, this.string, this.stringSendingPhrases, stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withStringWithPointerPhrase(StringWithPointerPhrase stringWithPointerPhrase) {
            return this.stringWithPointerPhrase == stringWithPointerPhrase ? this : new StringStatement(this.prefix, this.markers, this.string, this.stringSendingPhrases, this.stringIntoPhrase, stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withOnOverflowPhrase(StatementPhrase onOverflowPhrase) {
            return this.onOverflowPhrase == onOverflowPhrase ? this : new StringStatement(this.prefix, this.markers, this.string, this.stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, onOverflowPhrase, this.notOnOverflowPhrase, this.endString);
        }

        public StringStatement withNotOnOverflowPhrase(StatementPhrase notOnOverflowPhrase) {
            return this.notOnOverflowPhrase == notOnOverflowPhrase ? this : new StringStatement(this.prefix, this.markers, this.string, this.stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, notOnOverflowPhrase, this.endString);
        }

        public StringStatement withEndString(Word endString) {
            return this.endString == endString ? this : new StringStatement(this.prefix, this.markers, this.string, this.stringSendingPhrases, this.stringIntoPhrase, this.stringWithPointerPhrase, this.onOverflowPhrase, this.notOnOverflowPhrase, endString);
        }
    }

    public static final class StringSendingPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> sendings;
        private final Cobol phrase;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStringSendingPhrase(this, p);
        }

        public StringSendingPhrase(Space prefix, Markers markers, List<Cobol> sendings, Cobol phrase) {
            this.prefix = prefix;
            this.markers = markers;
            this.sendings = sendings;
            this.phrase = phrase;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getSendings() {
            return this.sendings;
        }

        public Cobol getPhrase() {
            return this.phrase;
        }

        public String toString() {
            return "Cobol.StringSendingPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sendings=" + this.getSendings() + ", phrase=" + this.getPhrase() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringSendingPhrase)) {
                return false;
            }
            StringSendingPhrase other = (StringSendingPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$sendings = this.getSendings();
            List<Cobol> other$sendings = other.getSendings();
            if (this$sendings == null ? other$sendings != null : !((Object)this$sendings).equals(other$sendings)) {
                return false;
            }
            Cobol this$phrase = this.getPhrase();
            Cobol other$phrase = other.getPhrase();
            return !(this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $sendings = this.getSendings();
            result = result * 59 + ($sendings == null ? 43 : ((Object)$sendings).hashCode());
            Cobol $phrase = this.getPhrase();
            result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
            return result;
        }

        public StringSendingPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringSendingPhrase(prefix, this.markers, this.sendings, this.phrase);
        }

        public StringSendingPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringSendingPhrase(this.prefix, markers, this.sendings, this.phrase);
        }

        public StringSendingPhrase withSendings(List<Cobol> sendings) {
            return this.sendings == sendings ? this : new StringSendingPhrase(this.prefix, this.markers, sendings, this.phrase);
        }

        public StringSendingPhrase withPhrase(Cobol phrase) {
            return this.phrase == phrase ? this : new StringSendingPhrase(this.prefix, this.markers, this.sendings, phrase);
        }
    }

    public static final class StringIntoPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word into;
        private final Identifier identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStringIntoPhrase(this, p);
        }

        public StringIntoPhrase(Space prefix, Markers markers, Word into, Identifier identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.into = into;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getInto() {
            return this.into;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.StringIntoPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", into=" + this.getInto() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringIntoPhrase)) {
                return false;
            }
            StringIntoPhrase other = (StringIntoPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$into = this.getInto();
            Word other$into = other.getInto();
            if (this$into == null ? other$into != null : !((Object)this$into).equals(other$into)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $into = this.getInto();
            result = result * 59 + ($into == null ? 43 : ((Object)$into).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public StringIntoPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringIntoPhrase(prefix, this.markers, this.into, this.identifier);
        }

        public StringIntoPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringIntoPhrase(this.prefix, markers, this.into, this.identifier);
        }

        public StringIntoPhrase withInto(Word into) {
            return this.into == into ? this : new StringIntoPhrase(this.prefix, this.markers, into, this.identifier);
        }

        public StringIntoPhrase withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new StringIntoPhrase(this.prefix, this.markers, this.into, identifier);
        }
    }

    public static final class StringForPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Name identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStringForPhrase(this, p);
        }

        public StringForPhrase(Space prefix, Markers markers, Word word, Name identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.StringForPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringForPhrase)) {
                return false;
            }
            StringForPhrase other = (StringForPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$identifier = this.getIdentifier();
            Name other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public StringForPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringForPhrase(prefix, this.markers, this.word, this.identifier);
        }

        public StringForPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringForPhrase(this.prefix, markers, this.word, this.identifier);
        }

        public StringForPhrase withWord(Word word) {
            return this.word == word ? this : new StringForPhrase(this.prefix, this.markers, word, this.identifier);
        }

        public StringForPhrase withIdentifier(Name identifier) {
            return this.identifier == identifier ? this : new StringForPhrase(this.prefix, this.markers, this.word, identifier);
        }
    }

    public static final class StopStatementGiving
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStopStatementGiving(this, p);
        }

        public StopStatementGiving(Space prefix, Markers markers, List<Word> words, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.StopStatementGiving(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StopStatementGiving)) {
                return false;
            }
            StopStatementGiving other = (StopStatementGiving)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public StopStatementGiving withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StopStatementGiving(prefix, this.markers, this.words, this.name);
        }

        public StopStatementGiving withMarkers(Markers markers) {
            return this.markers == markers ? this : new StopStatementGiving(this.prefix, markers, this.words, this.name);
        }

        public StopStatementGiving withWords(List<Word> words) {
            return this.words == words ? this : new StopStatementGiving(this.prefix, this.markers, words, this.name);
        }

        public StopStatementGiving withName(Name name) {
            return this.name == name ? this : new StopStatementGiving(this.prefix, this.markers, this.words, name);
        }
    }

    public static final class StringDelimitedByPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStringDelimitedByPhrase(this, p);
        }

        public StringDelimitedByPhrase(Space prefix, Markers markers, List<Word> words, Name identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.StringDelimitedByPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringDelimitedByPhrase)) {
                return false;
            }
            StringDelimitedByPhrase other = (StringDelimitedByPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$identifier = this.getIdentifier();
            Name other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public StringDelimitedByPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StringDelimitedByPhrase(prefix, this.markers, this.words, this.identifier);
        }

        public StringDelimitedByPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new StringDelimitedByPhrase(this.prefix, markers, this.words, this.identifier);
        }

        public StringDelimitedByPhrase withWords(List<Word> words) {
            return this.words == words ? this : new StringDelimitedByPhrase(this.prefix, this.markers, words, this.identifier);
        }

        public StringDelimitedByPhrase withIdentifier(Name identifier) {
            return this.identifier == identifier ? this : new StringDelimitedByPhrase(this.prefix, this.markers, this.words, identifier);
        }
    }

    public static final class Stop
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Cobol statement;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStop(this, p);
        }

        public Stop(Space prefix, Markers markers, List<Word> words, Cobol statement) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.statement = statement;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getStatement() {
            return this.statement;
        }

        public String toString() {
            return "Cobol.Stop(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", statement=" + this.getStatement() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Stop)) {
                return false;
            }
            Stop other = (Stop)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$statement = this.getStatement();
            Cobol other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public Stop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Stop(prefix, this.markers, this.words, this.statement);
        }

        public Stop withMarkers(Markers markers) {
            return this.markers == markers ? this : new Stop(this.prefix, markers, this.words, this.statement);
        }

        public Stop withWords(List<Word> words) {
            return this.words == words ? this : new Stop(this.prefix, this.markers, words, this.statement);
        }

        public Stop withStatement(Cobol statement) {
            return this.statement == statement ? this : new Stop(this.prefix, this.markers, this.words, statement);
        }
    }

    public static final class StatusKeyClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStatusKeyClause(this, p);
        }

        public StatusKeyClause(Space prefix, Markers markers, List<Word> words, Word name) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.StatusKeyClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusKeyClause)) {
                return false;
            }
            StatusKeyClause other = (StatusKeyClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$name = this.getName();
            Word other$name = other.getName();
            return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            return result;
        }

        public StatusKeyClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StatusKeyClause(prefix, this.markers, this.words, this.name);
        }

        public StatusKeyClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new StatusKeyClause(this.prefix, markers, this.words, this.name);
        }

        public StatusKeyClause withWords(List<Word> words) {
            return this.words == words ? this : new StatusKeyClause(this.prefix, this.markers, words, this.name);
        }

        public StatusKeyClause withName(Word name) {
            return this.name == name ? this : new StatusKeyClause(this.prefix, this.markers, this.words, name);
        }
    }

    public static final class StatementPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> phrases;
        private final List<Statement> statements;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStatementPhrase(this, p);
        }

        public StatementPhrase(Space prefix, Markers markers, List<Word> phrases, List<Statement> statements) {
            this.prefix = prefix;
            this.markers = markers;
            this.phrases = phrases;
            this.statements = statements;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getPhrases() {
            return this.phrases;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public String toString() {
            return "Cobol.StatementPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", phrases=" + this.getPhrases() + ", statements=" + this.getStatements() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementPhrase)) {
                return false;
            }
            StatementPhrase other = (StatementPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$phrases = this.getPhrases();
            List<Word> other$phrases = other.getPhrases();
            if (this$phrases == null ? other$phrases != null : !((Object)this$phrases).equals(other$phrases)) {
                return false;
            }
            List<Statement> this$statements = this.getStatements();
            List<Statement> other$statements = other.getStatements();
            return !(this$statements == null ? other$statements != null : !((Object)this$statements).equals(other$statements));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $phrases = this.getPhrases();
            result = result * 59 + ($phrases == null ? 43 : ((Object)$phrases).hashCode());
            List<Statement> $statements = this.getStatements();
            result = result * 59 + ($statements == null ? 43 : ((Object)$statements).hashCode());
            return result;
        }

        public StatementPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StatementPhrase(prefix, this.markers, this.phrases, this.statements);
        }

        public StatementPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new StatementPhrase(this.prefix, markers, this.phrases, this.statements);
        }

        public StatementPhrase withPhrases(List<Word> phrases) {
            return this.phrases == phrases ? this : new StatementPhrase(this.prefix, this.markers, phrases, this.statements);
        }

        public StatementPhrase withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new StatementPhrase(this.prefix, this.markers, this.phrases, statements);
        }
    }

    public static final class StartKey
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStartKey(this, p);
        }

        public StartKey(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.StartKey(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartKey)) {
                return false;
            }
            StartKey other = (StartKey)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public StartKey withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new StartKey(prefix, this.markers, this.words, this.qualifiedDataName);
        }

        public StartKey withMarkers(Markers markers) {
            return this.markers == markers ? this : new StartKey(this.prefix, markers, this.words, this.qualifiedDataName);
        }

        public StartKey withWords(List<Word> words) {
            return this.words == words ? this : new StartKey(this.prefix, this.markers, words, this.qualifiedDataName);
        }

        public StartKey withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new StartKey(this.prefix, this.markers, this.words, qualifiedDataName);
        }
    }

    public static final class Start
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word start;
        private final Word fileName;
        @Nullable
        private final StartKey startKey;
        @Nullable
        private final StatementPhrase invalidKeyPhrase;
        @Nullable
        private final StatementPhrase notInvalidKeyPhrase;
        @Nullable
        private final Word endStart;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitStart(this, p);
        }

        public Start(Space prefix, Markers markers, Word start, Word fileName, StartKey startKey, StatementPhrase invalidKeyPhrase, StatementPhrase notInvalidKeyPhrase, Word endStart) {
            this.prefix = prefix;
            this.markers = markers;
            this.start = start;
            this.fileName = fileName;
            this.startKey = startKey;
            this.invalidKeyPhrase = invalidKeyPhrase;
            this.notInvalidKeyPhrase = notInvalidKeyPhrase;
            this.endStart = endStart;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getStart() {
            return this.start;
        }

        public Word getFileName() {
            return this.fileName;
        }

        public StartKey getStartKey() {
            return this.startKey;
        }

        public StatementPhrase getInvalidKeyPhrase() {
            return this.invalidKeyPhrase;
        }

        public StatementPhrase getNotInvalidKeyPhrase() {
            return this.notInvalidKeyPhrase;
        }

        public Word getEndStart() {
            return this.endStart;
        }

        public String toString() {
            return "Cobol.Start(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", start=" + this.getStart() + ", fileName=" + this.getFileName() + ", startKey=" + this.getStartKey() + ", invalidKeyPhrase=" + this.getInvalidKeyPhrase() + ", notInvalidKeyPhrase=" + this.getNotInvalidKeyPhrase() + ", endStart=" + this.getEndStart() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Start)) {
                return false;
            }
            Start other = (Start)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$start = this.getStart();
            Word other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            Word this$fileName = this.getFileName();
            Word other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !((Object)this$fileName).equals(other$fileName)) {
                return false;
            }
            StartKey this$startKey = this.getStartKey();
            StartKey other$startKey = other.getStartKey();
            if (this$startKey == null ? other$startKey != null : !((Object)this$startKey).equals(other$startKey)) {
                return false;
            }
            StatementPhrase this$invalidKeyPhrase = this.getInvalidKeyPhrase();
            StatementPhrase other$invalidKeyPhrase = other.getInvalidKeyPhrase();
            if (this$invalidKeyPhrase == null ? other$invalidKeyPhrase != null : !((Object)this$invalidKeyPhrase).equals(other$invalidKeyPhrase)) {
                return false;
            }
            StatementPhrase this$notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            StatementPhrase other$notInvalidKeyPhrase = other.getNotInvalidKeyPhrase();
            if (this$notInvalidKeyPhrase == null ? other$notInvalidKeyPhrase != null : !((Object)this$notInvalidKeyPhrase).equals(other$notInvalidKeyPhrase)) {
                return false;
            }
            Word this$endStart = this.getEndStart();
            Word other$endStart = other.getEndStart();
            return !(this$endStart == null ? other$endStart != null : !((Object)this$endStart).equals(other$endStart));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            Word $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : ((Object)$fileName).hashCode());
            StartKey $startKey = this.getStartKey();
            result = result * 59 + ($startKey == null ? 43 : ((Object)$startKey).hashCode());
            StatementPhrase $invalidKeyPhrase = this.getInvalidKeyPhrase();
            result = result * 59 + ($invalidKeyPhrase == null ? 43 : ((Object)$invalidKeyPhrase).hashCode());
            StatementPhrase $notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            result = result * 59 + ($notInvalidKeyPhrase == null ? 43 : ((Object)$notInvalidKeyPhrase).hashCode());
            Word $endStart = this.getEndStart();
            result = result * 59 + ($endStart == null ? 43 : ((Object)$endStart).hashCode());
            return result;
        }

        public Start withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Start(prefix, this.markers, this.start, this.fileName, this.startKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endStart);
        }

        public Start withMarkers(Markers markers) {
            return this.markers == markers ? this : new Start(this.prefix, markers, this.start, this.fileName, this.startKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endStart);
        }

        public Start withStart(Word start) {
            return this.start == start ? this : new Start(this.prefix, this.markers, start, this.fileName, this.startKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endStart);
        }

        public Start withFileName(Word fileName) {
            return this.fileName == fileName ? this : new Start(this.prefix, this.markers, this.start, fileName, this.startKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endStart);
        }

        public Start withStartKey(StartKey startKey) {
            return this.startKey == startKey ? this : new Start(this.prefix, this.markers, this.start, this.fileName, startKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endStart);
        }

        public Start withInvalidKeyPhrase(StatementPhrase invalidKeyPhrase) {
            return this.invalidKeyPhrase == invalidKeyPhrase ? this : new Start(this.prefix, this.markers, this.start, this.fileName, this.startKey, invalidKeyPhrase, this.notInvalidKeyPhrase, this.endStart);
        }

        public Start withNotInvalidKeyPhrase(StatementPhrase notInvalidKeyPhrase) {
            return this.notInvalidKeyPhrase == notInvalidKeyPhrase ? this : new Start(this.prefix, this.markers, this.start, this.fileName, this.startKey, this.invalidKeyPhrase, notInvalidKeyPhrase, this.endStart);
        }

        public Start withEndStart(Word endStart) {
            return this.endStart == endStart ? this : new Start(this.prefix, this.markers, this.start, this.fileName, this.startKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, endStart);
        }
    }

    public static final class SpecialRegister
    implements Cobol,
    Name,
    Identifier {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> words;
        @Nullable
        private final Name identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSpecialRegister(this, p);
        }

        public SpecialRegister(Space prefix, Markers markers, List<Cobol> words, Name identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getWords() {
            return this.words;
        }

        public Name getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.SpecialRegister(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecialRegister)) {
                return false;
            }
            SpecialRegister other = (SpecialRegister)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$words = this.getWords();
            List<Cobol> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$identifier = this.getIdentifier();
            Name other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public SpecialRegister withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SpecialRegister(prefix, this.markers, this.words, this.identifier);
        }

        public SpecialRegister withMarkers(Markers markers) {
            return this.markers == markers ? this : new SpecialRegister(this.prefix, markers, this.words, this.identifier);
        }

        public SpecialRegister withWords(List<Cobol> words) {
            return this.words == words ? this : new SpecialRegister(this.prefix, this.markers, words, this.identifier);
        }

        public SpecialRegister withIdentifier(Name identifier) {
            return this.identifier == identifier ? this : new SpecialRegister(this.prefix, this.markers, this.words, identifier);
        }
    }

    public static final class SpecialNames
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Word dot;
        @Nullable
        private final List<Cobol> clauses;
        @Nullable
        private final Word dot2;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSpecialNames(this, p);
        }

        public SpecialNames(Space prefix, Markers markers, Word word, Word dot, List<Cobol> clauses, Word dot2) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.dot = dot;
            this.clauses = clauses;
            this.dot2 = dot2;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getDot() {
            return this.dot;
        }

        public List<Cobol> getClauses() {
            return this.clauses;
        }

        public Word getDot2() {
            return this.dot2;
        }

        public String toString() {
            return "Cobol.SpecialNames(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", dot=" + this.getDot() + ", clauses=" + this.getClauses() + ", dot2=" + this.getDot2() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecialNames)) {
                return false;
            }
            SpecialNames other = (SpecialNames)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            List<Cobol> this$clauses = this.getClauses();
            List<Cobol> other$clauses = other.getClauses();
            if (this$clauses == null ? other$clauses != null : !((Object)this$clauses).equals(other$clauses)) {
                return false;
            }
            Word this$dot2 = this.getDot2();
            Word other$dot2 = other.getDot2();
            return !(this$dot2 == null ? other$dot2 != null : !((Object)this$dot2).equals(other$dot2));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            List<Cobol> $clauses = this.getClauses();
            result = result * 59 + ($clauses == null ? 43 : ((Object)$clauses).hashCode());
            Word $dot2 = this.getDot2();
            result = result * 59 + ($dot2 == null ? 43 : ((Object)$dot2).hashCode());
            return result;
        }

        public SpecialNames withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SpecialNames(prefix, this.markers, this.word, this.dot, this.clauses, this.dot2);
        }

        public SpecialNames withMarkers(Markers markers) {
            return this.markers == markers ? this : new SpecialNames(this.prefix, markers, this.word, this.dot, this.clauses, this.dot2);
        }

        public SpecialNames withWord(Word word) {
            return this.word == word ? this : new SpecialNames(this.prefix, this.markers, word, this.dot, this.clauses, this.dot2);
        }

        public SpecialNames withDot(Word dot) {
            return this.dot == dot ? this : new SpecialNames(this.prefix, this.markers, this.word, dot, this.clauses, this.dot2);
        }

        public SpecialNames withClauses(List<Cobol> clauses) {
            return this.clauses == clauses ? this : new SpecialNames(this.prefix, this.markers, this.word, this.dot, clauses, this.dot2);
        }

        public SpecialNames withDot2(Word dot2) {
            return this.dot2 == dot2 ? this : new SpecialNames(this.prefix, this.markers, this.word, this.dot, this.clauses, dot2);
        }
    }

    public static final class SourceComputerDefinition
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word computerName;
        @Nullable
        private final List<Word> debuggingMode;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSourceComputerDefinition(this, p);
        }

        public SourceComputerDefinition(Space prefix, Markers markers, Word computerName, List<Word> debuggingMode, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.computerName = computerName;
            this.debuggingMode = debuggingMode;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getComputerName() {
            return this.computerName;
        }

        public List<Word> getDebuggingMode() {
            return this.debuggingMode;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.SourceComputerDefinition(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", computerName=" + this.getComputerName() + ", debuggingMode=" + this.getDebuggingMode() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceComputerDefinition)) {
                return false;
            }
            SourceComputerDefinition other = (SourceComputerDefinition)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$computerName = this.getComputerName();
            Word other$computerName = other.getComputerName();
            if (this$computerName == null ? other$computerName != null : !((Object)this$computerName).equals(other$computerName)) {
                return false;
            }
            List<Word> this$debuggingMode = this.getDebuggingMode();
            List<Word> other$debuggingMode = other.getDebuggingMode();
            if (this$debuggingMode == null ? other$debuggingMode != null : !((Object)this$debuggingMode).equals(other$debuggingMode)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $computerName = this.getComputerName();
            result = result * 59 + ($computerName == null ? 43 : ((Object)$computerName).hashCode());
            List<Word> $debuggingMode = this.getDebuggingMode();
            result = result * 59 + ($debuggingMode == null ? 43 : ((Object)$debuggingMode).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public SourceComputerDefinition withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SourceComputerDefinition(prefix, this.markers, this.computerName, this.debuggingMode, this.dot);
        }

        public SourceComputerDefinition withMarkers(Markers markers) {
            return this.markers == markers ? this : new SourceComputerDefinition(this.prefix, markers, this.computerName, this.debuggingMode, this.dot);
        }

        public SourceComputerDefinition withComputerName(Word computerName) {
            return this.computerName == computerName ? this : new SourceComputerDefinition(this.prefix, this.markers, computerName, this.debuggingMode, this.dot);
        }

        public SourceComputerDefinition withDebuggingMode(List<Word> debuggingMode) {
            return this.debuggingMode == debuggingMode ? this : new SourceComputerDefinition(this.prefix, this.markers, this.computerName, debuggingMode, this.dot);
        }

        public SourceComputerDefinition withDot(Word dot) {
            return this.dot == dot ? this : new SourceComputerDefinition(this.prefix, this.markers, this.computerName, this.debuggingMode, dot);
        }
    }

    public static final class SourceComputer
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final SourceComputerDefinition computer;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSourceComputer(this, p);
        }

        public SourceComputer(Space prefix, Markers markers, List<Word> words, SourceComputerDefinition computer) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.computer = computer;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public SourceComputerDefinition getComputer() {
            return this.computer;
        }

        public String toString() {
            return "Cobol.SourceComputer(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", computer=" + this.getComputer() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceComputer)) {
                return false;
            }
            SourceComputer other = (SourceComputer)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            SourceComputerDefinition this$computer = this.getComputer();
            SourceComputerDefinition other$computer = other.getComputer();
            return !(this$computer == null ? other$computer != null : !((Object)this$computer).equals(other$computer));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            SourceComputerDefinition $computer = this.getComputer();
            result = result * 59 + ($computer == null ? 43 : ((Object)$computer).hashCode());
            return result;
        }

        public SourceComputer withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SourceComputer(prefix, this.markers, this.words, this.computer);
        }

        public SourceComputer withMarkers(Markers markers) {
            return this.markers == markers ? this : new SourceComputer(this.prefix, markers, this.words, this.computer);
        }

        public SourceComputer withWords(List<Word> words) {
            return this.words == words ? this : new SourceComputer(this.prefix, this.markers, words, this.computer);
        }

        public SourceComputer withComputer(SourceComputerDefinition computer) {
            return this.computer == computer ? this : new SourceComputer(this.prefix, this.markers, this.words, computer);
        }
    }

    public static final class SortProcedurePhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name procedureName;
        @Nullable
        private final Sortable sortInputThrough;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSortProcedurePhrase(this, p);
        }

        public SortProcedurePhrase(Space prefix, Markers markers, List<Word> words, Name procedureName, Sortable sortInputThrough) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.procedureName = procedureName;
            this.sortInputThrough = sortInputThrough;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getProcedureName() {
            return this.procedureName;
        }

        public Sortable getSortInputThrough() {
            return this.sortInputThrough;
        }

        public String toString() {
            return "Cobol.SortProcedurePhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", procedureName=" + this.getProcedureName() + ", sortInputThrough=" + this.getSortInputThrough() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortProcedurePhrase)) {
                return false;
            }
            SortProcedurePhrase other = (SortProcedurePhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$procedureName = this.getProcedureName();
            Name other$procedureName = other.getProcedureName();
            if (this$procedureName == null ? other$procedureName != null : !this$procedureName.equals(other$procedureName)) {
                return false;
            }
            Sortable this$sortInputThrough = this.getSortInputThrough();
            Sortable other$sortInputThrough = other.getSortInputThrough();
            return !(this$sortInputThrough == null ? other$sortInputThrough != null : !((Object)this$sortInputThrough).equals(other$sortInputThrough));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $procedureName = this.getProcedureName();
            result = result * 59 + ($procedureName == null ? 43 : $procedureName.hashCode());
            Sortable $sortInputThrough = this.getSortInputThrough();
            result = result * 59 + ($sortInputThrough == null ? 43 : ((Object)$sortInputThrough).hashCode());
            return result;
        }

        public SortProcedurePhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SortProcedurePhrase(prefix, this.markers, this.words, this.procedureName, this.sortInputThrough);
        }

        public SortProcedurePhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new SortProcedurePhrase(this.prefix, markers, this.words, this.procedureName, this.sortInputThrough);
        }

        public SortProcedurePhrase withWords(List<Word> words) {
            return this.words == words ? this : new SortProcedurePhrase(this.prefix, this.markers, words, this.procedureName, this.sortInputThrough);
        }

        public SortProcedurePhrase withProcedureName(Name procedureName) {
            return this.procedureName == procedureName ? this : new SortProcedurePhrase(this.prefix, this.markers, this.words, procedureName, this.sortInputThrough);
        }

        public SortProcedurePhrase withSortInputThrough(Sortable sortInputThrough) {
            return this.sortInputThrough == sortInputThrough ? this : new SortProcedurePhrase(this.prefix, this.markers, this.words, this.procedureName, sortInputThrough);
        }
    }

    public static final class SortGiving
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word fileName;
        @Nullable
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSortGiving(this, p);
        }

        public SortGiving(Space prefix, Markers markers, Word fileName, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.fileName = fileName;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getFileName() {
            return this.fileName;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.SortGiving(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", fileName=" + this.getFileName() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortGiving)) {
                return false;
            }
            SortGiving other = (SortGiving)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$fileName = this.getFileName();
            Word other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !((Object)this$fileName).equals(other$fileName)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : ((Object)$fileName).hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public SortGiving withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SortGiving(prefix, this.markers, this.fileName, this.words);
        }

        public SortGiving withMarkers(Markers markers) {
            return this.markers == markers ? this : new SortGiving(this.prefix, markers, this.fileName, this.words);
        }

        public SortGiving withFileName(Word fileName) {
            return this.fileName == fileName ? this : new SortGiving(this.prefix, this.markers, fileName, this.words);
        }

        public SortGiving withWords(List<Word> words) {
            return this.words == words ? this : new SortGiving(this.prefix, this.markers, this.fileName, words);
        }
    }

    public static final class SortCollatingSequencePhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Word> alphabetNames;
        @Nullable
        private final Sortable sortCollatingAlphanumeric;
        @Nullable
        private final Sortable sortCollatingNational;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSortCollatingSequencePhrase(this, p);
        }

        public SortCollatingSequencePhrase(Space prefix, Markers markers, List<Word> words, List<Word> alphabetNames, Sortable sortCollatingAlphanumeric, Sortable sortCollatingNational) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.alphabetNames = alphabetNames;
            this.sortCollatingAlphanumeric = sortCollatingAlphanumeric;
            this.sortCollatingNational = sortCollatingNational;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Word> getAlphabetNames() {
            return this.alphabetNames;
        }

        public Sortable getSortCollatingAlphanumeric() {
            return this.sortCollatingAlphanumeric;
        }

        public Sortable getSortCollatingNational() {
            return this.sortCollatingNational;
        }

        public String toString() {
            return "Cobol.SortCollatingSequencePhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", alphabetNames=" + this.getAlphabetNames() + ", sortCollatingAlphanumeric=" + this.getSortCollatingAlphanumeric() + ", sortCollatingNational=" + this.getSortCollatingNational() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortCollatingSequencePhrase)) {
                return false;
            }
            SortCollatingSequencePhrase other = (SortCollatingSequencePhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Word> this$alphabetNames = this.getAlphabetNames();
            List<Word> other$alphabetNames = other.getAlphabetNames();
            if (this$alphabetNames == null ? other$alphabetNames != null : !((Object)this$alphabetNames).equals(other$alphabetNames)) {
                return false;
            }
            Sortable this$sortCollatingAlphanumeric = this.getSortCollatingAlphanumeric();
            Sortable other$sortCollatingAlphanumeric = other.getSortCollatingAlphanumeric();
            if (this$sortCollatingAlphanumeric == null ? other$sortCollatingAlphanumeric != null : !((Object)this$sortCollatingAlphanumeric).equals(other$sortCollatingAlphanumeric)) {
                return false;
            }
            Sortable this$sortCollatingNational = this.getSortCollatingNational();
            Sortable other$sortCollatingNational = other.getSortCollatingNational();
            return !(this$sortCollatingNational == null ? other$sortCollatingNational != null : !((Object)this$sortCollatingNational).equals(other$sortCollatingNational));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Word> $alphabetNames = this.getAlphabetNames();
            result = result * 59 + ($alphabetNames == null ? 43 : ((Object)$alphabetNames).hashCode());
            Sortable $sortCollatingAlphanumeric = this.getSortCollatingAlphanumeric();
            result = result * 59 + ($sortCollatingAlphanumeric == null ? 43 : ((Object)$sortCollatingAlphanumeric).hashCode());
            Sortable $sortCollatingNational = this.getSortCollatingNational();
            result = result * 59 + ($sortCollatingNational == null ? 43 : ((Object)$sortCollatingNational).hashCode());
            return result;
        }

        public SortCollatingSequencePhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SortCollatingSequencePhrase(prefix, this.markers, this.words, this.alphabetNames, this.sortCollatingAlphanumeric, this.sortCollatingNational);
        }

        public SortCollatingSequencePhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new SortCollatingSequencePhrase(this.prefix, markers, this.words, this.alphabetNames, this.sortCollatingAlphanumeric, this.sortCollatingNational);
        }

        public SortCollatingSequencePhrase withWords(List<Word> words) {
            return this.words == words ? this : new SortCollatingSequencePhrase(this.prefix, this.markers, words, this.alphabetNames, this.sortCollatingAlphanumeric, this.sortCollatingNational);
        }

        public SortCollatingSequencePhrase withAlphabetNames(List<Word> alphabetNames) {
            return this.alphabetNames == alphabetNames ? this : new SortCollatingSequencePhrase(this.prefix, this.markers, this.words, alphabetNames, this.sortCollatingAlphanumeric, this.sortCollatingNational);
        }

        public SortCollatingSequencePhrase withSortCollatingAlphanumeric(Sortable sortCollatingAlphanumeric) {
            return this.sortCollatingAlphanumeric == sortCollatingAlphanumeric ? this : new SortCollatingSequencePhrase(this.prefix, this.markers, this.words, this.alphabetNames, sortCollatingAlphanumeric, this.sortCollatingNational);
        }

        public SortCollatingSequencePhrase withSortCollatingNational(Sortable sortCollatingNational) {
            return this.sortCollatingNational == sortCollatingNational ? this : new SortCollatingSequencePhrase(this.prefix, this.markers, this.words, this.alphabetNames, this.sortCollatingAlphanumeric, sortCollatingNational);
        }
    }

    public static final class Sortable
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Cobol> names;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSortable(this, p);
        }

        public Sortable(Space prefix, Markers markers, List<Word> words, List<Cobol> names) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.names = names;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Cobol> getNames() {
            return this.names;
        }

        public String toString() {
            return "Cobol.Sortable(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", names=" + this.getNames() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sortable)) {
                return false;
            }
            Sortable other = (Sortable)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Cobol> this$names = this.getNames();
            List<Cobol> other$names = other.getNames();
            return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Cobol> $names = this.getNames();
            result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
            return result;
        }

        public Sortable withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Sortable(prefix, this.markers, this.words, this.names);
        }

        public Sortable withMarkers(Markers markers) {
            return this.markers == markers ? this : new Sortable(this.prefix, markers, this.words, this.names);
        }

        public Sortable withWords(List<Word> words) {
            return this.words == words ? this : new Sortable(this.prefix, this.markers, words, this.names);
        }

        public Sortable withNames(List<Cobol> names) {
            return this.names == names ? this : new Sortable(this.prefix, this.markers, this.words, names);
        }
    }

    public static final class Sort
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word sort;
        private final Word fileName;
        private final List<Sortable> sortOnKeyClause;
        @Nullable
        private final Sortable sortDuplicatesPhrase;
        private final SortCollatingSequencePhrase sortCollatingSequencePhrase;
        private final SortProcedurePhrase sortInputProcedurePhrase;
        private final List<Sortable> sortUsing;
        @Nullable
        private final SortProcedurePhrase sortOutputProcedurePhrase;
        private final List<Sortable> sortGiving;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSort(this, p);
        }

        public Sort(Space prefix, Markers markers, Word sort, Word fileName, List<Sortable> sortOnKeyClause, Sortable sortDuplicatesPhrase, SortCollatingSequencePhrase sortCollatingSequencePhrase, SortProcedurePhrase sortInputProcedurePhrase, List<Sortable> sortUsing, SortProcedurePhrase sortOutputProcedurePhrase, List<Sortable> sortGiving) {
            this.prefix = prefix;
            this.markers = markers;
            this.sort = sort;
            this.fileName = fileName;
            this.sortOnKeyClause = sortOnKeyClause;
            this.sortDuplicatesPhrase = sortDuplicatesPhrase;
            this.sortCollatingSequencePhrase = sortCollatingSequencePhrase;
            this.sortInputProcedurePhrase = sortInputProcedurePhrase;
            this.sortUsing = sortUsing;
            this.sortOutputProcedurePhrase = sortOutputProcedurePhrase;
            this.sortGiving = sortGiving;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getSort() {
            return this.sort;
        }

        public Word getFileName() {
            return this.fileName;
        }

        public List<Sortable> getSortOnKeyClause() {
            return this.sortOnKeyClause;
        }

        public Sortable getSortDuplicatesPhrase() {
            return this.sortDuplicatesPhrase;
        }

        public SortCollatingSequencePhrase getSortCollatingSequencePhrase() {
            return this.sortCollatingSequencePhrase;
        }

        public SortProcedurePhrase getSortInputProcedurePhrase() {
            return this.sortInputProcedurePhrase;
        }

        public List<Sortable> getSortUsing() {
            return this.sortUsing;
        }

        public SortProcedurePhrase getSortOutputProcedurePhrase() {
            return this.sortOutputProcedurePhrase;
        }

        public List<Sortable> getSortGiving() {
            return this.sortGiving;
        }

        public String toString() {
            return "Cobol.Sort(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sort=" + this.getSort() + ", fileName=" + this.getFileName() + ", sortOnKeyClause=" + this.getSortOnKeyClause() + ", sortDuplicatesPhrase=" + this.getSortDuplicatesPhrase() + ", sortCollatingSequencePhrase=" + this.getSortCollatingSequencePhrase() + ", sortInputProcedurePhrase=" + this.getSortInputProcedurePhrase() + ", sortUsing=" + this.getSortUsing() + ", sortOutputProcedurePhrase=" + this.getSortOutputProcedurePhrase() + ", sortGiving=" + this.getSortGiving() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sort)) {
                return false;
            }
            Sort other = (Sort)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$sort = this.getSort();
            Word other$sort = other.getSort();
            if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
                return false;
            }
            Word this$fileName = this.getFileName();
            Word other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !((Object)this$fileName).equals(other$fileName)) {
                return false;
            }
            List<Sortable> this$sortOnKeyClause = this.getSortOnKeyClause();
            List<Sortable> other$sortOnKeyClause = other.getSortOnKeyClause();
            if (this$sortOnKeyClause == null ? other$sortOnKeyClause != null : !((Object)this$sortOnKeyClause).equals(other$sortOnKeyClause)) {
                return false;
            }
            Sortable this$sortDuplicatesPhrase = this.getSortDuplicatesPhrase();
            Sortable other$sortDuplicatesPhrase = other.getSortDuplicatesPhrase();
            if (this$sortDuplicatesPhrase == null ? other$sortDuplicatesPhrase != null : !((Object)this$sortDuplicatesPhrase).equals(other$sortDuplicatesPhrase)) {
                return false;
            }
            SortCollatingSequencePhrase this$sortCollatingSequencePhrase = this.getSortCollatingSequencePhrase();
            SortCollatingSequencePhrase other$sortCollatingSequencePhrase = other.getSortCollatingSequencePhrase();
            if (this$sortCollatingSequencePhrase == null ? other$sortCollatingSequencePhrase != null : !((Object)this$sortCollatingSequencePhrase).equals(other$sortCollatingSequencePhrase)) {
                return false;
            }
            SortProcedurePhrase this$sortInputProcedurePhrase = this.getSortInputProcedurePhrase();
            SortProcedurePhrase other$sortInputProcedurePhrase = other.getSortInputProcedurePhrase();
            if (this$sortInputProcedurePhrase == null ? other$sortInputProcedurePhrase != null : !((Object)this$sortInputProcedurePhrase).equals(other$sortInputProcedurePhrase)) {
                return false;
            }
            List<Sortable> this$sortUsing = this.getSortUsing();
            List<Sortable> other$sortUsing = other.getSortUsing();
            if (this$sortUsing == null ? other$sortUsing != null : !((Object)this$sortUsing).equals(other$sortUsing)) {
                return false;
            }
            SortProcedurePhrase this$sortOutputProcedurePhrase = this.getSortOutputProcedurePhrase();
            SortProcedurePhrase other$sortOutputProcedurePhrase = other.getSortOutputProcedurePhrase();
            if (this$sortOutputProcedurePhrase == null ? other$sortOutputProcedurePhrase != null : !((Object)this$sortOutputProcedurePhrase).equals(other$sortOutputProcedurePhrase)) {
                return false;
            }
            List<Sortable> this$sortGiving = this.getSortGiving();
            List<Sortable> other$sortGiving = other.getSortGiving();
            return !(this$sortGiving == null ? other$sortGiving != null : !((Object)this$sortGiving).equals(other$sortGiving));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $sort = this.getSort();
            result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
            Word $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : ((Object)$fileName).hashCode());
            List<Sortable> $sortOnKeyClause = this.getSortOnKeyClause();
            result = result * 59 + ($sortOnKeyClause == null ? 43 : ((Object)$sortOnKeyClause).hashCode());
            Sortable $sortDuplicatesPhrase = this.getSortDuplicatesPhrase();
            result = result * 59 + ($sortDuplicatesPhrase == null ? 43 : ((Object)$sortDuplicatesPhrase).hashCode());
            SortCollatingSequencePhrase $sortCollatingSequencePhrase = this.getSortCollatingSequencePhrase();
            result = result * 59 + ($sortCollatingSequencePhrase == null ? 43 : ((Object)$sortCollatingSequencePhrase).hashCode());
            SortProcedurePhrase $sortInputProcedurePhrase = this.getSortInputProcedurePhrase();
            result = result * 59 + ($sortInputProcedurePhrase == null ? 43 : ((Object)$sortInputProcedurePhrase).hashCode());
            List<Sortable> $sortUsing = this.getSortUsing();
            result = result * 59 + ($sortUsing == null ? 43 : ((Object)$sortUsing).hashCode());
            SortProcedurePhrase $sortOutputProcedurePhrase = this.getSortOutputProcedurePhrase();
            result = result * 59 + ($sortOutputProcedurePhrase == null ? 43 : ((Object)$sortOutputProcedurePhrase).hashCode());
            List<Sortable> $sortGiving = this.getSortGiving();
            result = result * 59 + ($sortGiving == null ? 43 : ((Object)$sortGiving).hashCode());
            return result;
        }

        public Sort withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Sort(prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withMarkers(Markers markers) {
            return this.markers == markers ? this : new Sort(this.prefix, markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSort(Word sort) {
            return this.sort == sort ? this : new Sort(this.prefix, this.markers, sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withFileName(Word fileName) {
            return this.fileName == fileName ? this : new Sort(this.prefix, this.markers, this.sort, fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortOnKeyClause(List<Sortable> sortOnKeyClause) {
            return this.sortOnKeyClause == sortOnKeyClause ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortDuplicatesPhrase(Sortable sortDuplicatesPhrase) {
            return this.sortDuplicatesPhrase == sortDuplicatesPhrase ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortCollatingSequencePhrase(SortCollatingSequencePhrase sortCollatingSequencePhrase) {
            return this.sortCollatingSequencePhrase == sortCollatingSequencePhrase ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortInputProcedurePhrase(SortProcedurePhrase sortInputProcedurePhrase) {
            return this.sortInputProcedurePhrase == sortInputProcedurePhrase ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortUsing(List<Sortable> sortUsing) {
            return this.sortUsing == sortUsing ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, sortUsing, this.sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortOutputProcedurePhrase(SortProcedurePhrase sortOutputProcedurePhrase) {
            return this.sortOutputProcedurePhrase == sortOutputProcedurePhrase ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, sortOutputProcedurePhrase, this.sortGiving);
        }

        public Sort withSortGiving(List<Sortable> sortGiving) {
            return this.sortGiving == sortGiving ? this : new Sort(this.prefix, this.markers, this.sort, this.fileName, this.sortOnKeyClause, this.sortDuplicatesPhrase, this.sortCollatingSequencePhrase, this.sortInputProcedurePhrase, this.sortUsing, this.sortOutputProcedurePhrase, sortGiving);
        }
    }

    public static final class SetUpDown
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> to;
        private final List<Word> operation;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSetUpDown(this, p);
        }

        public SetUpDown(Space prefix, Markers markers, List<Cobol> to, List<Word> operation, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.to = to;
            this.operation = operation;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getTo() {
            return this.to;
        }

        public List<Word> getOperation() {
            return this.operation;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.SetUpDown(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", to=" + this.getTo() + ", operation=" + this.getOperation() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetUpDown)) {
                return false;
            }
            SetUpDown other = (SetUpDown)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$to = this.getTo();
            List<Cobol> other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
                return false;
            }
            List<Word> this$operation = this.getOperation();
            List<Word> other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !((Object)this$operation).equals(other$operation)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            List<Word> $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : ((Object)$operation).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public SetUpDown withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SetUpDown(prefix, this.markers, this.to, this.operation, this.value);
        }

        public SetUpDown withMarkers(Markers markers) {
            return this.markers == markers ? this : new SetUpDown(this.prefix, markers, this.to, this.operation, this.value);
        }

        public SetUpDown withTo(List<Cobol> to) {
            return this.to == to ? this : new SetUpDown(this.prefix, this.markers, to, this.operation, this.value);
        }

        public SetUpDown withOperation(List<Word> operation) {
            return this.operation == operation ? this : new SetUpDown(this.prefix, this.markers, this.to, operation, this.value);
        }

        public SetUpDown withValue(Name value) {
            return this.value == value ? this : new SetUpDown(this.prefix, this.markers, this.to, this.operation, value);
        }
    }

    public static final class SetTo
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> identifiers;
        private final Word to;
        private final List<Cobol> values;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSetTo(this, p);
        }

        public SetTo(Space prefix, Markers markers, List<Cobol> identifiers, Word to, List<Cobol> values) {
            this.prefix = prefix;
            this.markers = markers;
            this.identifiers = identifiers;
            this.to = to;
            this.values = values;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getIdentifiers() {
            return this.identifiers;
        }

        public Word getTo() {
            return this.to;
        }

        public List<Cobol> getValues() {
            return this.values;
        }

        public String toString() {
            return "Cobol.SetTo(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", identifiers=" + this.getIdentifiers() + ", to=" + this.getTo() + ", values=" + this.getValues() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetTo)) {
                return false;
            }
            SetTo other = (SetTo)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$identifiers = this.getIdentifiers();
            List<Cobol> other$identifiers = other.getIdentifiers();
            if (this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers)) {
                return false;
            }
            Word this$to = this.getTo();
            Word other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
                return false;
            }
            List<Cobol> this$values = this.getValues();
            List<Cobol> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $identifiers = this.getIdentifiers();
            result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
            Word $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            List<Cobol> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public SetTo withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SetTo(prefix, this.markers, this.identifiers, this.to, this.values);
        }

        public SetTo withMarkers(Markers markers) {
            return this.markers == markers ? this : new SetTo(this.prefix, markers, this.identifiers, this.to, this.values);
        }

        public SetTo withIdentifiers(List<Cobol> identifiers) {
            return this.identifiers == identifiers ? this : new SetTo(this.prefix, this.markers, identifiers, this.to, this.values);
        }

        public SetTo withTo(Word to) {
            return this.to == to ? this : new SetTo(this.prefix, this.markers, this.identifiers, to, this.values);
        }

        public SetTo withValues(List<Cobol> values) {
            return this.values == values ? this : new SetTo(this.prefix, this.markers, this.identifiers, this.to, values);
        }
    }

    public static final class Set
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word set;
        @Nullable
        private final List<SetTo> to;
        @Nullable
        private final SetUpDown upDown;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSet(this, p);
        }

        public Set(Space prefix, Markers markers, Word set, List<SetTo> to, SetUpDown upDown) {
            this.prefix = prefix;
            this.markers = markers;
            this.set = set;
            this.to = to;
            this.upDown = upDown;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getSet() {
            return this.set;
        }

        public List<SetTo> getTo() {
            return this.to;
        }

        public SetUpDown getUpDown() {
            return this.upDown;
        }

        public String toString() {
            return "Cobol.Set(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", set=" + this.getSet() + ", to=" + this.getTo() + ", upDown=" + this.getUpDown() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set other = (Set)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$set = this.getSet();
            Word other$set = other.getSet();
            if (this$set == null ? other$set != null : !((Object)this$set).equals(other$set)) {
                return false;
            }
            List<SetTo> this$to = this.getTo();
            List<SetTo> other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
                return false;
            }
            SetUpDown this$upDown = this.getUpDown();
            SetUpDown other$upDown = other.getUpDown();
            return !(this$upDown == null ? other$upDown != null : !((Object)this$upDown).equals(other$upDown));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $set = this.getSet();
            result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
            List<SetTo> $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            SetUpDown $upDown = this.getUpDown();
            result = result * 59 + ($upDown == null ? 43 : ((Object)$upDown).hashCode());
            return result;
        }

        public Set withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Set(prefix, this.markers, this.set, this.to, this.upDown);
        }

        public Set withMarkers(Markers markers) {
            return this.markers == markers ? this : new Set(this.prefix, markers, this.set, this.to, this.upDown);
        }

        public Set withSet(Word set) {
            return this.set == set ? this : new Set(this.prefix, this.markers, set, this.to, this.upDown);
        }

        public Set withTo(List<SetTo> to) {
            return this.to == to ? this : new Set(this.prefix, this.markers, this.set, to, this.upDown);
        }

        public Set withUpDown(SetUpDown upDown) {
            return this.upDown == upDown ? this : new Set(this.prefix, this.markers, this.set, this.to, upDown);
        }
    }

    public static final class Sentence
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Statement> statements;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSentence(this, p);
        }

        public Sentence(Space prefix, Markers markers, List<Statement> statements, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.statements = statements;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.Sentence(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", statements=" + this.getStatements() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sentence)) {
                return false;
            }
            Sentence other = (Sentence)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Statement> this$statements = this.getStatements();
            List<Statement> other$statements = other.getStatements();
            if (this$statements == null ? other$statements != null : !((Object)this$statements).equals(other$statements)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Statement> $statements = this.getStatements();
            result = result * 59 + ($statements == null ? 43 : ((Object)$statements).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public Sentence withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Sentence(prefix, this.markers, this.statements, this.dot);
        }

        public Sentence withMarkers(Markers markers) {
            return this.markers == markers ? this : new Sentence(this.prefix, markers, this.statements, this.dot);
        }

        public Sentence withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new Sentence(this.prefix, this.markers, statements, this.dot);
        }

        public Sentence withDot(Word dot) {
            return this.dot == dot ? this : new Sentence(this.prefix, this.markers, this.statements, dot);
        }
    }

    public static final class SendStatementSync
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        @Nullable
        private final SendPhrase sendFromPhrase;
        @Nullable
        private final SendPhrase sendWithPhrase;
        @Nullable
        private final SendPhrase sendReplacingPhrase;
        @Nullable
        private final SendPhrase sendAdvancingPhrase;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSendStatementSync(this, p);
        }

        public SendStatementSync(Space prefix, Markers markers, Name name, SendPhrase sendFromPhrase, SendPhrase sendWithPhrase, SendPhrase sendReplacingPhrase, SendPhrase sendAdvancingPhrase) {
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.sendFromPhrase = sendFromPhrase;
            this.sendWithPhrase = sendWithPhrase;
            this.sendReplacingPhrase = sendReplacingPhrase;
            this.sendAdvancingPhrase = sendAdvancingPhrase;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public SendPhrase getSendFromPhrase() {
            return this.sendFromPhrase;
        }

        public SendPhrase getSendWithPhrase() {
            return this.sendWithPhrase;
        }

        public SendPhrase getSendReplacingPhrase() {
            return this.sendReplacingPhrase;
        }

        public SendPhrase getSendAdvancingPhrase() {
            return this.sendAdvancingPhrase;
        }

        public String toString() {
            return "Cobol.SendStatementSync(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", sendFromPhrase=" + this.getSendFromPhrase() + ", sendWithPhrase=" + this.getSendWithPhrase() + ", sendReplacingPhrase=" + this.getSendReplacingPhrase() + ", sendAdvancingPhrase=" + this.getSendAdvancingPhrase() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendStatementSync)) {
                return false;
            }
            SendStatementSync other = (SendStatementSync)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            SendPhrase this$sendFromPhrase = this.getSendFromPhrase();
            SendPhrase other$sendFromPhrase = other.getSendFromPhrase();
            if (this$sendFromPhrase == null ? other$sendFromPhrase != null : !((Object)this$sendFromPhrase).equals(other$sendFromPhrase)) {
                return false;
            }
            SendPhrase this$sendWithPhrase = this.getSendWithPhrase();
            SendPhrase other$sendWithPhrase = other.getSendWithPhrase();
            if (this$sendWithPhrase == null ? other$sendWithPhrase != null : !((Object)this$sendWithPhrase).equals(other$sendWithPhrase)) {
                return false;
            }
            SendPhrase this$sendReplacingPhrase = this.getSendReplacingPhrase();
            SendPhrase other$sendReplacingPhrase = other.getSendReplacingPhrase();
            if (this$sendReplacingPhrase == null ? other$sendReplacingPhrase != null : !((Object)this$sendReplacingPhrase).equals(other$sendReplacingPhrase)) {
                return false;
            }
            SendPhrase this$sendAdvancingPhrase = this.getSendAdvancingPhrase();
            SendPhrase other$sendAdvancingPhrase = other.getSendAdvancingPhrase();
            return !(this$sendAdvancingPhrase == null ? other$sendAdvancingPhrase != null : !((Object)this$sendAdvancingPhrase).equals(other$sendAdvancingPhrase));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            SendPhrase $sendFromPhrase = this.getSendFromPhrase();
            result = result * 59 + ($sendFromPhrase == null ? 43 : ((Object)$sendFromPhrase).hashCode());
            SendPhrase $sendWithPhrase = this.getSendWithPhrase();
            result = result * 59 + ($sendWithPhrase == null ? 43 : ((Object)$sendWithPhrase).hashCode());
            SendPhrase $sendReplacingPhrase = this.getSendReplacingPhrase();
            result = result * 59 + ($sendReplacingPhrase == null ? 43 : ((Object)$sendReplacingPhrase).hashCode());
            SendPhrase $sendAdvancingPhrase = this.getSendAdvancingPhrase();
            result = result * 59 + ($sendAdvancingPhrase == null ? 43 : ((Object)$sendAdvancingPhrase).hashCode());
            return result;
        }

        public SendStatementSync withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SendStatementSync(prefix, this.markers, this.name, this.sendFromPhrase, this.sendWithPhrase, this.sendReplacingPhrase, this.sendAdvancingPhrase);
        }

        public SendStatementSync withMarkers(Markers markers) {
            return this.markers == markers ? this : new SendStatementSync(this.prefix, markers, this.name, this.sendFromPhrase, this.sendWithPhrase, this.sendReplacingPhrase, this.sendAdvancingPhrase);
        }

        public SendStatementSync withName(Name name) {
            return this.name == name ? this : new SendStatementSync(this.prefix, this.markers, name, this.sendFromPhrase, this.sendWithPhrase, this.sendReplacingPhrase, this.sendAdvancingPhrase);
        }

        public SendStatementSync withSendFromPhrase(SendPhrase sendFromPhrase) {
            return this.sendFromPhrase == sendFromPhrase ? this : new SendStatementSync(this.prefix, this.markers, this.name, sendFromPhrase, this.sendWithPhrase, this.sendReplacingPhrase, this.sendAdvancingPhrase);
        }

        public SendStatementSync withSendWithPhrase(SendPhrase sendWithPhrase) {
            return this.sendWithPhrase == sendWithPhrase ? this : new SendStatementSync(this.prefix, this.markers, this.name, this.sendFromPhrase, sendWithPhrase, this.sendReplacingPhrase, this.sendAdvancingPhrase);
        }

        public SendStatementSync withSendReplacingPhrase(SendPhrase sendReplacingPhrase) {
            return this.sendReplacingPhrase == sendReplacingPhrase ? this : new SendStatementSync(this.prefix, this.markers, this.name, this.sendFromPhrase, this.sendWithPhrase, sendReplacingPhrase, this.sendAdvancingPhrase);
        }

        public SendStatementSync withSendAdvancingPhrase(SendPhrase sendAdvancingPhrase) {
            return this.sendAdvancingPhrase == sendAdvancingPhrase ? this : new SendStatementSync(this.prefix, this.markers, this.name, this.sendFromPhrase, this.sendWithPhrase, this.sendReplacingPhrase, sendAdvancingPhrase);
        }
    }

    public static final class SendPhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Cobol target;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSendPhrase(this, p);
        }

        public SendPhrase(Space prefix, Markers markers, List<Word> words, Cobol target) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.target = target;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getTarget() {
            return this.target;
        }

        public String toString() {
            return "Cobol.SendPhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", target=" + this.getTarget() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendPhrase)) {
                return false;
            }
            SendPhrase other = (SendPhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$target = this.getTarget();
            Cobol other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        public SendPhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SendPhrase(prefix, this.markers, this.words, this.target);
        }

        public SendPhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new SendPhrase(this.prefix, markers, this.words, this.target);
        }

        public SendPhrase withWords(List<Word> words) {
            return this.words == words ? this : new SendPhrase(this.prefix, this.markers, words, this.target);
        }

        public SendPhrase withTarget(Cobol target) {
            return this.target == target ? this : new SendPhrase(this.prefix, this.markers, this.words, target);
        }
    }

    public static final class SendAdvancingLines
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        @Nullable
        private final Word lines;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSendAdvancingLines(this, p);
        }

        public SendAdvancingLines(Space prefix, Markers markers, Name name, Word lines) {
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.lines = lines;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public Word getLines() {
            return this.lines;
        }

        public String toString() {
            return "Cobol.SendAdvancingLines(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", lines=" + this.getLines() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendAdvancingLines)) {
                return false;
            }
            SendAdvancingLines other = (SendAdvancingLines)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Word this$lines = this.getLines();
            Word other$lines = other.getLines();
            return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Word $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            return result;
        }

        public SendAdvancingLines withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SendAdvancingLines(prefix, this.markers, this.name, this.lines);
        }

        public SendAdvancingLines withMarkers(Markers markers) {
            return this.markers == markers ? this : new SendAdvancingLines(this.prefix, markers, this.name, this.lines);
        }

        public SendAdvancingLines withName(Name name) {
            return this.name == name ? this : new SendAdvancingLines(this.prefix, this.markers, name, this.lines);
        }

        public SendAdvancingLines withLines(Word lines) {
            return this.lines == lines ? this : new SendAdvancingLines(this.prefix, this.markers, this.name, lines);
        }
    }

    public static final class Send
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word send;
        private final Cobol statement;
        @Nullable
        private final StatementPhrase onExceptionClause;
        @Nullable
        private final StatementPhrase notOnExceptionClause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSend(this, p);
        }

        public Send(Space prefix, Markers markers, Word send, Cobol statement, StatementPhrase onExceptionClause, StatementPhrase notOnExceptionClause) {
            this.prefix = prefix;
            this.markers = markers;
            this.send = send;
            this.statement = statement;
            this.onExceptionClause = onExceptionClause;
            this.notOnExceptionClause = notOnExceptionClause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getSend() {
            return this.send;
        }

        public Cobol getStatement() {
            return this.statement;
        }

        public StatementPhrase getOnExceptionClause() {
            return this.onExceptionClause;
        }

        public StatementPhrase getNotOnExceptionClause() {
            return this.notOnExceptionClause;
        }

        public String toString() {
            return "Cobol.Send(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", send=" + this.getSend() + ", statement=" + this.getStatement() + ", onExceptionClause=" + this.getOnExceptionClause() + ", notOnExceptionClause=" + this.getNotOnExceptionClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Send)) {
                return false;
            }
            Send other = (Send)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$send = this.getSend();
            Word other$send = other.getSend();
            if (this$send == null ? other$send != null : !((Object)this$send).equals(other$send)) {
                return false;
            }
            Cobol this$statement = this.getStatement();
            Cobol other$statement = other.getStatement();
            if (this$statement == null ? other$statement != null : !this$statement.equals(other$statement)) {
                return false;
            }
            StatementPhrase this$onExceptionClause = this.getOnExceptionClause();
            StatementPhrase other$onExceptionClause = other.getOnExceptionClause();
            if (this$onExceptionClause == null ? other$onExceptionClause != null : !((Object)this$onExceptionClause).equals(other$onExceptionClause)) {
                return false;
            }
            StatementPhrase this$notOnExceptionClause = this.getNotOnExceptionClause();
            StatementPhrase other$notOnExceptionClause = other.getNotOnExceptionClause();
            return !(this$notOnExceptionClause == null ? other$notOnExceptionClause != null : !((Object)this$notOnExceptionClause).equals(other$notOnExceptionClause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $send = this.getSend();
            result = result * 59 + ($send == null ? 43 : ((Object)$send).hashCode());
            Cobol $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            StatementPhrase $onExceptionClause = this.getOnExceptionClause();
            result = result * 59 + ($onExceptionClause == null ? 43 : ((Object)$onExceptionClause).hashCode());
            StatementPhrase $notOnExceptionClause = this.getNotOnExceptionClause();
            result = result * 59 + ($notOnExceptionClause == null ? 43 : ((Object)$notOnExceptionClause).hashCode());
            return result;
        }

        public Send withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Send(prefix, this.markers, this.send, this.statement, this.onExceptionClause, this.notOnExceptionClause);
        }

        public Send withMarkers(Markers markers) {
            return this.markers == markers ? this : new Send(this.prefix, markers, this.send, this.statement, this.onExceptionClause, this.notOnExceptionClause);
        }

        public Send withSend(Word send) {
            return this.send == send ? this : new Send(this.prefix, this.markers, send, this.statement, this.onExceptionClause, this.notOnExceptionClause);
        }

        public Send withStatement(Cobol statement) {
            return this.statement == statement ? this : new Send(this.prefix, this.markers, this.send, statement, this.onExceptionClause, this.notOnExceptionClause);
        }

        public Send withOnExceptionClause(StatementPhrase onExceptionClause) {
            return this.onExceptionClause == onExceptionClause ? this : new Send(this.prefix, this.markers, this.send, this.statement, onExceptionClause, this.notOnExceptionClause);
        }

        public Send withNotOnExceptionClause(StatementPhrase notOnExceptionClause) {
            return this.notOnExceptionClause == notOnExceptionClause ? this : new Send(this.prefix, this.markers, this.send, this.statement, this.onExceptionClause, notOnExceptionClause);
        }
    }

    public static final class SelectClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word fileName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSelectClause(this, p);
        }

        public SelectClause(Space prefix, Markers markers, List<Word> words, Word fileName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.fileName = fileName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getFileName() {
            return this.fileName;
        }

        public String toString() {
            return "Cobol.SelectClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", fileName=" + this.getFileName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectClause)) {
                return false;
            }
            SelectClause other = (SelectClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$fileName = this.getFileName();
            Word other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !((Object)this$fileName).equals(other$fileName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : ((Object)$fileName).hashCode());
            return result;
        }

        public SelectClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SelectClause(prefix, this.markers, this.words, this.fileName);
        }

        public SelectClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SelectClause(this.prefix, markers, this.words, this.fileName);
        }

        public SelectClause withWords(List<Word> words) {
            return this.words == words ? this : new SelectClause(this.prefix, this.markers, words, this.fileName);
        }

        public SelectClause withFileName(Word fileName) {
            return this.fileName == fileName ? this : new SelectClause(this.prefix, this.markers, this.words, fileName);
        }
    }

    public static final class SearchWhen
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word when;
        private final Condition condition;
        private final List<Word> nextSentence;
        private final List<Statement> statements;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSearchWhen(this, p);
        }

        public SearchWhen(Space prefix, Markers markers, Word when, Condition condition, List<Word> nextSentence, List<Statement> statements) {
            this.prefix = prefix;
            this.markers = markers;
            this.when = when;
            this.condition = condition;
            this.nextSentence = nextSentence;
            this.statements = statements;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWhen() {
            return this.when;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public List<Word> getNextSentence() {
            return this.nextSentence;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public String toString() {
            return "Cobol.SearchWhen(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", when=" + this.getWhen() + ", condition=" + this.getCondition() + ", nextSentence=" + this.getNextSentence() + ", statements=" + this.getStatements() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchWhen)) {
                return false;
            }
            SearchWhen other = (SearchWhen)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$when = this.getWhen();
            Word other$when = other.getWhen();
            if (this$when == null ? other$when != null : !((Object)this$when).equals(other$when)) {
                return false;
            }
            Condition this$condition = this.getCondition();
            Condition other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
                return false;
            }
            List<Word> this$nextSentence = this.getNextSentence();
            List<Word> other$nextSentence = other.getNextSentence();
            if (this$nextSentence == null ? other$nextSentence != null : !((Object)this$nextSentence).equals(other$nextSentence)) {
                return false;
            }
            List<Statement> this$statements = this.getStatements();
            List<Statement> other$statements = other.getStatements();
            return !(this$statements == null ? other$statements != null : !((Object)this$statements).equals(other$statements));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $when = this.getWhen();
            result = result * 59 + ($when == null ? 43 : ((Object)$when).hashCode());
            Condition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
            List<Word> $nextSentence = this.getNextSentence();
            result = result * 59 + ($nextSentence == null ? 43 : ((Object)$nextSentence).hashCode());
            List<Statement> $statements = this.getStatements();
            result = result * 59 + ($statements == null ? 43 : ((Object)$statements).hashCode());
            return result;
        }

        public SearchWhen withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SearchWhen(prefix, this.markers, this.when, this.condition, this.nextSentence, this.statements);
        }

        public SearchWhen withMarkers(Markers markers) {
            return this.markers == markers ? this : new SearchWhen(this.prefix, markers, this.when, this.condition, this.nextSentence, this.statements);
        }

        public SearchWhen withWhen(Word when) {
            return this.when == when ? this : new SearchWhen(this.prefix, this.markers, when, this.condition, this.nextSentence, this.statements);
        }

        public SearchWhen withCondition(Condition condition) {
            return this.condition == condition ? this : new SearchWhen(this.prefix, this.markers, this.when, condition, this.nextSentence, this.statements);
        }

        public SearchWhen withNextSentence(List<Word> nextSentence) {
            return this.nextSentence == nextSentence ? this : new SearchWhen(this.prefix, this.markers, this.when, this.condition, nextSentence, this.statements);
        }

        public SearchWhen withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new SearchWhen(this.prefix, this.markers, this.when, this.condition, this.nextSentence, statements);
        }
    }

    public static final class SearchVarying
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word varying;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSearchVarying(this, p);
        }

        public SearchVarying(Space prefix, Markers markers, Word varying, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.varying = varying;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getVarying() {
            return this.varying;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.SearchVarying(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", varying=" + this.getVarying() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchVarying)) {
                return false;
            }
            SearchVarying other = (SearchVarying)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$varying = this.getVarying();
            Word other$varying = other.getVarying();
            if (this$varying == null ? other$varying != null : !((Object)this$varying).equals(other$varying)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $varying = this.getVarying();
            result = result * 59 + ($varying == null ? 43 : ((Object)$varying).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public SearchVarying withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SearchVarying(prefix, this.markers, this.varying, this.qualifiedDataName);
        }

        public SearchVarying withMarkers(Markers markers) {
            return this.markers == markers ? this : new SearchVarying(this.prefix, markers, this.varying, this.qualifiedDataName);
        }

        public SearchVarying withVarying(Word varying) {
            return this.varying == varying ? this : new SearchVarying(this.prefix, this.markers, varying, this.qualifiedDataName);
        }

        public SearchVarying withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new SearchVarying(this.prefix, this.markers, this.varying, qualifiedDataName);
        }
    }

    public static final class Search
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;
        @Nullable
        private final SearchVarying searchVarying;
        @Nullable
        private final StatementPhrase atEndPhrase;
        private final List<SearchWhen> searchWhen;
        @Nullable
        private final Word endSearch;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSearch(this, p);
        }

        public Search(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName, SearchVarying searchVarying, StatementPhrase atEndPhrase, List<SearchWhen> searchWhen, Word endSearch) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
            this.searchVarying = searchVarying;
            this.atEndPhrase = atEndPhrase;
            this.searchWhen = searchWhen;
            this.endSearch = endSearch;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public SearchVarying getSearchVarying() {
            return this.searchVarying;
        }

        public StatementPhrase getAtEndPhrase() {
            return this.atEndPhrase;
        }

        public List<SearchWhen> getSearchWhen() {
            return this.searchWhen;
        }

        public Word getEndSearch() {
            return this.endSearch;
        }

        public String toString() {
            return "Cobol.Search(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ", searchVarying=" + this.getSearchVarying() + ", atEndPhrase=" + this.getAtEndPhrase() + ", searchWhen=" + this.getSearchWhen() + ", endSearch=" + this.getEndSearch() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Search)) {
                return false;
            }
            Search other = (Search)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            if (this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName)) {
                return false;
            }
            SearchVarying this$searchVarying = this.getSearchVarying();
            SearchVarying other$searchVarying = other.getSearchVarying();
            if (this$searchVarying == null ? other$searchVarying != null : !((Object)this$searchVarying).equals(other$searchVarying)) {
                return false;
            }
            StatementPhrase this$atEndPhrase = this.getAtEndPhrase();
            StatementPhrase other$atEndPhrase = other.getAtEndPhrase();
            if (this$atEndPhrase == null ? other$atEndPhrase != null : !((Object)this$atEndPhrase).equals(other$atEndPhrase)) {
                return false;
            }
            List<SearchWhen> this$searchWhen = this.getSearchWhen();
            List<SearchWhen> other$searchWhen = other.getSearchWhen();
            if (this$searchWhen == null ? other$searchWhen != null : !((Object)this$searchWhen).equals(other$searchWhen)) {
                return false;
            }
            Word this$endSearch = this.getEndSearch();
            Word other$endSearch = other.getEndSearch();
            return !(this$endSearch == null ? other$endSearch != null : !((Object)this$endSearch).equals(other$endSearch));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            SearchVarying $searchVarying = this.getSearchVarying();
            result = result * 59 + ($searchVarying == null ? 43 : ((Object)$searchVarying).hashCode());
            StatementPhrase $atEndPhrase = this.getAtEndPhrase();
            result = result * 59 + ($atEndPhrase == null ? 43 : ((Object)$atEndPhrase).hashCode());
            List<SearchWhen> $searchWhen = this.getSearchWhen();
            result = result * 59 + ($searchWhen == null ? 43 : ((Object)$searchWhen).hashCode());
            Word $endSearch = this.getEndSearch();
            result = result * 59 + ($endSearch == null ? 43 : ((Object)$endSearch).hashCode());
            return result;
        }

        public Search withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Search(prefix, this.markers, this.words, this.qualifiedDataName, this.searchVarying, this.atEndPhrase, this.searchWhen, this.endSearch);
        }

        public Search withMarkers(Markers markers) {
            return this.markers == markers ? this : new Search(this.prefix, markers, this.words, this.qualifiedDataName, this.searchVarying, this.atEndPhrase, this.searchWhen, this.endSearch);
        }

        public Search withWords(List<Word> words) {
            return this.words == words ? this : new Search(this.prefix, this.markers, words, this.qualifiedDataName, this.searchVarying, this.atEndPhrase, this.searchWhen, this.endSearch);
        }

        public Search withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new Search(this.prefix, this.markers, this.words, qualifiedDataName, this.searchVarying, this.atEndPhrase, this.searchWhen, this.endSearch);
        }

        public Search withSearchVarying(SearchVarying searchVarying) {
            return this.searchVarying == searchVarying ? this : new Search(this.prefix, this.markers, this.words, this.qualifiedDataName, searchVarying, this.atEndPhrase, this.searchWhen, this.endSearch);
        }

        public Search withAtEndPhrase(StatementPhrase atEndPhrase) {
            return this.atEndPhrase == atEndPhrase ? this : new Search(this.prefix, this.markers, this.words, this.qualifiedDataName, this.searchVarying, atEndPhrase, this.searchWhen, this.endSearch);
        }

        public Search withSearchWhen(List<SearchWhen> searchWhen) {
            return this.searchWhen == searchWhen ? this : new Search(this.prefix, this.markers, this.words, this.qualifiedDataName, this.searchVarying, this.atEndPhrase, searchWhen, this.endSearch);
        }

        public Search withEndSearch(Word endSearch) {
            return this.endSearch == endSearch ? this : new Search(this.prefix, this.markers, this.words, this.qualifiedDataName, this.searchVarying, this.atEndPhrase, this.searchWhen, endSearch);
        }
    }

    public static final class ScreenSection
    implements DataDivisionSection {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word dot;
        private final List<ScreenDescriptionEntry> descriptions;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenSection(this, p);
        }

        public ScreenSection(Space prefix, Markers markers, List<Word> words, Word dot, List<ScreenDescriptionEntry> descriptions) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dot = dot;
            this.descriptions = descriptions;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDot() {
            return this.dot;
        }

        public List<ScreenDescriptionEntry> getDescriptions() {
            return this.descriptions;
        }

        public String toString() {
            return "Cobol.ScreenSection(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dot=" + this.getDot() + ", descriptions=" + this.getDescriptions() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenSection)) {
                return false;
            }
            ScreenSection other = (ScreenSection)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            List<ScreenDescriptionEntry> this$descriptions = this.getDescriptions();
            List<ScreenDescriptionEntry> other$descriptions = other.getDescriptions();
            return !(this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            List<ScreenDescriptionEntry> $descriptions = this.getDescriptions();
            result = result * 59 + ($descriptions == null ? 43 : ((Object)$descriptions).hashCode());
            return result;
        }

        public ScreenSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenSection(prefix, this.markers, this.words, this.dot, this.descriptions);
        }

        public ScreenSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenSection(this.prefix, markers, this.words, this.dot, this.descriptions);
        }

        public ScreenSection withWords(List<Word> words) {
            return this.words == words ? this : new ScreenSection(this.prefix, this.markers, words, this.dot, this.descriptions);
        }

        public ScreenSection withDot(Word dot) {
            return this.dot == dot ? this : new ScreenSection(this.prefix, this.markers, this.words, dot, this.descriptions);
        }

        public ScreenSection withDescriptions(List<ScreenDescriptionEntry> descriptions) {
            return this.descriptions == descriptions ? this : new ScreenSection(this.prefix, this.markers, this.words, this.dot, descriptions);
        }
    }

    public static final class ScreenDescriptionZeroFillClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionZeroFillClause(this, p);
        }

        public ScreenDescriptionZeroFillClause(Space prefix, Markers markers, Word word) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionZeroFillClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionZeroFillClause)) {
                return false;
            }
            ScreenDescriptionZeroFillClause other = (ScreenDescriptionZeroFillClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            return !(this$word == null ? other$word != null : !((Object)this$word).equals(other$word));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            return result;
        }

        public ScreenDescriptionZeroFillClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionZeroFillClause(prefix, this.markers, this.word);
        }

        public ScreenDescriptionZeroFillClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionZeroFillClause(this.prefix, markers, this.word);
        }

        public ScreenDescriptionZeroFillClause withWord(Word word) {
            return this.word == word ? this : new ScreenDescriptionZeroFillClause(this.prefix, this.markers, word);
        }
    }

    public static final class ScreenDescriptionValueClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionValueClause(this, p);
        }

        public ScreenDescriptionValueClause(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionValueClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionValueClause)) {
                return false;
            }
            ScreenDescriptionValueClause other = (ScreenDescriptionValueClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionValueClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionValueClause(prefix, this.markers, this.words, this.value);
        }

        public ScreenDescriptionValueClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionValueClause(this.prefix, markers, this.words, this.value);
        }

        public ScreenDescriptionValueClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionValueClause(this.prefix, this.markers, words, this.value);
        }

        public ScreenDescriptionValueClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionValueClause(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ScreenDescriptionUsingClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word using;
        private final Identifier identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionUsingClause(this, p);
        }

        public ScreenDescriptionUsingClause(Space prefix, Markers markers, Word using, Identifier identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.using = using;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getUsing() {
            return this.using;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionUsingClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", using=" + this.getUsing() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionUsingClause)) {
                return false;
            }
            ScreenDescriptionUsingClause other = (ScreenDescriptionUsingClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$using = this.getUsing();
            Word other$using = other.getUsing();
            if (this$using == null ? other$using != null : !((Object)this$using).equals(other$using)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $using = this.getUsing();
            result = result * 59 + ($using == null ? 43 : ((Object)$using).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public ScreenDescriptionUsingClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionUsingClause(prefix, this.markers, this.using, this.identifier);
        }

        public ScreenDescriptionUsingClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionUsingClause(this.prefix, markers, this.using, this.identifier);
        }

        public ScreenDescriptionUsingClause withUsing(Word using) {
            return this.using == using ? this : new ScreenDescriptionUsingClause(this.prefix, this.markers, using, this.identifier);
        }

        public ScreenDescriptionUsingClause withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new ScreenDescriptionUsingClause(this.prefix, this.markers, this.using, identifier);
        }
    }

    public static final class ScreenDescriptionUsageClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionUsageClause(this, p);
        }

        public ScreenDescriptionUsageClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionUsageClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionUsageClause)) {
                return false;
            }
            ScreenDescriptionUsageClause other = (ScreenDescriptionUsageClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ScreenDescriptionUsageClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionUsageClause(prefix, this.markers, this.words);
        }

        public ScreenDescriptionUsageClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionUsageClause(this.prefix, markers, this.words);
        }

        public ScreenDescriptionUsageClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionUsageClause(this.prefix, this.markers, words);
        }
    }

    public static final class ScreenDescriptionUnderlineClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word underline;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionUnderlineClause(this, p);
        }

        public ScreenDescriptionUnderlineClause(Space prefix, Markers markers, Word underline) {
            this.prefix = prefix;
            this.markers = markers;
            this.underline = underline;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getUnderline() {
            return this.underline;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionUnderlineClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", underline=" + this.getUnderline() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionUnderlineClause)) {
                return false;
            }
            ScreenDescriptionUnderlineClause other = (ScreenDescriptionUnderlineClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$underline = this.getUnderline();
            Word other$underline = other.getUnderline();
            return !(this$underline == null ? other$underline != null : !((Object)this$underline).equals(other$underline));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $underline = this.getUnderline();
            result = result * 59 + ($underline == null ? 43 : ((Object)$underline).hashCode());
            return result;
        }

        public ScreenDescriptionUnderlineClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionUnderlineClause(prefix, this.markers, this.underline);
        }

        public ScreenDescriptionUnderlineClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionUnderlineClause(this.prefix, markers, this.underline);
        }

        public ScreenDescriptionUnderlineClause withUnderline(Word underline) {
            return this.underline == underline ? this : new ScreenDescriptionUnderlineClause(this.prefix, this.markers, underline);
        }
    }

    public static final class ScreenDescriptionToClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word to;
        private final Identifier identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionToClause(this, p);
        }

        public ScreenDescriptionToClause(Space prefix, Markers markers, Word to, Identifier identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.to = to;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getTo() {
            return this.to;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionToClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", to=" + this.getTo() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionToClause)) {
                return false;
            }
            ScreenDescriptionToClause other = (ScreenDescriptionToClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$to = this.getTo();
            Word other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public ScreenDescriptionToClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionToClause(prefix, this.markers, this.to, this.identifier);
        }

        public ScreenDescriptionToClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionToClause(this.prefix, markers, this.to, this.identifier);
        }

        public ScreenDescriptionToClause withTo(Word to) {
            return this.to == to ? this : new ScreenDescriptionToClause(this.prefix, this.markers, to, this.identifier);
        }

        public ScreenDescriptionToClause withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new ScreenDescriptionToClause(this.prefix, this.markers, this.to, identifier);
        }
    }

    public static final class ScreenDescriptionSizeClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionSizeClause(this, p);
        }

        public ScreenDescriptionSizeClause(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionSizeClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionSizeClause)) {
                return false;
            }
            ScreenDescriptionSizeClause other = (ScreenDescriptionSizeClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionSizeClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionSizeClause(prefix, this.markers, this.words, this.value);
        }

        public ScreenDescriptionSizeClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionSizeClause(this.prefix, markers, this.words, this.value);
        }

        public ScreenDescriptionSizeClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionSizeClause(this.prefix, this.markers, words, this.value);
        }

        public ScreenDescriptionSizeClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionSizeClause(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ScreenDescriptionSignClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionSignClause(this, p);
        }

        public ScreenDescriptionSignClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionSignClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionSignClause)) {
                return false;
            }
            ScreenDescriptionSignClause other = (ScreenDescriptionSignClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ScreenDescriptionSignClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionSignClause(prefix, this.markers, this.words);
        }

        public ScreenDescriptionSignClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionSignClause(this.prefix, markers, this.words);
        }

        public ScreenDescriptionSignClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionSignClause(this.prefix, this.markers, words);
        }
    }

    public static final class ScreenDescriptionSecureClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionSecureClause(this, p);
        }

        public ScreenDescriptionSecureClause(Space prefix, Markers markers, Word word) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionSecureClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionSecureClause)) {
                return false;
            }
            ScreenDescriptionSecureClause other = (ScreenDescriptionSecureClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            return !(this$word == null ? other$word != null : !((Object)this$word).equals(other$word));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            return result;
        }

        public ScreenDescriptionSecureClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionSecureClause(prefix, this.markers, this.word);
        }

        public ScreenDescriptionSecureClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionSecureClause(this.prefix, markers, this.word);
        }

        public ScreenDescriptionSecureClause withWord(Word word) {
            return this.word == word ? this : new ScreenDescriptionSecureClause(this.prefix, this.markers, word);
        }
    }

    public static final class ScreenDescriptionReverseVideoClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionReverseVideoClause(this, p);
        }

        public ScreenDescriptionReverseVideoClause(Space prefix, Markers markers, Word word) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionReverseVideoClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionReverseVideoClause)) {
                return false;
            }
            ScreenDescriptionReverseVideoClause other = (ScreenDescriptionReverseVideoClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            return !(this$word == null ? other$word != null : !((Object)this$word).equals(other$word));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            return result;
        }

        public ScreenDescriptionReverseVideoClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionReverseVideoClause(prefix, this.markers, this.word);
        }

        public ScreenDescriptionReverseVideoClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionReverseVideoClause(this.prefix, markers, this.word);
        }

        public ScreenDescriptionReverseVideoClause withWord(Word word) {
            return this.word == word ? this : new ScreenDescriptionReverseVideoClause(this.prefix, this.markers, word);
        }
    }

    public static final class ScreenDescriptionRequiredClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word required;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionRequiredClause(this, p);
        }

        public ScreenDescriptionRequiredClause(Space prefix, Markers markers, Word required) {
            this.prefix = prefix;
            this.markers = markers;
            this.required = required;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getRequired() {
            return this.required;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionRequiredClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", required=" + this.getRequired() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionRequiredClause)) {
                return false;
            }
            ScreenDescriptionRequiredClause other = (ScreenDescriptionRequiredClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$required = this.getRequired();
            Word other$required = other.getRequired();
            return !(this$required == null ? other$required != null : !((Object)this$required).equals(other$required));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            return result;
        }

        public ScreenDescriptionRequiredClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionRequiredClause(prefix, this.markers, this.required);
        }

        public ScreenDescriptionRequiredClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionRequiredClause(this.prefix, markers, this.required);
        }

        public ScreenDescriptionRequiredClause withRequired(Word required) {
            return this.required == required ? this : new ScreenDescriptionRequiredClause(this.prefix, this.markers, required);
        }
    }

    public static final class ScreenDescriptionPromptOccursClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word occurs;
        private final Word integer;
        @Nullable
        private final Word times;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionPromptOccursClause(this, p);
        }

        public ScreenDescriptionPromptOccursClause(Space prefix, Markers markers, Word occurs, Word integer, Word times) {
            this.prefix = prefix;
            this.markers = markers;
            this.occurs = occurs;
            this.integer = integer;
            this.times = times;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getOccurs() {
            return this.occurs;
        }

        public Word getInteger() {
            return this.integer;
        }

        public Word getTimes() {
            return this.times;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionPromptOccursClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", occurs=" + this.getOccurs() + ", integer=" + this.getInteger() + ", times=" + this.getTimes() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionPromptOccursClause)) {
                return false;
            }
            ScreenDescriptionPromptOccursClause other = (ScreenDescriptionPromptOccursClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$occurs = this.getOccurs();
            Word other$occurs = other.getOccurs();
            if (this$occurs == null ? other$occurs != null : !((Object)this$occurs).equals(other$occurs)) {
                return false;
            }
            Word this$integer = this.getInteger();
            Word other$integer = other.getInteger();
            if (this$integer == null ? other$integer != null : !((Object)this$integer).equals(other$integer)) {
                return false;
            }
            Word this$times = this.getTimes();
            Word other$times = other.getTimes();
            return !(this$times == null ? other$times != null : !((Object)this$times).equals(other$times));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $occurs = this.getOccurs();
            result = result * 59 + ($occurs == null ? 43 : ((Object)$occurs).hashCode());
            Word $integer = this.getInteger();
            result = result * 59 + ($integer == null ? 43 : ((Object)$integer).hashCode());
            Word $times = this.getTimes();
            result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
            return result;
        }

        public ScreenDescriptionPromptOccursClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionPromptOccursClause(prefix, this.markers, this.occurs, this.integer, this.times);
        }

        public ScreenDescriptionPromptOccursClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionPromptOccursClause(this.prefix, markers, this.occurs, this.integer, this.times);
        }

        public ScreenDescriptionPromptOccursClause withOccurs(Word occurs) {
            return this.occurs == occurs ? this : new ScreenDescriptionPromptOccursClause(this.prefix, this.markers, occurs, this.integer, this.times);
        }

        public ScreenDescriptionPromptOccursClause withInteger(Word integer) {
            return this.integer == integer ? this : new ScreenDescriptionPromptOccursClause(this.prefix, this.markers, this.occurs, integer, this.times);
        }

        public ScreenDescriptionPromptOccursClause withTimes(Word times) {
            return this.times == times ? this : new ScreenDescriptionPromptOccursClause(this.prefix, this.markers, this.occurs, this.integer, times);
        }
    }

    public static final class ScreenDescriptionPromptClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name name;
        @Nullable
        private final ScreenDescriptionPromptOccursClause screenDescriptionPromptOccursClause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionPromptClause(this, p);
        }

        public ScreenDescriptionPromptClause(Space prefix, Markers markers, List<Word> words, Name name, ScreenDescriptionPromptOccursClause screenDescriptionPromptOccursClause) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
            this.screenDescriptionPromptOccursClause = screenDescriptionPromptOccursClause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getName() {
            return this.name;
        }

        public ScreenDescriptionPromptOccursClause getScreenDescriptionPromptOccursClause() {
            return this.screenDescriptionPromptOccursClause;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionPromptClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ", screenDescriptionPromptOccursClause=" + this.getScreenDescriptionPromptOccursClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionPromptClause)) {
                return false;
            }
            ScreenDescriptionPromptClause other = (ScreenDescriptionPromptClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ScreenDescriptionPromptOccursClause this$screenDescriptionPromptOccursClause = this.getScreenDescriptionPromptOccursClause();
            ScreenDescriptionPromptOccursClause other$screenDescriptionPromptOccursClause = other.getScreenDescriptionPromptOccursClause();
            return !(this$screenDescriptionPromptOccursClause == null ? other$screenDescriptionPromptOccursClause != null : !((Object)this$screenDescriptionPromptOccursClause).equals(other$screenDescriptionPromptOccursClause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ScreenDescriptionPromptOccursClause $screenDescriptionPromptOccursClause = this.getScreenDescriptionPromptOccursClause();
            result = result * 59 + ($screenDescriptionPromptOccursClause == null ? 43 : ((Object)$screenDescriptionPromptOccursClause).hashCode());
            return result;
        }

        public ScreenDescriptionPromptClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionPromptClause(prefix, this.markers, this.words, this.name, this.screenDescriptionPromptOccursClause);
        }

        public ScreenDescriptionPromptClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionPromptClause(this.prefix, markers, this.words, this.name, this.screenDescriptionPromptOccursClause);
        }

        public ScreenDescriptionPromptClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionPromptClause(this.prefix, this.markers, words, this.name, this.screenDescriptionPromptOccursClause);
        }

        public ScreenDescriptionPromptClause withName(Name name) {
            return this.name == name ? this : new ScreenDescriptionPromptClause(this.prefix, this.markers, this.words, name, this.screenDescriptionPromptOccursClause);
        }

        public ScreenDescriptionPromptClause withScreenDescriptionPromptOccursClause(ScreenDescriptionPromptOccursClause screenDescriptionPromptOccursClause) {
            return this.screenDescriptionPromptOccursClause == screenDescriptionPromptOccursClause ? this : new ScreenDescriptionPromptClause(this.prefix, this.markers, this.words, this.name, screenDescriptionPromptOccursClause);
        }
    }

    public static final class ScreenDescriptionPictureClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final PictureString pictureString;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionPictureClause(this, p);
        }

        public ScreenDescriptionPictureClause(Space prefix, Markers markers, List<Word> words, PictureString pictureString) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.pictureString = pictureString;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public PictureString getPictureString() {
            return this.pictureString;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionPictureClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", pictureString=" + this.getPictureString() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionPictureClause)) {
                return false;
            }
            ScreenDescriptionPictureClause other = (ScreenDescriptionPictureClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            PictureString this$pictureString = this.getPictureString();
            PictureString other$pictureString = other.getPictureString();
            return !(this$pictureString == null ? other$pictureString != null : !((Object)this$pictureString).equals(other$pictureString));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            PictureString $pictureString = this.getPictureString();
            result = result * 59 + ($pictureString == null ? 43 : ((Object)$pictureString).hashCode());
            return result;
        }

        public ScreenDescriptionPictureClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionPictureClause(prefix, this.markers, this.words, this.pictureString);
        }

        public ScreenDescriptionPictureClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionPictureClause(this.prefix, markers, this.words, this.pictureString);
        }

        public ScreenDescriptionPictureClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionPictureClause(this.prefix, this.markers, words, this.pictureString);
        }

        public ScreenDescriptionPictureClause withPictureString(PictureString pictureString) {
            return this.pictureString == pictureString ? this : new ScreenDescriptionPictureClause(this.prefix, this.markers, this.words, pictureString);
        }
    }

    public static final class ScreenDescriptionLineClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionLineClause(this, p);
        }

        public ScreenDescriptionLineClause(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionLineClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionLineClause)) {
                return false;
            }
            ScreenDescriptionLineClause other = (ScreenDescriptionLineClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionLineClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionLineClause(prefix, this.markers, this.words, this.value);
        }

        public ScreenDescriptionLineClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionLineClause(this.prefix, markers, this.words, this.value);
        }

        public ScreenDescriptionLineClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionLineClause(this.prefix, this.markers, words, this.value);
        }

        public ScreenDescriptionLineClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionLineClause(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ScreenDescriptionLightClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word light;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionLightClause(this, p);
        }

        public ScreenDescriptionLightClause(Space prefix, Markers markers, Word light) {
            this.prefix = prefix;
            this.markers = markers;
            this.light = light;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getLight() {
            return this.light;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionLightClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", light=" + this.getLight() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionLightClause)) {
                return false;
            }
            ScreenDescriptionLightClause other = (ScreenDescriptionLightClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$light = this.getLight();
            Word other$light = other.getLight();
            return !(this$light == null ? other$light != null : !((Object)this$light).equals(other$light));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $light = this.getLight();
            result = result * 59 + ($light == null ? 43 : ((Object)$light).hashCode());
            return result;
        }

        public ScreenDescriptionLightClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionLightClause(prefix, this.markers, this.light);
        }

        public ScreenDescriptionLightClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionLightClause(this.prefix, markers, this.light);
        }

        public ScreenDescriptionLightClause withLight(Word light) {
            return this.light == light ? this : new ScreenDescriptionLightClause(this.prefix, this.markers, light);
        }
    }

    public static final class ScreenDescriptionJustifiedClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionJustifiedClause(this, p);
        }

        public ScreenDescriptionJustifiedClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionJustifiedClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionJustifiedClause)) {
                return false;
            }
            ScreenDescriptionJustifiedClause other = (ScreenDescriptionJustifiedClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ScreenDescriptionJustifiedClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionJustifiedClause(prefix, this.markers, this.words);
        }

        public ScreenDescriptionJustifiedClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionJustifiedClause(this.prefix, markers, this.words);
        }

        public ScreenDescriptionJustifiedClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionJustifiedClause(this.prefix, this.markers, words);
        }
    }

    public static final class ScreenDescriptionGridClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionGridClause(this, p);
        }

        public ScreenDescriptionGridClause(Space prefix, Markers markers, Word word) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionGridClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionGridClause)) {
                return false;
            }
            ScreenDescriptionGridClause other = (ScreenDescriptionGridClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            return !(this$word == null ? other$word != null : !((Object)this$word).equals(other$word));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            return result;
        }

        public ScreenDescriptionGridClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionGridClause(prefix, this.markers, this.word);
        }

        public ScreenDescriptionGridClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionGridClause(this.prefix, markers, this.word);
        }

        public ScreenDescriptionGridClause withWord(Word word) {
            return this.word == word ? this : new ScreenDescriptionGridClause(this.prefix, this.markers, word);
        }
    }

    public static final class ScreenDescriptionFullClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionFullClause(this, p);
        }

        public ScreenDescriptionFullClause(Space prefix, Markers markers, Word word) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionFullClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionFullClause)) {
                return false;
            }
            ScreenDescriptionFullClause other = (ScreenDescriptionFullClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            return !(this$word == null ? other$word != null : !((Object)this$word).equals(other$word));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            return result;
        }

        public ScreenDescriptionFullClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionFullClause(prefix, this.markers, this.word);
        }

        public ScreenDescriptionFullClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionFullClause(this.prefix, markers, this.word);
        }

        public ScreenDescriptionFullClause withWord(Word word) {
            return this.word == word ? this : new ScreenDescriptionFullClause(this.prefix, this.markers, word);
        }
    }

    public static final class ScreenDescriptionFromClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word from;
        private final Name value;
        @Nullable
        private final ScreenDescriptionToClause screenDescriptionToClause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionFromClause(this, p);
        }

        public ScreenDescriptionFromClause(Space prefix, Markers markers, Word from, Name value, ScreenDescriptionToClause screenDescriptionToClause) {
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.value = value;
            this.screenDescriptionToClause = screenDescriptionToClause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getFrom() {
            return this.from;
        }

        public Name getValue() {
            return this.value;
        }

        public ScreenDescriptionToClause getScreenDescriptionToClause() {
            return this.screenDescriptionToClause;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionFromClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", from=" + this.getFrom() + ", value=" + this.getValue() + ", screenDescriptionToClause=" + this.getScreenDescriptionToClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionFromClause)) {
                return false;
            }
            ScreenDescriptionFromClause other = (ScreenDescriptionFromClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            ScreenDescriptionToClause this$screenDescriptionToClause = this.getScreenDescriptionToClause();
            ScreenDescriptionToClause other$screenDescriptionToClause = other.getScreenDescriptionToClause();
            return !(this$screenDescriptionToClause == null ? other$screenDescriptionToClause != null : !((Object)this$screenDescriptionToClause).equals(other$screenDescriptionToClause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            ScreenDescriptionToClause $screenDescriptionToClause = this.getScreenDescriptionToClause();
            result = result * 59 + ($screenDescriptionToClause == null ? 43 : ((Object)$screenDescriptionToClause).hashCode());
            return result;
        }

        public ScreenDescriptionFromClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionFromClause(prefix, this.markers, this.from, this.value, this.screenDescriptionToClause);
        }

        public ScreenDescriptionFromClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionFromClause(this.prefix, markers, this.from, this.value, this.screenDescriptionToClause);
        }

        public ScreenDescriptionFromClause withFrom(Word from) {
            return this.from == from ? this : new ScreenDescriptionFromClause(this.prefix, this.markers, from, this.value, this.screenDescriptionToClause);
        }

        public ScreenDescriptionFromClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionFromClause(this.prefix, this.markers, this.from, value, this.screenDescriptionToClause);
        }

        public ScreenDescriptionFromClause withScreenDescriptionToClause(ScreenDescriptionToClause screenDescriptionToClause) {
            return this.screenDescriptionToClause == screenDescriptionToClause ? this : new ScreenDescriptionFromClause(this.prefix, this.markers, this.from, this.value, screenDescriptionToClause);
        }
    }

    public static final class ScreenDescriptionForegroundColorClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionForegroundColorClause(this, p);
        }

        public ScreenDescriptionForegroundColorClause(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionForegroundColorClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionForegroundColorClause)) {
                return false;
            }
            ScreenDescriptionForegroundColorClause other = (ScreenDescriptionForegroundColorClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionForegroundColorClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionForegroundColorClause(prefix, this.markers, this.words, this.value);
        }

        public ScreenDescriptionForegroundColorClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionForegroundColorClause(this.prefix, markers, this.words, this.value);
        }

        public ScreenDescriptionForegroundColorClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionForegroundColorClause(this.prefix, this.markers, words, this.value);
        }

        public ScreenDescriptionForegroundColorClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionForegroundColorClause(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ScreenDescriptionEraseClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionEraseClause(this, p);
        }

        public ScreenDescriptionEraseClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionEraseClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionEraseClause)) {
                return false;
            }
            ScreenDescriptionEraseClause other = (ScreenDescriptionEraseClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ScreenDescriptionEraseClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionEraseClause(prefix, this.markers, this.words);
        }

        public ScreenDescriptionEraseClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionEraseClause(this.prefix, markers, this.words);
        }

        public ScreenDescriptionEraseClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionEraseClause(this.prefix, this.markers, words);
        }
    }

    public static final class ScreenDescriptionEntry
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        @Nullable
        private final Word name;
        private final List<Cobol> clauses;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionEntry(this, p);
        }

        public ScreenDescriptionEntry(Space prefix, Markers markers, Word word, Word name, List<Cobol> clauses, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.name = name;
            this.clauses = clauses;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Word getName() {
            return this.name;
        }

        public List<Cobol> getClauses() {
            return this.clauses;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionEntry(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", name=" + this.getName() + ", clauses=" + this.getClauses() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionEntry)) {
                return false;
            }
            ScreenDescriptionEntry other = (ScreenDescriptionEntry)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Word this$name = this.getName();
            Word other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            List<Cobol> this$clauses = this.getClauses();
            List<Cobol> other$clauses = other.getClauses();
            if (this$clauses == null ? other$clauses != null : !((Object)this$clauses).equals(other$clauses)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Word $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            List<Cobol> $clauses = this.getClauses();
            result = result * 59 + ($clauses == null ? 43 : ((Object)$clauses).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ScreenDescriptionEntry withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionEntry(prefix, this.markers, this.word, this.name, this.clauses, this.dot);
        }

        public ScreenDescriptionEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionEntry(this.prefix, markers, this.word, this.name, this.clauses, this.dot);
        }

        public ScreenDescriptionEntry withWord(Word word) {
            return this.word == word ? this : new ScreenDescriptionEntry(this.prefix, this.markers, word, this.name, this.clauses, this.dot);
        }

        public ScreenDescriptionEntry withName(Word name) {
            return this.name == name ? this : new ScreenDescriptionEntry(this.prefix, this.markers, this.word, name, this.clauses, this.dot);
        }

        public ScreenDescriptionEntry withClauses(List<Cobol> clauses) {
            return this.clauses == clauses ? this : new ScreenDescriptionEntry(this.prefix, this.markers, this.word, this.name, clauses, this.dot);
        }

        public ScreenDescriptionEntry withDot(Word dot) {
            return this.dot == dot ? this : new ScreenDescriptionEntry(this.prefix, this.markers, this.word, this.name, this.clauses, dot);
        }
    }

    public static final class ScreenDescriptionControlClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionControlClause(this, p);
        }

        public ScreenDescriptionControlClause(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionControlClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionControlClause)) {
                return false;
            }
            ScreenDescriptionControlClause other = (ScreenDescriptionControlClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionControlClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionControlClause(prefix, this.markers, this.words, this.value);
        }

        public ScreenDescriptionControlClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionControlClause(this.prefix, markers, this.words, this.value);
        }

        public ScreenDescriptionControlClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionControlClause(this.prefix, this.markers, words, this.value);
        }

        public ScreenDescriptionControlClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionControlClause(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ScreenDescriptionColumnClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionColumnClause(this, p);
        }

        public ScreenDescriptionColumnClause(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionColumnClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionColumnClause)) {
                return false;
            }
            ScreenDescriptionColumnClause other = (ScreenDescriptionColumnClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionColumnClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionColumnClause(prefix, this.markers, this.words, this.value);
        }

        public ScreenDescriptionColumnClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionColumnClause(this.prefix, markers, this.words, this.value);
        }

        public ScreenDescriptionColumnClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionColumnClause(this.prefix, this.markers, words, this.value);
        }

        public ScreenDescriptionColumnClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionColumnClause(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ScreenDescriptionBlinkClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word blink;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionBlinkClause(this, p);
        }

        public ScreenDescriptionBlinkClause(Space prefix, Markers markers, Word blink) {
            this.prefix = prefix;
            this.markers = markers;
            this.blink = blink;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getBlink() {
            return this.blink;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionBlinkClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", blink=" + this.getBlink() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionBlinkClause)) {
                return false;
            }
            ScreenDescriptionBlinkClause other = (ScreenDescriptionBlinkClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$blink = this.getBlink();
            Word other$blink = other.getBlink();
            return !(this$blink == null ? other$blink != null : !((Object)this$blink).equals(other$blink));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $blink = this.getBlink();
            result = result * 59 + ($blink == null ? 43 : ((Object)$blink).hashCode());
            return result;
        }

        public ScreenDescriptionBlinkClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionBlinkClause(prefix, this.markers, this.blink);
        }

        public ScreenDescriptionBlinkClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionBlinkClause(this.prefix, markers, this.blink);
        }

        public ScreenDescriptionBlinkClause withBlink(Word blink) {
            return this.blink == blink ? this : new ScreenDescriptionBlinkClause(this.prefix, this.markers, blink);
        }
    }

    public static final class ScreenDescriptionBlankWhenZeroClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionBlankWhenZeroClause(this, p);
        }

        public ScreenDescriptionBlankWhenZeroClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionBlankWhenZeroClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionBlankWhenZeroClause)) {
                return false;
            }
            ScreenDescriptionBlankWhenZeroClause other = (ScreenDescriptionBlankWhenZeroClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ScreenDescriptionBlankWhenZeroClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionBlankWhenZeroClause(prefix, this.markers, this.words);
        }

        public ScreenDescriptionBlankWhenZeroClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionBlankWhenZeroClause(this.prefix, markers, this.words);
        }

        public ScreenDescriptionBlankWhenZeroClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionBlankWhenZeroClause(this.prefix, this.markers, words);
        }
    }

    public static final class ScreenDescriptionBlankClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionBlankClause(this, p);
        }

        public ScreenDescriptionBlankClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionBlankClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionBlankClause)) {
                return false;
            }
            ScreenDescriptionBlankClause other = (ScreenDescriptionBlankClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ScreenDescriptionBlankClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionBlankClause(prefix, this.markers, this.words);
        }

        public ScreenDescriptionBlankClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionBlankClause(this.prefix, markers, this.words);
        }

        public ScreenDescriptionBlankClause withWords(List<Word> words) {
            return this.words == words ? this : new ScreenDescriptionBlankClause(this.prefix, this.markers, words);
        }
    }

    public static final class ScreenDescriptionBellClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word bell;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionBellClause(this, p);
        }

        public ScreenDescriptionBellClause(Space prefix, Markers markers, Word bell) {
            this.prefix = prefix;
            this.markers = markers;
            this.bell = bell;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getBell() {
            return this.bell;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionBellClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", bell=" + this.getBell() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionBellClause)) {
                return false;
            }
            ScreenDescriptionBellClause other = (ScreenDescriptionBellClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$bell = this.getBell();
            Word other$bell = other.getBell();
            return !(this$bell == null ? other$bell != null : !((Object)this$bell).equals(other$bell));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $bell = this.getBell();
            result = result * 59 + ($bell == null ? 43 : ((Object)$bell).hashCode());
            return result;
        }

        public ScreenDescriptionBellClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionBellClause(prefix, this.markers, this.bell);
        }

        public ScreenDescriptionBellClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionBellClause(this.prefix, markers, this.bell);
        }

        public ScreenDescriptionBellClause withBell(Word bell) {
            return this.bell == bell ? this : new ScreenDescriptionBellClause(this.prefix, this.markers, bell);
        }
    }

    public static final class ScreenDescriptionBackgroundColorClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word background;
        private final Word is;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionBackgroundColorClause(this, p);
        }

        public ScreenDescriptionBackgroundColorClause(Space prefix, Markers markers, Word background, Word is, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.background = background;
            this.is = is;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getBackground() {
            return this.background;
        }

        public Word getIs() {
            return this.is;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionBackgroundColorClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", background=" + this.getBackground() + ", is=" + this.getIs() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionBackgroundColorClause)) {
                return false;
            }
            ScreenDescriptionBackgroundColorClause other = (ScreenDescriptionBackgroundColorClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$background = this.getBackground();
            Word other$background = other.getBackground();
            if (this$background == null ? other$background != null : !((Object)this$background).equals(other$background)) {
                return false;
            }
            Word this$is = this.getIs();
            Word other$is = other.getIs();
            if (this$is == null ? other$is != null : !((Object)this$is).equals(other$is)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $background = this.getBackground();
            result = result * 59 + ($background == null ? 43 : ((Object)$background).hashCode());
            Word $is = this.getIs();
            result = result * 59 + ($is == null ? 43 : ((Object)$is).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public ScreenDescriptionBackgroundColorClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionBackgroundColorClause(prefix, this.markers, this.background, this.is, this.value);
        }

        public ScreenDescriptionBackgroundColorClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionBackgroundColorClause(this.prefix, markers, this.background, this.is, this.value);
        }

        public ScreenDescriptionBackgroundColorClause withBackground(Word background) {
            return this.background == background ? this : new ScreenDescriptionBackgroundColorClause(this.prefix, this.markers, background, this.is, this.value);
        }

        public ScreenDescriptionBackgroundColorClause withIs(Word is) {
            return this.is == is ? this : new ScreenDescriptionBackgroundColorClause(this.prefix, this.markers, this.background, is, this.value);
        }

        public ScreenDescriptionBackgroundColorClause withValue(Name value) {
            return this.value == value ? this : new ScreenDescriptionBackgroundColorClause(this.prefix, this.markers, this.background, this.is, value);
        }
    }

    public static final class ScreenDescriptionAutoClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word auto;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitScreenDescriptionAutoClause(this, p);
        }

        public ScreenDescriptionAutoClause(Space prefix, Markers markers, Word auto) {
            this.prefix = prefix;
            this.markers = markers;
            this.auto = auto;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getAuto() {
            return this.auto;
        }

        public String toString() {
            return "Cobol.ScreenDescriptionAutoClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", auto=" + this.getAuto() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenDescriptionAutoClause)) {
                return false;
            }
            ScreenDescriptionAutoClause other = (ScreenDescriptionAutoClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$auto = this.getAuto();
            Word other$auto = other.getAuto();
            return !(this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $auto = this.getAuto();
            result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
            return result;
        }

        public ScreenDescriptionAutoClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScreenDescriptionAutoClause(prefix, this.markers, this.auto);
        }

        public ScreenDescriptionAutoClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScreenDescriptionAutoClause(this.prefix, markers, this.auto);
        }

        public ScreenDescriptionAutoClause withAuto(Word auto) {
            return this.auto == auto ? this : new ScreenDescriptionAutoClause(this.prefix, this.markers, auto);
        }
    }

    public static final class SameClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Word> fileNames;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitSameClause(this, p);
        }

        public SameClause(Space prefix, Markers markers, List<Word> words, List<Word> fileNames) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.fileNames = fileNames;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Word> getFileNames() {
            return this.fileNames;
        }

        public String toString() {
            return "Cobol.SameClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", fileNames=" + this.getFileNames() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SameClause)) {
                return false;
            }
            SameClause other = (SameClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Word> this$fileNames = this.getFileNames();
            List<Word> other$fileNames = other.getFileNames();
            return !(this$fileNames == null ? other$fileNames != null : !((Object)this$fileNames).equals(other$fileNames));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Word> $fileNames = this.getFileNames();
            result = result * 59 + ($fileNames == null ? 43 : ((Object)$fileNames).hashCode());
            return result;
        }

        public SameClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SameClause(prefix, this.markers, this.words, this.fileNames);
        }

        public SameClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new SameClause(this.prefix, markers, this.words, this.fileNames);
        }

        public SameClause withWords(List<Word> words) {
            return this.words == words ? this : new SameClause(this.prefix, this.markers, words, this.fileNames);
        }

        public SameClause withFileNames(List<Word> fileNames) {
            return this.fileNames == fileNames ? this : new SameClause(this.prefix, this.markers, this.words, fileNames);
        }
    }

    public static final class Roundable
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Identifier identifier;
        @Nullable
        private final Word rounded;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRoundable(this, p);
        }

        public Roundable(Space prefix, Markers markers, Identifier identifier, Word rounded) {
            this.prefix = prefix;
            this.markers = markers;
            this.identifier = identifier;
            this.rounded = rounded;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public Word getRounded() {
            return this.rounded;
        }

        public String toString() {
            return "Cobol.Roundable(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", identifier=" + this.getIdentifier() + ", rounded=" + this.getRounded() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Roundable)) {
                return false;
            }
            Roundable other = (Roundable)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            Word this$rounded = this.getRounded();
            Word other$rounded = other.getRounded();
            return !(this$rounded == null ? other$rounded != null : !((Object)this$rounded).equals(other$rounded));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            Word $rounded = this.getRounded();
            result = result * 59 + ($rounded == null ? 43 : ((Object)$rounded).hashCode());
            return result;
        }

        public Roundable withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Roundable(prefix, this.markers, this.identifier, this.rounded);
        }

        public Roundable withMarkers(Markers markers) {
            return this.markers == markers ? this : new Roundable(this.prefix, markers, this.identifier, this.rounded);
        }

        public Roundable withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new Roundable(this.prefix, this.markers, identifier, this.rounded);
        }

        public Roundable withRounded(Word rounded) {
            return this.rounded == rounded ? this : new Roundable(this.prefix, this.markers, this.identifier, rounded);
        }
    }

    public static final class RewriteFrom
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word from;
        private final Name identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRewriteFrom(this, p);
        }

        public RewriteFrom(Space prefix, Markers markers, Word from, Name identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getFrom() {
            return this.from;
        }

        public Name getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.RewriteFrom(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", from=" + this.getFrom() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RewriteFrom)) {
                return false;
            }
            RewriteFrom other = (RewriteFrom)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            Name this$identifier = this.getIdentifier();
            Name other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            Name $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public RewriteFrom withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RewriteFrom(prefix, this.markers, this.from, this.identifier);
        }

        public RewriteFrom withMarkers(Markers markers) {
            return this.markers == markers ? this : new RewriteFrom(this.prefix, markers, this.from, this.identifier);
        }

        public RewriteFrom withFrom(Word from) {
            return this.from == from ? this : new RewriteFrom(this.prefix, this.markers, from, this.identifier);
        }

        public RewriteFrom withIdentifier(Name identifier) {
            return this.identifier == identifier ? this : new RewriteFrom(this.prefix, this.markers, this.from, identifier);
        }
    }

    public static final class Rewrite
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word rewrite;
        private final QualifiedDataName recordName;
        @Nullable
        private final RewriteFrom rewriteFrom;
        @Nullable
        private final StatementPhrase invalidKeyPhrase;
        @Nullable
        private final StatementPhrase notInvalidKeyPhrase;
        @Nullable
        private final Word endRewrite;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRewrite(this, p);
        }

        public Rewrite(Space prefix, Markers markers, Word rewrite, QualifiedDataName recordName, RewriteFrom rewriteFrom, StatementPhrase invalidKeyPhrase, StatementPhrase notInvalidKeyPhrase, Word endRewrite) {
            this.prefix = prefix;
            this.markers = markers;
            this.rewrite = rewrite;
            this.recordName = recordName;
            this.rewriteFrom = rewriteFrom;
            this.invalidKeyPhrase = invalidKeyPhrase;
            this.notInvalidKeyPhrase = notInvalidKeyPhrase;
            this.endRewrite = endRewrite;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getRewrite() {
            return this.rewrite;
        }

        public QualifiedDataName getRecordName() {
            return this.recordName;
        }

        public RewriteFrom getRewriteFrom() {
            return this.rewriteFrom;
        }

        public StatementPhrase getInvalidKeyPhrase() {
            return this.invalidKeyPhrase;
        }

        public StatementPhrase getNotInvalidKeyPhrase() {
            return this.notInvalidKeyPhrase;
        }

        public Word getEndRewrite() {
            return this.endRewrite;
        }

        public String toString() {
            return "Cobol.Rewrite(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", rewrite=" + this.getRewrite() + ", recordName=" + this.getRecordName() + ", rewriteFrom=" + this.getRewriteFrom() + ", invalidKeyPhrase=" + this.getInvalidKeyPhrase() + ", notInvalidKeyPhrase=" + this.getNotInvalidKeyPhrase() + ", endRewrite=" + this.getEndRewrite() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rewrite)) {
                return false;
            }
            Rewrite other = (Rewrite)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$rewrite = this.getRewrite();
            Word other$rewrite = other.getRewrite();
            if (this$rewrite == null ? other$rewrite != null : !((Object)this$rewrite).equals(other$rewrite)) {
                return false;
            }
            QualifiedDataName this$recordName = this.getRecordName();
            QualifiedDataName other$recordName = other.getRecordName();
            if (this$recordName == null ? other$recordName != null : !((Object)this$recordName).equals(other$recordName)) {
                return false;
            }
            RewriteFrom this$rewriteFrom = this.getRewriteFrom();
            RewriteFrom other$rewriteFrom = other.getRewriteFrom();
            if (this$rewriteFrom == null ? other$rewriteFrom != null : !((Object)this$rewriteFrom).equals(other$rewriteFrom)) {
                return false;
            }
            StatementPhrase this$invalidKeyPhrase = this.getInvalidKeyPhrase();
            StatementPhrase other$invalidKeyPhrase = other.getInvalidKeyPhrase();
            if (this$invalidKeyPhrase == null ? other$invalidKeyPhrase != null : !((Object)this$invalidKeyPhrase).equals(other$invalidKeyPhrase)) {
                return false;
            }
            StatementPhrase this$notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            StatementPhrase other$notInvalidKeyPhrase = other.getNotInvalidKeyPhrase();
            if (this$notInvalidKeyPhrase == null ? other$notInvalidKeyPhrase != null : !((Object)this$notInvalidKeyPhrase).equals(other$notInvalidKeyPhrase)) {
                return false;
            }
            Word this$endRewrite = this.getEndRewrite();
            Word other$endRewrite = other.getEndRewrite();
            return !(this$endRewrite == null ? other$endRewrite != null : !((Object)this$endRewrite).equals(other$endRewrite));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $rewrite = this.getRewrite();
            result = result * 59 + ($rewrite == null ? 43 : ((Object)$rewrite).hashCode());
            QualifiedDataName $recordName = this.getRecordName();
            result = result * 59 + ($recordName == null ? 43 : ((Object)$recordName).hashCode());
            RewriteFrom $rewriteFrom = this.getRewriteFrom();
            result = result * 59 + ($rewriteFrom == null ? 43 : ((Object)$rewriteFrom).hashCode());
            StatementPhrase $invalidKeyPhrase = this.getInvalidKeyPhrase();
            result = result * 59 + ($invalidKeyPhrase == null ? 43 : ((Object)$invalidKeyPhrase).hashCode());
            StatementPhrase $notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            result = result * 59 + ($notInvalidKeyPhrase == null ? 43 : ((Object)$notInvalidKeyPhrase).hashCode());
            Word $endRewrite = this.getEndRewrite();
            result = result * 59 + ($endRewrite == null ? 43 : ((Object)$endRewrite).hashCode());
            return result;
        }

        public Rewrite withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Rewrite(prefix, this.markers, this.rewrite, this.recordName, this.rewriteFrom, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withMarkers(Markers markers) {
            return this.markers == markers ? this : new Rewrite(this.prefix, markers, this.rewrite, this.recordName, this.rewriteFrom, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withRewrite(Word rewrite) {
            return this.rewrite == rewrite ? this : new Rewrite(this.prefix, this.markers, rewrite, this.recordName, this.rewriteFrom, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withRecordName(QualifiedDataName recordName) {
            return this.recordName == recordName ? this : new Rewrite(this.prefix, this.markers, this.rewrite, recordName, this.rewriteFrom, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withRewriteFrom(RewriteFrom rewriteFrom) {
            return this.rewriteFrom == rewriteFrom ? this : new Rewrite(this.prefix, this.markers, this.rewrite, this.recordName, rewriteFrom, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withInvalidKeyPhrase(StatementPhrase invalidKeyPhrase) {
            return this.invalidKeyPhrase == invalidKeyPhrase ? this : new Rewrite(this.prefix, this.markers, this.rewrite, this.recordName, this.rewriteFrom, invalidKeyPhrase, this.notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withNotInvalidKeyPhrase(StatementPhrase notInvalidKeyPhrase) {
            return this.notInvalidKeyPhrase == notInvalidKeyPhrase ? this : new Rewrite(this.prefix, this.markers, this.rewrite, this.recordName, this.rewriteFrom, this.invalidKeyPhrase, notInvalidKeyPhrase, this.endRewrite);
        }

        public Rewrite withEndRewrite(Word endRewrite) {
            return this.endRewrite == endRewrite ? this : new Rewrite(this.prefix, this.markers, this.rewrite, this.recordName, this.rewriteFrom, this.invalidKeyPhrase, this.notInvalidKeyPhrase, endRewrite);
        }
    }

    public static final class ReturnInto
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word into;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReturnInto(this, p);
        }

        public ReturnInto(Space prefix, Markers markers, Word into, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.into = into;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getInto() {
            return this.into;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.ReturnInto(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", into=" + this.getInto() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReturnInto)) {
                return false;
            }
            ReturnInto other = (ReturnInto)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$into = this.getInto();
            Word other$into = other.getInto();
            if (this$into == null ? other$into != null : !((Object)this$into).equals(other$into)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $into = this.getInto();
            result = result * 59 + ($into == null ? 43 : ((Object)$into).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public ReturnInto withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReturnInto(prefix, this.markers, this.into, this.qualifiedDataName);
        }

        public ReturnInto withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReturnInto(this.prefix, markers, this.into, this.qualifiedDataName);
        }

        public ReturnInto withInto(Word into) {
            return this.into == into ? this : new ReturnInto(this.prefix, this.markers, into, this.qualifiedDataName);
        }

        public ReturnInto withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new ReturnInto(this.prefix, this.markers, this.into, qualifiedDataName);
        }
    }

    public static final class Return
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Name fileName;
        @Nullable
        private final Word record;
        @Nullable
        private final ReturnInto into;
        private final StatementPhrase atEndPhrase;
        @Nullable
        private final StatementPhrase notAtEndPhrase;
        @Nullable
        private final Word endReturn;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReturn(this, p);
        }

        public Return(Space prefix, Markers markers, Word word, Name fileName, Word record, ReturnInto into, StatementPhrase atEndPhrase, StatementPhrase notAtEndPhrase, Word endReturn) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.fileName = fileName;
            this.record = record;
            this.into = into;
            this.atEndPhrase = atEndPhrase;
            this.notAtEndPhrase = notAtEndPhrase;
            this.endReturn = endReturn;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getFileName() {
            return this.fileName;
        }

        public Word getRecord() {
            return this.record;
        }

        public ReturnInto getInto() {
            return this.into;
        }

        public StatementPhrase getAtEndPhrase() {
            return this.atEndPhrase;
        }

        public StatementPhrase getNotAtEndPhrase() {
            return this.notAtEndPhrase;
        }

        public Word getEndReturn() {
            return this.endReturn;
        }

        public String toString() {
            return "Cobol.Return(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", fileName=" + this.getFileName() + ", record=" + this.getRecord() + ", into=" + this.getInto() + ", atEndPhrase=" + this.getAtEndPhrase() + ", notAtEndPhrase=" + this.getNotAtEndPhrase() + ", endReturn=" + this.getEndReturn() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$fileName = this.getFileName();
            Name other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            Word this$record = this.getRecord();
            Word other$record = other.getRecord();
            if (this$record == null ? other$record != null : !((Object)this$record).equals(other$record)) {
                return false;
            }
            ReturnInto this$into = this.getInto();
            ReturnInto other$into = other.getInto();
            if (this$into == null ? other$into != null : !((Object)this$into).equals(other$into)) {
                return false;
            }
            StatementPhrase this$atEndPhrase = this.getAtEndPhrase();
            StatementPhrase other$atEndPhrase = other.getAtEndPhrase();
            if (this$atEndPhrase == null ? other$atEndPhrase != null : !((Object)this$atEndPhrase).equals(other$atEndPhrase)) {
                return false;
            }
            StatementPhrase this$notAtEndPhrase = this.getNotAtEndPhrase();
            StatementPhrase other$notAtEndPhrase = other.getNotAtEndPhrase();
            if (this$notAtEndPhrase == null ? other$notAtEndPhrase != null : !((Object)this$notAtEndPhrase).equals(other$notAtEndPhrase)) {
                return false;
            }
            Word this$endReturn = this.getEndReturn();
            Word other$endReturn = other.getEndReturn();
            return !(this$endReturn == null ? other$endReturn != null : !((Object)this$endReturn).equals(other$endReturn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            Word $record = this.getRecord();
            result = result * 59 + ($record == null ? 43 : ((Object)$record).hashCode());
            ReturnInto $into = this.getInto();
            result = result * 59 + ($into == null ? 43 : ((Object)$into).hashCode());
            StatementPhrase $atEndPhrase = this.getAtEndPhrase();
            result = result * 59 + ($atEndPhrase == null ? 43 : ((Object)$atEndPhrase).hashCode());
            StatementPhrase $notAtEndPhrase = this.getNotAtEndPhrase();
            result = result * 59 + ($notAtEndPhrase == null ? 43 : ((Object)$notAtEndPhrase).hashCode());
            Word $endReturn = this.getEndReturn();
            result = result * 59 + ($endReturn == null ? 43 : ((Object)$endReturn).hashCode());
            return result;
        }

        public Return withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Return(prefix, this.markers, this.word, this.fileName, this.record, this.into, this.atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.prefix, markers, this.word, this.fileName, this.record, this.into, this.atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withWord(Word word) {
            return this.word == word ? this : new Return(this.prefix, this.markers, word, this.fileName, this.record, this.into, this.atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withFileName(Name fileName) {
            return this.fileName == fileName ? this : new Return(this.prefix, this.markers, this.word, fileName, this.record, this.into, this.atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withRecord(Word record) {
            return this.record == record ? this : new Return(this.prefix, this.markers, this.word, this.fileName, record, this.into, this.atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withInto(ReturnInto into) {
            return this.into == into ? this : new Return(this.prefix, this.markers, this.word, this.fileName, this.record, into, this.atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withAtEndPhrase(StatementPhrase atEndPhrase) {
            return this.atEndPhrase == atEndPhrase ? this : new Return(this.prefix, this.markers, this.word, this.fileName, this.record, this.into, atEndPhrase, this.notAtEndPhrase, this.endReturn);
        }

        public Return withNotAtEndPhrase(StatementPhrase notAtEndPhrase) {
            return this.notAtEndPhrase == notAtEndPhrase ? this : new Return(this.prefix, this.markers, this.word, this.fileName, this.record, this.into, this.atEndPhrase, notAtEndPhrase, this.endReturn);
        }

        public Return withEndReturn(Word endReturn) {
            return this.endReturn == endReturn ? this : new Return(this.prefix, this.markers, this.word, this.fileName, this.record, this.into, this.atEndPhrase, this.notAtEndPhrase, endReturn);
        }
    }

    public static final class ReserveNetworkClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReserveNetworkClause(this, p);
        }

        public ReserveNetworkClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReserveNetworkClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReserveNetworkClause)) {
                return false;
            }
            ReserveNetworkClause other = (ReserveNetworkClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReserveNetworkClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReserveNetworkClause(prefix, this.markers, this.words);
        }

        public ReserveNetworkClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReserveNetworkClause(this.prefix, markers, this.words);
        }

        public ReserveNetworkClause withWords(List<Word> words) {
            return this.words == words ? this : new ReserveNetworkClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReserveClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReserveClause(this, p);
        }

        public ReserveClause(Space prefix, Markers markers, List<Cobol> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReserveClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReserveClause)) {
                return false;
            }
            ReserveClause other = (ReserveClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$words = this.getWords();
            List<Cobol> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReserveClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReserveClause(prefix, this.markers, this.words);
        }

        public ReserveClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReserveClause(this.prefix, markers, this.words);
        }

        public ReserveClause withWords(List<Cobol> words) {
            return this.words == words ? this : new ReserveClause(this.prefix, this.markers, words);
        }
    }

    public static final class RerunEveryRecords
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word integerLiteral;
        private final Word records;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRerunEveryRecords(this, p);
        }

        public RerunEveryRecords(Space prefix, Markers markers, Word integerLiteral, Word records) {
            this.prefix = prefix;
            this.markers = markers;
            this.integerLiteral = integerLiteral;
            this.records = records;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getRecords() {
            return this.records;
        }

        public String toString() {
            return "Cobol.RerunEveryRecords(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", integerLiteral=" + this.getIntegerLiteral() + ", records=" + this.getRecords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RerunEveryRecords)) {
                return false;
            }
            RerunEveryRecords other = (RerunEveryRecords)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            Word this$records = this.getRecords();
            Word other$records = other.getRecords();
            return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            Word $records = this.getRecords();
            result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
            return result;
        }

        public RerunEveryRecords withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RerunEveryRecords(prefix, this.markers, this.integerLiteral, this.records);
        }

        public RerunEveryRecords withMarkers(Markers markers) {
            return this.markers == markers ? this : new RerunEveryRecords(this.prefix, markers, this.integerLiteral, this.records);
        }

        public RerunEveryRecords withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new RerunEveryRecords(this.prefix, this.markers, integerLiteral, this.records);
        }

        public RerunEveryRecords withRecords(Word records) {
            return this.records == records ? this : new RerunEveryRecords(this.prefix, this.markers, this.integerLiteral, records);
        }
    }

    public static final class RerunEveryOf
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> records;
        private final Word fileName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRerunEveryOf(this, p);
        }

        public RerunEveryOf(Space prefix, Markers markers, List<Word> records, Word fileName) {
            this.prefix = prefix;
            this.markers = markers;
            this.records = records;
            this.fileName = fileName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getRecords() {
            return this.records;
        }

        public Word getFileName() {
            return this.fileName;
        }

        public String toString() {
            return "Cobol.RerunEveryOf(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", records=" + this.getRecords() + ", fileName=" + this.getFileName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RerunEveryOf)) {
                return false;
            }
            RerunEveryOf other = (RerunEveryOf)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$records = this.getRecords();
            List<Word> other$records = other.getRecords();
            if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
                return false;
            }
            Word this$fileName = this.getFileName();
            Word other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !((Object)this$fileName).equals(other$fileName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $records = this.getRecords();
            result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
            Word $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : ((Object)$fileName).hashCode());
            return result;
        }

        public RerunEveryOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RerunEveryOf(prefix, this.markers, this.records, this.fileName);
        }

        public RerunEveryOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new RerunEveryOf(this.prefix, markers, this.records, this.fileName);
        }

        public RerunEveryOf withRecords(List<Word> records) {
            return this.records == records ? this : new RerunEveryOf(this.prefix, this.markers, records, this.fileName);
        }

        public RerunEveryOf withFileName(Word fileName) {
            return this.fileName == fileName ? this : new RerunEveryOf(this.prefix, this.markers, this.records, fileName);
        }
    }

    public static final class RerunEveryClock
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word integerLiteral;
        @Nullable
        private final Word clockUnits;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRerunEveryClock(this, p);
        }

        public RerunEveryClock(Space prefix, Markers markers, Word integerLiteral, Word clockUnits) {
            this.prefix = prefix;
            this.markers = markers;
            this.integerLiteral = integerLiteral;
            this.clockUnits = clockUnits;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getClockUnits() {
            return this.clockUnits;
        }

        public String toString() {
            return "Cobol.RerunEveryClock(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", integerLiteral=" + this.getIntegerLiteral() + ", clockUnits=" + this.getClockUnits() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RerunEveryClock)) {
                return false;
            }
            RerunEveryClock other = (RerunEveryClock)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            Word this$clockUnits = this.getClockUnits();
            Word other$clockUnits = other.getClockUnits();
            return !(this$clockUnits == null ? other$clockUnits != null : !((Object)this$clockUnits).equals(other$clockUnits));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            Word $clockUnits = this.getClockUnits();
            result = result * 59 + ($clockUnits == null ? 43 : ((Object)$clockUnits).hashCode());
            return result;
        }

        public RerunEveryClock withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RerunEveryClock(prefix, this.markers, this.integerLiteral, this.clockUnits);
        }

        public RerunEveryClock withMarkers(Markers markers) {
            return this.markers == markers ? this : new RerunEveryClock(this.prefix, markers, this.integerLiteral, this.clockUnits);
        }

        public RerunEveryClock withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new RerunEveryClock(this.prefix, this.markers, integerLiteral, this.clockUnits);
        }

        public RerunEveryClock withClockUnits(Word clockUnits) {
            return this.clockUnits == clockUnits ? this : new RerunEveryClock(this.prefix, this.markers, this.integerLiteral, clockUnits);
        }
    }

    public static final class RerunClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word rerun;
        @Nullable
        private final Word on;
        @Nullable
        private final Word name;
        private final Word every;
        private final Cobol action;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRerunClause(this, p);
        }

        public RerunClause(Space prefix, Markers markers, Word rerun, Word on, Word name, Word every, Cobol action) {
            this.prefix = prefix;
            this.markers = markers;
            this.rerun = rerun;
            this.on = on;
            this.name = name;
            this.every = every;
            this.action = action;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getRerun() {
            return this.rerun;
        }

        public Word getOn() {
            return this.on;
        }

        public Word getName() {
            return this.name;
        }

        public Word getEvery() {
            return this.every;
        }

        public Cobol getAction() {
            return this.action;
        }

        public String toString() {
            return "Cobol.RerunClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", rerun=" + this.getRerun() + ", on=" + this.getOn() + ", name=" + this.getName() + ", every=" + this.getEvery() + ", action=" + this.getAction() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RerunClause)) {
                return false;
            }
            RerunClause other = (RerunClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$rerun = this.getRerun();
            Word other$rerun = other.getRerun();
            if (this$rerun == null ? other$rerun != null : !((Object)this$rerun).equals(other$rerun)) {
                return false;
            }
            Word this$on = this.getOn();
            Word other$on = other.getOn();
            if (this$on == null ? other$on != null : !((Object)this$on).equals(other$on)) {
                return false;
            }
            Word this$name = this.getName();
            Word other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            Word this$every = this.getEvery();
            Word other$every = other.getEvery();
            if (this$every == null ? other$every != null : !((Object)this$every).equals(other$every)) {
                return false;
            }
            Cobol this$action = this.getAction();
            Cobol other$action = other.getAction();
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $rerun = this.getRerun();
            result = result * 59 + ($rerun == null ? 43 : ((Object)$rerun).hashCode());
            Word $on = this.getOn();
            result = result * 59 + ($on == null ? 43 : ((Object)$on).hashCode());
            Word $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            Word $every = this.getEvery();
            result = result * 59 + ($every == null ? 43 : ((Object)$every).hashCode());
            Cobol $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }

        public RerunClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RerunClause(prefix, this.markers, this.rerun, this.on, this.name, this.every, this.action);
        }

        public RerunClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new RerunClause(this.prefix, markers, this.rerun, this.on, this.name, this.every, this.action);
        }

        public RerunClause withRerun(Word rerun) {
            return this.rerun == rerun ? this : new RerunClause(this.prefix, this.markers, rerun, this.on, this.name, this.every, this.action);
        }

        public RerunClause withOn(Word on) {
            return this.on == on ? this : new RerunClause(this.prefix, this.markers, this.rerun, on, this.name, this.every, this.action);
        }

        public RerunClause withName(Word name) {
            return this.name == name ? this : new RerunClause(this.prefix, this.markers, this.rerun, this.on, name, this.every, this.action);
        }

        public RerunClause withEvery(Word every) {
            return this.every == every ? this : new RerunClause(this.prefix, this.markers, this.rerun, this.on, this.name, every, this.action);
        }

        public RerunClause withAction(Cobol action) {
            return this.action == action ? this : new RerunClause(this.prefix, this.markers, this.rerun, this.on, this.name, this.every, action);
        }
    }

    public static final class ReportSection
    implements DataDivisionSection {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Cobol> descriptions;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportSection(this, p);
        }

        public ReportSection(Space prefix, Markers markers, List<Word> words, List<Cobol> descriptions) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.descriptions = descriptions;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Cobol> getDescriptions() {
            return this.descriptions;
        }

        public String toString() {
            return "Cobol.ReportSection(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", descriptions=" + this.getDescriptions() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportSection)) {
                return false;
            }
            ReportSection other = (ReportSection)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Cobol> this$descriptions = this.getDescriptions();
            List<Cobol> other$descriptions = other.getDescriptions();
            return !(this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Cobol> $descriptions = this.getDescriptions();
            result = result * 59 + ($descriptions == null ? 43 : ((Object)$descriptions).hashCode());
            return result;
        }

        public ReportSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportSection(prefix, this.markers, this.words, this.descriptions);
        }

        public ReportSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportSection(this.prefix, markers, this.words, this.descriptions);
        }

        public ReportSection withWords(List<Word> words) {
            return this.words == words ? this : new ReportSection(this.prefix, this.markers, words, this.descriptions);
        }

        public ReportSection withDescriptions(List<Cobol> descriptions) {
            return this.descriptions == descriptions ? this : new ReportSection(this.prefix, this.markers, this.words, descriptions);
        }
    }

    public static final class ReportName
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportName(this, p);
        }

        public ReportName(Space prefix, Markers markers, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.ReportName(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportName)) {
                return false;
            }
            ReportName other = (ReportName)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public ReportName withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportName(prefix, this.markers, this.qualifiedDataName);
        }

        public ReportName withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportName(this.prefix, markers, this.qualifiedDataName);
        }

        public ReportName withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new ReportName(this.prefix, this.markers, qualifiedDataName);
        }
    }

    public static final class ReportGroupValueClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name literal;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupValueClause(this, p);
        }

        public ReportGroupValueClause(Space prefix, Markers markers, List<Word> words, Name literal) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.literal = literal;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getLiteral() {
            return this.literal;
        }

        public String toString() {
            return "Cobol.ReportGroupValueClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", literal=" + this.getLiteral() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupValueClause)) {
                return false;
            }
            ReportGroupValueClause other = (ReportGroupValueClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$literal = this.getLiteral();
            Name other$literal = other.getLiteral();
            return !(this$literal == null ? other$literal != null : !this$literal.equals(other$literal));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $literal = this.getLiteral();
            result = result * 59 + ($literal == null ? 43 : $literal.hashCode());
            return result;
        }

        public ReportGroupValueClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupValueClause(prefix, this.markers, this.words, this.literal);
        }

        public ReportGroupValueClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupValueClause(this.prefix, markers, this.words, this.literal);
        }

        public ReportGroupValueClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupValueClause(this.prefix, this.markers, words, this.literal);
        }

        public ReportGroupValueClause withLiteral(Name literal) {
            return this.literal == literal ? this : new ReportGroupValueClause(this.prefix, this.markers, this.words, literal);
        }
    }

    public static final class ReportGroupUsageClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupUsageClause(this, p);
        }

        public ReportGroupUsageClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupUsageClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupUsageClause)) {
                return false;
            }
            ReportGroupUsageClause other = (ReportGroupUsageClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupUsageClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupUsageClause(prefix, this.markers, this.words);
        }

        public ReportGroupUsageClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupUsageClause(this.prefix, markers, this.words);
        }

        public ReportGroupUsageClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupUsageClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupTypeReportHeading
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypeReportHeading(this, p);
        }

        public ReportGroupTypeReportHeading(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupTypeReportHeading(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypeReportHeading)) {
                return false;
            }
            ReportGroupTypeReportHeading other = (ReportGroupTypeReportHeading)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupTypeReportHeading withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypeReportHeading(prefix, this.markers, this.words);
        }

        public ReportGroupTypeReportHeading withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypeReportHeading(this.prefix, markers, this.words);
        }

        public ReportGroupTypeReportHeading withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypeReportHeading(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupTypeReportFooting
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypeReportFooting(this, p);
        }

        public ReportGroupTypeReportFooting(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupTypeReportFooting(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypeReportFooting)) {
                return false;
            }
            ReportGroupTypeReportFooting other = (ReportGroupTypeReportFooting)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupTypeReportFooting withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypeReportFooting(prefix, this.markers, this.words);
        }

        public ReportGroupTypeReportFooting withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypeReportFooting(this.prefix, markers, this.words);
        }

        public ReportGroupTypeReportFooting withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypeReportFooting(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupTypePageHeading
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypePageHeading(this, p);
        }

        public ReportGroupTypePageHeading(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupTypePageHeading(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypePageHeading)) {
                return false;
            }
            ReportGroupTypePageHeading other = (ReportGroupTypePageHeading)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupTypePageHeading withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypePageHeading(prefix, this.markers, this.words);
        }

        public ReportGroupTypePageHeading withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypePageHeading(this.prefix, markers, this.words);
        }

        public ReportGroupTypePageHeading withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypePageHeading(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupTypePageFooting
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypePageFooting(this, p);
        }

        public ReportGroupTypePageFooting(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupTypePageFooting(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypePageFooting)) {
                return false;
            }
            ReportGroupTypePageFooting other = (ReportGroupTypePageFooting)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupTypePageFooting withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypePageFooting(prefix, this.markers, this.words);
        }

        public ReportGroupTypePageFooting withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypePageFooting(this.prefix, markers, this.words);
        }

        public ReportGroupTypePageFooting withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypePageFooting(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupTypeDetail
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypeDetail(this, p);
        }

        public ReportGroupTypeDetail(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupTypeDetail(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypeDetail)) {
                return false;
            }
            ReportGroupTypeDetail other = (ReportGroupTypeDetail)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupTypeDetail withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypeDetail(prefix, this.markers, this.words);
        }

        public ReportGroupTypeDetail withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypeDetail(this.prefix, markers, this.words);
        }

        public ReportGroupTypeDetail withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypeDetail(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupTypeControlHeading
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypeControlHeading(this, p);
        }

        public ReportGroupTypeControlHeading(Space prefix, Markers markers, List<Word> words, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportGroupTypeControlHeading(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypeControlHeading)) {
                return false;
            }
            ReportGroupTypeControlHeading other = (ReportGroupTypeControlHeading)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportGroupTypeControlHeading withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypeControlHeading(prefix, this.markers, this.words, this.dataName);
        }

        public ReportGroupTypeControlHeading withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypeControlHeading(this.prefix, markers, this.words, this.dataName);
        }

        public ReportGroupTypeControlHeading withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypeControlHeading(this.prefix, this.markers, words, this.dataName);
        }

        public ReportGroupTypeControlHeading withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportGroupTypeControlHeading(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class ReportGroupTypeControlFooting
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypeControlFooting(this, p);
        }

        public ReportGroupTypeControlFooting(Space prefix, Markers markers, List<Word> words, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportGroupTypeControlFooting(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypeControlFooting)) {
                return false;
            }
            ReportGroupTypeControlFooting other = (ReportGroupTypeControlFooting)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportGroupTypeControlFooting withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypeControlFooting(prefix, this.markers, this.words, this.dataName);
        }

        public ReportGroupTypeControlFooting withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypeControlFooting(this.prefix, markers, this.words, this.dataName);
        }

        public ReportGroupTypeControlFooting withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypeControlFooting(this.prefix, this.markers, words, this.dataName);
        }

        public ReportGroupTypeControlFooting withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportGroupTypeControlFooting(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class ReportGroupTypeClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Cobol type;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupTypeClause(this, p);
        }

        public ReportGroupTypeClause(Space prefix, Markers markers, List<Word> words, Cobol type) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.type = type;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getType() {
            return this.type;
        }

        public String toString() {
            return "Cobol.ReportGroupTypeClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", type=" + this.getType() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupTypeClause)) {
                return false;
            }
            ReportGroupTypeClause other = (ReportGroupTypeClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$type = this.getType();
            Cobol other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public ReportGroupTypeClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupTypeClause(prefix, this.markers, this.words, this.type);
        }

        public ReportGroupTypeClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupTypeClause(this.prefix, markers, this.words, this.type);
        }

        public ReportGroupTypeClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupTypeClause(this.prefix, this.markers, words, this.type);
        }

        public ReportGroupTypeClause withType(Cobol type) {
            return this.type == type ? this : new ReportGroupTypeClause(this.prefix, this.markers, this.words, type);
        }
    }

    public static final class ReportGroupSumClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> cobols;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupSumClause(this, p);
        }

        public ReportGroupSumClause(Space prefix, Markers markers, List<Cobol> cobols) {
            this.prefix = prefix;
            this.markers = markers;
            this.cobols = cobols;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getCobols() {
            return this.cobols;
        }

        public String toString() {
            return "Cobol.ReportGroupSumClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", cobols=" + this.getCobols() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupSumClause)) {
                return false;
            }
            ReportGroupSumClause other = (ReportGroupSumClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$cobols = this.getCobols();
            List<Cobol> other$cobols = other.getCobols();
            return !(this$cobols == null ? other$cobols != null : !((Object)this$cobols).equals(other$cobols));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $cobols = this.getCobols();
            result = result * 59 + ($cobols == null ? 43 : ((Object)$cobols).hashCode());
            return result;
        }

        public ReportGroupSumClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupSumClause(prefix, this.markers, this.cobols);
        }

        public ReportGroupSumClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupSumClause(this.prefix, markers, this.cobols);
        }

        public ReportGroupSumClause withCobols(List<Cobol> cobols) {
            return this.cobols == cobols ? this : new ReportGroupSumClause(this.prefix, this.markers, cobols);
        }
    }

    public static final class ReportGroupSourceClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupSourceClause(this, p);
        }

        public ReportGroupSourceClause(Space prefix, Markers markers, List<Word> words, Name identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.ReportGroupSourceClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupSourceClause)) {
                return false;
            }
            ReportGroupSourceClause other = (ReportGroupSourceClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$identifier = this.getIdentifier();
            Name other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public ReportGroupSourceClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupSourceClause(prefix, this.markers, this.words, this.identifier);
        }

        public ReportGroupSourceClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupSourceClause(this.prefix, markers, this.words, this.identifier);
        }

        public ReportGroupSourceClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupSourceClause(this.prefix, this.markers, words, this.identifier);
        }

        public ReportGroupSourceClause withIdentifier(Name identifier) {
            return this.identifier == identifier ? this : new ReportGroupSourceClause(this.prefix, this.markers, this.words, identifier);
        }
    }

    public static final class ReportGroupSignClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupSignClause(this, p);
        }

        public ReportGroupSignClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupSignClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupSignClause)) {
                return false;
            }
            ReportGroupSignClause other = (ReportGroupSignClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupSignClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupSignClause(prefix, this.markers, this.words);
        }

        public ReportGroupSignClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupSignClause(this.prefix, markers, this.words);
        }

        public ReportGroupSignClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupSignClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupResetClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupResetClause(this, p);
        }

        public ReportGroupResetClause(Space prefix, Markers markers, List<Word> words, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportGroupResetClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupResetClause)) {
                return false;
            }
            ReportGroupResetClause other = (ReportGroupResetClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportGroupResetClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupResetClause(prefix, this.markers, this.words, this.dataName);
        }

        public ReportGroupResetClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupResetClause(this.prefix, markers, this.words, this.dataName);
        }

        public ReportGroupResetClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupResetClause(this.prefix, this.markers, words, this.dataName);
        }

        public ReportGroupResetClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportGroupResetClause(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class ReportGroupPictureClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final PictureString pictureString;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupPictureClause(this, p);
        }

        public ReportGroupPictureClause(Space prefix, Markers markers, List<Word> words, PictureString pictureString) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.pictureString = pictureString;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public PictureString getPictureString() {
            return this.pictureString;
        }

        public String toString() {
            return "Cobol.ReportGroupPictureClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", pictureString=" + this.getPictureString() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupPictureClause)) {
                return false;
            }
            ReportGroupPictureClause other = (ReportGroupPictureClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            PictureString this$pictureString = this.getPictureString();
            PictureString other$pictureString = other.getPictureString();
            return !(this$pictureString == null ? other$pictureString != null : !((Object)this$pictureString).equals(other$pictureString));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            PictureString $pictureString = this.getPictureString();
            result = result * 59 + ($pictureString == null ? 43 : ((Object)$pictureString).hashCode());
            return result;
        }

        public ReportGroupPictureClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupPictureClause(prefix, this.markers, this.words, this.pictureString);
        }

        public ReportGroupPictureClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupPictureClause(this.prefix, markers, this.words, this.pictureString);
        }

        public ReportGroupPictureClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupPictureClause(this.prefix, this.markers, words, this.pictureString);
        }

        public ReportGroupPictureClause withPictureString(PictureString pictureString) {
            return this.pictureString == pictureString ? this : new ReportGroupPictureClause(this.prefix, this.markers, this.words, pictureString);
        }
    }

    public static final class ReportGroupNextGroupPlus
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word plus;
        private final Word integerLiteral;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupNextGroupPlus(this, p);
        }

        public ReportGroupNextGroupPlus(Space prefix, Markers markers, Word plus, Word integerLiteral) {
            this.prefix = prefix;
            this.markers = markers;
            this.plus = plus;
            this.integerLiteral = integerLiteral;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getPlus() {
            return this.plus;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public String toString() {
            return "Cobol.ReportGroupNextGroupPlus(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", plus=" + this.getPlus() + ", integerLiteral=" + this.getIntegerLiteral() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupNextGroupPlus)) {
                return false;
            }
            ReportGroupNextGroupPlus other = (ReportGroupNextGroupPlus)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$plus = this.getPlus();
            Word other$plus = other.getPlus();
            if (this$plus == null ? other$plus != null : !((Object)this$plus).equals(other$plus)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            return !(this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $plus = this.getPlus();
            result = result * 59 + ($plus == null ? 43 : ((Object)$plus).hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            return result;
        }

        public ReportGroupNextGroupPlus withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupNextGroupPlus(prefix, this.markers, this.plus, this.integerLiteral);
        }

        public ReportGroupNextGroupPlus withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupNextGroupPlus(this.prefix, markers, this.plus, this.integerLiteral);
        }

        public ReportGroupNextGroupPlus withPlus(Word plus) {
            return this.plus == plus ? this : new ReportGroupNextGroupPlus(this.prefix, this.markers, plus, this.integerLiteral);
        }

        public ReportGroupNextGroupPlus withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportGroupNextGroupPlus(this.prefix, this.markers, this.plus, integerLiteral);
        }
    }

    public static final class ReportGroupNextGroupNextPage
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> nextPage;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupNextGroupNextPage(this, p);
        }

        public ReportGroupNextGroupNextPage(Space prefix, Markers markers, List<Word> nextPage) {
            this.prefix = prefix;
            this.markers = markers;
            this.nextPage = nextPage;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getNextPage() {
            return this.nextPage;
        }

        public String toString() {
            return "Cobol.ReportGroupNextGroupNextPage(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", nextPage=" + this.getNextPage() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupNextGroupNextPage)) {
                return false;
            }
            ReportGroupNextGroupNextPage other = (ReportGroupNextGroupNextPage)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$nextPage = this.getNextPage();
            List<Word> other$nextPage = other.getNextPage();
            return !(this$nextPage == null ? other$nextPage != null : !((Object)this$nextPage).equals(other$nextPage));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $nextPage = this.getNextPage();
            result = result * 59 + ($nextPage == null ? 43 : ((Object)$nextPage).hashCode());
            return result;
        }

        public ReportGroupNextGroupNextPage withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupNextGroupNextPage(prefix, this.markers, this.nextPage);
        }

        public ReportGroupNextGroupNextPage withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupNextGroupNextPage(this.prefix, markers, this.nextPage);
        }

        public ReportGroupNextGroupNextPage withNextPage(List<Word> nextPage) {
            return this.nextPage == nextPage ? this : new ReportGroupNextGroupNextPage(this.prefix, this.markers, nextPage);
        }
    }

    public static final class ReportGroupNextGroupClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Cobol clause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupNextGroupClause(this, p);
        }

        public ReportGroupNextGroupClause(Space prefix, Markers markers, List<Word> words, Cobol clause) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.clause = clause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getClause() {
            return this.clause;
        }

        public String toString() {
            return "Cobol.ReportGroupNextGroupClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", clause=" + this.getClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupNextGroupClause)) {
                return false;
            }
            ReportGroupNextGroupClause other = (ReportGroupNextGroupClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$clause = this.getClause();
            Cobol other$clause = other.getClause();
            return !(this$clause == null ? other$clause != null : !this$clause.equals(other$clause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $clause = this.getClause();
            result = result * 59 + ($clause == null ? 43 : $clause.hashCode());
            return result;
        }

        public ReportGroupNextGroupClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupNextGroupClause(prefix, this.markers, this.words, this.clause);
        }

        public ReportGroupNextGroupClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupNextGroupClause(this.prefix, markers, this.words, this.clause);
        }

        public ReportGroupNextGroupClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupNextGroupClause(this.prefix, this.markers, words, this.clause);
        }

        public ReportGroupNextGroupClause withClause(Cobol clause) {
            return this.clause == clause ? this : new ReportGroupNextGroupClause(this.prefix, this.markers, this.words, clause);
        }
    }

    public static final class ReportGroupLineNumberPlus
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word plus;
        private final Word integerLiteral;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupLineNumberPlus(this, p);
        }

        public ReportGroupLineNumberPlus(Space prefix, Markers markers, Word plus, Word integerLiteral) {
            this.prefix = prefix;
            this.markers = markers;
            this.plus = plus;
            this.integerLiteral = integerLiteral;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getPlus() {
            return this.plus;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public String toString() {
            return "Cobol.ReportGroupLineNumberPlus(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", plus=" + this.getPlus() + ", integerLiteral=" + this.getIntegerLiteral() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupLineNumberPlus)) {
                return false;
            }
            ReportGroupLineNumberPlus other = (ReportGroupLineNumberPlus)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$plus = this.getPlus();
            Word other$plus = other.getPlus();
            if (this$plus == null ? other$plus != null : !((Object)this$plus).equals(other$plus)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            return !(this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $plus = this.getPlus();
            result = result * 59 + ($plus == null ? 43 : ((Object)$plus).hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            return result;
        }

        public ReportGroupLineNumberPlus withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupLineNumberPlus(prefix, this.markers, this.plus, this.integerLiteral);
        }

        public ReportGroupLineNumberPlus withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupLineNumberPlus(this.prefix, markers, this.plus, this.integerLiteral);
        }

        public ReportGroupLineNumberPlus withPlus(Word plus) {
            return this.plus == plus ? this : new ReportGroupLineNumberPlus(this.prefix, this.markers, plus, this.integerLiteral);
        }

        public ReportGroupLineNumberPlus withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportGroupLineNumberPlus(this.prefix, this.markers, this.plus, integerLiteral);
        }
    }

    public static final class ReportGroupLineNumberNextPage
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word integerLiteral;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupLineNumberNextPage(this, p);
        }

        public ReportGroupLineNumberNextPage(Space prefix, Markers markers, Word integerLiteral, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.integerLiteral = integerLiteral;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupLineNumberNextPage(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", integerLiteral=" + this.getIntegerLiteral() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupLineNumberNextPage)) {
                return false;
            }
            ReportGroupLineNumberNextPage other = (ReportGroupLineNumberNextPage)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupLineNumberNextPage withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupLineNumberNextPage(prefix, this.markers, this.integerLiteral, this.words);
        }

        public ReportGroupLineNumberNextPage withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupLineNumberNextPage(this.prefix, markers, this.integerLiteral, this.words);
        }

        public ReportGroupLineNumberNextPage withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportGroupLineNumberNextPage(this.prefix, this.markers, integerLiteral, this.words);
        }

        public ReportGroupLineNumberNextPage withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupLineNumberNextPage(this.prefix, this.markers, this.integerLiteral, words);
        }
    }

    public static final class ReportGroupLineNumberClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Cobol clause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupLineNumberClause(this, p);
        }

        public ReportGroupLineNumberClause(Space prefix, Markers markers, List<Word> words, Cobol clause) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.clause = clause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Cobol getClause() {
            return this.clause;
        }

        public String toString() {
            return "Cobol.ReportGroupLineNumberClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", clause=" + this.getClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupLineNumberClause)) {
                return false;
            }
            ReportGroupLineNumberClause other = (ReportGroupLineNumberClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Cobol this$clause = this.getClause();
            Cobol other$clause = other.getClause();
            return !(this$clause == null ? other$clause != null : !this$clause.equals(other$clause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Cobol $clause = this.getClause();
            result = result * 59 + ($clause == null ? 43 : $clause.hashCode());
            return result;
        }

        public ReportGroupLineNumberClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupLineNumberClause(prefix, this.markers, this.words, this.clause);
        }

        public ReportGroupLineNumberClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupLineNumberClause(this.prefix, markers, this.words, this.clause);
        }

        public ReportGroupLineNumberClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupLineNumberClause(this.prefix, this.markers, words, this.clause);
        }

        public ReportGroupLineNumberClause withClause(Cobol clause) {
            return this.clause == clause ? this : new ReportGroupLineNumberClause(this.prefix, this.markers, this.words, clause);
        }
    }

    public static final class ReportGroupJustifiedClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupJustifiedClause(this, p);
        }

        public ReportGroupJustifiedClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupJustifiedClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupJustifiedClause)) {
                return false;
            }
            ReportGroupJustifiedClause other = (ReportGroupJustifiedClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupJustifiedClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupJustifiedClause(prefix, this.markers, this.words);
        }

        public ReportGroupJustifiedClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupJustifiedClause(this.prefix, markers, this.words);
        }

        public ReportGroupJustifiedClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupJustifiedClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupIndicateClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupIndicateClause(this, p);
        }

        public ReportGroupIndicateClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupIndicateClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupIndicateClause)) {
                return false;
            }
            ReportGroupIndicateClause other = (ReportGroupIndicateClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupIndicateClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupIndicateClause(prefix, this.markers, this.words);
        }

        public ReportGroupIndicateClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupIndicateClause(this.prefix, markers, this.words);
        }

        public ReportGroupIndicateClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupIndicateClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReportGroupDescriptionEntryFormat3
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word integerLiteral;
        @Nullable
        private final Word dataName;
        @Nullable
        private final List<Cobol> clauses;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupDescriptionEntryFormat3(this, p);
        }

        public ReportGroupDescriptionEntryFormat3(Space prefix, Markers markers, Word integerLiteral, Word dataName, List<Cobol> clauses, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.integerLiteral = integerLiteral;
            this.dataName = dataName;
            this.clauses = clauses;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getDataName() {
            return this.dataName;
        }

        public List<Cobol> getClauses() {
            return this.clauses;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.ReportGroupDescriptionEntryFormat3(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", integerLiteral=" + this.getIntegerLiteral() + ", dataName=" + this.getDataName() + ", clauses=" + this.getClauses() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupDescriptionEntryFormat3)) {
                return false;
            }
            ReportGroupDescriptionEntryFormat3 other = (ReportGroupDescriptionEntryFormat3)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            Word this$dataName = this.getDataName();
            Word other$dataName = other.getDataName();
            if (this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName)) {
                return false;
            }
            List<Cobol> this$clauses = this.getClauses();
            List<Cobol> other$clauses = other.getClauses();
            if (this$clauses == null ? other$clauses != null : !((Object)this$clauses).equals(other$clauses)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            Word $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
            List<Cobol> $clauses = this.getClauses();
            result = result * 59 + ($clauses == null ? 43 : ((Object)$clauses).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ReportGroupDescriptionEntryFormat3 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupDescriptionEntryFormat3(prefix, this.markers, this.integerLiteral, this.dataName, this.clauses, this.dot);
        }

        public ReportGroupDescriptionEntryFormat3 withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupDescriptionEntryFormat3(this.prefix, markers, this.integerLiteral, this.dataName, this.clauses, this.dot);
        }

        public ReportGroupDescriptionEntryFormat3 withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportGroupDescriptionEntryFormat3(this.prefix, this.markers, integerLiteral, this.dataName, this.clauses, this.dot);
        }

        public ReportGroupDescriptionEntryFormat3 withDataName(Word dataName) {
            return this.dataName == dataName ? this : new ReportGroupDescriptionEntryFormat3(this.prefix, this.markers, this.integerLiteral, dataName, this.clauses, this.dot);
        }

        public ReportGroupDescriptionEntryFormat3 withClauses(List<Cobol> clauses) {
            return this.clauses == clauses ? this : new ReportGroupDescriptionEntryFormat3(this.prefix, this.markers, this.integerLiteral, this.dataName, clauses, this.dot);
        }

        public ReportGroupDescriptionEntryFormat3 withDot(Word dot) {
            return this.dot == dot ? this : new ReportGroupDescriptionEntryFormat3(this.prefix, this.markers, this.integerLiteral, this.dataName, this.clauses, dot);
        }
    }

    public static final class ReportGroupDescriptionEntryFormat2
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word integerLiteral;
        @Nullable
        private final Word dataName;
        @Nullable
        private final ReportGroupLineNumberClause reportGroupLineNumberClause;
        private final ReportGroupUsageClause groupUsageClause;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupDescriptionEntryFormat2(this, p);
        }

        public ReportGroupDescriptionEntryFormat2(Space prefix, Markers markers, Word integerLiteral, Word dataName, ReportGroupLineNumberClause reportGroupLineNumberClause, ReportGroupUsageClause groupUsageClause, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.integerLiteral = integerLiteral;
            this.dataName = dataName;
            this.reportGroupLineNumberClause = reportGroupLineNumberClause;
            this.groupUsageClause = groupUsageClause;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getDataName() {
            return this.dataName;
        }

        public ReportGroupLineNumberClause getReportGroupLineNumberClause() {
            return this.reportGroupLineNumberClause;
        }

        public ReportGroupUsageClause getGroupUsageClause() {
            return this.groupUsageClause;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.ReportGroupDescriptionEntryFormat2(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", integerLiteral=" + this.getIntegerLiteral() + ", dataName=" + this.getDataName() + ", reportGroupLineNumberClause=" + this.getReportGroupLineNumberClause() + ", groupUsageClause=" + this.getGroupUsageClause() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupDescriptionEntryFormat2)) {
                return false;
            }
            ReportGroupDescriptionEntryFormat2 other = (ReportGroupDescriptionEntryFormat2)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            Word this$dataName = this.getDataName();
            Word other$dataName = other.getDataName();
            if (this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName)) {
                return false;
            }
            ReportGroupLineNumberClause this$reportGroupLineNumberClause = this.getReportGroupLineNumberClause();
            ReportGroupLineNumberClause other$reportGroupLineNumberClause = other.getReportGroupLineNumberClause();
            if (this$reportGroupLineNumberClause == null ? other$reportGroupLineNumberClause != null : !((Object)this$reportGroupLineNumberClause).equals(other$reportGroupLineNumberClause)) {
                return false;
            }
            ReportGroupUsageClause this$groupUsageClause = this.getGroupUsageClause();
            ReportGroupUsageClause other$groupUsageClause = other.getGroupUsageClause();
            if (this$groupUsageClause == null ? other$groupUsageClause != null : !((Object)this$groupUsageClause).equals(other$groupUsageClause)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            Word $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
            ReportGroupLineNumberClause $reportGroupLineNumberClause = this.getReportGroupLineNumberClause();
            result = result * 59 + ($reportGroupLineNumberClause == null ? 43 : ((Object)$reportGroupLineNumberClause).hashCode());
            ReportGroupUsageClause $groupUsageClause = this.getGroupUsageClause();
            result = result * 59 + ($groupUsageClause == null ? 43 : ((Object)$groupUsageClause).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ReportGroupDescriptionEntryFormat2 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupDescriptionEntryFormat2(prefix, this.markers, this.integerLiteral, this.dataName, this.reportGroupLineNumberClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat2 withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupDescriptionEntryFormat2(this.prefix, markers, this.integerLiteral, this.dataName, this.reportGroupLineNumberClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat2 withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportGroupDescriptionEntryFormat2(this.prefix, this.markers, integerLiteral, this.dataName, this.reportGroupLineNumberClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat2 withDataName(Word dataName) {
            return this.dataName == dataName ? this : new ReportGroupDescriptionEntryFormat2(this.prefix, this.markers, this.integerLiteral, dataName, this.reportGroupLineNumberClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat2 withReportGroupLineNumberClause(ReportGroupLineNumberClause reportGroupLineNumberClause) {
            return this.reportGroupLineNumberClause == reportGroupLineNumberClause ? this : new ReportGroupDescriptionEntryFormat2(this.prefix, this.markers, this.integerLiteral, this.dataName, reportGroupLineNumberClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat2 withGroupUsageClause(ReportGroupUsageClause groupUsageClause) {
            return this.groupUsageClause == groupUsageClause ? this : new ReportGroupDescriptionEntryFormat2(this.prefix, this.markers, this.integerLiteral, this.dataName, this.reportGroupLineNumberClause, groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat2 withDot(Word dot) {
            return this.dot == dot ? this : new ReportGroupDescriptionEntryFormat2(this.prefix, this.markers, this.integerLiteral, this.dataName, this.reportGroupLineNumberClause, this.groupUsageClause, dot);
        }
    }

    public static final class ReportGroupDescriptionEntryFormat1
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word integerLiteral;
        private final Word dataName;
        @Nullable
        private final ReportGroupLineNumberClause groupLineNumberClause;
        @Nullable
        private final ReportGroupNextGroupClause groupNextGroupClause;
        private final ReportGroupTypeClause groupTypeClause;
        @Nullable
        private final ReportGroupUsageClause groupUsageClause;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupDescriptionEntryFormat1(this, p);
        }

        public ReportGroupDescriptionEntryFormat1(Space prefix, Markers markers, Word integerLiteral, Word dataName, ReportGroupLineNumberClause groupLineNumberClause, ReportGroupNextGroupClause groupNextGroupClause, ReportGroupTypeClause groupTypeClause, ReportGroupUsageClause groupUsageClause, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.integerLiteral = integerLiteral;
            this.dataName = dataName;
            this.groupLineNumberClause = groupLineNumberClause;
            this.groupNextGroupClause = groupNextGroupClause;
            this.groupTypeClause = groupTypeClause;
            this.groupUsageClause = groupUsageClause;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getDataName() {
            return this.dataName;
        }

        public ReportGroupLineNumberClause getGroupLineNumberClause() {
            return this.groupLineNumberClause;
        }

        public ReportGroupNextGroupClause getGroupNextGroupClause() {
            return this.groupNextGroupClause;
        }

        public ReportGroupTypeClause getGroupTypeClause() {
            return this.groupTypeClause;
        }

        public ReportGroupUsageClause getGroupUsageClause() {
            return this.groupUsageClause;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.ReportGroupDescriptionEntryFormat1(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", integerLiteral=" + this.getIntegerLiteral() + ", dataName=" + this.getDataName() + ", groupLineNumberClause=" + this.getGroupLineNumberClause() + ", groupNextGroupClause=" + this.getGroupNextGroupClause() + ", groupTypeClause=" + this.getGroupTypeClause() + ", groupUsageClause=" + this.getGroupUsageClause() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupDescriptionEntryFormat1)) {
                return false;
            }
            ReportGroupDescriptionEntryFormat1 other = (ReportGroupDescriptionEntryFormat1)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            Word this$dataName = this.getDataName();
            Word other$dataName = other.getDataName();
            if (this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName)) {
                return false;
            }
            ReportGroupLineNumberClause this$groupLineNumberClause = this.getGroupLineNumberClause();
            ReportGroupLineNumberClause other$groupLineNumberClause = other.getGroupLineNumberClause();
            if (this$groupLineNumberClause == null ? other$groupLineNumberClause != null : !((Object)this$groupLineNumberClause).equals(other$groupLineNumberClause)) {
                return false;
            }
            ReportGroupNextGroupClause this$groupNextGroupClause = this.getGroupNextGroupClause();
            ReportGroupNextGroupClause other$groupNextGroupClause = other.getGroupNextGroupClause();
            if (this$groupNextGroupClause == null ? other$groupNextGroupClause != null : !((Object)this$groupNextGroupClause).equals(other$groupNextGroupClause)) {
                return false;
            }
            ReportGroupTypeClause this$groupTypeClause = this.getGroupTypeClause();
            ReportGroupTypeClause other$groupTypeClause = other.getGroupTypeClause();
            if (this$groupTypeClause == null ? other$groupTypeClause != null : !((Object)this$groupTypeClause).equals(other$groupTypeClause)) {
                return false;
            }
            ReportGroupUsageClause this$groupUsageClause = this.getGroupUsageClause();
            ReportGroupUsageClause other$groupUsageClause = other.getGroupUsageClause();
            if (this$groupUsageClause == null ? other$groupUsageClause != null : !((Object)this$groupUsageClause).equals(other$groupUsageClause)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            Word $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
            ReportGroupLineNumberClause $groupLineNumberClause = this.getGroupLineNumberClause();
            result = result * 59 + ($groupLineNumberClause == null ? 43 : ((Object)$groupLineNumberClause).hashCode());
            ReportGroupNextGroupClause $groupNextGroupClause = this.getGroupNextGroupClause();
            result = result * 59 + ($groupNextGroupClause == null ? 43 : ((Object)$groupNextGroupClause).hashCode());
            ReportGroupTypeClause $groupTypeClause = this.getGroupTypeClause();
            result = result * 59 + ($groupTypeClause == null ? 43 : ((Object)$groupTypeClause).hashCode());
            ReportGroupUsageClause $groupUsageClause = this.getGroupUsageClause();
            result = result * 59 + ($groupUsageClause == null ? 43 : ((Object)$groupUsageClause).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ReportGroupDescriptionEntryFormat1 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupDescriptionEntryFormat1(prefix, this.markers, this.integerLiteral, this.dataName, this.groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, markers, this.integerLiteral, this.dataName, this.groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, integerLiteral, this.dataName, this.groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withDataName(Word dataName) {
            return this.dataName == dataName ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, this.integerLiteral, dataName, this.groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withGroupLineNumberClause(ReportGroupLineNumberClause groupLineNumberClause) {
            return this.groupLineNumberClause == groupLineNumberClause ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, this.integerLiteral, this.dataName, groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withGroupNextGroupClause(ReportGroupNextGroupClause groupNextGroupClause) {
            return this.groupNextGroupClause == groupNextGroupClause ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, this.integerLiteral, this.dataName, this.groupLineNumberClause, groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withGroupTypeClause(ReportGroupTypeClause groupTypeClause) {
            return this.groupTypeClause == groupTypeClause ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, this.integerLiteral, this.dataName, this.groupLineNumberClause, this.groupNextGroupClause, groupTypeClause, this.groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withGroupUsageClause(ReportGroupUsageClause groupUsageClause) {
            return this.groupUsageClause == groupUsageClause ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, this.integerLiteral, this.dataName, this.groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, groupUsageClause, this.dot);
        }

        public ReportGroupDescriptionEntryFormat1 withDot(Word dot) {
            return this.dot == dot ? this : new ReportGroupDescriptionEntryFormat1(this.prefix, this.markers, this.integerLiteral, this.dataName, this.groupLineNumberClause, this.groupNextGroupClause, this.groupTypeClause, this.groupUsageClause, dot);
        }
    }

    public static final class ReportGroupColumnNumberClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupColumnNumberClause(this, p);
        }

        public ReportGroupColumnNumberClause(Space prefix, Markers markers, List<Word> words, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportGroupColumnNumberClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupColumnNumberClause)) {
                return false;
            }
            ReportGroupColumnNumberClause other = (ReportGroupColumnNumberClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportGroupColumnNumberClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupColumnNumberClause(prefix, this.markers, this.words, this.dataName);
        }

        public ReportGroupColumnNumberClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupColumnNumberClause(this.prefix, markers, this.words, this.dataName);
        }

        public ReportGroupColumnNumberClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupColumnNumberClause(this.prefix, this.markers, words, this.dataName);
        }

        public ReportGroupColumnNumberClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportGroupColumnNumberClause(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class ReportGroupBlankWhenZeroClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportGroupBlankWhenZeroClause(this, p);
        }

        public ReportGroupBlankWhenZeroClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportGroupBlankWhenZeroClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportGroupBlankWhenZeroClause)) {
                return false;
            }
            ReportGroupBlankWhenZeroClause other = (ReportGroupBlankWhenZeroClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportGroupBlankWhenZeroClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportGroupBlankWhenZeroClause(prefix, this.markers, this.words);
        }

        public ReportGroupBlankWhenZeroClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportGroupBlankWhenZeroClause(this.prefix, markers, this.words);
        }

        public ReportGroupBlankWhenZeroClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportGroupBlankWhenZeroClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReportDescriptionPageLimitClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> firstWords;
        private final Name integerLiteral;
        @Nullable
        private final Word secondWords;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionPageLimitClause(this, p);
        }

        public ReportDescriptionPageLimitClause(Space prefix, Markers markers, List<Word> firstWords, Name integerLiteral, Word secondWords) {
            this.prefix = prefix;
            this.markers = markers;
            this.firstWords = firstWords;
            this.integerLiteral = integerLiteral;
            this.secondWords = secondWords;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getFirstWords() {
            return this.firstWords;
        }

        public Name getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getSecondWords() {
            return this.secondWords;
        }

        public String toString() {
            return "Cobol.ReportDescriptionPageLimitClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", firstWords=" + this.getFirstWords() + ", integerLiteral=" + this.getIntegerLiteral() + ", secondWords=" + this.getSecondWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionPageLimitClause)) {
                return false;
            }
            ReportDescriptionPageLimitClause other = (ReportDescriptionPageLimitClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$firstWords = this.getFirstWords();
            List<Word> other$firstWords = other.getFirstWords();
            if (this$firstWords == null ? other$firstWords != null : !((Object)this$firstWords).equals(other$firstWords)) {
                return false;
            }
            Name this$integerLiteral = this.getIntegerLiteral();
            Name other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !this$integerLiteral.equals(other$integerLiteral)) {
                return false;
            }
            Word this$secondWords = this.getSecondWords();
            Word other$secondWords = other.getSecondWords();
            return !(this$secondWords == null ? other$secondWords != null : !((Object)this$secondWords).equals(other$secondWords));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $firstWords = this.getFirstWords();
            result = result * 59 + ($firstWords == null ? 43 : ((Object)$firstWords).hashCode());
            Name $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : $integerLiteral.hashCode());
            Word $secondWords = this.getSecondWords();
            result = result * 59 + ($secondWords == null ? 43 : ((Object)$secondWords).hashCode());
            return result;
        }

        public ReportDescriptionPageLimitClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionPageLimitClause(prefix, this.markers, this.firstWords, this.integerLiteral, this.secondWords);
        }

        public ReportDescriptionPageLimitClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionPageLimitClause(this.prefix, markers, this.firstWords, this.integerLiteral, this.secondWords);
        }

        public ReportDescriptionPageLimitClause withFirstWords(List<Word> firstWords) {
            return this.firstWords == firstWords ? this : new ReportDescriptionPageLimitClause(this.prefix, this.markers, firstWords, this.integerLiteral, this.secondWords);
        }

        public ReportDescriptionPageLimitClause withIntegerLiteral(Name integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new ReportDescriptionPageLimitClause(this.prefix, this.markers, this.firstWords, integerLiteral, this.secondWords);
        }

        public ReportDescriptionPageLimitClause withSecondWords(Word secondWords) {
            return this.secondWords == secondWords ? this : new ReportDescriptionPageLimitClause(this.prefix, this.markers, this.firstWords, this.integerLiteral, secondWords);
        }
    }

    public static final class ReportDescriptionLastDetailClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionLastDetailClause(this, p);
        }

        public ReportDescriptionLastDetailClause(Space prefix, Markers markers, List<Word> words, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportDescriptionLastDetailClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionLastDetailClause)) {
                return false;
            }
            ReportDescriptionLastDetailClause other = (ReportDescriptionLastDetailClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportDescriptionLastDetailClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionLastDetailClause(prefix, this.markers, this.words, this.dataName);
        }

        public ReportDescriptionLastDetailClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionLastDetailClause(this.prefix, markers, this.words, this.dataName);
        }

        public ReportDescriptionLastDetailClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportDescriptionLastDetailClause(this.prefix, this.markers, words, this.dataName);
        }

        public ReportDescriptionLastDetailClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportDescriptionLastDetailClause(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class ReportDescriptionHeadingClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionHeadingClause(this, p);
        }

        public ReportDescriptionHeadingClause(Space prefix, Markers markers, Word word, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportDescriptionHeadingClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionHeadingClause)) {
                return false;
            }
            ReportDescriptionHeadingClause other = (ReportDescriptionHeadingClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportDescriptionHeadingClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionHeadingClause(prefix, this.markers, this.word, this.dataName);
        }

        public ReportDescriptionHeadingClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionHeadingClause(this.prefix, markers, this.word, this.dataName);
        }

        public ReportDescriptionHeadingClause withWord(Word word) {
            return this.word == word ? this : new ReportDescriptionHeadingClause(this.prefix, this.markers, word, this.dataName);
        }

        public ReportDescriptionHeadingClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportDescriptionHeadingClause(this.prefix, this.markers, this.word, dataName);
        }
    }

    public static final class ReportDescriptionGlobalClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionGlobalClause(this, p);
        }

        public ReportDescriptionGlobalClause(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReportDescriptionGlobalClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionGlobalClause)) {
                return false;
            }
            ReportDescriptionGlobalClause other = (ReportDescriptionGlobalClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReportDescriptionGlobalClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionGlobalClause(prefix, this.markers, this.words);
        }

        public ReportDescriptionGlobalClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionGlobalClause(this.prefix, markers, this.words);
        }

        public ReportDescriptionGlobalClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportDescriptionGlobalClause(this.prefix, this.markers, words);
        }
    }

    public static final class ReportDescriptionFootingClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionFootingClause(this, p);
        }

        public ReportDescriptionFootingClause(Space prefix, Markers markers, Word word, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportDescriptionFootingClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionFootingClause)) {
                return false;
            }
            ReportDescriptionFootingClause other = (ReportDescriptionFootingClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportDescriptionFootingClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionFootingClause(prefix, this.markers, this.word, this.dataName);
        }

        public ReportDescriptionFootingClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionFootingClause(this.prefix, markers, this.word, this.dataName);
        }

        public ReportDescriptionFootingClause withWord(Word word) {
            return this.word == word ? this : new ReportDescriptionFootingClause(this.prefix, this.markers, word, this.dataName);
        }

        public ReportDescriptionFootingClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportDescriptionFootingClause(this.prefix, this.markers, this.word, dataName);
        }
    }

    public static final class ReportDescriptionFirstDetailClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionFirstDetailClause(this, p);
        }

        public ReportDescriptionFirstDetailClause(Space prefix, Markers markers, List<Word> words, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReportDescriptionFirstDetailClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionFirstDetailClause)) {
                return false;
            }
            ReportDescriptionFirstDetailClause other = (ReportDescriptionFirstDetailClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ReportDescriptionFirstDetailClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionFirstDetailClause(prefix, this.markers, this.words, this.dataName);
        }

        public ReportDescriptionFirstDetailClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionFirstDetailClause(this.prefix, markers, this.words, this.dataName);
        }

        public ReportDescriptionFirstDetailClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportDescriptionFirstDetailClause(this.prefix, this.markers, words, this.dataName);
        }

        public ReportDescriptionFirstDetailClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ReportDescriptionFirstDetailClause(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class ReportDescriptionEntry
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word rd;
        private final QualifiedDataName qualifiedDataName;
        @Nullable
        private final ReportDescriptionGlobalClause reportDescriptionGlobalClause;
        @Nullable
        private final ReportDescriptionPageLimitClause reportDescriptionPageLimitClause;
        @Nullable
        private final ReportDescriptionHeadingClause reportDescriptionHeadingClause;
        @Nullable
        private final ReportDescriptionFirstDetailClause reportDescriptionFirstDetailClause;
        @Nullable
        private final ReportDescriptionLastDetailClause reportDescriptionLastDetailClause;
        @Nullable
        private final ReportDescriptionFootingClause reportDescriptionFootingClause;
        private final Word dot;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescriptionEntry(this, p);
        }

        public ReportDescriptionEntry(Space prefix, Markers markers, Word rd, QualifiedDataName qualifiedDataName, ReportDescriptionGlobalClause reportDescriptionGlobalClause, ReportDescriptionPageLimitClause reportDescriptionPageLimitClause, ReportDescriptionHeadingClause reportDescriptionHeadingClause, ReportDescriptionFirstDetailClause reportDescriptionFirstDetailClause, ReportDescriptionLastDetailClause reportDescriptionLastDetailClause, ReportDescriptionFootingClause reportDescriptionFootingClause, Word dot) {
            this.prefix = prefix;
            this.markers = markers;
            this.rd = rd;
            this.qualifiedDataName = qualifiedDataName;
            this.reportDescriptionGlobalClause = reportDescriptionGlobalClause;
            this.reportDescriptionPageLimitClause = reportDescriptionPageLimitClause;
            this.reportDescriptionHeadingClause = reportDescriptionHeadingClause;
            this.reportDescriptionFirstDetailClause = reportDescriptionFirstDetailClause;
            this.reportDescriptionLastDetailClause = reportDescriptionLastDetailClause;
            this.reportDescriptionFootingClause = reportDescriptionFootingClause;
            this.dot = dot;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getRd() {
            return this.rd;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public ReportDescriptionGlobalClause getReportDescriptionGlobalClause() {
            return this.reportDescriptionGlobalClause;
        }

        public ReportDescriptionPageLimitClause getReportDescriptionPageLimitClause() {
            return this.reportDescriptionPageLimitClause;
        }

        public ReportDescriptionHeadingClause getReportDescriptionHeadingClause() {
            return this.reportDescriptionHeadingClause;
        }

        public ReportDescriptionFirstDetailClause getReportDescriptionFirstDetailClause() {
            return this.reportDescriptionFirstDetailClause;
        }

        public ReportDescriptionLastDetailClause getReportDescriptionLastDetailClause() {
            return this.reportDescriptionLastDetailClause;
        }

        public ReportDescriptionFootingClause getReportDescriptionFootingClause() {
            return this.reportDescriptionFootingClause;
        }

        public Word getDot() {
            return this.dot;
        }

        public String toString() {
            return "Cobol.ReportDescriptionEntry(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", rd=" + this.getRd() + ", qualifiedDataName=" + this.getQualifiedDataName() + ", reportDescriptionGlobalClause=" + this.getReportDescriptionGlobalClause() + ", reportDescriptionPageLimitClause=" + this.getReportDescriptionPageLimitClause() + ", reportDescriptionHeadingClause=" + this.getReportDescriptionHeadingClause() + ", reportDescriptionFirstDetailClause=" + this.getReportDescriptionFirstDetailClause() + ", reportDescriptionLastDetailClause=" + this.getReportDescriptionLastDetailClause() + ", reportDescriptionFootingClause=" + this.getReportDescriptionFootingClause() + ", dot=" + this.getDot() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescriptionEntry)) {
                return false;
            }
            ReportDescriptionEntry other = (ReportDescriptionEntry)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$rd = this.getRd();
            Word other$rd = other.getRd();
            if (this$rd == null ? other$rd != null : !((Object)this$rd).equals(other$rd)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            if (this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName)) {
                return false;
            }
            ReportDescriptionGlobalClause this$reportDescriptionGlobalClause = this.getReportDescriptionGlobalClause();
            ReportDescriptionGlobalClause other$reportDescriptionGlobalClause = other.getReportDescriptionGlobalClause();
            if (this$reportDescriptionGlobalClause == null ? other$reportDescriptionGlobalClause != null : !((Object)this$reportDescriptionGlobalClause).equals(other$reportDescriptionGlobalClause)) {
                return false;
            }
            ReportDescriptionPageLimitClause this$reportDescriptionPageLimitClause = this.getReportDescriptionPageLimitClause();
            ReportDescriptionPageLimitClause other$reportDescriptionPageLimitClause = other.getReportDescriptionPageLimitClause();
            if (this$reportDescriptionPageLimitClause == null ? other$reportDescriptionPageLimitClause != null : !((Object)this$reportDescriptionPageLimitClause).equals(other$reportDescriptionPageLimitClause)) {
                return false;
            }
            ReportDescriptionHeadingClause this$reportDescriptionHeadingClause = this.getReportDescriptionHeadingClause();
            ReportDescriptionHeadingClause other$reportDescriptionHeadingClause = other.getReportDescriptionHeadingClause();
            if (this$reportDescriptionHeadingClause == null ? other$reportDescriptionHeadingClause != null : !((Object)this$reportDescriptionHeadingClause).equals(other$reportDescriptionHeadingClause)) {
                return false;
            }
            ReportDescriptionFirstDetailClause this$reportDescriptionFirstDetailClause = this.getReportDescriptionFirstDetailClause();
            ReportDescriptionFirstDetailClause other$reportDescriptionFirstDetailClause = other.getReportDescriptionFirstDetailClause();
            if (this$reportDescriptionFirstDetailClause == null ? other$reportDescriptionFirstDetailClause != null : !((Object)this$reportDescriptionFirstDetailClause).equals(other$reportDescriptionFirstDetailClause)) {
                return false;
            }
            ReportDescriptionLastDetailClause this$reportDescriptionLastDetailClause = this.getReportDescriptionLastDetailClause();
            ReportDescriptionLastDetailClause other$reportDescriptionLastDetailClause = other.getReportDescriptionLastDetailClause();
            if (this$reportDescriptionLastDetailClause == null ? other$reportDescriptionLastDetailClause != null : !((Object)this$reportDescriptionLastDetailClause).equals(other$reportDescriptionLastDetailClause)) {
                return false;
            }
            ReportDescriptionFootingClause this$reportDescriptionFootingClause = this.getReportDescriptionFootingClause();
            ReportDescriptionFootingClause other$reportDescriptionFootingClause = other.getReportDescriptionFootingClause();
            if (this$reportDescriptionFootingClause == null ? other$reportDescriptionFootingClause != null : !((Object)this$reportDescriptionFootingClause).equals(other$reportDescriptionFootingClause)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            return !(this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $rd = this.getRd();
            result = result * 59 + ($rd == null ? 43 : ((Object)$rd).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            ReportDescriptionGlobalClause $reportDescriptionGlobalClause = this.getReportDescriptionGlobalClause();
            result = result * 59 + ($reportDescriptionGlobalClause == null ? 43 : ((Object)$reportDescriptionGlobalClause).hashCode());
            ReportDescriptionPageLimitClause $reportDescriptionPageLimitClause = this.getReportDescriptionPageLimitClause();
            result = result * 59 + ($reportDescriptionPageLimitClause == null ? 43 : ((Object)$reportDescriptionPageLimitClause).hashCode());
            ReportDescriptionHeadingClause $reportDescriptionHeadingClause = this.getReportDescriptionHeadingClause();
            result = result * 59 + ($reportDescriptionHeadingClause == null ? 43 : ((Object)$reportDescriptionHeadingClause).hashCode());
            ReportDescriptionFirstDetailClause $reportDescriptionFirstDetailClause = this.getReportDescriptionFirstDetailClause();
            result = result * 59 + ($reportDescriptionFirstDetailClause == null ? 43 : ((Object)$reportDescriptionFirstDetailClause).hashCode());
            ReportDescriptionLastDetailClause $reportDescriptionLastDetailClause = this.getReportDescriptionLastDetailClause();
            result = result * 59 + ($reportDescriptionLastDetailClause == null ? 43 : ((Object)$reportDescriptionLastDetailClause).hashCode());
            ReportDescriptionFootingClause $reportDescriptionFootingClause = this.getReportDescriptionFootingClause();
            result = result * 59 + ($reportDescriptionFootingClause == null ? 43 : ((Object)$reportDescriptionFootingClause).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            return result;
        }

        public ReportDescriptionEntry withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescriptionEntry(prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescriptionEntry(this.prefix, markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withRd(Word rd) {
            return this.rd == rd ? this : new ReportDescriptionEntry(this.prefix, this.markers, rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withReportDescriptionGlobalClause(ReportDescriptionGlobalClause reportDescriptionGlobalClause) {
            return this.reportDescriptionGlobalClause == reportDescriptionGlobalClause ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withReportDescriptionPageLimitClause(ReportDescriptionPageLimitClause reportDescriptionPageLimitClause) {
            return this.reportDescriptionPageLimitClause == reportDescriptionPageLimitClause ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withReportDescriptionHeadingClause(ReportDescriptionHeadingClause reportDescriptionHeadingClause) {
            return this.reportDescriptionHeadingClause == reportDescriptionHeadingClause ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withReportDescriptionFirstDetailClause(ReportDescriptionFirstDetailClause reportDescriptionFirstDetailClause) {
            return this.reportDescriptionFirstDetailClause == reportDescriptionFirstDetailClause ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withReportDescriptionLastDetailClause(ReportDescriptionLastDetailClause reportDescriptionLastDetailClause) {
            return this.reportDescriptionLastDetailClause == reportDescriptionLastDetailClause ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withReportDescriptionFootingClause(ReportDescriptionFootingClause reportDescriptionFootingClause) {
            return this.reportDescriptionFootingClause == reportDescriptionFootingClause ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, reportDescriptionFootingClause, this.dot);
        }

        public ReportDescriptionEntry withDot(Word dot) {
            return this.dot == dot ? this : new ReportDescriptionEntry(this.prefix, this.markers, this.rd, this.qualifiedDataName, this.reportDescriptionGlobalClause, this.reportDescriptionPageLimitClause, this.reportDescriptionHeadingClause, this.reportDescriptionFirstDetailClause, this.reportDescriptionLastDetailClause, this.reportDescriptionFootingClause, dot);
        }
    }

    public static final class ReportDescription
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final ReportDescriptionEntry reportDescriptionEntry;
        private final List<Cobol> groupDescriptionEntries;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportDescription(this, p);
        }

        public ReportDescription(Space prefix, Markers markers, ReportDescriptionEntry reportDescriptionEntry, List<Cobol> groupDescriptionEntries) {
            this.prefix = prefix;
            this.markers = markers;
            this.reportDescriptionEntry = reportDescriptionEntry;
            this.groupDescriptionEntries = groupDescriptionEntries;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ReportDescriptionEntry getReportDescriptionEntry() {
            return this.reportDescriptionEntry;
        }

        public List<Cobol> getGroupDescriptionEntries() {
            return this.groupDescriptionEntries;
        }

        public String toString() {
            return "Cobol.ReportDescription(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", reportDescriptionEntry=" + this.getReportDescriptionEntry() + ", groupDescriptionEntries=" + this.getGroupDescriptionEntries() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDescription)) {
                return false;
            }
            ReportDescription other = (ReportDescription)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ReportDescriptionEntry this$reportDescriptionEntry = this.getReportDescriptionEntry();
            ReportDescriptionEntry other$reportDescriptionEntry = other.getReportDescriptionEntry();
            if (this$reportDescriptionEntry == null ? other$reportDescriptionEntry != null : !((Object)this$reportDescriptionEntry).equals(other$reportDescriptionEntry)) {
                return false;
            }
            List<Cobol> this$groupDescriptionEntries = this.getGroupDescriptionEntries();
            List<Cobol> other$groupDescriptionEntries = other.getGroupDescriptionEntries();
            return !(this$groupDescriptionEntries == null ? other$groupDescriptionEntries != null : !((Object)this$groupDescriptionEntries).equals(other$groupDescriptionEntries));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ReportDescriptionEntry $reportDescriptionEntry = this.getReportDescriptionEntry();
            result = result * 59 + ($reportDescriptionEntry == null ? 43 : ((Object)$reportDescriptionEntry).hashCode());
            List<Cobol> $groupDescriptionEntries = this.getGroupDescriptionEntries();
            result = result * 59 + ($groupDescriptionEntries == null ? 43 : ((Object)$groupDescriptionEntries).hashCode());
            return result;
        }

        public ReportDescription withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportDescription(prefix, this.markers, this.reportDescriptionEntry, this.groupDescriptionEntries);
        }

        public ReportDescription withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportDescription(this.prefix, markers, this.reportDescriptionEntry, this.groupDescriptionEntries);
        }

        public ReportDescription withReportDescriptionEntry(ReportDescriptionEntry reportDescriptionEntry) {
            return this.reportDescriptionEntry == reportDescriptionEntry ? this : new ReportDescription(this.prefix, this.markers, reportDescriptionEntry, this.groupDescriptionEntries);
        }

        public ReportDescription withGroupDescriptionEntries(List<Cobol> groupDescriptionEntries) {
            return this.groupDescriptionEntries == groupDescriptionEntries ? this : new ReportDescription(this.prefix, this.markers, this.reportDescriptionEntry, groupDescriptionEntries);
        }
    }

    public static final class ReportClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Name> reportName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReportClause(this, p);
        }

        public ReportClause(Space prefix, Markers markers, List<Word> words, List<Name> reportName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.reportName = reportName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Name> getReportName() {
            return this.reportName;
        }

        public String toString() {
            return "Cobol.ReportClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", reportName=" + this.getReportName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportClause)) {
                return false;
            }
            ReportClause other = (ReportClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Name> this$reportName = this.getReportName();
            List<Name> other$reportName = other.getReportName();
            return !(this$reportName == null ? other$reportName != null : !((Object)this$reportName).equals(other$reportName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Name> $reportName = this.getReportName();
            result = result * 59 + ($reportName == null ? 43 : ((Object)$reportName).hashCode());
            return result;
        }

        public ReportClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReportClause(prefix, this.markers, this.words, this.reportName);
        }

        public ReportClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReportClause(this.prefix, markers, this.words, this.reportName);
        }

        public ReportClause withWords(List<Word> words) {
            return this.words == words ? this : new ReportClause(this.prefix, this.markers, words, this.reportName);
        }

        public ReportClause withReportName(List<Name> reportName) {
            return this.reportName == reportName ? this : new ReportClause(this.prefix, this.markers, this.words, reportName);
        }
    }

    public static final class Release
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word release;
        private final QualifiedDataName recordName;
        @Nullable
        private final Word from;
        @Nullable
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelease(this, p);
        }

        public Release(Space prefix, Markers markers, Word release, QualifiedDataName recordName, Word from, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.release = release;
            this.recordName = recordName;
            this.from = from;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getRelease() {
            return this.release;
        }

        public QualifiedDataName getRecordName() {
            return this.recordName;
        }

        public Word getFrom() {
            return this.from;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.Release(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", release=" + this.getRelease() + ", recordName=" + this.getRecordName() + ", from=" + this.getFrom() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Release)) {
                return false;
            }
            Release other = (Release)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$release = this.getRelease();
            Word other$release = other.getRelease();
            if (this$release == null ? other$release != null : !((Object)this$release).equals(other$release)) {
                return false;
            }
            QualifiedDataName this$recordName = this.getRecordName();
            QualifiedDataName other$recordName = other.getRecordName();
            if (this$recordName == null ? other$recordName != null : !((Object)this$recordName).equals(other$recordName)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : ((Object)$release).hashCode());
            QualifiedDataName $recordName = this.getRecordName();
            result = result * 59 + ($recordName == null ? 43 : ((Object)$recordName).hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public Release withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Release(prefix, this.markers, this.release, this.recordName, this.from, this.qualifiedDataName);
        }

        public Release withMarkers(Markers markers) {
            return this.markers == markers ? this : new Release(this.prefix, markers, this.release, this.recordName, this.from, this.qualifiedDataName);
        }

        public Release withRelease(Word release) {
            return this.release == release ? this : new Release(this.prefix, this.markers, release, this.recordName, this.from, this.qualifiedDataName);
        }

        public Release withRecordName(QualifiedDataName recordName) {
            return this.recordName == recordName ? this : new Release(this.prefix, this.markers, this.release, recordName, this.from, this.qualifiedDataName);
        }

        public Release withFrom(Word from) {
            return this.from == from ? this : new Release(this.prefix, this.markers, this.release, this.recordName, from, this.qualifiedDataName);
        }

        public Release withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new Release(this.prefix, this.markers, this.release, this.recordName, this.from, qualifiedDataName);
        }
    }

    public static final class RelativeKeyClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelativeKeyClause(this, p);
        }

        public RelativeKeyClause(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.RelativeKeyClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelativeKeyClause)) {
                return false;
            }
            RelativeKeyClause other = (RelativeKeyClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public RelativeKeyClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RelativeKeyClause(prefix, this.markers, this.words, this.qualifiedDataName);
        }

        public RelativeKeyClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new RelativeKeyClause(this.prefix, markers, this.words, this.qualifiedDataName);
        }

        public RelativeKeyClause withWords(List<Word> words) {
            return this.words == words ? this : new RelativeKeyClause(this.prefix, this.markers, words, this.qualifiedDataName);
        }

        public RelativeKeyClause withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new RelativeKeyClause(this.prefix, this.markers, this.words, qualifiedDataName);
        }
    }

    public static final class RelationSignCondition
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final ArithmeticExpression arithmeticExpression;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelationSignCondition(this, p);
        }

        public RelationSignCondition(Space prefix, Markers markers, ArithmeticExpression arithmeticExpression, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.arithmeticExpression = arithmeticExpression;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ArithmeticExpression getArithmeticExpression() {
            return this.arithmeticExpression;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.RelationSignCondition(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", arithmeticExpression=" + this.getArithmeticExpression() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationSignCondition)) {
                return false;
            }
            RelationSignCondition other = (RelationSignCondition)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ArithmeticExpression this$arithmeticExpression = this.getArithmeticExpression();
            ArithmeticExpression other$arithmeticExpression = other.getArithmeticExpression();
            if (this$arithmeticExpression == null ? other$arithmeticExpression != null : !((Object)this$arithmeticExpression).equals(other$arithmeticExpression)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ArithmeticExpression $arithmeticExpression = this.getArithmeticExpression();
            result = result * 59 + ($arithmeticExpression == null ? 43 : ((Object)$arithmeticExpression).hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public RelationSignCondition withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RelationSignCondition(prefix, this.markers, this.arithmeticExpression, this.words);
        }

        public RelationSignCondition withMarkers(Markers markers) {
            return this.markers == markers ? this : new RelationSignCondition(this.prefix, markers, this.arithmeticExpression, this.words);
        }

        public RelationSignCondition withArithmeticExpression(ArithmeticExpression arithmeticExpression) {
            return this.arithmeticExpression == arithmeticExpression ? this : new RelationSignCondition(this.prefix, this.markers, arithmeticExpression, this.words);
        }

        public RelationSignCondition withWords(List<Word> words) {
            return this.words == words ? this : new RelationSignCondition(this.prefix, this.markers, this.arithmeticExpression, words);
        }
    }

    public static final class RelationCombinedCondition
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Cobol> relationalArithmeticExpressions;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelationCombinedCondition(this, p);
        }

        public RelationCombinedCondition(Space prefix, Markers markers, List<Cobol> relationalArithmeticExpressions) {
            this.prefix = prefix;
            this.markers = markers;
            this.relationalArithmeticExpressions = relationalArithmeticExpressions;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Cobol> getRelationalArithmeticExpressions() {
            return this.relationalArithmeticExpressions;
        }

        public String toString() {
            return "Cobol.RelationCombinedCondition(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", relationalArithmeticExpressions=" + this.getRelationalArithmeticExpressions() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationCombinedCondition)) {
                return false;
            }
            RelationCombinedCondition other = (RelationCombinedCondition)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Cobol> this$relationalArithmeticExpressions = this.getRelationalArithmeticExpressions();
            List<Cobol> other$relationalArithmeticExpressions = other.getRelationalArithmeticExpressions();
            return !(this$relationalArithmeticExpressions == null ? other$relationalArithmeticExpressions != null : !((Object)this$relationalArithmeticExpressions).equals(other$relationalArithmeticExpressions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Cobol> $relationalArithmeticExpressions = this.getRelationalArithmeticExpressions();
            result = result * 59 + ($relationalArithmeticExpressions == null ? 43 : ((Object)$relationalArithmeticExpressions).hashCode());
            return result;
        }

        public RelationCombinedCondition withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RelationCombinedCondition(prefix, this.markers, this.relationalArithmeticExpressions);
        }

        public RelationCombinedCondition withMarkers(Markers markers) {
            return this.markers == markers ? this : new RelationCombinedCondition(this.prefix, markers, this.relationalArithmeticExpressions);
        }

        public RelationCombinedCondition withRelationalArithmeticExpressions(List<Cobol> relationalArithmeticExpressions) {
            return this.relationalArithmeticExpressions == relationalArithmeticExpressions ? this : new RelationCombinedCondition(this.prefix, this.markers, relationalArithmeticExpressions);
        }
    }

    public static final class RelationCombinedComparison
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final ArithmeticExpression arithmeticExpression;
        private final RelationalOperator relationalOperator;
        private final Parenthesized combinedCondition;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelationCombinedComparison(this, p);
        }

        public RelationCombinedComparison(Space prefix, Markers markers, ArithmeticExpression arithmeticExpression, RelationalOperator relationalOperator, Parenthesized combinedCondition) {
            this.prefix = prefix;
            this.markers = markers;
            this.arithmeticExpression = arithmeticExpression;
            this.relationalOperator = relationalOperator;
            this.combinedCondition = combinedCondition;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ArithmeticExpression getArithmeticExpression() {
            return this.arithmeticExpression;
        }

        public RelationalOperator getRelationalOperator() {
            return this.relationalOperator;
        }

        public Parenthesized getCombinedCondition() {
            return this.combinedCondition;
        }

        public String toString() {
            return "Cobol.RelationCombinedComparison(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", arithmeticExpression=" + this.getArithmeticExpression() + ", relationalOperator=" + this.getRelationalOperator() + ", combinedCondition=" + this.getCombinedCondition() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationCombinedComparison)) {
                return false;
            }
            RelationCombinedComparison other = (RelationCombinedComparison)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ArithmeticExpression this$arithmeticExpression = this.getArithmeticExpression();
            ArithmeticExpression other$arithmeticExpression = other.getArithmeticExpression();
            if (this$arithmeticExpression == null ? other$arithmeticExpression != null : !((Object)this$arithmeticExpression).equals(other$arithmeticExpression)) {
                return false;
            }
            RelationalOperator this$relationalOperator = this.getRelationalOperator();
            RelationalOperator other$relationalOperator = other.getRelationalOperator();
            if (this$relationalOperator == null ? other$relationalOperator != null : !((Object)this$relationalOperator).equals(other$relationalOperator)) {
                return false;
            }
            Parenthesized this$combinedCondition = this.getCombinedCondition();
            Parenthesized other$combinedCondition = other.getCombinedCondition();
            return !(this$combinedCondition == null ? other$combinedCondition != null : !((Object)this$combinedCondition).equals(other$combinedCondition));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ArithmeticExpression $arithmeticExpression = this.getArithmeticExpression();
            result = result * 59 + ($arithmeticExpression == null ? 43 : ((Object)$arithmeticExpression).hashCode());
            RelationalOperator $relationalOperator = this.getRelationalOperator();
            result = result * 59 + ($relationalOperator == null ? 43 : ((Object)$relationalOperator).hashCode());
            Parenthesized $combinedCondition = this.getCombinedCondition();
            result = result * 59 + ($combinedCondition == null ? 43 : ((Object)$combinedCondition).hashCode());
            return result;
        }

        public RelationCombinedComparison withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RelationCombinedComparison(prefix, this.markers, this.arithmeticExpression, this.relationalOperator, this.combinedCondition);
        }

        public RelationCombinedComparison withMarkers(Markers markers) {
            return this.markers == markers ? this : new RelationCombinedComparison(this.prefix, markers, this.arithmeticExpression, this.relationalOperator, this.combinedCondition);
        }

        public RelationCombinedComparison withArithmeticExpression(ArithmeticExpression arithmeticExpression) {
            return this.arithmeticExpression == arithmeticExpression ? this : new RelationCombinedComparison(this.prefix, this.markers, arithmeticExpression, this.relationalOperator, this.combinedCondition);
        }

        public RelationCombinedComparison withRelationalOperator(RelationalOperator relationalOperator) {
            return this.relationalOperator == relationalOperator ? this : new RelationCombinedComparison(this.prefix, this.markers, this.arithmeticExpression, relationalOperator, this.combinedCondition);
        }

        public RelationCombinedComparison withCombinedCondition(Parenthesized combinedCondition) {
            return this.combinedCondition == combinedCondition ? this : new RelationCombinedComparison(this.prefix, this.markers, this.arithmeticExpression, this.relationalOperator, combinedCondition);
        }
    }

    public static final class RelationArithmeticComparison
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final ArithmeticExpression arithmeticExpressionA;
        private final RelationalOperator relationalOperator;
        private final ArithmeticExpression arithmeticExpressionB;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelationArithmeticComparison(this, p);
        }

        public RelationArithmeticComparison(Space prefix, Markers markers, ArithmeticExpression arithmeticExpressionA, RelationalOperator relationalOperator, ArithmeticExpression arithmeticExpressionB) {
            this.prefix = prefix;
            this.markers = markers;
            this.arithmeticExpressionA = arithmeticExpressionA;
            this.relationalOperator = relationalOperator;
            this.arithmeticExpressionB = arithmeticExpressionB;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ArithmeticExpression getArithmeticExpressionA() {
            return this.arithmeticExpressionA;
        }

        public RelationalOperator getRelationalOperator() {
            return this.relationalOperator;
        }

        public ArithmeticExpression getArithmeticExpressionB() {
            return this.arithmeticExpressionB;
        }

        public String toString() {
            return "Cobol.RelationArithmeticComparison(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", arithmeticExpressionA=" + this.getArithmeticExpressionA() + ", relationalOperator=" + this.getRelationalOperator() + ", arithmeticExpressionB=" + this.getArithmeticExpressionB() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationArithmeticComparison)) {
                return false;
            }
            RelationArithmeticComparison other = (RelationArithmeticComparison)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ArithmeticExpression this$arithmeticExpressionA = this.getArithmeticExpressionA();
            ArithmeticExpression other$arithmeticExpressionA = other.getArithmeticExpressionA();
            if (this$arithmeticExpressionA == null ? other$arithmeticExpressionA != null : !((Object)this$arithmeticExpressionA).equals(other$arithmeticExpressionA)) {
                return false;
            }
            RelationalOperator this$relationalOperator = this.getRelationalOperator();
            RelationalOperator other$relationalOperator = other.getRelationalOperator();
            if (this$relationalOperator == null ? other$relationalOperator != null : !((Object)this$relationalOperator).equals(other$relationalOperator)) {
                return false;
            }
            ArithmeticExpression this$arithmeticExpressionB = this.getArithmeticExpressionB();
            ArithmeticExpression other$arithmeticExpressionB = other.getArithmeticExpressionB();
            return !(this$arithmeticExpressionB == null ? other$arithmeticExpressionB != null : !((Object)this$arithmeticExpressionB).equals(other$arithmeticExpressionB));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ArithmeticExpression $arithmeticExpressionA = this.getArithmeticExpressionA();
            result = result * 59 + ($arithmeticExpressionA == null ? 43 : ((Object)$arithmeticExpressionA).hashCode());
            RelationalOperator $relationalOperator = this.getRelationalOperator();
            result = result * 59 + ($relationalOperator == null ? 43 : ((Object)$relationalOperator).hashCode());
            ArithmeticExpression $arithmeticExpressionB = this.getArithmeticExpressionB();
            result = result * 59 + ($arithmeticExpressionB == null ? 43 : ((Object)$arithmeticExpressionB).hashCode());
            return result;
        }

        public RelationArithmeticComparison withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RelationArithmeticComparison(prefix, this.markers, this.arithmeticExpressionA, this.relationalOperator, this.arithmeticExpressionB);
        }

        public RelationArithmeticComparison withMarkers(Markers markers) {
            return this.markers == markers ? this : new RelationArithmeticComparison(this.prefix, markers, this.arithmeticExpressionA, this.relationalOperator, this.arithmeticExpressionB);
        }

        public RelationArithmeticComparison withArithmeticExpressionA(ArithmeticExpression arithmeticExpressionA) {
            return this.arithmeticExpressionA == arithmeticExpressionA ? this : new RelationArithmeticComparison(this.prefix, this.markers, arithmeticExpressionA, this.relationalOperator, this.arithmeticExpressionB);
        }

        public RelationArithmeticComparison withRelationalOperator(RelationalOperator relationalOperator) {
            return this.relationalOperator == relationalOperator ? this : new RelationArithmeticComparison(this.prefix, this.markers, this.arithmeticExpressionA, relationalOperator, this.arithmeticExpressionB);
        }

        public RelationArithmeticComparison withArithmeticExpressionB(ArithmeticExpression arithmeticExpressionB) {
            return this.arithmeticExpressionB == arithmeticExpressionB ? this : new RelationArithmeticComparison(this.prefix, this.markers, this.arithmeticExpressionA, this.relationalOperator, arithmeticExpressionB);
        }
    }

    public static final class RelationalOperator
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRelationalOperator(this, p);
        }

        public RelationalOperator(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.RelationalOperator(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationalOperator)) {
                return false;
            }
            RelationalOperator other = (RelationalOperator)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public RelationalOperator withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RelationalOperator(prefix, this.markers, this.words);
        }

        public RelationalOperator withMarkers(Markers markers) {
            return this.markers == markers ? this : new RelationalOperator(this.prefix, markers, this.words);
        }

        public RelationalOperator withWords(List<Word> words) {
            return this.words == words ? this : new RelationalOperator(this.prefix, this.markers, words);
        }
    }

    public static final class ReferenceModifier
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word leftParen;
        private final ArithmeticExpression characterPosition;
        private final Word colon;
        @Nullable
        private final ArithmeticExpression length;
        private final Word rightParen;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReferenceModifier(this, p);
        }

        public ReferenceModifier(Space prefix, Markers markers, Word leftParen, ArithmeticExpression characterPosition, Word colon, ArithmeticExpression length, Word rightParen) {
            this.prefix = prefix;
            this.markers = markers;
            this.leftParen = leftParen;
            this.characterPosition = characterPosition;
            this.colon = colon;
            this.length = length;
            this.rightParen = rightParen;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getLeftParen() {
            return this.leftParen;
        }

        public ArithmeticExpression getCharacterPosition() {
            return this.characterPosition;
        }

        public Word getColon() {
            return this.colon;
        }

        public ArithmeticExpression getLength() {
            return this.length;
        }

        public Word getRightParen() {
            return this.rightParen;
        }

        public String toString() {
            return "Cobol.ReferenceModifier(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", leftParen=" + this.getLeftParen() + ", characterPosition=" + this.getCharacterPosition() + ", colon=" + this.getColon() + ", length=" + this.getLength() + ", rightParen=" + this.getRightParen() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReferenceModifier)) {
                return false;
            }
            ReferenceModifier other = (ReferenceModifier)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$leftParen = this.getLeftParen();
            Word other$leftParen = other.getLeftParen();
            if (this$leftParen == null ? other$leftParen != null : !((Object)this$leftParen).equals(other$leftParen)) {
                return false;
            }
            ArithmeticExpression this$characterPosition = this.getCharacterPosition();
            ArithmeticExpression other$characterPosition = other.getCharacterPosition();
            if (this$characterPosition == null ? other$characterPosition != null : !((Object)this$characterPosition).equals(other$characterPosition)) {
                return false;
            }
            Word this$colon = this.getColon();
            Word other$colon = other.getColon();
            if (this$colon == null ? other$colon != null : !((Object)this$colon).equals(other$colon)) {
                return false;
            }
            ArithmeticExpression this$length = this.getLength();
            ArithmeticExpression other$length = other.getLength();
            if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
                return false;
            }
            Word this$rightParen = this.getRightParen();
            Word other$rightParen = other.getRightParen();
            return !(this$rightParen == null ? other$rightParen != null : !((Object)this$rightParen).equals(other$rightParen));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $leftParen = this.getLeftParen();
            result = result * 59 + ($leftParen == null ? 43 : ((Object)$leftParen).hashCode());
            ArithmeticExpression $characterPosition = this.getCharacterPosition();
            result = result * 59 + ($characterPosition == null ? 43 : ((Object)$characterPosition).hashCode());
            Word $colon = this.getColon();
            result = result * 59 + ($colon == null ? 43 : ((Object)$colon).hashCode());
            ArithmeticExpression $length = this.getLength();
            result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
            Word $rightParen = this.getRightParen();
            result = result * 59 + ($rightParen == null ? 43 : ((Object)$rightParen).hashCode());
            return result;
        }

        public ReferenceModifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReferenceModifier(prefix, this.markers, this.leftParen, this.characterPosition, this.colon, this.length, this.rightParen);
        }

        public ReferenceModifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReferenceModifier(this.prefix, markers, this.leftParen, this.characterPosition, this.colon, this.length, this.rightParen);
        }

        public ReferenceModifier withLeftParen(Word leftParen) {
            return this.leftParen == leftParen ? this : new ReferenceModifier(this.prefix, this.markers, leftParen, this.characterPosition, this.colon, this.length, this.rightParen);
        }

        public ReferenceModifier withCharacterPosition(ArithmeticExpression characterPosition) {
            return this.characterPosition == characterPosition ? this : new ReferenceModifier(this.prefix, this.markers, this.leftParen, characterPosition, this.colon, this.length, this.rightParen);
        }

        public ReferenceModifier withColon(Word colon) {
            return this.colon == colon ? this : new ReferenceModifier(this.prefix, this.markers, this.leftParen, this.characterPosition, colon, this.length, this.rightParen);
        }

        public ReferenceModifier withLength(ArithmeticExpression length) {
            return this.length == length ? this : new ReferenceModifier(this.prefix, this.markers, this.leftParen, this.characterPosition, this.colon, length, this.rightParen);
        }

        public ReferenceModifier withRightParen(Word rightParen) {
            return this.rightParen == rightParen ? this : new ReferenceModifier(this.prefix, this.markers, this.leftParen, this.characterPosition, this.colon, this.length, rightParen);
        }
    }

    public static final class RecordKeyClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> recordWords;
        private final QualifiedDataName qualifiedDataName;
        @Nullable
        private final PasswordClause passwordClause;
        private final List<Word> duplicates;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordKeyClause(this, p);
        }

        public RecordKeyClause(Space prefix, Markers markers, List<Word> recordWords, QualifiedDataName qualifiedDataName, PasswordClause passwordClause, List<Word> duplicates) {
            this.prefix = prefix;
            this.markers = markers;
            this.recordWords = recordWords;
            this.qualifiedDataName = qualifiedDataName;
            this.passwordClause = passwordClause;
            this.duplicates = duplicates;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getRecordWords() {
            return this.recordWords;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public PasswordClause getPasswordClause() {
            return this.passwordClause;
        }

        public List<Word> getDuplicates() {
            return this.duplicates;
        }

        public String toString() {
            return "Cobol.RecordKeyClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", recordWords=" + this.getRecordWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ", passwordClause=" + this.getPasswordClause() + ", duplicates=" + this.getDuplicates() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordKeyClause)) {
                return false;
            }
            RecordKeyClause other = (RecordKeyClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$recordWords = this.getRecordWords();
            List<Word> other$recordWords = other.getRecordWords();
            if (this$recordWords == null ? other$recordWords != null : !((Object)this$recordWords).equals(other$recordWords)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            if (this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName)) {
                return false;
            }
            PasswordClause this$passwordClause = this.getPasswordClause();
            PasswordClause other$passwordClause = other.getPasswordClause();
            if (this$passwordClause == null ? other$passwordClause != null : !((Object)this$passwordClause).equals(other$passwordClause)) {
                return false;
            }
            List<Word> this$duplicates = this.getDuplicates();
            List<Word> other$duplicates = other.getDuplicates();
            return !(this$duplicates == null ? other$duplicates != null : !((Object)this$duplicates).equals(other$duplicates));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $recordWords = this.getRecordWords();
            result = result * 59 + ($recordWords == null ? 43 : ((Object)$recordWords).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            PasswordClause $passwordClause = this.getPasswordClause();
            result = result * 59 + ($passwordClause == null ? 43 : ((Object)$passwordClause).hashCode());
            List<Word> $duplicates = this.getDuplicates();
            result = result * 59 + ($duplicates == null ? 43 : ((Object)$duplicates).hashCode());
            return result;
        }

        public RecordKeyClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordKeyClause(prefix, this.markers, this.recordWords, this.qualifiedDataName, this.passwordClause, this.duplicates);
        }

        public RecordKeyClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordKeyClause(this.prefix, markers, this.recordWords, this.qualifiedDataName, this.passwordClause, this.duplicates);
        }

        public RecordKeyClause withRecordWords(List<Word> recordWords) {
            return this.recordWords == recordWords ? this : new RecordKeyClause(this.prefix, this.markers, recordWords, this.qualifiedDataName, this.passwordClause, this.duplicates);
        }

        public RecordKeyClause withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new RecordKeyClause(this.prefix, this.markers, this.recordWords, qualifiedDataName, this.passwordClause, this.duplicates);
        }

        public RecordKeyClause withPasswordClause(PasswordClause passwordClause) {
            return this.passwordClause == passwordClause ? this : new RecordKeyClause(this.prefix, this.markers, this.recordWords, this.qualifiedDataName, passwordClause, this.duplicates);
        }

        public RecordKeyClause withDuplicates(List<Word> duplicates) {
            return this.duplicates == duplicates ? this : new RecordKeyClause(this.prefix, this.markers, this.recordWords, this.qualifiedDataName, this.passwordClause, duplicates);
        }
    }

    public static final class RecordingModeClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Word mode;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordingModeClause(this, p);
        }

        public RecordingModeClause(Space prefix, Markers markers, List<Word> words, Word mode) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.mode = mode;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getMode() {
            return this.mode;
        }

        public String toString() {
            return "Cobol.RecordingModeClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", mode=" + this.getMode() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordingModeClause)) {
                return false;
            }
            RecordingModeClause other = (RecordingModeClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$mode = this.getMode();
            Word other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !((Object)this$mode).equals(other$mode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : ((Object)$mode).hashCode());
            return result;
        }

        public RecordingModeClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordingModeClause(prefix, this.markers, this.words, this.mode);
        }

        public RecordingModeClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordingModeClause(this.prefix, markers, this.words, this.mode);
        }

        public RecordingModeClause withWords(List<Word> words) {
            return this.words == words ? this : new RecordingModeClause(this.prefix, this.markers, words, this.mode);
        }

        public RecordingModeClause withMode(Word mode) {
            return this.mode == mode ? this : new RecordingModeClause(this.prefix, this.markers, this.words, mode);
        }
    }

    public static final class RecordDelimiterClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Name name;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordDelimiterClause(this, p);
        }

        public RecordDelimiterClause(Space prefix, Markers markers, List<Word> words, Name name) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.name = name;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Cobol.RecordDelimiterClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordDelimiterClause)) {
                return false;
            }
            RecordDelimiterClause other = (RecordDelimiterClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public RecordDelimiterClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordDelimiterClause(prefix, this.markers, this.words, this.name);
        }

        public RecordDelimiterClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordDelimiterClause(this.prefix, markers, this.words, this.name);
        }

        public RecordDelimiterClause withWords(List<Word> words) {
            return this.words == words ? this : new RecordDelimiterClause(this.prefix, this.markers, words, this.name);
        }

        public RecordDelimiterClause withName(Name name) {
            return this.name == name ? this : new RecordDelimiterClause(this.prefix, this.markers, this.words, name);
        }
    }

    public static final class RecordContainsTo
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word to;
        private final Word integerLiteral;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordContainsTo(this, p);
        }

        public RecordContainsTo(Space prefix, Markers markers, Word to, Word integerLiteral) {
            this.prefix = prefix;
            this.markers = markers;
            this.to = to;
            this.integerLiteral = integerLiteral;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getTo() {
            return this.to;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public String toString() {
            return "Cobol.RecordContainsTo(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", to=" + this.getTo() + ", integerLiteral=" + this.getIntegerLiteral() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordContainsTo)) {
                return false;
            }
            RecordContainsTo other = (RecordContainsTo)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$to = this.getTo();
            Word other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            return !(this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            return result;
        }

        public RecordContainsTo withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordContainsTo(prefix, this.markers, this.to, this.integerLiteral);
        }

        public RecordContainsTo withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordContainsTo(this.prefix, markers, this.to, this.integerLiteral);
        }

        public RecordContainsTo withTo(Word to) {
            return this.to == to ? this : new RecordContainsTo(this.prefix, this.markers, to, this.integerLiteral);
        }

        public RecordContainsTo withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new RecordContainsTo(this.prefix, this.markers, this.to, integerLiteral);
        }
    }

    public static final class RecordContainsClauseFormat3
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Word contains;
        private final Word integerLiteral;
        private final RecordContainsTo recordContainsTo;
        @Nullable
        private final Word characters;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordContainsClauseFormat3(this, p);
        }

        public RecordContainsClauseFormat3(Space prefix, Markers markers, Word contains, Word integerLiteral, RecordContainsTo recordContainsTo, Word characters) {
            this.prefix = prefix;
            this.markers = markers;
            this.contains = contains;
            this.integerLiteral = integerLiteral;
            this.recordContainsTo = recordContainsTo;
            this.characters = characters;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getContains() {
            return this.contains;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public RecordContainsTo getRecordContainsTo() {
            return this.recordContainsTo;
        }

        public Word getCharacters() {
            return this.characters;
        }

        public String toString() {
            return "Cobol.RecordContainsClauseFormat3(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", contains=" + this.getContains() + ", integerLiteral=" + this.getIntegerLiteral() + ", recordContainsTo=" + this.getRecordContainsTo() + ", characters=" + this.getCharacters() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordContainsClauseFormat3)) {
                return false;
            }
            RecordContainsClauseFormat3 other = (RecordContainsClauseFormat3)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$contains = this.getContains();
            Word other$contains = other.getContains();
            if (this$contains == null ? other$contains != null : !((Object)this$contains).equals(other$contains)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            RecordContainsTo this$recordContainsTo = this.getRecordContainsTo();
            RecordContainsTo other$recordContainsTo = other.getRecordContainsTo();
            if (this$recordContainsTo == null ? other$recordContainsTo != null : !((Object)this$recordContainsTo).equals(other$recordContainsTo)) {
                return false;
            }
            Word this$characters = this.getCharacters();
            Word other$characters = other.getCharacters();
            return !(this$characters == null ? other$characters != null : !((Object)this$characters).equals(other$characters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $contains = this.getContains();
            result = result * 59 + ($contains == null ? 43 : ((Object)$contains).hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            RecordContainsTo $recordContainsTo = this.getRecordContainsTo();
            result = result * 59 + ($recordContainsTo == null ? 43 : ((Object)$recordContainsTo).hashCode());
            Word $characters = this.getCharacters();
            result = result * 59 + ($characters == null ? 43 : ((Object)$characters).hashCode());
            return result;
        }

        public RecordContainsClauseFormat3 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordContainsClauseFormat3(prefix, this.markers, this.contains, this.integerLiteral, this.recordContainsTo, this.characters);
        }

        public RecordContainsClauseFormat3 withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordContainsClauseFormat3(this.prefix, markers, this.contains, this.integerLiteral, this.recordContainsTo, this.characters);
        }

        public RecordContainsClauseFormat3 withContains(Word contains) {
            return this.contains == contains ? this : new RecordContainsClauseFormat3(this.prefix, this.markers, contains, this.integerLiteral, this.recordContainsTo, this.characters);
        }

        public RecordContainsClauseFormat3 withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new RecordContainsClauseFormat3(this.prefix, this.markers, this.contains, integerLiteral, this.recordContainsTo, this.characters);
        }

        public RecordContainsClauseFormat3 withRecordContainsTo(RecordContainsTo recordContainsTo) {
            return this.recordContainsTo == recordContainsTo ? this : new RecordContainsClauseFormat3(this.prefix, this.markers, this.contains, this.integerLiteral, recordContainsTo, this.characters);
        }

        public RecordContainsClauseFormat3 withCharacters(Word characters) {
            return this.characters == characters ? this : new RecordContainsClauseFormat3(this.prefix, this.markers, this.contains, this.integerLiteral, this.recordContainsTo, characters);
        }
    }

    public static final class RecordContainsClauseFormat2
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Cobol> fromClause;
        private final List<Cobol> qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordContainsClauseFormat2(this, p);
        }

        public RecordContainsClauseFormat2(Space prefix, Markers markers, List<Word> words, List<Cobol> fromClause, List<Cobol> qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.fromClause = fromClause;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Cobol> getFromClause() {
            return this.fromClause;
        }

        public List<Cobol> getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.RecordContainsClauseFormat2(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", fromClause=" + this.getFromClause() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordContainsClauseFormat2)) {
                return false;
            }
            RecordContainsClauseFormat2 other = (RecordContainsClauseFormat2)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Cobol> this$fromClause = this.getFromClause();
            List<Cobol> other$fromClause = other.getFromClause();
            if (this$fromClause == null ? other$fromClause != null : !((Object)this$fromClause).equals(other$fromClause)) {
                return false;
            }
            List<Cobol> this$qualifiedDataName = this.getQualifiedDataName();
            List<Cobol> other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Cobol> $fromClause = this.getFromClause();
            result = result * 59 + ($fromClause == null ? 43 : ((Object)$fromClause).hashCode());
            List<Cobol> $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public RecordContainsClauseFormat2 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordContainsClauseFormat2(prefix, this.markers, this.words, this.fromClause, this.qualifiedDataName);
        }

        public RecordContainsClauseFormat2 withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordContainsClauseFormat2(this.prefix, markers, this.words, this.fromClause, this.qualifiedDataName);
        }

        public RecordContainsClauseFormat2 withWords(List<Word> words) {
            return this.words == words ? this : new RecordContainsClauseFormat2(this.prefix, this.markers, words, this.fromClause, this.qualifiedDataName);
        }

        public RecordContainsClauseFormat2 withFromClause(List<Cobol> fromClause) {
            return this.fromClause == fromClause ? this : new RecordContainsClauseFormat2(this.prefix, this.markers, this.words, fromClause, this.qualifiedDataName);
        }

        public RecordContainsClauseFormat2 withQualifiedDataName(List<Cobol> qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new RecordContainsClauseFormat2(this.prefix, this.markers, this.words, this.fromClause, qualifiedDataName);
        }
    }

    public static final class RecordContainsClauseFormat1
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Word contains;
        private final Word integerLiteral;
        @Nullable
        private final Word characters;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordContainsClauseFormat1(this, p);
        }

        public RecordContainsClauseFormat1(Space prefix, Markers markers, Word contains, Word integerLiteral, Word characters) {
            this.prefix = prefix;
            this.markers = markers;
            this.contains = contains;
            this.integerLiteral = integerLiteral;
            this.characters = characters;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getContains() {
            return this.contains;
        }

        public Word getIntegerLiteral() {
            return this.integerLiteral;
        }

        public Word getCharacters() {
            return this.characters;
        }

        public String toString() {
            return "Cobol.RecordContainsClauseFormat1(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", contains=" + this.getContains() + ", integerLiteral=" + this.getIntegerLiteral() + ", characters=" + this.getCharacters() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordContainsClauseFormat1)) {
                return false;
            }
            RecordContainsClauseFormat1 other = (RecordContainsClauseFormat1)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$contains = this.getContains();
            Word other$contains = other.getContains();
            if (this$contains == null ? other$contains != null : !((Object)this$contains).equals(other$contains)) {
                return false;
            }
            Word this$integerLiteral = this.getIntegerLiteral();
            Word other$integerLiteral = other.getIntegerLiteral();
            if (this$integerLiteral == null ? other$integerLiteral != null : !((Object)this$integerLiteral).equals(other$integerLiteral)) {
                return false;
            }
            Word this$characters = this.getCharacters();
            Word other$characters = other.getCharacters();
            return !(this$characters == null ? other$characters != null : !((Object)this$characters).equals(other$characters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $contains = this.getContains();
            result = result * 59 + ($contains == null ? 43 : ((Object)$contains).hashCode());
            Word $integerLiteral = this.getIntegerLiteral();
            result = result * 59 + ($integerLiteral == null ? 43 : ((Object)$integerLiteral).hashCode());
            Word $characters = this.getCharacters();
            result = result * 59 + ($characters == null ? 43 : ((Object)$characters).hashCode());
            return result;
        }

        public RecordContainsClauseFormat1 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordContainsClauseFormat1(prefix, this.markers, this.contains, this.integerLiteral, this.characters);
        }

        public RecordContainsClauseFormat1 withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordContainsClauseFormat1(this.prefix, markers, this.contains, this.integerLiteral, this.characters);
        }

        public RecordContainsClauseFormat1 withContains(Word contains) {
            return this.contains == contains ? this : new RecordContainsClauseFormat1(this.prefix, this.markers, contains, this.integerLiteral, this.characters);
        }

        public RecordContainsClauseFormat1 withIntegerLiteral(Word integerLiteral) {
            return this.integerLiteral == integerLiteral ? this : new RecordContainsClauseFormat1(this.prefix, this.markers, this.contains, integerLiteral, this.characters);
        }

        public RecordContainsClauseFormat1 withCharacters(Word characters) {
            return this.characters == characters ? this : new RecordContainsClauseFormat1(this.prefix, this.markers, this.contains, this.integerLiteral, characters);
        }
    }

    public static final class RecordContainsClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word record;
        private final Cobol clause;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRecordContainsClause(this, p);
        }

        public RecordContainsClause(Space prefix, Markers markers, Word record, Cobol clause) {
            this.prefix = prefix;
            this.markers = markers;
            this.record = record;
            this.clause = clause;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getRecord() {
            return this.record;
        }

        public Cobol getClause() {
            return this.clause;
        }

        public String toString() {
            return "Cobol.RecordContainsClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", record=" + this.getRecord() + ", clause=" + this.getClause() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordContainsClause)) {
                return false;
            }
            RecordContainsClause other = (RecordContainsClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$record = this.getRecord();
            Word other$record = other.getRecord();
            if (this$record == null ? other$record != null : !((Object)this$record).equals(other$record)) {
                return false;
            }
            Cobol this$clause = this.getClause();
            Cobol other$clause = other.getClause();
            return !(this$clause == null ? other$clause != null : !this$clause.equals(other$clause));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $record = this.getRecord();
            result = result * 59 + ($record == null ? 43 : ((Object)$record).hashCode());
            Cobol $clause = this.getClause();
            result = result * 59 + ($clause == null ? 43 : $clause.hashCode());
            return result;
        }

        public RecordContainsClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new RecordContainsClause(prefix, this.markers, this.record, this.clause);
        }

        public RecordContainsClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new RecordContainsClause(this.prefix, markers, this.record, this.clause);
        }

        public RecordContainsClause withRecord(Word record) {
            return this.record == record ? this : new RecordContainsClause(this.prefix, this.markers, record, this.clause);
        }

        public RecordContainsClause withClause(Cobol clause) {
            return this.clause == clause ? this : new RecordContainsClause(this.prefix, this.markers, this.record, clause);
        }
    }

    public static final class ReceiveIntoStatement
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word cdName;
        private final List<Word> words;
        private final Identifier identifier;
        @Nullable
        private final StatementPhrase receiveNoData;
        @Nullable
        private final StatementPhrase receiveWithData;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReceiveIntoStatement(this, p);
        }

        public ReceiveIntoStatement(Space prefix, Markers markers, Word cdName, List<Word> words, Identifier identifier, StatementPhrase receiveNoData, StatementPhrase receiveWithData) {
            this.prefix = prefix;
            this.markers = markers;
            this.cdName = cdName;
            this.words = words;
            this.identifier = identifier;
            this.receiveNoData = receiveNoData;
            this.receiveWithData = receiveWithData;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getCdName() {
            return this.cdName;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public StatementPhrase getReceiveNoData() {
            return this.receiveNoData;
        }

        public StatementPhrase getReceiveWithData() {
            return this.receiveWithData;
        }

        public String toString() {
            return "Cobol.ReceiveIntoStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", cdName=" + this.getCdName() + ", words=" + this.getWords() + ", identifier=" + this.getIdentifier() + ", receiveNoData=" + this.getReceiveNoData() + ", receiveWithData=" + this.getReceiveWithData() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiveIntoStatement)) {
                return false;
            }
            ReceiveIntoStatement other = (ReceiveIntoStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$cdName = this.getCdName();
            Word other$cdName = other.getCdName();
            if (this$cdName == null ? other$cdName != null : !((Object)this$cdName).equals(other$cdName)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            StatementPhrase this$receiveNoData = this.getReceiveNoData();
            StatementPhrase other$receiveNoData = other.getReceiveNoData();
            if (this$receiveNoData == null ? other$receiveNoData != null : !((Object)this$receiveNoData).equals(other$receiveNoData)) {
                return false;
            }
            StatementPhrase this$receiveWithData = this.getReceiveWithData();
            StatementPhrase other$receiveWithData = other.getReceiveWithData();
            return !(this$receiveWithData == null ? other$receiveWithData != null : !((Object)this$receiveWithData).equals(other$receiveWithData));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $cdName = this.getCdName();
            result = result * 59 + ($cdName == null ? 43 : ((Object)$cdName).hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            StatementPhrase $receiveNoData = this.getReceiveNoData();
            result = result * 59 + ($receiveNoData == null ? 43 : ((Object)$receiveNoData).hashCode());
            StatementPhrase $receiveWithData = this.getReceiveWithData();
            result = result * 59 + ($receiveWithData == null ? 43 : ((Object)$receiveWithData).hashCode());
            return result;
        }

        public ReceiveIntoStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReceiveIntoStatement(prefix, this.markers, this.cdName, this.words, this.identifier, this.receiveNoData, this.receiveWithData);
        }

        public ReceiveIntoStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReceiveIntoStatement(this.prefix, markers, this.cdName, this.words, this.identifier, this.receiveNoData, this.receiveWithData);
        }

        public ReceiveIntoStatement withCdName(Word cdName) {
            return this.cdName == cdName ? this : new ReceiveIntoStatement(this.prefix, this.markers, cdName, this.words, this.identifier, this.receiveNoData, this.receiveWithData);
        }

        public ReceiveIntoStatement withWords(List<Word> words) {
            return this.words == words ? this : new ReceiveIntoStatement(this.prefix, this.markers, this.cdName, words, this.identifier, this.receiveNoData, this.receiveWithData);
        }

        public ReceiveIntoStatement withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new ReceiveIntoStatement(this.prefix, this.markers, this.cdName, this.words, identifier, this.receiveNoData, this.receiveWithData);
        }

        public ReceiveIntoStatement withReceiveNoData(StatementPhrase receiveNoData) {
            return this.receiveNoData == receiveNoData ? this : new ReceiveIntoStatement(this.prefix, this.markers, this.cdName, this.words, this.identifier, receiveNoData, this.receiveWithData);
        }

        public ReceiveIntoStatement withReceiveWithData(StatementPhrase receiveWithData) {
            return this.receiveWithData == receiveWithData ? this : new ReceiveIntoStatement(this.prefix, this.markers, this.cdName, this.words, this.identifier, this.receiveNoData, receiveWithData);
        }
    }

    public static final class ReceiveFromStatement
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word dataName;
        private final Word from;
        private final ReceiveFrom receiveFrom;
        private final List<Cobol> beforeWithThreadSizeStatus;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReceiveFromStatement(this, p);
        }

        public ReceiveFromStatement(Space prefix, Markers markers, Word dataName, Word from, ReceiveFrom receiveFrom, List<Cobol> beforeWithThreadSizeStatus) {
            this.prefix = prefix;
            this.markers = markers;
            this.dataName = dataName;
            this.from = from;
            this.receiveFrom = receiveFrom;
            this.beforeWithThreadSizeStatus = beforeWithThreadSizeStatus;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getDataName() {
            return this.dataName;
        }

        public Word getFrom() {
            return this.from;
        }

        public ReceiveFrom getReceiveFrom() {
            return this.receiveFrom;
        }

        public List<Cobol> getBeforeWithThreadSizeStatus() {
            return this.beforeWithThreadSizeStatus;
        }

        public String toString() {
            return "Cobol.ReceiveFromStatement(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", dataName=" + this.getDataName() + ", from=" + this.getFrom() + ", receiveFrom=" + this.getReceiveFrom() + ", beforeWithThreadSizeStatus=" + this.getBeforeWithThreadSizeStatus() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiveFromStatement)) {
                return false;
            }
            ReceiveFromStatement other = (ReceiveFromStatement)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$dataName = this.getDataName();
            Word other$dataName = other.getDataName();
            if (this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName)) {
                return false;
            }
            Word this$from = this.getFrom();
            Word other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            ReceiveFrom this$receiveFrom = this.getReceiveFrom();
            ReceiveFrom other$receiveFrom = other.getReceiveFrom();
            if (this$receiveFrom == null ? other$receiveFrom != null : !((Object)this$receiveFrom).equals(other$receiveFrom)) {
                return false;
            }
            List<Cobol> this$beforeWithThreadSizeStatus = this.getBeforeWithThreadSizeStatus();
            List<Cobol> other$beforeWithThreadSizeStatus = other.getBeforeWithThreadSizeStatus();
            return !(this$beforeWithThreadSizeStatus == null ? other$beforeWithThreadSizeStatus != null : !((Object)this$beforeWithThreadSizeStatus).equals(other$beforeWithThreadSizeStatus));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
            Word $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            ReceiveFrom $receiveFrom = this.getReceiveFrom();
            result = result * 59 + ($receiveFrom == null ? 43 : ((Object)$receiveFrom).hashCode());
            List<Cobol> $beforeWithThreadSizeStatus = this.getBeforeWithThreadSizeStatus();
            result = result * 59 + ($beforeWithThreadSizeStatus == null ? 43 : ((Object)$beforeWithThreadSizeStatus).hashCode());
            return result;
        }

        public ReceiveFromStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReceiveFromStatement(prefix, this.markers, this.dataName, this.from, this.receiveFrom, this.beforeWithThreadSizeStatus);
        }

        public ReceiveFromStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReceiveFromStatement(this.prefix, markers, this.dataName, this.from, this.receiveFrom, this.beforeWithThreadSizeStatus);
        }

        public ReceiveFromStatement withDataName(Word dataName) {
            return this.dataName == dataName ? this : new ReceiveFromStatement(this.prefix, this.markers, dataName, this.from, this.receiveFrom, this.beforeWithThreadSizeStatus);
        }

        public ReceiveFromStatement withFrom(Word from) {
            return this.from == from ? this : new ReceiveFromStatement(this.prefix, this.markers, this.dataName, from, this.receiveFrom, this.beforeWithThreadSizeStatus);
        }

        public ReceiveFromStatement withReceiveFrom(ReceiveFrom receiveFrom) {
            return this.receiveFrom == receiveFrom ? this : new ReceiveFromStatement(this.prefix, this.markers, this.dataName, this.from, receiveFrom, this.beforeWithThreadSizeStatus);
        }

        public ReceiveFromStatement withBeforeWithThreadSizeStatus(List<Cobol> beforeWithThreadSizeStatus) {
            return this.beforeWithThreadSizeStatus == beforeWithThreadSizeStatus ? this : new ReceiveFromStatement(this.prefix, this.markers, this.dataName, this.from, this.receiveFrom, beforeWithThreadSizeStatus);
        }
    }

    public static final class ReceiveFrom
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final Word dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReceiveFrom(this, p);
        }

        public ReceiveFrom(Space prefix, Markers markers, List<Word> words, Word dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Word getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ReceiveFrom(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiveFrom)) {
                return false;
            }
            ReceiveFrom other = (ReceiveFrom)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Word this$dataName = this.getDataName();
            Word other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Word $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
            return result;
        }

        public ReceiveFrom withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReceiveFrom(prefix, this.markers, this.words, this.dataName);
        }

        public ReceiveFrom withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReceiveFrom(this.prefix, markers, this.words, this.dataName);
        }

        public ReceiveFrom withWords(List<Word> words) {
            return this.words == words ? this : new ReceiveFrom(this.prefix, this.markers, words, this.dataName);
        }

        public ReceiveFrom withDataName(Word dataName) {
            return this.dataName == dataName ? this : new ReceiveFrom(this.prefix, this.markers, this.words, dataName);
        }
    }

    public static final class Receive
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word receive;
        private final Cobol fromOrInto;
        @Nullable
        private final StatementPhrase onExceptionClause;
        @Nullable
        private final StatementPhrase notOnExceptionClause;
        private final Word endReceive;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReceive(this, p);
        }

        public Receive(Space prefix, Markers markers, Word receive, Cobol fromOrInto, StatementPhrase onExceptionClause, StatementPhrase notOnExceptionClause, Word endReceive) {
            this.prefix = prefix;
            this.markers = markers;
            this.receive = receive;
            this.fromOrInto = fromOrInto;
            this.onExceptionClause = onExceptionClause;
            this.notOnExceptionClause = notOnExceptionClause;
            this.endReceive = endReceive;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getReceive() {
            return this.receive;
        }

        public Cobol getFromOrInto() {
            return this.fromOrInto;
        }

        public StatementPhrase getOnExceptionClause() {
            return this.onExceptionClause;
        }

        public StatementPhrase getNotOnExceptionClause() {
            return this.notOnExceptionClause;
        }

        public Word getEndReceive() {
            return this.endReceive;
        }

        public String toString() {
            return "Cobol.Receive(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", receive=" + this.getReceive() + ", fromOrInto=" + this.getFromOrInto() + ", onExceptionClause=" + this.getOnExceptionClause() + ", notOnExceptionClause=" + this.getNotOnExceptionClause() + ", endReceive=" + this.getEndReceive() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Receive)) {
                return false;
            }
            Receive other = (Receive)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$receive = this.getReceive();
            Word other$receive = other.getReceive();
            if (this$receive == null ? other$receive != null : !((Object)this$receive).equals(other$receive)) {
                return false;
            }
            Cobol this$fromOrInto = this.getFromOrInto();
            Cobol other$fromOrInto = other.getFromOrInto();
            if (this$fromOrInto == null ? other$fromOrInto != null : !this$fromOrInto.equals(other$fromOrInto)) {
                return false;
            }
            StatementPhrase this$onExceptionClause = this.getOnExceptionClause();
            StatementPhrase other$onExceptionClause = other.getOnExceptionClause();
            if (this$onExceptionClause == null ? other$onExceptionClause != null : !((Object)this$onExceptionClause).equals(other$onExceptionClause)) {
                return false;
            }
            StatementPhrase this$notOnExceptionClause = this.getNotOnExceptionClause();
            StatementPhrase other$notOnExceptionClause = other.getNotOnExceptionClause();
            if (this$notOnExceptionClause == null ? other$notOnExceptionClause != null : !((Object)this$notOnExceptionClause).equals(other$notOnExceptionClause)) {
                return false;
            }
            Word this$endReceive = this.getEndReceive();
            Word other$endReceive = other.getEndReceive();
            return !(this$endReceive == null ? other$endReceive != null : !((Object)this$endReceive).equals(other$endReceive));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $receive = this.getReceive();
            result = result * 59 + ($receive == null ? 43 : ((Object)$receive).hashCode());
            Cobol $fromOrInto = this.getFromOrInto();
            result = result * 59 + ($fromOrInto == null ? 43 : $fromOrInto.hashCode());
            StatementPhrase $onExceptionClause = this.getOnExceptionClause();
            result = result * 59 + ($onExceptionClause == null ? 43 : ((Object)$onExceptionClause).hashCode());
            StatementPhrase $notOnExceptionClause = this.getNotOnExceptionClause();
            result = result * 59 + ($notOnExceptionClause == null ? 43 : ((Object)$notOnExceptionClause).hashCode());
            Word $endReceive = this.getEndReceive();
            result = result * 59 + ($endReceive == null ? 43 : ((Object)$endReceive).hashCode());
            return result;
        }

        public Receive withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Receive(prefix, this.markers, this.receive, this.fromOrInto, this.onExceptionClause, this.notOnExceptionClause, this.endReceive);
        }

        public Receive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Receive(this.prefix, markers, this.receive, this.fromOrInto, this.onExceptionClause, this.notOnExceptionClause, this.endReceive);
        }

        public Receive withReceive(Word receive) {
            return this.receive == receive ? this : new Receive(this.prefix, this.markers, receive, this.fromOrInto, this.onExceptionClause, this.notOnExceptionClause, this.endReceive);
        }

        public Receive withFromOrInto(Cobol fromOrInto) {
            return this.fromOrInto == fromOrInto ? this : new Receive(this.prefix, this.markers, this.receive, fromOrInto, this.onExceptionClause, this.notOnExceptionClause, this.endReceive);
        }

        public Receive withOnExceptionClause(StatementPhrase onExceptionClause) {
            return this.onExceptionClause == onExceptionClause ? this : new Receive(this.prefix, this.markers, this.receive, this.fromOrInto, onExceptionClause, this.notOnExceptionClause, this.endReceive);
        }

        public Receive withNotOnExceptionClause(StatementPhrase notOnExceptionClause) {
            return this.notOnExceptionClause == notOnExceptionClause ? this : new Receive(this.prefix, this.markers, this.receive, this.fromOrInto, this.onExceptionClause, notOnExceptionClause, this.endReceive);
        }

        public Receive withEndReceive(Word endReceive) {
            return this.endReceive == endReceive ? this : new Receive(this.prefix, this.markers, this.receive, this.fromOrInto, this.onExceptionClause, this.notOnExceptionClause, endReceive);
        }
    }

    public static final class ReceiveWith
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReceiveWith(this, p);
        }

        public ReceiveWith(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReceiveWith(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceiveWith)) {
                return false;
            }
            ReceiveWith other = (ReceiveWith)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReceiveWith withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReceiveWith(prefix, this.markers, this.words);
        }

        public ReceiveWith withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReceiveWith(this.prefix, markers, this.words);
        }

        public ReceiveWith withWords(List<Word> words) {
            return this.words == words ? this : new ReceiveWith(this.prefix, this.markers, words);
        }
    }

    public static final class Receivable
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final Name value;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReceivable(this, p);
        }

        public Receivable(Space prefix, Markers markers, List<Word> words, Name value) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.value = value;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public Name getValue() {
            return this.value;
        }

        public String toString() {
            return "Cobol.Receivable(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Receivable)) {
                return false;
            }
            Receivable other = (Receivable)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            Name this$value = this.getValue();
            Name other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            Name $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public Receivable withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Receivable(prefix, this.markers, this.words, this.value);
        }

        public Receivable withMarkers(Markers markers) {
            return this.markers == markers ? this : new Receivable(this.prefix, markers, this.words, this.value);
        }

        public Receivable withWords(List<Word> words) {
            return this.words == words ? this : new Receivable(this.prefix, this.markers, words, this.value);
        }

        public Receivable withValue(Name value) {
            return this.value == value ? this : new Receivable(this.prefix, this.markers, this.words, value);
        }
    }

    public static final class ReadWith
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReadWith(this, p);
        }

        public ReadWith(Space prefix, Markers markers, List<Word> words) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            return "Cobol.ReadWith(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadWith)) {
                return false;
            }
            ReadWith other = (ReadWith)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            return !(this$words == null ? other$words != null : !((Object)this$words).equals(other$words));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            return result;
        }

        public ReadWith withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReadWith(prefix, this.markers, this.words);
        }

        public ReadWith withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReadWith(this.prefix, markers, this.words);
        }

        public ReadWith withWords(List<Word> words) {
            return this.words == words ? this : new ReadWith(this.prefix, this.markers, words);
        }
    }

    public static final class ReadKey
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final QualifiedDataName qualifiedDataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReadKey(this, p);
        }

        public ReadKey(Space prefix, Markers markers, List<Word> words, QualifiedDataName qualifiedDataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.qualifiedDataName = qualifiedDataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public QualifiedDataName getQualifiedDataName() {
            return this.qualifiedDataName;
        }

        public String toString() {
            return "Cobol.ReadKey(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", qualifiedDataName=" + this.getQualifiedDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadKey)) {
                return false;
            }
            ReadKey other = (ReadKey)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            QualifiedDataName this$qualifiedDataName = this.getQualifiedDataName();
            QualifiedDataName other$qualifiedDataName = other.getQualifiedDataName();
            return !(this$qualifiedDataName == null ? other$qualifiedDataName != null : !((Object)this$qualifiedDataName).equals(other$qualifiedDataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            QualifiedDataName $qualifiedDataName = this.getQualifiedDataName();
            result = result * 59 + ($qualifiedDataName == null ? 43 : ((Object)$qualifiedDataName).hashCode());
            return result;
        }

        public ReadKey withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReadKey(prefix, this.markers, this.words, this.qualifiedDataName);
        }

        public ReadKey withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReadKey(this.prefix, markers, this.words, this.qualifiedDataName);
        }

        public ReadKey withWords(List<Word> words) {
            return this.words == words ? this : new ReadKey(this.prefix, this.markers, words, this.qualifiedDataName);
        }

        public ReadKey withQualifiedDataName(QualifiedDataName qualifiedDataName) {
            return this.qualifiedDataName == qualifiedDataName ? this : new ReadKey(this.prefix, this.markers, this.words, qualifiedDataName);
        }
    }

    public static final class ReadInto
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Identifier identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitReadInto(this, p);
        }

        public ReadInto(Space prefix, Markers markers, Word word, Identifier identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.ReadInto(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadInto)) {
                return false;
            }
            ReadInto other = (ReadInto)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Identifier this$identifier = this.getIdentifier();
            Identifier other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Identifier $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public ReadInto withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ReadInto(prefix, this.markers, this.word, this.identifier);
        }

        public ReadInto withMarkers(Markers markers) {
            return this.markers == markers ? this : new ReadInto(this.prefix, markers, this.word, this.identifier);
        }

        public ReadInto withWord(Word word) {
            return this.word == word ? this : new ReadInto(this.prefix, this.markers, word, this.identifier);
        }

        public ReadInto withIdentifier(Identifier identifier) {
            return this.identifier == identifier ? this : new ReadInto(this.prefix, this.markers, this.word, identifier);
        }
    }

    public static final class Read
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Name fileName;
        private final List<Word> nextRecord;
        @Nullable
        private final ReadInto readInto;
        @Nullable
        private final ReadWith readWith;
        @Nullable
        private final ReadKey readKey;
        @Nullable
        private final StatementPhrase invalidKeyPhrase;
        @Nullable
        private final StatementPhrase notInvalidKeyPhrase;
        @Nullable
        private final StatementPhrase atEndPhrase;
        @Nullable
        private final StatementPhrase notAtEndPhrase;
        private final Word endRead;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitRead(this, p);
        }

        public Read(Space prefix, Markers markers, Word word, Name fileName, List<Word> nextRecord, ReadInto readInto, ReadWith readWith, ReadKey readKey, StatementPhrase invalidKeyPhrase, StatementPhrase notInvalidKeyPhrase, StatementPhrase atEndPhrase, StatementPhrase notAtEndPhrase, Word endRead) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.fileName = fileName;
            this.nextRecord = nextRecord;
            this.readInto = readInto;
            this.readWith = readWith;
            this.readKey = readKey;
            this.invalidKeyPhrase = invalidKeyPhrase;
            this.notInvalidKeyPhrase = notInvalidKeyPhrase;
            this.atEndPhrase = atEndPhrase;
            this.notAtEndPhrase = notAtEndPhrase;
            this.endRead = endRead;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getFileName() {
            return this.fileName;
        }

        public List<Word> getNextRecord() {
            return this.nextRecord;
        }

        public ReadInto getReadInto() {
            return this.readInto;
        }

        public ReadWith getReadWith() {
            return this.readWith;
        }

        public ReadKey getReadKey() {
            return this.readKey;
        }

        public StatementPhrase getInvalidKeyPhrase() {
            return this.invalidKeyPhrase;
        }

        public StatementPhrase getNotInvalidKeyPhrase() {
            return this.notInvalidKeyPhrase;
        }

        public StatementPhrase getAtEndPhrase() {
            return this.atEndPhrase;
        }

        public StatementPhrase getNotAtEndPhrase() {
            return this.notAtEndPhrase;
        }

        public Word getEndRead() {
            return this.endRead;
        }

        public String toString() {
            return "Cobol.Read(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", fileName=" + this.getFileName() + ", nextRecord=" + this.getNextRecord() + ", readInto=" + this.getReadInto() + ", readWith=" + this.getReadWith() + ", readKey=" + this.getReadKey() + ", invalidKeyPhrase=" + this.getInvalidKeyPhrase() + ", notInvalidKeyPhrase=" + this.getNotInvalidKeyPhrase() + ", atEndPhrase=" + this.getAtEndPhrase() + ", notAtEndPhrase=" + this.getNotAtEndPhrase() + ", endRead=" + this.getEndRead() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Read)) {
                return false;
            }
            Read other = (Read)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$fileName = this.getFileName();
            Name other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            List<Word> this$nextRecord = this.getNextRecord();
            List<Word> other$nextRecord = other.getNextRecord();
            if (this$nextRecord == null ? other$nextRecord != null : !((Object)this$nextRecord).equals(other$nextRecord)) {
                return false;
            }
            ReadInto this$readInto = this.getReadInto();
            ReadInto other$readInto = other.getReadInto();
            if (this$readInto == null ? other$readInto != null : !((Object)this$readInto).equals(other$readInto)) {
                return false;
            }
            ReadWith this$readWith = this.getReadWith();
            ReadWith other$readWith = other.getReadWith();
            if (this$readWith == null ? other$readWith != null : !((Object)this$readWith).equals(other$readWith)) {
                return false;
            }
            ReadKey this$readKey = this.getReadKey();
            ReadKey other$readKey = other.getReadKey();
            if (this$readKey == null ? other$readKey != null : !((Object)this$readKey).equals(other$readKey)) {
                return false;
            }
            StatementPhrase this$invalidKeyPhrase = this.getInvalidKeyPhrase();
            StatementPhrase other$invalidKeyPhrase = other.getInvalidKeyPhrase();
            if (this$invalidKeyPhrase == null ? other$invalidKeyPhrase != null : !((Object)this$invalidKeyPhrase).equals(other$invalidKeyPhrase)) {
                return false;
            }
            StatementPhrase this$notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            StatementPhrase other$notInvalidKeyPhrase = other.getNotInvalidKeyPhrase();
            if (this$notInvalidKeyPhrase == null ? other$notInvalidKeyPhrase != null : !((Object)this$notInvalidKeyPhrase).equals(other$notInvalidKeyPhrase)) {
                return false;
            }
            StatementPhrase this$atEndPhrase = this.getAtEndPhrase();
            StatementPhrase other$atEndPhrase = other.getAtEndPhrase();
            if (this$atEndPhrase == null ? other$atEndPhrase != null : !((Object)this$atEndPhrase).equals(other$atEndPhrase)) {
                return false;
            }
            StatementPhrase this$notAtEndPhrase = this.getNotAtEndPhrase();
            StatementPhrase other$notAtEndPhrase = other.getNotAtEndPhrase();
            if (this$notAtEndPhrase == null ? other$notAtEndPhrase != null : !((Object)this$notAtEndPhrase).equals(other$notAtEndPhrase)) {
                return false;
            }
            Word this$endRead = this.getEndRead();
            Word other$endRead = other.getEndRead();
            return !(this$endRead == null ? other$endRead != null : !((Object)this$endRead).equals(other$endRead));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            List<Word> $nextRecord = this.getNextRecord();
            result = result * 59 + ($nextRecord == null ? 43 : ((Object)$nextRecord).hashCode());
            ReadInto $readInto = this.getReadInto();
            result = result * 59 + ($readInto == null ? 43 : ((Object)$readInto).hashCode());
            ReadWith $readWith = this.getReadWith();
            result = result * 59 + ($readWith == null ? 43 : ((Object)$readWith).hashCode());
            ReadKey $readKey = this.getReadKey();
            result = result * 59 + ($readKey == null ? 43 : ((Object)$readKey).hashCode());
            StatementPhrase $invalidKeyPhrase = this.getInvalidKeyPhrase();
            result = result * 59 + ($invalidKeyPhrase == null ? 43 : ((Object)$invalidKeyPhrase).hashCode());
            StatementPhrase $notInvalidKeyPhrase = this.getNotInvalidKeyPhrase();
            result = result * 59 + ($notInvalidKeyPhrase == null ? 43 : ((Object)$notInvalidKeyPhrase).hashCode());
            StatementPhrase $atEndPhrase = this.getAtEndPhrase();
            result = result * 59 + ($atEndPhrase == null ? 43 : ((Object)$atEndPhrase).hashCode());
            StatementPhrase $notAtEndPhrase = this.getNotAtEndPhrase();
            result = result * 59 + ($notAtEndPhrase == null ? 43 : ((Object)$notAtEndPhrase).hashCode());
            Word $endRead = this.getEndRead();
            result = result * 59 + ($endRead == null ? 43 : ((Object)$endRead).hashCode());
            return result;
        }

        public Read withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Read(prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withMarkers(Markers markers) {
            return this.markers == markers ? this : new Read(this.prefix, markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withWord(Word word) {
            return this.word == word ? this : new Read(this.prefix, this.markers, word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withFileName(Name fileName) {
            return this.fileName == fileName ? this : new Read(this.prefix, this.markers, this.word, fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withNextRecord(List<Word> nextRecord) {
            return this.nextRecord == nextRecord ? this : new Read(this.prefix, this.markers, this.word, this.fileName, nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withReadInto(ReadInto readInto) {
            return this.readInto == readInto ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withReadWith(ReadWith readWith) {
            return this.readWith == readWith ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withReadKey(ReadKey readKey) {
            return this.readKey == readKey ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withInvalidKeyPhrase(StatementPhrase invalidKeyPhrase) {
            return this.invalidKeyPhrase == invalidKeyPhrase ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withNotInvalidKeyPhrase(StatementPhrase notInvalidKeyPhrase) {
            return this.notInvalidKeyPhrase == notInvalidKeyPhrase ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withAtEndPhrase(StatementPhrase atEndPhrase) {
            return this.atEndPhrase == atEndPhrase ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, atEndPhrase, this.notAtEndPhrase, this.endRead);
        }

        public Read withNotAtEndPhrase(StatementPhrase notAtEndPhrase) {
            return this.notAtEndPhrase == notAtEndPhrase ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, notAtEndPhrase, this.endRead);
        }

        public Read withEndRead(Word endRead) {
            return this.endRead == endRead ? this : new Read(this.prefix, this.markers, this.word, this.fileName, this.nextRecord, this.readInto, this.readWith, this.readKey, this.invalidKeyPhrase, this.notInvalidKeyPhrase, this.atEndPhrase, this.notAtEndPhrase, endRead);
        }
    }

    public static final class QualifiedInData
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Cobol in;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitQualifiedInData(this, p);
        }

        public QualifiedInData(Space prefix, Markers markers, Cobol in) {
            this.prefix = prefix;
            this.markers = markers;
            this.in = in;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Cobol getIn() {
            return this.in;
        }

        public String toString() {
            return "Cobol.QualifiedInData(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", in=" + this.getIn() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedInData)) {
                return false;
            }
            QualifiedInData other = (QualifiedInData)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Cobol this$in = this.getIn();
            Cobol other$in = other.getIn();
            return !(this$in == null ? other$in != null : !this$in.equals(other$in));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Cobol $in = this.getIn();
            result = result * 59 + ($in == null ? 43 : $in.hashCode());
            return result;
        }

        public QualifiedInData withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QualifiedInData(prefix, this.markers, this.in);
        }

        public QualifiedInData withMarkers(Markers markers) {
            return this.markers == markers ? this : new QualifiedInData(this.prefix, markers, this.in);
        }

        public QualifiedInData withIn(Cobol in) {
            return this.in == in ? this : new QualifiedInData(this.prefix, this.markers, in);
        }
    }

    public static final class QualifiedDataNameFormat4
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word linageCounter;
        private final InFile inFile;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitQualifiedDataNameFormat4(this, p);
        }

        public QualifiedDataNameFormat4(Space prefix, Markers markers, Word linageCounter, InFile inFile) {
            this.prefix = prefix;
            this.markers = markers;
            this.linageCounter = linageCounter;
            this.inFile = inFile;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getLinageCounter() {
            return this.linageCounter;
        }

        public InFile getInFile() {
            return this.inFile;
        }

        public String toString() {
            return "Cobol.QualifiedDataNameFormat4(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", linageCounter=" + this.getLinageCounter() + ", inFile=" + this.getInFile() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedDataNameFormat4)) {
                return false;
            }
            QualifiedDataNameFormat4 other = (QualifiedDataNameFormat4)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$linageCounter = this.getLinageCounter();
            Word other$linageCounter = other.getLinageCounter();
            if (this$linageCounter == null ? other$linageCounter != null : !((Object)this$linageCounter).equals(other$linageCounter)) {
                return false;
            }
            InFile this$inFile = this.getInFile();
            InFile other$inFile = other.getInFile();
            return !(this$inFile == null ? other$inFile != null : !((Object)this$inFile).equals(other$inFile));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $linageCounter = this.getLinageCounter();
            result = result * 59 + ($linageCounter == null ? 43 : ((Object)$linageCounter).hashCode());
            InFile $inFile = this.getInFile();
            result = result * 59 + ($inFile == null ? 43 : ((Object)$inFile).hashCode());
            return result;
        }

        public QualifiedDataNameFormat4 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QualifiedDataNameFormat4(prefix, this.markers, this.linageCounter, this.inFile);
        }

        public QualifiedDataNameFormat4 withMarkers(Markers markers) {
            return this.markers == markers ? this : new QualifiedDataNameFormat4(this.prefix, markers, this.linageCounter, this.inFile);
        }

        public QualifiedDataNameFormat4 withLinageCounter(Word linageCounter) {
            return this.linageCounter == linageCounter ? this : new QualifiedDataNameFormat4(this.prefix, this.markers, linageCounter, this.inFile);
        }

        public QualifiedDataNameFormat4 withInFile(InFile inFile) {
            return this.inFile == inFile ? this : new QualifiedDataNameFormat4(this.prefix, this.markers, this.linageCounter, inFile);
        }
    }

    public static final class QualifiedDataNameFormat3
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name textName;
        private final InLibrary inLibrary;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitQualifiedDataNameFormat3(this, p);
        }

        public QualifiedDataNameFormat3(Space prefix, Markers markers, Name textName, InLibrary inLibrary) {
            this.prefix = prefix;
            this.markers = markers;
            this.textName = textName;
            this.inLibrary = inLibrary;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getTextName() {
            return this.textName;
        }

        public InLibrary getInLibrary() {
            return this.inLibrary;
        }

        public String toString() {
            return "Cobol.QualifiedDataNameFormat3(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", textName=" + this.getTextName() + ", inLibrary=" + this.getInLibrary() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedDataNameFormat3)) {
                return false;
            }
            QualifiedDataNameFormat3 other = (QualifiedDataNameFormat3)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$textName = this.getTextName();
            Name other$textName = other.getTextName();
            if (this$textName == null ? other$textName != null : !this$textName.equals(other$textName)) {
                return false;
            }
            InLibrary this$inLibrary = this.getInLibrary();
            InLibrary other$inLibrary = other.getInLibrary();
            return !(this$inLibrary == null ? other$inLibrary != null : !((Object)this$inLibrary).equals(other$inLibrary));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $textName = this.getTextName();
            result = result * 59 + ($textName == null ? 43 : $textName.hashCode());
            InLibrary $inLibrary = this.getInLibrary();
            result = result * 59 + ($inLibrary == null ? 43 : ((Object)$inLibrary).hashCode());
            return result;
        }

        public QualifiedDataNameFormat3 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QualifiedDataNameFormat3(prefix, this.markers, this.textName, this.inLibrary);
        }

        public QualifiedDataNameFormat3 withMarkers(Markers markers) {
            return this.markers == markers ? this : new QualifiedDataNameFormat3(this.prefix, markers, this.textName, this.inLibrary);
        }

        public QualifiedDataNameFormat3 withTextName(Name textName) {
            return this.textName == textName ? this : new QualifiedDataNameFormat3(this.prefix, this.markers, textName, this.inLibrary);
        }

        public QualifiedDataNameFormat3 withInLibrary(InLibrary inLibrary) {
            return this.inLibrary == inLibrary ? this : new QualifiedDataNameFormat3(this.prefix, this.markers, this.textName, inLibrary);
        }
    }

    public static final class QualifiedDataNameFormat2
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name paragraphName;
        private final InSection inSection;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitQualifiedDataNameFormat2(this, p);
        }

        public QualifiedDataNameFormat2(Space prefix, Markers markers, Name paragraphName, InSection inSection) {
            this.prefix = prefix;
            this.markers = markers;
            this.paragraphName = paragraphName;
            this.inSection = inSection;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getParagraphName() {
            return this.paragraphName;
        }

        public InSection getInSection() {
            return this.inSection;
        }

        public String toString() {
            return "Cobol.QualifiedDataNameFormat2(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", paragraphName=" + this.getParagraphName() + ", inSection=" + this.getInSection() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedDataNameFormat2)) {
                return false;
            }
            QualifiedDataNameFormat2 other = (QualifiedDataNameFormat2)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$paragraphName = this.getParagraphName();
            Name other$paragraphName = other.getParagraphName();
            if (this$paragraphName == null ? other$paragraphName != null : !this$paragraphName.equals(other$paragraphName)) {
                return false;
            }
            InSection this$inSection = this.getInSection();
            InSection other$inSection = other.getInSection();
            return !(this$inSection == null ? other$inSection != null : !((Object)this$inSection).equals(other$inSection));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $paragraphName = this.getParagraphName();
            result = result * 59 + ($paragraphName == null ? 43 : $paragraphName.hashCode());
            InSection $inSection = this.getInSection();
            result = result * 59 + ($inSection == null ? 43 : ((Object)$inSection).hashCode());
            return result;
        }

        public QualifiedDataNameFormat2 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QualifiedDataNameFormat2(prefix, this.markers, this.paragraphName, this.inSection);
        }

        public QualifiedDataNameFormat2 withMarkers(Markers markers) {
            return this.markers == markers ? this : new QualifiedDataNameFormat2(this.prefix, markers, this.paragraphName, this.inSection);
        }

        public QualifiedDataNameFormat2 withParagraphName(Name paragraphName) {
            return this.paragraphName == paragraphName ? this : new QualifiedDataNameFormat2(this.prefix, this.markers, paragraphName, this.inSection);
        }

        public QualifiedDataNameFormat2 withInSection(InSection inSection) {
            return this.inSection == inSection ? this : new QualifiedDataNameFormat2(this.prefix, this.markers, this.paragraphName, inSection);
        }
    }

    public static final class QualifiedDataNameFormat1
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        @Nullable
        private final List<Cobol> qualifiedInData;
        @Nullable
        private final InFile inFile;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitQualifiedDataNameFormat1(this, p);
        }

        public QualifiedDataNameFormat1(Space prefix, Markers markers, Name name, List<Cobol> qualifiedInData, InFile inFile) {
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.qualifiedInData = qualifiedInData;
            this.inFile = inFile;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public List<Cobol> getQualifiedInData() {
            return this.qualifiedInData;
        }

        public InFile getInFile() {
            return this.inFile;
        }

        public String toString() {
            return "Cobol.QualifiedDataNameFormat1(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", qualifiedInData=" + this.getQualifiedInData() + ", inFile=" + this.getInFile() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedDataNameFormat1)) {
                return false;
            }
            QualifiedDataNameFormat1 other = (QualifiedDataNameFormat1)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Cobol> this$qualifiedInData = this.getQualifiedInData();
            List<Cobol> other$qualifiedInData = other.getQualifiedInData();
            if (this$qualifiedInData == null ? other$qualifiedInData != null : !((Object)this$qualifiedInData).equals(other$qualifiedInData)) {
                return false;
            }
            InFile this$inFile = this.getInFile();
            InFile other$inFile = other.getInFile();
            return !(this$inFile == null ? other$inFile != null : !((Object)this$inFile).equals(other$inFile));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Cobol> $qualifiedInData = this.getQualifiedInData();
            result = result * 59 + ($qualifiedInData == null ? 43 : ((Object)$qualifiedInData).hashCode());
            InFile $inFile = this.getInFile();
            result = result * 59 + ($inFile == null ? 43 : ((Object)$inFile).hashCode());
            return result;
        }

        public QualifiedDataNameFormat1 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QualifiedDataNameFormat1(prefix, this.markers, this.name, this.qualifiedInData, this.inFile);
        }

        public QualifiedDataNameFormat1 withMarkers(Markers markers) {
            return this.markers == markers ? this : new QualifiedDataNameFormat1(this.prefix, markers, this.name, this.qualifiedInData, this.inFile);
        }

        public QualifiedDataNameFormat1 withName(Name name) {
            return this.name == name ? this : new QualifiedDataNameFormat1(this.prefix, this.markers, name, this.qualifiedInData, this.inFile);
        }

        public QualifiedDataNameFormat1 withQualifiedInData(List<Cobol> qualifiedInData) {
            return this.qualifiedInData == qualifiedInData ? this : new QualifiedDataNameFormat1(this.prefix, this.markers, this.name, qualifiedInData, this.inFile);
        }

        public QualifiedDataNameFormat1 withInFile(InFile inFile) {
            return this.inFile == inFile ? this : new QualifiedDataNameFormat1(this.prefix, this.markers, this.name, this.qualifiedInData, inFile);
        }
    }

    public static final class QualifiedDataName
    implements Cobol,
    Identifier {
        private final Space prefix;
        private final Markers markers;
        private final Cobol dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitQualifiedDataName(this, p);
        }

        public QualifiedDataName(Space prefix, Markers markers, Cobol dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Cobol getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.QualifiedDataName(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QualifiedDataName)) {
                return false;
            }
            QualifiedDataName other = (QualifiedDataName)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Cobol this$dataName = this.getDataName();
            Cobol other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Cobol $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public QualifiedDataName withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new QualifiedDataName(prefix, this.markers, this.dataName);
        }

        public QualifiedDataName withMarkers(Markers markers) {
            return this.markers == markers ? this : new QualifiedDataName(this.prefix, markers, this.dataName);
        }

        public QualifiedDataName withDataName(Cobol dataName) {
            return this.dataName == dataName ? this : new QualifiedDataName(this.prefix, this.markers, dataName);
        }
    }

    public static final class Purge
    implements Statement {
        private final Space prefix;
        private final Markers markers;
        private final Word purge;
        private final List<Name> names;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitPurge(this, p);
        }

        public Purge(Space prefix, Markers markers, Word purge, List<Name> names) {
            this.prefix = prefix;
            this.markers = markers;
            this.purge = purge;
            this.names = names;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getPurge() {
            return this.purge;
        }

        public List<Name> getNames() {
            return this.names;
        }

        public String toString() {
            return "Cobol.Purge(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", purge=" + this.getPurge() + ", names=" + this.getNames() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Purge)) {
                return false;
            }
            Purge other = (Purge)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$purge = this.getPurge();
            Word other$purge = other.getPurge();
            if (this$purge == null ? other$purge != null : !((Object)this$purge).equals(other$purge)) {
                return false;
            }
            List<Name> this$names = this.getNames();
            List<Name> other$names = other.getNames();
            return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $purge = this.getPurge();
            result = result * 59 + ($purge == null ? 43 : ((Object)$purge).hashCode());
            List<Name> $names = this.getNames();
            result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
            return result;
        }

        public Purge withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Purge(prefix, this.markers, this.purge, this.names);
        }

        public Purge withMarkers(Markers markers) {
            return this.markers == markers ? this : new Purge(this.prefix, markers, this.purge, this.names);
        }

        public Purge withPurge(Word purge) {
            return this.purge == purge ? this : new Purge(this.prefix, this.markers, purge, this.names);
        }

        public Purge withNames(List<Name> names) {
            return this.names == names ? this : new Purge(this.prefix, this.markers, this.purge, names);
        }
    }

    public static final class ProgramUnit
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<CobolPreprocessor.CompilerOptions> compilerOptions;
        private final IdentificationDivision identificationDivision;
        @Nullable
        private final EnvironmentDivision environmentDivision;
        @Nullable
        private final DataDivision dataDivision;
        @Nullable
        private final ProcedureDivision procedureDivision;
        @Nullable
        private final List<ProgramUnit> programUnits;
        @Nullable
        private final EndProgram endProgram;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProgramUnit(this, p);
        }

        public ProgramUnit(Space prefix, Markers markers, List<CobolPreprocessor.CompilerOptions> compilerOptions, IdentificationDivision identificationDivision, EnvironmentDivision environmentDivision, DataDivision dataDivision, ProcedureDivision procedureDivision, List<ProgramUnit> programUnits, EndProgram endProgram) {
            this.prefix = prefix;
            this.markers = markers;
            this.compilerOptions = compilerOptions;
            this.identificationDivision = identificationDivision;
            this.environmentDivision = environmentDivision;
            this.dataDivision = dataDivision;
            this.procedureDivision = procedureDivision;
            this.programUnits = programUnits;
            this.endProgram = endProgram;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<CobolPreprocessor.CompilerOptions> getCompilerOptions() {
            return this.compilerOptions;
        }

        public IdentificationDivision getIdentificationDivision() {
            return this.identificationDivision;
        }

        public EnvironmentDivision getEnvironmentDivision() {
            return this.environmentDivision;
        }

        public DataDivision getDataDivision() {
            return this.dataDivision;
        }

        public ProcedureDivision getProcedureDivision() {
            return this.procedureDivision;
        }

        public List<ProgramUnit> getProgramUnits() {
            return this.programUnits;
        }

        public EndProgram getEndProgram() {
            return this.endProgram;
        }

        public String toString() {
            return "Cobol.ProgramUnit(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", compilerOptions=" + this.getCompilerOptions() + ", identificationDivision=" + this.getIdentificationDivision() + ", environmentDivision=" + this.getEnvironmentDivision() + ", dataDivision=" + this.getDataDivision() + ", procedureDivision=" + this.getProcedureDivision() + ", programUnits=" + this.getProgramUnits() + ", endProgram=" + this.getEndProgram() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProgramUnit)) {
                return false;
            }
            ProgramUnit other = (ProgramUnit)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<CobolPreprocessor.CompilerOptions> this$compilerOptions = this.getCompilerOptions();
            List<CobolPreprocessor.CompilerOptions> other$compilerOptions = other.getCompilerOptions();
            if (this$compilerOptions == null ? other$compilerOptions != null : !((Object)this$compilerOptions).equals(other$compilerOptions)) {
                return false;
            }
            IdentificationDivision this$identificationDivision = this.getIdentificationDivision();
            IdentificationDivision other$identificationDivision = other.getIdentificationDivision();
            if (this$identificationDivision == null ? other$identificationDivision != null : !((Object)this$identificationDivision).equals(other$identificationDivision)) {
                return false;
            }
            EnvironmentDivision this$environmentDivision = this.getEnvironmentDivision();
            EnvironmentDivision other$environmentDivision = other.getEnvironmentDivision();
            if (this$environmentDivision == null ? other$environmentDivision != null : !((Object)this$environmentDivision).equals(other$environmentDivision)) {
                return false;
            }
            DataDivision this$dataDivision = this.getDataDivision();
            DataDivision other$dataDivision = other.getDataDivision();
            if (this$dataDivision == null ? other$dataDivision != null : !((Object)this$dataDivision).equals(other$dataDivision)) {
                return false;
            }
            ProcedureDivision this$procedureDivision = this.getProcedureDivision();
            ProcedureDivision other$procedureDivision = other.getProcedureDivision();
            if (this$procedureDivision == null ? other$procedureDivision != null : !((Object)this$procedureDivision).equals(other$procedureDivision)) {
                return false;
            }
            List<ProgramUnit> this$programUnits = this.getProgramUnits();
            List<ProgramUnit> other$programUnits = other.getProgramUnits();
            if (this$programUnits == null ? other$programUnits != null : !((Object)this$programUnits).equals(other$programUnits)) {
                return false;
            }
            EndProgram this$endProgram = this.getEndProgram();
            EndProgram other$endProgram = other.getEndProgram();
            return !(this$endProgram == null ? other$endProgram != null : !((Object)this$endProgram).equals(other$endProgram));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<CobolPreprocessor.CompilerOptions> $compilerOptions = this.getCompilerOptions();
            result = result * 59 + ($compilerOptions == null ? 43 : ((Object)$compilerOptions).hashCode());
            IdentificationDivision $identificationDivision = this.getIdentificationDivision();
            result = result * 59 + ($identificationDivision == null ? 43 : ((Object)$identificationDivision).hashCode());
            EnvironmentDivision $environmentDivision = this.getEnvironmentDivision();
            result = result * 59 + ($environmentDivision == null ? 43 : ((Object)$environmentDivision).hashCode());
            DataDivision $dataDivision = this.getDataDivision();
            result = result * 59 + ($dataDivision == null ? 43 : ((Object)$dataDivision).hashCode());
            ProcedureDivision $procedureDivision = this.getProcedureDivision();
            result = result * 59 + ($procedureDivision == null ? 43 : ((Object)$procedureDivision).hashCode());
            List<ProgramUnit> $programUnits = this.getProgramUnits();
            result = result * 59 + ($programUnits == null ? 43 : ((Object)$programUnits).hashCode());
            EndProgram $endProgram = this.getEndProgram();
            result = result * 59 + ($endProgram == null ? 43 : ((Object)$endProgram).hashCode());
            return result;
        }

        public ProgramUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProgramUnit(prefix, this.markers, this.compilerOptions, this.identificationDivision, this.environmentDivision, this.dataDivision, this.procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProgramUnit(this.prefix, markers, this.compilerOptions, this.identificationDivision, this.environmentDivision, this.dataDivision, this.procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withCompilerOptions(List<CobolPreprocessor.CompilerOptions> compilerOptions) {
            return this.compilerOptions == compilerOptions ? this : new ProgramUnit(this.prefix, this.markers, compilerOptions, this.identificationDivision, this.environmentDivision, this.dataDivision, this.procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withIdentificationDivision(IdentificationDivision identificationDivision) {
            return this.identificationDivision == identificationDivision ? this : new ProgramUnit(this.prefix, this.markers, this.compilerOptions, identificationDivision, this.environmentDivision, this.dataDivision, this.procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withEnvironmentDivision(EnvironmentDivision environmentDivision) {
            return this.environmentDivision == environmentDivision ? this : new ProgramUnit(this.prefix, this.markers, this.compilerOptions, this.identificationDivision, environmentDivision, this.dataDivision, this.procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withDataDivision(DataDivision dataDivision) {
            return this.dataDivision == dataDivision ? this : new ProgramUnit(this.prefix, this.markers, this.compilerOptions, this.identificationDivision, this.environmentDivision, dataDivision, this.procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withProcedureDivision(ProcedureDivision procedureDivision) {
            return this.procedureDivision == procedureDivision ? this : new ProgramUnit(this.prefix, this.markers, this.compilerOptions, this.identificationDivision, this.environmentDivision, this.dataDivision, procedureDivision, this.programUnits, this.endProgram);
        }

        public ProgramUnit withProgramUnits(List<ProgramUnit> programUnits) {
            return this.programUnits == programUnits ? this : new ProgramUnit(this.prefix, this.markers, this.compilerOptions, this.identificationDivision, this.environmentDivision, this.dataDivision, this.procedureDivision, programUnits, this.endProgram);
        }

        public ProgramUnit withEndProgram(EndProgram endProgram) {
            return this.endProgram == endProgram ? this : new ProgramUnit(this.prefix, this.markers, this.compilerOptions, this.identificationDivision, this.environmentDivision, this.dataDivision, this.procedureDivision, this.programUnits, endProgram);
        }
    }

    public static final class ProgramLibrarySection
    implements DataDivisionSection {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final List<Cobol> libraryDescriptionEntries;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProgramLibrarySection(this, p);
        }

        public ProgramLibrarySection(Space prefix, Markers markers, List<Word> words, List<Cobol> libraryDescriptionEntries) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.libraryDescriptionEntries = libraryDescriptionEntries;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Cobol> getLibraryDescriptionEntries() {
            return this.libraryDescriptionEntries;
        }

        public String toString() {
            return "Cobol.ProgramLibrarySection(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", libraryDescriptionEntries=" + this.getLibraryDescriptionEntries() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProgramLibrarySection)) {
                return false;
            }
            ProgramLibrarySection other = (ProgramLibrarySection)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Cobol> this$libraryDescriptionEntries = this.getLibraryDescriptionEntries();
            List<Cobol> other$libraryDescriptionEntries = other.getLibraryDescriptionEntries();
            return !(this$libraryDescriptionEntries == null ? other$libraryDescriptionEntries != null : !((Object)this$libraryDescriptionEntries).equals(other$libraryDescriptionEntries));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Cobol> $libraryDescriptionEntries = this.getLibraryDescriptionEntries();
            result = result * 59 + ($libraryDescriptionEntries == null ? 43 : ((Object)$libraryDescriptionEntries).hashCode());
            return result;
        }

        public ProgramLibrarySection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProgramLibrarySection(prefix, this.markers, this.words, this.libraryDescriptionEntries);
        }

        public ProgramLibrarySection withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProgramLibrarySection(this.prefix, markers, this.words, this.libraryDescriptionEntries);
        }

        public ProgramLibrarySection withWords(List<Word> words) {
            return this.words == words ? this : new ProgramLibrarySection(this.prefix, this.markers, words, this.libraryDescriptionEntries);
        }

        public ProgramLibrarySection withLibraryDescriptionEntries(List<Cobol> libraryDescriptionEntries) {
            return this.libraryDescriptionEntries == libraryDescriptionEntries ? this : new ProgramLibrarySection(this.prefix, this.markers, this.words, libraryDescriptionEntries);
        }
    }

    public static final class ProgramIdParagraph
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word programId;
        private final Word dot;
        private final Name programName;
        @Nullable
        private final List<Word> programAttributes;
        @Nullable
        private final Word dot2;
        @Nullable
        private final CommentEntry commentEntry;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProgramIdParagraph(this, p);
        }

        public ProgramIdParagraph(Space prefix, Markers markers, Word programId, Word dot, Name programName, List<Word> programAttributes, Word dot2, CommentEntry commentEntry) {
            this.prefix = prefix;
            this.markers = markers;
            this.programId = programId;
            this.dot = dot;
            this.programName = programName;
            this.programAttributes = programAttributes;
            this.dot2 = dot2;
            this.commentEntry = commentEntry;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getProgramId() {
            return this.programId;
        }

        public Word getDot() {
            return this.dot;
        }

        public Name getProgramName() {
            return this.programName;
        }

        public List<Word> getProgramAttributes() {
            return this.programAttributes;
        }

        public Word getDot2() {
            return this.dot2;
        }

        public CommentEntry getCommentEntry() {
            return this.commentEntry;
        }

        public String toString() {
            return "Cobol.ProgramIdParagraph(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", programId=" + this.getProgramId() + ", dot=" + this.getDot() + ", programName=" + this.getProgramName() + ", programAttributes=" + this.getProgramAttributes() + ", dot2=" + this.getDot2() + ", commentEntry=" + this.getCommentEntry() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProgramIdParagraph)) {
                return false;
            }
            ProgramIdParagraph other = (ProgramIdParagraph)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$programId = this.getProgramId();
            Word other$programId = other.getProgramId();
            if (this$programId == null ? other$programId != null : !((Object)this$programId).equals(other$programId)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            Name this$programName = this.getProgramName();
            Name other$programName = other.getProgramName();
            if (this$programName == null ? other$programName != null : !this$programName.equals(other$programName)) {
                return false;
            }
            List<Word> this$programAttributes = this.getProgramAttributes();
            List<Word> other$programAttributes = other.getProgramAttributes();
            if (this$programAttributes == null ? other$programAttributes != null : !((Object)this$programAttributes).equals(other$programAttributes)) {
                return false;
            }
            Word this$dot2 = this.getDot2();
            Word other$dot2 = other.getDot2();
            if (this$dot2 == null ? other$dot2 != null : !((Object)this$dot2).equals(other$dot2)) {
                return false;
            }
            CommentEntry this$commentEntry = this.getCommentEntry();
            CommentEntry other$commentEntry = other.getCommentEntry();
            return !(this$commentEntry == null ? other$commentEntry != null : !((Object)this$commentEntry).equals(other$commentEntry));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $programId = this.getProgramId();
            result = result * 59 + ($programId == null ? 43 : ((Object)$programId).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            Name $programName = this.getProgramName();
            result = result * 59 + ($programName == null ? 43 : $programName.hashCode());
            List<Word> $programAttributes = this.getProgramAttributes();
            result = result * 59 + ($programAttributes == null ? 43 : ((Object)$programAttributes).hashCode());
            Word $dot2 = this.getDot2();
            result = result * 59 + ($dot2 == null ? 43 : ((Object)$dot2).hashCode());
            CommentEntry $commentEntry = this.getCommentEntry();
            result = result * 59 + ($commentEntry == null ? 43 : ((Object)$commentEntry).hashCode());
            return result;
        }

        public ProgramIdParagraph withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProgramIdParagraph(prefix, this.markers, this.programId, this.dot, this.programName, this.programAttributes, this.dot2, this.commentEntry);
        }

        public ProgramIdParagraph withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProgramIdParagraph(this.prefix, markers, this.programId, this.dot, this.programName, this.programAttributes, this.dot2, this.commentEntry);
        }

        public ProgramIdParagraph withProgramId(Word programId) {
            return this.programId == programId ? this : new ProgramIdParagraph(this.prefix, this.markers, programId, this.dot, this.programName, this.programAttributes, this.dot2, this.commentEntry);
        }

        public ProgramIdParagraph withDot(Word dot) {
            return this.dot == dot ? this : new ProgramIdParagraph(this.prefix, this.markers, this.programId, dot, this.programName, this.programAttributes, this.dot2, this.commentEntry);
        }

        public ProgramIdParagraph withProgramName(Name programName) {
            return this.programName == programName ? this : new ProgramIdParagraph(this.prefix, this.markers, this.programId, this.dot, programName, this.programAttributes, this.dot2, this.commentEntry);
        }

        public ProgramIdParagraph withProgramAttributes(List<Word> programAttributes) {
            return this.programAttributes == programAttributes ? this : new ProgramIdParagraph(this.prefix, this.markers, this.programId, this.dot, this.programName, programAttributes, this.dot2, this.commentEntry);
        }

        public ProgramIdParagraph withDot2(Word dot2) {
            return this.dot2 == dot2 ? this : new ProgramIdParagraph(this.prefix, this.markers, this.programId, this.dot, this.programName, this.programAttributes, dot2, this.commentEntry);
        }

        public ProgramIdParagraph withCommentEntry(CommentEntry commentEntry) {
            return this.commentEntry == commentEntry ? this : new ProgramIdParagraph(this.prefix, this.markers, this.programId, this.dot, this.programName, this.programAttributes, this.dot2, commentEntry);
        }
    }

    public static final class ProcedureSectionHeader
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Name sectionName;
        private final Word section;
        private final Name identifier;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureSectionHeader(this, p);
        }

        public ProcedureSectionHeader(Space prefix, Markers markers, Name sectionName, Word section, Name identifier) {
            this.prefix = prefix;
            this.markers = markers;
            this.sectionName = sectionName;
            this.section = section;
            this.identifier = identifier;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getSectionName() {
            return this.sectionName;
        }

        public Word getSection() {
            return this.section;
        }

        public Name getIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return "Cobol.ProcedureSectionHeader(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sectionName=" + this.getSectionName() + ", section=" + this.getSection() + ", identifier=" + this.getIdentifier() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureSectionHeader)) {
                return false;
            }
            ProcedureSectionHeader other = (ProcedureSectionHeader)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$sectionName = this.getSectionName();
            Name other$sectionName = other.getSectionName();
            if (this$sectionName == null ? other$sectionName != null : !this$sectionName.equals(other$sectionName)) {
                return false;
            }
            Word this$section = this.getSection();
            Word other$section = other.getSection();
            if (this$section == null ? other$section != null : !((Object)this$section).equals(other$section)) {
                return false;
            }
            Name this$identifier = this.getIdentifier();
            Name other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $sectionName = this.getSectionName();
            result = result * 59 + ($sectionName == null ? 43 : $sectionName.hashCode());
            Word $section = this.getSection();
            result = result * 59 + ($section == null ? 43 : ((Object)$section).hashCode());
            Name $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public ProcedureSectionHeader withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureSectionHeader(prefix, this.markers, this.sectionName, this.section, this.identifier);
        }

        public ProcedureSectionHeader withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureSectionHeader(this.prefix, markers, this.sectionName, this.section, this.identifier);
        }

        public ProcedureSectionHeader withSectionName(Name sectionName) {
            return this.sectionName == sectionName ? this : new ProcedureSectionHeader(this.prefix, this.markers, sectionName, this.section, this.identifier);
        }

        public ProcedureSectionHeader withSection(Word section) {
            return this.section == section ? this : new ProcedureSectionHeader(this.prefix, this.markers, this.sectionName, section, this.identifier);
        }

        public ProcedureSectionHeader withIdentifier(Name identifier) {
            return this.identifier == identifier ? this : new ProcedureSectionHeader(this.prefix, this.markers, this.sectionName, this.section, identifier);
        }
    }

    public static final class ProcedureSection
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final ProcedureSectionHeader procedureSectionHeader;
        private final Word dot;
        private final Paragraphs paragraphs;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureSection(this, p);
        }

        public ProcedureSection(Space prefix, Markers markers, ProcedureSectionHeader procedureSectionHeader, Word dot, Paragraphs paragraphs) {
            this.prefix = prefix;
            this.markers = markers;
            this.procedureSectionHeader = procedureSectionHeader;
            this.dot = dot;
            this.paragraphs = paragraphs;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ProcedureSectionHeader getProcedureSectionHeader() {
            return this.procedureSectionHeader;
        }

        public Word getDot() {
            return this.dot;
        }

        public Paragraphs getParagraphs() {
            return this.paragraphs;
        }

        public String toString() {
            return "Cobol.ProcedureSection(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", procedureSectionHeader=" + this.getProcedureSectionHeader() + ", dot=" + this.getDot() + ", paragraphs=" + this.getParagraphs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureSection)) {
                return false;
            }
            ProcedureSection other = (ProcedureSection)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ProcedureSectionHeader this$procedureSectionHeader = this.getProcedureSectionHeader();
            ProcedureSectionHeader other$procedureSectionHeader = other.getProcedureSectionHeader();
            if (this$procedureSectionHeader == null ? other$procedureSectionHeader != null : !((Object)this$procedureSectionHeader).equals(other$procedureSectionHeader)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            Paragraphs this$paragraphs = this.getParagraphs();
            Paragraphs other$paragraphs = other.getParagraphs();
            return !(this$paragraphs == null ? other$paragraphs != null : !((Object)this$paragraphs).equals(other$paragraphs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ProcedureSectionHeader $procedureSectionHeader = this.getProcedureSectionHeader();
            result = result * 59 + ($procedureSectionHeader == null ? 43 : ((Object)$procedureSectionHeader).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            Paragraphs $paragraphs = this.getParagraphs();
            result = result * 59 + ($paragraphs == null ? 43 : ((Object)$paragraphs).hashCode());
            return result;
        }

        public ProcedureSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureSection(prefix, this.markers, this.procedureSectionHeader, this.dot, this.paragraphs);
        }

        public ProcedureSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureSection(this.prefix, markers, this.procedureSectionHeader, this.dot, this.paragraphs);
        }

        public ProcedureSection withProcedureSectionHeader(ProcedureSectionHeader procedureSectionHeader) {
            return this.procedureSectionHeader == procedureSectionHeader ? this : new ProcedureSection(this.prefix, this.markers, procedureSectionHeader, this.dot, this.paragraphs);
        }

        public ProcedureSection withDot(Word dot) {
            return this.dot == dot ? this : new ProcedureSection(this.prefix, this.markers, this.procedureSectionHeader, dot, this.paragraphs);
        }

        public ProcedureSection withParagraphs(Paragraphs paragraphs) {
            return this.paragraphs == paragraphs ? this : new ProcedureSection(this.prefix, this.markers, this.procedureSectionHeader, this.dot, paragraphs);
        }
    }

    public static final class ProcedureName
    implements Cobol,
    Name {
        private final Space prefix;
        private final Markers markers;
        private final Name paragraphName;
        @Nullable
        private final InSection inSection;
        @Nullable
        private final Name sectionName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureName(this, p);
        }

        public ProcedureName(Space prefix, Markers markers, Name paragraphName, InSection inSection, Name sectionName) {
            this.prefix = prefix;
            this.markers = markers;
            this.paragraphName = paragraphName;
            this.inSection = inSection;
            this.sectionName = sectionName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getParagraphName() {
            return this.paragraphName;
        }

        public InSection getInSection() {
            return this.inSection;
        }

        public Name getSectionName() {
            return this.sectionName;
        }

        public String toString() {
            return "Cobol.ProcedureName(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", paragraphName=" + this.getParagraphName() + ", inSection=" + this.getInSection() + ", sectionName=" + this.getSectionName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureName)) {
                return false;
            }
            ProcedureName other = (ProcedureName)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Name this$paragraphName = this.getParagraphName();
            Name other$paragraphName = other.getParagraphName();
            if (this$paragraphName == null ? other$paragraphName != null : !this$paragraphName.equals(other$paragraphName)) {
                return false;
            }
            InSection this$inSection = this.getInSection();
            InSection other$inSection = other.getInSection();
            if (this$inSection == null ? other$inSection != null : !((Object)this$inSection).equals(other$inSection)) {
                return false;
            }
            Name this$sectionName = this.getSectionName();
            Name other$sectionName = other.getSectionName();
            return !(this$sectionName == null ? other$sectionName != null : !this$sectionName.equals(other$sectionName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Name $paragraphName = this.getParagraphName();
            result = result * 59 + ($paragraphName == null ? 43 : $paragraphName.hashCode());
            InSection $inSection = this.getInSection();
            result = result * 59 + ($inSection == null ? 43 : ((Object)$inSection).hashCode());
            Name $sectionName = this.getSectionName();
            result = result * 59 + ($sectionName == null ? 43 : $sectionName.hashCode());
            return result;
        }

        public ProcedureName withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureName(prefix, this.markers, this.paragraphName, this.inSection, this.sectionName);
        }

        public ProcedureName withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureName(this.prefix, markers, this.paragraphName, this.inSection, this.sectionName);
        }

        public ProcedureName withParagraphName(Name paragraphName) {
            return this.paragraphName == paragraphName ? this : new ProcedureName(this.prefix, this.markers, paragraphName, this.inSection, this.sectionName);
        }

        public ProcedureName withInSection(InSection inSection) {
            return this.inSection == inSection ? this : new ProcedureName(this.prefix, this.markers, this.paragraphName, inSection, this.sectionName);
        }

        public ProcedureName withSectionName(Name sectionName) {
            return this.sectionName == sectionName ? this : new ProcedureName(this.prefix, this.markers, this.paragraphName, this.inSection, sectionName);
        }
    }

    public static final class ProcedureDivisionUsingClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final List<Cobol> procedureDivisionUsingParameter;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivisionUsingClause(this, p);
        }

        public ProcedureDivisionUsingClause(Space prefix, Markers markers, Word word, List<Cobol> procedureDivisionUsingParameter) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.procedureDivisionUsingParameter = procedureDivisionUsingParameter;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public List<Cobol> getProcedureDivisionUsingParameter() {
            return this.procedureDivisionUsingParameter;
        }

        public String toString() {
            return "Cobol.ProcedureDivisionUsingClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", procedureDivisionUsingParameter=" + this.getProcedureDivisionUsingParameter() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivisionUsingClause)) {
                return false;
            }
            ProcedureDivisionUsingClause other = (ProcedureDivisionUsingClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            List<Cobol> this$procedureDivisionUsingParameter = this.getProcedureDivisionUsingParameter();
            List<Cobol> other$procedureDivisionUsingParameter = other.getProcedureDivisionUsingParameter();
            return !(this$procedureDivisionUsingParameter == null ? other$procedureDivisionUsingParameter != null : !((Object)this$procedureDivisionUsingParameter).equals(other$procedureDivisionUsingParameter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            List<Cobol> $procedureDivisionUsingParameter = this.getProcedureDivisionUsingParameter();
            result = result * 59 + ($procedureDivisionUsingParameter == null ? 43 : ((Object)$procedureDivisionUsingParameter).hashCode());
            return result;
        }

        public ProcedureDivisionUsingClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivisionUsingClause(prefix, this.markers, this.word, this.procedureDivisionUsingParameter);
        }

        public ProcedureDivisionUsingClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivisionUsingClause(this.prefix, markers, this.word, this.procedureDivisionUsingParameter);
        }

        public ProcedureDivisionUsingClause withWord(Word word) {
            return this.word == word ? this : new ProcedureDivisionUsingClause(this.prefix, this.markers, word, this.procedureDivisionUsingParameter);
        }

        public ProcedureDivisionUsingClause withProcedureDivisionUsingParameter(List<Cobol> procedureDivisionUsingParameter) {
            return this.procedureDivisionUsingParameter == procedureDivisionUsingParameter ? this : new ProcedureDivisionUsingClause(this.prefix, this.markers, this.word, procedureDivisionUsingParameter);
        }
    }

    public static final class ProcedureDivisionGivingClause
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word word;
        private final Name dataName;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivisionGivingClause(this, p);
        }

        public ProcedureDivisionGivingClause(Space prefix, Markers markers, Word word, Name dataName) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.dataName = dataName;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getDataName() {
            return this.dataName;
        }

        public String toString() {
            return "Cobol.ProcedureDivisionGivingClause(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", dataName=" + this.getDataName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivisionGivingClause)) {
                return false;
            }
            ProcedureDivisionGivingClause other = (ProcedureDivisionGivingClause)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$dataName = this.getDataName();
            Name other$dataName = other.getDataName();
            return !(this$dataName == null ? other$dataName != null : !this$dataName.equals(other$dataName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $dataName = this.getDataName();
            result = result * 59 + ($dataName == null ? 43 : $dataName.hashCode());
            return result;
        }

        public ProcedureDivisionGivingClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivisionGivingClause(prefix, this.markers, this.word, this.dataName);
        }

        public ProcedureDivisionGivingClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivisionGivingClause(this.prefix, markers, this.word, this.dataName);
        }

        public ProcedureDivisionGivingClause withWord(Word word) {
            return this.word == word ? this : new ProcedureDivisionGivingClause(this.prefix, this.markers, word, this.dataName);
        }

        public ProcedureDivisionGivingClause withDataName(Name dataName) {
            return this.dataName == dataName ? this : new ProcedureDivisionGivingClause(this.prefix, this.markers, this.word, dataName);
        }
    }

    public static final class ProcedureDivisionByValuePhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        private final List<Name> phrases;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivisionByValuePhrase(this, p);
        }

        public ProcedureDivisionByValuePhrase(Space prefix, Markers markers, List<Word> words, List<Name> phrases) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.phrases = phrases;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<Name> getPhrases() {
            return this.phrases;
        }

        public String toString() {
            return "Cobol.ProcedureDivisionByValuePhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", phrases=" + this.getPhrases() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivisionByValuePhrase)) {
                return false;
            }
            ProcedureDivisionByValuePhrase other = (ProcedureDivisionByValuePhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<Name> this$phrases = this.getPhrases();
            List<Name> other$phrases = other.getPhrases();
            return !(this$phrases == null ? other$phrases != null : !((Object)this$phrases).equals(other$phrases));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<Name> $phrases = this.getPhrases();
            result = result * 59 + ($phrases == null ? 43 : ((Object)$phrases).hashCode());
            return result;
        }

        public ProcedureDivisionByValuePhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivisionByValuePhrase(prefix, this.markers, this.words, this.phrases);
        }

        public ProcedureDivisionByValuePhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivisionByValuePhrase(this.prefix, markers, this.words, this.phrases);
        }

        public ProcedureDivisionByValuePhrase withWords(List<Word> words) {
            return this.words == words ? this : new ProcedureDivisionByValuePhrase(this.prefix, this.markers, words, this.phrases);
        }

        public ProcedureDivisionByValuePhrase withPhrases(List<Name> phrases) {
            return this.phrases == phrases ? this : new ProcedureDivisionByValuePhrase(this.prefix, this.markers, this.words, phrases);
        }
    }

    public static final class ProcedureDivisionByReferencePhrase
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final List<Word> words;
        private final List<ProcedureDivisionByReference> procedureDivisionByReference;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivisionByReferencePhrase(this, p);
        }

        public ProcedureDivisionByReferencePhrase(Space prefix, Markers markers, List<Word> words, List<ProcedureDivisionByReference> procedureDivisionByReference) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.procedureDivisionByReference = procedureDivisionByReference;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public List<ProcedureDivisionByReference> getProcedureDivisionByReference() {
            return this.procedureDivisionByReference;
        }

        public String toString() {
            return "Cobol.ProcedureDivisionByReferencePhrase(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", procedureDivisionByReference=" + this.getProcedureDivisionByReference() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivisionByReferencePhrase)) {
                return false;
            }
            ProcedureDivisionByReferencePhrase other = (ProcedureDivisionByReferencePhrase)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            List<ProcedureDivisionByReference> this$procedureDivisionByReference = this.getProcedureDivisionByReference();
            List<ProcedureDivisionByReference> other$procedureDivisionByReference = other.getProcedureDivisionByReference();
            return !(this$procedureDivisionByReference == null ? other$procedureDivisionByReference != null : !((Object)this$procedureDivisionByReference).equals(other$procedureDivisionByReference));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            List<ProcedureDivisionByReference> $procedureDivisionByReference = this.getProcedureDivisionByReference();
            result = result * 59 + ($procedureDivisionByReference == null ? 43 : ((Object)$procedureDivisionByReference).hashCode());
            return result;
        }

        public ProcedureDivisionByReferencePhrase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivisionByReferencePhrase(prefix, this.markers, this.words, this.procedureDivisionByReference);
        }

        public ProcedureDivisionByReferencePhrase withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivisionByReferencePhrase(this.prefix, markers, this.words, this.procedureDivisionByReference);
        }

        public ProcedureDivisionByReferencePhrase withWords(List<Word> words) {
            return this.words == words ? this : new ProcedureDivisionByReferencePhrase(this.prefix, this.markers, words, this.procedureDivisionByReference);
        }

        public ProcedureDivisionByReferencePhrase withProcedureDivisionByReference(List<ProcedureDivisionByReference> procedureDivisionByReference) {
            return this.procedureDivisionByReference == procedureDivisionByReference ? this : new ProcedureDivisionByReferencePhrase(this.prefix, this.markers, this.words, procedureDivisionByReference);
        }
    }

    public static final class ProcedureDivisionByReference
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Word word;
        private final Name reference;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivisionByReference(this, p);
        }

        public ProcedureDivisionByReference(Space prefix, Markers markers, Word word, Name reference) {
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.reference = reference;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public Name getReference() {
            return this.reference;
        }

        public String toString() {
            return "Cobol.ProcedureDivisionByReference(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", reference=" + this.getReference() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivisionByReference)) {
                return false;
            }
            ProcedureDivisionByReference other = (ProcedureDivisionByReference)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$word = this.getWord();
            Word other$word = other.getWord();
            if (this$word == null ? other$word != null : !((Object)this$word).equals(other$word)) {
                return false;
            }
            Name this$reference = this.getReference();
            Name other$reference = other.getReference();
            return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $word = this.getWord();
            result = result * 59 + ($word == null ? 43 : ((Object)$word).hashCode());
            Name $reference = this.getReference();
            result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
            return result;
        }

        public ProcedureDivisionByReference withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivisionByReference(prefix, this.markers, this.word, this.reference);
        }

        public ProcedureDivisionByReference withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivisionByReference(this.prefix, markers, this.word, this.reference);
        }

        public ProcedureDivisionByReference withWord(Word word) {
            return this.word == word ? this : new ProcedureDivisionByReference(this.prefix, this.markers, word, this.reference);
        }

        public ProcedureDivisionByReference withReference(Name reference) {
            return this.reference == reference ? this : new ProcedureDivisionByReference(this.prefix, this.markers, this.word, reference);
        }
    }

    public static final class ProcedureDivisionBody
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Paragraphs paragraphs;
        @Nullable
        private final List<ProcedureSection> procedureSection;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivisionBody(this, p);
        }

        public ProcedureDivisionBody(Space prefix, Markers markers, Paragraphs paragraphs, List<ProcedureSection> procedureSection) {
            this.prefix = prefix;
            this.markers = markers;
            this.paragraphs = paragraphs;
            this.procedureSection = procedureSection;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Paragraphs getParagraphs() {
            return this.paragraphs;
        }

        public List<ProcedureSection> getProcedureSection() {
            return this.procedureSection;
        }

        public String toString() {
            return "Cobol.ProcedureDivisionBody(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", paragraphs=" + this.getParagraphs() + ", procedureSection=" + this.getProcedureSection() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivisionBody)) {
                return false;
            }
            ProcedureDivisionBody other = (ProcedureDivisionBody)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Paragraphs this$paragraphs = this.getParagraphs();
            Paragraphs other$paragraphs = other.getParagraphs();
            if (this$paragraphs == null ? other$paragraphs != null : !((Object)this$paragraphs).equals(other$paragraphs)) {
                return false;
            }
            List<ProcedureSection> this$procedureSection = this.getProcedureSection();
            List<ProcedureSection> other$procedureSection = other.getProcedureSection();
            return !(this$procedureSection == null ? other$procedureSection != null : !((Object)this$procedureSection).equals(other$procedureSection));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Paragraphs $paragraphs = this.getParagraphs();
            result = result * 59 + ($paragraphs == null ? 43 : ((Object)$paragraphs).hashCode());
            List<ProcedureSection> $procedureSection = this.getProcedureSection();
            result = result * 59 + ($procedureSection == null ? 43 : ((Object)$procedureSection).hashCode());
            return result;
        }

        public ProcedureDivisionBody withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivisionBody(prefix, this.markers, this.paragraphs, this.procedureSection);
        }

        public ProcedureDivisionBody withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivisionBody(this.prefix, markers, this.paragraphs, this.procedureSection);
        }

        public ProcedureDivisionBody withParagraphs(Paragraphs paragraphs) {
            return this.paragraphs == paragraphs ? this : new ProcedureDivisionBody(this.prefix, this.markers, paragraphs, this.procedureSection);
        }

        public ProcedureDivisionBody withProcedureSection(List<ProcedureSection> procedureSection) {
            return this.procedureSection == procedureSection ? this : new ProcedureDivisionBody(this.prefix, this.markers, this.paragraphs, procedureSection);
        }
    }

    public static final class ProcedureDivision
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final List<Word> words;
        @Nullable
        private final ProcedureDivisionUsingClause procedureDivisionUsingClause;
        @Nullable
        private final ProcedureDivisionGivingClause procedureDivisionGivingClause;
        private final Word dot;
        @Nullable
        private final ProcedureDeclaratives procedureDeclaratives;
        private final ProcedureDivisionBody body;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDivision(this, p);
        }

        public ProcedureDivision(Space prefix, Markers markers, List<Word> words, ProcedureDivisionUsingClause procedureDivisionUsingClause, ProcedureDivisionGivingClause procedureDivisionGivingClause, Word dot, ProcedureDeclaratives procedureDeclaratives, ProcedureDivisionBody body) {
            this.prefix = prefix;
            this.markers = markers;
            this.words = words;
            this.procedureDivisionUsingClause = procedureDivisionUsingClause;
            this.procedureDivisionGivingClause = procedureDivisionGivingClause;
            this.dot = dot;
            this.procedureDeclaratives = procedureDeclaratives;
            this.body = body;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public ProcedureDivisionUsingClause getProcedureDivisionUsingClause() {
            return this.procedureDivisionUsingClause;
        }

        public ProcedureDivisionGivingClause getProcedureDivisionGivingClause() {
            return this.procedureDivisionGivingClause;
        }

        public Word getDot() {
            return this.dot;
        }

        public ProcedureDeclaratives getProcedureDeclaratives() {
            return this.procedureDeclaratives;
        }

        public ProcedureDivisionBody getBody() {
            return this.body;
        }

        public String toString() {
            return "Cobol.ProcedureDivision(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", words=" + this.getWords() + ", procedureDivisionUsingClause=" + this.getProcedureDivisionUsingClause() + ", procedureDivisionGivingClause=" + this.getProcedureDivisionGivingClause() + ", dot=" + this.getDot() + ", procedureDeclaratives=" + this.getProcedureDeclaratives() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDivision)) {
                return false;
            }
            ProcedureDivision other = (ProcedureDivision)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Word> this$words = this.getWords();
            List<Word> other$words = other.getWords();
            if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
                return false;
            }
            ProcedureDivisionUsingClause this$procedureDivisionUsingClause = this.getProcedureDivisionUsingClause();
            ProcedureDivisionUsingClause other$procedureDivisionUsingClause = other.getProcedureDivisionUsingClause();
            if (this$procedureDivisionUsingClause == null ? other$procedureDivisionUsingClause != null : !((Object)this$procedureDivisionUsingClause).equals(other$procedureDivisionUsingClause)) {
                return false;
            }
            ProcedureDivisionGivingClause this$procedureDivisionGivingClause = this.getProcedureDivisionGivingClause();
            ProcedureDivisionGivingClause other$procedureDivisionGivingClause = other.getProcedureDivisionGivingClause();
            if (this$procedureDivisionGivingClause == null ? other$procedureDivisionGivingClause != null : !((Object)this$procedureDivisionGivingClause).equals(other$procedureDivisionGivingClause)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            ProcedureDeclaratives this$procedureDeclaratives = this.getProcedureDeclaratives();
            ProcedureDeclaratives other$procedureDeclaratives = other.getProcedureDeclaratives();
            if (this$procedureDeclaratives == null ? other$procedureDeclaratives != null : !((Object)this$procedureDeclaratives).equals(other$procedureDeclaratives)) {
                return false;
            }
            ProcedureDivisionBody this$body = this.getBody();
            ProcedureDivisionBody other$body = other.getBody();
            return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Word> $words = this.getWords();
            result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
            ProcedureDivisionUsingClause $procedureDivisionUsingClause = this.getProcedureDivisionUsingClause();
            result = result * 59 + ($procedureDivisionUsingClause == null ? 43 : ((Object)$procedureDivisionUsingClause).hashCode());
            ProcedureDivisionGivingClause $procedureDivisionGivingClause = this.getProcedureDivisionGivingClause();
            result = result * 59 + ($procedureDivisionGivingClause == null ? 43 : ((Object)$procedureDivisionGivingClause).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            ProcedureDeclaratives $procedureDeclaratives = this.getProcedureDeclaratives();
            result = result * 59 + ($procedureDeclaratives == null ? 43 : ((Object)$procedureDeclaratives).hashCode());
            ProcedureDivisionBody $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
            return result;
        }

        public ProcedureDivision withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDivision(prefix, this.markers, this.words, this.procedureDivisionUsingClause, this.procedureDivisionGivingClause, this.dot, this.procedureDeclaratives, this.body);
        }

        public ProcedureDivision withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDivision(this.prefix, markers, this.words, this.procedureDivisionUsingClause, this.procedureDivisionGivingClause, this.dot, this.procedureDeclaratives, this.body);
        }

        public ProcedureDivision withWords(List<Word> words) {
            return this.words == words ? this : new ProcedureDivision(this.prefix, this.markers, words, this.procedureDivisionUsingClause, this.procedureDivisionGivingClause, this.dot, this.procedureDeclaratives, this.body);
        }

        public ProcedureDivision withProcedureDivisionUsingClause(ProcedureDivisionUsingClause procedureDivisionUsingClause) {
            return this.procedureDivisionUsingClause == procedureDivisionUsingClause ? this : new ProcedureDivision(this.prefix, this.markers, this.words, procedureDivisionUsingClause, this.procedureDivisionGivingClause, this.dot, this.procedureDeclaratives, this.body);
        }

        public ProcedureDivision withProcedureDivisionGivingClause(ProcedureDivisionGivingClause procedureDivisionGivingClause) {
            return this.procedureDivisionGivingClause == procedureDivisionGivingClause ? this : new ProcedureDivision(this.prefix, this.markers, this.words, this.procedureDivisionUsingClause, procedureDivisionGivingClause, this.dot, this.procedureDeclaratives, this.body);
        }

        public ProcedureDivision withDot(Word dot) {
            return this.dot == dot ? this : new ProcedureDivision(this.prefix, this.markers, this.words, this.procedureDivisionUsingClause, this.procedureDivisionGivingClause, dot, this.procedureDeclaratives, this.body);
        }

        public ProcedureDivision withProcedureDeclaratives(ProcedureDeclaratives procedureDeclaratives) {
            return this.procedureDeclaratives == procedureDeclaratives ? this : new ProcedureDivision(this.prefix, this.markers, this.words, this.procedureDivisionUsingClause, this.procedureDivisionGivingClause, this.dot, procedureDeclaratives, this.body);
        }

        public ProcedureDivision withBody(ProcedureDivisionBody body) {
            return this.body == body ? this : new ProcedureDivision(this.prefix, this.markers, this.words, this.procedureDivisionUsingClause, this.procedureDivisionGivingClause, this.dot, this.procedureDeclaratives, body);
        }
    }

    public static final class ProcedureDeclaratives
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final Word declaratives;
        private final Word dot;
        private final List<ProcedureDeclarative> procedureDeclarative;
        private final List<Word> endDeclaratives;
        private final Word dot2;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDeclaratives(this, p);
        }

        public ProcedureDeclaratives(Space prefix, Markers markers, Word declaratives, Word dot, List<ProcedureDeclarative> procedureDeclarative, List<Word> endDeclaratives, Word dot2) {
            this.prefix = prefix;
            this.markers = markers;
            this.declaratives = declaratives;
            this.dot = dot;
            this.procedureDeclarative = procedureDeclarative;
            this.endDeclaratives = endDeclaratives;
            this.dot2 = dot2;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getDeclaratives() {
            return this.declaratives;
        }

        public Word getDot() {
            return this.dot;
        }

        public List<ProcedureDeclarative> getProcedureDeclarative() {
            return this.procedureDeclarative;
        }

        public List<Word> getEndDeclaratives() {
            return this.endDeclaratives;
        }

        public Word getDot2() {
            return this.dot2;
        }

        public String toString() {
            return "Cobol.ProcedureDeclaratives(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", declaratives=" + this.getDeclaratives() + ", dot=" + this.getDot() + ", procedureDeclarative=" + this.getProcedureDeclarative() + ", endDeclaratives=" + this.getEndDeclaratives() + ", dot2=" + this.getDot2() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDeclaratives)) {
                return false;
            }
            ProcedureDeclaratives other = (ProcedureDeclaratives)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Word this$declaratives = this.getDeclaratives();
            Word other$declaratives = other.getDeclaratives();
            if (this$declaratives == null ? other$declaratives != null : !((Object)this$declaratives).equals(other$declaratives)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            List<ProcedureDeclarative> this$procedureDeclarative = this.getProcedureDeclarative();
            List<ProcedureDeclarative> other$procedureDeclarative = other.getProcedureDeclarative();
            if (this$procedureDeclarative == null ? other$procedureDeclarative != null : !((Object)this$procedureDeclarative).equals(other$procedureDeclarative)) {
                return false;
            }
            List<Word> this$endDeclaratives = this.getEndDeclaratives();
            List<Word> other$endDeclaratives = other.getEndDeclaratives();
            if (this$endDeclaratives == null ? other$endDeclaratives != null : !((Object)this$endDeclaratives).equals(other$endDeclaratives)) {
                return false;
            }
            Word this$dot2 = this.getDot2();
            Word other$dot2 = other.getDot2();
            return !(this$dot2 == null ? other$dot2 != null : !((Object)this$dot2).equals(other$dot2));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Word $declaratives = this.getDeclaratives();
            result = result * 59 + ($declaratives == null ? 43 : ((Object)$declaratives).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            List<ProcedureDeclarative> $procedureDeclarative = this.getProcedureDeclarative();
            result = result * 59 + ($procedureDeclarative == null ? 43 : ((Object)$procedureDeclarative).hashCode());
            List<Word> $endDeclaratives = this.getEndDeclaratives();
            result = result * 59 + ($endDeclaratives == null ? 43 : ((Object)$endDeclaratives).hashCode());
            Word $dot2 = this.getDot2();
            result = result * 59 + ($dot2 == null ? 43 : ((Object)$dot2).hashCode());
            return result;
        }

        public ProcedureDeclaratives withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDeclaratives(prefix, this.markers, this.declaratives, this.dot, this.procedureDeclarative, this.endDeclaratives, this.dot2);
        }

        public ProcedureDeclaratives withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDeclaratives(this.prefix, markers, this.declaratives, this.dot, this.procedureDeclarative, this.endDeclaratives, this.dot2);
        }

        public ProcedureDeclaratives withDeclaratives(Word declaratives) {
            return this.declaratives == declaratives ? this : new ProcedureDeclaratives(this.prefix, this.markers, declaratives, this.dot, this.procedureDeclarative, this.endDeclaratives, this.dot2);
        }

        public ProcedureDeclaratives withDot(Word dot) {
            return this.dot == dot ? this : new ProcedureDeclaratives(this.prefix, this.markers, this.declaratives, dot, this.procedureDeclarative, this.endDeclaratives, this.dot2);
        }

        public ProcedureDeclaratives withProcedureDeclarative(List<ProcedureDeclarative> procedureDeclarative) {
            return this.procedureDeclarative == procedureDeclarative ? this : new ProcedureDeclaratives(this.prefix, this.markers, this.declaratives, this.dot, procedureDeclarative, this.endDeclaratives, this.dot2);
        }

        public ProcedureDeclaratives withEndDeclaratives(List<Word> endDeclaratives) {
            return this.endDeclaratives == endDeclaratives ? this : new ProcedureDeclaratives(this.prefix, this.markers, this.declaratives, this.dot, this.procedureDeclarative, endDeclaratives, this.dot2);
        }

        public ProcedureDeclaratives withDot2(Word dot2) {
            return this.dot2 == dot2 ? this : new ProcedureDeclaratives(this.prefix, this.markers, this.declaratives, this.dot, this.procedureDeclarative, this.endDeclaratives, dot2);
        }
    }

    public static final class ProcedureDeclarative
    implements Cobol {
        private final Space prefix;
        private final Markers markers;
        private final ProcedureSectionHeader procedureSectionHeader;
        private final Word dot;
        private final UseStatement useStatement;
        private final Word dot2;
        private final Paragraphs paragraphs;

        @Override
        public <P> Cobol acceptCobol(CobolVisitor<P> v, P p) {
            return v.visitProcedureDeclarative(this, p);
        }

        public ProcedureDeclarative(Space prefix, Markers markers, ProcedureSectionHeader procedureSectionHeader, Word dot, UseStatement useStatement, Word dot2, Paragraphs paragraphs) {
            this.prefix = prefix;
            this.markers = markers;
            this.procedureSectionHeader = procedureSectionHeader;
            this.dot = dot;
            this.useStatement = useStatement;
            this.dot2 = dot2;
            this.paragraphs = paragraphs;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ProcedureSectionHeader getProcedureSectionHeader() {
            return this.procedureSectionHeader;
        }

        public Word getDot() {
            return this.dot;
        }

        public UseStatement getUseStatement() {
            return this.useStatement;
        }

        public Word getDot2() {
            return this.dot2;
        }

        public Paragraphs getParagraphs() {
            return this.paragraphs;
        }

        public String toString() {
            return "Cobol.ProcedureDeclarative(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", procedureSectionHeader=" + this.getProcedureSectionHeader() + ", dot=" + this.getDot() + ", useStatement=" + this.getUseStatement() + ", dot2=" + this.getDot2() + ", paragraphs=" + this.getParagraphs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcedureDeclarative)) {
                return false;
            }
            ProcedureDeclarative other = (ProcedureDeclarative)o;
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            ProcedureSectionHeader this$procedureSectionHeader = this.getProcedureSectionHeader();
            ProcedureSectionHeader other$procedureSectionHeader = other.getProcedureSectionHeader();
            if (this$procedureSectionHeader == null ? other$procedureSectionHeader != null : !((Object)this$procedureSectionHeader).equals(other$procedureSectionHeader)) {
                return false;
            }
            Word this$dot = this.getDot();
            Word other$dot = other.getDot();
            if (this$dot == null ? other$dot != null : !((Object)this$dot).equals(other$dot)) {
                return false;
            }
            UseStatement this$useStatement = this.getUseStatement();
            UseStatement other$useStatement = other.getUseStatement();
            if (this$useStatement == null ? other$useStatement != null : !((Object)this$useStatement).equals(other$useStatement)) {
                return false;
            }
            Word this$dot2 = this.getDot2();
            Word other$dot2 = other.getDot2();
            if (this$dot2 == null ? other$dot2 != null : !((Object)this$dot2).equals(other$dot2)) {
                return false;
            }
            Paragraphs this$paragraphs = this.getParagraphs();
            Paragraphs other$paragraphs = other.getParagraphs();
            return !(this$paragraphs == null ? other$paragraphs != null : !((Object)this$paragraphs).equals(other$paragraphs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            ProcedureSectionHeader $procedureSectionHeader = this.getProcedureSectionHeader();
            result = result * 59 + ($procedureSectionHeader == null ? 43 : ((Object)$procedureSectionHeader).hashCode());
            Word $dot = this.getDot();
            result = result * 59 + ($dot == null ? 43 : ((Object)$dot).hashCode());
            UseStatement $useStatement = this.getUseStatement();
            result = result * 59 + ($useStatement == null ? 43 : ((Object)$useStatement).hashCode());
            Word $dot2 = this.getDot2();
            result = result * 59 + ($dot2 == null ? 43 : ((Object)$dot2).hashCode());
            Paragraphs $paragraphs = this.getParagraphs();
            result = result * 59 + ($paragraphs == null ? 43 : ((Object)$paragraphs).hashCode());
            return result;
        }

        public ProcedureDeclarative withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcedureDeclarative(prefix, this.markers, this.procedureSectionHeader, this.dot, this.useStatement, this.dot2, this.paragraphs);
        }

        public ProcedureDeclarative withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcedureDeclarative(this.prefix, markers, this.procedureSectionHeader, this.dot, this.useStatement, this.dot2, this.paragraphs);
        }

        public ProcedureDeclarative withProcedureSectionHeader(ProcedureSectionHeader procedureSectionHeader) {
            return this.procedureSectionHeader == procedureSectionHeader ? this : new ProcedureDeclarative(this.prefix, this.markers, procedureSectionHeader, this.dot, this.useStatement, this.dot2, this.paragraphs);
        }

        public ProcedureDeclarative withDot(Word dot) {
            return this.dot == dot ? this : new ProcedureDeclarative(this.prefix, this.markers, this.procedureSectionHeader, dot, this.useStatement, this.dot2, this.paragraphs);
        }

        public ProcedureDeclarative withUseStatement(UseStatement useStatement) {
            return this.useStatement == useStatement ? this : new ProcedureDeclarative(this.prefix, this.markers, this.procedureSectionHeader, this.dot, useStatement, this.dot2, this.paragraphs);
        }

        p