/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolLeftPadded;
import org.openrewrite.cobol.tree.CobolRightPadded;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public class CobolContainer<T> {
    private transient Padding<T> padding;
    private static final CobolContainer<?> EMPTY = new CobolContainer(Space.EMPTY, null, Collections.emptyList(), Markers.EMPTY);
    private final Space before;
    @Nullable
    private final CobolLeftPadded<String> preposition;
    private final List<CobolRightPadded<T>> elements;
    private final Markers markers;

    private CobolContainer(Space before, @Nullable CobolLeftPadded<String> preposition, List<CobolRightPadded<T>> elements, Markers markers) {
        this.before = before;
        this.preposition = preposition;
        this.elements = elements;
        this.markers = markers;
    }

    public static <T> CobolContainer<T> build(List<CobolRightPadded<T>> elements) {
        return CobolContainer.build(Space.EMPTY, null, elements, Markers.EMPTY);
    }

    @JsonCreator
    public static <T> CobolContainer<T> build(Space before, @Nullable CobolLeftPadded<String> preposition, List<CobolRightPadded<T>> elements, Markers markers) {
        if (before.isEmpty() && elements.isEmpty()) {
            return CobolContainer.empty();
        }
        return new CobolContainer<T>(before, preposition, elements, markers);
    }

    public static <T> CobolContainer<T> empty() {
        return EMPTY;
    }

    public CobolContainer<T> withPreposition(@Nullable CobolLeftPadded<String> preposition) {
        return this.preposition == preposition ? this : CobolContainer.build(this.before, preposition, this.elements, this.markers);
    }

    public CobolContainer<T> withBefore(Space before) {
        return this.before == before ? this : CobolContainer.build(before, this.preposition, this.elements, this.markers);
    }

    public CobolContainer<T> withElements(List<CobolRightPadded<T>> elements) {
        return this.elements == elements ? this : CobolContainer.build(this.before, this.preposition, elements, this.markers);
    }

    public CobolContainer<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : CobolContainer.build(this.before, this.preposition, this.elements, markers);
    }

    @Nullable
    public CobolLeftPadded<String> getPreposition() {
        return this.preposition;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public List<T> getElements() {
        return CobolRightPadded.getElements(this.elements);
    }

    public Space getBefore() {
        return this.before;
    }

    public CobolContainer<T> map(UnaryOperator<T> map) {
        return this.getPadding().withElements(ListUtils.map(this.elements, t -> t.map(map)));
    }

    public Space getLastSpace() {
        return this.elements.isEmpty() ? Space.EMPTY : this.elements.get(this.elements.size() - 1).getAfter();
    }

    public CobolContainer<T> withLastSpace(Space after) {
        return this.withElements(ListUtils.mapLast(this.elements, elem -> elem.withAfter(after)));
    }

    public Padding<T> getPadding() {
        if (this.padding == null) {
            this.padding = new Padding(this);
        }
        return this.padding;
    }

    @Nullable
    public static <P extends Cobol> CobolContainer<P> withElementsNullable(@Nullable CobolContainer<P> before, @Nullable List<P> elements) {
        if (before == null) {
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            return CobolContainer.build(Space.EMPTY, null, CobolRightPadded.withElements(Collections.emptyList(), elements), Markers.EMPTY);
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return before.getPadding().withElements(CobolRightPadded.withElements(before.elements, elements));
    }

    public static <P extends Cobol> CobolContainer<P> withElements(CobolContainer<P> before, @Nullable List<P> elements) {
        if (elements == null) {
            return before.getPadding().withElements(Collections.emptyList());
        }
        return before.getPadding().withElements(CobolRightPadded.withElements(before.elements, elements));
    }

    public String toString() {
        return "CobolContainer(before=" + this.before + ", elementCount=" + this.elements.size() + ')';
    }

    public static class Padding<T> {
        private final CobolContainer<T> c;

        public List<CobolRightPadded<T>> getElements() {
            return ((CobolContainer)this.c).elements;
        }

        public CobolContainer<T> withElements(List<CobolRightPadded<T>> elements) {
            return ((CobolContainer)this.c).elements == elements ? this.c : CobolContainer.build(((CobolContainer)this.c).before, ((CobolContainer)this.c).preposition, elements, ((CobolContainer)this.c).markers);
        }

        public Padding(CobolContainer<T> c) {
            this.c = c;
        }
    }
}

