/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class CommentArea
implements ColumnArea {
    private final Space prefix;
    private final Markers markers;
    private final String comment;
    private final Space endOfLine;
    private final boolean isAdded;

    @Override
    public <P> void printColumnArea(CobolPreprocessorSourcePrinter<P> sourcePrinter, Cursor cursor, boolean printColumns, PrintOutputCapture<P> p) {
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
        sourcePrinter.visitSpace(this.prefix, Space.Location.COMMENT_AREA_PREFIX, p);
        if (printColumns) {
            p.append(this.comment);
        }
        sourcePrinter.visitSpace(this.endOfLine, Space.Location.COMMENT_AREA_EOL, p);
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
    }

    @Override
    public <P> void printColumnArea(CobolSourcePrinter<P> sourcePrinter, Cursor cursor, boolean printColumns, PrintOutputCapture<P> p) {
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
        sourcePrinter.visitSpace(this.prefix, Space.Location.COMMENT_AREA_PREFIX, p);
        if (printColumns) {
            p.append(this.comment);
        }
        sourcePrinter.visitSpace(this.endOfLine, Space.Location.COMMENT_AREA_EOL, p);
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
    }

    public CommentArea(Space prefix, Markers markers, String comment, Space endOfLine, boolean isAdded) {
        this.prefix = prefix;
        this.markers = markers;
        this.comment = comment;
        this.endOfLine = endOfLine;
        this.isAdded = isAdded;
    }

    public Space getPrefix() {
        return this.prefix;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public String getComment() {
        return this.comment;
    }

    public Space getEndOfLine() {
        return this.endOfLine;
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommentArea)) {
            return false;
        }
        CommentArea other = (CommentArea)o;
        if (this.isAdded() != other.isAdded()) {
            return false;
        }
        Space this$prefix = this.getPrefix();
        Space other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Space this$endOfLine = this.getEndOfLine();
        Space other$endOfLine = other.getEndOfLine();
        return !(this$endOfLine == null ? other$endOfLine != null : !((Object)this$endOfLine).equals(other$endOfLine));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAdded() ? 79 : 97);
        Space $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Space $endOfLine = this.getEndOfLine();
        result = result * 59 + ($endOfLine == null ? 43 : ((Object)$endOfLine).hashCode());
        return result;
    }

    public String toString() {
        return "CommentArea(prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", comment=" + this.getComment() + ", endOfLine=" + this.getEndOfLine() + ", isAdded=" + this.isAdded() + ")";
    }

    public CommentArea withPrefix(Space prefix) {
        return this.prefix == prefix ? this : new CommentArea(prefix, this.markers, this.comment, this.endOfLine, this.isAdded);
    }

    public CommentArea withMarkers(Markers markers) {
        return this.markers == markers ? this : new CommentArea(this.prefix, markers, this.comment, this.endOfLine, this.isAdded);
    }

    public CommentArea withComment(String comment) {
        return this.comment == comment ? this : new CommentArea(this.prefix, this.markers, comment, this.endOfLine, this.isAdded);
    }

    public CommentArea withEndOfLine(Space endOfLine) {
        return this.endOfLine == endOfLine ? this : new CommentArea(this.prefix, this.markers, this.comment, endOfLine, this.isAdded);
    }

    public CommentArea withAdded(boolean isAdded) {
        return this.isAdded == isAdded ? this : new CommentArea(this.prefix, this.markers, this.comment, this.endOfLine, isAdded);
    }
}

