/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class IndicatorArea
implements ColumnArea {
    private final Markers markers;
    private final String indicator;
    @Nullable
    private final String continuationPrefix;

    @Override
    public <P> void printColumnArea(CobolPreprocessorSourcePrinter<P> sourcePrinter, Cursor cursor, boolean printColumns, PrintOutputCapture<P> p) {
        if (printColumns) {
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
            p.out.append(this.indicator);
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
        }
        if (this.continuationPrefix != null) {
            p.out.append(this.continuationPrefix);
        }
    }

    @Override
    public <P> void printColumnArea(CobolSourcePrinter<P> sourcePrinter, Cursor cursor, boolean printColumns, PrintOutputCapture<P> p) {
        if (printColumns) {
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
            p.out.append(this.indicator);
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
        }
        if (this.continuationPrefix != null) {
            p.out.append(this.continuationPrefix);
        }
    }

    public IndicatorArea(Markers markers, String indicator, String continuationPrefix) {
        this.markers = markers;
        this.indicator = indicator;
        this.continuationPrefix = continuationPrefix;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public String getContinuationPrefix() {
        return this.continuationPrefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndicatorArea)) {
            return false;
        }
        IndicatorArea other = (IndicatorArea)o;
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        String this$indicator = this.getIndicator();
        String other$indicator = other.getIndicator();
        if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
            return false;
        }
        String this$continuationPrefix = this.getContinuationPrefix();
        String other$continuationPrefix = other.getContinuationPrefix();
        return !(this$continuationPrefix == null ? other$continuationPrefix != null : !this$continuationPrefix.equals(other$continuationPrefix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        String $indicator = this.getIndicator();
        result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
        String $continuationPrefix = this.getContinuationPrefix();
        result = result * 59 + ($continuationPrefix == null ? 43 : $continuationPrefix.hashCode());
        return result;
    }

    public String toString() {
        return "IndicatorArea(markers=" + this.getMarkers() + ", indicator=" + this.getIndicator() + ", continuationPrefix=" + this.getContinuationPrefix() + ")";
    }

    public IndicatorArea withMarkers(Markers markers) {
        return this.markers == markers ? this : new IndicatorArea(markers, this.indicator, this.continuationPrefix);
    }

    public IndicatorArea withIndicator(String indicator) {
        return this.indicator == indicator ? this : new IndicatorArea(this.markers, indicator, this.continuationPrefix);
    }

    public IndicatorArea withContinuationPrefix(String continuationPrefix) {
        return this.continuationPrefix == continuationPrefix ? this : new IndicatorArea(this.markers, this.indicator, continuationPrefix);
    }
}

