/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import java.util.List;
import java.util.UUID;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.marker.Markers;

public final class Replacement {
    private final UUID id;
    private final Markers markers;
    private final List<OriginalWord> originalWords;
    private final Type type;
    private final boolean isCopiedSource;

    public Replacement(UUID id, Markers markers, List<OriginalWord> originalWords, Type type, boolean isCopiedSource) {
        this.id = id;
        this.markers = markers;
        this.originalWords = originalWords;
        this.type = type;
        this.isCopiedSource = isCopiedSource;
    }

    public UUID getId() {
        return this.id;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public List<OriginalWord> getOriginalWords() {
        return this.originalWords;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isCopiedSource() {
        return this.isCopiedSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Replacement)) {
            return false;
        }
        Replacement other = (Replacement)o;
        if (this.isCopiedSource() != other.isCopiedSource()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        List<OriginalWord> this$originalWords = this.getOriginalWords();
        List<OriginalWord> other$originalWords = other.getOriginalWords();
        if (this$originalWords == null ? other$originalWords != null : !((Object)this$originalWords).equals(other$originalWords)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCopiedSource() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        List<OriginalWord> $originalWords = this.getOriginalWords();
        result = result * 59 + ($originalWords == null ? 43 : ((Object)$originalWords).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Replacement(id=" + this.getId() + ", markers=" + this.getMarkers() + ", originalWords=" + this.getOriginalWords() + ", type=" + (Object)((Object)this.getType()) + ", isCopiedSource=" + this.isCopiedSource() + ")";
    }

    public Replacement withId(UUID id) {
        return this.id == id ? this : new Replacement(id, this.markers, this.originalWords, this.type, this.isCopiedSource);
    }

    public Replacement withMarkers(Markers markers) {
        return this.markers == markers ? this : new Replacement(this.id, markers, this.originalWords, this.type, this.isCopiedSource);
    }

    public Replacement withOriginalWords(List<OriginalWord> originalWords) {
        return this.originalWords == originalWords ? this : new Replacement(this.id, this.markers, originalWords, this.type, this.isCopiedSource);
    }

    public Replacement withType(Type type) {
        return this.type == type ? this : new Replacement(this.id, this.markers, this.originalWords, type, this.isCopiedSource);
    }

    public Replacement withCopiedSource(boolean isCopiedSource) {
        return this.isCopiedSource == isCopiedSource ? this : new Replacement(this.id, this.markers, this.originalWords, this.type, isCopiedSource);
    }

    public static enum Type {
        ADDITIVE,
        REDUCTIVE,
        EQUAL;

    }

    public static final class OriginalWord {
        private final Cobol.Word original;
        private final boolean replacedWithEmpty;

        public OriginalWord(Cobol.Word original, boolean replacedWithEmpty) {
            this.original = original;
            this.replacedWithEmpty = replacedWithEmpty;
        }

        public Cobol.Word getOriginal() {
            return this.original;
        }

        public boolean isReplacedWithEmpty() {
            return this.replacedWithEmpty;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginalWord)) {
                return false;
            }
            OriginalWord other = (OriginalWord)o;
            if (this.isReplacedWithEmpty() != other.isReplacedWithEmpty()) {
                return false;
            }
            Cobol.Word this$original = this.getOriginal();
            Cobol.Word other$original = other.getOriginal();
            return !(this$original == null ? other$original != null : !((Object)this$original).equals(other$original));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isReplacedWithEmpty() ? 79 : 97);
            Cobol.Word $original = this.getOriginal();
            result = result * 59 + ($original == null ? 43 : ((Object)$original).hashCode());
            return result;
        }

        public String toString() {
            return "Replacement.OriginalWord(original=" + this.getOriginal() + ", replacedWithEmpty=" + this.isReplacedWithEmpty() + ")";
        }

        public OriginalWord withOriginal(Cobol.Word original) {
            return this.original == original ? this : new OriginalWord(original, this.replacedWithEmpty);
        }

        public OriginalWord withReplacedWithEmpty(boolean replacedWithEmpty) {
            return this.replacedWithEmpty == replacedWithEmpty ? this : new OriginalWord(this.original, replacedWithEmpty);
        }
    }
}

