/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class SequenceArea
implements ColumnArea {
    private final Markers markers;
    private final String sequence;

    @Override
    public <P> void printColumnArea(CobolPreprocessorSourcePrinter<P> sourcePrinter, Cursor cursor, boolean printColumns, PrintOutputCapture<P> p) {
        if (printColumns) {
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
            p.out.append(this.sequence);
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
        }
    }

    @Override
    public <P> void printColumnArea(CobolSourcePrinter<P> sourcePrinter, Cursor cursor, boolean printColumns, PrintOutputCapture<P> p) {
        if (printColumns) {
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
            p.out.append(this.sequence);
            for (Marker marker : this.markers.getMarkers()) {
                p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
            }
        }
    }

    public SequenceArea(Markers markers, String sequence) {
        this.markers = markers;
        this.sequence = sequence;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public String getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceArea)) {
            return false;
        }
        SequenceArea other = (SequenceArea)o;
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        String this$sequence = this.getSequence();
        String other$sequence = other.getSequence();
        return !(this$sequence == null ? other$sequence != null : !this$sequence.equals(other$sequence));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        String $sequence = this.getSequence();
        result = result * 59 + ($sequence == null ? 43 : $sequence.hashCode());
        return result;
    }

    public String toString() {
        return "SequenceArea(markers=" + this.getMarkers() + ", sequence=" + this.getSequence() + ")";
    }

    public SequenceArea withMarkers(Markers markers) {
        return this.markers == markers ? this : new SequenceArea(markers, this.sequence);
    }

    public SequenceArea withSequence(String sequence) {
        return this.sequence == sequence ? this : new SequenceArea(this.markers, sequence);
    }
}

