/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.controlm;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.controlm.ControlMLineReader;
import org.openrewrite.controlm.ControlMParsingException;
import org.openrewrite.controlm.internal.ControlMParserVisitor;
import org.openrewrite.controlm.internal.grammar.ControlMLexer;
import org.openrewrite.controlm.tree.ControlM;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class ControlMParser
implements Parser {
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        Stream accepted = this.acceptedInputs(sourceFiles);
        return accepted.map(sourceFile -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a Control-M file").tag("file.type", "Control-M");
            Timer.Sample sample = Timer.start();
            Path path = sourceFile.getRelativePath(relativeTo);
            try {
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                String sourceStr = is.readFully();
                String processedStr = ControlMLineReader.readLines(sourceStr);
                org.openrewrite.controlm.internal.grammar.ControlMParser parser = new org.openrewrite.controlm.internal.grammar.ControlMParser((TokenStream)new CommonTokenStream((TokenSource)new ControlMLexer((CharStream)CharStreams.fromString((String)processedStr))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                ControlM.CompilationUnit cu = new ControlMParserVisitor(path, sourceFile.getFileAttributes(), sourceStr, is.getCharset(), is.isCharsetBomMarked()).visitCompilationUnit(parser.compilationUnit());
                sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                parsingListener.parsed(sourceFile, (SourceFile)cu);
                return cu;
            }
            catch (Throwable t) {
                sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                return ParseError.build((Parser)this, (Parser.Input)sourceFile, (Path)relativeTo, (ExecutionContext)pctx, (Throwable)t);
            }
        });
    }

    public boolean accept(Path path) {
        return path.toString().toLowerCase().endsWith(".ctms");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.ctms");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(ControlM.CompilationUnit.class);
        }

        public ControlMParser build() {
            return new ControlMParser();
        }

        public String getDslName() {
            return "controlm";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new ControlMParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), e));
        }
    }
}

