/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.controlm.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.controlm.internal.grammar.ControlMParser;
import org.openrewrite.controlm.internal.grammar.ControlMParserBaseVisitor;
import org.openrewrite.controlm.marker.Column;
import org.openrewrite.controlm.tree.ControlM;
import org.openrewrite.controlm.tree.ControlMLeftPadded;
import org.openrewrite.controlm.tree.Section;
import org.openrewrite.controlm.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class ControlMParserVisitor
extends ControlMParserBaseVisitor<ControlM> {
    private final Path path;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private int cursor = 0;

    public ControlMParserVisitor(Path path, @Nullable FileAttributes fileAttributes, String source, Charset charset, boolean charsetBomMarked) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
    }

    public <T> T visitNullable(@Nullable ParseTree tree) {
        if (tree == null) {
            return null;
        }
        return (T)super.visit(tree);
    }

    @Override
    public ControlM.CompilationUnit visitCompilationUnit(ControlMParser.CompilationUnitContext ctx) {
        Space prefix = this.whitespace();
        ArrayList<Section> sections = new ArrayList<Section>(6);
        if (ctx.definitionSection() != null) {
            sections.add(this.visitDefinitionSection(ctx.definitionSection()));
        }
        if (ctx.scheduleSection() != null) {
            sections.add(this.visitScheduleSection(ctx.scheduleSection()));
        }
        if (ctx.inputSection() != null) {
            sections.add(this.visitInputSection(ctx.inputSection()));
        }
        if (ctx.outputSection() != null) {
            sections.add(this.visitOutputSection(ctx.outputSection()));
        }
        if (ctx.applicationFormSection() != null) {
            sections.add(this.visitApplicationFormSection(ctx.applicationFormSection()));
        }
        return new ControlM.CompilationUnit(Tree.randomId(), this.path, this.fileAttributes, prefix, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, sections, Space.build(this.source.substring(this.cursor)));
    }

    @Override
    public Section visitDefinitionSection(ControlMParser.DefinitionSectionContext ctx) {
        return new ControlM.DefinitionSection(Tree.randomId(), this.sourceBefore("+---------------------------------- BROWSE -----------------------------------+"), Markers.EMPTY, this.convertAll(ctx.definitionLine()));
    }

    @Override
    public ControlM visitDefinitionLine(ControlMParser.DefinitionLineContext ctx) {
        if (ctx.memLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.memLine());
        }
        if (ctx.ownerLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.ownerLine());
        }
        if (ctx.applLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.applLine());
        }
        if (ctx.descLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.descLine());
        }
        if (ctx.overlibLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.overlibLine());
        }
        if (ctx.schenvLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.schenvLine());
        }
        if (ctx.setVarLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.setVarLine());
        }
        if (ctx.ctbSetLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.ctbSetLine());
        }
        if (ctx.docLine() != null) {
            return (ControlM)this.visit((ParseTree)ctx.docLine());
        }
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, Collections.emptyList());
    }

    @Override
    public ControlM.Line visitMemLine(ControlMParser.MemLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> parameters = this.convertAll(Arrays.asList(new ParserRuleContext[]{ctx.memName(), ctx.memLib()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, parameters);
    }

    @Override
    public ControlM.Parameter visitMemName(ControlMParser.MemNameContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_MEMNAME().getText()), Markers.EMPTY, ctx.DEFINITION_MEMNAME().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM.Parameter visitMemLib(ControlMParser.MemLibContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_MEMLIB().getText()), Markers.EMPTY, ctx.DEFINITION_MEMLIB().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitOwnerLine(ControlMParser.OwnerLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> parameters = this.convertAll(Arrays.asList(new ParserRuleContext[]{ctx.owner(), ctx.taskType(), ctx.preventNc2(), ctx.dflt()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, parameters);
    }

    @Override
    public ControlM visitOwner(ControlMParser.OwnerContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_OWNER().getText()), Markers.EMPTY, ctx.DEFINITION_OWNER().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitTaskType(ControlMParser.TaskTypeContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_TASKTYPE().getText()), Markers.EMPTY, ctx.DEFINITION_TASKTYPE().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitPreventNc2(ControlMParser.PreventNc2Context ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_PREVENT_NCT2().getText()), Markers.EMPTY, ctx.DEFINITION_PREVENT_NCT2().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitDflt(ControlMParser.DfltContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_DFLT().getText()), Markers.EMPTY, ctx.DEFINITION_DFLT().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitApplLine(ControlMParser.ApplLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> parameters = this.convertAll(Arrays.asList(new ParserRuleContext[]{ctx.appl(), ctx.group()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, parameters);
    }

    @Override
    public ControlM visitAppl(ControlMParser.ApplContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_APPL().getText()), Markers.EMPTY, ctx.DEFINITION_APPL().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitGroup(ControlMParser.GroupContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_GROUP().getText()), Markers.EMPTY, ctx.DEFINITION_GROUP().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM.Line visitDescLine(ControlMParser.DescLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        ControlM.Description description = new ControlM.Description(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_DESC().getText()), Markers.EMPTY, ctx.DEFINITION_DESC().getText(), this.convertAll(ctx.DESC_TEXT_WORD()));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, Collections.singletonList(description));
    }

    @Override
    public ControlM visitOverlibLine(ControlMParser.OverlibLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> parameters = this.convertAll(Arrays.asList(new ParserRuleContext[]{ctx.overlib(), ctx.statCal()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, parameters);
    }

    @Override
    public ControlM visitOverlib(ControlMParser.OverlibContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_OVERLIB().getText()), Markers.EMPTY, ctx.DEFINITION_OVERLIB().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitStatCal(ControlMParser.StatCalContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_STAT_CAL().getText()), Markers.EMPTY, ctx.DEFINITION_STAT_CAL().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitSchenvLine(ControlMParser.SchenvLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> parameters = this.convertAll(Arrays.asList(new ParserRuleContext[]{ctx.schenv(), ctx.systemId(), ctx.njeNode()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, parameters);
    }

    @Override
    public ControlM visitSchenv(ControlMParser.SchenvContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_SCHENV().getText()), Markers.EMPTY, ctx.DEFINITION_SCHENV().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitSystemId(ControlMParser.SystemIdContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_SYSTEM_ID().getText()), Markers.EMPTY, ctx.DEFINITION_SYSTEM_ID().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitNjeNode(ControlMParser.NjeNodeContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_NJE_NODE().getText()), Markers.EMPTY, ctx.DEFINITION_NJE_NODE().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitSetVarLine(ControlMParser.SetVarLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        ControlM set = ctx.DEFINITION_EQUALS_CHAR() != null ? new ControlM.SetVar(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_SET_VAR().getText()), Markers.EMPTY, ctx.DEFINITION_SET_VAR().getText(), (ControlM.Word)this.visit((ParseTree)ctx.name(0)), this.padLeft(this.sourceBefore(ctx.DEFINITION_EQUALS_CHAR().getText()), (ControlM.Word)this.visit((ParseTree)ctx.name(1)))) : new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_SET_VAR().getText()), Markers.EMPTY, ctx.DEFINITION_SET_VAR().getText(), ctx.name().isEmpty() ? null : (ControlM.Word)this.visit((ParseTree)ctx.name(0)));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, Collections.singletonList(set));
    }

    @Override
    public ControlM visitCtbSetLine(ControlMParser.CtbSetLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> words = this.convertAll(Arrays.asList(new ParseTree[]{ctx.DEFINITION_CTB_STEP(), ctx.DEFINITION_AT(), ctx.name(), ctx.DEFINITION_TYPE()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, words);
    }

    @Override
    public ControlM visitDocLine(ControlMParser.DocLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> parameters = this.convertAll(Arrays.asList(new ParserRuleContext[]{ctx.docMem(), ctx.docLib()}));
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, parameters);
    }

    @Override
    public ControlM visitDocMem(ControlMParser.DocMemContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_DOCMEM().getText()), Markers.EMPTY, ctx.DEFINITION_DOCMEM().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public ControlM visitDocLib(ControlMParser.DocLibContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.DEFINITION_DOCLIB().getText()), Markers.EMPTY, ctx.DEFINITION_DOCLIB().getText(), (ControlM.Word)this.visitNullable((ParseTree)ctx.name()));
    }

    @Override
    public Section visitScheduleSection(ControlMParser.ScheduleSectionContext ctx) {
        return new ControlM.ScheduleSection(Tree.randomId(), this.sourceBefore("| =========================================================================== |"), Markers.EMPTY, this.convertAll(ctx.scheduleLine()));
    }

    @Override
    public ControlM visitScheduleLine(ControlMParser.ScheduleLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> words = this.convertAll(ctx.name());
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, words);
    }

    @Override
    public Section visitInputSection(ControlMParser.InputSectionContext ctx) {
        return new ControlM.InputSection(Tree.randomId(), this.sourceBefore("| =========================================================================== |"), Markers.EMPTY, this.convertAll(ctx.inputNamesLine()), this.convertAll(ctx.inputLine()));
    }

    @Override
    public ControlM visitInputNamesLine(ControlMParser.InputNamesLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        ControlM.Word in = (ControlM.Word)this.visitNullable((ParseTree)ctx.INPUT_NAMES_IN());
        List<ControlM> inputs = this.convertAll(ctx.input());
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Input(Tree.randomId(), prefix, markers, in, inputs);
    }

    @Override
    public ControlM visitInput(ControlMParser.InputContext ctx) {
        return new ControlM.Input.NameParameter(Tree.randomId(), this.whitespace(), Markers.EMPTY, (ControlM.Word)this.visitNullable((ParseTree)ctx.name()), (ControlM.Parameter)this.visit((ParseTree)ctx.date()));
    }

    @Override
    public ControlM visitDate(ControlMParser.DateContext ctx) {
        return new ControlM.Parameter(Tree.randomId(), this.sourceBefore(ctx.dateParam().getText()), Markers.EMPTY, ctx.dateParam().getText(), ctx.MINUS_CHAR() != null ? (ControlM.Word)this.visit((ParseTree)ctx.MINUS_CHAR()) : (ctx.PLUS_CHAR() != null ? (ControlM.Word)this.visit((ParseTree)ctx.PLUS_CHAR()) : null));
    }

    @Override
    public ControlM visitInputLine(ControlMParser.InputLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> words = this.convertAll(ctx.name());
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, words);
    }

    @Override
    public Section visitOutputSection(ControlMParser.OutputSectionContext ctx) {
        return new ControlM.OutputSection(Tree.randomId(), this.sourceBefore("| =========================================================================== |"), Markers.EMPTY, this.convertAll(ctx.outputNamesLine()), this.convertAll(ctx.outputLine()));
    }

    @Override
    public ControlM visitOutputNamesLine(ControlMParser.OutputNamesLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        ControlM.Word out = (ControlM.Word)this.visitNullable((ParseTree)ctx.OUTPUT_NAMES_OUT());
        List<ControlM> outputs = this.convertAll(ctx.output());
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Output(Tree.randomId(), prefix, markers, out, outputs);
    }

    @Override
    public ControlM visitOutput(ControlMParser.OutputContext ctx) {
        return new ControlM.Output.NameParameter(Tree.randomId(), this.whitespace(), Markers.EMPTY, (ControlM.Word)this.visitNullable((ParseTree)ctx.name()), (ControlM.Parameter)this.visit((ParseTree)ctx.date()));
    }

    @Override
    public ControlM visitOutputLine(ControlMParser.OutputLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> words = this.convertAll(ctx.name());
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, words);
    }

    @Override
    public Section visitApplicationFormSection(ControlMParser.ApplicationFormSectionContext ctx) {
        return new ControlM.ApplicationFormSection(Tree.randomId(), this.sourceBefore("| =========================================================================== |"), Markers.EMPTY, this.convertAll(ctx.applicationFormLine()));
    }

    @Override
    public ControlM visitApplicationFormLine(ControlMParser.ApplicationFormLineContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.START));
        List<ControlM> words = this.convertAll(ctx.name());
        markers = markers.addIfAbsent((Marker)this.mapColumn(Column.Location.END));
        return new ControlM.Line(Tree.randomId(), prefix, markers, words);
    }

    public ControlM visitTerminal(TerminalNode node) {
        return new ControlM.Word(Tree.randomId(), this.sourceBefore(node.getText().trim()), Markers.EMPTY, node.getText().trim());
    }

    private Column mapColumn(Column.Location location) {
        return new Column(Tree.randomId(), this.sourceBefore("|"), location);
    }

    private <C, T extends ParseTree> List<C> convertAll(List<T> trees, Function<T, C> convert) {
        ArrayList converted = new ArrayList(trees.size());
        for (ParseTree tree : trees) {
            converted.add(convert.apply(tree));
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    private <C extends ControlM, T extends ParseTree> List<C> convertAll(List<T> trees) {
        return this.convertAll(trees, t -> (ControlM)this.visit((ParseTree)t));
    }

    private <T> ControlMLeftPadded<T> padLeft(Space left, T tree) {
        return new ControlMLeftPadded<T>(left, tree, Markers.EMPTY);
    }

    private void skip(@Nullable String token) {
        if (token != null && this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
    }

    private Space whitespace() {
        int endIndex = ControlMParserVisitor.indexOfNextNonWhitespace(this.cursor, this.source);
        String prefix = this.source.substring(this.cursor, endIndex);
        this.cursor += prefix.length();
        return Space.build(prefix);
    }

    private Space sourceBefore(String untilDelim) {
        Space prefix = this.whitespace();
        this.skip(untilDelim);
        return Space.build(prefix.getWhitespace());
    }

    public static int indexOfNextNonWhitespace(int cursor, String source) {
        int delimIndex;
        for (delimIndex = cursor; delimIndex < source.length() && Character.isWhitespace(source.charAt(delimIndex)); ++delimIndex) {
        }
        return delimIndex;
    }
}

