/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.controlm.internal;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.controlm.ControlMVisitor;
import org.openrewrite.controlm.marker.Column;
import org.openrewrite.controlm.tree.ControlM;
import org.openrewrite.controlm.tree.ControlMLeftPadded;
import org.openrewrite.controlm.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class ControlMPrinter<P>
extends ControlMVisitor<PrintOutputCapture<P>> {
    public static final UnaryOperator<String> CONTROL_M_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public ControlM visitCompilationUnit(ControlM.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax(cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visit(cu.getSections(), p);
        this.afterSyntax(cu, p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        return cu;
    }

    @Override
    public ControlM visitDefinitionSection(ControlM.DefinitionSection definitionSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(definitionSection, Space.Location.DEFINITION_SECTION_PREFIX, p);
        p.append("+---------------------------------- BROWSE -----------------------------------+");
        this.visit(definitionSection.getLines(), p);
        this.afterSyntax(definitionSection, p);
        return definitionSection;
    }

    @Override
    public ControlM visitDescription(ControlM.Description description, PrintOutputCapture<P> p) {
        this.beforeSyntax(description, Space.Location.DESCRIPTION_PREFIX, p);
        p.append(description.getWord());
        this.visit(description.getDescription(), p);
        this.afterSyntax(description, p);
        return description;
    }

    @Override
    public ControlM visitSetVar(ControlM.SetVar setVar, PrintOutputCapture<P> p) {
        this.beforeSyntax(setVar, Space.Location.SET_VAR_PREFIX, p);
        p.append(setVar.getSetVar());
        this.visit(setVar.getVarName(), p);
        this.visitLeftPadded("=", setVar.getPadding().getValue(), ControlMLeftPadded.Location.SET_VAR_INITIALIZER, p);
        this.afterSyntax(setVar, p);
        return setVar;
    }

    @Override
    public ControlM visitScheduleSection(ControlM.ScheduleSection scheduleSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(scheduleSection, Space.Location.SCHEDULE_SECTION_PREFIX, p);
        p.append("| =========================================================================== |");
        this.visit(scheduleSection.getLines(), p);
        this.afterSyntax(scheduleSection, p);
        return scheduleSection;
    }

    @Override
    public ControlM visitInputSection(ControlM.InputSection inputSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(inputSection, Space.Location.INPUT_SECTION_PREFIX, p);
        p.append("| =========================================================================== |");
        this.visit(inputSection.getInputNames(), p);
        this.visit(inputSection.getLines(), p);
        this.afterSyntax(inputSection, p);
        return inputSection;
    }

    @Override
    public ControlM visitInput(ControlM.Input input, PrintOutputCapture<P> p) {
        this.beforeSyntax(input, Space.Location.INPUT_PREFIX, p);
        this.visit(input.getIn(), p);
        this.visit(input.getInput(), p);
        this.afterSyntax(input, p);
        return input;
    }

    @Override
    public ControlM visitInputNameParameter(ControlM.Input.NameParameter nameParameter, PrintOutputCapture<P> p) {
        this.beforeSyntax(nameParameter, Space.Location.PARAMETER_PREFIX, p);
        this.visit(nameParameter.getName(), p);
        this.visit(nameParameter.getDate(), p);
        this.afterSyntax(nameParameter, p);
        return nameParameter;
    }

    @Override
    public ControlM visitOutputSection(ControlM.OutputSection outputSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(outputSection, Space.Location.OUTPUT_SECTION_PREFIX, p);
        p.append("| =========================================================================== |");
        this.visit(outputSection.getOutputNames(), p);
        this.visit(outputSection.getLines(), p);
        this.afterSyntax(outputSection, p);
        return outputSection;
    }

    @Override
    public ControlM visitOutput(ControlM.Output output, PrintOutputCapture<P> p) {
        this.beforeSyntax(output, Space.Location.OUTPUT_PREFIX, p);
        this.visit(output.getOut(), p);
        this.visit(output.getOutput(), p);
        this.afterSyntax(output, p);
        return output;
    }

    @Override
    public ControlM visitOutputNameParameter(ControlM.Output.NameParameter nameParameter, PrintOutputCapture<P> p) {
        this.beforeSyntax(nameParameter, Space.Location.PARAMETER_PREFIX, p);
        this.visit(nameParameter.getName(), p);
        this.visit(nameParameter.getDate(), p);
        this.afterSyntax(nameParameter, p);
        return nameParameter;
    }

    @Override
    public ControlM visitApplicationFormSection(ControlM.ApplicationFormSection applicationFormSection, PrintOutputCapture<P> p) {
        this.beforeSyntax(applicationFormSection, Space.Location.APPLICATION_FORM_SECTION_PREFIX, p);
        p.append("| =========================================================================== |");
        this.visit(applicationFormSection.getLines(), p);
        this.afterSyntax(applicationFormSection, p);
        return applicationFormSection;
    }

    @Override
    public ControlM visitLine(ControlM.Line line, PrintOutputCapture<P> p) {
        this.beforeSyntax(line, Space.Location.LINE_PREFIX, p);
        this.visit(line.getParameters(), p);
        this.afterSyntax(line, p);
        return line;
    }

    @Override
    public ControlM visitParameter(ControlM.Parameter parameter, PrintOutputCapture<P> p) {
        this.beforeSyntax(parameter, Space.Location.PARAMETER_PREFIX, p);
        p.append(parameter.getOption());
        this.visit(parameter.getValue(), p);
        this.afterSyntax(parameter, p);
        return parameter;
    }

    @Override
    public ControlM visitWord(ControlM.Word word, PrintOutputCapture<P> p) {
        this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
        p.append(word.getText());
        this.afterSyntax(word, p);
        return word;
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable ControlMLeftPadded<? extends ControlM> leftPadded, ControlMLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit(leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    @Override
    public Space visitSpace(Space space, Space.Location location, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        return space;
    }

    protected void beforeSyntax(ControlM c, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(c.getPrefix(), c.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), CONTROL_M_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), CONTROL_M_MARKER_WRAPPER));
            if (!(marker instanceof Column) || ((Column)marker).getLocation() != Column.Location.START) continue;
            this.visitSpace(((Column)marker).getPrefix(), Space.Location.COLUMN_START_PREFIX, p);
            p.out.append("|");
        }
    }

    protected void afterSyntax(ControlM c, PrintOutputCapture<P> p) {
        this.afterSyntax(c.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            if (marker instanceof Column && ((Column)marker).getLocation() == Column.Location.END) {
                this.visitSpace(((Column)marker).getPrefix(), Space.Location.COLUMN_END_PREFIX, p);
                p.out.append("|");
            }
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), CONTROL_M_MARKER_WRAPPER));
        }
    }
}

