/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.controlm.tree;

import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.controlm.ControlMVisitor;
import org.openrewrite.controlm.internal.ControlMPrinter;
import org.openrewrite.controlm.tree.ControlMLeftPadded;
import org.openrewrite.controlm.tree.Section;
import org.openrewrite.controlm.tree.Space;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public interface ControlM
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptControlM((ControlMVisitor)v.adapt(ControlMVisitor.class), p);
    }

    @Nullable
    default public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
        return (ControlM)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(ControlMVisitor.class);
    }

    public Space getPrefix();

    public <P extends ControlM> P withPrefix(Space var1);

    public static final class Word
    implements ControlM {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String text;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitWord(this, p);
        }

        public Word(UUID id, Space prefix, Markers markers, String text) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.text = text;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "ControlM.Word(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Word)) {
                return false;
            }
            Word other = (Word)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Word withId(UUID id) {
            return this.id == id ? this : new Word(id, this.prefix, this.markers, this.text);
        }

        public Word withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Word(this.id, prefix, this.markers, this.text);
        }

        public Word withMarkers(Markers markers) {
            return this.markers == markers ? this : new Word(this.id, this.prefix, markers, this.text);
        }

        public Word withText(String text) {
            return this.text == text ? this : new Word(this.id, this.prefix, this.markers, text);
        }
    }

    public static final class Parameter
    implements ControlM {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String option;
        @Nullable
        private final Word value;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitParameter(this, p);
        }

        public Parameter(UUID id, Space prefix, Markers markers, String option, Word value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.option = option;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getOption() {
            return this.option;
        }

        public Word getValue() {
            return this.value;
        }

        public String toString() {
            return "ControlM.Parameter(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", option=" + this.getOption() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Parameter withId(UUID id) {
            return this.id == id ? this : new Parameter(id, this.prefix, this.markers, this.option, this.value);
        }

        public Parameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parameter(this.id, prefix, this.markers, this.option, this.value);
        }

        public Parameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parameter(this.id, this.prefix, markers, this.option, this.value);
        }

        public Parameter withOption(String option) {
            return this.option == option ? this : new Parameter(this.id, this.prefix, this.markers, option, this.value);
        }

        public Parameter withValue(Word value) {
            return this.value == value ? this : new Parameter(this.id, this.prefix, this.markers, this.option, value);
        }
    }

    public static final class Line
    implements ControlM {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ControlM> parameters;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitLine(this, p);
        }

        public Line(UUID id, Space prefix, Markers markers, List<ControlM> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<ControlM> getParameters() {
            return this.parameters;
        }

        public String toString() {
            return "ControlM.Line(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parameters=" + this.getParameters() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Line)) {
                return false;
            }
            Line other = (Line)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Line withId(UUID id) {
            return this.id == id ? this : new Line(id, this.prefix, this.markers, this.parameters);
        }

        public Line withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Line(this.id, prefix, this.markers, this.parameters);
        }

        public Line withMarkers(Markers markers) {
            return this.markers == markers ? this : new Line(this.id, this.prefix, markers, this.parameters);
        }

        public Line withParameters(List<ControlM> parameters) {
            return this.parameters == parameters ? this : new Line(this.id, this.prefix, this.markers, parameters);
        }
    }

    public static final class ApplicationFormSection
    implements ControlM,
    Section {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ControlM> lines;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitApplicationFormSection(this, p);
        }

        public ApplicationFormSection(UUID id, Space prefix, Markers markers, List<ControlM> lines) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lines = lines;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<ControlM> getLines() {
            return this.lines;
        }

        public String toString() {
            return "ControlM.ApplicationFormSection(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lines=" + this.getLines() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationFormSection)) {
                return false;
            }
            ApplicationFormSection other = (ApplicationFormSection)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ApplicationFormSection withId(UUID id) {
            return this.id == id ? this : new ApplicationFormSection(id, this.prefix, this.markers, this.lines);
        }

        public ApplicationFormSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ApplicationFormSection(this.id, prefix, this.markers, this.lines);
        }

        public ApplicationFormSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new ApplicationFormSection(this.id, this.prefix, markers, this.lines);
        }

        public ApplicationFormSection withLines(List<ControlM> lines) {
            return this.lines == lines ? this : new ApplicationFormSection(this.id, this.prefix, this.markers, lines);
        }
    }

    public static final class Output
    implements ControlM {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Word out;
        private final List<ControlM> output;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitOutput(this, p);
        }

        public Output(UUID id, Space prefix, Markers markers, Word out, List<ControlM> output) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.out = out;
            this.output = output;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getOut() {
            return this.out;
        }

        public List<ControlM> getOutput() {
            return this.output;
        }

        public String toString() {
            return "ControlM.Output(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", out=" + this.getOut() + ", output=" + this.getOutput() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Output withId(UUID id) {
            return this.id == id ? this : new Output(id, this.prefix, this.markers, this.out, this.output);
        }

        public Output withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Output(this.id, prefix, this.markers, this.out, this.output);
        }

        public Output withMarkers(Markers markers) {
            return this.markers == markers ? this : new Output(this.id, this.prefix, markers, this.out, this.output);
        }

        public Output withOut(Word out) {
            return this.out == out ? this : new Output(this.id, this.prefix, this.markers, out, this.output);
        }

        public Output withOutput(List<ControlM> output) {
            return this.output == output ? this : new Output(this.id, this.prefix, this.markers, this.out, output);
        }

        public static final class NameParameter
        implements ControlM {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            @Nullable
            private final Word name;
            @Nullable
            private final Parameter date;

            @Override
            public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
                return v.visitOutputNameParameter(this, p);
            }

            public NameParameter(UUID id, Space prefix, Markers markers, Word name, Parameter date) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.date = date;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Word getName() {
                return this.name;
            }

            public Parameter getDate() {
                return this.date;
            }

            public String toString() {
                return "ControlM.Output.NameParameter(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", date=" + this.getDate() + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NameParameter)) {
                    return false;
                }
                NameParameter other = (NameParameter)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public NameParameter withId(UUID id) {
                return this.id == id ? this : new NameParameter(id, this.prefix, this.markers, this.name, this.date);
            }

            public NameParameter withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new NameParameter(this.id, prefix, this.markers, this.name, this.date);
            }

            public NameParameter withMarkers(Markers markers) {
                return this.markers == markers ? this : new NameParameter(this.id, this.prefix, markers, this.name, this.date);
            }

            public NameParameter withName(Word name) {
                return this.name == name ? this : new NameParameter(this.id, this.prefix, this.markers, name, this.date);
            }

            public NameParameter withDate(Parameter date) {
                return this.date == date ? this : new NameParameter(this.id, this.prefix, this.markers, this.name, date);
            }
        }
    }

    public static final class OutputSection
    implements ControlM,
    Section {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ControlM> outputNames;
        private final List<ControlM> lines;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitOutputSection(this, p);
        }

        public OutputSection(UUID id, Space prefix, Markers markers, List<ControlM> outputNames, List<ControlM> lines) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.outputNames = outputNames;
            this.lines = lines;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<ControlM> getOutputNames() {
            return this.outputNames;
        }

        public List<ControlM> getLines() {
            return this.lines;
        }

        public String toString() {
            return "ControlM.OutputSection(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", outputNames=" + this.getOutputNames() + ", lines=" + this.getLines() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OutputSection)) {
                return false;
            }
            OutputSection other = (OutputSection)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public OutputSection withId(UUID id) {
            return this.id == id ? this : new OutputSection(id, this.prefix, this.markers, this.outputNames, this.lines);
        }

        public OutputSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new OutputSection(this.id, prefix, this.markers, this.outputNames, this.lines);
        }

        public OutputSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new OutputSection(this.id, this.prefix, markers, this.outputNames, this.lines);
        }

        public OutputSection withOutputNames(List<ControlM> outputNames) {
            return this.outputNames == outputNames ? this : new OutputSection(this.id, this.prefix, this.markers, outputNames, this.lines);
        }

        public OutputSection withLines(List<ControlM> lines) {
            return this.lines == lines ? this : new OutputSection(this.id, this.prefix, this.markers, this.outputNames, lines);
        }
    }

    public static final class Input
    implements ControlM {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Word in;
        private final List<ControlM> input;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitInput(this, p);
        }

        public Input(UUID id, Space prefix, Markers markers, Word in, List<ControlM> input) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.in = in;
            this.input = input;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getIn() {
            return this.in;
        }

        public List<ControlM> getInput() {
            return this.input;
        }

        public String toString() {
            return "ControlM.Input(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", in=" + this.getIn() + ", input=" + this.getInput() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Input withId(UUID id) {
            return this.id == id ? this : new Input(id, this.prefix, this.markers, this.in, this.input);
        }

        public Input withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Input(this.id, prefix, this.markers, this.in, this.input);
        }

        public Input withMarkers(Markers markers) {
            return this.markers == markers ? this : new Input(this.id, this.prefix, markers, this.in, this.input);
        }

        public Input withIn(Word in) {
            return this.in == in ? this : new Input(this.id, this.prefix, this.markers, in, this.input);
        }

        public Input withInput(List<ControlM> input) {
            return this.input == input ? this : new Input(this.id, this.prefix, this.markers, this.in, input);
        }

        public static final class NameParameter
        implements ControlM {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            @Nullable
            private final Word name;
            @Nullable
            private final Parameter date;

            @Override
            public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
                return v.visitInputNameParameter(this, p);
            }

            public NameParameter(UUID id, Space prefix, Markers markers, Word name, Parameter date) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.date = date;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Word getName() {
                return this.name;
            }

            public Parameter getDate() {
                return this.date;
            }

            public String toString() {
                return "ControlM.Input.NameParameter(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", date=" + this.getDate() + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NameParameter)) {
                    return false;
                }
                NameParameter other = (NameParameter)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public NameParameter withId(UUID id) {
                return this.id == id ? this : new NameParameter(id, this.prefix, this.markers, this.name, this.date);
            }

            public NameParameter withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new NameParameter(this.id, prefix, this.markers, this.name, this.date);
            }

            public NameParameter withMarkers(Markers markers) {
                return this.markers == markers ? this : new NameParameter(this.id, this.prefix, markers, this.name, this.date);
            }

            public NameParameter withName(Word name) {
                return this.name == name ? this : new NameParameter(this.id, this.prefix, this.markers, name, this.date);
            }

            public NameParameter withDate(Parameter date) {
                return this.date == date ? this : new NameParameter(this.id, this.prefix, this.markers, this.name, date);
            }
        }
    }

    public static final class InputSection
    implements ControlM,
    Section {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ControlM> inputNames;
        private final List<ControlM> lines;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitInputSection(this, p);
        }

        public InputSection(UUID id, Space prefix, Markers markers, List<ControlM> inputNames, List<ControlM> lines) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.inputNames = inputNames;
            this.lines = lines;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<ControlM> getInputNames() {
            return this.inputNames;
        }

        public List<ControlM> getLines() {
            return this.lines;
        }

        public String toString() {
            return "ControlM.InputSection(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", inputNames=" + this.getInputNames() + ", lines=" + this.getLines() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputSection)) {
                return false;
            }
            InputSection other = (InputSection)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public InputSection withId(UUID id) {
            return this.id == id ? this : new InputSection(id, this.prefix, this.markers, this.inputNames, this.lines);
        }

        public InputSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new InputSection(this.id, prefix, this.markers, this.inputNames, this.lines);
        }

        public InputSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new InputSection(this.id, this.prefix, markers, this.inputNames, this.lines);
        }

        public InputSection withInputNames(List<ControlM> inputNames) {
            return this.inputNames == inputNames ? this : new InputSection(this.id, this.prefix, this.markers, inputNames, this.lines);
        }

        public InputSection withLines(List<ControlM> lines) {
            return this.lines == lines ? this : new InputSection(this.id, this.prefix, this.markers, this.inputNames, lines);
        }
    }

    public static final class ScheduleSection
    implements ControlM,
    Section {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ControlM> lines;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitScheduleSection(this, p);
        }

        public ScheduleSection(UUID id, Space prefix, Markers markers, List<ControlM> lines) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lines = lines;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<ControlM> getLines() {
            return this.lines;
        }

        public String toString() {
            return "ControlM.ScheduleSection(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lines=" + this.getLines() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScheduleSection)) {
                return false;
            }
            ScheduleSection other = (ScheduleSection)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ScheduleSection withId(UUID id) {
            return this.id == id ? this : new ScheduleSection(id, this.prefix, this.markers, this.lines);
        }

        public ScheduleSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScheduleSection(this.id, prefix, this.markers, this.lines);
        }

        public ScheduleSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScheduleSection(this.id, this.prefix, markers, this.lines);
        }

        public ScheduleSection withLines(List<ControlM> lines) {
            return this.lines == lines ? this : new ScheduleSection(this.id, this.prefix, this.markers, lines);
        }
    }

    public static class SetVar
    implements ControlM {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String setVar;
        private final Word varName;
        private final ControlMLeftPadded<Word> value;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitSetVar(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetVar)) {
                return false;
            }
            SetVar other = (SetVar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetVar;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        private SetVar(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, String setVar, Word varName, ControlMLeftPadded<Word> value) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.setVar = setVar;
            this.varName = varName;
            this.value = value;
        }

        public SetVar(UUID id, Space prefix, Markers markers, String setVar, Word varName, ControlMLeftPadded<Word> value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.setVar = setVar;
            this.varName = varName;
            this.value = value;
        }

        public SetVar withId(UUID id) {
            return this.id == id ? this : new SetVar(this.padding, id, this.prefix, this.markers, this.setVar, this.varName, this.value);
        }

        public UUID getId() {
            return this.id;
        }

        public SetVar withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SetVar(this.padding, this.id, prefix, this.markers, this.setVar, this.varName, this.value);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public SetVar withMarkers(Markers markers) {
            return this.markers == markers ? this : new SetVar(this.padding, this.id, this.prefix, markers, this.setVar, this.varName, this.value);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public SetVar withSetVar(String setVar) {
            return this.setVar == setVar ? this : new SetVar(this.padding, this.id, this.prefix, this.markers, setVar, this.varName, this.value);
        }

        public String getSetVar() {
            return this.setVar;
        }

        public SetVar withVarName(Word varName) {
            return this.varName == varName ? this : new SetVar(this.padding, this.id, this.prefix, this.markers, this.setVar, varName, this.value);
        }

        public Word getVarName() {
            return this.varName;
        }

        public SetVar withValue(ControlMLeftPadded<Word> value) {
            return this.value == value ? this : new SetVar(this.padding, this.id, this.prefix, this.markers, this.setVar, this.varName, value);
        }

        public ControlMLeftPadded<Word> getValue() {
            return this.value;
        }

        public static class Padding {
            private final SetVar t;

            @Nullable
            public ControlMLeftPadded<Word> getValue() {
                return this.t.value;
            }

            public SetVar withValue(@Nullable ControlMLeftPadded<Word> value) {
                return this.t.value == value ? this.t : new SetVar(this.t.id, this.t.prefix, this.t.markers, this.t.setVar, this.t.varName, value);
            }

            public Padding(SetVar t) {
                this.t = t;
            }
        }
    }

    public static final class Description
    implements ControlM {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String word;
        private final List<Word> description;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitDescription(this, p);
        }

        public Description(UUID id, Space prefix, Markers markers, String word, List<Word> description) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
            this.description = description;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getWord() {
            return this.word;
        }

        public List<Word> getDescription() {
            return this.description;
        }

        public String toString() {
            return "ControlM.Description(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ", description=" + this.getDescription() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description other = (Description)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Description withId(UUID id) {
            return this.id == id ? this : new Description(id, this.prefix, this.markers, this.word, this.description);
        }

        public Description withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Description(this.id, prefix, this.markers, this.word, this.description);
        }

        public Description withMarkers(Markers markers) {
            return this.markers == markers ? this : new Description(this.id, this.prefix, markers, this.word, this.description);
        }

        public Description withWord(String word) {
            return this.word == word ? this : new Description(this.id, this.prefix, this.markers, word, this.description);
        }

        public Description withDescription(List<Word> description) {
            return this.description == description ? this : new Description(this.id, this.prefix, this.markers, this.word, description);
        }
    }

    public static final class DefinitionSection
    implements ControlM,
    Section {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<ControlM> lines;

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitDefinitionSection(this, p);
        }

        public DefinitionSection(UUID id, Space prefix, Markers markers, List<ControlM> lines) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lines = lines;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<ControlM> getLines() {
            return this.lines;
        }

        public String toString() {
            return "ControlM.DefinitionSection(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lines=" + this.getLines() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefinitionSection)) {
                return false;
            }
            DefinitionSection other = (DefinitionSection)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DefinitionSection withId(UUID id) {
            return this.id == id ? this : new DefinitionSection(id, this.prefix, this.markers, this.lines);
        }

        public DefinitionSection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DefinitionSection(this.id, prefix, this.markers, this.lines);
        }

        public DefinitionSection withMarkers(Markers markers) {
            return this.markers == markers ? this : new DefinitionSection(this.id, this.prefix, markers, this.lines);
        }

        public DefinitionSection withLines(List<ControlM> lines) {
            return this.lines == lines ? this : new DefinitionSection(this.id, this.prefix, this.markers, lines);
        }
    }

    public static final class CompilationUnit
    implements ControlM,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<Section> sections;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> ControlM acceptControlM(ControlMVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new ControlMPrinter();
        }

        public CompilationUnit(UUID id, Path sourcePath, FileAttributes fileAttributes, Space prefix, Markers markers, String charsetName, boolean charsetBomMarked, Checksum checksum, List<Section> sections, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.sections = sections;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public List<Section> getSections() {
            return this.sections;
        }

        public Space getEof() {
            return this.eof;
        }

        public String toString() {
            return "ControlM.CompilationUnit(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", sections=" + this.getSections() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.sections, this.eof);
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.id, sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.sections, this.eof);
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.id, this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.sections, this.eof);
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.sections, this.eof);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.sections, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.sections, this.eof);
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.sections, this.eof);
        }

        public CompilationUnit withSections(List<Section> sections) {
            return this.sections == sections ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, sections, this.eof);
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.sections, eof);
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.sections, this.eof);
        }
    }
}

