/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class JclLineReader {
    private static final Set<String> JCL_STATEMENT_NAMES = new HashSet<String>(Arrays.asList("JOB", "JCLLIB", "CNTL", "ENDCNTL", "DD", "EXEC", "EXPORT", "IF", "INCLUDE", "NOTIFY", "OUTPUT", "PEND", "PROC", "SCHEDULE", "SET", "XMIT"));

    public static String readLines(String source) {
        StringBuilder p = new StringBuilder();
        int cursor = 0;
        JclLineContext jclLineContext = JclLineContext.NORM;
        Scanner scanner = new Scanner(source);
        while (scanner.hasNextLine()) {
            String endOfLine;
            String line = scanner.nextLine();
            String trailingComment = null;
            String commentArea = null;
            LineType lineType = JclLineReader.getLineType(line);
            if (line.length() > 72) {
                commentArea = line.substring(72);
                line = line.substring(0, 72);
            }
            if (lineType == LineType.JES2) {
                if (jclLineContext == JclLineContext.STREAM) {
                    p.append("^^STREAM_END^^");
                } else if (jclLineContext == JclLineContext.CONT) {
                    p.append("^^JES2_CONT^^");
                } else {
                    p.append("^^JES2^^");
                }
                jclLineContext = JclLineReader.getLineContext(line);
            } else if (lineType == LineType.JES3) {
                if (jclLineContext == JclLineContext.CONT) {
                    p.append("^^JES3_CONT^^");
                } else {
                    p.append("^^JES3^^");
                }
                jclLineContext = JclLineReader.getLineContext(line);
            } else if (lineType == LineType.JCL) {
                if (jclLineContext == JclLineContext.CONT) {
                    p.append("^^JCL_CONT^^");
                } else {
                    p.append("^^JCL^^");
                }
                jclLineContext = JclLineReader.getLineContext(line);
            } else if (lineType == LineType.JCL_STATEMENT) {
                p.append("^^JCL_STATEMENT^^");
                jclLineContext = JclLineReader.getLineContext(line);
                if (jclLineContext == JclLineContext.STREAM) {
                    int i;
                    boolean inDD = false;
                    int asteriskCount = 0;
                    for (i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (inDD) {
                            if (c == '*') {
                                ++asteriskCount;
                            }
                            if (asteriskCount == 2) break;
                        }
                        if (c != 'D' || i - 2 <= 0 || line.charAt(i - 1) != 'D' || line.charAt(i - 2) != ' ' && line.charAt(i - 2) != '\t' || i + 1 >= line.length() || line.charAt(i + 1) != ' ' && line.charAt(i + 1) != '\t') continue;
                        inDD = true;
                    }
                    if (asteriskCount == 2) {
                        trailingComment = line.substring(i);
                        line = line.substring(0, i);
                    }
                }
                jclLineContext = JclLineReader.getLineContext(line);
            } else if (lineType == LineType.COMMENT) {
                p.append("^^COMMENT^^");
                if (jclLineContext != JclLineContext.CONT) {
                    jclLineContext = null;
                }
            } else if (line.trim().startsWith("%%")) {
                p.append("^^CM^^");
                jclLineContext = null;
            } else if (jclLineContext == JclLineContext.STREAM) {
                p.append("^^STREAM^^");
            } else {
                p.append("^^UNKNOWN^^");
                if (jclLineContext != JclLineContext.CONT) {
                    jclLineContext = null;
                }
            }
            p.append(line);
            if (trailingComment != null) {
                p.append("^^TC_START^^");
                p.append(trailingComment);
                p.append("^^TC_STOP^^");
            }
            if (commentArea != null) {
                p.append("^^CA_START^^");
                p.append(commentArea);
            }
            if ((endOfLine = source.substring(cursor += line.length() + (trailingComment == null ? 0 : trailingComment.length()) + (commentArea == null ? 0 : commentArea.length()))).startsWith("\r\n")) {
                p.append("\r\n");
                cursor += 2;
                continue;
            }
            if (!endOfLine.startsWith("\n")) continue;
            p.append("\n");
            ++cursor;
        }
        return p.toString();
    }

    private static LineType getLineType(String line) {
        int c3;
        int c0 = !line.isEmpty() ? (int)line.charAt(0) : 126;
        int c1 = line.length() > 1 ? (int)line.charAt(1) : 126;
        int c2 = line.length() > 2 ? (int)line.charAt(2) : 126;
        int n = c3 = line.length() > 3 ? (int)line.charAt(3) : 126;
        if (c0 == 47 && c1 == 47 && c2 == 42 && (c3 == 32 || c3 == 126 || c3 == 42 || c3 == 61 || c3 == 45 || c3 == 47 || c3 == 13 || c3 == 10)) {
            return LineType.COMMENT;
        }
        if (c0 == 47 && c1 == 47 && c2 == 42) {
            return LineType.JES3;
        }
        if (c0 == 47 && c1 == 47) {
            String[] words = line.split("\\s+");
            return words.length >= 2 && JCL_STATEMENT_NAMES.contains(words[1]) ? LineType.JCL_STATEMENT : LineType.JCL;
        }
        if (c0 == 47 && c1 == 42) {
            return LineType.JES2;
        }
        return LineType.UNKNOWN;
    }

    private static JclLineContext getLineContext(String line) {
        if (line.trim().endsWith(",")) {
            return JclLineContext.CONT;
        }
        int tickCount = 0;
        boolean checkDD = false;
        char[] charArray = line.trim().toCharArray();
        int prev = 126;
        for (int i = charArray.length - 1; i >= 0; --i) {
            int c = charArray[i];
            if (checkDD) {
                if (Character.isWhitespace((char)c)) {
                    prev = c;
                    continue;
                }
                if (c == 68 && prev == 68 && i - 1 >= 0 && (charArray[i - 1] == ' ' || charArray[i - 1] == '\t')) {
                    return JclLineContext.STREAM;
                }
                if (c != 68) {
                    checkDD = false;
                }
            }
            if (c == 42) {
                checkDD = true;
            }
            if (c == 39) {
                ++tickCount;
            }
            prev = c;
        }
        return tickCount % 2 == 0 ? JclLineContext.NORM : JclLineContext.CONT;
    }

    private static enum JclLineContext {
        NORM,
        CONT,
        STREAM,
        CM_CONT;

    }

    private static enum LineType {
        JCL_STATEMENT("//"),
        JCL("//"),
        JES2("/*"),
        JES3("//*"),
        COMMENT("//* "),
        UNKNOWN("");

        private final String prefix;

        private LineType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

