/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.internal.grammar.JCLParser;
import org.openrewrite.jcl.internal.grammar.JCLParserBaseVisitor;
import org.openrewrite.jcl.marker.CommentArea;
import org.openrewrite.jcl.marker.TrailingComment;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.jcl.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JclParserVisitor
extends JCLParserBaseVisitor<Jcl> {
    private final Path path;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private int cursor = 0;

    public JclParserVisitor(Path path, @Nullable FileAttributes fileAttributes, String source, Charset charset, boolean charsetBomMarked) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
    }

    public <T> T visit(ParseTree ... trees) {
        for (ParseTree tree : trees) {
            if (tree == null) continue;
            return (T)this.visit(tree);
        }
        throw new IllegalStateException("Expected one of the supplied trees to be non-null");
    }

    @Override
    public Jcl.CompilationUnit visitCompilationUnit(JCLParser.CompilationUnitContext ctx) {
        ArrayList<Statement> statements = new ArrayList<Statement>(ctx.statement().size());
        for (JCLParser.StatementContext statement : ctx.statement()) {
            statements.add((Statement)this.visitStatement(statement));
        }
        return new Jcl.CompilationUnit(Tree.randomId(), this.path, this.fileAttributes, Space.EMPTY, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, statements, Space.build(this.source.substring(this.cursor)));
    }

    @Override
    public Jcl visitCommentWord(JCLParser.CommentWordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = (Jcl.Word)this.visit(new ParseTree[]{ctx.COMMENT_TEXT(), ctx.COMMENT_STRINGLITERAL()});
        if (ctx.commentCommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.commentCommentArea()));
        }
        return new Jcl.Comment(Tree.randomId(), prefix, markers, word);
    }

    @Override
    public Jcl visitControlMWord(JCLParser.ControlMWordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = (Jcl.Word)this.visit(new ParseTree[]{ctx.CM_TEXT(), ctx.CM_STRINGLITERAL()});
        if (ctx.controlMCommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.controlMCommentArea()));
        }
        return new Jcl.ControlM(Tree.randomId(), prefix, markers, word);
    }

    @Override
    public Jcl visitJclWord(JCLParser.JclWordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = (Jcl.Word)this.visit(new ParseTree[]{ctx.JCL_TEXT(), ctx.JCL_STRINGLITERAL()});
        if (ctx.jclCommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.jclCommentArea()));
        }
        return new Jcl.JclStatement(Tree.randomId(), prefix, markers, word);
    }

    @Override
    public Jcl visitJclTrailingComment(JCLParser.JclTrailingCommentContext ctx) {
        Markers markers = Markers.EMPTY;
        Jcl.JclStatement jclStatement = (Jcl.JclStatement)this.visit((ParseTree)ctx.jclWord(0));
        markers = markers.addIfAbsent((Marker)this.mapTrailingComment(ctx.jclWord().subList(1, ctx.jclWord().size())));
        if (ctx.jclCommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.jclCommentArea()));
        }
        return jclStatement.withMarkers(markers);
    }

    @Override
    public Jcl visitJes2Word(JCLParser.Jes2WordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = (Jcl.Word)this.visit(new ParseTree[]{ctx.JES2_TEXT(), ctx.JES2_STRINGLITERAL()});
        if (ctx.jes2CommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.jes2CommentArea()));
        }
        return new Jcl.Jes2(Tree.randomId(), prefix, markers, word);
    }

    @Override
    public Jcl visitJes3Word(JCLParser.Jes3WordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = (Jcl.Word)this.visit(new ParseTree[]{ctx.JES3_TEXT(), ctx.JES3_STRINGLITERAL()});
        if (ctx.jes3CommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.jes3CommentArea()));
        }
        return new Jcl.Jes3(Tree.randomId(), prefix, markers, word);
    }

    @Override
    public Jcl visitStreamWord(JCLParser.StreamWordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = (Jcl.Word)this.visit(new ParseTree[]{ctx.STREAM_TEXT(), ctx.STREAM_STRINGLITERAL()});
        if (ctx.streamCommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.streamCommentArea()));
        }
        return new Jcl.DataDefinitionStream(Tree.randomId(), prefix, markers, word);
    }

    @Override
    public Jcl visitUnknownWord(JCLParser.UnknownWordContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Jcl.Word word = ctx.UNKNOWN_TEXT() == null && ctx.UNKNOWN_STRINGLITERAL() == null ? new Jcl.Word(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "") : (Jcl.Word)this.visit(new ParseTree[]{ctx.UNKNOWN_TEXT(), ctx.UNKNOWN_STRINGLITERAL()});
        if (ctx.unknownCommentArea() != null) {
            markers = markers.addIfAbsent((Marker)this.mapCommentArea(ctx.unknownCommentArea()));
        }
        return new Jcl.Unknown(Tree.randomId(), prefix, markers, word);
    }

    public Jcl visitTerminal(TerminalNode node) {
        return new Jcl.Word(Tree.randomId(), this.sourceBefore(node.getText()), Markers.EMPTY, node.getText());
    }

    private CommentArea mapCommentArea(ParserRuleContext ctx) {
        return new CommentArea(Tree.randomId(), this.sourceBefore(ctx.getChild(ctx.getChildCount() - 1).getText()), ctx.getChild(ctx.getChildCount() - 1).getText());
    }

    private TrailingComment mapTrailingComment(List<JCLParser.JclWordContext> rules) {
        Space prefix = this.whitespace();
        StringBuilder trailingComment = new StringBuilder();
        for (ParserRuleContext parserRuleContext : rules) {
            trailingComment.append(this.sourceBefore(parserRuleContext.getText()).getWhitespace());
            trailingComment.append(parserRuleContext.getText());
        }
        return new TrailingComment(Tree.randomId(), prefix, trailingComment.toString());
    }

    private void skip(@Nullable String token) {
        if (token != null && this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
    }

    private Space whitespace() {
        int endIndex = JclParserVisitor.indexOfNextNonWhitespace(this.cursor, this.source);
        String prefix = this.source.substring(this.cursor, endIndex);
        this.cursor += prefix.length();
        return Space.build(prefix);
    }

    private Space sourceBefore(String untilDelim) {
        Space prefix = this.whitespace();
        this.skip(untilDelim);
        return Space.build(prefix.getWhitespace());
    }

    public static int indexOfNextNonWhitespace(int cursor, String source) {
        int delimIndex;
        for (delimIndex = cursor; delimIndex < source.length() && Character.isWhitespace(source.charAt(delimIndex)); ++delimIndex) {
        }
        return delimIndex;
    }
}

