/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.internal;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.JclVisitor;
import org.openrewrite.jcl.marker.CommentArea;
import org.openrewrite.jcl.marker.TrailingComment;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JclPrinter<P>
extends JclVisitor<PrintOutputCapture<P>> {
    public static final UnaryOperator<String> JCL_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    public Jcl.CompilationUnit visitCompilationUnit(Jcl.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax(cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visit(cu.getStatements(), p);
        this.afterSyntax(cu, p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        return cu;
    }

    @Override
    public Jcl visitComment(Jcl.Comment comment, PrintOutputCapture<P> p) {
        this.beforeSyntax(comment, Space.Location.COMMENT_PREFIX, p);
        this.visit(comment.getWord(), p);
        this.afterSyntax(comment, p);
        return comment;
    }

    @Override
    public Jcl visitControlM(Jcl.ControlM controlM, PrintOutputCapture<P> p) {
        this.beforeSyntax(controlM, Space.Location.CONTROL_M_PREFIX, p);
        this.visit(controlM.getWord(), p);
        this.afterSyntax(controlM, p);
        return controlM;
    }

    @Override
    public Jcl visitDataDefinitionStream(Jcl.DataDefinitionStream ddStream, PrintOutputCapture<P> p) {
        this.beforeSyntax(ddStream, Space.Location.DATA_DEFINITION_STREAM_PREFIX, p);
        this.visit(ddStream.getWord(), p);
        this.afterSyntax(ddStream, p);
        return ddStream;
    }

    @Override
    public Jcl visitJclStatement(Jcl.JclStatement jclStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(jclStatement, Space.Location.JCL_STATEMENT_PREFIX, p);
        this.visit(jclStatement.getWord(), p);
        this.afterSyntax(jclStatement, p);
        return jclStatement;
    }

    @Override
    public Jcl visitJes2(Jcl.Jes2 jes2, PrintOutputCapture<P> p) {
        this.beforeSyntax(jes2, Space.Location.JES2_PREFIX, p);
        this.visit(jes2.getWord(), p);
        this.afterSyntax(jes2, p);
        return jes2;
    }

    @Override
    public Jcl visitJes3(Jcl.Jes3 jes3, PrintOutputCapture<P> p) {
        this.beforeSyntax(jes3, Space.Location.JES2_PREFIX, p);
        this.visit(jes3.getWord(), p);
        this.afterSyntax(jes3, p);
        return jes3;
    }

    @Override
    public Jcl visitUnknown(Jcl.Unknown unknown, PrintOutputCapture<P> p) {
        this.beforeSyntax(unknown, Space.Location.UNKNOWN_PREFIX, p);
        this.visit(unknown.getWord(), p);
        this.afterSyntax(unknown, p);
        return unknown;
    }

    @Override
    public Jcl visitWord(Jcl.Word word, PrintOutputCapture<P> p) {
        this.beforeSyntax(word, Space.Location.WORD_PREFIX, p);
        p.append(word.getText());
        this.afterSyntax(word, p);
        return word;
    }

    @Override
    public Space visitSpace(Space space, Space.Location location, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        return space;
    }

    protected void beforeSyntax(Jcl c, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(c.getPrefix(), c.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JCL_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JCL_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(Jcl c, PrintOutputCapture<P> p) {
        this.afterSyntax(c.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            if (marker instanceof TrailingComment) {
                TrailingComment tc = (TrailingComment)marker;
                this.visitSpace(tc.getPrefix(), Space.Location.TRAILING_COMMENT_PREFIX, p);
                p.append(tc.getComment());
            } else if (marker instanceof CommentArea) {
                CommentArea ca = (CommentArea)marker;
                this.visitSpace(ca.getPrefix(), Space.Location.COMMENT_AREA_PREFIX, p);
                p.append(ca.getComment());
            }
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JCL_MARKER_WRAPPER));
        }
    }
}

