/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.JclVisitor;
import org.openrewrite.jcl.internal.JclPrinter;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.jcl.tree.Statement;
import org.openrewrite.marker.Markers;

public interface Jcl
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJcl((JclVisitor)v.adapt(JclVisitor.class), p);
    }

    @Nullable
    default public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
        return (Jcl)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JclVisitor.class);
    }

    public Space getPrefix();

    public <P extends Jcl> P withPrefix(Space var1);

    public static final class Word
    implements Jcl {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String text;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitWord(this, p);
        }

        public Word(UUID id, Space prefix, Markers markers, String text) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.text = text;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Jcl.Word(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Word)) {
                return false;
            }
            Word other = (Word)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Word withId(UUID id) {
            return this.id == id ? this : new Word(id, this.prefix, this.markers, this.text);
        }

        public Word withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Word(this.id, prefix, this.markers, this.text);
        }

        public Word withMarkers(Markers markers) {
            return this.markers == markers ? this : new Word(this.id, this.prefix, markers, this.text);
        }

        public Word withText(String text) {
            return this.text == text ? this : new Word(this.id, this.prefix, this.markers, text);
        }
    }

    public static final class Unknown
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitUnknown(this, p);
        }

        public Unknown(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.Unknown(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unknown)) {
                return false;
            }
            Unknown other = (Unknown)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Unknown withId(UUID id) {
            return this.id == id ? this : new Unknown(id, this.prefix, this.markers, this.word);
        }

        public Unknown withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unknown(this.id, prefix, this.markers, this.word);
        }

        public Unknown withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unknown(this.id, this.prefix, markers, this.word);
        }

        public Unknown withWord(Word word) {
            return this.word == word ? this : new Unknown(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class Jes3
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitJes3(this, p);
        }

        public Jes3(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.Jes3(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jes3)) {
                return false;
            }
            Jes3 other = (Jes3)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Jes3 withId(UUID id) {
            return this.id == id ? this : new Jes3(id, this.prefix, this.markers, this.word);
        }

        public Jes3 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Jes3(this.id, prefix, this.markers, this.word);
        }

        public Jes3 withMarkers(Markers markers) {
            return this.markers == markers ? this : new Jes3(this.id, this.prefix, markers, this.word);
        }

        public Jes3 withWord(Word word) {
            return this.word == word ? this : new Jes3(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class Jes2
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitJes2(this, p);
        }

        public Jes2(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.Jes2(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jes2)) {
                return false;
            }
            Jes2 other = (Jes2)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Jes2 withId(UUID id) {
            return this.id == id ? this : new Jes2(id, this.prefix, this.markers, this.word);
        }

        public Jes2 withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Jes2(this.id, prefix, this.markers, this.word);
        }

        public Jes2 withMarkers(Markers markers) {
            return this.markers == markers ? this : new Jes2(this.id, this.prefix, markers, this.word);
        }

        public Jes2 withWord(Word word) {
            return this.word == word ? this : new Jes2(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class JclStatement
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitJclStatement(this, p);
        }

        public JclStatement(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.JclStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JclStatement)) {
                return false;
            }
            JclStatement other = (JclStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public JclStatement withId(UUID id) {
            return this.id == id ? this : new JclStatement(id, this.prefix, this.markers, this.word);
        }

        public JclStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JclStatement(this.id, prefix, this.markers, this.word);
        }

        public JclStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new JclStatement(this.id, this.prefix, markers, this.word);
        }

        public JclStatement withWord(Word word) {
            return this.word == word ? this : new JclStatement(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class DataDefinitionStream
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitDataDefinitionStream(this, p);
        }

        public DataDefinitionStream(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.DataDefinitionStream(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataDefinitionStream)) {
                return false;
            }
            DataDefinitionStream other = (DataDefinitionStream)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DataDefinitionStream withId(UUID id) {
            return this.id == id ? this : new DataDefinitionStream(id, this.prefix, this.markers, this.word);
        }

        public DataDefinitionStream withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DataDefinitionStream(this.id, prefix, this.markers, this.word);
        }

        public DataDefinitionStream withMarkers(Markers markers) {
            return this.markers == markers ? this : new DataDefinitionStream(this.id, this.prefix, markers, this.word);
        }

        public DataDefinitionStream withWord(Word word) {
            return this.word == word ? this : new DataDefinitionStream(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class ControlM
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitControlM(this, p);
        }

        public ControlM(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.ControlM(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlM)) {
                return false;
            }
            ControlM other = (ControlM)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ControlM withId(UUID id) {
            return this.id == id ? this : new ControlM(id, this.prefix, this.markers, this.word);
        }

        public ControlM withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ControlM(this.id, prefix, this.markers, this.word);
        }

        public ControlM withMarkers(Markers markers) {
            return this.markers == markers ? this : new ControlM(this.id, this.prefix, markers, this.word);
        }

        public ControlM withWord(Word word) {
            return this.word == word ? this : new ControlM(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class Comment
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Word word;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitComment(this, p);
        }

        public Comment(UUID id, Space prefix, Markers markers, Word word) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.word = word;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Word getWord() {
            return this.word;
        }

        public String toString() {
            return "Jcl.Comment(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", word=" + this.getWord() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Comment withId(UUID id) {
            return this.id == id ? this : new Comment(id, this.prefix, this.markers, this.word);
        }

        public Comment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Comment(this.id, prefix, this.markers, this.word);
        }

        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.prefix, markers, this.word);
        }

        public Comment withWord(Word word) {
            return this.word == word ? this : new Comment(this.id, this.prefix, this.markers, word);
        }
    }

    public static final class CompilationUnit
    implements Jcl,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<Statement> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JclPrinter();
        }

        public CompilationUnit(UUID id, Path sourcePath, FileAttributes fileAttributes, Space prefix, Markers markers, String charsetName, boolean charsetBomMarked, Checksum checksum, List<Statement> statements, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.statements = statements;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public Space getEof() {
            return this.eof;
        }

        public String toString() {
            return "Jcl.CompilationUnit(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.id, sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.id, this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.statements, this.eof);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, statements, this.eof);
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, eof);
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }
    }
}

