/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.openrewrite.internal.lang.Nullable;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Space {
    public static final Space EMPTY = new Space("");
    @Nullable
    private final String whitespace;
    private static final Map<String, Space> flyweights = Collections.synchronizedMap(new WeakHashMap());
    private static final String[] spaces = new String[]{"\u00b7\u2081", "\u00b7\u2082", "\u00b7\u2083", "\u00b7\u2084", "\u00b7\u2085", "\u00b7\u2086", "\u00b7\u2087", "\u00b7\u2088", "\u00b7\u2089", "\u00b7\u208a"};
    private static final String[] tabs = new String[]{"-\u2081", "-\u2082", "-\u2083", "-\u2084", "-\u2085", "-\u2086", "-\u2087", "-\u2088", "-\u2089", "-\u208a"};

    private Space(@Nullable String whitespace) {
        this.whitespace = whitespace == null || whitespace.isEmpty() ? null : whitespace;
    }

    @JsonCreator
    public static Space build(@Nullable String whitespace) {
        if (whitespace == null || whitespace.isEmpty()) {
            return EMPTY;
        }
        if (whitespace.length() <= 100) {
            return flyweights.computeIfAbsent(whitespace, k -> new Space(whitespace));
        }
        return new Space(whitespace);
    }

    public String getIndent() {
        return this.getWhitespaceIndent(this.whitespace);
    }

    private String getWhitespaceIndent(@Nullable String whitespace) {
        if (whitespace == null) {
            return "";
        }
        int lastNewline = whitespace.lastIndexOf(10);
        if (lastNewline >= 0) {
            return whitespace.substring(lastNewline + 1);
        }
        if (lastNewline == whitespace.length() - 1) {
            return "";
        }
        return whitespace;
    }

    public String getWhitespace() {
        return this.whitespace == null ? "" : this.whitespace;
    }

    public Space withWhitespace(String whitespace) {
        if (whitespace.isEmpty()) {
            return EMPTY;
        }
        if (this.whitespace == null || whitespace.equals(this.whitespace)) {
            return this;
        }
        return Space.build(whitespace);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public String toString() {
        StringBuilder printedWs = new StringBuilder();
        int lastNewline = 0;
        if (this.whitespace != null) {
            char[] charArray = this.whitespace.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == '\n') {
                    printedWs.append("\\n");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == '\r') {
                    printedWs.append("\\r");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == ' ') {
                    printedWs.append(spaces[(i - lastNewline) % 10]);
                    continue;
                }
                if (c != '\t') continue;
                printedWs.append(tabs[(i - lastNewline) % 10]);
            }
        }
        return "Space(whitespace='" + printedWs + "')";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Space)) {
            return false;
        }
        Space other = (Space)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$whitespace = this.getWhitespace();
        String other$whitespace = other.getWhitespace();
        return !(this$whitespace == null ? other$whitespace != null : !this$whitespace.equals(other$whitespace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Space;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $whitespace = this.getWhitespace();
        result = result * 59 + ($whitespace == null ? 43 : $whitespace.hashCode());
        return result;
    }

    public static enum Location {
        COMPILATION_UNIT_PREFIX,
        COMPILATION_UNIT_EOF,
        COMMENT_AREA_PREFIX,
        CONTROL_M_PREFIX,
        DATA_DEFINITION_STREAM_PREFIX,
        JCL_STATEMENT_PREFIX,
        JES2_PREFIX,
        JES3_PREFIX,
        UNKNOWN_PREFIX,
        TRAILING_COMMENT_PREFIX,
        COMMENT_PREFIX,
        WORD_PREFIX;

    }
}

