/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.services;

import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.cli.CommandLineConverter;
import org.gradle.internal.logging.LoggingCommandLineConverter;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.config.LoggingConfigurer;
import org.gradle.internal.logging.config.LoggingSystemAdapter;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.services.DefaultLoggingManagerFactory;
import org.gradle.internal.logging.services.DefaultStyledTextOutputFactory;
import org.gradle.internal.logging.services.TextStreamOutputEventListener;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.logging.slf4j.Slf4jLoggingConfigurer;
import org.gradle.internal.logging.source.DefaultStdErrLoggingSystem;
import org.gradle.internal.logging.source.DefaultStdOutLoggingSystem;
import org.gradle.internal.logging.source.JavaUtilLoggingSystem;
import org.gradle.internal.logging.source.NoOpLoggingSystem;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;

public abstract class LoggingServiceRegistry
extends DefaultServiceRegistry {
    public static final Object NO_OP = new Object(){

        OutputEventListener createOutputEventListener() {
            return OutputEventListener.NO_OP;
        }
    };
    private TextStreamOutputEventListener stdoutListener;
    protected final OutputEventRenderer renderer = this.makeOutputEventRenderer();
    protected final OutputEventListenerManager outputEventListenerManager = new OutputEventListenerManager(this.renderer);

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        CommandLineLogging loggingServices = new CommandLineLogging();
        LoggingManagerInternal rootLoggingManager = loggingServices.get(DefaultLoggingManagerFactory.class).getRoot();
        rootLoggingManager.captureSystemSources();
        rootLoggingManager.attachSystemOutAndErr();
        return loggingServices;
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new CommandLineLogging();
    }

    public static LoggingServiceRegistry newNestedLogging() {
        return new NestedLogging();
    }

    protected CommandLineConverter<LoggingConfiguration> createCommandLineConverter() {
        return new LoggingCommandLineConverter();
    }

    protected Clock createTimeProvider() {
        return Time.clock();
    }

    protected StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.getStdoutListener(), this.get(Clock.class));
    }

    protected TextStreamOutputEventListener getStdoutListener() {
        if (this.stdoutListener == null) {
            this.stdoutListener = new TextStreamOutputEventListener(this.get(OutputEventListenerManager.class).getBroadcaster());
        }
        return this.stdoutListener;
    }

    protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
        OutputEventListener outputEventBroadcaster = this.outputEventListenerManager.getBroadcaster();
        DefaultStdOutLoggingSystem stdout = new DefaultStdOutLoggingSystem(this.getStdoutListener(), this.get(Clock.class));
        stdout.setLevel(LogLevel.QUIET);
        DefaultStdErrLoggingSystem stderr = new DefaultStdErrLoggingSystem(new TextStreamOutputEventListener(outputEventBroadcaster), this.get(Clock.class));
        stderr.setLevel(LogLevel.ERROR);
        return new DefaultLoggingManagerFactory(this.renderer, new LoggingSystemAdapter((LoggingConfigurer)new Slf4jLoggingConfigurer(outputEventBroadcaster)), new JavaUtilLoggingSystem(), stdout, stderr);
    }

    protected OutputEventListener createOutputEventListener(OutputEventListenerManager manager) {
        return manager.getBroadcaster();
    }

    protected OutputEventListenerManager createOutputEventListenerManager() {
        return this.outputEventListenerManager;
    }

    protected OutputEventRenderer makeOutputEventRenderer() {
        return new OutputEventRenderer(Time.clock());
    }

    private static class NestedLogging
    extends LoggingServiceRegistry {
        private NestedLogging() {
        }

        @Override
        protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
            return new DefaultLoggingManagerFactory(this.renderer, new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem());
        }
    }

    private static class CommandLineLogging
    extends LoggingServiceRegistry {
        private CommandLineLogging() {
        }
    }
}

