/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyVersion
extends Recipe {
    @Option(displayName="Dependency pattern", description="A dependency pattern specifying which dependencies should have their groupId updated. Dependency patterns are a concise way of describing which dependencies are applicable to a recipe. Valid dependency patterns take one of these forms:\n\n* groupId:artifactId\n* groupId:artifactId:versionSelector\n* groupId:artifactId:versionSelector/versionPattern\n\n\"groupId\" and \"artifactId\" accept glob patterns.\n\"versionSelector\" accepts both literal version numbers and semver selectors.\n\"versionPattern\" is used for artifacts that encode variant/platform information in their version.Guava is a common example of such a library. Guava appends \"-jre\" or \"-android\" to its version to indicate platform compatibility.", example="com.fasterxml.jackson*:*")
    private final String dependencyPattern;
    @Option(displayName="New Version", description="The version number to update the dependency to", example="1.0")
    private final String newVersion;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Change a Gradle dependency version";
    }

    public String getDescription() {
        return "Finds dependencies declared in `build.gradle` files.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    protected GroovyVisitor<ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            {
                this.depMatcher = (DependencyMatcher)DependencyMatcher.build((String)ChangeDependencyVersion.this.dependencyPattern).getValue();
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!this.dependencyDsl.matches(m) || ChangeDependencyVersion.this.configuration != null && !m.getSimpleName().equals(ChangeDependencyVersion.this.configuration)) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    String[] gavs;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (gavs = gav.split(":")).length >= 3 && !ChangeDependencyVersion.this.newVersion.equals(gavs[2]) && this.depMatcher.matches(gavs[0], gavs[1], gavs[2])) {
                        String newGav = gavs[0] + ":" + gavs[1] + ":" + ChangeDependencyVersion.this.newVersion;
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), (n, arg) -> n == 0 ? ChangeStringLiteral.withStringValue((J.Literal)arg, newGav) : arg));
                    }
                } else if (depArgs.get(0) instanceof G.MapEntry) {
                    G.MapEntry versionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    String versionStringDelimiter = "'";
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if ("name".equals(keyValue)) {
                            artifactId = valueValue;
                            continue;
                        }
                        if (!"version".equals(keyValue) || ChangeDependencyVersion.this.newVersion.equals(valueValue)) continue;
                        if (value.getValueSource() != null) {
                            versionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                        }
                        versionEntry = arg2;
                        version = valueValue;
                    }
                    if (groupId == null || artifactId == null || version == null && !this.depMatcher.matches(groupId, artifactId) || version != null && !this.depMatcher.matches(groupId, artifactId, version)) {
                        return m;
                    }
                    String delimiter = versionStringDelimiter;
                    G.MapEntry finalVersion = versionEntry;
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                        if (arg == finalVersion) {
                            return finalVersion.withValue((Expression)((J.Literal)finalVersion.getValue()).withValue((Object)ChangeDependencyVersion.this.newVersion).withValueSource(delimiter + ChangeDependencyVersion.this.newVersion + delimiter));
                        }
                        return arg;
                    }));
                }
                return m;
            }
        };
    }

    public ChangeDependencyVersion(String dependencyPattern, String newVersion, @Nullable String configuration) {
        this.dependencyPattern = dependencyPattern;
        this.newVersion = newVersion;
        this.configuration = configuration;
    }

    public String getDependencyPattern() {
        return this.dependencyPattern;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyVersion(dependencyPattern=" + this.getDependencyPattern() + ", newVersion=" + this.getNewVersion() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyVersion)) {
            return false;
        }
        ChangeDependencyVersion other = (ChangeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dependencyPattern = this.getDependencyPattern();
        String other$dependencyPattern = other.getDependencyPattern();
        if (this$dependencyPattern == null ? other$dependencyPattern != null : !this$dependencyPattern.equals(other$dependencyPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dependencyPattern = this.getDependencyPattern();
        result = result * 59 + ($dependencyPattern == null ? 43 : $dependencyPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

