/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradePluginVersion
extends Recipe {
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`, as a glob expression.", example="com.jfrog.bintray")
    private final String pluginIdPattern;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Update a Gradle plugin by id";
    }

    public String getDescription() {
        return "Update a Gradle plugin by id to a later version.";
    }

    public Validated validate() {
        return super.validate().and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                List pluginArgs;
                if (versionMatcher.matches(method) && method.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(method.getSelect()) && (pluginArgs = ((J.MethodInvocation)method.getSelect()).getArguments()).get(0) instanceof J.Literal) {
                    String currentVersion;
                    List versionArgs;
                    String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                    assert (pluginId != null);
                    if (StringUtils.matchesGlob((String)pluginId, (String)UpgradePluginVersion.this.pluginIdPattern) && (versionArgs = method.getArguments()).get(0) instanceof J.Literal && (currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue()) != null) {
                        return (J)versionComparator.upgrade(currentVersion, UpgradePluginVersion.availablePluginVersions(pluginId, ctx)).map(upgradeVersion -> method.withArguments(ListUtils.map((List)versionArgs, v -> {
                            J.Literal versionLiteral = (J.Literal)v;
                            assert (versionLiteral.getValueSource() != null);
                            return versionLiteral.withValue(upgradeVersion).withValueSource(versionLiteral.getValueSource().replace(currentVersion, (CharSequence)upgradeVersion));
                        }))).orElse(method);
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> availablePluginVersions(String pluginId, ExecutionContext ctx) {
        String uri = "https://plugins.gradle.org/plugin/" + pluginId;
        HttpSender httpSender = HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender();
        try (HttpSender.Response response = httpSender.send(httpSender.get(uri).build());){
            if (!response.isSuccessful()) return Collections.emptyList();
            String responseBody = StringUtils.readFully((InputStream)response.getBody());
            ArrayList<String> versions = new ArrayList<String>();
            Matcher matcher = Pattern.compile("href=\"/plugin/" + pluginId + "/([^\"]+)\"").matcher(responseBody);
            int lastFind = 0;
            while (matcher.find(lastFind)) {
                versions.add(matcher.group(1));
                lastFind = matcher.end();
            }
            matcher = Pattern.compile("Version (\\S+) \\(latest\\)").matcher(responseBody);
            if (matcher.find()) {
                versions.add(matcher.group(1));
            }
            ArrayList<String> arrayList = versions;
            return arrayList;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public UpgradePluginVersion(String pluginIdPattern, String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradePluginVersion(pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

