/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public final class FindPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`.", example="`com.jfrog.bintray`")
    private final String pluginId;

    public String getDisplayName() {
        return "Find Gradle plugin";
    }

    public String getDescription() {
        return "Find a Gradle plugin by id.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        return new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (pluginMatcher.matches(method) && method.getArguments().get(0) instanceof J.Literal && FindPlugin.this.pluginId.equals(((J.Literal)method.getArguments().get(0)).getValue())) {
                    return method.withMarkers(method.getMarkers().searchResult());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    public FindPlugin(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @NonNull
    public String toString() {
        return "FindPlugin(pluginId=" + this.getPluginId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPlugin)) {
            return false;
        }
        FindPlugin other = (FindPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        return result;
    }
}

