/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.LoathingOfOthers;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.text.PlainText;

public final class AddGradleWrapper
extends Recipe {
    @Option(displayName="New version", description="An exact version number or [dependency version selector](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to the latest release version.", example="7.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. Defaults to \"bin\".", valid={"bin", "all"}, required=false)
    @Nullable
    private final String distribution;
    @Option(displayName="Repository URL", description="The URL of the repository to download the Gradle distribution from. Currently only supports repositories like services.gradle.org, not arbitrary maven or ivy repositories. Defaults to `https://services.gradle.org/versions/all`.", example="https://services.gradle.org/versions/all")
    @Nullable
    private final String repositoryUrl;
    private Validated gradleWrapper;

    public String getDisplayName() {
        return "Add Gradle wrapper";
    }

    public String getDescription() {
        return "Add a Gradle wrapper where one does not exist.";
    }

    public Validated validate(ExecutionContext ctx) {
        return super.validate(ctx).and(GradleWrapper.validate(ctx, StringUtils.isBlank((String)this.version) ? "latest.release" : this.version, this.distribution, this.gradleWrapper, this.repositoryUrl));
    }

    @LoathingOfOthers(value="JavaDoc")
    @JsonCreator
    public AddGradleWrapper(@Nullable String version, @Nullable String distribution) {
        this.version = version;
        this.distribution = distribution;
        this.repositoryUrl = null;
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new IsBuildGradle();
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        GradleWrapper gradleWrapper = (GradleWrapper)this.validate(ctx).getValue();
        assert (gradleWrapper != null);
        return AddGradleWrapper.addGradleFiles(gradleWrapper, before);
    }

    public static List<SourceFile> addGradleFiles(GradleWrapper gradleWrapper, List<SourceFile> before) {
        boolean needsGradleWrapperProperties = true;
        boolean needsGradleWrapperJar = true;
        boolean needsGradleShellScript = true;
        boolean needsGradleBatchScript = true;
        for (SourceFile sourceFile : before) {
            if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION)) {
                needsGradleWrapperProperties = false;
                continue;
            }
            if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_SCRIPT_LOCATION)) {
                needsGradleShellScript = false;
                continue;
            }
            if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_BATCH_LOCATION)) {
                needsGradleBatchScript = false;
                continue;
            }
            if (!PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_JAR_LOCATION)) continue;
            needsGradleWrapperJar = false;
        }
        if (!(needsGradleWrapperProperties || needsGradleWrapperJar || needsGradleShellScript || needsGradleBatchScript)) {
            return before;
        }
        ArrayList<Object> gradleWrapperFiles = new ArrayList<Object>();
        ZonedDateTime now = ZonedDateTime.now();
        if (needsGradleWrapperProperties) {
            Properties.File gradleWrapperProperties = ((Properties.File)new PropertiesParser().parse(new String[]{"distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\ndistributionSha256Sum=" + gradleWrapper.getDistributionChecksum().getHexValue() + "\nzipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists"}).get(0)).withSourcePath(GradleWrapper.WRAPPER_PROPERTIES_LOCATION);
            gradleWrapperFiles.add(gradleWrapperProperties);
        }
        FileAttributes wrapperScriptAttributes = new FileAttributes(now, now, now, true, true, true, 1L);
        if (needsGradleShellScript) {
            PlainText gradlew = PlainText.builder().sourcePath(GradleWrapper.WRAPPER_SCRIPT_LOCATION).fileAttributes(wrapperScriptAttributes).text(StringUtils.readFully((InputStream)Objects.requireNonNull(AddGradleWrapper.class.getResourceAsStream("/gradlew")), (Charset)StandardCharsets.UTF_8)).charsetName(StandardCharsets.UTF_8.name()).build();
            gradleWrapperFiles.add(gradlew);
        }
        if (needsGradleBatchScript) {
            PlainText gradlewBat = PlainText.builder().sourcePath(GradleWrapper.WRAPPER_BATCH_LOCATION).fileAttributes(wrapperScriptAttributes).text(StringUtils.readFully((InputStream)Objects.requireNonNull(AddGradleWrapper.class.getResourceAsStream("/gradlew.bat")), (Charset)StandardCharsets.UTF_8)).charsetName(StandardCharsets.UTF_8.name()).build();
            gradleWrapperFiles.add(gradlewBat);
        }
        if (needsGradleWrapperJar) {
            gradleWrapperFiles.add(gradleWrapper.asRemote());
        }
        return ListUtils.concatAll(before, gradleWrapperFiles);
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDistribution() {
        return this.distribution;
    }

    @Nullable
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public Validated getGradleWrapper() {
        return this.gradleWrapper;
    }

    @NonNull
    public String toString() {
        return "AddGradleWrapper(version=" + this.getVersion() + ", distribution=" + this.getDistribution() + ", repositoryUrl=" + this.getRepositoryUrl() + ", gradleWrapper=" + this.getGradleWrapper() + ")";
    }

    private AddGradleWrapper(@Nullable String version, @Nullable String distribution, @Nullable String repositoryUrl, Validated gradleWrapper) {
        this.version = version;
        this.distribution = distribution;
        this.repositoryUrl = repositoryUrl;
        this.gradleWrapper = gradleWrapper;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddGradleWrapper)) {
            return false;
        }
        AddGradleWrapper other = (AddGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        String this$repositoryUrl = this.getRepositoryUrl();
        String other$repositoryUrl = other.getRepositoryUrl();
        if (this$repositoryUrl == null ? other$repositoryUrl != null : !this$repositoryUrl.equals(other$repositoryUrl)) {
            return false;
        }
        Validated this$gradleWrapper = this.getGradleWrapper();
        Validated other$gradleWrapper = other.getGradleWrapper();
        return !(this$gradleWrapper == null ? other$gradleWrapper != null : !this$gradleWrapper.equals(other$gradleWrapper));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddGradleWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        String $repositoryUrl = this.getRepositoryUrl();
        result = result * 59 + ($repositoryUrl == null ? 43 : $repositoryUrl.hashCode());
        Validated $gradleWrapper = this.getGradleWrapper();
        result = result * 59 + ($gradleWrapper == null ? 43 : $gradleWrapper.hashCode());
        return result;
    }
}

