/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.Semver;

public final class AddDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example, Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Configuration", description="A configuration to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a new as of yet unused dependency.", example="implementation", required=false)
    @Nullable
    private final String configuration;
    @Option(displayName="Only if using", description="Used to determine if the dependency will be added and in which scope it should be placed.", example="org.junit.jupiter.api.*")
    private final String onlyIfUsing;
    @Option(displayName="Classifier", description="A classifier to add. Commonly used to select variants of a library.", example="test", required=false)
    @Nullable
    private final String classifier;
    @Option(displayName="Extension", description="The extension of the dependency to add. If omitted Gradle defaults to assuming the type is \"jar\".", example="jar", required=false)
    @Nullable
    private final String extension;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    @Nullable
    private final String familyPattern;
    static final String DEPENDENCY_PRESENT = "org.openrewrite.gradle.AddDependency.DEPENDENCY_PRESENT";

    public String getDisplayName() {
        return "Add Gradle dependency";
    }

    public String getDescription() {
        return "Add a gradle dependency to a `build.gradle` file in the correct configuration based on where it is used.";
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.or(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        if (this.onlyIfUsing == null) {
            return null;
        }
        return new UsesType(this.onlyIfUsing, Boolean.valueOf(true));
    }

    protected List<SourceFile> visit(List<SourceFile> before, final ExecutionContext ctx) {
        final HashMap configurationByProject = new HashMap();
        for (SourceFile source : before) {
            source.getMarkers().findFirst(JavaProject.class).ifPresent(javaProject -> source.getMarkers().findFirst(JavaSourceSet.class).ifPresent(sourceSet -> {
                if (source != new UsesType(this.onlyIfUsing, Boolean.valueOf(true)).visit((Tree)source, (Object)ctx)) {
                    configurationByProject.compute(javaProject, (jp, configuration) -> "implementation".equals(configuration) ? configuration : ("test".equals(sourceSet.getName()) ? "testImplementation" : "implementation"));
                }
            }));
        }
        if (configurationByProject.isEmpty()) {
            return before;
        }
        final MethodMatcher dependencyDslMatcher = new MethodMatcher("DependencyHandlerSpec *(..)");
        final Pattern familyPatternCompiled = StringUtils.isBlank((String)this.familyPattern) ? null : Pattern.compile(this.familyPattern.replace("*", ".*"));
        return ListUtils.map(before, s -> s.getMarkers().findFirst(JavaProject.class).map(javaProject -> new GroovyIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)executionContext);
                if (dependencyDslMatcher.matches(m) && (StringUtils.isBlank((String)AddDependency.this.configuration) || AddDependency.this.configuration.equals(m.getSimpleName()))) {
                    if (m.getArguments().get(0) instanceof J.Literal) {
                        Dependency dependency = DependencyStringNotationConverter.parse((String)((J.Literal)m.getArguments().get(0)).getValue());
                        if (AddDependency.this.groupId.equals(dependency.getGroupId()) && AddDependency.this.artifactId.equals(dependency.getArtifactId())) {
                            this.getCursor().putMessageOnFirstEnclosing(G.CompilationUnit.class, AddDependency.DEPENDENCY_PRESENT, (Object)true);
                        }
                    } else if (m.getArguments().get(0) instanceof G.GString) {
                        List strings = ((G.GString)m.getArguments().get(0)).getStrings();
                        if (strings.size() >= 2 && strings.get(0) instanceof J.Literal) {
                            Dependency dependency = DependencyStringNotationConverter.parse((String)((J.Literal)strings.get(0)).getValue());
                            if (AddDependency.this.groupId.equals(dependency.getGroupId()) && AddDependency.this.artifactId.equals(dependency.getArtifactId())) {
                                this.getCursor().putMessageOnFirstEnclosing(G.CompilationUnit.class, AddDependency.DEPENDENCY_PRESENT, (Object)true);
                            }
                        }
                    } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                        G.MapEntry groupEntry = null;
                        G.MapEntry artifactEntry = null;
                        for (Expression e : m.getArguments()) {
                            G.MapEntry arg;
                            if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                            J.Literal key = (J.Literal)arg.getKey();
                            J.Literal value = (J.Literal)arg.getValue();
                            if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                            if ("group".equals(key.getValue())) {
                                groupEntry = arg;
                                continue;
                            }
                            if (!"name".equals(key.getValue())) continue;
                            artifactEntry = arg;
                        }
                        if (groupEntry == null || artifactEntry == null) {
                            return m;
                        }
                        if (AddDependency.this.groupId.equals(((J.Literal)groupEntry.getValue()).getValue()) && AddDependency.this.artifactId.equals(((J.Literal)artifactEntry.getValue()).getValue())) {
                            this.getCursor().putMessageOnFirstEnclosing(G.CompilationUnit.class, AddDependency.DEPENDENCY_PRESENT, (Object)true);
                        }
                    }
                }
                return m;
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext executionContext) {
                if (!cu.getSourcePath().toString().endsWith(".gradle") || cu.getSourcePath().getFileName().toString().equals("settings.gradle")) {
                    return cu;
                }
                String maybeConfiguration = (String)configurationByProject.get(javaProject);
                if (maybeConfiguration == null) {
                    return cu;
                }
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)executionContext);
                if (((Boolean)this.getCursor().getMessage(AddDependency.DEPENDENCY_PRESENT, (Object)false)).booleanValue()) {
                    return g;
                }
                String resolvedConfiguration = StringUtils.isBlank((String)AddDependency.this.configuration) ? maybeConfiguration : AddDependency.this.configuration;
                return (G.CompilationUnit)new AddDependencyVisitor(AddDependency.this.groupId, AddDependency.this.artifactId, AddDependency.this.version, StringUtils.isBlank((String)AddDependency.this.versionPattern) ? null : AddDependency.this.versionPattern, resolvedConfiguration, StringUtils.isBlank((String)AddDependency.this.classifier) ? null : AddDependency.this.classifier, StringUtils.isBlank((String)AddDependency.this.extension) ? null : AddDependency.this.extension, familyPatternCompiled).visitNonNull((Tree)g, ctx);
            }
        }.visit((Tree)s, (Object)ctx)).map(SourceFile.class::cast).orElse((SourceFile)s));
    }

    public AddDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String configuration, String onlyIfUsing, @Nullable String classifier, @Nullable String extension, @Nullable String familyPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.onlyIfUsing = onlyIfUsing;
        this.classifier = classifier;
        this.extension = extension;
        this.familyPattern = familyPattern;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    public String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Nullable
    public String getFamilyPattern() {
        return this.familyPattern;
    }

    @NonNull
    public String toString() {
        return "AddDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", configuration=" + this.getConfiguration() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", classifier=" + this.getClassifier() + ", extension=" + this.getExtension() + ", familyPattern=" + this.getFamilyPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        return !(this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        return result;
    }
}

