/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.internal.InsertDependencyComparator;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class AddDependencyVisitor
extends GroovyIsoVisitor<ExecutionContext> {
    private static final MethodMatcher DEPENDENCIES_DSL_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    private static final GradleParser GRADLE_PARSER = GradleParser.builder().build();
    private final String groupId;
    private final String artifactId;
    private final String version;
    @Nullable
    private final String versionPattern;
    @Nullable
    private final String configuration;
    @Nullable
    private final String classifier;
    @Nullable
    private final String extension;
    @Nullable
    private final Pattern familyRegex;

    public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
        Validated versionValidation;
        G.CompilationUnit groovy = super.visitCompilationUnit(cu, (Object)ctx);
        boolean dependenciesBlockMissing = true;
        for (Statement statement : groovy.getStatements()) {
            if (!(statement instanceof J.MethodInvocation) || !DEPENDENCIES_DSL_MATCHER.matches((J.MethodInvocation)statement)) continue;
            dependenciesBlockMissing = false;
        }
        if (null != this.version && (versionValidation = Semver.validate((String)this.version, (String)this.versionPattern)).isValid()) {
            VersionComparator versionComparator = (VersionComparator)versionValidation.getValue();
        }
        if (dependenciesBlockMissing) {
            Statement dependenciesInvocation = (Statement)((G.CompilationUnit)GRADLE_PARSER.parse(new String[]{"dependencies {}"}).get(0)).getStatements().get(0);
            dependenciesInvocation = (Statement)this.autoFormat((J)dependenciesInvocation, ctx, new Cursor(this.getCursor(), (Object)cu));
            groovy = groovy.withStatements(ListUtils.concat((List)groovy.getStatements(), (Object)(groovy.getStatements().isEmpty() ? dependenciesInvocation : (Statement)dependenciesInvocation.withPrefix(Space.format((String)"\n\n")))));
        }
        this.doAfterVisit((TreeVisitor)new InsertDependencyInOrder(this.configuration));
        return groovy;
    }

    private DependencyStyle autodetectDependencyStyle(List<Statement> statements) {
        int string = 0;
        int map = 0;
        for (Statement statement : statements) {
            J.MethodInvocation invocation;
            if (statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof J.MethodInvocation) {
                invocation = (J.MethodInvocation)((J.Return)statement).getExpression();
                if (invocation.getArguments().get(0) instanceof J.Literal || invocation.getArguments().get(0) instanceof G.GString) {
                    ++string;
                    continue;
                }
                if (!(invocation.getArguments().get(0) instanceof G.MapEntry)) continue;
                ++map;
                continue;
            }
            if (!(statement instanceof J.MethodInvocation)) continue;
            invocation = (J.MethodInvocation)statement;
            if (invocation.getArguments().get(0) instanceof J.Literal || invocation.getArguments().get(0) instanceof G.GString) {
                ++string;
                continue;
            }
            if (!(invocation.getArguments().get(0) instanceof G.MapEntry)) continue;
            ++map;
        }
        return string >= map ? DependencyStyle.String : DependencyStyle.Map;
    }

    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String configuration, @Nullable String classifier, @Nullable String extension, @Nullable Pattern familyRegex) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.classifier = classifier;
        this.extension = extension;
        this.familyRegex = familyRegex;
    }

    static enum DependencyStyle {
        Map,
        String;

    }

    private class InsertDependencyInOrder
    extends GroovyIsoVisitor<ExecutionContext> {
        private final String configuration;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            int i;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!DEPENDENCIES_DSL_MATCHER.matches(m)) {
                return m;
            }
            J.Lambda dependenciesBlock = (J.Lambda)m.getArguments().get(0);
            if (!(dependenciesBlock.getBody() instanceof J.Block)) {
                return m;
            }
            J.Block body = (J.Block)dependenciesBlock.getBody();
            DependencyStyle style = AddDependencyVisitor.this.autodetectDependencyStyle(body.getStatements());
            String codeTemplate = style == DependencyStyle.String ? "dependencies {\n" + this.configuration + " \"" + AddDependencyVisitor.this.groupId + ":" + AddDependencyVisitor.this.artifactId + (AddDependencyVisitor.this.version == null ? "" : ":" + AddDependencyVisitor.this.version) + (AddDependencyVisitor.this.version == null || AddDependencyVisitor.this.classifier == null ? "" : ":" + AddDependencyVisitor.this.classifier) + (AddDependencyVisitor.this.extension == null ? "" : "@" + AddDependencyVisitor.this.extension) + "\"\n}" : "dependencies {\n" + this.configuration + " group: \"" + AddDependencyVisitor.this.groupId + "\", name: \"" + AddDependencyVisitor.this.artifactId + "\"" + (AddDependencyVisitor.this.version == null ? "" : ", version: \"" + AddDependencyVisitor.this.version + "\"") + (AddDependencyVisitor.this.classifier == null ? "" : ", classifier: \"" + AddDependencyVisitor.this.classifier + "\"") + (AddDependencyVisitor.this.extension == null ? "" : ", ext: \"" + AddDependencyVisitor.this.extension + "\"") + "\n}";
            J.MethodInvocation addDependencyInvocation = Objects.requireNonNull((J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)((J.MethodInvocation)((G.CompilationUnit)GRADLE_PARSER.parse(new String[]{codeTemplate}).get(0)).getStatements().get(0)).getArguments().get(0)).getBody()).getStatements().get(0)).getExpression());
            addDependencyInvocation = (J.MethodInvocation)this.autoFormat((J)addDependencyInvocation, ctx, new Cursor(this.getCursor(), (Object)body));
            InsertDependencyComparator dependencyComparator = new InsertDependencyComparator(body.getStatements(), addDependencyInvocation);
            ArrayList<Object> statements = new ArrayList<Object>(body.getStatements());
            for (i = 0; i < body.getStatements().size(); ++i) {
                Statement currentStatement = (Statement)body.getStatements().get(i);
                if (dependencyComparator.compare(currentStatement, (Statement)addDependencyInvocation) <= 0) continue;
                if (dependencyComparator.getBeforeDependency() != null) {
                    J.MethodInvocation beforeDependency = (J.MethodInvocation)(dependencyComparator.getBeforeDependency() instanceof J.Return ? (J)Objects.requireNonNull(((J.Return)dependencyComparator.getBeforeDependency()).getExpression()) : dependencyComparator.getBeforeDependency());
                    if (i == 0) {
                        if (!addDependencyInvocation.getSimpleName().equals(beforeDependency.getSimpleName())) {
                            statements.set(i, (Statement)currentStatement.withPrefix(Space.format((String)("\n\n" + currentStatement.getPrefix().getIndent()))));
                        }
                    } else {
                        J.VariableDeclarations variableDeclarations;
                        Space originalPrefix = addDependencyInvocation.getPrefix();
                        if (currentStatement instanceof J.VariableDeclarations) {
                            variableDeclarations = (J.VariableDeclarations)currentStatement;
                            if (variableDeclarations.getTypeExpression() != null) {
                                addDependencyInvocation = addDependencyInvocation.withPrefix(variableDeclarations.getTypeExpression().getPrefix());
                            }
                        } else {
                            addDependencyInvocation = addDependencyInvocation.withPrefix(currentStatement.getPrefix());
                        }
                        if (addDependencyInvocation.getSimpleName().equals(beforeDependency.getSimpleName())) {
                            if (currentStatement instanceof J.VariableDeclarations) {
                                variableDeclarations = (J.VariableDeclarations)currentStatement;
                                if (variableDeclarations.getTypeExpression() != null && !variableDeclarations.getTypeExpression().getPrefix().equals((Object)originalPrefix)) {
                                    statements.set(i, variableDeclarations.withTypeExpression((TypeTree)variableDeclarations.getTypeExpression().withPrefix(originalPrefix)));
                                }
                            } else if (!currentStatement.getPrefix().equals((Object)originalPrefix)) {
                                statements.set(i, (Statement)currentStatement.withPrefix(originalPrefix));
                            }
                        }
                    }
                }
                statements.add(i, addDependencyInvocation);
                break;
            }
            if (body.getStatements().size() == i) {
                if (!body.getStatements().isEmpty()) {
                    Statement lastStatement;
                    if (statements.get(i - 1) instanceof J.Return) {
                        J.Return r = (J.Return)statements.remove(i - 1);
                        lastStatement = (Statement)Objects.requireNonNull(r.getExpression()).withPrefix(r.getPrefix());
                        statements.add(lastStatement);
                    } else {
                        lastStatement = (Statement)statements.get(i - 1);
                    }
                    if (lastStatement instanceof J.MethodInvocation && !((J.MethodInvocation)lastStatement).getSimpleName().equals(addDependencyInvocation.getSimpleName())) {
                        addDependencyInvocation = addDependencyInvocation.withPrefix(Space.format((String)("\n\n" + addDependencyInvocation.getPrefix().getIndent())));
                    }
                }
                statements.add(addDependencyInvocation);
            }
            body = body.withStatements(statements);
            m = m.withArguments(Collections.singletonList(dependenciesBlock.withBody((J)body)));
            return m;
        }

        public InsertDependencyInOrder(String configuration) {
            this.configuration = configuration;
        }
    }
}

