/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number.", example="29.0")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Change a Gradle dependency version";
    }

    public String getDescription() {
        return "Change a version of a specified dependency. The new version must be an exact version number.";
    }

    public Validated validate() {
        return super.validate().and(DependencyMatcher.build((String)(this.groupId + ":" + this.artifactId)));
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public GroovyVisitor<ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeDependencyVersion.this.groupId + ":" + ChangeDependencyVersion.this.artifactId)).getValue());
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!this.dependencyDsl.matches(m) || !StringUtils.isBlank((String)ChangeDependencyVersion.this.configuration) && !m.getSimpleName().equals(ChangeDependencyVersion.this.configuration)) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency dependency;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (dependency = DependencyStringNotationConverter.parse(gav)).getVersion() != null && !ChangeDependencyVersion.this.newVersion.equals(dependency.getVersion()) && this.depMatcher.matches(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion())) {
                        Dependency newDependency = dependency.withVersion(ChangeDependencyVersion.this.newVersion);
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, newDependency.toStringNotation())));
                    }
                } else if (depArgs.get(0) instanceof G.MapEntry) {
                    G.MapEntry versionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    String versionStringDelimiter = "'";
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if ("name".equals(keyValue)) {
                            artifactId = valueValue;
                            continue;
                        }
                        if (!"version".equals(keyValue) || ChangeDependencyVersion.this.newVersion.equals(valueValue)) continue;
                        if (value.getValueSource() != null) {
                            versionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                        }
                        versionEntry = arg2;
                        version = valueValue;
                    }
                    if (groupId == null || artifactId == null || version == null && !this.depMatcher.matches(groupId, artifactId) || version != null && !this.depMatcher.matches(groupId, artifactId, version)) {
                        return m;
                    }
                    String delimiter = versionStringDelimiter;
                    G.MapEntry finalVersion = versionEntry;
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                        if (arg == finalVersion) {
                            return finalVersion.withValue((Expression)((J.Literal)finalVersion.getValue()).withValue((Object)ChangeDependencyVersion.this.newVersion).withValueSource(delimiter + ChangeDependencyVersion.this.newVersion + delimiter));
                        }
                        return arg;
                    }));
                }
                return m;
            }
        };
    }

    public ChangeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyVersion)) {
            return false;
        }
        ChangeDependencyVersion other = (ChangeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

