/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.gradle.plugins.UpgradePluginVersion;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.style.Style;

@Incubating(since="7.33.0")
public final class AddGradleEnterprise
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the plugin version.", example="3.x")
    private final String version;
    @Option(displayName="Server URL", description="The URL of the Gradle Enterprise server. If omitted the recipe will set no URL and Gradle will direct scans to https://scans.gradle.com/", required=false, example="https://ge.openrewrite.org/")
    @Nullable
    private final String server;
    @Option(displayName="Allow untrusted server", description="When set to `true` the plugin will be configured to allow unencrypted http connections with the server. If set to `false` or omitted, the plugin will refuse to communicate without transport layer security enabled.", required=false, example="true")
    @Nullable
    private final Boolean allowUntrustedServer;
    @Option(displayName="Capture task input files", description="When set to `true` the plugin will capture additional information about the inputs to Gradle tasks. This increases the size of build scans, but is useful for diagnosing issues with task caching. ", required=false, example="true")
    @Nullable
    private final Boolean captureTaskInputFiles;
    @Option(displayName="Upload in background", description="When set to `true` the plugin will capture additional information about the outputs of Gradle tasks. This increases the size of build scans, but is useful for diagnosing issues with task caching. ", required=false, example="true")
    @Nullable
    private final Boolean uploadInBackground;
    @Option(displayName="Publish Criteria", description="When set to `always` the plugin will publish build scans of every single build. When set to `failure` the plugin will only publish build scans when the build fails. When omitted scans will be published only when the `--scan` option is passed to the build.", required=false, valid={"always", "failure"}, example="always")
    @Nullable
    private final PublishCriteria publishCriteria;

    public String getDisplayName() {
        return "Add the Gradle Enterprise plugin";
    }

    public String getDescription() {
        return "Add the Gradle Enterprise plugin to settings.gradle files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                boolean gradleSixOrLater;
                Optional maybeBuildTool = cu.getMarkers().findFirst(BuildTool.class);
                if (!maybeBuildTool.isPresent()) {
                    return cu;
                }
                BuildTool buildTool = (BuildTool)maybeBuildTool.get();
                if (buildTool.getType() != BuildTool.Type.Gradle) {
                    return cu;
                }
                VersionComparator versionComparator = (VersionComparator)Semver.validate((String)"(,6)", null).getValue();
                if (versionComparator == null) {
                    return cu;
                }
                if (AddGradleEnterprise.containsGradleEnterpriseDsl((JavaSourceFile)cu)) {
                    return cu;
                }
                boolean bl = gradleSixOrLater = versionComparator.compare(null, buildTool.getVersion(), "6.0") >= 0;
                if (gradleSixOrLater && cu.getSourcePath().endsWith("settings.gradle")) {
                    Optional maybeGradleSettings = cu.getMarkers().findFirst(GradleSettings.class);
                    if (!maybeGradleSettings.isPresent()) {
                        return cu;
                    }
                    GradleSettings gradleSettings = (GradleSettings)maybeGradleSettings.get();
                    cu = AddGradleEnterprise.this.withPlugin(cu, "com.gradle.enterprise", versionComparator, gradleSettings.getPluginRepositories(), ctx);
                } else if (!gradleSixOrLater && cu.getSourcePath().toString().equals("build.gradle")) {
                    Optional maybeGradleProject = cu.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGradleProject.isPresent()) {
                        return cu;
                    }
                    GradleProject gradleProject = (GradleProject)maybeGradleProject.get();
                    cu = AddGradleEnterprise.this.withPlugin(cu, "com.gradle.build-scan", versionComparator, gradleProject.getMavenPluginRepositories(), ctx);
                }
                return cu;
            }
        });
    }

    private G.CompilationUnit withPlugin(G.CompilationUnit cu, String pluginId, VersionComparator versionComparator, List<MavenRepository> repositories, ExecutionContext ctx) {
        try {
            Optional<String> maybeNewVersion = AddPluginVisitor.resolvePluginVersion(pluginId, "0", this.version, null, repositories, ctx);
            if (!maybeNewVersion.isPresent()) {
                return cu;
            }
            String newVersion = maybeNewVersion.get();
            cu = (G.CompilationUnit)new AddPluginVisitor(pluginId, newVersion, null, repositories).visitNonNull((Tree)cu, ctx);
            cu = (G.CompilationUnit)new UpgradePluginVersion(pluginId, newVersion, null).getVisitor().visitNonNull((Tree)cu, (Object)ctx);
            J.MethodInvocation gradleEnterpriseInvocation = this.gradleEnterpriseDsl(newVersion, versionComparator, AddGradleEnterprise.getIndent(cu), ctx);
            return cu.withStatements(ListUtils.concat((List)cu.getStatements(), (Object)gradleEnterpriseInvocation));
        }
        catch (MavenDownloadingException e) {
            return (G.CompilationUnit)e.warn((Tree)cu);
        }
    }

    private static boolean containsGradleEnterpriseDsl(JavaSourceFile cu) {
        AtomicBoolean found = new AtomicBoolean(false);
        new GroovyIsoVisitor<AtomicBoolean>(){

            @Nullable
            public J visit(@Nullable Tree tree, AtomicBoolean atomicBoolean) {
                if (atomicBoolean.get()) {
                    return (J)tree;
                }
                return (J)super.visit(tree, (Object)atomicBoolean);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                if (method.getSimpleName().equals("gradleEnterprise")) {
                    atomicBoolean.set(true);
                }
                return super.visitMethodInvocation(method, (Object)atomicBoolean);
            }
        }.visit((Tree)cu, found);
        return found.get();
    }

    @Nullable
    private J.MethodInvocation gradleEnterpriseDsl(String newVersion, VersionComparator versionComparator, String indent, ExecutionContext ctx) {
        if (this.server == null && this.allowUntrustedServer == null && this.captureTaskInputFiles == null && this.uploadInBackground == null && this.publishCriteria == null) {
            return null;
        }
        boolean versionIsAtLeast3_2 = versionComparator.compare(null, newVersion, "3.2") >= 0;
        boolean versionIsAtLeast3_7 = versionComparator.compare(null, newVersion, "3.7") >= 0;
        StringBuilder ge = new StringBuilder("\ngradleEnterprise {\n");
        if (this.server != null && !this.server.isEmpty()) {
            ge.append(indent).append("server = '").append(this.server).append("'\n");
        }
        if (this.allowUntrustedServer != null && versionIsAtLeast3_2) {
            ge.append(indent).append("allowUntrustedServer = ").append(this.allowUntrustedServer).append("\n");
        }
        if (this.captureTaskInputFiles != null || this.uploadInBackground != null || this.allowUntrustedServer != null && !versionIsAtLeast3_2 || this.publishCriteria != null) {
            ge.append(indent).append("buildScan {\n");
            if (this.publishCriteria != null) {
                if (this.publishCriteria == PublishCriteria.Always) {
                    ge.append(indent).append(indent).append("publishAlways()\n");
                } else {
                    ge.append(indent).append(indent).append("publishOnFailure()\n");
                }
            }
            if (this.allowUntrustedServer != null && !versionIsAtLeast3_2) {
                ge.append(indent).append(indent).append("allowUntrustedServer = ").append(this.allowUntrustedServer).append("\n");
            }
            if (this.uploadInBackground != null) {
                ge.append(indent).append(indent).append("uploadInBackground = ").append(this.uploadInBackground).append("\n");
            }
            if (this.captureTaskInputFiles != null) {
                if (versionIsAtLeast3_7) {
                    ge.append(indent).append(indent).append("capture {\n");
                    ge.append(indent).append(indent).append(indent).append("taskInputFiles = ").append(this.captureTaskInputFiles).append("\n");
                    ge.append(indent).append(indent).append("}\n");
                } else {
                    ge.append(indent).append(indent).append("captureTaskInputFiles = ").append(this.captureTaskInputFiles).append("\n");
                }
            }
            ge.append(indent).append("}\n");
        }
        ge.append("}\n");
        G.CompilationUnit cu = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("settings.gradle", new String[0]), (String)ge.toString())), null, ctx).map(G.CompilationUnit.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
        return (J.MethodInvocation)cu.getStatements().get(0);
    }

    private static String getIndent(G.CompilationUnit cu) {
        TabsAndIndentsStyle style = (TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class, (Style)IntelliJ.tabsAndIndents());
        if (style.getUseTabCharacter().booleanValue()) {
            return "\t";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < style.getIndentSize(); ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public AddGradleEnterprise(String version, @Nullable String server, @Nullable Boolean allowUntrustedServer, @Nullable Boolean captureTaskInputFiles, @Nullable Boolean uploadInBackground, @Nullable PublishCriteria publishCriteria) {
        this.version = version;
        this.server = server;
        this.allowUntrustedServer = allowUntrustedServer;
        this.captureTaskInputFiles = captureTaskInputFiles;
        this.uploadInBackground = uploadInBackground;
        this.publishCriteria = publishCriteria;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getServer() {
        return this.server;
    }

    @Nullable
    public Boolean getAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    @Nullable
    public Boolean getCaptureTaskInputFiles() {
        return this.captureTaskInputFiles;
    }

    @Nullable
    public Boolean getUploadInBackground() {
        return this.uploadInBackground;
    }

    @Nullable
    public PublishCriteria getPublishCriteria() {
        return this.publishCriteria;
    }

    @NonNull
    public String toString() {
        return "AddGradleEnterprise(metadataFailures=" + this.getMetadataFailures() + ", version=" + this.getVersion() + ", server=" + this.getServer() + ", allowUntrustedServer=" + this.getAllowUntrustedServer() + ", captureTaskInputFiles=" + this.getCaptureTaskInputFiles() + ", uploadInBackground=" + this.getUploadInBackground() + ", publishCriteria=" + (Object)((Object)this.getPublishCriteria()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddGradleEnterprise)) {
            return false;
        }
        AddGradleEnterprise other = (AddGradleEnterprise)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$allowUntrustedServer = this.getAllowUntrustedServer();
        Boolean other$allowUntrustedServer = other.getAllowUntrustedServer();
        if (this$allowUntrustedServer == null ? other$allowUntrustedServer != null : !((Object)this$allowUntrustedServer).equals(other$allowUntrustedServer)) {
            return false;
        }
        Boolean this$captureTaskInputFiles = this.getCaptureTaskInputFiles();
        Boolean other$captureTaskInputFiles = other.getCaptureTaskInputFiles();
        if (this$captureTaskInputFiles == null ? other$captureTaskInputFiles != null : !((Object)this$captureTaskInputFiles).equals(other$captureTaskInputFiles)) {
            return false;
        }
        Boolean this$uploadInBackground = this.getUploadInBackground();
        Boolean other$uploadInBackground = other.getUploadInBackground();
        if (this$uploadInBackground == null ? other$uploadInBackground != null : !((Object)this$uploadInBackground).equals(other$uploadInBackground)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        PublishCriteria this$publishCriteria = this.getPublishCriteria();
        PublishCriteria other$publishCriteria = other.getPublishCriteria();
        return !(this$publishCriteria == null ? other$publishCriteria != null : !((Object)((Object)this$publishCriteria)).equals((Object)other$publishCriteria));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddGradleEnterprise;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $allowUntrustedServer = this.getAllowUntrustedServer();
        result = result * 59 + ($allowUntrustedServer == null ? 43 : ((Object)$allowUntrustedServer).hashCode());
        Boolean $captureTaskInputFiles = this.getCaptureTaskInputFiles();
        result = result * 59 + ($captureTaskInputFiles == null ? 43 : ((Object)$captureTaskInputFiles).hashCode());
        Boolean $uploadInBackground = this.getUploadInBackground();
        result = result * 59 + ($uploadInBackground == null ? 43 : ((Object)$uploadInBackground).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        PublishCriteria $publishCriteria = this.getPublishCriteria();
        result = result * 59 + ($publishCriteria == null ? 43 : ((Object)((Object)$publishCriteria)).hashCode());
        return result;
    }

    public static enum PublishCriteria {
        Always,
        Failure;

    }
}

