/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class DependencyUseMapNotation
extends Recipe {
    public String getDisplayName() {
        return "Use `Map` notation for Gradle dependency declarations";
    }

    public String getDescription() {
        return "In Gradle, dependencies can be expressed as a `String` like `\"groupId:artifactId:version\"`, or equivalently as a `Map` like `group: 'groupId', name: 'artifactId', version: 'version'`. This recipe replaces dependencies represented as `Strings` with an equivalent dependency represented as a `Map`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!dependencyDsl.matches((MethodCall)m)) {
                    return m;
                }
                m = this.forBasicString(m);
                m = this.forGString(m);
                return m;
            }

            private J.MethodInvocation forBasicString(J.MethodInvocation m) {
                Expression lastArg;
                Expression e = (Expression)m.getArguments().get(0);
                if (!(e instanceof J.Literal)) {
                    return m;
                }
                J.Literal arg = (J.Literal)e;
                if (arg.getType() != JavaType.Primitive.String) {
                    return m;
                }
                String dependencyString = (String)arg.getValue();
                if (dependencyString == null) {
                    return m;
                }
                Dependency dependency = DependencyStringNotationConverter.parse(dependencyString);
                ArrayList<G.MapEntry> arguments = new ArrayList<G.MapEntry>();
                arguments.add(DependencyUseMapNotation.mapEntry("group", dependency.getGroupId()).withMarkers(arg.getMarkers()).withPrefix(arg.getPrefix()));
                arguments.add(DependencyUseMapNotation.mapEntry("name", dependency.getArtifactId()).withMarkers(arg.getMarkers()));
                if (dependency.getVersion() != null) {
                    arguments.add(DependencyUseMapNotation.mapEntry("version", dependency.getVersion()).withMarkers(arg.getMarkers()));
                }
                if (dependency.getClassifier() != null) {
                    arguments.add(DependencyUseMapNotation.mapEntry("classifier", dependency.getClassifier()).withMarkers(arg.getMarkers()));
                }
                if (dependency.getExt() != null) {
                    arguments.add(DependencyUseMapNotation.mapEntry("ext", dependency.getExt()).withMarkers(arg.getMarkers()));
                }
                m = (lastArg = (Expression)m.getArguments().get(m.getArguments().size() - 1)) instanceof J.Lambda ? m.withArguments(ListUtils.concat(arguments, (Object)lastArg)) : m.withArguments(arguments);
                return this.updateTypeForMapArgument(m);
            }

            private J.MethodInvocation forGString(J.MethodInvocation m) {
                Expression e = (Expression)m.getArguments().get(0);
                if (!(e instanceof G.GString)) {
                    return m;
                }
                G.GString g = (G.GString)e;
                if (g.getStrings().size() != 2 || !(g.getStrings().get(0) instanceof J.Literal) || !(g.getStrings().get(1) instanceof G.GString.Value)) {
                    return m;
                }
                J.Literal arg1 = (J.Literal)g.getStrings().get(0);
                if (arg1.getType() != JavaType.Primitive.String || arg1.getValue() == null) {
                    return m;
                }
                String[] ga = ((String)arg1.getValue()).split(":");
                if (ga.length != 2) {
                    return m;
                }
                G.GString.Value arg2 = (G.GString.Value)g.getStrings().get(1);
                if (!(arg2.getTree() instanceof Expression)) {
                    return m;
                }
                G.MapEntry groupEntry = DependencyUseMapNotation.mapEntry("group", ga[0]).withMarkers(e.getMarkers()).withPrefix(e.getPrefix());
                G.MapEntry artifactEntry = DependencyUseMapNotation.mapEntry("name", ga[1]).withMarkers(e.getMarkers());
                G.MapEntry versionEntry = DependencyUseMapNotation.mapEntry("version", (Expression)arg2.getTree().withPrefix(Space.format((String)" "))).withMarkers(e.getMarkers());
                Expression lastArg = (Expression)m.getArguments().get(m.getArguments().size() - 1);
                m = lastArg instanceof J.Lambda ? m.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry, lastArg)) : m.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry));
                return this.updateTypeForMapArgument(m);
            }

            private J.MethodInvocation updateTypeForMapArgument(J.MethodInvocation m) {
                JavaType.Method mtype = m.getMethodType();
                if (mtype == null) {
                    return m;
                }
                mtype = mtype.withParameterTypes(Collections.singletonList(JavaType.ShallowClass.build((String)"java.util.Map")));
                if (m.getName().getType() != null) {
                    m = m.withName(m.getName().withType((JavaType)mtype));
                }
                return m.withMethodType(mtype);
            }
        });
    }

    private static G.MapEntry mapEntry(String key, String value) {
        return DependencyUseMapNotation.mapEntry(key, (Expression)new J.Literal(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, (Object)value, "'" + value + "'", null, JavaType.Primitive.String));
    }

    private static G.MapEntry mapEntry(String key, Expression e) {
        return new G.MapEntry(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), key, null, null)), e, null);
    }
}

