/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import io.micrometer.core.instrument.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Marker;
import org.openrewrite.semver.DependencyMatcher;

public final class RemoveDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="The dependency configuration", description="The dependency configuration to remove from.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Remove a Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Removes a single dependency from the dependencies section of the `build.gradle`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){
            final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            final DependencyMatcher dependencyMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(RemoveDependency.access$000(RemoveDependency.this) + ":" + RemoveDependency.access$100(RemoveDependency.this))).getValue());

            public J visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit g = (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                if (g == cu) {
                    return cu;
                }
                Optional maybeGp = g.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                GradleProject gp = (GradleProject)maybeGp.get();
                Map nameToConfiguration = gp.getNameToConfiguration();
                boolean anyChanged = false;
                for (GradleDependencyConfiguration gdc : nameToConfiguration.values()) {
                    GradleDependencyConfiguration newGdc = gdc.withRequested(ListUtils.map((List)gdc.getRequested(), requested -> {
                        if (this.dependencyMatcher.matches(requested.getGroupId(), requested.getArtifactId())) {
                            return null;
                        }
                        return requested;
                    }));
                    newGdc = newGdc.withResolved(ListUtils.map((List)newGdc.getResolved(), resolved -> {
                        if (this.dependencyMatcher.matches(resolved.getGroupId(), resolved.getArtifactId())) {
                            return null;
                        }
                        return resolved;
                    }));
                    nameToConfiguration.put(newGdc.getName(), newGdc);
                    anyChanged |= newGdc != gdc;
                }
                if (!anyChanged) {
                    return cu;
                }
                return g.withMarkers(g.getMarkers().setByType((Marker)gp.withNameToConfiguration(nameToConfiguration)));
            }

            @Nullable
            public J visitReturn(J.Return return_, ExecutionContext ctx) {
                boolean dependencyInvocation = return_.getExpression() instanceof J.MethodInvocation && this.dependencyDsl.matches((MethodCall)((J.MethodInvocation)return_.getExpression()));
                J.Return r = (J.Return)super.visitReturn(return_, (Object)ctx);
                if (dependencyInvocation && r.getExpression() == null) {
                    return null;
                }
                return r;
            }

            @Nullable
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (this.dependencyDsl.matches((MethodCall)m) && (StringUtils.isEmpty((String)RemoveDependency.this.configuration) || RemoveDependency.this.configuration.equals(m.getSimpleName()))) {
                    J after;
                    Expression firstArgument = (Expression)m.getArguments().get(0);
                    if (firstArgument instanceof J.Literal || firstArgument instanceof G.GString || firstArgument instanceof G.MapEntry) {
                        return this.maybeRemoveDependency(m);
                    }
                    if (firstArgument instanceof J.MethodInvocation && (((J.MethodInvocation)firstArgument).getSimpleName().equals("platform") || ((J.MethodInvocation)firstArgument).getSimpleName().equals("enforcedPlatform")) && (after = this.maybeRemoveDependency((J.MethodInvocation)firstArgument)) == null) {
                        return null;
                    }
                }
                return m;
            }

            @Nullable
            private J maybeRemoveDependency(J.MethodInvocation m) {
                if (m.getArguments().get(0) instanceof G.GString) {
                    G.GString gString = (G.GString)m.getArguments().get(0);
                    List strings = gString.getStrings();
                    if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) {
                        return m;
                    }
                    J.Literal groupArtifact = (J.Literal)strings.get(0);
                    if (!(groupArtifact.getValue() instanceof String)) {
                        return m;
                    }
                    Dependency dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                    if (this.dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId())) {
                        return null;
                    }
                } else if (m.getArguments().get(0) instanceof J.Literal) {
                    Dependency dependency = DependencyStringNotationConverter.parse((String)((J.Literal)m.getArguments().get(0)).getValue());
                    if (this.dependencyMatcher.matches(dependency.getGroupId(), dependency.getArtifactId())) {
                        return null;
                    }
                } else if (m.getArguments().get(0) instanceof G.MapEntry) {
                    String groupId = null;
                    String artifactId = null;
                    for (Expression e : m.getArguments()) {
                        G.MapEntry arg;
                        if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg.getKey();
                        J.Literal value = (J.Literal)arg.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if (!"name".equals(keyValue)) continue;
                        artifactId = valueValue;
                    }
                    if (groupId != null && artifactId != null && this.dependencyMatcher.matches(groupId, artifactId)) {
                        return null;
                    }
                }
                return m;
            }
        });
    }

    public RemoveDependency(String groupId, String artifactId, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "RemoveDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveDependency)) {
            return false;
        }
        RemoveDependency other = (RemoveDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    static /* synthetic */ String access$000(RemoveDependency x0) {
        return x0.groupId;
    }

    static /* synthetic */ String access$100(RemoveDependency x0) {
        return x0.artifactId;
    }
}

