/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class ChangeExtraProperty
extends Recipe {
    @Option(displayName="Key", description="The key of the property to change.", example="foo")
    private final String key;
    @Option(displayName="Value", description="The new value to set. The value will be treated the contents of a string literal.", example="bar")
    private final String value;

    public String getDisplayName() {
        return "Change Extra Property";
    }

    public String getDescription() {
        return "Gradle's [ExtraPropertiesExtension](https://docs.gradle.org/current/dsl/org.gradle.api.plugins.ExtraPropertiesExtension.html) is a commonly used mechanism for setting arbitrary key/value pairs on a project. This recipe will change the value of a property with the given key name if that key can be found. It assumes that the value being set is a String literal. Does not add the value if it does not already exist.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindGradleProject(FindGradleProject.SearchCriteria.File).getVisitor(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public J.Assignment visitAssignment(J.Assignment as, ExecutionContext ctx) {
                if (!(as.getAssignment() instanceof J.Literal)) {
                    return as;
                }
                if (as.getVariable() instanceof J.Identifier) {
                    if (!Objects.equals(ChangeExtraProperty.this.key, ((J.Identifier)as.getVariable()).getSimpleName())) {
                        return as;
                    }
                    J.MethodInvocation m = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
                    if (m == null || !m.getSimpleName().equals("ext")) {
                        return as;
                    }
                    as = ChangeExtraProperty.this.updateAssignment(as);
                } else if (as.getVariable() instanceof J.FieldAccess) {
                    J.FieldAccess var = (J.FieldAccess)as.getVariable();
                    if (!Objects.equals(ChangeExtraProperty.this.key, var.getSimpleName())) {
                        return as;
                    }
                    if (var.getTarget() instanceof J.Identifier && ((J.Identifier)var.getTarget()).getSimpleName().equals("ext") || var.getTarget() instanceof J.FieldAccess && ((J.FieldAccess)var.getTarget()).getSimpleName().equals("ext")) {
                        as = ChangeExtraProperty.this.updateAssignment(as);
                    }
                }
                return as;
            }
        });
    }

    private J.Assignment updateAssignment(J.Assignment as) {
        if (!(as.getAssignment() instanceof J.Literal)) {
            return as;
        }
        J.Literal asVal = (J.Literal)as.getAssignment();
        if (Objects.equals(this.value, asVal.getValue())) {
            return as;
        }
        String quote = "\"";
        if (asVal.getValueSource() != null && asVal.getValueSource().trim().startsWith("'")) {
            quote = "'";
        }
        return as.withAssignment((Expression)asVal.withValue((Object)this.value).withValueSource(quote + this.value + quote));
    }

    public ChangeExtraProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @NonNull
    public String toString() {
        return "ChangeExtraProperty(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeExtraProperty)) {
            return false;
        }
        ChangeExtraProperty other = (ChangeExtraProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeExtraProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

