/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.text.PlainText;

public class UpdateGradleWrapper
extends ScanningRecipe<GradleWrapperState> {
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. Defaults to the latest release available from services.gradle.org if not specified.", example="7.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. Defaults to \"bin\".", valid={"bin", "all"}, required=false)
    @Nullable
    private final String distribution;
    @Option(displayName="Add if missing", description="Add a Gradle wrapper, if it's missing. Defaults to `true`.", required=false)
    @Nullable
    private final Boolean addIfMissing;
    @Option(example="https://services.gradle.org/distributions/gradle-${version}-${distribution}.zip", displayName="Wrapper URI", description="The URI of the Gradle wrapper distribution. Lookup of available versions still requires access to https://services.gradle.org When this is specified the exact literal values supplied for `version` and `distribution` will be interpolated into this string wherever `${version}` and `${distribution}` appear respectively. Defaults to https://services.gradle.org/distributions/gradle-${version}-${distribution}.zip.", required=false)
    @Nullable
    private final String wrapperUri;
    private transient GradleWrapper gradleWrapper;

    public String getDisplayName() {
        return "Update Gradle wrapper";
    }

    public String getDescription() {
        return "Update the version of Gradle used in an existing Gradle wrapper. Queries services.gradle.org to determine the available releases, but prefers the artifact repository URL which already exists within the wrapper properties file. If your artifact repository does not contain the same Gradle distributions as services.gradle.org, then the recipe may suggest a version which is not available in your artifact repository.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    private GradleWrapper getGradleWrapper(ExecutionContext ctx) {
        if (this.gradleWrapper == null) {
            try {
                this.gradleWrapper = GradleWrapper.create(this.distribution, this.version, null, ctx);
            }
            catch (Exception e) {
                if (this.wrapperUri == null) {
                    throw new IllegalArgumentException("Could not reach services.gradle.org and no alternative wrapper URI is provided. To use this recipe in environments where services.gradle.org is unavailable specify a wrapperUri.", e);
                }
                if (this.wrapperUri.contains("${version})")) {
                    if (this.version == null) {
                        throw new IllegalArgumentException("wrapperUri contains a ${version} interpolation specifier but no version parameter was specified.", e);
                    }
                    if (!this.version.matches("[0-9.]+")) {
                        throw new IllegalArgumentException("Version selectors like \"" + this.version + "\" are unavailable when services.gradle.org cannot be reached. Specify an exact, literal version number.", e);
                    }
                }
                String effectiveWrapperUri = this.wrapperUri.replace("${version}", this.version == null ? "" : this.version).replace("${distribution}", this.distribution == null ? "bin" : this.distribution);
                this.gradleWrapper = GradleWrapper.create(URI.create(effectiveWrapperUri), ctx);
            }
        }
        return this.gradleWrapper;
    }

    public GradleWrapperState getInitialValue(ExecutionContext ctx) {
        return new GradleWrapperState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final GradleWrapperState acc) {
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{new PropertiesVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (!super.isAcceptable(sourceFile, (Object)ctx)) {
                    return false;
                }
                if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION)) {
                    acc.addGradleWrapperProperties = false;
                } else if (!PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.properties")) {
                    return false;
                }
                Optional maybeBuildTool = sourceFile.getMarkers().findFirst(BuildTool.class);
                if (!maybeBuildTool.isPresent()) {
                    return false;
                }
                BuildTool buildTool = (BuildTool)maybeBuildTool.get();
                if (buildTool.getType() != BuildTool.Type.Gradle) {
                    return false;
                }
                GradleWrapper gradleWrapper = UpdateGradleWrapper.this.getGradleWrapper(ctx);
                VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpdateGradleWrapper.this.version) ? "latest.release" : UpdateGradleWrapper.this.version), null).getValue());
                int compare = versionComparator.compare(null, buildTool.getVersion(), gradleWrapper.getVersion());
                if (compare < 0) {
                    acc.needsWrapperUpdate = true;
                    acc.updatedMarker = buildTool.withVersion(gradleWrapper.getVersion());
                    return true;
                }
                return compare == 0;
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (!"distributionUrl".equals(entry.getKey())) {
                    return entry;
                }
                GradleWrapper gradleWrapper = UpdateGradleWrapper.this.getGradleWrapper(ctx);
                String currentDistributionUrl = entry.getValue().getText();
                if (!gradleWrapper.getPropertiesFormattedUrl().equals(currentDistributionUrl)) {
                    acc.needsWrapperUpdate = true;
                }
                return entry;
            }
        }, new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (!super.isAcceptable(sourceFile, (Object)ctx)) {
                    return false;
                }
                if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_JAR_LOCATION)) {
                    acc.addGradleWrapperJar = false;
                    return true;
                }
                if (sourceFile instanceof PlainText) {
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_BATCH_LOCATION)) {
                        acc.addGradleBatchScript = false;
                        return true;
                    }
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_SCRIPT_LOCATION)) {
                        acc.addGradleShellScript = false;
                        return true;
                    }
                }
                return false;
            }
        }});
    }

    public Collection<SourceFile> generate(GradleWrapperState acc, ExecutionContext ctx) {
        if (Boolean.FALSE.equals(this.addIfMissing)) {
            return Collections.emptyList();
        }
        if (!(acc.addGradleWrapperJar || acc.addGradleWrapperProperties || acc.addGradleBatchScript || acc.addGradleShellScript)) {
            return Collections.emptyList();
        }
        ArrayList<SourceFile> gradleWrapperFiles = new ArrayList<SourceFile>();
        ZonedDateTime now = ZonedDateTime.now();
        GradleWrapper gradleWrapper = this.getGradleWrapper(ctx);
        if (acc.addGradleWrapperProperties) {
            Properties.File gradleWrapperProperties = (Properties.File)((SourceFile)new PropertiesParser().parse(new String[]{"distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\n" + (gradleWrapper.getDistributionChecksum() == null ? "" : "distributionSha256Sum=" + gradleWrapper.getDistributionChecksum().getHexValue() + "\n") + "zipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists"}).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as properties"))).withSourcePath(GradleWrapper.WRAPPER_PROPERTIES_LOCATION);
            gradleWrapperFiles.add((SourceFile)gradleWrapperProperties);
        }
        FileAttributes wrapperScriptAttributes = new FileAttributes(now, now, now, true, true, true, 1L);
        if (acc.addGradleShellScript) {
            String gradlewText = this.unixScript(gradleWrapper, ctx);
            PlainText gradlew = PlainText.builder().text(gradlewText).sourcePath(GradleWrapper.WRAPPER_SCRIPT_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            gradleWrapperFiles.add((SourceFile)gradlew);
        }
        if (acc.addGradleBatchScript) {
            String gradlewBatText = this.batchScript(gradleWrapper, ctx);
            PlainText gradlewBat = PlainText.builder().text(gradlewBatText).sourcePath(GradleWrapper.WRAPPER_BATCH_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            gradleWrapperFiles.add((SourceFile)gradlewBat);
        }
        if (acc.addGradleWrapperJar) {
            gradleWrapperFiles.add((SourceFile)gradleWrapper.wrapperJar());
        }
        return gradleWrapperFiles;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final GradleWrapperState acc) {
        if (!acc.needsWrapperUpdate) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Optional maybeCurrentMarker;
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (acc.updatedMarker != null && (maybeCurrentMarker = sourceFile.getMarkers().findFirst(BuildTool.class)).isPresent()) {
                    BuildTool currentMarker = (BuildTool)maybeCurrentMarker.get();
                    if (currentMarker.getType() != BuildTool.Type.Gradle) {
                        return sourceFile;
                    }
                    VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpdateGradleWrapper.this.version) ? "latest.release" : UpdateGradleWrapper.this.version), null).getValue());
                    int compare = versionComparator.compare(null, currentMarker.getVersion(), acc.updatedMarker.getVersion());
                    if (compare < 0) {
                        sourceFile = (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().setByType((Marker)acc.updatedMarker));
                    } else {
                        return sourceFile;
                    }
                }
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradlew")) {
                    PlainText gradlew;
                    String gradlewText = UpdateGradleWrapper.this.unixScript(UpdateGradleWrapper.this.gradleWrapper, ctx);
                    if (!gradlewText.equals((gradlew = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile)).getText())) {
                        gradlew = gradlew.withText(gradlewText);
                    }
                    return gradlew;
                }
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradlew.bat")) {
                    PlainText gradlewBat;
                    String gradlewBatText = UpdateGradleWrapper.this.batchScript(UpdateGradleWrapper.this.gradleWrapper, ctx);
                    if (!gradlewBatText.equals((gradlewBat = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile)).getText())) {
                        gradlewBat = gradlewBat.withText(gradlewBatText);
                    }
                    return gradlewBat;
                }
                if (sourceFile instanceof Properties.File && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.properties")) {
                    return new WrapperPropertiesVisitor(UpdateGradleWrapper.this.gradleWrapper).visitNonNull((Tree)sourceFile, ctx);
                }
                if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.jar")) {
                    return UpdateGradleWrapper.this.gradleWrapper.wrapperJar(sourceFile);
                }
                return sourceFile;
            }
        };
    }

    private static <T extends SourceFile> T setExecutable(T sourceFile) {
        FileAttributes attributes = sourceFile.getFileAttributes();
        if (attributes == null) {
            ZonedDateTime now = ZonedDateTime.now();
            return (T)sourceFile.withFileAttributes(new FileAttributes(now, now, now, true, true, true, 1L));
        }
        if (!attributes.isExecutable()) {
            return (T)sourceFile.withFileAttributes(attributes.withExecutable(true));
        }
        return sourceFile;
    }

    private String unixScript(GradleWrapper gradleWrapper, ExecutionContext ctx) {
        HashMap<String, String> binding = new HashMap<String, String>();
        String defaultJvmOpts = this.defaultJvmOpts(gradleWrapper);
        binding.put("defaultJvmOpts", StringUtils.isNotEmpty((String)defaultJvmOpts) ? "'" + defaultJvmOpts + "'" : "");
        binding.put("classpath", "$APP_HOME/gradle/wrapper/gradle-wrapper.jar");
        String gradlewTemplate = StringUtils.readFully((InputStream)gradleWrapper.gradlew().getInputStream(ctx));
        return this.renderTemplate(gradlewTemplate, binding, "\n");
    }

    private String batchScript(GradleWrapper gradleWrapper, ExecutionContext ctx) {
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("defaultJvmOpts", this.defaultJvmOpts(gradleWrapper));
        binding.put("classpath", "%APP_HOME%\\gradle\\wrapper\\gradle-wrapper.jar");
        String gradlewBatTemplate = StringUtils.readFully((InputStream)gradleWrapper.gradlewBat().getInputStream(ctx));
        return this.renderTemplate(gradlewBatTemplate, binding, "\r\n");
    }

    private String defaultJvmOpts(GradleWrapper gradleWrapper) {
        VersionComparator gradle53VersionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)"[5.3,)", null).getValue());
        VersionComparator gradle50VersionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)"[5.0,)", null).getValue());
        if (gradle53VersionComparator.isValid(null, gradleWrapper.getVersion())) {
            return "\"-Xmx64m\" \"-Xms64m\"";
        }
        if (gradle50VersionComparator.isValid(null, gradleWrapper.getVersion())) {
            return "\"-Xmx64m\"";
        }
        return "";
    }

    private String renderTemplate(String source, Map<String, String> parameters, String lineSeparator) {
        HashMap<String, String> binding = new HashMap<String, String>(parameters);
        binding.put("applicationName", "Gradle");
        binding.put("optsEnvironmentVar", "GRADLE_OPTS");
        binding.put("exitEnvironmentVar", "GRADLE_EXIT_CONSOLE");
        binding.put("mainClassName", "org.gradle.wrapper.GradleWrapperMain");
        binding.put("appNameSystemProperty", "org.gradle.appname");
        binding.put("appHomeRelativePath", "");
        binding.put("modulePath", "");
        String script = source;
        for (Map.Entry variable : binding.entrySet()) {
            script = script.replace("${" + (String)variable.getKey() + "}", (CharSequence)variable.getValue()).replace("$" + (String)variable.getKey(), (CharSequence)variable.getValue());
        }
        script = script.replaceAll("(?sm)<% /\\*.*?\\*/ %>", "");
        script = script.replaceAll("(?sm)<% if \\( mainClassName\\.startsWith\\('--module '\\) \\) \\{.*?} %>", "");
        script = script.replaceAll("(?sm)<% if \\( appNameSystemProperty \\) \\{.*?%>(.*?)<% } %>", "$1");
        script = script.replace("\\$", "$");
        script = script.replaceAll("DIRNAME=\\.\\\\[\r\n]", "DIRNAME=.");
        script = script.replace("\\\\", "\\");
        script = script.replaceAll("\r\n|\r|\n", lineSeparator);
        return script;
    }

    @Generated
    public UpdateGradleWrapper(@Nullable String version, @Nullable String distribution, @Nullable Boolean addIfMissing, @Nullable String wrapperUri) {
        this.version = version;
        this.distribution = distribution;
        this.addIfMissing = addIfMissing;
        this.wrapperUri = wrapperUri;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGradleWrapper)) {
            return false;
        }
        UpdateGradleWrapper other = (UpdateGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        String this$wrapperUri = this.getWrapperUri();
        String other$wrapperUri = other.getWrapperUri();
        return !(this$wrapperUri == null ? other$wrapperUri != null : !this$wrapperUri.equals(other$wrapperUri));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateGradleWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        String $wrapperUri = this.getWrapperUri();
        result = result * 59 + ($wrapperUri == null ? 43 : $wrapperUri.hashCode());
        return result;
    }

    @Nullable
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Nullable
    @Generated
    public String getDistribution() {
        return this.distribution;
    }

    @Nullable
    @Generated
    public Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    @Nullable
    @Generated
    public String getWrapperUri() {
        return this.wrapperUri;
    }

    public static class GradleWrapperState {
        boolean needsWrapperUpdate = false;
        BuildTool updatedMarker;
        boolean addGradleWrapperProperties = true;
        boolean addGradleWrapperJar = true;
        boolean addGradleShellScript = true;
        boolean addGradleBatchScript = true;
    }

    private class WrapperPropertiesVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private static final String DISTRIBUTION_SHA_256_SUM_KEY = "distributionSha256Sum";
        private final GradleWrapper gradleWrapper;

        public WrapperPropertiesVisitor(GradleWrapper gradleWrapper) {
            this.gradleWrapper = gradleWrapper;
        }

        public Properties visitFile(Properties.File file, ExecutionContext ctx) {
            Properties p = super.visitFile(file, (Object)ctx);
            Set checksumKey = FindProperties.find((Properties)p, (String)DISTRIBUTION_SHA_256_SUM_KEY, (Boolean)false);
            if (checksumKey.isEmpty() && this.gradleWrapper.getDistributionChecksum() != null) {
                Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, this.gradleWrapper.getDistributionChecksum().getHexValue());
                Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, DISTRIBUTION_SHA_256_SUM_KEY, "", Properties.Entry.Delimiter.EQUALS, propertyValue);
                List contentList = ListUtils.concat((List)((Properties.File)p).getContent(), (Object)entry);
                p = ((Properties.File)p).withContent(contentList);
            }
            return p;
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
            if ("distributionUrl".equals(entry.getKey())) {
                Properties.Value value = entry.getValue();
                String currentUrl = value.getText();
                if (UpdateGradleWrapper.this.wrapperUri != null) {
                    String effectiveWrapperUri = StringUtils.formatUriForPropertiesFile((String)UpdateGradleWrapper.this.wrapperUri.replace("${version}", this.gradleWrapper.getVersion()).replace("${distribution}", UpdateGradleWrapper.this.distribution == null ? "bin" : UpdateGradleWrapper.this.distribution));
                    return entry.withValue(value.withText(effectiveWrapperUri));
                }
                if (currentUrl.startsWith("https\\://services.gradle.org/distributions/")) {
                    return entry.withValue(value.withText(this.gradleWrapper.getPropertiesFormattedUrl()));
                }
                String gradleServicesDistributionUrl = this.gradleWrapper.getDistributionUrl();
                String newDistributionFile = gradleServicesDistributionUrl.substring(gradleServicesDistributionUrl.lastIndexOf(47) + 1);
                String repositoryUrlPrefix = currentUrl.substring(0, currentUrl.lastIndexOf(47));
                return entry.withValue(value.withText(repositoryUrlPrefix + "/" + newDistributionFile));
            }
            if (DISTRIBUTION_SHA_256_SUM_KEY.equals(entry.getKey()) && this.gradleWrapper.getDistributionChecksum() != null) {
                return entry.withValue(entry.getValue().withText(this.gradleWrapper.getDistributionChecksum().getHexValue()));
            }
            return entry;
        }
    }
}

