/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.table.GradleWrappersInUse;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class FindGradleWrapper
extends Recipe {
    private final transient GradleWrappersInUse wrappersInUse = new GradleWrappersInUse(this);
    private static final Pattern GRADLE_VERSION = Pattern.compile("gradle-(.*?)-(all|bin).zip");
    @Option(displayName="Version expression", description="A version expression representing the versions to search for", example="7.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Distribution type", description="The distribution of Gradle to find. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation.", valid={"bin", "all"}, required=false)
    @Nullable
    private final String distribution;

    public String getDisplayName() {
        return "Find Gradle wrappers";
    }

    public String getDescription() {
        return "Find Gradle wrappers.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            public Properties visitFile(Properties.File file, ExecutionContext ctx) {
                return !PathUtils.equalIgnoringSeparators((Path)file.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION) ? file : super.visitFile(file, (Object)ctx);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (!"distributionUrl".equals(entry.getKey())) {
                    return entry;
                }
                String currentDistributionUrl = entry.getValue().getText();
                Matcher matcher = GRADLE_VERSION.matcher(currentDistributionUrl);
                if (!matcher.find()) return entry;
                String currentVersion = matcher.group(1);
                boolean requireVersion = !StringUtils.isNullOrEmpty((String)FindGradleWrapper.this.version);
                String currentDistribution = matcher.group(2);
                boolean requireMeta = !StringUtils.isNullOrEmpty((String)FindGradleWrapper.this.distribution);
                FindGradleWrapper.this.wrappersInUse.insertRow(ctx, new GradleWrappersInUse.Row(currentVersion, currentDistribution));
                if (requireVersion) {
                    VersionComparator versionComparator = (VersionComparator)Semver.validate((String)FindGradleWrapper.this.version, (String)FindGradleWrapper.this.versionPattern).getValue();
                    if (versionComparator != null && !versionComparator.isValid(null, currentVersion)) return entry;
                    if (!requireMeta) return (Properties)SearchResult.found((Tree)entry);
                    if (!currentDistribution.matches(FindGradleWrapper.this.distribution)) return entry;
                    return (Properties)SearchResult.found((Tree)entry);
                }
                if (!requireMeta) return (Properties)SearchResult.found((Tree)entry);
                if (!currentDistribution.matches(FindGradleWrapper.this.distribution)) return entry;
                return (Properties)SearchResult.found((Tree)entry);
            }
        };
    }

    @Generated
    public FindGradleWrapper(@Nullable String version, @Nullable String versionPattern, @Nullable String distribution) {
        this.version = version;
        this.versionPattern = versionPattern;
        this.distribution = distribution;
    }

    @Generated
    public GradleWrappersInUse getWrappersInUse() {
        return this.wrappersInUse;
    }

    @Nullable
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Nullable
    @Generated
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    @Generated
    public String getDistribution() {
        return this.distribution;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindGradleWrapper(wrappersInUse=" + (Object)((Object)this.getWrappersInUse()) + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", distribution=" + this.getDistribution() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindGradleWrapper)) {
            return false;
        }
        FindGradleWrapper other = (FindGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        return !(this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindGradleWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        return result;
    }
}

