/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.plugins.ChangePlugin;
import org.openrewrite.gradle.plugins.ChangePluginVersion;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.style.Style;

public final class MigrateGradleEnterpriseToDevelocity
extends Recipe {
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="3.x", required=false)
    @Nullable
    private final String version;

    public String getDisplayName() {
        return "Migrate from Gradle Enterprise to Develocity";
    }

    public String getDescription() {
        return "Migrate from the Gradle Enterprise Gradle plugin to the Develocity Gradle plugin.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGs = cu.getMarkers().findFirst(GradleSettings.class);
                if (!maybeGs.isPresent()) {
                    return cu;
                }
                try {
                    String newVersion = new DependencyVersionSelector(null, null, (GradleSettings)maybeGs.get()).select(new GroupArtifact("com.gradle.develocity", "com.gradle.develocity.gradle.plugin"), "classpath", MigrateGradleEnterpriseToDevelocity.this.version, null, ctx);
                    if (newVersion == null) {
                        return cu;
                    }
                }
                catch (MavenDownloadingException e) {
                    return (G.CompilationUnit)e.warn((Tree)cu);
                }
                G.CompilationUnit g = cu;
                g = (G.CompilationUnit)new ChangePlugin("com.gradle.enterprise", "com.gradle.develocity", MigrateGradleEnterpriseToDevelocity.this.version).getVisitor().visitNonNull((Tree)g, (Object)ctx);
                g = (G.CompilationUnit)new ChangePluginVersion("com.gradle.common-custom-user-data-gradle-plugin", "2.x", null).getVisitor().visitNonNull((Tree)g, (Object)ctx);
                g = (G.CompilationUnit)new MigrateConfigurationVisitor().visitNonNull((Tree)g, ctx);
                return g;
            }
        });
    }

    @Generated
    public MigrateGradleEnterpriseToDevelocity(@Nullable String version) {
        this.version = version;
    }

    @Nullable
    @Generated
    public String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MigrateGradleEnterpriseToDevelocity(version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateGradleEnterpriseToDevelocity)) {
            return false;
        }
        MigrateGradleEnterpriseToDevelocity other = (MigrateGradleEnterpriseToDevelocity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MigrateGradleEnterpriseToDevelocity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    private static class MigrateConfigurationVisitor
    extends GroovyIsoVisitor<ExecutionContext> {
        private MigrateConfigurationVisitor() {
        }

        @Nullable
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (m.getSimpleName().equals("gradleEnterprise") && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Lambda) {
                return m.withName(m.getName().withSimpleName("develocity"));
            }
            if (m.getSimpleName().startsWith("publishAlways") && this.withinMethodInvocations(Arrays.asList("gradleEnterprise", "buildScan"))) {
                if (m.getSimpleName().equals("publishAlways") && this.noArguments(m.getArguments())) {
                    return null;
                }
                if (m.getSimpleName().equals("publishAlwaysIf")) {
                    J.MethodInvocation publishingTemplate = this.develocityPublishAlwaysIfDsl(this.getIndent((G.CompilationUnit)this.getCursor().firstEnclosing(G.CompilationUnit.class)), ctx);
                    if (publishingTemplate == null) {
                        return m;
                    }
                    return publishingTemplate.withArguments(ListUtils.mapFirst((List)publishingTemplate.getArguments(), arg -> {
                        if (arg instanceof J.Lambda) {
                            J.Lambda lambda = (J.Lambda)arg;
                            J.Block block = (J.Block)lambda.getBody();
                            return lambda.withBody((J)block.withStatements(ListUtils.mapFirst((List)block.getStatements(), s -> {
                                if (s instanceof J.Return) {
                                    J.Return _return = (J.Return)s;
                                    return _return.withExpression((Expression)m.getArguments().get(0));
                                }
                                return s;
                            })));
                        }
                        return arg;
                    }));
                }
            }
            if (m.getSimpleName().startsWith("publishOnFailure") && this.withinMethodInvocations(Arrays.asList("gradleEnterprise", "buildScan"))) {
                J.MethodInvocation publishingTemplate = this.develocityPublishOnFailureIfDsl(this.getIndent((G.CompilationUnit)this.getCursor().firstEnclosing(G.CompilationUnit.class)), ctx);
                if (publishingTemplate == null) {
                    return m;
                }
                if (m.getSimpleName().equals("publishOnFailure") && this.noArguments(m.getArguments())) {
                    return publishingTemplate;
                }
                if (m.getSimpleName().equals("publishOnFailureIf") && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Binary) {
                    return publishingTemplate.withArguments(ListUtils.mapFirst((List)publishingTemplate.getArguments(), arg -> {
                        if (arg instanceof J.Lambda) {
                            J.Lambda lambda = (J.Lambda)arg;
                            J.Block block = (J.Block)lambda.getBody();
                            return lambda.withBody((J)block.withStatements(ListUtils.mapFirst((List)block.getStatements(), s -> {
                                if (s instanceof J.Return && ((J.Return)s).getExpression() instanceof J.Unary) {
                                    J.Return _return = (J.Return)s;
                                    return _return.withExpression((Expression)new J.Binary(Tree.randomId(), Space.EMPTY, Markers.EMPTY, _return.getExpression(), JLeftPadded.build((Object)J.Binary.Type.And).withBefore(Space.SINGLE_SPACE), (Expression)Space.formatFirstPrefix((List)m.getArguments(), (Space)Space.SINGLE_SPACE).get(0), (JavaType)JavaType.Primitive.Boolean));
                                }
                                return s;
                            })));
                        }
                        return arg;
                    }));
                }
            }
            if (m.getSimpleName().equals("remote") && this.withinMethodInvocations(Arrays.asList("gradleEnterprise", "buildCache"))) {
                return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                    J.FieldAccess field;
                    if (arg instanceof J.FieldAccess && (field = (J.FieldAccess)arg).getSimpleName().equals("buildCache") && field.getTarget() instanceof J.Identifier && ((J.Identifier)field.getTarget()).getSimpleName().equals("gradleEnterprise")) {
                        return field.withTarget((Expression)((J.Identifier)field.getTarget()).withSimpleName("develocity"));
                    }
                    return arg;
                }));
            }
            return m;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
            if (a.getVariable() instanceof J.Identifier && ((J.Identifier)a.getVariable()).getSimpleName().equals("taskInputFiles") && this.withinMethodInvocations(Arrays.asList("gradleEnterprise", "buildScan", "capture"))) {
                return a.withVariable((Expression)((J.Identifier)a.getVariable()).withSimpleName("fileFingerprints"));
            }
            return a;
        }

        private boolean noArguments(List<Expression> arguments) {
            return arguments.isEmpty() || arguments.size() == 1 && arguments.get(0) instanceof J.Empty;
        }

        private boolean withinMethodInvocations(List<String> methods) {
            Cursor current = this.getCursor().getParent();
            for (int i = methods.size() - 1; i >= 0; --i) {
                if ((current = this.findMethodInvocation(current)) == null) {
                    return false;
                }
                if (!((J.MethodInvocation)current.getValue()).getSimpleName().equals(methods.get(i))) {
                    return false;
                }
                current = current.getParent();
            }
            return true;
        }

        @Nullable
        private Cursor findMethodInvocation(@Nullable Cursor start) {
            if (start == null) {
                return null;
            }
            Cursor current = start;
            while (current.getParent() != null) {
                if (current.getValue() instanceof J.MethodInvocation) {
                    return current;
                }
                current = current.getParent();
            }
            return null;
        }

        @Nullable
        private J.MethodInvocation develocityPublishAlwaysIfDsl(String indent, ExecutionContext ctx) {
            StringBuilder ge = new StringBuilder("\ndevelocity {\n");
            ge.append(indent).append("buildScan {\n");
            ge.append(indent).append(indent).append("publishing.onlyIf { true }\n");
            ge.append(indent).append("}\n");
            ge.append("}\n");
            G.CompilationUnit cu = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("settings.gradle", new String[0]), (String)ge.toString())), null, ctx).map(G.CompilationUnit.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
            J.MethodInvocation develocity = (J.MethodInvocation)cu.getStatements().get(0);
            J.MethodInvocation buildScan = (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)develocity.getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
            return (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)buildScan.getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
        }

        @Nullable
        private J.MethodInvocation develocityPublishOnFailureIfDsl(String indent, ExecutionContext ctx) {
            StringBuilder ge = new StringBuilder("\ndevelocity {\n");
            ge.append(indent).append("buildScan {\n");
            ge.append(indent).append(indent).append("publishing.onlyIf { !it.buildResult.failures.empty }\n");
            ge.append(indent).append("}\n");
            ge.append("}\n");
            G.CompilationUnit cu = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)Paths.get("settings.gradle", new String[0]), (String)ge.toString())), null, ctx).map(G.CompilationUnit.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle"));
            J.MethodInvocation develocity = (J.MethodInvocation)cu.getStatements().get(0);
            J.MethodInvocation buildScan = (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)develocity.getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
            return (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)buildScan.getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
        }

        private String getIndent(G.CompilationUnit cu) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class, (Style)IntelliJ.tabsAndIndents());
            if (style.getUseTabCharacter().booleanValue()) {
                return "\t";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < style.getIndentSize(); ++i) {
                sb.append(" ");
            }
            return sb.toString();
        }
    }
}

