/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class RemoveRepository
extends Recipe {
    @Option(displayName="Repository", description="The name of the repository to remove", example="jcenter")
    private final String repository;

    public String getDisplayName() {
        return "Remove repository";
    }

    public String getDescription() {
        return "Removes a repository from Gradle build scripts. Named repositories include \"jcenter\", \"mavenCentral\", \"mavenLocal\", and \"google\".";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher repositories = new MethodMatcher("org.gradle.api.artifacts.dsl.RepositoryHandler " + this.repository + "()");
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (repositories.matches((MethodCall)method)) {
                    return null;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public RemoveRepository(String repository) {
        this.repository = repository;
    }

    @Generated
    public String getRepository() {
        return this.repository;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRepository(repository=" + this.getRepository() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRepository)) {
            return false;
        }
        RemoveRepository other = (RemoveRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }
}

