/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.util.ChangeStringLiteral;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.semver.Semver;

public final class ChangePlugin
extends Recipe {
    @Option(displayName="Plugin ID", description="The current Gradle plugin id.", example="org.openrewrite.rewrite")
    private final String pluginId;
    @Option(displayName="New plugin ID", description="The new Gradle plugin id.", example="org.openrewrite.rewrite")
    private final String newPluginId;
    @Option(displayName="New plugin version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="7.x", required=false)
    private final @Nullable String newVersion;

    public String getDisplayName() {
        return "Change a Gradle plugin";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.pluginId, this.newPluginId);
    }

    public String getDescription() {
        return "Changes the selected Gradle plugin to the new plugin.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)");
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)");
        final MethodMatcher applyMatcher = new MethodMatcher("RewriteGradleProject apply(..)");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            @Nullable GradleProject gradleProject;
            @Nullable GradleSettings gradleSettings;

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                Optional maybeGs = cu.getMarkers().findFirst(GradleSettings.class);
                if (!maybeGp.isPresent() && !maybeGs.isPresent()) {
                    return cu;
                }
                this.gradleProject = maybeGp.orElse(null);
                this.gradleSettings = maybeGs.orElse(null);
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                if (g != cu) {
                    if (this.gradleProject != null) {
                        GradleProject updatedGp = this.gradleProject.withPlugins(ListUtils.map(this.gradleProject.getPlugins(), plugin -> {
                            if (ChangePlugin.this.pluginId.equals(plugin.getId())) {
                                return new GradlePluginDescriptor("unknown", ChangePlugin.this.newPluginId);
                            }
                            return plugin;
                        }));
                        g = g.withMarkers(g.getMarkers().setByType((Marker)updatedGp));
                    } else if (this.gradleSettings != null) {
                        GradleSettings updatedGs = this.gradleSettings.withPlugins(ListUtils.map(this.gradleSettings.getPlugins(), plugin -> {
                            if (ChangePlugin.this.pluginId.equals(plugin.getId())) {
                                return new GradlePluginDescriptor("unknown", ChangePlugin.this.newPluginId);
                            }
                            return plugin;
                        }));
                        g = g.withMarkers(g.getMarkers().setByType((Marker)updatedGs));
                    }
                }
                return g;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (versionMatcher.matches((MethodCall)m) && m.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(m.getSelect())) {
                    m = this.maybeUpdateVersion(m, ctx);
                } else if (pluginMatcher.matches((MethodCall)m)) {
                    m = this.maybeUpdatePluginSyntax(m);
                } else if (applyMatcher.matches((MethodCall)m)) {
                    m = this.maybeUpdateApplySyntax(m);
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }

            private J.MethodInvocation maybeUpdateVersion(J.MethodInvocation m, ExecutionContext ctx) {
                J.MethodInvocation select = (J.MethodInvocation)m.getSelect();
                if (select == null || !ChangePlugin.this.pluginId.equals(((J.Literal)select.getArguments().get(0)).getValue())) {
                    return m;
                }
                List args = m.getArguments();
                if (!(args.get(0) instanceof J.Literal)) {
                    return m;
                }
                J.Literal versionLiteral = (J.Literal)args.get(0);
                if (versionLiteral.getType() != JavaType.Primitive.String) {
                    return m;
                }
                if (!StringUtils.isBlank((String)ChangePlugin.this.newVersion)) {
                    try {
                        String resolvedVersion = new DependencyVersionSelector(null, this.gradleProject, this.gradleSettings).select(new GroupArtifact(ChangePlugin.this.newPluginId, ChangePlugin.this.newPluginId + ".gradle.plugin"), "classpath", ChangePlugin.this.newVersion, null, ctx);
                        if (resolvedVersion == null) {
                            return m;
                        }
                        m = m.withSelect((Expression)select.withArguments(ListUtils.mapFirst((List)select.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, ChangePlugin.this.newPluginId)))).withArguments(Collections.singletonList(ChangeStringLiteral.withStringValue(versionLiteral, resolvedVersion)));
                    }
                    catch (MavenDownloadingException e) {
                        return (J.MethodInvocation)e.warn((Tree)m);
                    }
                }
                return m;
            }

            private J.MethodInvocation maybeUpdatePluginSyntax(J.MethodInvocation m) {
                List args = m.getArguments();
                if (!(args.get(0) instanceof J.Literal)) {
                    return m;
                }
                J.Literal pluginIdLiteral = (J.Literal)args.get(0);
                if (pluginIdLiteral.getType() != JavaType.Primitive.String) {
                    return m;
                }
                String pluginIdValue = (String)pluginIdLiteral.getValue();
                if (!ChangePlugin.this.pluginId.equals(pluginIdValue)) {
                    return m;
                }
                return m.withArguments(ListUtils.concat((Object)ChangeStringLiteral.withStringValue(pluginIdLiteral, ChangePlugin.this.newPluginId), args.subList(1, args.size())));
            }

            private J.MethodInvocation maybeUpdateApplySyntax(J.MethodInvocation m) {
                List args = m.getArguments();
                if (!(args.get(0) instanceof G.MapEntry)) {
                    return m;
                }
                G.MapEntry entry = (G.MapEntry)args.get(0);
                if (!(entry.getKey() instanceof J.Literal) || !(entry.getValue() instanceof J.Literal)) {
                    return m;
                }
                J.Literal keyLiteral = (J.Literal)entry.getKey();
                if (keyLiteral.getType() != JavaType.Primitive.String) {
                    return m;
                }
                String keyValue = (String)keyLiteral.getValue();
                if (!"plugin".equals(keyValue)) {
                    return m;
                }
                J.Literal valueLiteral = (J.Literal)entry.getValue();
                if (valueLiteral.getType() != JavaType.Primitive.String) {
                    return m;
                }
                String valueValue = (String)valueLiteral.getValue();
                if (!ChangePlugin.this.pluginId.equals(valueValue)) {
                    return m;
                }
                entry = entry.withValue((Expression)ChangeStringLiteral.withStringValue(valueLiteral, ChangePlugin.this.newPluginId));
                return m.withArguments(ListUtils.concat((Object)entry, args.subList(1, args.size())));
            }
        });
    }

    @Generated
    public ChangePlugin(String pluginId, String newPluginId, @Nullable String newVersion) {
        this.pluginId = pluginId;
        this.newPluginId = newPluginId;
        this.newVersion = newVersion;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public String getNewPluginId() {
        return this.newPluginId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePlugin(pluginId=" + this.getPluginId() + ", newPluginId=" + this.getNewPluginId() + ", newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePlugin)) {
            return false;
        }
        ChangePlugin other = (ChangePlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$newPluginId = this.getNewPluginId();
        String other$newPluginId = other.getNewPluginId();
        if (this$newPluginId == null ? other$newPluginId != null : !this$newPluginId.equals(other$newPluginId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $newPluginId = this.getNewPluginId();
        result = result * 59 + ($newPluginId == null ? 43 : $newPluginId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

