/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.tree.GradlePlugin;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindPlugins
extends Recipe {
    @Option(displayName="Plugin id", description="The unique identifier used to apply a plugin in the `plugins` block. Note that this alone is insufficient to search for plugins applied by fully qualified class name and the `buildscript` block.", example="`com.jfrog.bintray`")
    private final @Nullable String pluginId;
    @Option(displayName="Plugin class", description="The fully qualified name of a class implementing a Gradle plugin. ", required=false, example="com.jfrog.bintray.gradle.BintrayPlugin")
    private final @Nullable String pluginClass;

    public Validated<Object> validate(ExecutionContext ctx) {
        return Validated.none().and((Validated)new Validated.Either(Validated.notBlank((String)"pluginId", (String)this.pluginId), Validated.notBlank((String)"pluginClass", (String)this.pluginClass)));
    }

    public String getDisplayName() {
        return "Find Gradle plugin";
    }

    public String getDescription() {
        return "Find a Gradle plugin by id and/or class name. For best results both should be specified, as one cannot automatically be used to infer the other.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                final AtomicBoolean found = new AtomicBoolean(false);
                TreeVisitor jv = Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                        if (pluginMatcher.matches((MethodCall)method) && method.getArguments().get(0) instanceof J.Literal && FindPlugins.this.pluginId.equals(((J.Literal)method.getArguments().get(0)).getValue())) {
                            found.set(true);
                            return (J)SearchResult.found((Tree)method);
                        }
                        return super.visitMethodInvocation(method, (Object)ctx);
                    }
                });
                if (jv.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)jv.visitNonNull((Tree)s, (Object)ctx);
                }
                GradleProject gp = s.getMarkers().findFirst(GradleProject.class).orElse(null);
                if (!found.get() && gp != null && gp.getPlugins().stream().anyMatch(plugin -> StringUtils.matchesGlob((String)plugin.getId(), (String)FindPlugins.this.pluginId) || StringUtils.matchesGlob((String)plugin.getFullyQualifiedClassName(), (String)FindPlugins.this.pluginClass))) {
                    s = (SourceFile)SearchResult.found((Tree)s);
                }
                return s;
            }
        };
    }

    public static List<GradlePlugin> find(J j, String pluginIdPattern) {
        List plugins = (List)TreeVisitor.collect(new FindPlugins(pluginIdPattern, null).getVisitor(), (Tree)j, new ArrayList(), J.MethodInvocation.class, Function.identity());
        MethodMatcher idMatcher = new MethodMatcher("PluginSpec id(..)", false);
        MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        List pluginsWithVersion = plugins.stream().flatMap(plugin -> {
            if (versionMatcher.matches((MethodCall)plugin) && idMatcher.matches(plugin.getSelect()) && plugin.getArguments().get(0) instanceof J.Literal) {
                return Stream.of(new GradlePlugin((J.MethodInvocation)plugin, Objects.requireNonNull(((J.Literal)Objects.requireNonNull((J.MethodInvocation)plugin.getSelect()).getArguments().get(0)).getValue()).toString(), Objects.requireNonNull(((J.Literal)plugin.getArguments().get(0)).getValue()).toString()));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        List pluginsWithoutVersion = plugins.stream().flatMap(plugin -> {
            if (idMatcher.matches((MethodCall)plugin) && pluginsWithVersion.stream().noneMatch(it -> it.getPluginId().equals(plugin.getSimpleName()))) {
                return Stream.of(new GradlePlugin((J.MethodInvocation)plugin, Objects.requireNonNull(((J.Literal)Objects.requireNonNull(plugin).getArguments().get(0)).getValue()).toString(), null));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        ArrayList<GradlePlugin> result = new ArrayList<GradlePlugin>(pluginsWithVersion.size() + pluginsWithoutVersion.size());
        result.addAll(pluginsWithVersion);
        result.addAll(pluginsWithoutVersion);
        return result;
    }

    @Generated
    public FindPlugins(@Nullable String pluginId, @Nullable String pluginClass) {
        this.pluginId = pluginId;
        this.pluginClass = pluginClass;
    }

    @Generated
    public @Nullable String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public @Nullable String getPluginClass() {
        return this.pluginClass;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindPlugins(pluginId=" + this.getPluginId() + ", pluginClass=" + this.getPluginClass() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindPlugins)) {
            return false;
        }
        FindPlugins other = (FindPlugins)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$pluginClass = this.getPluginClass();
        String other$pluginClass = other.getPluginClass();
        return !(this$pluginClass == null ? other$pluginClass != null : !this$pluginClass.equals(other$pluginClass));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindPlugins;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $pluginClass = this.getPluginClass();
        result = result * 59 + ($pluginClass == null ? 43 : $pluginClass.hashCode());
        return result;
    }
}

